/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.concurrent.TimeUnit;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeUtils {
    public static final LocalDate JAN_1ST_1883 = LocalDate.of(1882, 12, 31);
    private static final DateTimeFormatter WIX_DATE = DateTimeFormat.forPattern("yyyy/MM/dd");
    private static final DateTimeFormatter EXPECTED = DateTimeFormat.forPattern("yyyyMMdd");
    public static final long ONE_DAY_IN_MS = 2592000000L;

    public static String getDate() {
        return java.time.format.DateTimeFormatter.ofPattern("yyyyMMdd").format(LocalDateTime.now());
    }

    public static int dayDiff(String first, String second) {
        int diff;
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        try {
            diff = (int)TimeUnit.DAYS.convert(f.parse(first).getTime() - f.parse(second).getTime(), TimeUnit.MILLISECONDS);
        }
        catch (ParseException e) {
            return 1;
        }
        if (first.equalsIgnoreCase(second)) {
            return 0;
        }
        return Math.abs(diff);
    }

    public static String subtractDaysFromDate(String date, int dur) {
        return LocalDate.parse(date, java.time.format.DateTimeFormatter.ofPattern("yyyyMMdd")).minusDays(dur).format(java.time.format.DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public static String addDaysToDate(String date, int dur) {
        return LocalDate.parse(date, java.time.format.DateTimeFormatter.ofPattern("yyyyMMdd")).plusDays(dur).format(java.time.format.DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public static boolean isWeekday(int dateInteger) {
        String dateString = String.valueOf(dateInteger);
        if (dateString.length() != 8) {
            throw new IllegalArgumentException("dateInteger must be in yyyyMMdd format (8 digits)");
        }
        try {
            LocalDate date = LocalDate.parse(dateString, java.time.format.DateTimeFormatter.ofPattern("yyyyMMdd"));
            DayOfWeek dayOfWeek = date.getDayOfWeek();
            return dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY;
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid date format. Expected yyyyMMdd", e);
        }
    }
}

