/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.config;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import net.thetadata.utils.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BuildInfo {
    private static final Logger logger = LogManager.getLogger(BuildInfo.class);
    private final Properties properties = new Properties();

    public BuildInfo() {
        try (InputStream in = Utils.class.getClassLoader().getResourceAsStream("git.properties");){
            this.properties.load(in);
        }
        catch (Exception e) {
            logger.error("ERROR GETTING BUILD INFORMATION", (Throwable)e);
        }
    }

    public String dateCommitVersion() {
        String buildDateTime = this.buildTime();
        String buildDate = buildDateTime.split("T")[0].replace("-", "");
        return buildDate + ":" + this.abbreviatedCommitId();
    }

    public String abbreviatedCommitId() {
        return this.getProperty("git.commit.id.abbrev");
    }

    public String fullCommitId() {
        return this.getProperty("git.commit.id.full");
    }

    public String buildName() {
        return this.getProperty("git.build.user.name");
    }

    public String buildEmail() {
        return this.getProperty("git.build.user.email");
    }

    public String buildTime() {
        return this.getProperty("git.build.time");
    }

    public String branch() {
        return this.getProperty("git.branch");
    }

    public boolean isDirty() {
        return Boolean.parseBoolean(this.getProperty("git.dirty"));
    }

    public String getProperty(String key) {
        Preconditions.checkArgument(key.startsWith("git."), "Key must start with 'git.'");
        return Objects.requireNonNull(this.properties.getProperty(key), "Cannot find property '" + key + "' in git.properties");
    }
}

