/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.math;

import org.apache.commons.math3.distribution.NormalDistribution;

public class Greeks {
    private static final NormalDistribution DIST = new NormalDistribution();
    private static final double ONE_ROOT2PI = 1.0 / Math.sqrt(Math.PI * 2);
    private static final double MAX_TRIES = 128.0;

    public static double d1(double s2, double x, double v, double r, double q, double t2) {
        return (Math.log(s2 / x) + t2 * (r - q + Math.pow(v, 2.0) / 2.0)) / (v * Math.sqrt(t2));
    }

    public static double d2(double s2, double x, double v, double r, double q, double t2) {
        return Greeks.d1(s2, x, v, r, q, t2) - v * Math.sqrt(t2);
    }

    private static double e1(double s2, double x, double v, double r, double q, double t2) {
        return Math.pow(Math.E, -Math.pow(Greeks.d1(s2, x, v, r, q, t2), 2.0) / 2.0);
    }

    private static double f1(double x) {
        return ONE_ROOT2PI * Math.pow(Math.E, -0.5 * Math.pow(x, 2.0));
    }

    private static double realize(double x) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            return 0.0;
        }
        return x;
    }

    private static double ivGuess(double s2, double t2, double c) {
        return 2.0 * Math.sqrt(Math.PI / t2) * c / s2;
    }

    public static double iv(double s2, double x, double r, double q, double t2, double o, boolean isCall) {
        double guess = Greeks.ivGuess(s2, t2, o);
        double diff = Greeks.value(s2, x, guess, r, q, t2, isCall) - o;
        boolean isPos = diff > 0.0;
        double changer = 0.2;
        int tries = 0;
        if (isPos) {
            while (diff > 0.001) {
                int n = tries++;
                if ((double)n > 128.0) {
                    return Math.max(0.0, Greeks.ivITM(s2, x, r, q, t2, o, isCall));
                }
                diff = Greeks.value(s2, x, guess, r, q, t2, isCall) - o;
                if (diff < 0.001 && diff > 0.0) {
                    return guess;
                }
                while (diff < 0.0) {
                    guess += changer;
                    diff = Greeks.value(s2, x, guess -= (changer /= 2.0), r, q, t2, isCall) - o;
                }
                guess -= changer;
            }
            if (diff < 0.001 && diff > 0.0) {
                return guess;
            }
        } else {
            while (diff < -0.001) {
                int n = tries++;
                if ((double)n > 128.0) {
                    return Math.max(0.0, Greeks.ivITM(s2, x, r, q, t2, o, isCall));
                }
                diff = Greeks.value(s2, x, guess, r, q, t2, isCall) - o;
                if (diff > -0.001 && diff < 0.0) {
                    return guess;
                }
                while (diff > 0.0) {
                    guess -= changer;
                    diff = Greeks.value(s2, x, guess += (changer /= 2.0), r, q, t2, isCall) - o;
                }
                guess += changer;
            }
            if (diff > -0.001 && diff < 0.0) {
                return guess;
            }
        }
        return Math.max(0.0, Greeks.ivITM(s2, x, r, q, t2, o, isCall));
    }

    private static double ivITM(double s2, double x, double r, double q, double t2, double o, boolean isCall) {
        double guess = Greeks.ivGuess(s2, t2, o);
        double diff = Greeks.value(s2, x, guess, r, q, t2, isCall) - o;
        boolean isPos = diff > 0.0;
        double changer = 0.2;
        double prevValue = Double.MAX_VALUE;
        if (isPos) {
            while (diff > 0.001) {
                double value = Greeks.value(s2, x, guess, r, q, t2, isCall);
                if (Math.abs(value - prevValue) < 0.01) {
                    return guess;
                }
                prevValue = value;
                diff = value - o;
                while (diff < 0.0) {
                    guess += changer;
                    value = Greeks.value(s2, x, guess -= (changer /= 2.0), r, q, t2, isCall);
                    if (Math.abs(value - prevValue) < 0.01) {
                        return guess;
                    }
                    prevValue = value;
                    diff = value - o;
                }
                guess -= changer;
            }
        } else {
            while (diff < -0.001) {
                double value = Greeks.value(s2, x, guess, r, q, t2, isCall);
                if (Math.abs(value - prevValue) < 0.01) {
                    return guess;
                }
                prevValue = value;
                diff = value - o;
                while (diff > 0.0) {
                    guess -= changer;
                    value = Greeks.value(s2, x, guess += (changer /= 2.0), r, q, t2, isCall);
                    if (Math.abs(value - prevValue) < 0.01) {
                        return guess;
                    }
                    prevValue = value;
                    diff = value - o;
                }
                guess += changer;
            }
        }
        return guess;
    }

    public static double value(double s2, double x, double v, double r, double q, double t2, boolean isCall) {
        if (isCall) {
            return s2 * Math.pow(Math.E, -q * t2) * DIST.cumulativeProbability(Greeks.d1(s2, x, v, r, q, t2)) - Math.pow(Math.E, -r * t2) * x * DIST.cumulativeProbability(Greeks.d2(s2, x, v, r, q, t2));
        }
        return Math.pow(Math.E, -r * t2) * x * DIST.cumulativeProbability(-Greeks.d2(s2, x, v, r, q, t2)) - s2 * Math.pow(Math.E, -q * t2) * DIST.cumulativeProbability(-Greeks.d1(s2, x, v, r, q, t2));
    }

    public static double delta(double s2, double x, double v, double r, double q, double t2, boolean isCall) {
        if (isCall) {
            return Math.pow(Math.E, -q * t2) * DIST.cumulativeProbability(Greeks.d1(s2, x, v, r, q, t2));
        }
        return Math.pow(Math.E, -q * t2) * (DIST.cumulativeProbability(Greeks.d1(s2, x, v, r, q, t2)) - 1.0);
    }

    public static double theta(double s2, double x, double v, double r, double q, double t2, boolean isCall) {
        double d1 = Greeks.d1(s2, x, v, r, q, t2);
        if (isCall) {
            return (-Math.pow(Math.E, -q * t2) * (s2 * Greeks.f1(d1) * v) / (2.0 * Math.sqrt(t2)) - r * x * Math.pow(Math.E, -r * t2) * DIST.cumulativeProbability(Greeks.d2(s2, x, v, r, q, t2)) + q * s2 * Math.pow(Math.E, -q * t2) * DIST.cumulativeProbability(d1)) / 365.0;
        }
        return (-Math.pow(Math.E, -q * t2) * (s2 * Greeks.f1(d1) * v) / (2.0 * Math.sqrt(t2)) + r * x * Math.pow(Math.E, -r * t2) * DIST.cumulativeProbability(-Greeks.d2(s2, x, v, r, q, t2)) - q * s2 * Math.pow(Math.E, -q * t2) * DIST.cumulativeProbability(-d1)) / 365.0;
    }

    public static double vega(double s2, double x, double v, double r, double q, double t2) {
        return s2 * Math.pow(Math.E, -q * t2) * Math.sqrt(t2) * ONE_ROOT2PI * Greeks.e1(s2, x, v, r, q, t2);
    }

    public static double rho(double s2, double x, double v, double r, double q, double t2, boolean isCall) {
        if (isCall) {
            return x * t2 * Math.pow(Math.E, -r * t2) * DIST.cumulativeProbability(Greeks.d2(s2, x, v, r, q, t2));
        }
        return -x * t2 * Math.pow(Math.E, -r * t2) * DIST.cumulativeProbability(-Greeks.d2(s2, x, v, r, q, t2));
    }

    public static double epsilon(double s2, double x, double v, double r, double q, double t2, boolean isCall) {
        if (isCall) {
            return Greeks.realize(-s2 * t2 * Math.pow(Math.E, -q * t2) * DIST.cumulativeProbability(Greeks.d1(s2, x, v, r, q, t2)));
        }
        return Greeks.realize(s2 * t2 * Math.pow(Math.E, -q * t2) * DIST.cumulativeProbability(-Greeks.d1(s2, x, v, r, q, t2)));
    }

    public static double lambda(double s2, double x, double v, double r, double q, double t2, boolean isCall) {
        return Greeks.realize(Greeks.delta(s2, x, v, r, q, t2, isCall) * s2 / Greeks.value(s2, x, v, r, q, t2, isCall));
    }

    public static double vera(double s2, double x, double v, double r, double q, double t2, boolean isCall) {
        try {
            return Math.pow(-x * t2 * Math.E, -r * t2) * Greeks.f1(Greeks.d2(s2, x, v, r, q, t2) * (Greeks.d1(s2, x, v, r, q, t2) / v));
        }
        catch (Exception ignore) {
            return 0.0;
        }
    }

    public static double gamma(double s2, double x, double v, double r, double q, double t2) {
        return Math.pow(Math.E, -q * t2) / (s2 * v * Math.sqrt(t2)) * ONE_ROOT2PI * Greeks.e1(s2, x, v, r, q, t2);
    }

    public static double vanna(double s2, double x, double v, double r, double q, double t2) {
        return -Math.pow(Math.E, -q * t2) * Greeks.f1(Greeks.d1(s2, x, v, r, q, t2)) * Greeks.d2(s2, x, v, r, q, t2) / v;
    }

    public static double charm(double s2, double x, double v, double r, double q, double t2, boolean isCall) {
        double d1 = Greeks.d1(s2, x, v, r, q, t2);
        double p1 = (2.0 * (r - q) * t2 - Greeks.d2(s2, x, v, r, q, t2) * v * Math.sqrt(t2)) / (2.0 * t2 * v * Math.sqrt(t2));
        if (isCall) {
            return q * Math.pow(Math.E, -q * t2) * DIST.cumulativeProbability(d1) - Math.pow(Math.E, -q * t2) * Greeks.f1(d1) * p1;
        }
        return -q * Math.pow(Math.E, -q * t2) * DIST.cumulativeProbability(-d1) - Math.pow(Math.E, -q * t2) * Greeks.f1(d1) * p1;
    }

    public static double vomma(double s2, double x, double v, double r, double q, double t2) {
        return Greeks.vega(s2, x, v, r, q, t2) * (Greeks.d1(s2, x, v, r, q, t2) * Greeks.d2(s2, x, v, r, q, t2) / v);
    }

    public static double veta(double s2, double x, double v, double r, double q, double t2) {
        double d1 = Greeks.d1(s2, x, v, r, q, t2);
        double d2 = Greeks.d2(s2, x, v, r, q, t2);
        return -s2 * Math.pow(Math.E, -q * t2) * Greeks.f1(d1) * Math.sqrt(t2) * (q + (r - q) * d1 / v * Math.sqrt(t2) - (1.0 + d1 * d2) / 2.0 * t2);
    }

    public static double speed(double s2, double x, double v, double r, double q, double t2) {
        double d1 = Greeks.d1(s2, x, v, r, q, t2);
        return -Math.pow(Math.E, -q * t2) * Greeks.f1(d1) / Math.pow(s2, 2.0) * v * Math.sqrt(t2) * (d1 / v * Math.sqrt(t2) + 1.0);
    }

    public static double zomma(double s2, double x, double v, double r, double q, double t2) {
        double d1 = Greeks.d1(s2, x, v, r, q, t2);
        return Math.pow(Math.E, -q * t2) * Greeks.f1(d1) * (d1 * Greeks.d2(s2, x, v, r, q, t2) - 1.0) / s2 * v * v * Math.sqrt(t2);
    }

    public static double color(double s2, double x, double v, double r, double q, double t2) {
        double d1 = Greeks.d1(s2, x, v, r, q, t2);
        return -Math.pow(Math.E, -q * t2) * Greeks.f1(d1) / 2.0 * s2 * t2 * v * Math.sqrt(t2) * (2.0 * q * t2 + 1.0 + 2.0 * (r - q) * t2 - Greeks.d2(s2, x, v, r, q, t2) * v * Math.sqrt(t2) / v * Math.sqrt(t2) * d1);
    }

    public static double ultima(double s2, double x, double v, double r, double q, double t2) {
        double d1 = Greeks.d1(s2, x, v, r, q, t2);
        double d2 = Greeks.d2(s2, x, v, r, q, t2);
        double out = -Greeks.vega(s2, x, v, r, q, t2) / Math.pow(v, 2.0) * (d1 * d2 * (1.0 - d1 * d2) + d1 * d1 + d2 * d2);
        if (out < 0.0) {
            return Math.max(out, -100.0);
        }
        if (out > 0.0) {
            return Math.min(out, 100.0);
        }
        return out;
    }

    public static double dualDelta(double s2, double x, double v, double r, double q, double t2, boolean isCall) {
        if (isCall) {
            return -Math.pow(Math.E, -r * t2) * DIST.cumulativeProbability(Greeks.d2(s2, x, v, r, q, t2));
        }
        return Math.pow(Math.E, -r * t2) * DIST.cumulativeProbability(-Greeks.d2(s2, x, v, r, q, t2));
    }

    public static double dualGamma(double s2, double x, double v, double r, double q, double t2) {
        return Math.pow(Math.E, -r * t2) * Greeks.f1(Greeks.d2(s2, x, v, r, q, t2)) / x * v * Math.sqrt(t2);
    }

    public static double findZeroError(double s2, double x, double r, double q, double t2, double o, boolean isCall) {
        double out = (Greeks.value(s2, x, 0.0, r, q, t2, isCall) - o) / o;
        if (out < 0.0) {
            out = Math.max(out, -100.0);
        } else if (out > 0.0) {
            out = Math.min(out, 100.0);
        }
        return out;
    }

    public static void iv2(double s2, double x, double r, double q, double t2, double o, boolean isCall, double[] out) {
        if (Greeks.value(s2, x, 0.0, r, q, t2, isCall) > o) {
            out[0] = 0.0;
            out[1] = (Greeks.value(s2, x, 0.0, r, q, t2, isCall) - o) / o;
            if (out[1] < 0.0) {
                out[1] = Math.max(out[1], -100.0);
            } else if (out[1] > 0.0) {
                out[1] = Math.min(out[1], 100.0);
            }
            return;
        }
        double guess = 0.5;
        double start = 0.0;
        double end = guess;
        double changer = 0.2;
        for (int i = 0; i < 32 && !(Greeks.value(s2, x, end += changer, r, q, t2, isCall) > o); ++i) {
            changer *= 2.0;
        }
        int count = 0;
        while (true) {
            double value = Greeks.value(s2, x, guess, r, q, t2, isCall);
            int n = count++;
            if ((double)n > 128.0) {
                out[0] = guess;
                out[1] = (value - o) / o;
                if (out[1] < 0.0) {
                    out[1] = Math.max(out[1], -100.0);
                } else if (out[1] > 0.0) {
                    out[1] = Math.min(out[1], 100.0);
                }
                return;
            }
            if (Math.abs(value - o) < 0.001) {
                out[0] = guess;
                out[1] = (value - o) / o;
                if (out[1] < 0.0) {
                    out[1] = Math.max(out[1], -100.0);
                } else if (out[1] > 0.0) {
                    out[1] = Math.min(out[1], 100.0);
                }
                return;
            }
            if (value > o) {
                end = guess;
                guess -= (end - start) / 2.0;
                continue;
            }
            start = guess;
            guess += (end - start) / 2.0;
        }
    }

    public static void iv2Fast(double s2, double x, double r, double q, double t2, double o, boolean isCall, double[] out) {
        if (Greeks.value(s2, x, 0.0, r, q, t2, isCall) > o) {
            out[0] = 0.0;
            out[1] = (Greeks.value(s2, x, 0.0, r, q, t2, isCall) - o) / o;
            if (out[1] < 0.0) {
                out[1] = Math.max(out[1], -100.0);
            } else if (out[1] > 0.0) {
                out[1] = Math.min(out[1], 100.0);
            }
            return;
        }
        double guess = 0.5;
        double start = 0.0;
        double end = guess;
        double changer = 0.2;
        for (int i = 0; i < 32 && !(Greeks.value(s2, x, end += changer, r, q, t2, isCall) > o); ++i) {
            changer *= 2.0;
        }
        int count = 0;
        while (true) {
            double value = Greeks.value(s2, x, guess, r, q, t2, isCall);
            if (count++ > 16) {
                out[0] = guess;
                out[1] = (value - o) / o;
                if (out[1] < 0.0) {
                    out[1] = Math.max(out[1], -100.0);
                } else if (out[1] > 0.0) {
                    out[1] = Math.min(out[1], 100.0);
                }
                return;
            }
            if (Math.abs(value - o) < 0.1) {
                out[0] = guess;
                out[1] = (value - o) / o;
                if (out[1] < 0.0) {
                    out[1] = Math.max(out[1], -100.0);
                } else if (out[1] > 0.0) {
                    out[1] = Math.min(out[1], 100.0);
                }
                return;
            }
            if (value > o) {
                end = guess;
                guess -= (end - start) / 2.0;
                continue;
            }
            start = guess;
            guess += (end - start) / 2.0;
        }
    }
}

