/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.types.tick;

import java.time.ZoneId;
import net.thetadata.generated.Price;
import net.thetadata.generated.TimeZone;
import net.thetadata.generated.ZonedDateTime;
import net.thetadata.types.tick.Tick;
import net.thetadata.utils.TimeUtils;

public class EodTick {
    private final int[] data;

    public EodTick(Tick t2) {
        this.data = t2.data();
        if (this.data.length != 18) {
            throw new IllegalArgumentException("Wrong number of data fields, expecting 18, got " + this.data.length);
        }
    }

    public int msOfDay() {
        return this.data[0];
    }

    public int msOfDay2() {
        return this.data[1];
    }

    public int open() {
        return this.data[2];
    }

    public Price openPrice() {
        return Price.newBuilder().setValue(this.open()).setType(this.priceType()).build();
    }

    public int high() {
        return this.data[3];
    }

    public Price highPrice() {
        return Price.newBuilder().setValue(this.high()).setType(this.priceType()).build();
    }

    public int low() {
        return this.data[4];
    }

    public Price lowPrice() {
        return Price.newBuilder().setValue(this.low()).setType(this.priceType()).build();
    }

    public int close() {
        return this.data[5];
    }

    public Price closePrice() {
        return Price.newBuilder().setValue(this.close()).setType(this.priceType()).build();
    }

    public int volume() {
        return this.data[6];
    }

    public int count() {
        return this.data[7];
    }

    public int bidSize() {
        return this.data[8];
    }

    public int bidExchange() {
        return this.data[9];
    }

    public int bid() {
        return this.data[10];
    }

    public Price bidPrice() {
        return Price.newBuilder().setValue(this.bid()).setType(this.priceType()).build();
    }

    public int bidCondition() {
        return this.data[11];
    }

    public int askSize() {
        return this.data[12];
    }

    public int askExchange() {
        return this.data[13];
    }

    public int ask() {
        return this.data[14];
    }

    public Price askPrice() {
        return Price.newBuilder().setValue(this.ask()).setType(this.priceType()).build();
    }

    public int askCondition() {
        return this.data[15];
    }

    public int priceType() {
        return this.data[16];
    }

    public int date() {
        return this.data[17];
    }

    public int midPointValue() {
        return this.bid() / 2 + this.ask() / 2 + (this.bid() % 2 + this.ask() % 2) / 2;
    }

    public Price midPoint() {
        return Price.newBuilder().setValue(this.midPointValue()).setType(this.priceType()).build();
    }

    public ZonedDateTime getCreatedDateTimeMessage() {
        java.time.ZonedDateTime timestamp = TimeUtils.getZonedDateTime(this.date(), this.msOfDay(), ZoneId.of("America/New_York"));
        return ZonedDateTime.newBuilder().setEpochMs(timestamp.toInstant().toEpochMilli()).setZone(TimeZone.NEW_YORK).build();
    }

    public ZonedDateTime getLastTradeDateTimeMessage() {
        java.time.ZonedDateTime timestamp = TimeUtils.getZonedDateTime(this.date(), this.msOfDay2(), ZoneId.of("America/New_York"));
        return ZonedDateTime.newBuilder().setEpochMs(timestamp.toInstant().toEpochMilli()).setZone(TimeZone.NEW_YORK).build();
    }
}

