/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.types.tick;

import java.time.ZoneId;
import net.thetadata.generated.Price;
import net.thetadata.generated.TimeZone;
import net.thetadata.generated.ZonedDateTime;
import net.thetadata.types.tick.Tick;
import net.thetadata.utils.TimeUtils;

public class QuoteTick
extends Tick {
    public QuoteTick(Tick t2) {
        super(t2.data());
        if (this.data.length != 11) {
            throw new IllegalArgumentException("Wrong number of data fields, expecting 11, got " + this.data.length);
        }
    }

    public int msOfDay() {
        return this.data[0];
    }

    public int bidSize() {
        return this.data[1];
    }

    public int bidExg() {
        return this.data[2];
    }

    public int bid() {
        return this.data[3];
    }

    public Price bidPrice() {
        return Price.newBuilder().setValue(this.bid()).setType(this.priceType()).build();
    }

    public int bidCondition() {
        return this.data[4];
    }

    public int askSize() {
        return this.data[5];
    }

    public int askExg() {
        return this.data[6];
    }

    public int ask() {
        return this.data[7];
    }

    public Price askPrice() {
        return Price.newBuilder().setValue(this.ask()).setType(this.priceType()).build();
    }

    public int askCondition() {
        return this.data[8];
    }

    public int priceType() {
        return this.data[9];
    }

    public int date() {
        return this.data[10];
    }

    public int[] getDataArray() {
        return this.data;
    }

    public int midPointValue() {
        return this.bid() / 2 + this.ask() / 2 + (this.bid() % 2 + this.ask() % 2) / 2;
    }

    public Price midPoint() {
        return Price.newBuilder().setValue(this.midPointValue()).setType(this.priceType()).build();
    }

    @Override
    public QuoteTick clone() {
        return new QuoteTick(super.clone());
    }

    public ZonedDateTime getDateTimeMessage() {
        java.time.ZonedDateTime timestamp = TimeUtils.getZonedDateTime(this.date(), this.msOfDay(), ZoneId.of("America/New_York"));
        return ZonedDateTime.newBuilder().setEpochMs(timestamp.toInstant().toEpochMilli()).setZone(TimeZone.NEW_YORK).build();
    }
}

