/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.types.tick;

import java.time.ZoneId;
import net.thetadata.generated.TimeZone;
import net.thetadata.generated.ZonedDateTime;
import net.thetadata.types.Price;
import net.thetadata.types.tick.Tick;
import net.thetadata.utils.TimeUtils;

public class SnapshotTradeTick {
    private final int[] data;

    public SnapshotTradeTick(Tick t2) {
        this.data = t2.data();
        if (this.data.length != 7) {
            throw new IllegalArgumentException("Wrong number of data fields, expecting 7, got " + this.data.length);
        }
    }

    public int msOfDay() {
        return this.data[0];
    }

    public int sequence() {
        return this.data[1];
    }

    public int size() {
        return this.data[2];
    }

    public int condition() {
        return this.data[3];
    }

    public int price() {
        return this.data[4];
    }

    public int priceType() {
        return this.data[5];
    }

    public int date() {
        return this.data[6];
    }

    public Price getPrice() {
        return new Price(this.price(), this.priceType());
    }

    public ZonedDateTime getDateTimeMessage() {
        java.time.ZonedDateTime timestamp = TimeUtils.getZonedDateTime(this.date(), this.msOfDay(), ZoneId.of("America/New_York"));
        return ZonedDateTime.newBuilder().setEpochMs(timestamp.toInstant().toEpochMilli()).setZone(TimeZone.NEW_YORK).build();
    }

    public net.thetadata.generated.Price getPriceMessage() {
        return net.thetadata.generated.Price.newBuilder().setValue(this.price()).setType(this.priceType()).build();
    }
}

