/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.types.tick;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import net.thetadata.generated.Price;
import net.thetadata.generated.TimeZone;
import net.thetadata.types.tick.QuoteTick;
import net.thetadata.types.tick.Tick;
import net.thetadata.types.tick.TradeTick;
import net.thetadata.utils.PriceCalcUtils;
import net.thetadata.utils.TimeUtils;

public class TradeQuoteTick {
    private final int[] data;

    public TradeQuoteTick(Tick t2) {
        this.data = t2.data();
        if (this.data.length != 25) {
            throw new IllegalArgumentException("Wrong number of data fields, expecting 25, got " + this.data.length);
        }
    }

    public TradeQuoteTick(TradeTick trade, QuoteTick quote) {
        this.data = new int[25];
        if (trade.date() != quote.date()) {
            throw new IllegalArgumentException("Trade date does not match quote date: " + trade.date() + " != " + quote.date());
        }
        this.data[0] = trade.msOfDay();
        this.data[1] = trade.sequence();
        this.data[2] = trade.extCon1();
        this.data[3] = trade.extCon2();
        this.data[4] = trade.extCon3();
        this.data[5] = trade.extCon4();
        this.data[6] = trade.condition();
        this.data[7] = trade.size();
        this.data[8] = trade.exchange();
        this.data[9] = trade.price();
        this.data[10] = trade.conditionFlags();
        this.data[11] = trade.priceFlags();
        this.data[12] = trade.volumeType();
        this.data[13] = trade.recordsBack();
        this.data[14] = quote.msOfDay();
        this.data[15] = quote.bidSize();
        this.data[16] = quote.bidExg();
        this.data[17] = PriceCalcUtils.changePriceType(quote.bid(), quote.priceType(), trade.priceType());
        this.data[18] = quote.bidCondition();
        this.data[19] = quote.askSize();
        this.data[20] = quote.askExg();
        this.data[21] = PriceCalcUtils.changePriceType(quote.ask(), quote.priceType(), trade.priceType());
        this.data[22] = quote.askCondition();
        this.data[23] = trade.priceType();
        this.data[24] = trade.date();
    }

    public int msOfDay() {
        return this.data[0];
    }

    public int sequence() {
        return this.data[1];
    }

    public int extCon1() {
        return this.data[2];
    }

    public int extCon2() {
        return this.data[3];
    }

    public int extCon3() {
        return this.data[4];
    }

    public int extCon4() {
        return this.data[5];
    }

    public int condition() {
        return this.data[6];
    }

    public int size() {
        return this.data[7];
    }

    public int exchange() {
        return this.data[8];
    }

    public int price() {
        return this.data[9];
    }

    public int conditionFlags() {
        return this.data[10];
    }

    public int priceFlags() {
        return this.data[11];
    }

    public int volumeType() {
        return this.data[12];
    }

    public int recordsBack() {
        return this.data[13];
    }

    public int msOfDay2() {
        return this.data[14];
    }

    public int bidSize() {
        return this.data[15];
    }

    public int bidExchange() {
        return this.data[16];
    }

    public int bid() {
        return this.data[17];
    }

    public int bidCondition() {
        return this.data[18];
    }

    public int askSize() {
        return this.data[19];
    }

    public int askExchange() {
        return this.data[20];
    }

    public int ask() {
        return this.data[21];
    }

    public int askCondition() {
        return this.data[22];
    }

    public int priceType() {
        return this.data[23];
    }

    public int date() {
        return this.data[24];
    }

    public net.thetadata.generated.ZonedDateTime getTradeDateTimeMessage() {
        ZonedDateTime timestamp = TimeUtils.getZonedDateTime(this.date(), this.msOfDay(), ZoneId.of("America/New_York"));
        return net.thetadata.generated.ZonedDateTime.newBuilder().setEpochMs(timestamp.toInstant().toEpochMilli()).setZone(TimeZone.NEW_YORK).build();
    }

    public net.thetadata.generated.ZonedDateTime getQuoteDateTimeMessage() {
        ZonedDateTime timestamp = TimeUtils.getZonedDateTime(this.date(), this.msOfDay2(), ZoneId.of("America/New_York"));
        return net.thetadata.generated.ZonedDateTime.newBuilder().setEpochMs(timestamp.toInstant().toEpochMilli()).setZone(TimeZone.NEW_YORK).build();
    }

    public Price getPricePriceMessage() {
        return Price.newBuilder().setValue(this.price()).setType(this.priceType()).build();
    }

    public Price getBidPriceMessage() {
        return Price.newBuilder().setValue(this.bid()).setType(this.priceType()).build();
    }

    public Price getAskPriceMessage() {
        return Price.newBuilder().setValue(this.ask()).setType(this.priceType()).build();
    }
}

