/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.utils;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.thetadata.generated.DataValue;
import net.thetadata.generated.TimeZone;
import net.thetadata.types.Price;

public class PojoMessageUtils {
    public static int intervalToMilliseconds(String interval) {
        return switch (interval.toLowerCase()) {
            case "tick" -> 0;
            case "10ms" -> 10;
            case "100ms" -> 100;
            case "500ms" -> 500;
            case "1s" -> 1000;
            case "5s" -> 5000;
            case "10s" -> 10000;
            case "15s" -> 15000;
            case "30s" -> 30000;
            case "1m" -> 60000;
            case "5m" -> 300000;
            case "10m" -> 600000;
            case "15m" -> 900000;
            case "30m" -> 1800000;
            case "1h" -> 3600000;
            default -> throw new IllegalArgumentException("Invalid interval: " + interval);
        };
    }

    public static DataValue pojo2DataValue(Object obj) {
        if (obj instanceof DataValue) {
            return (DataValue)obj;
        }
        DataValue.Builder builder = DataValue.newBuilder();
        if (obj instanceof String) {
            builder.setText((String)obj);
        } else if (obj instanceof Long) {
            builder.setNumber((Long)obj);
        } else if (obj instanceof Integer) {
            builder.setNumber(((Integer)obj).intValue());
        } else if (obj instanceof net.thetadata.generated.ZonedDateTime) {
            builder.setTimestamp((net.thetadata.generated.ZonedDateTime)obj);
        } else if (obj instanceof net.thetadata.generated.Price) {
            builder.setPrice((net.thetadata.generated.Price)obj);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + obj.getClass().getName());
        }
        return builder.build();
    }

    public static String dataValue2String(DataValue dataValue) {
        switch (dataValue.getDataTypeCase()) {
            case TEXT: {
                return "\"" + dataValue.getText() + "\"";
            }
            case NUMBER: {
                return String.valueOf(dataValue.getNumber());
            }
            case PRICE: {
                return new Price(dataValue.getPrice()).toString();
            }
            case TIMESTAMP: {
                net.thetadata.generated.ZonedDateTime timestamp = dataValue.getTimestamp();
                ZoneId zoneId = switch (timestamp.getZone()) {
                    case TimeZone.UTC -> ZoneId.of("UTC");
                    default -> ZoneId.of("America/New_York");
                };
                ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp.getEpochMs()), zoneId);
                return zonedDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + String.valueOf(dataValue.getDataTypeCase()));
    }

    public static Object dataValue2Object(DataValue dataValue) {
        return switch (dataValue.getDataTypeCase()) {
            case DataValue.DataTypeCase.TEXT -> dataValue.getText();
            case DataValue.DataTypeCase.NUMBER -> dataValue.getNumber();
            case DataValue.DataTypeCase.PRICE -> new BigDecimal(new Price(dataValue.getPrice()).toString());
            case DataValue.DataTypeCase.TIMESTAMP -> {
                net.thetadata.generated.ZonedDateTime timestamp = dataValue.getTimestamp();
                ZoneId v1 = switch (timestamp.getZone()) {
                    case TimeZone.UTC -> ZoneId.of("UTC");
                    default -> ZoneId.of("America/New_York");
                };
                ZoneId zoneId = v1;
                ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp.getEpochMs()), zoneId);
                yield zonedDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            default -> throw new IllegalArgumentException("Unsupported data type: " + String.valueOf(dataValue.getDataTypeCase()));
        };
    }
}

