/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.utils;

import java.math.BigDecimal;
import net.thetadata.types.Price;

public class PriceCalcUtils {
    private static final int[] POWERS_OF_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    static final BigDecimal[] BIG_DECIMALS = new BigDecimal[]{BigDecimal.ZERO, new BigDecimal("0.000000001"), new BigDecimal("0.00000001"), new BigDecimal("0.0000001"), new BigDecimal("0.000001"), new BigDecimal("0.00001"), new BigDecimal("0.0001"), new BigDecimal("0.001"), new BigDecimal("0.01"), new BigDecimal("0.1"), BigDecimal.ONE, new BigDecimal("10.0"), new BigDecimal("100.0"), new BigDecimal("1000.0"), new BigDecimal("10000.0"), new BigDecimal("100000.0"), new BigDecimal("1000000.0"), new BigDecimal("10000000.0"), new BigDecimal("100000000.0"), new BigDecimal("1000000000.0")};
    static final double[] DOUBLES = new double[]{0.0, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    public static final int[] PLACES = new int[]{1, 9, 8, 7, 6, 5, 4, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

    public static double getPriceDouble(int price, int pType) {
        return DOUBLES[pType] * (double)price;
    }

    public static int toTickPrice(double d, int pType) {
        int out = (int)(d / DOUBLES[pType]);
        if (out == Integer.MAX_VALUE) {
            return out - 1;
        }
        if (out == Integer.MIN_VALUE) {
            return out + 1;
        }
        return out;
    }

    public static int changePriceType(int price, int priceType, int newPrice) {
        if (price == 0) {
            return 0;
        }
        int exp = newPrice - priceType;
        if (exp <= 0) {
            return price * POWERS_OF_10[Math.abs(exp)];
        }
        return price / POWERS_OF_10[exp];
    }

    public static void fmtPrice(StringBuilder builder, double d, int places) {
        long factor;
        double dFactor;
        if (d < 0.0) {
            builder.append('-');
            d = -d;
        }
        if (d * (dFactor = (double)(factor = (long)POWERS_OF_10[places])) + 0.5 > 9.223372036854776E18) {
            throw new IllegalArgumentException("number too large");
        }
        long scaled = (long)(d * dFactor + 0.5);
        int scale = places + 1;
        long scaled2 = scaled / 10L;
        while (factor <= scaled2) {
            factor *= 10L;
            ++scale;
        }
        while (scale > 0) {
            if (scale == places) {
                builder.append('.');
            }
            long c = scaled / factor % 10L;
            factor /= 10L;
            builder.append((char)(48L + c));
            --scale;
        }
    }

    public static int parseStrike(String strike) {
        if (strike.isBlank() || "*".equals(strike)) {
            return 0;
        }
        BigDecimal strikePrice = new BigDecimal(strike).multiply(BIG_DECIMALS[13]);
        return strikePrice.intValueExact();
    }

    public static Price strikeToPrice(int strike) {
        return new Price(strike, 7);
    }
}

