/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.utils;

import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import net.thetadata.exceptions.BadRequestException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeUtils {
    public static final LocalDate JAN_1ST_1883 = LocalDate.of(1882, 12, 31);
    private static final DateTimeFormatter WIX_DATE = DateTimeFormat.forPattern("yyyy/MM/dd");
    private static final DateTimeFormatter EXPECTED = DateTimeFormat.forPattern("yyyyMMdd");
    public static final long ONE_DAY_IN_MS = 2592000000L;
    private static final java.time.format.DateTimeFormatter DATE_FORMATTER = java.time.format.DateTimeFormatter.ofPattern("yyyyMMdd");

    public static String getDate() {
        return DATE_FORMATTER.format(LocalDateTime.now());
    }

    public static int dayDiff(String first, String second) {
        int diff;
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        try {
            diff = (int)TimeUnit.DAYS.convert(f.parse(first).getTime() - f.parse(second).getTime(), TimeUnit.MILLISECONDS);
        }
        catch (ParseException e) {
            return 1;
        }
        if (first.equalsIgnoreCase(second)) {
            return 0;
        }
        return Math.abs(diff);
    }

    public static String subtractDaysFromDate(String date, int dur) {
        return LocalDate.parse(date, DATE_FORMATTER).minusDays(dur).format(DATE_FORMATTER);
    }

    public static String addDaysToDate(String date, int dur) {
        return LocalDate.parse(date, DATE_FORMATTER).plusDays(dur).format(DATE_FORMATTER);
    }

    public static String intDateToString(int date) {
        return String.format("%d-%02d-%02d", date / 10000, date / 100 % 100, date % 100);
    }

    public static LocalDate intDateToLocalDate(int date) {
        return LocalDate.parse(String.valueOf(date), DATE_FORMATTER);
    }

    public static int stringDateToInt(String date, boolean allowStar, String errorMessagePrefix) throws BadRequestException {
        if ("*".equals(date)) {
            if (allowStar) {
                return 0;
            }
            throw new BadRequestException(errorMessagePrefix + " Cannot specify '*' for the date");
        }
        try {
            Calendar cal = TimeUtils.parseDate(date);
            return TimeUtils.calendar2Int(cal);
        }
        catch (Exception e) {
            throw new BadRequestException(errorMessagePrefix + " " + e.getMessage());
        }
    }

    public static int stringDateToInt(String date, String errorMessagePrefix) throws BadRequestException {
        return TimeUtils.stringDateToInt(date, false, errorMessagePrefix);
    }

    public static ZonedDateTime getZonedDateTime(int date, int msOfDay, ZoneId zoneId) {
        if (msOfDay < 0 || msOfDay >= 86400000) {
            throw new IllegalArgumentException("millisecondsOfDay must be between 0 and 86399999");
        }
        String dateString = String.valueOf(date);
        if (dateString.length() != 8) {
            throw new IllegalArgumentException("date must be in YYYYMMDD format (8 digits): " + dateString);
        }
        try {
            LocalDate localDate = LocalDate.parse(dateString, DATE_FORMATTER);
            int hours = msOfDay / 3600000;
            int minutes = msOfDay % 3600000 / 60000;
            int seconds = msOfDay % 60000 / 1000;
            int milliseconds = msOfDay % 1000;
            LocalDateTime localDateTime = LocalDateTime.of(localDate.getYear(), localDate.getMonth(), localDate.getDayOfMonth(), hours, minutes, seconds, milliseconds * 1000000);
            return ZonedDateTime.of(localDateTime, zoneId);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid date format. Expected YYYYMMDD", e);
        }
    }

    public static net.thetadata.generated.ZonedDateTime toZonedDateTimeMessage(ZonedDateTime dateTime) {
        return net.thetadata.generated.ZonedDateTime.newBuilder().setEpochMs(dateTime.toInstant().toEpochMilli()).setZone(net.thetadata.generated.TimeZone.NEW_YORK).build();
    }

    public static Calendar parseDate(String dateString) {
        Preconditions.checkArgument(!dateString.isBlank(), "Date cannot be blank");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("America/New_York"));
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (dateString.contains("/")) {
            String[] fields = dateString.split("/");
            if (fields.length != 3) {
                throw new IllegalArgumentException("Invalid date format. Expected MM/dd/yyyy");
            }
            cal.set(2, Integer.parseInt(fields[0]) - 1);
            cal.set(5, Integer.parseInt(fields[1]));
            cal.set(1, Integer.parseInt(fields[2]));
            return cal;
        }
        if (dateString.contains("-")) {
            String[] fields = dateString.split("-");
            if (fields.length != 3) {
                throw new IllegalArgumentException("Invalid date format. Expected yyyy-MM-dd");
            }
            cal.set(1, Integer.parseInt(fields[0]));
            cal.set(2, Integer.parseInt(fields[1]) - 1);
            cal.set(5, Integer.parseInt(fields[2]));
            return cal;
        }
        if (dateString.length() == 8) {
            cal.set(1, Integer.parseInt(dateString.substring(0, 4)));
            cal.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            cal.set(5, Integer.parseInt(dateString.substring(6, 8)));
            return cal;
        }
        throw new IllegalArgumentException("Cannot parse date string: " + dateString);
    }

    public static int calendar2Int(Calendar cal) {
        return cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5);
    }

    public static List<Calendar> generateClosedRange(Calendar start, Calendar end) {
        Preconditions.checkArgument(start.equals(end) || start.before(end), "End must be after start: %d, %d", start.toInstant().getEpochSecond(), end.toInstant().getEpochSecond());
        Preconditions.checkArgument(TimeUtils.daysBetween(start, end) <= 30L, "Too many days between start and end date; max 30 days allowed");
        Calendar cur = (Calendar)start.clone();
        ArrayList<Calendar> ret = new ArrayList<Calendar>();
        do {
            ret.add((Calendar)cur.clone());
            cur.add(5, 1);
        } while (cur.before(end));
        if (!start.equals(end)) {
            ret.add((Calendar)cur.clone());
        }
        return ret;
    }

    public static long daysBetween(Calendar start, Calendar end) {
        return ChronoUnit.DAYS.between(start.toInstant(), end.toInstant());
    }

    public static int msOfDay(Calendar date) {
        return date.get(11) * 60 * 60 * 1000 + date.get(12) * 60 * 1000 + date.get(13) * 1000 + date.get(14);
    }

    public static int convertTimeStringToMilliseconds(String timeString) {
        try {
            LocalTime localTime = LocalTime.parse(timeString, java.time.format.DateTimeFormatter.ofPattern("HH:mm:ss.SSS"));
            return localTime.toSecondOfDay() * 1000 + localTime.getNano() / 1000000;
        }
        catch (DateTimeParseException localTime) {
            try {
                LocalTime localTime2 = LocalTime.parse(timeString, java.time.format.DateTimeFormatter.ofPattern("HH:mm:ss"));
                return localTime2.toSecondOfDay() * 1000 + localTime2.getNano() / 1000000;
            }
            catch (DateTimeParseException localTime2) {
                try {
                    LocalTime localTime3 = LocalTime.parse(timeString, java.time.format.DateTimeFormatter.ofPattern("HH:mm"));
                    return localTime3.toSecondOfDay() * 1000 + localTime3.getNano() / 1000000;
                }
                catch (DateTimeParseException e) {
                    throw new IllegalArgumentException("Invalid time format: " + timeString + " Expected hh:mm:ss.SSS", e);
                }
            }
        }
    }
}

