/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.zone.ZoneRules;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import net.thetadata.utils.TimeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static final Logger logger = LogManager.getLogger(Utils.class);
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final ZoneRules rules = ZoneId.of("America/New_York").getRules();
    private static String hostname = null;
    public static final Comparator<File> COMPARE = (o1, o2) -> Integer.parseInt(o1.getName()) - Integer.parseInt(o2.getName());

    public static void logBuildInfo() {
        try (InputStream in = Utils.class.getClassLoader().getResourceAsStream("git.properties");){
            Properties props = new Properties();
            props.load(in);
            logger.info("JAR BUILT BY {} ({}) at {}", props.get("git.build.user.name"), props.get("git.build.user.email"), props.get("git.build.time"));
            boolean isDirty = Boolean.parseBoolean(props.getProperty("git.dirty"));
            String branch = props.getProperty("git.branch");
            if (!"main".equals(branch) || isDirty) {
                logger.warn("BRANCH: {} {} COMMIT: {}", (Object)branch, (Object)(isDirty ? "!DIRTY!" : ""), (Object)props.getProperty("git.commit.id.full"));
            } else {
                logger.warn("BRANCH: {} COMMIT: {}", (Object)branch, (Object)props.getProperty("git.commit.id.full"));
            }
        }
        catch (Exception e) {
            logger.error("ERROR GETTING BUILD INFORMATION", (Throwable)e);
        }
    }

    public static int toFmtDays(int nDays) {
        return Integer.parseInt(TimeUtils.JAN_1ST_1883.plusDays(nDays).format(DATE_FMT));
    }

    public static int toNDays(int date) {
        return (int)(LocalDate.parse("" + date, DATE_FMT).toEpochDay() - TimeUtils.JAN_1ST_1883.toEpochDay());
    }

    public static int currentDayMS() {
        if (rules.isDaylightSavings(Instant.now())) {
            return (int)(System.currentTimeMillis() % 86400000L - 14400000L);
        }
        return (int)(System.currentTimeMillis() % 86400000L - 14400000L) - 3600000;
    }

    public static String getTrace(Exception e) {
        return String.valueOf(e) + "e" + e.getMessage() + "\n" + Arrays.toString(e.getStackTrace()).replace(",", "\n") + "\n";
    }

    public static String removeBrackets(String s2) {
        return s2.replace("[", "").replace("]", "").replaceAll(" ", "");
    }

    public static String getIP(SocketAddress s2) {
        if (!s2.toString().contains(":")) {
            return null;
        }
        return s2.toString().substring(1, s2.toString().indexOf(58));
    }

    public static String getHostname() {
        if (hostname != null) {
            return hostname;
        }
        String os = System.getProperty("os.name").toLowerCase();
        try {
            if (os.contains("win")) {
                hostname = System.getenv("COMPUTERNAME");
            } else {
                Process process = Runtime.getRuntime().exec("hostname");
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
                hostname = reader.readLine();
                reader.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (hostname != null) {
            return hostname.trim();
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (Exception e) {
            logger.error("Error getting hostname", (Throwable)e);
        }
        if (hostname == null) {
            hostname = "unknown";
        }
        return hostname.trim();
    }
}

