# NyanCAD Server

NyanCAD Server is a Python package that provides an ASGI server for hosting NyanCAD applications with marimo notebook integration.

## Features

- Serves NyanCAD static files (HTML, CSS, JavaScript, assets) at the root path
- Integrates marimo notebook server at `/notebook/` endpoint
- Bundles all static assets in the wheel for easy deployment
- Simple command-line interface for starting the server
- Development mode with auto-reload support

## Installation

```bash
pip install nyancad-server
```

## Usage

### Command Line

Start the server with default settings (localhost:8080):

```bash
nyancad-server
```

Custom host and port:

```bash
nyancad-server --host 0.0.0.0 --port 3000
```

Development mode with auto-reload:

```bash
nyancad-server --reload
```

### Programmatic Usage

```python
from nyancad_server.server import create_app
import uvicorn

app = create_app()
uvicorn.run(app, host="localhost", port=8080)
```

## Server Endpoints

- `/` - NyanCAD web interface (static files)
- `/css/`, `/js/`, `/library/`, etc. - Static assets
- `/wheels/` - Python wheels (including nyancad package)
- `/notebook/` - Marimo notebook interface

## Architecture

The server creates a Starlette ASGI application that:

1. **Static Files**: Serves the entire `public/` folder contents at the root path using Starlette's StaticFiles
2. **Marimo Integration**: Mounts a marimo ASGI app at `/notebook/` that hosts the NyanCAD notebook
3. **Asset Bundling**: All static files and the notebook are bundled into the wheel during package build

This mirrors the existing WASM setup where users can access the main interface at `/` and the notebook at `/notebook/`, but replaces the WASM notebook with a full marimo server.

## Development

The server includes fallback logic to work in development mode by looking for files relative to the source code when bundled assets are not available.

## Requirements

- Python 3.8+
- marimo >= 0.13.0
  
- uvicorn[standard] >= 0.23.0
- nyancad >= 0.1.0

## License

This project is licensed under the Mozilla Public License 2.0 (MPL-2.0).
