const e=JSON.parse(`{"select":{"description":"Retrieves data from one or more tables","syntax":"SELECT column1, column2, ... FROM table_name","example":"SELECT name, email FROM users WHERE active = true"},"from":{"description":"Specifies which table to select data from","syntax":"FROM table_name","example":"FROM users u JOIN orders o ON u.id = o.user_id"},"where":{"description":"Filters records based on specified conditions","syntax":"WHERE condition","example":"WHERE age > 18 AND status = 'active'"},"join":{"description":"Combines rows from two or more tables based on a related column","syntax":"JOIN table_name ON condition","example":"JOIN orders ON users.id = orders.user_id"},"inner":{"description":"Returns records that have matching values in both tables","syntax":"INNER JOIN table_name ON condition","example":"INNER JOIN orders ON users.id = orders.user_id"},"left":{"description":"Returns all records from the left table and matching records from the right","syntax":"LEFT JOIN table_name ON condition","example":"LEFT JOIN orders ON users.id = orders.user_id"},"right":{"description":"Returns all records from the right table and matching records from the left","syntax":"RIGHT JOIN table_name ON condition","example":"RIGHT JOIN users ON users.id = orders.user_id"},"full":{"description":"Returns all records when there is a match in either left or right table","syntax":"FULL OUTER JOIN table_name ON condition","example":"FULL OUTER JOIN orders ON users.id = orders.user_id"},"outer":{"description":"Used with FULL to return all records from both tables","syntax":"FULL OUTER JOIN table_name ON condition","example":"FULL OUTER JOIN orders ON users.id = orders.user_id"},"cross":{"description":"Returns the Cartesian product of both tables","syntax":"CROSS JOIN table_name","example":"CROSS JOIN colors"},"order":{"description":"Sorts the result set in ascending or descending order","syntax":"ORDER BY column_name [ASC|DESC]","example":"ORDER BY created_at DESC, name ASC"},"by":{"description":"Used with ORDER BY and GROUP BY clauses","syntax":"ORDER BY column_name or GROUP BY column_name","example":"ORDER BY name ASC or GROUP BY category"},"group":{"description":"Groups rows that have the same values into summary rows","syntax":"GROUP BY column_name","example":"GROUP BY category HAVING COUNT(*) > 5"},"having":{"description":"Filters groups based on specified conditions (used with GROUP BY)","syntax":"HAVING condition","example":"GROUP BY category HAVING COUNT(*) > 5"},"insert":{"description":"Adds new records to a table","syntax":"INSERT INTO table_name (columns) VALUES (values)","example":"INSERT INTO users (name, email) VALUES ('John', 'john@example.com')"},"into":{"description":"Specifies the target table for INSERT statements","syntax":"INSERT INTO table_name","example":"INSERT INTO users (name, email) VALUES ('John', 'john@example.com')"},"values":{"description":"Specifies the values to insert into a table","syntax":"VALUES (value1, value2, ...)","example":"VALUES ('John', 'john@example.com', true)"},"update":{"description":"Modifies existing records in a table","syntax":"UPDATE table_name SET column = value WHERE condition","example":"UPDATE users SET email = 'new@example.com' WHERE id = 1"},"set":{"description":"Specifies which columns to update and their new values","syntax":"SET column1 = value1, column2 = value2","example":"SET name = 'John', email = 'john@example.com'"},"delete":{"description":"Removes records from a table","syntax":"DELETE FROM table_name WHERE condition","example":"DELETE FROM users WHERE active = false"},"create":{"description":"Creates a new table, database, or other database object","syntax":"CREATE TABLE table_name (column definitions)","example":"CREATE TABLE users (id INT PRIMARY KEY, name VARCHAR(100))"},"table":{"description":"Specifies a table in CREATE, ALTER, or DROP statements","syntax":"CREATE TABLE table_name or ALTER TABLE table_name","example":"CREATE TABLE users (id INT, name VARCHAR(100))"},"drop":{"description":"Deletes a table, database, or other database object","syntax":"DROP TABLE table_name","example":"DROP TABLE old_users"},"alter":{"description":"Modifies an existing database object","syntax":"ALTER TABLE table_name ADD/DROP/MODIFY column","example":"ALTER TABLE users ADD COLUMN phone VARCHAR(20)"},"add":{"description":"Adds a new column or constraint to a table","syntax":"ALTER TABLE table_name ADD column_name data_type","example":"ALTER TABLE users ADD phone VARCHAR(20)"},"column":{"description":"Specifies a column in table operations","syntax":"ADD COLUMN column_name or DROP COLUMN column_name","example":"ADD COLUMN created_at TIMESTAMP DEFAULT NOW()"},"primary":{"description":"Defines a primary key constraint","syntax":"PRIMARY KEY (column_name)","example":"CREATE TABLE users (id INT PRIMARY KEY, name VARCHAR(100))"},"key":{"description":"Used with PRIMARY or FOREIGN to define constraints","syntax":"PRIMARY KEY or FOREIGN KEY","example":"PRIMARY KEY (id) or FOREIGN KEY (user_id) REFERENCES users(id)"},"foreign":{"description":"Defines a foreign key constraint","syntax":"FOREIGN KEY (column_name) REFERENCES table_name(column_name)","example":"FOREIGN KEY (user_id) REFERENCES users(id)"},"references":{"description":"Specifies the referenced table and column for foreign keys","syntax":"REFERENCES table_name(column_name)","example":"FOREIGN KEY (user_id) REFERENCES users(id)"},"unique":{"description":"Ensures all values in a column are unique","syntax":"UNIQUE (column_name)","example":"CREATE TABLE users (email VARCHAR(255) UNIQUE)"},"constraint":{"description":"Names a constraint for easier management","syntax":"CONSTRAINT constraint_name constraint_type","example":"CONSTRAINT fk_user FOREIGN KEY (user_id) REFERENCES users(id)"},"check":{"description":"Defines a condition that must be true for all rows","syntax":"CHECK (condition)","example":"CHECK (age >= 18)"},"default":{"description":"Specifies a default value for a column","syntax":"column_name data_type DEFAULT value","example":"created_at TIMESTAMP DEFAULT NOW()"},"index":{"description":"Creates an index to improve query performance","syntax":"CREATE INDEX index_name ON table_name (column_name)","example":"CREATE INDEX idx_user_email ON users (email)"},"view":{"description":"Creates a virtual table based on a SELECT statement","syntax":"CREATE VIEW view_name AS SELECT ...","example":"CREATE VIEW active_users AS SELECT * FROM users WHERE active = true"},"limit":{"description":"Restricts the number of records returned","syntax":"LIMIT number","example":"SELECT * FROM users LIMIT 10"},"offset":{"description":"Skips a specified number of rows before returning results","syntax":"OFFSET number","example":"SELECT * FROM users LIMIT 10 OFFSET 20"},"top":{"description":"Limits the number of records returned (SQL Server syntax)","syntax":"SELECT TOP number columns FROM table","example":"SELECT TOP 10 * FROM users"},"fetch":{"description":"Retrieves a specific number of rows (modern SQL standard)","syntax":"OFFSET number ROWS FETCH NEXT number ROWS ONLY","example":"OFFSET 10 ROWS FETCH NEXT 5 ROWS ONLY"},"with":{"description":"Defines a Common Table Expression (CTE)","syntax":"WITH cte_name AS (SELECT ...) SELECT ... FROM cte_name","example":"WITH user_stats AS (SELECT user_id, COUNT(*) FROM orders GROUP BY user_id) SELECT * FROM user_stats"},"recursive":{"description":"Creates a recursive CTE that can reference itself","syntax":"WITH RECURSIVE cte_name AS (...) SELECT ...","example":"WITH RECURSIVE tree AS (SELECT id, parent_id FROM categories WHERE parent_id IS NULL UNION ALL SELECT c.id, c.parent_id FROM categories c JOIN tree t ON c.parent_id = t.id) SELECT * FROM tree"},"distinct":{"description":"Returns only unique values","syntax":"SELECT DISTINCT column_name FROM table_name","example":"SELECT DISTINCT category FROM products"},"count":{"description":"Returns the number of rows that match a condition","syntax":"COUNT(*) or COUNT(column_name)","example":"SELECT COUNT(*) FROM users WHERE active = true"},"sum":{"description":"Returns the sum of numeric values","syntax":"SUM(column_name)","example":"SELECT SUM(price) FROM orders WHERE status = 'completed'"},"avg":{"description":"Returns the average value of numeric values","syntax":"AVG(column_name)","example":"SELECT AVG(age) FROM users"},"max":{"description":"Returns the maximum value","syntax":"MAX(column_name)","example":"SELECT MAX(price) FROM products"},"min":{"description":"Returns the minimum value","syntax":"MIN(column_name)","example":"SELECT MIN(price) FROM products"},"as":{"description":"Creates an alias for a column or table","syntax":"column_name AS alias_name or table_name AS alias_name","example":"SELECT name AS customer_name FROM users AS u"},"on":{"description":"Specifies the join condition between tables","syntax":"JOIN table_name ON condition","example":"JOIN orders ON users.id = orders.user_id"},"and":{"description":"Combines multiple conditions with logical AND","syntax":"WHERE condition1 AND condition2","example":"WHERE age > 18 AND status = 'active'"},"or":{"description":"Combines multiple conditions with logical OR","syntax":"WHERE condition1 OR condition2","example":"WHERE category = 'electronics' OR category = 'books'"},"not":{"description":"Negates a condition","syntax":"WHERE NOT condition","example":"WHERE NOT status = 'inactive'"},"null":{"description":"Represents a missing or unknown value","syntax":"column_name IS NULL or column_name IS NOT NULL","example":"WHERE email IS NOT NULL"},"is":{"description":"Used to test for NULL values or boolean conditions","syntax":"column_name IS NULL or column_name IS NOT NULL","example":"WHERE deleted_at IS NULL"},"in":{"description":"Checks if a value matches any value in a list","syntax":"column_name IN (value1, value2, ...)","example":"WHERE status IN ('active', 'pending', 'approved')"},"between":{"description":"Selects values within a range","syntax":"column_name BETWEEN value1 AND value2","example":"WHERE age BETWEEN 18 AND 65"},"like":{"description":"Searches for a pattern in a column","syntax":"column_name LIKE pattern","example":"WHERE name LIKE 'John%' (starts with 'John')"},"exists":{"description":"Tests whether a subquery returns any rows","syntax":"WHERE EXISTS (subquery)","example":"WHERE EXISTS (SELECT 1 FROM orders WHERE orders.user_id = users.id)"},"any":{"description":"Compares a value to any value returned by a subquery","syntax":"column_name operator ANY (subquery)","example":"WHERE price > ANY (SELECT price FROM products WHERE category = 'electronics')"},"all":{"description":"Compares a value to all values returned by a subquery","syntax":"column_name operator ALL (subquery)","example":"WHERE price > ALL (SELECT price FROM products WHERE category = 'books')"},"some":{"description":"Synonym for ANY - compares a value to some values in a subquery","syntax":"column_name operator SOME (subquery)","example":"WHERE price > SOME (SELECT price FROM products WHERE category = 'electronics')"},"union":{"description":"Combines the result sets of two or more SELECT statements","syntax":"SELECT ... UNION SELECT ...","example":"SELECT name FROM customers UNION SELECT name FROM suppliers"},"intersect":{"description":"Returns rows that are in both result sets","syntax":"SELECT ... INTERSECT SELECT ...","example":"SELECT customer_id FROM orders INTERSECT SELECT customer_id FROM returns"},"except":{"description":"Returns rows from the first query that are not in the second","syntax":"SELECT ... EXCEPT SELECT ...","example":"SELECT customer_id FROM customers EXCEPT SELECT customer_id FROM blacklist"},"case":{"description":"Provides conditional logic in SQL queries","syntax":"CASE WHEN condition THEN result ELSE result END","example":"CASE WHEN age < 18 THEN 'Minor' ELSE 'Adult' END"},"when":{"description":"Specifies conditions in CASE statements","syntax":"CASE WHEN condition THEN result","example":"CASE WHEN score >= 90 THEN 'A' WHEN score >= 80 THEN 'B' END"},"then":{"description":"Specifies the result for a WHEN condition","syntax":"WHEN condition THEN result","example":"WHEN age < 18 THEN 'Minor'"},"else":{"description":"Specifies the default result in CASE statements","syntax":"CASE WHEN condition THEN result ELSE default_result END","example":"CASE WHEN score >= 60 THEN 'Pass' ELSE 'Fail' END"},"end":{"description":"Terminates a CASE statement","syntax":"CASE WHEN condition THEN result END","example":"CASE WHEN age < 18 THEN 'Minor' ELSE 'Adult' END"},"over":{"description":"Defines a window for window functions","syntax":"window_function() OVER (PARTITION BY ... ORDER BY ...)","example":"ROW_NUMBER() OVER (PARTITION BY department ORDER BY salary DESC)"},"partition":{"description":"Divides the result set into groups for window functions","syntax":"OVER (PARTITION BY column_name)","example":"SUM(salary) OVER (PARTITION BY department)"},"row_number":{"description":"Assigns a unique sequential integer to each row","syntax":"ROW_NUMBER() OVER (ORDER BY column_name)","example":"ROW_NUMBER() OVER (ORDER BY created_at DESC)"},"rank":{"description":"Assigns a rank to each row with gaps for ties","syntax":"RANK() OVER (ORDER BY column_name)","example":"RANK() OVER (ORDER BY score DESC)"},"dense_rank":{"description":"Assigns a rank to each row without gaps for ties","syntax":"DENSE_RANK() OVER (ORDER BY column_name)","example":"DENSE_RANK() OVER (ORDER BY score DESC)"},"begin":{"description":"Starts a transaction block","syntax":"BEGIN [TRANSACTION]","example":"BEGIN; UPDATE accounts SET balance = balance - 100; COMMIT;"},"commit":{"description":"Permanently saves all changes made in the current transaction","syntax":"COMMIT [TRANSACTION]","example":"BEGIN; INSERT INTO users VALUES (...); COMMIT;"},"rollback":{"description":"Undoes all changes made in the current transaction","syntax":"ROLLBACK [TRANSACTION]","example":"BEGIN; DELETE FROM users WHERE id = 1; ROLLBACK;"},"transaction":{"description":"Groups multiple SQL statements into a single unit of work","syntax":"BEGIN TRANSACTION; ... COMMIT/ROLLBACK;","example":"BEGIN TRANSACTION; UPDATE accounts SET balance = balance - 100 WHERE id = 1; COMMIT;"}}`),a={keywords:e};export{a as default,e as keywords};
