﻿
---

# HoloAI – Universal Multimodal AI Orchestrator

# NOTICE: PLEASE DO NOT INSTALL VERSION 0.1.0-0.1.7, IT IS NOT STABLE AND WILL BREAK YOUR PROJECT.

---

## Overview

HoloAI is a production-grade, multi-provider orchestrator for LLM and vision models.  
Supports OpenAI, Anthropic, Google, and Groq, with automatic provider inference.
Built for:

* Agents & bots
* Workflow automation
* Voice assistants
* Any application needing multi-model, multi-provider intelligence

HoloAI unifies OpenAI, Google Gemini, Groq, and Anthropic: handling agents, conversation, vision, all from a single interface.

---

## New Features

* Tool/Function calling

---

## Up Coming Features

* 

---

## Key Features

* **Universal Provider Support:**
  Instantly switch between OpenAI, Google Gemini, Groq, and Anthropic—no vendor lock-in.
* **Multimodal Ready:**
  Handles text, image, out of the box.
* **Automatic Provider Inference:**
  Just specify your model; HoloAI selects the right backend.
* **Minimal, Clean API:**
  One interface for all major models—rapid integration.

---

## Why HoloAI?

Most LLM wrappers lock you into a single vendor or force you to juggle multiple APIs and formats.
**HoloAI** delivers:

* **One Framework, any provider.**
* **No boilerplate, no rewrites.**
* **Plug-and-play for agents, scripts, automations, or apps.**

---

## Environment

Set API keys as environment variables:

* `OPENAI_API_KEY`
* `ANTHROPIC_API_KEY`
* `GOOGLE_API_KEY`
* `GROQ_API_KEY`

Only providers with keys set will be loaded.

---

## Code Examples

You can find code examples on my [GitHub repository](https://github.com/TristanMcBrideSr/TechBook).

---

## License

This project is licensed under the [MIT](LICENSE).
Copyright 2025 Tristan McBride Sr.

---

## Acknowledgements

Project by:
- Tristan McBride Sr.
- Sybil
