## Description
Brief description of what this PR does.

Fixes #(issue number)

## Type of Change
- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation update
- [ ] Performance improvement
- [ ] Code refactoring

## Changes Made
- Change 1
- Change 2
- Change 3

## Testing
Describe the tests you ran to verify your changes:

```bash
# Commands used for testing
pytest tests/ -v
pyresolvers -tL test_servers.txt
```

## Checklist
- [ ] My code follows the project's style guidelines
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] All new and existing tests pass locally
- [ ] I have updated the documentation (README.md, docstrings, etc.)
- [ ] My changes generate no new warnings

## Screenshots (if applicable)
Add screenshots or command output showing the changes in action.

## Additional Notes
Any additional information that reviewers should know.
