"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .choice import Choice, ChoiceTypedDict
from .usage import Usage, UsageTypedDict
from pydantic import model_serializer
from sudo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing import Dict, List
from typing_extensions import NotRequired, TypedDict


class ChatCompletionTypedDict(TypedDict):
    choices: List[ChoiceTypedDict]
    created: int
    id: str
    model: str
    object: str
    usage: UsageTypedDict
    service_tier: NotRequired[Nullable[str]]
    system_fingerprint: NotRequired[Nullable[str]]
    metadata: NotRequired[Nullable[Dict[str, str]]]
    r"""Developer-defined metadata attached to the completion."""


class ChatCompletion(BaseModel):
    choices: List[Choice]

    created: int

    id: str

    model: str

    object: str

    usage: Usage

    service_tier: OptionalNullable[str] = UNSET

    system_fingerprint: OptionalNullable[str] = UNSET

    metadata: OptionalNullable[Dict[str, str]] = UNSET
    r"""Developer-defined metadata attached to the completion."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["service_tier", "system_fingerprint", "metadata"]
        nullable_fields = ["service_tier", "system_fingerprint", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
