"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .toolcall import ToolCall, ToolCallTypedDict
from enum import Enum
from pydantic import model_serializer
from sudo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing import List
from typing_extensions import NotRequired, TypedDict


class Role(str, Enum):
    r"""The role of the author of this message."""

    ASSISTANT = "assistant"
    USER = "user"
    SYSTEM = "system"
    TOOL = "tool"


class ChatCompletionDeltaTypedDict(TypedDict):
    content: NotRequired[Nullable[str]]
    r"""The contents of the chunk message."""
    role: NotRequired[Nullable[Role]]
    r"""The role of the author of this message."""
    tool_calls: NotRequired[Nullable[List[ToolCallTypedDict]]]
    r"""The tool calls generated by the model, such as function calls."""
    refusal: NotRequired[Nullable[str]]
    r"""The refusal message generated by the model."""


class ChatCompletionDelta(BaseModel):
    content: OptionalNullable[str] = UNSET
    r"""The contents of the chunk message."""

    role: OptionalNullable[Role] = UNSET
    r"""The role of the author of this message."""

    tool_calls: OptionalNullable[List[ToolCall]] = UNSET
    r"""The tool calls generated by the model, such as function calls."""

    refusal: OptionalNullable[str] = UNSET
    r"""The refusal message generated by the model."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["content", "role", "tool_calls", "refusal"]
        nullable_fields = ["content", "role", "tool_calls", "refusal"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
