"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chatmessage import ChatMessage, ChatMessageTypedDict
from .tool import Tool, ToolTypedDict
from enum import Enum
import pydantic
from pydantic import model_serializer
from sudo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class ChatCompletionRequestStreamFormat(str, Enum):
    r"""Specifies the output audio format. Must be one of wav, mp3, flac, opus, or pcm16."""

    WAV = "wav"
    MP3 = "mp3"
    FLAC = "flac"
    OPUS = "opus"
    PCM16 = "pcm16"


class ChatCompletionRequestStreamVoice(str, Enum):
    r"""Specifies the voice type. Supported voices are alloy, echo, fable, onyx, nova, and shimmer."""

    ALLOY = "alloy"
    ECHO = "echo"
    FABLE = "fable"
    ONYX = "onyx"
    NOVA = "nova"
    SHIMMER = "shimmer"


class ChatCompletionRequestStreamAudioTypedDict(TypedDict):
    r"""Parameters for audio output. Required when audio output is requested with modalities: [\"audio\"]."""

    format_: NotRequired[ChatCompletionRequestStreamFormat]
    r"""Specifies the output audio format. Must be one of wav, mp3, flac, opus, or pcm16."""
    voice: NotRequired[ChatCompletionRequestStreamVoice]
    r"""Specifies the voice type. Supported voices are alloy, echo, fable, onyx, nova, and shimmer."""


class ChatCompletionRequestStreamAudio(BaseModel):
    r"""Parameters for audio output. Required when audio output is requested with modalities: [\"audio\"]."""

    format_: Annotated[
        Optional[ChatCompletionRequestStreamFormat], pydantic.Field(alias="format")
    ] = None
    r"""Specifies the output audio format. Must be one of wav, mp3, flac, opus, or pcm16."""

    voice: Optional[ChatCompletionRequestStreamVoice] = None
    r"""Specifies the voice type. Supported voices are alloy, echo, fable, onyx, nova, and shimmer."""


class ChatCompletionRequestStreamModality(str, Enum):
    TEXT = "text"
    AUDIO = "audio"


class ChatCompletionRequestStreamTypeContent(str, Enum):
    CONTENT = "content"


class ChatCompletionRequestStreamPredictionTypedDict(TypedDict):
    r"""Configuration for a Predicted Output, which can greatly improve response times when large parts of the model response are known ahead of time. This is most common when you are regenerating a file with only minor changes to most of the content."""

    type: NotRequired[ChatCompletionRequestStreamTypeContent]
    content: NotRequired[str]
    r"""The predicted content for the completion."""


class ChatCompletionRequestStreamPrediction(BaseModel):
    r"""Configuration for a Predicted Output, which can greatly improve response times when large parts of the model response are known ahead of time. This is most common when you are regenerating a file with only minor changes to most of the content."""

    type: Optional[ChatCompletionRequestStreamTypeContent] = None

    content: Optional[str] = None
    r"""The predicted content for the completion."""


class ChatCompletionRequestStreamReasoningEffort(str, Enum):
    r"""o1 models only. Constrains effort on reasoning for reasoning models. Currently supported values are low, medium, and high. Reducing reasoning effort can result in faster responses and fewer tokens used on reasoning in a response."""

    LOW = "low"
    MEDIUM = "medium"
    HIGH = "high"


class ChatCompletionRequestStreamTypeJSONSchema(str, Enum):
    JSON_SCHEMA = "json_schema"


class ChatCompletionRequestStreamJSONSchemaTypedDict(TypedDict):
    r"""The JSON schema definition for structured outputs."""

    name: str
    r"""The name of the response format. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""
    schema_: Dict[str, Any]
    r"""The schema for the response format, described as a JSON Schema object."""
    description: NotRequired[str]
    r"""A description of what the response format is for, used by the model to determine how to respond in the format."""
    strict: NotRequired[bool]
    r"""Whether to enable strict schema adherence when generating the output."""


class ChatCompletionRequestStreamJSONSchema(BaseModel):
    r"""The JSON schema definition for structured outputs."""

    name: str
    r"""The name of the response format. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""

    schema_: Annotated[Dict[str, Any], pydantic.Field(alias="schema")]
    r"""The schema for the response format, described as a JSON Schema object."""

    description: Optional[str] = None
    r"""A description of what the response format is for, used by the model to determine how to respond in the format."""

    strict: Optional[bool] = None
    r"""Whether to enable strict schema adherence when generating the output."""


class ChatCompletionRequestStreamResponseFormatJSONSchemaTypedDict(TypedDict):
    type: ChatCompletionRequestStreamTypeJSONSchema
    json_schema: ChatCompletionRequestStreamJSONSchemaTypedDict
    r"""The JSON schema definition for structured outputs."""


class ChatCompletionRequestStreamResponseFormatJSONSchema(BaseModel):
    type: ChatCompletionRequestStreamTypeJSONSchema

    json_schema: ChatCompletionRequestStreamJSONSchema
    r"""The JSON schema definition for structured outputs."""


class ChatCompletionRequestStreamTypeJSONObject(str, Enum):
    JSON_OBJECT = "json_object"


class ChatCompletionRequestStreamResponseFormatJSONObjectTypedDict(TypedDict):
    type: ChatCompletionRequestStreamTypeJSONObject


class ChatCompletionRequestStreamResponseFormatJSONObject(BaseModel):
    type: ChatCompletionRequestStreamTypeJSONObject


class ChatCompletionRequestStreamTypeText(str, Enum):
    TEXT = "text"


class ChatCompletionRequestStreamResponseFormatTextTypedDict(TypedDict):
    type: ChatCompletionRequestStreamTypeText


class ChatCompletionRequestStreamResponseFormatText(BaseModel):
    type: ChatCompletionRequestStreamTypeText


ChatCompletionRequestStreamResponseFormatUnionTypedDict = TypeAliasType(
    "ChatCompletionRequestStreamResponseFormatUnionTypedDict",
    Union[
        ChatCompletionRequestStreamResponseFormatTextTypedDict,
        ChatCompletionRequestStreamResponseFormatJSONObjectTypedDict,
        ChatCompletionRequestStreamResponseFormatJSONSchemaTypedDict,
    ],
)
r"""An object specifying the format that the model must output. Compatible with GPT-4o, GPT-4o mini, GPT-4 Turbo and all GPT-3.5 Turbo models newer than gpt-3.5-turbo-1106. Setting to { \"type\": \"json_schema\", \"json_schema\": {...} } enables Structured Outputs which guarantee the model will match your supplied JSON schema. Setting to { \"type\": \"json_object\" } enables JSON mode, which guarantees the message the model generates is valid JSON."""


ChatCompletionRequestStreamResponseFormatUnion = TypeAliasType(
    "ChatCompletionRequestStreamResponseFormatUnion",
    Union[
        ChatCompletionRequestStreamResponseFormatText,
        ChatCompletionRequestStreamResponseFormatJSONObject,
        ChatCompletionRequestStreamResponseFormatJSONSchema,
    ],
)
r"""An object specifying the format that the model must output. Compatible with GPT-4o, GPT-4o mini, GPT-4 Turbo and all GPT-3.5 Turbo models newer than gpt-3.5-turbo-1106. Setting to { \"type\": \"json_schema\", \"json_schema\": {...} } enables Structured Outputs which guarantee the model will match your supplied JSON schema. Setting to { \"type\": \"json_object\" } enables JSON mode, which guarantees the message the model generates is valid JSON."""


class ChatCompletionRequestStreamServiceTier(str, Enum):
    r"""Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service."""

    AUTO = "auto"
    DEFAULT = "default"


class ChatCompletionRequestStreamStreamOptionsTypedDict(TypedDict):
    r"""Options for streaming response. Only set this when you set stream: true."""

    include_usage: NotRequired[bool]
    r"""If set, an additional chunk will be streamed before the data: [DONE] message. The usage field on this chunk shows the token usage statistics for the entire request, and the choices field will always be an empty array. All other chunks will also include a usage field, but with a null value."""


class ChatCompletionRequestStreamStreamOptions(BaseModel):
    r"""Options for streaming response. Only set this when you set stream: true."""

    include_usage: Optional[bool] = None
    r"""If set, an additional chunk will be streamed before the data: [DONE] message. The usage field on this chunk shows the token usage statistics for the entire request, and the choices field will always be an empty array. All other chunks will also include a usage field, but with a null value."""


class ChatCompletionRequestStreamToolChoiceType(str, Enum):
    FUNCTION = "function"


class ChatCompletionRequestStreamFunctionTypedDict(TypedDict):
    name: str


class ChatCompletionRequestStreamFunction(BaseModel):
    name: str


class ChatCompletionRequestStreamToolChoiceFunctionTypedDict(TypedDict):
    type: ChatCompletionRequestStreamToolChoiceType
    function: ChatCompletionRequestStreamFunctionTypedDict


class ChatCompletionRequestStreamToolChoiceFunction(BaseModel):
    type: ChatCompletionRequestStreamToolChoiceType

    function: ChatCompletionRequestStreamFunction


class ChatCompletionRequestStreamToolChoiceEnum(str, Enum):
    NONE = "none"
    AUTO = "auto"
    REQUIRED = "required"


ChatCompletionRequestStreamToolChoiceUnionTypedDict = TypeAliasType(
    "ChatCompletionRequestStreamToolChoiceUnionTypedDict",
    Union[
        ChatCompletionRequestStreamToolChoiceFunctionTypedDict,
        ChatCompletionRequestStreamToolChoiceEnum,
    ],
)
r"""Controls which (if any) tool is called by the model. none means the model won't call any tool and instead generates a message. auto means the model can pick between generating a message or calling one or more tools. required means the model must call one or more tools. Specifying a particular tool via {\"type\": \"function\", \"function\": {\"name\": \"my_function\"}} forces the model to call that tool. none is the default when no tools are present. auto is the default if tools are present."""


ChatCompletionRequestStreamToolChoiceUnion = TypeAliasType(
    "ChatCompletionRequestStreamToolChoiceUnion",
    Union[
        ChatCompletionRequestStreamToolChoiceFunction,
        ChatCompletionRequestStreamToolChoiceEnum,
    ],
)
r"""Controls which (if any) tool is called by the model. none means the model won't call any tool and instead generates a message. auto means the model can pick between generating a message or calling one or more tools. required means the model must call one or more tools. Specifying a particular tool via {\"type\": \"function\", \"function\": {\"name\": \"my_function\"}} forces the model to call that tool. none is the default when no tools are present. auto is the default if tools are present."""


class ChatCompletionRequestStreamTypedDict(TypedDict):
    messages: List[ChatMessageTypedDict]
    r"""A list of messages comprising the conversation so far. Depending on the model you use, different message types (modalities) are supported, like text, images, and audio."""
    model: str
    r"""Model name used to generate the response, like gpt-4o or deepseek-reasoner. Sudo offers a wide range of models with different capabilities, performance characteristics, and price points. Refer to the [docs](https://docs.sudoapp.dev/overview/models) to browse and compare available models."""
    audio: NotRequired[Nullable[ChatCompletionRequestStreamAudioTypedDict]]
    r"""Parameters for audio output. Required when audio output is requested with modalities: [\"audio\"]."""
    frequency_penalty: NotRequired[Nullable[float]]
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim."""
    logit_bias: NotRequired[Nullable[Dict[str, float]]]
    r"""Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token."""
    logprobs: NotRequired[Nullable[bool]]
    r"""Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the content of message."""
    max_completion_tokens: NotRequired[Nullable[int]]
    r"""An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and reasoning tokens."""
    metadata: NotRequired[Nullable[Dict[str, str]]]
    r"""Developer-defined tags and values used for filtering completions in the stored completions dashboard."""
    modalities: NotRequired[Nullable[List[ChatCompletionRequestStreamModality]]]
    r"""Output types that you would like the model to generate for this request. Most models are capable of generating text, which is the default: [\"text\"]. The gpt-4o-audio-preview model can also be used to generate audio. To request that this model generate both text and audio responses, you can use: [\"text\", \"audio\"]."""
    n: NotRequired[Nullable[int]]
    r"""How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep n as 1 to minimize costs."""
    parallel_tool_calls: NotRequired[Nullable[bool]]
    r"""Whether to enable parallel function calling during tool use."""
    prediction: NotRequired[Nullable[ChatCompletionRequestStreamPredictionTypedDict]]
    r"""Configuration for a Predicted Output, which can greatly improve response times when large parts of the model response are known ahead of time. This is most common when you are regenerating a file with only minor changes to most of the content."""
    presence_penalty: NotRequired[Nullable[float]]
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics."""
    prompt_cache_key: NotRequired[Nullable[str]]
    r"""A unique identifier for caching prompts to improve response times for repeated requests."""
    reasoning_effort: NotRequired[Nullable[ChatCompletionRequestStreamReasoningEffort]]
    r"""o1 models only. Constrains effort on reasoning for reasoning models. Currently supported values are low, medium, and high. Reducing reasoning effort can result in faster responses and fewer tokens used on reasoning in a response."""
    response_format: NotRequired[
        Nullable[ChatCompletionRequestStreamResponseFormatUnionTypedDict]
    ]
    r"""An object specifying the format that the model must output. Compatible with GPT-4o, GPT-4o mini, GPT-4 Turbo and all GPT-3.5 Turbo models newer than gpt-3.5-turbo-1106. Setting to { \"type\": \"json_schema\", \"json_schema\": {...} } enables Structured Outputs which guarantee the model will match your supplied JSON schema. Setting to { \"type\": \"json_object\" } enables JSON mode, which guarantees the message the model generates is valid JSON."""
    seed: NotRequired[Nullable[int]]
    r"""If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism isn't guaranteed, and you should refer to the system_fingerprint response parameter to monitor changes in the backend."""
    service_tier: NotRequired[Nullable[ChatCompletionRequestStreamServiceTier]]
    r"""Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service."""
    stop: NotRequired[Nullable[List[str]]]
    r"""Not supported with latest reasoning models o3 and o4-mini. Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence."""
    store: NotRequired[Nullable[bool]]
    r"""Whether or not to store the output of this chat completion request for use in our model distillation or evaluation products."""
    stream: NotRequired[bool]
    r"""If set, partial message deltas will be sent as server-sent events. For streaming responses, this must be true."""
    stream_options: NotRequired[
        Nullable[ChatCompletionRequestStreamStreamOptionsTypedDict]
    ]
    r"""Options for streaming response. Only set this when you set stream: true."""
    temperature: NotRequired[Nullable[float]]
    r"""What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. We generally recommend altering this or top_p but not both."""
    tool_choice: NotRequired[
        Nullable[ChatCompletionRequestStreamToolChoiceUnionTypedDict]
    ]
    r"""Controls which (if any) tool is called by the model. none means the model won't call any tool and instead generates a message. auto means the model can pick between generating a message or calling one or more tools. required means the model must call one or more tools. Specifying a particular tool via {\"type\": \"function\", \"function\": {\"name\": \"my_function\"}} forces the model to call that tool. none is the default when no tools are present. auto is the default if tools are present."""
    tools: NotRequired[Nullable[List[ToolTypedDict]]]
    r"""A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported."""
    top_logprobs: NotRequired[Nullable[int]]
    r"""An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. logprobs must be set to true if this parameter is used."""
    top_p: NotRequired[Nullable[float]]
    r"""An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We generally recommend altering this or temperature but not both."""
    user: NotRequired[Nullable[str]]
    r"""A unique identifier representing your end-user, which can help to monitor and detect abuse."""


class ChatCompletionRequestStream(BaseModel):
    messages: List[ChatMessage]
    r"""A list of messages comprising the conversation so far. Depending on the model you use, different message types (modalities) are supported, like text, images, and audio."""

    model: str
    r"""Model name used to generate the response, like gpt-4o or deepseek-reasoner. Sudo offers a wide range of models with different capabilities, performance characteristics, and price points. Refer to the [docs](https://docs.sudoapp.dev/overview/models) to browse and compare available models."""

    audio: OptionalNullable[ChatCompletionRequestStreamAudio] = UNSET
    r"""Parameters for audio output. Required when audio output is requested with modalities: [\"audio\"]."""

    frequency_penalty: OptionalNullable[float] = UNSET
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim."""

    logit_bias: OptionalNullable[Dict[str, float]] = UNSET
    r"""Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token."""

    logprobs: OptionalNullable[bool] = UNSET
    r"""Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the content of message."""

    max_completion_tokens: OptionalNullable[int] = UNSET
    r"""An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and reasoning tokens."""

    metadata: OptionalNullable[Dict[str, str]] = UNSET
    r"""Developer-defined tags and values used for filtering completions in the stored completions dashboard."""

    modalities: OptionalNullable[List[ChatCompletionRequestStreamModality]] = UNSET
    r"""Output types that you would like the model to generate for this request. Most models are capable of generating text, which is the default: [\"text\"]. The gpt-4o-audio-preview model can also be used to generate audio. To request that this model generate both text and audio responses, you can use: [\"text\", \"audio\"]."""

    n: OptionalNullable[int] = UNSET
    r"""How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep n as 1 to minimize costs."""

    parallel_tool_calls: OptionalNullable[bool] = UNSET
    r"""Whether to enable parallel function calling during tool use."""

    prediction: OptionalNullable[ChatCompletionRequestStreamPrediction] = UNSET
    r"""Configuration for a Predicted Output, which can greatly improve response times when large parts of the model response are known ahead of time. This is most common when you are regenerating a file with only minor changes to most of the content."""

    presence_penalty: OptionalNullable[float] = UNSET
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics."""

    prompt_cache_key: OptionalNullable[str] = UNSET
    r"""A unique identifier for caching prompts to improve response times for repeated requests."""

    reasoning_effort: OptionalNullable[ChatCompletionRequestStreamReasoningEffort] = (
        UNSET
    )
    r"""o1 models only. Constrains effort on reasoning for reasoning models. Currently supported values are low, medium, and high. Reducing reasoning effort can result in faster responses and fewer tokens used on reasoning in a response."""

    response_format: OptionalNullable[
        ChatCompletionRequestStreamResponseFormatUnion
    ] = UNSET
    r"""An object specifying the format that the model must output. Compatible with GPT-4o, GPT-4o mini, GPT-4 Turbo and all GPT-3.5 Turbo models newer than gpt-3.5-turbo-1106. Setting to { \"type\": \"json_schema\", \"json_schema\": {...} } enables Structured Outputs which guarantee the model will match your supplied JSON schema. Setting to { \"type\": \"json_object\" } enables JSON mode, which guarantees the message the model generates is valid JSON."""

    seed: OptionalNullable[int] = UNSET
    r"""If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism isn't guaranteed, and you should refer to the system_fingerprint response parameter to monitor changes in the backend."""

    service_tier: OptionalNullable[ChatCompletionRequestStreamServiceTier] = UNSET
    r"""Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service."""

    stop: OptionalNullable[List[str]] = UNSET
    r"""Not supported with latest reasoning models o3 and o4-mini. Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence."""

    store: OptionalNullable[bool] = UNSET
    r"""Whether or not to store the output of this chat completion request for use in our model distillation or evaluation products."""

    stream: Optional[bool] = True
    r"""If set, partial message deltas will be sent as server-sent events. For streaming responses, this must be true."""

    stream_options: OptionalNullable[ChatCompletionRequestStreamStreamOptions] = UNSET
    r"""Options for streaming response. Only set this when you set stream: true."""

    temperature: OptionalNullable[float] = UNSET
    r"""What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. We generally recommend altering this or top_p but not both."""

    tool_choice: OptionalNullable[ChatCompletionRequestStreamToolChoiceUnion] = UNSET
    r"""Controls which (if any) tool is called by the model. none means the model won't call any tool and instead generates a message. auto means the model can pick between generating a message or calling one or more tools. required means the model must call one or more tools. Specifying a particular tool via {\"type\": \"function\", \"function\": {\"name\": \"my_function\"}} forces the model to call that tool. none is the default when no tools are present. auto is the default if tools are present."""

    tools: OptionalNullable[List[Tool]] = UNSET
    r"""A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported."""

    top_logprobs: OptionalNullable[int] = UNSET
    r"""An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. logprobs must be set to true if this parameter is used."""

    top_p: OptionalNullable[float] = UNSET
    r"""An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We generally recommend altering this or temperature but not both."""

    user: OptionalNullable[str] = UNSET
    r"""A unique identifier representing your end-user, which can help to monitor and detect abuse."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "audio",
            "frequency_penalty",
            "logit_bias",
            "logprobs",
            "max_completion_tokens",
            "metadata",
            "modalities",
            "n",
            "parallel_tool_calls",
            "prediction",
            "presence_penalty",
            "prompt_cache_key",
            "reasoning_effort",
            "response_format",
            "seed",
            "service_tier",
            "stop",
            "store",
            "stream",
            "stream_options",
            "temperature",
            "tool_choice",
            "tools",
            "top_logprobs",
            "top_p",
            "user",
        ]
        nullable_fields = [
            "audio",
            "frequency_penalty",
            "logit_bias",
            "logprobs",
            "max_completion_tokens",
            "metadata",
            "modalities",
            "n",
            "parallel_tool_calls",
            "prediction",
            "presence_penalty",
            "prompt_cache_key",
            "reasoning_effort",
            "response_format",
            "seed",
            "service_tier",
            "stop",
            "store",
            "stream_options",
            "temperature",
            "tool_choice",
            "tools",
            "top_logprobs",
            "top_p",
            "user",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
