"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from sudo.types import BaseModel
from sudo.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetChatCompletionMessagesRequestTypedDict(TypedDict):
    completion_id: str
    r"""ID of the chat completion"""
    after: NotRequired[str]
    r"""Identifier for the last message from the previous pagination request."""
    limit: NotRequired[int]
    r"""Number of messages to retrieve."""
    order: NotRequired[str]
    r"""Sort order for messages by timestamp. Use asc for ascending order or desc for descending order. Defaults to asc."""


class GetChatCompletionMessagesRequest(BaseModel):
    completion_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the chat completion"""

    after: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Identifier for the last message from the previous pagination request."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Number of messages to retrieve."""

    order: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Sort order for messages by timestamp. Use asc for ascending order or desc for descending order. Defaults to asc."""
