"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chatcompletionchunkchoice import (
    ChatCompletionChunkChoice,
    ChatCompletionChunkChoiceTypedDict,
)
from .usage import Usage, UsageTypedDict
from enum import Enum
from pydantic import model_serializer
from sudo_ai.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class Object(str, Enum):
    r"""The object type, which is always 'chat.completion.chunk'."""

    CHAT_COMPLETION_CHUNK = "chat.completion.chunk"


class DataTypedDict(TypedDict):
    id: str
    r"""A unique identifier for the chat completion."""
    object: Object
    r"""The object type, which is always 'chat.completion.chunk'."""
    created: int
    r"""The Unix timestamp (in seconds) of when the chat completion was created."""
    model: str
    r"""The model used for the chat completion."""
    choices: List[ChatCompletionChunkChoiceTypedDict]
    r"""A list of chat completion choices."""
    system_fingerprint: NotRequired[Nullable[str]]
    r"""This fingerprint represents the backend configuration that the model runs with."""
    usage: NotRequired[UsageTypedDict]


class Data(BaseModel):
    id: str
    r"""A unique identifier for the chat completion."""

    object: Object
    r"""The object type, which is always 'chat.completion.chunk'."""

    created: int
    r"""The Unix timestamp (in seconds) of when the chat completion was created."""

    model: str
    r"""The model used for the chat completion."""

    choices: List[ChatCompletionChunkChoice]
    r"""A list of chat completion choices."""

    system_fingerprint: OptionalNullable[str] = UNSET
    r"""This fingerprint represents the backend configuration that the model runs with."""

    usage: Optional[Usage] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["system_fingerprint", "usage"]
        nullable_fields = ["system_fingerprint"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ChatCompletionChunkTypedDict(TypedDict):
    data: NotRequired[DataTypedDict]


class ChatCompletionChunk(BaseModel):
    data: Optional[Data] = None
