"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chatcompletiondelta import ChatCompletionDelta, ChatCompletionDeltaTypedDict
from enum import Enum
from pydantic import model_serializer
from sudo_ai.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing_extensions import NotRequired, TypedDict


class FinishReason(str, Enum):
    r"""The reason the model stopped generating tokens. This will be 'stop' if the model hit a natural stop point or a provided stop sequence, 'length' if the maximum number of tokens specified in the request was reached, 'tool_calls' if the model called a tool, or 'content_filter' if content was omitted due to a flag from our content filters."""

    STOP = "stop"
    LENGTH = "length"
    TOOL_CALLS = "tool_calls"
    CONTENT_FILTER = "content_filter"


class LogprobsTypedDict(TypedDict):
    r"""Log probability information for the choice."""


class Logprobs(BaseModel):
    r"""Log probability information for the choice."""


class ChatCompletionChunkChoiceTypedDict(TypedDict):
    index: int
    r"""The index of the choice in the list of choices."""
    delta: ChatCompletionDeltaTypedDict
    finish_reason: NotRequired[Nullable[FinishReason]]
    r"""The reason the model stopped generating tokens. This will be 'stop' if the model hit a natural stop point or a provided stop sequence, 'length' if the maximum number of tokens specified in the request was reached, 'tool_calls' if the model called a tool, or 'content_filter' if content was omitted due to a flag from our content filters."""
    logprobs: NotRequired[Nullable[LogprobsTypedDict]]
    r"""Log probability information for the choice."""


class ChatCompletionChunkChoice(BaseModel):
    index: int
    r"""The index of the choice in the list of choices."""

    delta: ChatCompletionDelta

    finish_reason: OptionalNullable[FinishReason] = UNSET
    r"""The reason the model stopped generating tokens. This will be 'stop' if the model hit a natural stop point or a provided stop sequence, 'length' if the maximum number of tokens specified in the request was reached, 'tool_calls' if the model called a tool, or 'content_filter' if content was omitted due to a flag from our content filters."""

    logprobs: OptionalNullable[Logprobs] = UNSET
    r"""Log probability information for the choice."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["finish_reason", "logprobs"]
        nullable_fields = ["finish_reason", "logprobs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
