"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from sudo_ai.types import BaseModel
from typing import Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class FileTypedDict(TypedDict):
    file_data: NotRequired[str]
    r"""The base64 encoded file data, used when passing the file to the model as a string."""
    file_id: NotRequired[str]
    r"""The ID of an uploaded file to use as input."""
    file_name: NotRequired[str]
    r"""The name of the file, used when passing the file to the model as a string."""


class File(BaseModel):
    file_data: Optional[str] = None
    r"""The base64 encoded file data, used when passing the file to the model as a string."""

    file_id: Optional[str] = None
    r"""The ID of an uploaded file to use as input."""

    file_name: Optional[str] = None
    r"""The name of the file, used when passing the file to the model as a string."""


class ContentPart4TypedDict(TypedDict):
    r"""File content part."""

    file: FileTypedDict
    type: str
    r"""The type of the content part. Always file."""


class ContentPart4(BaseModel):
    r"""File content part."""

    file: File

    type: str
    r"""The type of the content part. Always file."""


class InputAudioTypedDict(TypedDict):
    data: str
    r"""Base64 encoded audio data."""
    format_: str
    r"""The format of the encoded audio data. Currently supports wav and mp3."""


class InputAudio(BaseModel):
    data: str
    r"""Base64 encoded audio data."""

    format_: Annotated[str, pydantic.Field(alias="format")]
    r"""The format of the encoded audio data. Currently supports wav and mp3."""


class ContentPart3TypedDict(TypedDict):
    r"""Audio content part."""

    input_audio: InputAudioTypedDict
    type: str
    r"""The type of the content part. Always input_audio."""


class ContentPart3(BaseModel):
    r"""Audio content part."""

    input_audio: InputAudio

    type: str
    r"""The type of the content part. Always input_audio."""


class ImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded image data."""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image."""


class ImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded image data."""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image."""


class ContentPart2TypedDict(TypedDict):
    r"""Image content part."""

    image_url: ImageURLTypedDict
    type: str


class ContentPart2(BaseModel):
    r"""Image content part."""

    image_url: ImageURL

    type: str


class ContentPart1TypedDict(TypedDict):
    r"""Text content part."""

    text: str
    type: str


class ContentPart1(BaseModel):
    r"""Text content part."""

    text: str

    type: str


ContentPartUnionTypedDict = TypeAliasType(
    "ContentPartUnionTypedDict",
    Union[
        ContentPart1TypedDict,
        ContentPart2TypedDict,
        ContentPart3TypedDict,
        ContentPart4TypedDict,
    ],
)


ContentPartUnion = TypeAliasType(
    "ContentPartUnion", Union[ContentPart1, ContentPart2, ContentPart3, ContentPart4]
)
