"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from sudo_ai.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing_extensions import NotRequired, TypedDict


class ImageDataTypedDict(TypedDict):
    b64_json: NotRequired[Nullable[str]]
    r"""The base64-encoded JSON of the generated image, if response_format is b64_json."""
    revised_prompt: NotRequired[Nullable[str]]
    r"""The prompt that was used to generate the image, if there was any revision to the prompt."""
    url: NotRequired[Nullable[str]]
    r"""The URL of the generated image, if response_format is url (default)."""


class ImageData(BaseModel):
    b64_json: OptionalNullable[str] = UNSET
    r"""The base64-encoded JSON of the generated image, if response_format is b64_json."""

    revised_prompt: OptionalNullable[str] = UNSET
    r"""The prompt that was used to generate the image, if there was any revision to the prompt."""

    url: OptionalNullable[str] = UNSET
    r"""The URL of the generated image, if response_format is url (default)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["b64_json", "revised_prompt", "url"]
        nullable_fields = ["b64_json", "revised_prompt", "url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
