"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .imagedata import ImageData, ImageDataTypedDict
from .imageusage import ImageUsage, ImageUsageTypedDict
from pydantic import model_serializer
from sudo_ai.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ImageGenerationTypedDict(TypedDict):
    data: List[ImageDataTypedDict]
    r"""The list of generated images."""
    background: NotRequired[Nullable[str]]
    r"""Background settings used in generation (OpenAI only)"""
    created: NotRequired[Nullable[int]]
    r"""The Unix timestamp (in seconds) of when the image was created."""
    output_format: NotRequired[Nullable[str]]
    r"""The output format of the generated image (OpenAI only)"""
    quality: NotRequired[Nullable[str]]
    r"""The quality setting used for generation (OpenAI only)"""
    size: NotRequired[Nullable[str]]
    r"""The size of the generated image (OpenAI only)"""
    usage: NotRequired[ImageUsageTypedDict]


class ImageGeneration(BaseModel):
    data: List[ImageData]
    r"""The list of generated images."""

    background: OptionalNullable[str] = UNSET
    r"""Background settings used in generation (OpenAI only)"""

    created: OptionalNullable[int] = UNSET
    r"""The Unix timestamp (in seconds) of when the image was created."""

    output_format: OptionalNullable[str] = UNSET
    r"""The output format of the generated image (OpenAI only)"""

    quality: OptionalNullable[str] = UNSET
    r"""The quality setting used for generation (OpenAI only)"""

    size: OptionalNullable[str] = UNSET
    r"""The size of the generated image (OpenAI only)"""

    usage: Optional[ImageUsage] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "background",
            "created",
            "output_format",
            "quality",
            "size",
            "usage",
        ]
        nullable_fields = ["background", "created", "output_format", "quality", "size"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
