"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import model_serializer
from sudo_ai.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from typing_extensions import NotRequired, TypedDict


class ResponseFormatEnum(str, Enum):
    r"""The format in which the generated images are returned. Must be one of url or b64_json. URLs are only valid for 60 minutes after the image has been generated."""

    URL = "url"
    B64_JSON = "b64_json"


class Quality(str, Enum):
    r"""The quality of the image that will be generated. hd creates images with finer details and greater consistency across the image. This param is only supported for dall-e-3."""

    STANDARD = "standard"
    HD = "hd"


class Size(str, Enum):
    r"""The size of the generated images. Must be one of 256x256, 512x512, or 1024x1024 for dall-e-2. Must be one of 1024x1024, 1792x1024, or 1024x1792 for dall-e-3 models."""

    TWO_HUNDRED_AND_FIFTY_SIXX256 = "256x256"
    FIVE_HUNDRED_AND_TWELVEX512 = "512x512"
    ONE_THOUSAND_AND_TWENTY_FOURX1024 = "1024x1024"
    ONE_THOUSAND_SEVEN_HUNDRED_AND_NINETY_TWOX1024 = "1792x1024"
    ONE_THOUSAND_AND_TWENTY_FOURX1792 = "1024x1792"


class Style(str, Enum):
    r"""The style of the generated images. Must be one of vivid or natural. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for dall-e-3."""

    VIVID = "vivid"
    NATURAL = "natural"


class ImageGenerationRequestTypedDict(TypedDict):
    prompt: str
    r"""A text description of the desired image(s). The maximum length is 1000 characters for dall-e-2 and 4000 characters for dall-e-3."""
    model: str
    r"""The model to use for image generation."""
    n: NotRequired[Nullable[int]]
    r"""The number of images to generate. Must be between 1 and 10. For dall-e-3, only n=1 is supported."""
    response_format: NotRequired[Nullable[ResponseFormatEnum]]
    r"""The format in which the generated images are returned. Must be one of url or b64_json. URLs are only valid for 60 minutes after the image has been generated."""
    quality: NotRequired[Nullable[Quality]]
    r"""The quality of the image that will be generated. hd creates images with finer details and greater consistency across the image. This param is only supported for dall-e-3."""
    size: NotRequired[Nullable[Size]]
    r"""The size of the generated images. Must be one of 256x256, 512x512, or 1024x1024 for dall-e-2. Must be one of 1024x1024, 1792x1024, or 1024x1792 for dall-e-3 models."""
    style: NotRequired[Nullable[Style]]
    r"""The style of the generated images. Must be one of vivid or natural. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for dall-e-3."""
    background: NotRequired[Nullable[str]]
    r"""OpenAI only: Specify the background removal for the generated image."""
    moderation: NotRequired[Nullable[str]]
    r"""OpenAI only: Content moderation settings for the image generation."""
    output_compression: NotRequired[Nullable[int]]
    r"""OpenAI only: Compression level for the output image, from 0 to 100."""
    output_format: NotRequired[Nullable[str]]
    r"""OpenAI only: The output format for the generated image."""


class ImageGenerationRequest(BaseModel):
    prompt: str
    r"""A text description of the desired image(s). The maximum length is 1000 characters for dall-e-2 and 4000 characters for dall-e-3."""

    model: str
    r"""The model to use for image generation."""

    n: OptionalNullable[int] = UNSET
    r"""The number of images to generate. Must be between 1 and 10. For dall-e-3, only n=1 is supported."""

    response_format: OptionalNullable[ResponseFormatEnum] = UNSET
    r"""The format in which the generated images are returned. Must be one of url or b64_json. URLs are only valid for 60 minutes after the image has been generated."""

    quality: OptionalNullable[Quality] = UNSET
    r"""The quality of the image that will be generated. hd creates images with finer details and greater consistency across the image. This param is only supported for dall-e-3."""

    size: OptionalNullable[Size] = UNSET
    r"""The size of the generated images. Must be one of 256x256, 512x512, or 1024x1024 for dall-e-2. Must be one of 1024x1024, 1792x1024, or 1024x1792 for dall-e-3 models."""

    style: OptionalNullable[Style] = UNSET
    r"""The style of the generated images. Must be one of vivid or natural. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for dall-e-3."""

    background: OptionalNullable[str] = UNSET
    r"""OpenAI only: Specify the background removal for the generated image."""

    moderation: OptionalNullable[str] = UNSET
    r"""OpenAI only: Content moderation settings for the image generation."""

    output_compression: OptionalNullable[int] = UNSET
    r"""OpenAI only: Compression level for the output image, from 0 to 100."""

    output_format: OptionalNullable[str] = UNSET
    r"""OpenAI only: The output format for the generated image."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "n",
            "response_format",
            "quality",
            "size",
            "style",
            "background",
            "moderation",
            "output_compression",
            "output_format",
        ]
        nullable_fields = [
            "n",
            "response_format",
            "quality",
            "size",
            "style",
            "background",
            "moderation",
            "output_compression",
            "output_format",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
