"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from sudo_ai.types import BaseModel
from sudo_ai.utils import FieldMetadata, QueryParamMetadata
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListChatCompletionsRequestTypedDict(TypedDict):
    after: NotRequired[str]
    r"""Identifier for the last chat completion from the previous pagination request."""
    limit: NotRequired[int]
    r"""Number of Chat Completions to retrieve."""
    metadata: NotRequired[Dict[str, str]]
    r"""A list of metadata keys to filter the Chat Completions by. Example: metadata[key1]=value1&metadata[key2]=value2"""
    model: NotRequired[str]
    r"""The model used to generate the Chat Completions."""
    order: NotRequired[str]
    r"""Sort order for Chat Completions by timestamp. Use asc for ascending order or desc for descending order. Defaults to asc."""


class ListChatCompletionsRequest(BaseModel):
    after: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Identifier for the last chat completion from the previous pagination request."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Number of Chat Completions to retrieve."""

    metadata: Annotated[
        Optional[Dict[str, str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A list of metadata keys to filter the Chat Completions by. Example: metadata[key1]=value1&metadata[key2]=value2"""

    model: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The model used to generate the Chat Completions."""

    order: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Sort order for Chat Completions by timestamp. Use asc for ascending order or desc for descending order. Defaults to asc."""
