"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from sudo_ai import errors, models, utils
from sudo_ai._hooks import HookContext
from sudo_ai.types import OptionalNullable, UNSET
from sudo_ai.utils import eventstreaming, get_security_from_env
from sudo_ai.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Dict, List, Mapping, Optional, Union


class Router(BaseSDK):
    def list_chat_completions(
        self,
        *,
        after: Optional[str] = None,
        limit: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        model: Optional[str] = None,
        order: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatCompletionList:
        r"""*[OpenAI Only]* Get a list of saved Chat Completions. Only Chat Completions that have been stored with the `store` parameter set to true will be returned.

        :param after: Identifier for the last chat completion from the previous pagination request.
        :param limit: Number of Chat Completions to retrieve.
        :param metadata: A list of metadata keys to filter the Chat Completions by. Example: metadata[key1]=value1&metadata[key2]=value2
        :param model: The model used to generate the Chat Completions.
        :param order: Sort order for Chat Completions by timestamp. Use asc for ascending order or desc for descending order. Defaults to asc.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListChatCompletionsRequest(
            after=after,
            limit=limit,
            metadata=metadata,
            model=model,
            order=order,
        )

        req = self._build_request(
            method="GET",
            path="/v1/chat/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="listChatCompletions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatCompletionList, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    async def list_chat_completions_async(
        self,
        *,
        after: Optional[str] = None,
        limit: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        model: Optional[str] = None,
        order: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatCompletionList:
        r"""*[OpenAI Only]* Get a list of saved Chat Completions. Only Chat Completions that have been stored with the `store` parameter set to true will be returned.

        :param after: Identifier for the last chat completion from the previous pagination request.
        :param limit: Number of Chat Completions to retrieve.
        :param metadata: A list of metadata keys to filter the Chat Completions by. Example: metadata[key1]=value1&metadata[key2]=value2
        :param model: The model used to generate the Chat Completions.
        :param order: Sort order for Chat Completions by timestamp. Use asc for ascending order or desc for descending order. Defaults to asc.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListChatCompletionsRequest(
            after=after,
            limit=limit,
            metadata=metadata,
            model=model,
            order=order,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/chat/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="listChatCompletions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatCompletionList, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    def create(
        self,
        *,
        messages: Union[List[models.ChatMessage], List[models.ChatMessageTypedDict]],
        model: str,
        audio: OptionalNullable[
            Union[
                models.ChatCompletionRequestJSONAudio,
                models.ChatCompletionRequestJSONAudioTypedDict,
            ]
        ] = UNSET,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        max_completion_tokens: OptionalNullable[int] = UNSET,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        modalities: OptionalNullable[
            List[models.ChatCompletionRequestJSONModality]
        ] = UNSET,
        n: OptionalNullable[int] = UNSET,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        prediction: OptionalNullable[
            Union[
                models.ChatCompletionRequestJSONPrediction,
                models.ChatCompletionRequestJSONPredictionTypedDict,
            ]
        ] = UNSET,
        presence_penalty: OptionalNullable[float] = UNSET,
        prompt_cache_key: OptionalNullable[str] = UNSET,
        reasoning_effort: OptionalNullable[
            models.ChatCompletionRequestJSONReasoningEffort
        ] = UNSET,
        response_format: OptionalNullable[
            Union[
                models.ChatCompletionRequestJSONResponseFormatUnion,
                models.ChatCompletionRequestJSONResponseFormatUnionTypedDict,
            ]
        ] = UNSET,
        seed: OptionalNullable[int] = UNSET,
        service_tier: OptionalNullable[
            models.ChatCompletionRequestJSONServiceTier
        ] = UNSET,
        stop: OptionalNullable[List[str]] = UNSET,
        store: OptionalNullable[bool] = UNSET,
        stream: Optional[bool] = False,
        stream_options: OptionalNullable[
            Union[
                models.ChatCompletionRequestJSONStreamOptions,
                models.ChatCompletionRequestJSONStreamOptionsTypedDict,
            ]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: OptionalNullable[
            Union[
                models.ChatCompletionRequestJSONToolChoiceUnion,
                models.ChatCompletionRequestJSONToolChoiceUnionTypedDict,
            ]
        ] = UNSET,
        tools: OptionalNullable[
            Union[List[models.Tool], List[models.ToolTypedDict]]
        ] = UNSET,
        top_logprobs: OptionalNullable[int] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatCompletion:
        r"""Create a model response for the given string of prompts.

        :param messages: A list of messages comprising the conversation so far. Depending on the model you use, different message types (modalities) are supported, like text, images, and audio.
        :param model: Model name used to generate the response, like gpt-4o or deepseek-reasoner. Sudo offers a wide range of models with different capabilities, performance characteristics, and price points. Refer to the [docs](https://docs.sudoapp.dev/overview/models) to browse and compare available models.
        :param audio: Parameters for audio output. Required when audio output is requested with modalities: [\"audio\"].
        :param frequency_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
        :param logit_bias: Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
        :param logprobs: Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the content of message.
        :param max_completion_tokens: An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and reasoning tokens.
        :param metadata: Developer-defined tags and values used for filtering completions in the stored completions dashboard.
        :param modalities: Output types that you would like the model to generate for this request. Most models are capable of generating text, which is the default: [\"text\"]. The gpt-4o-audio-preview model can also be used to generate audio. To request that this model generate both text and audio responses, you can use: [\"text\", \"audio\"].
        :param n: How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep n as 1 to minimize costs.
        :param parallel_tool_calls: Whether to enable parallel function calling during tool use.
        :param prediction: Configuration for a Predicted Output, which can greatly improve response times when large parts of the model response are known ahead of time. This is most common when you are regenerating a file with only minor changes to most of the content.
        :param presence_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
        :param prompt_cache_key: A unique identifier for caching prompts to improve response times for repeated requests.
        :param reasoning_effort: o1 models only. Constrains effort on reasoning for reasoning models. Currently supported values are low, medium, and high. Reducing reasoning effort can result in faster responses and fewer tokens used on reasoning in a response.
        :param response_format: An object specifying the format that the model must output. Compatible with GPT-4o, GPT-4o mini, GPT-4 Turbo and all GPT-3.5 Turbo models newer than gpt-3.5-turbo-1106. Setting to { \"type\": \"json_schema\", \"json_schema\": {...} } enables Structured Outputs which guarantee the model will match your supplied JSON schema. Setting to { \"type\": \"json_object\" } enables JSON mode, which guarantees the message the model generates is valid JSON.
        :param seed: If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism isn't guaranteed, and you should refer to the system_fingerprint response parameter to monitor changes in the backend.
        :param service_tier: Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service.
        :param stop: Not supported with latest reasoning models o3 and o4-mini. Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
        :param store: Whether or not to store the output of this chat completion request for use in our model distillation or evaluation products.
        :param stream: If set, partial message deltas will be sent, like in ChatGPT. For JSON responses, this must be false.
        :param stream_options: Options for streaming response. Only set this when you set stream: true.
        :param temperature: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. We generally recommend altering this or top_p but not both.
        :param tool_choice: Controls which (if any) tool is called by the model. none means the model won't call any tool and instead generates a message. auto means the model can pick between generating a message or calling one or more tools. required means the model must call one or more tools. Specifying a particular tool via {\"type\": \"function\", \"function\": {\"name\": \"my_function\"}} forces the model to call that tool. none is the default when no tools are present. auto is the default if tools are present.
        :param tools: A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.
        :param top_logprobs: An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. logprobs must be set to true if this parameter is used.
        :param top_p: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We generally recommend altering this or temperature but not both.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ChatCompletionRequestJSON(
            audio=utils.get_pydantic_model(
                audio, OptionalNullable[models.ChatCompletionRequestJSONAudio]
            ),
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            logprobs=logprobs,
            max_completion_tokens=max_completion_tokens,
            messages=utils.get_pydantic_model(messages, List[models.ChatMessage]),
            metadata=metadata,
            modalities=modalities,
            model=model,
            n=n,
            parallel_tool_calls=parallel_tool_calls,
            prediction=utils.get_pydantic_model(
                prediction, OptionalNullable[models.ChatCompletionRequestJSONPrediction]
            ),
            presence_penalty=presence_penalty,
            prompt_cache_key=prompt_cache_key,
            reasoning_effort=reasoning_effort,
            response_format=utils.get_pydantic_model(
                response_format,
                OptionalNullable[models.ChatCompletionRequestJSONResponseFormatUnion],
            ),
            seed=seed,
            service_tier=service_tier,
            stop=stop,
            store=store,
            stream=stream,
            stream_options=utils.get_pydantic_model(
                stream_options,
                OptionalNullable[models.ChatCompletionRequestJSONStreamOptions],
            ),
            temperature=temperature,
            tool_choice=utils.get_pydantic_model(
                tool_choice,
                OptionalNullable[models.ChatCompletionRequestJSONToolChoiceUnion],
            ),
            tools=utils.get_pydantic_model(tools, OptionalNullable[List[models.Tool]]),
            top_logprobs=top_logprobs,
            top_p=top_p,
        )

        req = self._build_request(
            method="POST",
            path="/v1/chat/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ChatCompletionRequestJSON
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatCompletion, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        messages: Union[List[models.ChatMessage], List[models.ChatMessageTypedDict]],
        model: str,
        audio: OptionalNullable[
            Union[
                models.ChatCompletionRequestJSONAudio,
                models.ChatCompletionRequestJSONAudioTypedDict,
            ]
        ] = UNSET,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        max_completion_tokens: OptionalNullable[int] = UNSET,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        modalities: OptionalNullable[
            List[models.ChatCompletionRequestJSONModality]
        ] = UNSET,
        n: OptionalNullable[int] = UNSET,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        prediction: OptionalNullable[
            Union[
                models.ChatCompletionRequestJSONPrediction,
                models.ChatCompletionRequestJSONPredictionTypedDict,
            ]
        ] = UNSET,
        presence_penalty: OptionalNullable[float] = UNSET,
        prompt_cache_key: OptionalNullable[str] = UNSET,
        reasoning_effort: OptionalNullable[
            models.ChatCompletionRequestJSONReasoningEffort
        ] = UNSET,
        response_format: OptionalNullable[
            Union[
                models.ChatCompletionRequestJSONResponseFormatUnion,
                models.ChatCompletionRequestJSONResponseFormatUnionTypedDict,
            ]
        ] = UNSET,
        seed: OptionalNullable[int] = UNSET,
        service_tier: OptionalNullable[
            models.ChatCompletionRequestJSONServiceTier
        ] = UNSET,
        stop: OptionalNullable[List[str]] = UNSET,
        store: OptionalNullable[bool] = UNSET,
        stream: Optional[bool] = False,
        stream_options: OptionalNullable[
            Union[
                models.ChatCompletionRequestJSONStreamOptions,
                models.ChatCompletionRequestJSONStreamOptionsTypedDict,
            ]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: OptionalNullable[
            Union[
                models.ChatCompletionRequestJSONToolChoiceUnion,
                models.ChatCompletionRequestJSONToolChoiceUnionTypedDict,
            ]
        ] = UNSET,
        tools: OptionalNullable[
            Union[List[models.Tool], List[models.ToolTypedDict]]
        ] = UNSET,
        top_logprobs: OptionalNullable[int] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatCompletion:
        r"""Create a model response for the given string of prompts.

        :param messages: A list of messages comprising the conversation so far. Depending on the model you use, different message types (modalities) are supported, like text, images, and audio.
        :param model: Model name used to generate the response, like gpt-4o or deepseek-reasoner. Sudo offers a wide range of models with different capabilities, performance characteristics, and price points. Refer to the [docs](https://docs.sudoapp.dev/overview/models) to browse and compare available models.
        :param audio: Parameters for audio output. Required when audio output is requested with modalities: [\"audio\"].
        :param frequency_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
        :param logit_bias: Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
        :param logprobs: Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the content of message.
        :param max_completion_tokens: An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and reasoning tokens.
        :param metadata: Developer-defined tags and values used for filtering completions in the stored completions dashboard.
        :param modalities: Output types that you would like the model to generate for this request. Most models are capable of generating text, which is the default: [\"text\"]. The gpt-4o-audio-preview model can also be used to generate audio. To request that this model generate both text and audio responses, you can use: [\"text\", \"audio\"].
        :param n: How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep n as 1 to minimize costs.
        :param parallel_tool_calls: Whether to enable parallel function calling during tool use.
        :param prediction: Configuration for a Predicted Output, which can greatly improve response times when large parts of the model response are known ahead of time. This is most common when you are regenerating a file with only minor changes to most of the content.
        :param presence_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
        :param prompt_cache_key: A unique identifier for caching prompts to improve response times for repeated requests.
        :param reasoning_effort: o1 models only. Constrains effort on reasoning for reasoning models. Currently supported values are low, medium, and high. Reducing reasoning effort can result in faster responses and fewer tokens used on reasoning in a response.
        :param response_format: An object specifying the format that the model must output. Compatible with GPT-4o, GPT-4o mini, GPT-4 Turbo and all GPT-3.5 Turbo models newer than gpt-3.5-turbo-1106. Setting to { \"type\": \"json_schema\", \"json_schema\": {...} } enables Structured Outputs which guarantee the model will match your supplied JSON schema. Setting to { \"type\": \"json_object\" } enables JSON mode, which guarantees the message the model generates is valid JSON.
        :param seed: If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism isn't guaranteed, and you should refer to the system_fingerprint response parameter to monitor changes in the backend.
        :param service_tier: Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service.
        :param stop: Not supported with latest reasoning models o3 and o4-mini. Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
        :param store: Whether or not to store the output of this chat completion request for use in our model distillation or evaluation products.
        :param stream: If set, partial message deltas will be sent, like in ChatGPT. For JSON responses, this must be false.
        :param stream_options: Options for streaming response. Only set this when you set stream: true.
        :param temperature: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. We generally recommend altering this or top_p but not both.
        :param tool_choice: Controls which (if any) tool is called by the model. none means the model won't call any tool and instead generates a message. auto means the model can pick between generating a message or calling one or more tools. required means the model must call one or more tools. Specifying a particular tool via {\"type\": \"function\", \"function\": {\"name\": \"my_function\"}} forces the model to call that tool. none is the default when no tools are present. auto is the default if tools are present.
        :param tools: A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.
        :param top_logprobs: An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. logprobs must be set to true if this parameter is used.
        :param top_p: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We generally recommend altering this or temperature but not both.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ChatCompletionRequestJSON(
            audio=utils.get_pydantic_model(
                audio, OptionalNullable[models.ChatCompletionRequestJSONAudio]
            ),
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            logprobs=logprobs,
            max_completion_tokens=max_completion_tokens,
            messages=utils.get_pydantic_model(messages, List[models.ChatMessage]),
            metadata=metadata,
            modalities=modalities,
            model=model,
            n=n,
            parallel_tool_calls=parallel_tool_calls,
            prediction=utils.get_pydantic_model(
                prediction, OptionalNullable[models.ChatCompletionRequestJSONPrediction]
            ),
            presence_penalty=presence_penalty,
            prompt_cache_key=prompt_cache_key,
            reasoning_effort=reasoning_effort,
            response_format=utils.get_pydantic_model(
                response_format,
                OptionalNullable[models.ChatCompletionRequestJSONResponseFormatUnion],
            ),
            seed=seed,
            service_tier=service_tier,
            stop=stop,
            store=store,
            stream=stream,
            stream_options=utils.get_pydantic_model(
                stream_options,
                OptionalNullable[models.ChatCompletionRequestJSONStreamOptions],
            ),
            temperature=temperature,
            tool_choice=utils.get_pydantic_model(
                tool_choice,
                OptionalNullable[models.ChatCompletionRequestJSONToolChoiceUnion],
            ),
            tools=utils.get_pydantic_model(tools, OptionalNullable[List[models.Tool]]),
            top_logprobs=top_logprobs,
            top_p=top_p,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/chat/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ChatCompletionRequestJSON
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatCompletion, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    def create_streaming(
        self,
        *,
        messages: Union[List[models.ChatMessage], List[models.ChatMessageTypedDict]],
        model: str,
        audio: OptionalNullable[
            Union[
                models.ChatCompletionRequestStreamAudio,
                models.ChatCompletionRequestStreamAudioTypedDict,
            ]
        ] = UNSET,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        max_completion_tokens: OptionalNullable[int] = UNSET,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        modalities: OptionalNullable[
            List[models.ChatCompletionRequestStreamModality]
        ] = UNSET,
        n: OptionalNullable[int] = UNSET,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        prediction: OptionalNullable[
            Union[
                models.ChatCompletionRequestStreamPrediction,
                models.ChatCompletionRequestStreamPredictionTypedDict,
            ]
        ] = UNSET,
        presence_penalty: OptionalNullable[float] = UNSET,
        prompt_cache_key: OptionalNullable[str] = UNSET,
        reasoning_effort: OptionalNullable[
            models.ChatCompletionRequestStreamReasoningEffort
        ] = UNSET,
        response_format: OptionalNullable[
            Union[
                models.ChatCompletionRequestStreamResponseFormatUnion,
                models.ChatCompletionRequestStreamResponseFormatUnionTypedDict,
            ]
        ] = UNSET,
        seed: OptionalNullable[int] = UNSET,
        service_tier: OptionalNullable[
            models.ChatCompletionRequestStreamServiceTier
        ] = UNSET,
        stop: OptionalNullable[List[str]] = UNSET,
        store: OptionalNullable[bool] = UNSET,
        stream: Optional[bool] = True,
        stream_options: OptionalNullable[
            Union[
                models.ChatCompletionRequestStreamStreamOptions,
                models.ChatCompletionRequestStreamStreamOptionsTypedDict,
            ]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: OptionalNullable[
            Union[
                models.ChatCompletionRequestStreamToolChoiceUnion,
                models.ChatCompletionRequestStreamToolChoiceUnionTypedDict,
            ]
        ] = UNSET,
        tools: OptionalNullable[
            Union[List[models.Tool], List[models.ToolTypedDict]]
        ] = UNSET,
        top_logprobs: OptionalNullable[int] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        user: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> eventstreaming.EventStream[models.ChatCompletionChunk]:
        r"""Create a streaming model response for the given string of prompts using server-sent events.

        :param messages: A list of messages comprising the conversation so far. Depending on the model you use, different message types (modalities) are supported, like text, images, and audio.
        :param model: Model name used to generate the response, like gpt-4o or deepseek-reasoner. Sudo offers a wide range of models with different capabilities, performance characteristics, and price points. Refer to the [docs](https://docs.sudoapp.dev/overview/models) to browse and compare available models.
        :param audio: Parameters for audio output. Required when audio output is requested with modalities: [\"audio\"].
        :param frequency_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
        :param logit_bias: Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
        :param logprobs: Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the content of message.
        :param max_completion_tokens: An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and reasoning tokens.
        :param metadata: Developer-defined tags and values used for filtering completions in the stored completions dashboard.
        :param modalities: Output types that you would like the model to generate for this request. Most models are capable of generating text, which is the default: [\"text\"]. The gpt-4o-audio-preview model can also be used to generate audio. To request that this model generate both text and audio responses, you can use: [\"text\", \"audio\"].
        :param n: How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep n as 1 to minimize costs.
        :param parallel_tool_calls: Whether to enable parallel function calling during tool use.
        :param prediction: Configuration for a Predicted Output, which can greatly improve response times when large parts of the model response are known ahead of time. This is most common when you are regenerating a file with only minor changes to most of the content.
        :param presence_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
        :param prompt_cache_key: A unique identifier for caching prompts to improve response times for repeated requests.
        :param reasoning_effort: o1 models only. Constrains effort on reasoning for reasoning models. Currently supported values are low, medium, and high. Reducing reasoning effort can result in faster responses and fewer tokens used on reasoning in a response.
        :param response_format: An object specifying the format that the model must output. Compatible with GPT-4o, GPT-4o mini, GPT-4 Turbo and all GPT-3.5 Turbo models newer than gpt-3.5-turbo-1106. Setting to { \"type\": \"json_schema\", \"json_schema\": {...} } enables Structured Outputs which guarantee the model will match your supplied JSON schema. Setting to { \"type\": \"json_object\" } enables JSON mode, which guarantees the message the model generates is valid JSON.
        :param seed: If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism isn't guaranteed, and you should refer to the system_fingerprint response parameter to monitor changes in the backend.
        :param service_tier: Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service.
        :param stop: Not supported with latest reasoning models o3 and o4-mini. Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
        :param store: Whether or not to store the output of this chat completion request for use in our model distillation or evaluation products.
        :param stream: If set, partial message deltas will be sent as server-sent events. For streaming responses, this must be true.
        :param stream_options: Options for streaming response. Only set this when you set stream: true.
        :param temperature: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. We generally recommend altering this or top_p but not both.
        :param tool_choice: Controls which (if any) tool is called by the model. none means the model won't call any tool and instead generates a message. auto means the model can pick between generating a message or calling one or more tools. required means the model must call one or more tools. Specifying a particular tool via {\"type\": \"function\", \"function\": {\"name\": \"my_function\"}} forces the model to call that tool. none is the default when no tools are present. auto is the default if tools are present.
        :param tools: A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.
        :param top_logprobs: An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. logprobs must be set to true if this parameter is used.
        :param top_p: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We generally recommend altering this or temperature but not both.
        :param user: A unique identifier representing your end-user, which can help to monitor and detect abuse.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ChatCompletionRequestStream(
            audio=utils.get_pydantic_model(
                audio, OptionalNullable[models.ChatCompletionRequestStreamAudio]
            ),
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            logprobs=logprobs,
            max_completion_tokens=max_completion_tokens,
            messages=utils.get_pydantic_model(messages, List[models.ChatMessage]),
            metadata=metadata,
            modalities=modalities,
            model=model,
            n=n,
            parallel_tool_calls=parallel_tool_calls,
            prediction=utils.get_pydantic_model(
                prediction,
                OptionalNullable[models.ChatCompletionRequestStreamPrediction],
            ),
            presence_penalty=presence_penalty,
            prompt_cache_key=prompt_cache_key,
            reasoning_effort=reasoning_effort,
            response_format=utils.get_pydantic_model(
                response_format,
                OptionalNullable[models.ChatCompletionRequestStreamResponseFormatUnion],
            ),
            seed=seed,
            service_tier=service_tier,
            stop=stop,
            store=store,
            stream=stream,
            stream_options=utils.get_pydantic_model(
                stream_options,
                OptionalNullable[models.ChatCompletionRequestStreamStreamOptions],
            ),
            temperature=temperature,
            tool_choice=utils.get_pydantic_model(
                tool_choice,
                OptionalNullable[models.ChatCompletionRequestStreamToolChoiceUnion],
            ),
            tools=utils.get_pydantic_model(tools, OptionalNullable[List[models.Tool]]),
            top_logprobs=top_logprobs,
            top_p=top_p,
            user=user,
        )

        req = self._build_request(
            method="POST",
            path="/v1/chat/completions#stream",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="text/event-stream",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ChatCompletionRequestStream
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createStreaming",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.EventStream(
                http_res,
                lambda raw: utils.unmarshal_json(raw, models.ChatCompletionChunk),
                sentinel="[DONE]",
            )
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.ErrorResponseData, http_res, http_res_text
            )
            raise errors.ErrorResponse(response_data, http_res, http_res_text)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.ErrorResponseData, http_res, http_res_text
            )
            raise errors.ErrorResponse(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        http_res_text = utils.stream_to_text(http_res)
        raise errors.SudoDefaultError(
            "Unexpected response received", http_res, http_res_text
        )

    async def create_streaming_async(
        self,
        *,
        messages: Union[List[models.ChatMessage], List[models.ChatMessageTypedDict]],
        model: str,
        audio: OptionalNullable[
            Union[
                models.ChatCompletionRequestStreamAudio,
                models.ChatCompletionRequestStreamAudioTypedDict,
            ]
        ] = UNSET,
        frequency_penalty: OptionalNullable[float] = UNSET,
        logit_bias: OptionalNullable[Dict[str, float]] = UNSET,
        logprobs: OptionalNullable[bool] = UNSET,
        max_completion_tokens: OptionalNullable[int] = UNSET,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        modalities: OptionalNullable[
            List[models.ChatCompletionRequestStreamModality]
        ] = UNSET,
        n: OptionalNullable[int] = UNSET,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        prediction: OptionalNullable[
            Union[
                models.ChatCompletionRequestStreamPrediction,
                models.ChatCompletionRequestStreamPredictionTypedDict,
            ]
        ] = UNSET,
        presence_penalty: OptionalNullable[float] = UNSET,
        prompt_cache_key: OptionalNullable[str] = UNSET,
        reasoning_effort: OptionalNullable[
            models.ChatCompletionRequestStreamReasoningEffort
        ] = UNSET,
        response_format: OptionalNullable[
            Union[
                models.ChatCompletionRequestStreamResponseFormatUnion,
                models.ChatCompletionRequestStreamResponseFormatUnionTypedDict,
            ]
        ] = UNSET,
        seed: OptionalNullable[int] = UNSET,
        service_tier: OptionalNullable[
            models.ChatCompletionRequestStreamServiceTier
        ] = UNSET,
        stop: OptionalNullable[List[str]] = UNSET,
        store: OptionalNullable[bool] = UNSET,
        stream: Optional[bool] = True,
        stream_options: OptionalNullable[
            Union[
                models.ChatCompletionRequestStreamStreamOptions,
                models.ChatCompletionRequestStreamStreamOptionsTypedDict,
            ]
        ] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        tool_choice: OptionalNullable[
            Union[
                models.ChatCompletionRequestStreamToolChoiceUnion,
                models.ChatCompletionRequestStreamToolChoiceUnionTypedDict,
            ]
        ] = UNSET,
        tools: OptionalNullable[
            Union[List[models.Tool], List[models.ToolTypedDict]]
        ] = UNSET,
        top_logprobs: OptionalNullable[int] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        user: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> eventstreaming.EventStreamAsync[models.ChatCompletionChunk]:
        r"""Create a streaming model response for the given string of prompts using server-sent events.

        :param messages: A list of messages comprising the conversation so far. Depending on the model you use, different message types (modalities) are supported, like text, images, and audio.
        :param model: Model name used to generate the response, like gpt-4o or deepseek-reasoner. Sudo offers a wide range of models with different capabilities, performance characteristics, and price points. Refer to the [docs](https://docs.sudoapp.dev/overview/models) to browse and compare available models.
        :param audio: Parameters for audio output. Required when audio output is requested with modalities: [\"audio\"].
        :param frequency_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
        :param logit_bias: Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
        :param logprobs: Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the content of message.
        :param max_completion_tokens: An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and reasoning tokens.
        :param metadata: Developer-defined tags and values used for filtering completions in the stored completions dashboard.
        :param modalities: Output types that you would like the model to generate for this request. Most models are capable of generating text, which is the default: [\"text\"]. The gpt-4o-audio-preview model can also be used to generate audio. To request that this model generate both text and audio responses, you can use: [\"text\", \"audio\"].
        :param n: How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep n as 1 to minimize costs.
        :param parallel_tool_calls: Whether to enable parallel function calling during tool use.
        :param prediction: Configuration for a Predicted Output, which can greatly improve response times when large parts of the model response are known ahead of time. This is most common when you are regenerating a file with only minor changes to most of the content.
        :param presence_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
        :param prompt_cache_key: A unique identifier for caching prompts to improve response times for repeated requests.
        :param reasoning_effort: o1 models only. Constrains effort on reasoning for reasoning models. Currently supported values are low, medium, and high. Reducing reasoning effort can result in faster responses and fewer tokens used on reasoning in a response.
        :param response_format: An object specifying the format that the model must output. Compatible with GPT-4o, GPT-4o mini, GPT-4 Turbo and all GPT-3.5 Turbo models newer than gpt-3.5-turbo-1106. Setting to { \"type\": \"json_schema\", \"json_schema\": {...} } enables Structured Outputs which guarantee the model will match your supplied JSON schema. Setting to { \"type\": \"json_object\" } enables JSON mode, which guarantees the message the model generates is valid JSON.
        :param seed: If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism isn't guaranteed, and you should refer to the system_fingerprint response parameter to monitor changes in the backend.
        :param service_tier: Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service.
        :param stop: Not supported with latest reasoning models o3 and o4-mini. Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
        :param store: Whether or not to store the output of this chat completion request for use in our model distillation or evaluation products.
        :param stream: If set, partial message deltas will be sent as server-sent events. For streaming responses, this must be true.
        :param stream_options: Options for streaming response. Only set this when you set stream: true.
        :param temperature: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. We generally recommend altering this or top_p but not both.
        :param tool_choice: Controls which (if any) tool is called by the model. none means the model won't call any tool and instead generates a message. auto means the model can pick between generating a message or calling one or more tools. required means the model must call one or more tools. Specifying a particular tool via {\"type\": \"function\", \"function\": {\"name\": \"my_function\"}} forces the model to call that tool. none is the default when no tools are present. auto is the default if tools are present.
        :param tools: A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.
        :param top_logprobs: An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. logprobs must be set to true if this parameter is used.
        :param top_p: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We generally recommend altering this or temperature but not both.
        :param user: A unique identifier representing your end-user, which can help to monitor and detect abuse.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ChatCompletionRequestStream(
            audio=utils.get_pydantic_model(
                audio, OptionalNullable[models.ChatCompletionRequestStreamAudio]
            ),
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            logprobs=logprobs,
            max_completion_tokens=max_completion_tokens,
            messages=utils.get_pydantic_model(messages, List[models.ChatMessage]),
            metadata=metadata,
            modalities=modalities,
            model=model,
            n=n,
            parallel_tool_calls=parallel_tool_calls,
            prediction=utils.get_pydantic_model(
                prediction,
                OptionalNullable[models.ChatCompletionRequestStreamPrediction],
            ),
            presence_penalty=presence_penalty,
            prompt_cache_key=prompt_cache_key,
            reasoning_effort=reasoning_effort,
            response_format=utils.get_pydantic_model(
                response_format,
                OptionalNullable[models.ChatCompletionRequestStreamResponseFormatUnion],
            ),
            seed=seed,
            service_tier=service_tier,
            stop=stop,
            store=store,
            stream=stream,
            stream_options=utils.get_pydantic_model(
                stream_options,
                OptionalNullable[models.ChatCompletionRequestStreamStreamOptions],
            ),
            temperature=temperature,
            tool_choice=utils.get_pydantic_model(
                tool_choice,
                OptionalNullable[models.ChatCompletionRequestStreamToolChoiceUnion],
            ),
            tools=utils.get_pydantic_model(tools, OptionalNullable[List[models.Tool]]),
            top_logprobs=top_logprobs,
            top_p=top_p,
            user=user,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/chat/completions#stream",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="text/event-stream",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ChatCompletionRequestStream
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createStreaming",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.EventStreamAsync(
                http_res,
                lambda raw: utils.unmarshal_json(raw, models.ChatCompletionChunk),
                sentinel="[DONE]",
            )
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.ErrorResponseData, http_res, http_res_text
            )
            raise errors.ErrorResponse(response_data, http_res, http_res_text)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.ErrorResponseData, http_res, http_res_text
            )
            raise errors.ErrorResponse(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.SudoDefaultError(
            "Unexpected response received", http_res, http_res_text
        )

    def get_chat_completion(
        self,
        *,
        completion_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatCompletion:
        r"""*[OpenAI Only]* Get a Chat Completion. Only Chat Completions that have been stored with the `store` parameter set to true will be returned.

        :param completion_id: ID of the chat completion
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetChatCompletionRequest(
            completion_id=completion_id,
        )

        req = self._build_request(
            method="GET",
            path="/v1/chat/completions/{completion_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getChatCompletion",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatCompletion, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    async def get_chat_completion_async(
        self,
        *,
        completion_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatCompletion:
        r"""*[OpenAI Only]* Get a Chat Completion. Only Chat Completions that have been stored with the `store` parameter set to true will be returned.

        :param completion_id: ID of the chat completion
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetChatCompletionRequest(
            completion_id=completion_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/chat/completions/{completion_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getChatCompletion",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatCompletion, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    def update_chat_completion(
        self,
        *,
        completion_id: str,
        metadata: Dict[str, str],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatCompletion:
        r"""*[OpenAI Only]* Update a Chat Completion with some metadata. Only Chat Completions that have been stored with the `store` parameter set to true will be returned.

        :param completion_id: ID of the chat completion
        :param metadata: The metadata key-value pairs to attach to the completion.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateChatCompletionRequest(
            completion_id=completion_id,
            request_body=models.UpdateChatCompletionRequestBody(
                metadata=metadata,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v1/chat/completions/{completion_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.UpdateChatCompletionRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updateChatCompletion",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatCompletion, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    async def update_chat_completion_async(
        self,
        *,
        completion_id: str,
        metadata: Dict[str, str],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatCompletion:
        r"""*[OpenAI Only]* Update a Chat Completion with some metadata. Only Chat Completions that have been stored with the `store` parameter set to true will be returned.

        :param completion_id: ID of the chat completion
        :param metadata: The metadata key-value pairs to attach to the completion.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateChatCompletionRequest(
            completion_id=completion_id,
            request_body=models.UpdateChatCompletionRequestBody(
                metadata=metadata,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/chat/completions/{completion_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.UpdateChatCompletionRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="updateChatCompletion",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatCompletion, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    def delete_chat_completion(
        self,
        *,
        completion_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatDeletionConfirmation:
        r"""*[OpenAI Only]* Delete a stored Chat Completion. Only Chat Completions that have been stored with the `store` parameter set to true will be returned.

        :param completion_id: ID of the chat completion
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteChatCompletionRequest(
            completion_id=completion_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/v1/chat/completions/{completion_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="deleteChatCompletion",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatDeletionConfirmation, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    async def delete_chat_completion_async(
        self,
        *,
        completion_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatDeletionConfirmation:
        r"""*[OpenAI Only]* Delete a stored Chat Completion. Only Chat Completions that have been stored with the `store` parameter set to true will be returned.

        :param completion_id: ID of the chat completion
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteChatCompletionRequest(
            completion_id=completion_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/v1/chat/completions/{completion_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="deleteChatCompletion",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatDeletionConfirmation, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    def get_chat_completion_messages(
        self,
        *,
        completion_id: str,
        after: Optional[str] = None,
        limit: Optional[int] = None,
        order: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatMessageList:
        r"""*[OpenAI Only]* Get the array of messages for a saved Chat Completion. Only Chat Completions that have been stored with the `store` parameter set to true will be returned.

        :param completion_id: ID of the chat completion
        :param after: Identifier for the last message from the previous pagination request.
        :param limit: Number of messages to retrieve.
        :param order: Sort order for messages by timestamp. Use asc for ascending order or desc for descending order. Defaults to asc.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetChatCompletionMessagesRequest(
            completion_id=completion_id,
            after=after,
            limit=limit,
            order=order,
        )

        req = self._build_request(
            method="GET",
            path="/v1/chat/completions/{completion_id}/messages",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getChatCompletionMessages",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatMessageList, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    async def get_chat_completion_messages_async(
        self,
        *,
        completion_id: str,
        after: Optional[str] = None,
        limit: Optional[int] = None,
        order: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ChatMessageList:
        r"""*[OpenAI Only]* Get the array of messages for a saved Chat Completion. Only Chat Completions that have been stored with the `store` parameter set to true will be returned.

        :param completion_id: ID of the chat completion
        :param after: Identifier for the last message from the previous pagination request.
        :param limit: Number of messages to retrieve.
        :param order: Sort order for messages by timestamp. Use asc for ascending order or desc for descending order. Defaults to asc.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetChatCompletionMessagesRequest(
            completion_id=completion_id,
            after=after,
            limit=limit,
            order=order,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/chat/completions/{completion_id}/messages",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getChatCompletionMessages",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ChatMessageList, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    def generate_image(
        self,
        *,
        prompt: str,
        model: str,
        n: OptionalNullable[int] = UNSET,
        response_format: OptionalNullable[models.ResponseFormatEnum] = UNSET,
        quality: OptionalNullable[models.Quality] = UNSET,
        size: OptionalNullable[models.Size] = UNSET,
        style: OptionalNullable[models.Style] = UNSET,
        background: OptionalNullable[str] = UNSET,
        moderation: OptionalNullable[str] = UNSET,
        output_compression: OptionalNullable[int] = UNSET,
        output_format: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ImageGeneration:
        r"""Generate Image

        :param prompt: A text description of the desired image(s). The maximum length is 1000 characters for dall-e-2 and 4000 characters for dall-e-3.
        :param model: The model to use for image generation.
        :param n: The number of images to generate. Must be between 1 and 10. For dall-e-3, only n=1 is supported.
        :param response_format: The format in which the generated images are returned. Must be one of url or b64_json. URLs are only valid for 60 minutes after the image has been generated.
        :param quality: The quality of the image that will be generated. hd creates images with finer details and greater consistency across the image. This param is only supported for dall-e-3.
        :param size: The size of the generated images. Must be one of 256x256, 512x512, or 1024x1024 for dall-e-2. Must be one of 1024x1024, 1792x1024, or 1024x1792 for dall-e-3 models.
        :param style: The style of the generated images. Must be one of vivid or natural. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for dall-e-3.
        :param background: OpenAI only: Specify the background removal for the generated image.
        :param moderation: OpenAI only: Content moderation settings for the image generation.
        :param output_compression: OpenAI only: Compression level for the output image, from 0 to 100.
        :param output_format: OpenAI only: The output format for the generated image.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ImageGenerationRequest(
            prompt=prompt,
            model=model,
            n=n,
            response_format=response_format,
            quality=quality,
            size=size,
            style=style,
            background=background,
            moderation=moderation,
            output_compression=output_compression,
            output_format=output_format,
        )

        req = self._build_request(
            method="POST",
            path="/v1/images/generations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ImageGenerationRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="generateImage",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ImageGeneration, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)

    async def generate_image_async(
        self,
        *,
        prompt: str,
        model: str,
        n: OptionalNullable[int] = UNSET,
        response_format: OptionalNullable[models.ResponseFormatEnum] = UNSET,
        quality: OptionalNullable[models.Quality] = UNSET,
        size: OptionalNullable[models.Size] = UNSET,
        style: OptionalNullable[models.Style] = UNSET,
        background: OptionalNullable[str] = UNSET,
        moderation: OptionalNullable[str] = UNSET,
        output_compression: OptionalNullable[int] = UNSET,
        output_format: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ImageGeneration:
        r"""Generate Image

        :param prompt: A text description of the desired image(s). The maximum length is 1000 characters for dall-e-2 and 4000 characters for dall-e-3.
        :param model: The model to use for image generation.
        :param n: The number of images to generate. Must be between 1 and 10. For dall-e-3, only n=1 is supported.
        :param response_format: The format in which the generated images are returned. Must be one of url or b64_json. URLs are only valid for 60 minutes after the image has been generated.
        :param quality: The quality of the image that will be generated. hd creates images with finer details and greater consistency across the image. This param is only supported for dall-e-3.
        :param size: The size of the generated images. Must be one of 256x256, 512x512, or 1024x1024 for dall-e-2. Must be one of 1024x1024, 1792x1024, or 1024x1792 for dall-e-3 models.
        :param style: The style of the generated images. Must be one of vivid or natural. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for dall-e-3.
        :param background: OpenAI only: Specify the background removal for the generated image.
        :param moderation: OpenAI only: Content moderation settings for the image generation.
        :param output_compression: OpenAI only: Compression level for the output image, from 0 to 100.
        :param output_format: OpenAI only: The output format for the generated image.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ImageGenerationRequest(
            prompt=prompt,
            model=model,
            n=n,
            response_format=response_format,
            quality=quality,
            size=size,
            style=style,
            background=background,
            moderation=moderation,
            output_compression=output_compression,
            output_format=output_format,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/images/generations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ImageGenerationRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="generateImage",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "502", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ImageGeneration, http_res)
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, ["500", "502"], "application/json"):
            response_data = unmarshal_json_response(errors.ErrorResponseData, http_res)
            raise errors.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SudoDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SudoDefaultError("Unexpected response received", http_res)
