# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AccelerateMainland(AbstractModel):
    """Cross-MLC-border acceleration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable Cross-MLC-border acceleration. Valid values: 
<li>`on`: Enable;</li>
<li>`off`: Disable.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """Whether to enable Cross-MLC-border acceleration. Valid values: 
<li>`on`: Enable;</li>
<li>`off`: Disable.</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccelerateMainlandParameters(AbstractModel):
    """Accelerate optimization and configuration in mainland China.

    """

    def __init__(self):
        r"""
        :param _Switch: Mainland china acceleration optimization switch. valid values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """Mainland china acceleration optimization switch. valid values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccelerateType(AbstractModel):
    """Acceleration type

    """

    def __init__(self):
        r"""
        :param _Switch: Acceleration switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """Acceleration switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccelerationDomain(AbstractModel):
    """Accelerated domain name

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site.
        :type ZoneId: str
        :param _DomainName: Accelerated domain name
        :type DomainName: str
        :param _DomainStatus: Status of the accelerated domain name. Values:
<li>`online`: Activated</li>
<li>`process`: Being deployed</li>
<li>`offline`: Disabled</li>
<li>`forbidden`: Blocked</li>
<li>`init`: Pending activation</li>
        :type DomainStatus: str
        :param _OriginDetail: Details of the origin.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OriginDetail: :class:`tencentcloud.teo.v20220901.models.OriginDetail`
        :param _OriginProtocol: Origin-pull protocol configuration. Values:
<li>`FOLLOW`: Follow the protocol of origin</li>
<li>`HTTP`: Send requests to the origin over HTTP</li>
<li>`HTTPS`: Send requests to the origin over HTTPS</li>
Note: This field may return·null, indicating that no valid values can be obtained.
        :type OriginProtocol: str
        :param _HttpOriginPort: The port used for HTTP origin-pull requests
Note: This field may return·null, indicating that no valid values can be obtained.
        :type HttpOriginPort: int
        :param _HttpsOriginPort: The port used for HTTPS origin-pull requests
Note: This field may return·null, indicating that no valid values can be obtained.
        :type HttpsOriginPort: int
        :param _IPv6Status: IPv6 status. Values:
<li>`follow`: Follow the IPv6 configuration of the site</li>
<li>`on`: Enable</li>
<li>`off`: Disable</li>
Note: This field may return·null, indicating that no valid values can be obtained.
        :type IPv6Status: str
        :param _Cname: The CNAME address.
        :type Cname: str
        :param _IdentificationStatus: Ownership verification status. Values: <li>`pending`: Pending verification</li> <li>`finished`: Verified</li>	
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentificationStatus: str
        :param _CreatedOn: Creation time of the accelerated domain name.
        :type CreatedOn: str
        :param _ModifiedOn: Modification time of the accelerated domain name.
        :type ModifiedOn: str
        :param _OwnershipVerification: Information required to verify the ownership of a domain name.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type OwnershipVerification: :class:`tencentcloud.teo.v20220901.models.OwnershipVerification`
        :param _Certificate: Domain name certificate information
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Certificate: :class:`tencentcloud.teo.v20220901.models.AccelerationDomainCertificate`
        """
        self._ZoneId = None
        self._DomainName = None
        self._DomainStatus = None
        self._OriginDetail = None
        self._OriginProtocol = None
        self._HttpOriginPort = None
        self._HttpsOriginPort = None
        self._IPv6Status = None
        self._Cname = None
        self._IdentificationStatus = None
        self._CreatedOn = None
        self._ModifiedOn = None
        self._OwnershipVerification = None
        self._Certificate = None

    @property
    def ZoneId(self):
        """ID of the site.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def DomainName(self):
        """Accelerated domain name
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def DomainStatus(self):
        """Status of the accelerated domain name. Values:
<li>`online`: Activated</li>
<li>`process`: Being deployed</li>
<li>`offline`: Disabled</li>
<li>`forbidden`: Blocked</li>
<li>`init`: Pending activation</li>
        :rtype: str
        """
        return self._DomainStatus

    @DomainStatus.setter
    def DomainStatus(self, DomainStatus):
        self._DomainStatus = DomainStatus

    @property
    def OriginDetail(self):
        """Details of the origin.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.OriginDetail`
        """
        return self._OriginDetail

    @OriginDetail.setter
    def OriginDetail(self, OriginDetail):
        self._OriginDetail = OriginDetail

    @property
    def OriginProtocol(self):
        """Origin-pull protocol configuration. Values:
<li>`FOLLOW`: Follow the protocol of origin</li>
<li>`HTTP`: Send requests to the origin over HTTP</li>
<li>`HTTPS`: Send requests to the origin over HTTPS</li>
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._OriginProtocol

    @OriginProtocol.setter
    def OriginProtocol(self, OriginProtocol):
        self._OriginProtocol = OriginProtocol

    @property
    def HttpOriginPort(self):
        """The port used for HTTP origin-pull requests
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._HttpOriginPort

    @HttpOriginPort.setter
    def HttpOriginPort(self, HttpOriginPort):
        self._HttpOriginPort = HttpOriginPort

    @property
    def HttpsOriginPort(self):
        """The port used for HTTPS origin-pull requests
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._HttpsOriginPort

    @HttpsOriginPort.setter
    def HttpsOriginPort(self, HttpsOriginPort):
        self._HttpsOriginPort = HttpsOriginPort

    @property
    def IPv6Status(self):
        """IPv6 status. Values:
<li>`follow`: Follow the IPv6 configuration of the site</li>
<li>`on`: Enable</li>
<li>`off`: Disable</li>
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IPv6Status

    @IPv6Status.setter
    def IPv6Status(self, IPv6Status):
        self._IPv6Status = IPv6Status

    @property
    def Cname(self):
        """The CNAME address.
        :rtype: str
        """
        return self._Cname

    @Cname.setter
    def Cname(self, Cname):
        self._Cname = Cname

    @property
    def IdentificationStatus(self):
        """Ownership verification status. Values: <li>`pending`: Pending verification</li> <li>`finished`: Verified</li>	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IdentificationStatus

    @IdentificationStatus.setter
    def IdentificationStatus(self, IdentificationStatus):
        self._IdentificationStatus = IdentificationStatus

    @property
    def CreatedOn(self):
        """Creation time of the accelerated domain name.
        :rtype: str
        """
        return self._CreatedOn

    @CreatedOn.setter
    def CreatedOn(self, CreatedOn):
        self._CreatedOn = CreatedOn

    @property
    def ModifiedOn(self):
        """Modification time of the accelerated domain name.
        :rtype: str
        """
        return self._ModifiedOn

    @ModifiedOn.setter
    def ModifiedOn(self, ModifiedOn):
        self._ModifiedOn = ModifiedOn

    @property
    def OwnershipVerification(self):
        """Information required to verify the ownership of a domain name.
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.OwnershipVerification`
        """
        return self._OwnershipVerification

    @OwnershipVerification.setter
    def OwnershipVerification(self, OwnershipVerification):
        self._OwnershipVerification = OwnershipVerification

    @property
    def Certificate(self):
        """Domain name certificate information
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.AccelerationDomainCertificate`
        """
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._DomainName = params.get("DomainName")
        self._DomainStatus = params.get("DomainStatus")
        if params.get("OriginDetail") is not None:
            self._OriginDetail = OriginDetail()
            self._OriginDetail._deserialize(params.get("OriginDetail"))
        self._OriginProtocol = params.get("OriginProtocol")
        self._HttpOriginPort = params.get("HttpOriginPort")
        self._HttpsOriginPort = params.get("HttpsOriginPort")
        self._IPv6Status = params.get("IPv6Status")
        self._Cname = params.get("Cname")
        self._IdentificationStatus = params.get("IdentificationStatus")
        self._CreatedOn = params.get("CreatedOn")
        self._ModifiedOn = params.get("ModifiedOn")
        if params.get("OwnershipVerification") is not None:
            self._OwnershipVerification = OwnershipVerification()
            self._OwnershipVerification._deserialize(params.get("OwnershipVerification"))
        if params.get("Certificate") is not None:
            self._Certificate = AccelerationDomainCertificate()
            self._Certificate._deserialize(params.get("Certificate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccelerationDomainCertificate(AbstractModel):
    """Information of the acceleration domain name certificate.

    """

    def __init__(self):
        r"""
        :param _Mode: Certificate configuration mode. Values: <li>`disable`: Do not configure the certificate;</li><li>`eofreecert`: Use a free certificate provided by EdgeOne; </li><li>`sslcert`: Configure an SSL certificate.</li>
        :type Mode: str
        :param _List: List of server certificates. The relevant certificates are deployed on the entrance side of the EO.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type List: list of CertificateInfo
        :param _ClientCertInfo: In the edge mutual authentication scenario, this field represents the client's CA certificate, which is deployed inside the EO node and used for EO node authentication of the client certificate.
        :type ClientCertInfo: :class:`tencentcloud.teo.v20220901.models.MutualTLS`
        :param _UpstreamCertInfo: The certificate carried during EO node origin-pull is used when the origin server enables the mutual authentication handshake to validate the client certificate, ensuring that the request originates from a trusted EO node.
        :type UpstreamCertInfo: :class:`tencentcloud.teo.v20220901.models.UpstreamCertInfo`
        """
        self._Mode = None
        self._List = None
        self._ClientCertInfo = None
        self._UpstreamCertInfo = None

    @property
    def Mode(self):
        """Certificate configuration mode. Values: <li>`disable`: Do not configure the certificate;</li><li>`eofreecert`: Use a free certificate provided by EdgeOne; </li><li>`sslcert`: Configure an SSL certificate.</li>
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def List(self):
        """List of server certificates. The relevant certificates are deployed on the entrance side of the EO.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: list of CertificateInfo
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def ClientCertInfo(self):
        """In the edge mutual authentication scenario, this field represents the client's CA certificate, which is deployed inside the EO node and used for EO node authentication of the client certificate.
        :rtype: :class:`tencentcloud.teo.v20220901.models.MutualTLS`
        """
        return self._ClientCertInfo

    @ClientCertInfo.setter
    def ClientCertInfo(self, ClientCertInfo):
        self._ClientCertInfo = ClientCertInfo

    @property
    def UpstreamCertInfo(self):
        """The certificate carried during EO node origin-pull is used when the origin server enables the mutual authentication handshake to validate the client certificate, ensuring that the request originates from a trusted EO node.
        :rtype: :class:`tencentcloud.teo.v20220901.models.UpstreamCertInfo`
        """
        return self._UpstreamCertInfo

    @UpstreamCertInfo.setter
    def UpstreamCertInfo(self, UpstreamCertInfo):
        self._UpstreamCertInfo = UpstreamCertInfo


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = CertificateInfo()
                obj._deserialize(item)
                self._List.append(obj)
        if params.get("ClientCertInfo") is not None:
            self._ClientCertInfo = MutualTLS()
            self._ClientCertInfo._deserialize(params.get("ClientCertInfo"))
        if params.get("UpstreamCertInfo") is not None:
            self._UpstreamCertInfo = UpstreamCertInfo()
            self._UpstreamCertInfo._deserialize(params.get("UpstreamCertInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessURLRedirectParameters(AbstractModel):
    """Access URL redirect configuration parameters.

    """

    def __init__(self):
        r"""
        :param _StatusCode: Status code. valid values: 301, 302, 303, 307, 308.
        :type StatusCode: int
        :param _Protocol: Target request protocol. valid values:.
<Li>Http: target request protocol http;</li>.
<Li>Https: target request protocol https;</li>.
<Li>Follow: follow the request.</li>.
        :type Protocol: str
        :param _HostName: Target hostname.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type HostName: :class:`tencentcloud.teo.v20220901.models.HostName`
        :param _URLPath: Target path.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type URLPath: :class:`tencentcloud.teo.v20220901.models.URLPath`
        :param _QueryString: Carry query parameters.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type QueryString: :class:`tencentcloud.teo.v20220901.models.AccessURLRedirectQueryString`
        """
        self._StatusCode = None
        self._Protocol = None
        self._HostName = None
        self._URLPath = None
        self._QueryString = None

    @property
    def StatusCode(self):
        """Status code. valid values: 301, 302, 303, 307, 308.
        :rtype: int
        """
        return self._StatusCode

    @StatusCode.setter
    def StatusCode(self, StatusCode):
        self._StatusCode = StatusCode

    @property
    def Protocol(self):
        """Target request protocol. valid values:.
<Li>Http: target request protocol http;</li>.
<Li>Https: target request protocol https;</li>.
<Li>Follow: follow the request.</li>.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def HostName(self):
        """Target hostname.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.HostName`
        """
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def URLPath(self):
        """Target path.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.URLPath`
        """
        return self._URLPath

    @URLPath.setter
    def URLPath(self, URLPath):
        self._URLPath = URLPath

    @property
    def QueryString(self):
        """Carry query parameters.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.AccessURLRedirectQueryString`
        """
        return self._QueryString

    @QueryString.setter
    def QueryString(self, QueryString):
        self._QueryString = QueryString


    def _deserialize(self, params):
        self._StatusCode = params.get("StatusCode")
        self._Protocol = params.get("Protocol")
        if params.get("HostName") is not None:
            self._HostName = HostName()
            self._HostName._deserialize(params.get("HostName"))
        if params.get("URLPath") is not None:
            self._URLPath = URLPath()
            self._URLPath._deserialize(params.get("URLPath"))
        if params.get("QueryString") is not None:
            self._QueryString = AccessURLRedirectQueryString()
            self._QueryString._deserialize(params.get("QueryString"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessURLRedirectQueryString(AbstractModel):
    """Access URL redirect configuration parameters.

    """

    def __init__(self):
        r"""
        :param _Action: Action to be executed. values:.
<Li>`Full`: retain all</li>.
<Li>`Ignore`: ignore all</li>.
        :type Action: str
        """
        self._Action = None

    @property
    def Action(self):
        """Action to be executed. values:.
<Li>`Full`: retain all</li>.
<Li>`Ignore`: ignore all</li>.
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action


    def _deserialize(self, params):
        self._Action = params.get("Action")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AclCondition(AbstractModel):
    """The condition that makes up an access control rule

    """

    def __init__(self):
        r"""
        :param _MatchFrom: Filters: 
<li>`host`: Request domain name;</li>
<li>`sip`: Client IP;</li>
<li>`ua`: User-Agent;</li>
<li>`cookie`: Cookie;</li>
<li>`cgi`: CGI script;</li>
<li>`xff`: XFF header;</li></li>
<li>`url`: Request URL;<li></li>
<li>`accept`: Request content type;</li>
<li>`method`: Request method<;/li>
<li>`header`: Request header;</li>
<li>`app_proto`: Application layer protocol;</li>
<li>`sip_proto`: Network layer protocol;</li>
<li>`uabot`: UA rules (only available in custom bot rules);</li>
<li>`idcid`: IDC rules (only available in custom bot rules);</li>
<li>`sipbot`: Search engine rules (only available in custom bot rules);</li>
<li>`portrait`: Client reputation (only available in custom bot rules);</li>
<li>`header_seq`: Header sequence (only available in custom bot rules);</li>
<li>`hdr`: Request body (only available in custom Web protection rules). </li>
        :type MatchFrom: str
        :param _MatchParam: The parameter of the field. When `MatchFrom = header`, the key contained in the header can be passed.
        :type MatchParam: str
        :param _Operator: The logical operator. Values:
<li>`equal`: Value equals</li>
<li>`not_equal`: Value not equals</li>
<li>`include`: String contains</li>
<li>`not_include`: String not contains</li>
<li>`match`: IP matches</li>
<li>`not_match`: IP not matches</li>
<li>`include_area`: Regions contain</li>
<li>`is_empty`: Value left empty</li>
<li>`not_exists`: Key fields not exist</li>
<li>`regexp`: Regex matches</li>
<li>`len_gt`: Value greater than</li>
<li>`len_lt`: Value smaller than</li>
<li>`len_eq`: Value equals</li>
<li>`match_prefix`: Prefix matches</li>
<li>`match_suffix`: Suffix matches</li>
<li>`wildcard`: Wildcard</li>
        :type Operator: str
        :param _MatchContent: The content to match.
        :type MatchContent: str
        """
        self._MatchFrom = None
        self._MatchParam = None
        self._Operator = None
        self._MatchContent = None

    @property
    def MatchFrom(self):
        """Filters: 
<li>`host`: Request domain name;</li>
<li>`sip`: Client IP;</li>
<li>`ua`: User-Agent;</li>
<li>`cookie`: Cookie;</li>
<li>`cgi`: CGI script;</li>
<li>`xff`: XFF header;</li></li>
<li>`url`: Request URL;<li></li>
<li>`accept`: Request content type;</li>
<li>`method`: Request method<;/li>
<li>`header`: Request header;</li>
<li>`app_proto`: Application layer protocol;</li>
<li>`sip_proto`: Network layer protocol;</li>
<li>`uabot`: UA rules (only available in custom bot rules);</li>
<li>`idcid`: IDC rules (only available in custom bot rules);</li>
<li>`sipbot`: Search engine rules (only available in custom bot rules);</li>
<li>`portrait`: Client reputation (only available in custom bot rules);</li>
<li>`header_seq`: Header sequence (only available in custom bot rules);</li>
<li>`hdr`: Request body (only available in custom Web protection rules). </li>
        :rtype: str
        """
        return self._MatchFrom

    @MatchFrom.setter
    def MatchFrom(self, MatchFrom):
        self._MatchFrom = MatchFrom

    @property
    def MatchParam(self):
        """The parameter of the field. When `MatchFrom = header`, the key contained in the header can be passed.
        :rtype: str
        """
        return self._MatchParam

    @MatchParam.setter
    def MatchParam(self, MatchParam):
        self._MatchParam = MatchParam

    @property
    def Operator(self):
        """The logical operator. Values:
<li>`equal`: Value equals</li>
<li>`not_equal`: Value not equals</li>
<li>`include`: String contains</li>
<li>`not_include`: String not contains</li>
<li>`match`: IP matches</li>
<li>`not_match`: IP not matches</li>
<li>`include_area`: Regions contain</li>
<li>`is_empty`: Value left empty</li>
<li>`not_exists`: Key fields not exist</li>
<li>`regexp`: Regex matches</li>
<li>`len_gt`: Value greater than</li>
<li>`len_lt`: Value smaller than</li>
<li>`len_eq`: Value equals</li>
<li>`match_prefix`: Prefix matches</li>
<li>`match_suffix`: Suffix matches</li>
<li>`wildcard`: Wildcard</li>
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def MatchContent(self):
        """The content to match.
        :rtype: str
        """
        return self._MatchContent

    @MatchContent.setter
    def MatchContent(self, MatchContent):
        self._MatchContent = MatchContent


    def _deserialize(self, params):
        self._MatchFrom = params.get("MatchFrom")
        self._MatchParam = params.get("MatchParam")
        self._Operator = params.get("Operator")
        self._MatchContent = params.get("MatchContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AclConfig(AbstractModel):
    """ACL configuration

    """

    def __init__(self):
        r"""
        :param _Switch: Switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _AclUserRules: The custom rule.
        :type AclUserRules: list of AclUserRule
        :param _Customizes: Custom managed rules
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type Customizes: list of AclUserRule
        """
        self._Switch = None
        self._AclUserRules = None
        self._Customizes = None

    @property
    def Switch(self):
        """Switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def AclUserRules(self):
        """The custom rule.
        :rtype: list of AclUserRule
        """
        return self._AclUserRules

    @AclUserRules.setter
    def AclUserRules(self, AclUserRules):
        self._AclUserRules = AclUserRules

    @property
    def Customizes(self):
        """Custom managed rules
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: list of AclUserRule
        """
        return self._Customizes

    @Customizes.setter
    def Customizes(self, Customizes):
        self._Customizes = Customizes


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        if params.get("AclUserRules") is not None:
            self._AclUserRules = []
            for item in params.get("AclUserRules"):
                obj = AclUserRule()
                obj._deserialize(item)
                self._AclUserRules.append(obj)
        if params.get("Customizes") is not None:
            self._Customizes = []
            for item in params.get("Customizes"):
                obj = AclUserRule()
                obj._deserialize(item)
                self._Customizes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AclUserRule(AbstractModel):
    """The custom rule

    """

    def __init__(self):
        r"""
        :param _RuleName: The rule name.
        :type RuleName: str
        :param _Action: The action. Values:
<li>`trans`: Allow</li>
<li>`drop`: Block the request</li>
<li>`monitor`: Observe</li>
<li>`ban`: Block the IP</li>
<li>`redirect`: Redirect the request</li>
<li>`page`: Return the specified page</li>
<li>`alg`: JavaScript challenge</li>
        :type Action: str
        :param _RuleStatus: The rule status. Values:
<li>`on`: Enabled</li>
<li>`off`: Disabled</li>
        :type RuleStatus: str
        :param _AclConditions: The custom rule.
        :type AclConditions: list of AclCondition
        :param _RulePriority: The rule priority. Value range: 0-100.
        :type RulePriority: int
        :param _RuleID: Rule ID, which is only used as an output parameter.
        :type RuleID: int
        :param _UpdateTime: The update time, which is only used as an output parameter.
        :type UpdateTime: str
        :param _PunishTime: IP ban duration. Range: 0-2 days. It's required when `Action=ban`. 
        :type PunishTime: int
        :param _PunishTimeUnit: The unit of the IP ban duration. Values:
<li>`second`: Second</li>
<li>`minutes`: Minute</li>
<li>`hour`: Hour</li>Default value: `second`.
        :type PunishTimeUnit: str
        :param _Name: Name of the custom return page. It's required when `Action=page`.	
        :type Name: str
        :param _PageId: (Disused) ID of the custom return page. The default value is 0, which means that the system default blocking page is used. 
        :type PageId: int
        :param _CustomResponseId: ID of custom response. The ID can be obtained via the `DescribeCustomErrorPages` API. It's required when `Action=page`.	
        :type CustomResponseId: str
        :param _ResponseCode: The response code to trigger the return page. It's required when `Action=page`. Value: 100-600. 3xx response codes are not supported. Default value: 567.
        :type ResponseCode: int
        :param _RedirectUrl: The redirection URL. It's required when `Action=redirect`.	
        :type RedirectUrl: str
        """
        self._RuleName = None
        self._Action = None
        self._RuleStatus = None
        self._AclConditions = None
        self._RulePriority = None
        self._RuleID = None
        self._UpdateTime = None
        self._PunishTime = None
        self._PunishTimeUnit = None
        self._Name = None
        self._PageId = None
        self._CustomResponseId = None
        self._ResponseCode = None
        self._RedirectUrl = None

    @property
    def RuleName(self):
        """The rule name.
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Action(self):
        """The action. Values:
<li>`trans`: Allow</li>
<li>`drop`: Block the request</li>
<li>`monitor`: Observe</li>
<li>`ban`: Block the IP</li>
<li>`redirect`: Redirect the request</li>
<li>`page`: Return the specified page</li>
<li>`alg`: JavaScript challenge</li>
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def RuleStatus(self):
        """The rule status. Values:
<li>`on`: Enabled</li>
<li>`off`: Disabled</li>
        :rtype: str
        """
        return self._RuleStatus

    @RuleStatus.setter
    def RuleStatus(self, RuleStatus):
        self._RuleStatus = RuleStatus

    @property
    def AclConditions(self):
        """The custom rule.
        :rtype: list of AclCondition
        """
        return self._AclConditions

    @AclConditions.setter
    def AclConditions(self, AclConditions):
        self._AclConditions = AclConditions

    @property
    def RulePriority(self):
        """The rule priority. Value range: 0-100.
        :rtype: int
        """
        return self._RulePriority

    @RulePriority.setter
    def RulePriority(self, RulePriority):
        self._RulePriority = RulePriority

    @property
    def RuleID(self):
        """Rule ID, which is only used as an output parameter.
        :rtype: int
        """
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def UpdateTime(self):
        """The update time, which is only used as an output parameter.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def PunishTime(self):
        """IP ban duration. Range: 0-2 days. It's required when `Action=ban`. 
        :rtype: int
        """
        return self._PunishTime

    @PunishTime.setter
    def PunishTime(self, PunishTime):
        self._PunishTime = PunishTime

    @property
    def PunishTimeUnit(self):
        """The unit of the IP ban duration. Values:
<li>`second`: Second</li>
<li>`minutes`: Minute</li>
<li>`hour`: Hour</li>Default value: `second`.
        :rtype: str
        """
        return self._PunishTimeUnit

    @PunishTimeUnit.setter
    def PunishTimeUnit(self, PunishTimeUnit):
        self._PunishTimeUnit = PunishTimeUnit

    @property
    def Name(self):
        """Name of the custom return page. It's required when `Action=page`.	
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def PageId(self):
        """(Disused) ID of the custom return page. The default value is 0, which means that the system default blocking page is used. 
        :rtype: int
        """
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId

    @property
    def CustomResponseId(self):
        """ID of custom response. The ID can be obtained via the `DescribeCustomErrorPages` API. It's required when `Action=page`.	
        :rtype: str
        """
        return self._CustomResponseId

    @CustomResponseId.setter
    def CustomResponseId(self, CustomResponseId):
        self._CustomResponseId = CustomResponseId

    @property
    def ResponseCode(self):
        """The response code to trigger the return page. It's required when `Action=page`. Value: 100-600. 3xx response codes are not supported. Default value: 567.
        :rtype: int
        """
        return self._ResponseCode

    @ResponseCode.setter
    def ResponseCode(self, ResponseCode):
        self._ResponseCode = ResponseCode

    @property
    def RedirectUrl(self):
        """The redirection URL. It's required when `Action=redirect`.	
        :rtype: str
        """
        return self._RedirectUrl

    @RedirectUrl.setter
    def RedirectUrl(self, RedirectUrl):
        self._RedirectUrl = RedirectUrl


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        self._Action = params.get("Action")
        self._RuleStatus = params.get("RuleStatus")
        if params.get("AclConditions") is not None:
            self._AclConditions = []
            for item in params.get("AclConditions"):
                obj = AclCondition()
                obj._deserialize(item)
                self._AclConditions.append(obj)
        self._RulePriority = params.get("RulePriority")
        self._RuleID = params.get("RuleID")
        self._UpdateTime = params.get("UpdateTime")
        self._PunishTime = params.get("PunishTime")
        self._PunishTimeUnit = params.get("PunishTimeUnit")
        self._Name = params.get("Name")
        self._PageId = params.get("PageId")
        self._CustomResponseId = params.get("CustomResponseId")
        self._ResponseCode = params.get("ResponseCode")
        self._RedirectUrl = params.get("RedirectUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Action(AbstractModel):
    """Rule engine action. Each feature supports only one of the following three action types. The `RuleAction` array can be of only one of the following types. For all details, see [DescribeRulesSetting](https://intl.cloud.tencent.com/document/product/1552/80618?from_cn_redirect=1).

    """

    def __init__(self):
        r"""
        :param _NormalAction: Common feature operations. the options for this category include:.
<Li>Access url rewrite (`accessurlredirect`).</li>.
<Li> origin url overriding (upstreamurlredirect);</li>.
<Li> quic;</li>.
<Li> websocket;</li>.
<Li> video dragging (videoseek);</li>.
<Li> token authentication (authentication);</li>.
<Li> custom cachekey (cachekey);</li>.
<Li> node caching ttl (cache);</li>.
<Li> browser cache ttl (maxage);</li>.
<Li> offline caching (offlinecache);</li>.
<Li> smart acceleration (smartrouting);</li>.
<Li> range-based origin pull (rangeoriginpull);</li>.
<Li> http/2 origin pull (upstreamhttp2);</li>.
<Li> host header overriding (hostheader);</li>.
<Li> force https (forceredirect);</li>.
<Li> https origin pull (originpullprotocol);</li>.
<Li>`ResponseSpeedLimit`: single connection download speed limit.</li>.
<Li>`CachePrefresh`: cache prefresh.</li>.
<Li>`Compression`: smart compression.</li>.
<Li>Hsts;</Li>.
<Li>ClientIpHeader;</Li>.
<Li> ssltlssecureconf;</li>.
<Li> ocspstapling;</li>.
<Li> http/2 access (http2);</li>.
<Li> redirection during origin pull (upstreamfollowredirect);</li>.
<Li> modifying origin server (origin);</li>.
<Li> layer 7 origin pull timeout (httpupstreamtimeout).</li>.
<Li> http response (httpresponse).</li>.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type NormalAction: :class:`tencentcloud.teo.v20220901.models.NormalAction`
        :param _RewriteAction: Feature operation with a request/response header. Features of this type include:
<li>`RequestHeader`: HTTP request header modification.</li>
<li>`ResponseHeader`: HTTP response header modification.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type RewriteAction: :class:`tencentcloud.teo.v20220901.models.RewriteAction`
        :param _CodeAction: Feature operation with a status code. Features of this type include:
<li>`ErrorPage`: Custom error page.</li>
<li>`StatusCodeCache`: Status code cache TTL.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type CodeAction: :class:`tencentcloud.teo.v20220901.models.CodeAction`
        """
        self._NormalAction = None
        self._RewriteAction = None
        self._CodeAction = None

    @property
    def NormalAction(self):
        """Common feature operations. the options for this category include:.
<Li>Access url rewrite (`accessurlredirect`).</li>.
<Li> origin url overriding (upstreamurlredirect);</li>.
<Li> quic;</li>.
<Li> websocket;</li>.
<Li> video dragging (videoseek);</li>.
<Li> token authentication (authentication);</li>.
<Li> custom cachekey (cachekey);</li>.
<Li> node caching ttl (cache);</li>.
<Li> browser cache ttl (maxage);</li>.
<Li> offline caching (offlinecache);</li>.
<Li> smart acceleration (smartrouting);</li>.
<Li> range-based origin pull (rangeoriginpull);</li>.
<Li> http/2 origin pull (upstreamhttp2);</li>.
<Li> host header overriding (hostheader);</li>.
<Li> force https (forceredirect);</li>.
<Li> https origin pull (originpullprotocol);</li>.
<Li>`ResponseSpeedLimit`: single connection download speed limit.</li>.
<Li>`CachePrefresh`: cache prefresh.</li>.
<Li>`Compression`: smart compression.</li>.
<Li>Hsts;</Li>.
<Li>ClientIpHeader;</Li>.
<Li> ssltlssecureconf;</li>.
<Li> ocspstapling;</li>.
<Li> http/2 access (http2);</li>.
<Li> redirection during origin pull (upstreamfollowredirect);</li>.
<Li> modifying origin server (origin);</li>.
<Li> layer 7 origin pull timeout (httpupstreamtimeout).</li>.
<Li> http response (httpresponse).</li>.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.NormalAction`
        """
        return self._NormalAction

    @NormalAction.setter
    def NormalAction(self, NormalAction):
        self._NormalAction = NormalAction

    @property
    def RewriteAction(self):
        """Feature operation with a request/response header. Features of this type include:
<li>`RequestHeader`: HTTP request header modification.</li>
<li>`ResponseHeader`: HTTP response header modification.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.RewriteAction`
        """
        return self._RewriteAction

    @RewriteAction.setter
    def RewriteAction(self, RewriteAction):
        self._RewriteAction = RewriteAction

    @property
    def CodeAction(self):
        """Feature operation with a status code. Features of this type include:
<li>`ErrorPage`: Custom error page.</li>
<li>`StatusCodeCache`: Status code cache TTL.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CodeAction`
        """
        return self._CodeAction

    @CodeAction.setter
    def CodeAction(self, CodeAction):
        self._CodeAction = CodeAction


    def _deserialize(self, params):
        if params.get("NormalAction") is not None:
            self._NormalAction = NormalAction()
            self._NormalAction._deserialize(params.get("NormalAction"))
        if params.get("RewriteAction") is not None:
            self._RewriteAction = RewriteAction()
            self._RewriteAction._deserialize(params.get("RewriteAction"))
        if params.get("CodeAction") is not None:
            self._CodeAction = CodeAction()
            self._CodeAction._deserialize(params.get("CodeAction"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveFrequencyControl(AbstractModel):
    """Adaptive frequency control.

    """

    def __init__(self):
        r"""
        :param _Enabled: Whether adaptive frequency control is enabled. valid values: <li>on: enable;</li> <li>off: disable.</li>.
        :type Enabled: str
        :param _Sensitivity: The restriction level of adaptive frequency control. required when Enabled is on. valid values: <li>Loose: Loose</li><li>Moderate: Moderate</li><li>Strict: Strict</li>.
        :type Sensitivity: str
        :param _Action: The handling method of adaptive frequency control. this field is required when Enabled is on. valid values for SecurityAction Name: <li>Monitor: observation;</li> <li>Deny: block;</li> <li>Challenge: Challenge, where ChallengeActionParameters.Name only supports JSChallenge.</li>.
        :type Action: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        self._Enabled = None
        self._Sensitivity = None
        self._Action = None

    @property
    def Enabled(self):
        """Whether adaptive frequency control is enabled. valid values: <li>on: enable;</li> <li>off: disable.</li>.
        :rtype: str
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def Sensitivity(self):
        """The restriction level of adaptive frequency control. required when Enabled is on. valid values: <li>Loose: Loose</li><li>Moderate: Moderate</li><li>Strict: Strict</li>.
        :rtype: str
        """
        return self._Sensitivity

    @Sensitivity.setter
    def Sensitivity(self, Sensitivity):
        self._Sensitivity = Sensitivity

    @property
    def Action(self):
        """The handling method of adaptive frequency control. this field is required when Enabled is on. valid values for SecurityAction Name: <li>Monitor: observation;</li> <li>Deny: block;</li> <li>Challenge: Challenge, where ChallengeActionParameters.Name only supports JSChallenge.</li>.
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action


    def _deserialize(self, params):
        self._Enabled = params.get("Enabled")
        self._Sensitivity = params.get("Sensitivity")
        if params.get("Action") is not None:
            self._Action = SecurityAction()
            self._Action._deserialize(params.get("Action"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Addresses(AbstractModel):
    """IP range details.

    """

    def __init__(self):
        r"""
        :param _IPv4: IPv4 subnet.
        :type IPv4: list of str
        :param _IPv6: IPv6 subnet.
        :type IPv6: list of str
        """
        self._IPv4 = None
        self._IPv6 = None

    @property
    def IPv4(self):
        """IPv4 subnet.
        :rtype: list of str
        """
        return self._IPv4

    @IPv4.setter
    def IPv4(self, IPv4):
        self._IPv4 = IPv4

    @property
    def IPv6(self):
        """IPv6 subnet.
        :rtype: list of str
        """
        return self._IPv6

    @IPv6.setter
    def IPv6(self, IPv6):
        self._IPv6 = IPv6


    def _deserialize(self, params):
        self._IPv4 = params.get("IPv4")
        self._IPv6 = params.get("IPv6")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdvancedFilter(AbstractModel):
    """Key-value pair filters for conditional filtering queries and fuzzy queries, such as filtering ID, name, and status.
    If more than one filter exists, the logical relationship between these filters is `AND`.
    If one filter has multiple values, the logical relationship between these values is `OR`.

    """

    def __init__(self):
        r"""
        :param _Name: Field to be filtered.
        :type Name: str
        :param _Values: Value of the filtered field.
        :type Values: list of str
        :param _Fuzzy: Whether to enable fuzzy query.
        :type Fuzzy: bool
        """
        self._Name = None
        self._Values = None
        self._Fuzzy = None

    @property
    def Name(self):
        """Field to be filtered.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        """Value of the filtered field.
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def Fuzzy(self):
        """Whether to enable fuzzy query.
        :rtype: bool
        """
        return self._Fuzzy

    @Fuzzy.setter
    def Fuzzy(self, Fuzzy):
        self._Fuzzy = Fuzzy


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._Fuzzy = params.get("Fuzzy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRule(AbstractModel):
    """AI rule engine

    """

    def __init__(self):
        r"""
        :param _Mode: The status of the AI rule engine. Values:
<li>`smart_status_close`: Disabled</li>
<li>`smart_status_open`: Block</li>
<li>`smart_status_observe`: Observe</li>
        :type Mode: str
        """
        self._Mode = None

    @property
    def Mode(self):
        """The status of the AI rule engine. Values:
<li>`smart_status_close`: Disabled</li>
<li>`smart_status_open`: Block</li>
<li>`smart_status_observe`: Observe</li>
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlgDetectJS(AbstractModel):
    """Validate client behavior.

    """

    def __init__(self):
        r"""
        :param _Name: Method to validate client behavior.
        :type Name: str
        :param _WorkLevel: Proof-of-work strength. Values:
<li>`low` (default): Low</li>
<li>`middle`: Medium</li>
<li>`high`: High</li>
        :type WorkLevel: str
        :param _ExecuteMode: Implement a delay before executing JS in milliseconds. Value range: 0-1000. Default value: 500.
        :type ExecuteMode: int
        :param _InvalidStatTime: The period threshold for validating the result "Client JS disabled" in seconds. Value range: 5-3600. Default value: 10.
        :type InvalidStatTime: int
        :param _InvalidThreshold: The number of times for the result "Client JS disabled" occurred in the specified period. Value range: 1-100000000. Default value: 30.
        :type InvalidThreshold: int
        :param _AlgDetectResults: Client behavior validation results.
        :type AlgDetectResults: list of AlgDetectResult
        """
        self._Name = None
        self._WorkLevel = None
        self._ExecuteMode = None
        self._InvalidStatTime = None
        self._InvalidThreshold = None
        self._AlgDetectResults = None

    @property
    def Name(self):
        """Method to validate client behavior.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def WorkLevel(self):
        """Proof-of-work strength. Values:
<li>`low` (default): Low</li>
<li>`middle`: Medium</li>
<li>`high`: High</li>
        :rtype: str
        """
        return self._WorkLevel

    @WorkLevel.setter
    def WorkLevel(self, WorkLevel):
        self._WorkLevel = WorkLevel

    @property
    def ExecuteMode(self):
        """Implement a delay before executing JS in milliseconds. Value range: 0-1000. Default value: 500.
        :rtype: int
        """
        return self._ExecuteMode

    @ExecuteMode.setter
    def ExecuteMode(self, ExecuteMode):
        self._ExecuteMode = ExecuteMode

    @property
    def InvalidStatTime(self):
        """The period threshold for validating the result "Client JS disabled" in seconds. Value range: 5-3600. Default value: 10.
        :rtype: int
        """
        return self._InvalidStatTime

    @InvalidStatTime.setter
    def InvalidStatTime(self, InvalidStatTime):
        self._InvalidStatTime = InvalidStatTime

    @property
    def InvalidThreshold(self):
        """The number of times for the result "Client JS disabled" occurred in the specified period. Value range: 1-100000000. Default value: 30.
        :rtype: int
        """
        return self._InvalidThreshold

    @InvalidThreshold.setter
    def InvalidThreshold(self, InvalidThreshold):
        self._InvalidThreshold = InvalidThreshold

    @property
    def AlgDetectResults(self):
        """Client behavior validation results.
        :rtype: list of AlgDetectResult
        """
        return self._AlgDetectResults

    @AlgDetectResults.setter
    def AlgDetectResults(self, AlgDetectResults):
        self._AlgDetectResults = AlgDetectResults


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._WorkLevel = params.get("WorkLevel")
        self._ExecuteMode = params.get("ExecuteMode")
        self._InvalidStatTime = params.get("InvalidStatTime")
        self._InvalidThreshold = params.get("InvalidThreshold")
        if params.get("AlgDetectResults") is not None:
            self._AlgDetectResults = []
            for item in params.get("AlgDetectResults"):
                obj = AlgDetectResult()
                obj._deserialize(item)
                self._AlgDetectResults.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlgDetectResult(AbstractModel):
    """Active bot detection results.

    """

    def __init__(self):
        r"""
        :param _Result: The validation result. Values:
<li>`invalid`: Invalid Cookie</li>
<li>`cookie_empty`: No Cookie/Cookie expired</li>
<li>`js_empty`: Client JS disabled</li>
<li>`low`: Low-risk session</li>
<li>`middle`: Medium-risk session</li>
<li>`high`: High-risk session</li>
<li>`timeout`: JS validation timed out</li>
<li>`not_browser`: Invalid browser</li>
<li>`is_bot`: Bot client</li>
        :type Result: str
        :param _Action: The action. Values:
<li>`drop`: Block</li>
<li>`monitor`: Observe</li>
<li>`silence`: Drop w/o response</li>
<li>`shortdelay`: Add short latency</li>
<li>`longdelay`: Add long latency</li>
        :type Action: str
        """
        self._Result = None
        self._Action = None

    @property
    def Result(self):
        """The validation result. Values:
<li>`invalid`: Invalid Cookie</li>
<li>`cookie_empty`: No Cookie/Cookie expired</li>
<li>`js_empty`: Client JS disabled</li>
<li>`low`: Low-risk session</li>
<li>`middle`: Medium-risk session</li>
<li>`high`: High-risk session</li>
<li>`timeout`: JS validation timed out</li>
<li>`not_browser`: Invalid browser</li>
<li>`is_bot`: Bot client</li>
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def Action(self):
        """The action. Values:
<li>`drop`: Block</li>
<li>`monitor`: Observe</li>
<li>`silence`: Drop w/o response</li>
<li>`shortdelay`: Add short latency</li>
<li>`longdelay`: Add long latency</li>
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._Action = params.get("Action")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlgDetectRule(AbstractModel):
    """Active bot detection rule.

    """

    def __init__(self):
        r"""
        :param _RuleID: ID of the rule.
        :type RuleID: int
        :param _RuleName: Name of the rule.
        :type RuleName: str
        :param _Switch: Whether to enable the rule.
        :type Switch: str
        :param _AlgConditions: Condition specified for the rule.
        :type AlgConditions: list of AclCondition
        :param _AlgDetectSession: Validate Cookie when the condition is satisfied.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type AlgDetectSession: :class:`tencentcloud.teo.v20220901.models.AlgDetectSession`
        :param _AlgDetectJS: Validate client behavior when the condition is satisfied.
        :type AlgDetectJS: list of AlgDetectJS
        :param _UpdateTime: The update time, which is only used as an output parameter.
        :type UpdateTime: str
        """
        self._RuleID = None
        self._RuleName = None
        self._Switch = None
        self._AlgConditions = None
        self._AlgDetectSession = None
        self._AlgDetectJS = None
        self._UpdateTime = None

    @property
    def RuleID(self):
        """ID of the rule.
        :rtype: int
        """
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def RuleName(self):
        """Name of the rule.
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Switch(self):
        """Whether to enable the rule.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def AlgConditions(self):
        """Condition specified for the rule.
        :rtype: list of AclCondition
        """
        return self._AlgConditions

    @AlgConditions.setter
    def AlgConditions(self, AlgConditions):
        self._AlgConditions = AlgConditions

    @property
    def AlgDetectSession(self):
        """Validate Cookie when the condition is satisfied.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.AlgDetectSession`
        """
        return self._AlgDetectSession

    @AlgDetectSession.setter
    def AlgDetectSession(self, AlgDetectSession):
        self._AlgDetectSession = AlgDetectSession

    @property
    def AlgDetectJS(self):
        """Validate client behavior when the condition is satisfied.
        :rtype: list of AlgDetectJS
        """
        return self._AlgDetectJS

    @AlgDetectJS.setter
    def AlgDetectJS(self, AlgDetectJS):
        self._AlgDetectJS = AlgDetectJS

    @property
    def UpdateTime(self):
        """The update time, which is only used as an output parameter.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._RuleID = params.get("RuleID")
        self._RuleName = params.get("RuleName")
        self._Switch = params.get("Switch")
        if params.get("AlgConditions") is not None:
            self._AlgConditions = []
            for item in params.get("AlgConditions"):
                obj = AclCondition()
                obj._deserialize(item)
                self._AlgConditions.append(obj)
        if params.get("AlgDetectSession") is not None:
            self._AlgDetectSession = AlgDetectSession()
            self._AlgDetectSession._deserialize(params.get("AlgDetectSession"))
        if params.get("AlgDetectJS") is not None:
            self._AlgDetectJS = []
            for item in params.get("AlgDetectJS"):
                obj = AlgDetectJS()
                obj._deserialize(item)
                self._AlgDetectJS.append(obj)
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlgDetectSession(AbstractModel):
    """Validate Cookie.

    """

    def __init__(self):
        r"""
        :param _Name: Method to validate Cookie.
        :type Name: str
        :param _DetectMode: The validation mode. Values:
<li>`detect`: Validate only</li>
<li>`update_detect` (default): Update Cookie and validate</li>
        :type DetectMode: str
        :param _SessionAnalyzeSwitch: Whether to enable Cookie-based session check. The default value is `off`. Values:
<li>`off`: Disable</li>
<li>`on`: Enable</li>
        :type SessionAnalyzeSwitch: str
        :param _InvalidStatTime: The period threshold for validating the result "No Cookie/Cookie expired" in seconds. Value range: 5-3600. Default value: 10.
        :type InvalidStatTime: int
        :param _InvalidThreshold: The number of times for the result "No Cookie/Cookie expired" occurred in the specified period. Value range: 1-100000000. Default value: 300.
        :type InvalidThreshold: int
        :param _AlgDetectResults: Cookie validation results.
        :type AlgDetectResults: list of AlgDetectResult
        :param _SessionBehaviors: Cookie-based session check results.
        :type SessionBehaviors: list of AlgDetectResult
        """
        self._Name = None
        self._DetectMode = None
        self._SessionAnalyzeSwitch = None
        self._InvalidStatTime = None
        self._InvalidThreshold = None
        self._AlgDetectResults = None
        self._SessionBehaviors = None

    @property
    def Name(self):
        """Method to validate Cookie.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DetectMode(self):
        """The validation mode. Values:
<li>`detect`: Validate only</li>
<li>`update_detect` (default): Update Cookie and validate</li>
        :rtype: str
        """
        return self._DetectMode

    @DetectMode.setter
    def DetectMode(self, DetectMode):
        self._DetectMode = DetectMode

    @property
    def SessionAnalyzeSwitch(self):
        """Whether to enable Cookie-based session check. The default value is `off`. Values:
<li>`off`: Disable</li>
<li>`on`: Enable</li>
        :rtype: str
        """
        return self._SessionAnalyzeSwitch

    @SessionAnalyzeSwitch.setter
    def SessionAnalyzeSwitch(self, SessionAnalyzeSwitch):
        self._SessionAnalyzeSwitch = SessionAnalyzeSwitch

    @property
    def InvalidStatTime(self):
        """The period threshold for validating the result "No Cookie/Cookie expired" in seconds. Value range: 5-3600. Default value: 10.
        :rtype: int
        """
        return self._InvalidStatTime

    @InvalidStatTime.setter
    def InvalidStatTime(self, InvalidStatTime):
        self._InvalidStatTime = InvalidStatTime

    @property
    def InvalidThreshold(self):
        """The number of times for the result "No Cookie/Cookie expired" occurred in the specified period. Value range: 1-100000000. Default value: 300.
        :rtype: int
        """
        return self._InvalidThreshold

    @InvalidThreshold.setter
    def InvalidThreshold(self, InvalidThreshold):
        self._InvalidThreshold = InvalidThreshold

    @property
    def AlgDetectResults(self):
        """Cookie validation results.
        :rtype: list of AlgDetectResult
        """
        return self._AlgDetectResults

    @AlgDetectResults.setter
    def AlgDetectResults(self, AlgDetectResults):
        self._AlgDetectResults = AlgDetectResults

    @property
    def SessionBehaviors(self):
        """Cookie-based session check results.
        :rtype: list of AlgDetectResult
        """
        return self._SessionBehaviors

    @SessionBehaviors.setter
    def SessionBehaviors(self, SessionBehaviors):
        self._SessionBehaviors = SessionBehaviors


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._DetectMode = params.get("DetectMode")
        self._SessionAnalyzeSwitch = params.get("SessionAnalyzeSwitch")
        self._InvalidStatTime = params.get("InvalidStatTime")
        self._InvalidThreshold = params.get("InvalidThreshold")
        if params.get("AlgDetectResults") is not None:
            self._AlgDetectResults = []
            for item in params.get("AlgDetectResults"):
                obj = AlgDetectResult()
                obj._deserialize(item)
                self._AlgDetectResults.append(obj)
        if params.get("SessionBehaviors") is not None:
            self._SessionBehaviors = []
            for item in params.get("SessionBehaviors"):
                obj = AlgDetectResult()
                obj._deserialize(item)
                self._SessionBehaviors.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AliasDomain(AbstractModel):
    """Information of the alias domain name

    """

    def __init__(self):
        r"""
        :param _AliasName: The alias domain name.
        :type AliasName: str
        :param _ZoneId: The site ID.
        :type ZoneId: str
        :param _TargetName: The target domain name.
        :type TargetName: str
        :param _Status: Status of the alias domain name. Values:
<li>`active`: Activated</li>
<li>`pending`: Deploying</li>
<li>`conflict`: Reclaimed</li>
<li>`stop`: Stopped</li>
        :type Status: str
        :param _ForbidMode: The blocking mode. Values:
<li>`0`: Not blocked</li>
<li>`11`: Blocked due to regulatory compliance</li>
<li>`14`: Blocked due to ICP filing not obtained</li>
        :type ForbidMode: int
        :param _CreatedOn: Creation time of the alias domain name.
        :type CreatedOn: str
        :param _ModifiedOn: Modification time of the alias domain name.
        :type ModifiedOn: str
        """
        self._AliasName = None
        self._ZoneId = None
        self._TargetName = None
        self._Status = None
        self._ForbidMode = None
        self._CreatedOn = None
        self._ModifiedOn = None

    @property
    def AliasName(self):
        """The alias domain name.
        :rtype: str
        """
        return self._AliasName

    @AliasName.setter
    def AliasName(self, AliasName):
        self._AliasName = AliasName

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TargetName(self):
        """The target domain name.
        :rtype: str
        """
        return self._TargetName

    @TargetName.setter
    def TargetName(self, TargetName):
        self._TargetName = TargetName

    @property
    def Status(self):
        """Status of the alias domain name. Values:
<li>`active`: Activated</li>
<li>`pending`: Deploying</li>
<li>`conflict`: Reclaimed</li>
<li>`stop`: Stopped</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ForbidMode(self):
        """The blocking mode. Values:
<li>`0`: Not blocked</li>
<li>`11`: Blocked due to regulatory compliance</li>
<li>`14`: Blocked due to ICP filing not obtained</li>
        :rtype: int
        """
        return self._ForbidMode

    @ForbidMode.setter
    def ForbidMode(self, ForbidMode):
        self._ForbidMode = ForbidMode

    @property
    def CreatedOn(self):
        """Creation time of the alias domain name.
        :rtype: str
        """
        return self._CreatedOn

    @CreatedOn.setter
    def CreatedOn(self, CreatedOn):
        self._CreatedOn = CreatedOn

    @property
    def ModifiedOn(self):
        """Modification time of the alias domain name.
        :rtype: str
        """
        return self._ModifiedOn

    @ModifiedOn.setter
    def ModifiedOn(self, ModifiedOn):
        self._ModifiedOn = ModifiedOn


    def _deserialize(self, params):
        self._AliasName = params.get("AliasName")
        self._ZoneId = params.get("ZoneId")
        self._TargetName = params.get("TargetName")
        self._Status = params.get("Status")
        self._ForbidMode = params.get("ForbidMode")
        self._CreatedOn = params.get("CreatedOn")
        self._ModifiedOn = params.get("ModifiedOn")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AllowActionParameters(AbstractModel):
    """Additional parameter for Web security Allow.

    """

    def __init__(self):
        r"""
        :param _MinDelayTime: Minimum latency response time. when configured as 0s, it means no delay for direct response. supported units: <li>s: seconds, value ranges from 0 to 5.</li>.
        :type MinDelayTime: str
        :param _MaxDelayTime: Maximum delayed response time. supported units: <li>s: seconds, value ranges from 5 to 10.</li>.
        :type MaxDelayTime: str
        """
        self._MinDelayTime = None
        self._MaxDelayTime = None

    @property
    def MinDelayTime(self):
        """Minimum latency response time. when configured as 0s, it means no delay for direct response. supported units: <li>s: seconds, value ranges from 0 to 5.</li>.
        :rtype: str
        """
        return self._MinDelayTime

    @MinDelayTime.setter
    def MinDelayTime(self, MinDelayTime):
        self._MinDelayTime = MinDelayTime

    @property
    def MaxDelayTime(self):
        """Maximum delayed response time. supported units: <li>s: seconds, value ranges from 5 to 10.</li>.
        :rtype: str
        """
        return self._MaxDelayTime

    @MaxDelayTime.setter
    def MaxDelayTime(self, MaxDelayTime):
        self._MaxDelayTime = MaxDelayTime


    def _deserialize(self, params):
        self._MinDelayTime = params.get("MinDelayTime")
        self._MaxDelayTime = params.get("MaxDelayTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationProxy(AbstractModel):
    """Application proxy instance

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        :param _ZoneName: The site name.
        :type ZoneName: str
        :param _ProxyId: The proxy ID.
        :type ProxyId: str
        :param _ProxyName: The domain name or subdomain name when `ProxyType=hostname`.
The instance name when `ProxyType=instance`.
        :type ProxyName: str
        :param _ProxyType: The proxy type. Values:
<li>`hostname`: The proxy is created by subdomain name.</li>
<li>`instance`: The proxy is created by instance.</li>
        :type ProxyType: str
        :param _PlatType: The scheduling mode. Values:
<li>`ip`: Schedule via Anycast IP.</li>
<li>`domain`: Schedule via CNAME.</li>
        :type PlatType: str
        :param _Area: Acceleration region. Values:
<li>`mainland`: Chinese mainland.</li>
<li>`overseas`: Global (outside the Chinese mainland);</li>
Default value: overseas.
        :type Area: str
        :param _SecurityType: Whether to enable security protection. Values:
<li>`0`: Disable security protection.</li>
<li>`1`: Enable security protection.</li>
        :type SecurityType: int
        :param _AccelerateType: Whether to enable acceleration. Values:
<li>`0`: Disable acceleration.</li>
<li>`1`: Enable acceleration.</li>
        :type AccelerateType: int
        :param _SessionPersistTime: The session persistence duration.
        :type SessionPersistTime: int
        :param _Status: The rule status. Values:
<li>`online`: Enabled</li>
<li>`offline`: Disabled</li>
<li>`progress`: Deploying</li>
<li>`stopping`: Disabling</li>
<li>`fail`: Failed to deploy or disable</li>
        :type Status: str
        :param _BanStatus: The blocking status of the proxy. Values:
<li>`banned`: Blocked</li>
<li>`banning`: Blocking</li>
<li>`recover`: Unblocked</li>
<li>`recovering`: Unblocking</li>
        :type BanStatus: str
        :param _ScheduleValue: Scheduling information.
        :type ScheduleValue: list of str
        :param _HostId: When `ProxyType=hostname`:
This field indicates the unique ID of the subdomain name.
        :type HostId: str
        :param _Ipv6: The IPv6 access configuration.
        :type Ipv6: :class:`tencentcloud.teo.v20220901.models.Ipv6`
        :param _UpdateTime: The update time.
        :type UpdateTime: str
        :param _ApplicationProxyRules: List of rules.
        :type ApplicationProxyRules: list of ApplicationProxyRule
        :param _AccelerateMainland: Cross-MLC-border acceleration.
        :type AccelerateMainland: :class:`tencentcloud.teo.v20220901.models.AccelerateMainland`
        """
        self._ZoneId = None
        self._ZoneName = None
        self._ProxyId = None
        self._ProxyName = None
        self._ProxyType = None
        self._PlatType = None
        self._Area = None
        self._SecurityType = None
        self._AccelerateType = None
        self._SessionPersistTime = None
        self._Status = None
        self._BanStatus = None
        self._ScheduleValue = None
        self._HostId = None
        self._Ipv6 = None
        self._UpdateTime = None
        self._ApplicationProxyRules = None
        self._AccelerateMainland = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ZoneName(self):
        """The site name.
        :rtype: str
        """
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName

    @property
    def ProxyId(self):
        """The proxy ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId

    @property
    def ProxyName(self):
        """The domain name or subdomain name when `ProxyType=hostname`.
The instance name when `ProxyType=instance`.
        :rtype: str
        """
        return self._ProxyName

    @ProxyName.setter
    def ProxyName(self, ProxyName):
        self._ProxyName = ProxyName

    @property
    def ProxyType(self):
        """The proxy type. Values:
<li>`hostname`: The proxy is created by subdomain name.</li>
<li>`instance`: The proxy is created by instance.</li>
        :rtype: str
        """
        return self._ProxyType

    @ProxyType.setter
    def ProxyType(self, ProxyType):
        self._ProxyType = ProxyType

    @property
    def PlatType(self):
        """The scheduling mode. Values:
<li>`ip`: Schedule via Anycast IP.</li>
<li>`domain`: Schedule via CNAME.</li>
        :rtype: str
        """
        return self._PlatType

    @PlatType.setter
    def PlatType(self, PlatType):
        self._PlatType = PlatType

    @property
    def Area(self):
        """Acceleration region. Values:
<li>`mainland`: Chinese mainland.</li>
<li>`overseas`: Global (outside the Chinese mainland);</li>
Default value: overseas.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def SecurityType(self):
        """Whether to enable security protection. Values:
<li>`0`: Disable security protection.</li>
<li>`1`: Enable security protection.</li>
        :rtype: int
        """
        return self._SecurityType

    @SecurityType.setter
    def SecurityType(self, SecurityType):
        self._SecurityType = SecurityType

    @property
    def AccelerateType(self):
        """Whether to enable acceleration. Values:
<li>`0`: Disable acceleration.</li>
<li>`1`: Enable acceleration.</li>
        :rtype: int
        """
        return self._AccelerateType

    @AccelerateType.setter
    def AccelerateType(self, AccelerateType):
        self._AccelerateType = AccelerateType

    @property
    def SessionPersistTime(self):
        """The session persistence duration.
        :rtype: int
        """
        return self._SessionPersistTime

    @SessionPersistTime.setter
    def SessionPersistTime(self, SessionPersistTime):
        self._SessionPersistTime = SessionPersistTime

    @property
    def Status(self):
        """The rule status. Values:
<li>`online`: Enabled</li>
<li>`offline`: Disabled</li>
<li>`progress`: Deploying</li>
<li>`stopping`: Disabling</li>
<li>`fail`: Failed to deploy or disable</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def BanStatus(self):
        """The blocking status of the proxy. Values:
<li>`banned`: Blocked</li>
<li>`banning`: Blocking</li>
<li>`recover`: Unblocked</li>
<li>`recovering`: Unblocking</li>
        :rtype: str
        """
        return self._BanStatus

    @BanStatus.setter
    def BanStatus(self, BanStatus):
        self._BanStatus = BanStatus

    @property
    def ScheduleValue(self):
        """Scheduling information.
        :rtype: list of str
        """
        return self._ScheduleValue

    @ScheduleValue.setter
    def ScheduleValue(self, ScheduleValue):
        self._ScheduleValue = ScheduleValue

    @property
    def HostId(self):
        """When `ProxyType=hostname`:
This field indicates the unique ID of the subdomain name.
        :rtype: str
        """
        return self._HostId

    @HostId.setter
    def HostId(self, HostId):
        self._HostId = HostId

    @property
    def Ipv6(self):
        """The IPv6 access configuration.
        :rtype: :class:`tencentcloud.teo.v20220901.models.Ipv6`
        """
        return self._Ipv6

    @Ipv6.setter
    def Ipv6(self, Ipv6):
        self._Ipv6 = Ipv6

    @property
    def UpdateTime(self):
        """The update time.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ApplicationProxyRules(self):
        """List of rules.
        :rtype: list of ApplicationProxyRule
        """
        return self._ApplicationProxyRules

    @ApplicationProxyRules.setter
    def ApplicationProxyRules(self, ApplicationProxyRules):
        self._ApplicationProxyRules = ApplicationProxyRules

    @property
    def AccelerateMainland(self):
        """Cross-MLC-border acceleration.
        :rtype: :class:`tencentcloud.teo.v20220901.models.AccelerateMainland`
        """
        return self._AccelerateMainland

    @AccelerateMainland.setter
    def AccelerateMainland(self, AccelerateMainland):
        self._AccelerateMainland = AccelerateMainland


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ZoneName = params.get("ZoneName")
        self._ProxyId = params.get("ProxyId")
        self._ProxyName = params.get("ProxyName")
        self._ProxyType = params.get("ProxyType")
        self._PlatType = params.get("PlatType")
        self._Area = params.get("Area")
        self._SecurityType = params.get("SecurityType")
        self._AccelerateType = params.get("AccelerateType")
        self._SessionPersistTime = params.get("SessionPersistTime")
        self._Status = params.get("Status")
        self._BanStatus = params.get("BanStatus")
        self._ScheduleValue = params.get("ScheduleValue")
        self._HostId = params.get("HostId")
        if params.get("Ipv6") is not None:
            self._Ipv6 = Ipv6()
            self._Ipv6._deserialize(params.get("Ipv6"))
        self._UpdateTime = params.get("UpdateTime")
        if params.get("ApplicationProxyRules") is not None:
            self._ApplicationProxyRules = []
            for item in params.get("ApplicationProxyRules"):
                obj = ApplicationProxyRule()
                obj._deserialize(item)
                self._ApplicationProxyRules.append(obj)
        if params.get("AccelerateMainland") is not None:
            self._AccelerateMainland = AccelerateMainland()
            self._AccelerateMainland._deserialize(params.get("AccelerateMainland"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationProxyRule(AbstractModel):
    """Application proxy rule

    """

    def __init__(self):
        r"""
        :param _Proto: Protocol. Valid values:
<li>TCP: TCP protocol;</li>
<li>UDP: UDP protocol.</li>
        :type Proto: str
        :param _Port: Port. Supported formats:
<li>A single port, such as 80.</li>
<li>A port range, such as 81-82, indicating two ports 81 and 82.</li>
Note: Up to 20 ports can be input for each rule.
        :type Port: list of str
        :param _OriginType: Origin server type. Valid values:
<li>custom: manually added;</li>
<li>loadbalancer: cloud load balancer;</li>
<li>origins: origin server group.</li>
        :type OriginType: str
        :param _OriginValue: Origin server information.
<li>When OriginType is custom, it indicates one or more origin servers, such as `["8.8.8.8","9.9.9.9"]` or `OriginValue=["test.com"]`;</li>
<li>When OriginType is loadbalancer, it indicates a cloud load balancer, such as ["lb-xdffsfasdfs"];</li>
<li>When OriginType is origins, it requires one and only one element, indicating the origin server group ID, such as ["origin-537f5b41-162a-11ed-abaa-525400c5da15"].</li>
        :type OriginValue: list of str
        :param _RuleId: Rule ID.
        :type RuleId: str
        :param _Status: Status. Valid values:
<li>online: enabled;</li>
<li>offline: disabled;</li>
<li>progress: deploying;</li>
<li>stopping: disabling;</li>
<li>fail: deployment or disabling failed.</li>
        :type Status: str
        :param _ForwardClientIp: Passing the client IP address. Valid values:
<li>TOA: passing via TOA, available only when Proto = TCP;</li>
<li>PPV1: passing via Proxy Protocol V1, available only when Proto = TCP;</li>
<li>PPV2: passing via Proxy Protocol V2;</li>
<li>OFF: no passing.</li>Default value: OFF.
        :type ForwardClientIp: str
        :param _SessionPersist: Whether to enable session persistence. Valid values:
<li>true: Enable;</li>
<li>false: Disable.</li>Default value: false.
        :type SessionPersist: bool
        :param _SessionPersistTime: Duration for session persistence. The value takes effect only when SessionPersist is true.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type SessionPersistTime: int
        :param _OriginPort: Origin server port. Supported formats:
<li>A single port, such as 80.</li>
<li>A port range, such as 81-82, indicating two ports 81 and 82.</li>
        :type OriginPort: str
        :param _RuleTag: Rule tag.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type RuleTag: str
        """
        self._Proto = None
        self._Port = None
        self._OriginType = None
        self._OriginValue = None
        self._RuleId = None
        self._Status = None
        self._ForwardClientIp = None
        self._SessionPersist = None
        self._SessionPersistTime = None
        self._OriginPort = None
        self._RuleTag = None

    @property
    def Proto(self):
        """Protocol. Valid values:
<li>TCP: TCP protocol;</li>
<li>UDP: UDP protocol.</li>
        :rtype: str
        """
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def Port(self):
        """Port. Supported formats:
<li>A single port, such as 80.</li>
<li>A port range, such as 81-82, indicating two ports 81 and 82.</li>
Note: Up to 20 ports can be input for each rule.
        :rtype: list of str
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def OriginType(self):
        """Origin server type. Valid values:
<li>custom: manually added;</li>
<li>loadbalancer: cloud load balancer;</li>
<li>origins: origin server group.</li>
        :rtype: str
        """
        return self._OriginType

    @OriginType.setter
    def OriginType(self, OriginType):
        self._OriginType = OriginType

    @property
    def OriginValue(self):
        """Origin server information.
<li>When OriginType is custom, it indicates one or more origin servers, such as `["8.8.8.8","9.9.9.9"]` or `OriginValue=["test.com"]`;</li>
<li>When OriginType is loadbalancer, it indicates a cloud load balancer, such as ["lb-xdffsfasdfs"];</li>
<li>When OriginType is origins, it requires one and only one element, indicating the origin server group ID, such as ["origin-537f5b41-162a-11ed-abaa-525400c5da15"].</li>
        :rtype: list of str
        """
        return self._OriginValue

    @OriginValue.setter
    def OriginValue(self, OriginValue):
        self._OriginValue = OriginValue

    @property
    def RuleId(self):
        """Rule ID.
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Status(self):
        """Status. Valid values:
<li>online: enabled;</li>
<li>offline: disabled;</li>
<li>progress: deploying;</li>
<li>stopping: disabling;</li>
<li>fail: deployment or disabling failed.</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ForwardClientIp(self):
        """Passing the client IP address. Valid values:
<li>TOA: passing via TOA, available only when Proto = TCP;</li>
<li>PPV1: passing via Proxy Protocol V1, available only when Proto = TCP;</li>
<li>PPV2: passing via Proxy Protocol V2;</li>
<li>OFF: no passing.</li>Default value: OFF.
        :rtype: str
        """
        return self._ForwardClientIp

    @ForwardClientIp.setter
    def ForwardClientIp(self, ForwardClientIp):
        self._ForwardClientIp = ForwardClientIp

    @property
    def SessionPersist(self):
        """Whether to enable session persistence. Valid values:
<li>true: Enable;</li>
<li>false: Disable.</li>Default value: false.
        :rtype: bool
        """
        return self._SessionPersist

    @SessionPersist.setter
    def SessionPersist(self, SessionPersist):
        self._SessionPersist = SessionPersist

    @property
    def SessionPersistTime(self):
        """Duration for session persistence. The value takes effect only when SessionPersist is true.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: int
        """
        return self._SessionPersistTime

    @SessionPersistTime.setter
    def SessionPersistTime(self, SessionPersistTime):
        self._SessionPersistTime = SessionPersistTime

    @property
    def OriginPort(self):
        """Origin server port. Supported formats:
<li>A single port, such as 80.</li>
<li>A port range, such as 81-82, indicating two ports 81 and 82.</li>
        :rtype: str
        """
        return self._OriginPort

    @OriginPort.setter
    def OriginPort(self, OriginPort):
        self._OriginPort = OriginPort

    @property
    def RuleTag(self):
        """Rule tag.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: str
        """
        return self._RuleTag

    @RuleTag.setter
    def RuleTag(self, RuleTag):
        self._RuleTag = RuleTag


    def _deserialize(self, params):
        self._Proto = params.get("Proto")
        self._Port = params.get("Port")
        self._OriginType = params.get("OriginType")
        self._OriginValue = params.get("OriginValue")
        self._RuleId = params.get("RuleId")
        self._Status = params.get("Status")
        self._ForwardClientIp = params.get("ForwardClientIp")
        self._SessionPersist = params.get("SessionPersist")
        self._SessionPersistTime = params.get("SessionPersistTime")
        self._OriginPort = params.get("OriginPort")
        self._RuleTag = params.get("RuleTag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AscriptionInfo(AbstractModel):
    """The site ownership information

    """

    def __init__(self):
        r"""
        :param _Subdomain: 
        :type Subdomain: str
        :param _RecordType: The record type.
        :type RecordType: str
        :param _RecordValue: The record value.
        :type RecordValue: str
        """
        self._Subdomain = None
        self._RecordType = None
        self._RecordValue = None

    @property
    def Subdomain(self):
        """
        :rtype: str
        """
        return self._Subdomain

    @Subdomain.setter
    def Subdomain(self, Subdomain):
        self._Subdomain = Subdomain

    @property
    def RecordType(self):
        """The record type.
        :rtype: str
        """
        return self._RecordType

    @RecordType.setter
    def RecordType(self, RecordType):
        self._RecordType = RecordType

    @property
    def RecordValue(self):
        """The record value.
        :rtype: str
        """
        return self._RecordValue

    @RecordValue.setter
    def RecordValue(self, RecordValue):
        self._RecordValue = RecordValue


    def _deserialize(self, params):
        self._Subdomain = params.get("Subdomain")
        self._RecordType = params.get("RecordType")
        self._RecordValue = params.get("RecordValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuthenticationParameters(AbstractModel):
    """Token authentication configuration parameters

    """

    def __init__(self):
        r"""
        :param _AuthType: Authentication type. valid values:.

<Li>TypeA: authentication method a type, for specific meaning please refer to [authentication method a](https://intl.cloud.tencent.com/document/product/1552/109329?from_cn_redirect=1);</li>.
<Li>TypeB: authentication method b type, for specific meaning please refer to [authentication method b](https://intl.cloud.tencent.com/document/product/1552/109330?from_cn_redirect=1);</li>.
<Li>TypeC: authentication method c type, for specific meaning please refer to [authentication method c](https://intl.cloud.tencent.com/document/product/1552/109331?from_cn_redirect=1);</li>.
<Li>TypeD: authentication method d type, for specific meaning please refer to [authentication method d](https://intl.cloud.tencent.com/document/product/1552/109332?from_cn_redirect=1);</li>.
<Li>TypeVOD: authentication method v type, for specific meaning please refer to [authentication method v](https://intl.cloud.tencent.com/document/product/1552/109333?from_cn_redirect=1).</li>.
        :type AuthType: str
        :param _SecretKey: The primary authentication key consists of 6–40 uppercase and lowercase english letters or digits, and cannot contain " and $.
        :type SecretKey: str
        :param _Timeout: Validity period of the authentication url, in seconds, value range: 1–630720000. used to determine if the client access request has expired:.
<Li>If the current time exceeds "timestamp + validity period", it is an expired request, and a 403 is returned directly.</li>.
<Li>If the current time does not exceed "timestamp + validity period", the request is not expired, and the md5 string is further validated.</li> note: when authtype is one of typea, typeb, typec, or typed, this field is required.
        :type Timeout: int
        :param _BackupSecretKey: The backup authentication key consists of 6–40 uppercase and lowercase english letters or digits, and cannot contain " and $.
        :type BackupSecretKey: str
        :param _AuthParam: Authentication parameters name. the node will validate the value corresponding to this parameter name. consists of 1-100 uppercase and lowercase letters, numbers, or underscores.<br>note: this field is required when authtype is either typea or typed.
        :type AuthParam: str
        :param _TimeParam: Authentication timestamp. it cannot be the same as the value of the authparam field.<br>note: this field is required when authtype is typed.
        :type TimeParam: str
        :param _TimeFormat: Authentication time format. values:.
<Li>Dec: decimal;</li>.
<Li>Hex: hexadecimal.</li>note: this field is required when authtype is typed. the default is hex.
        :type TimeFormat: str
        """
        self._AuthType = None
        self._SecretKey = None
        self._Timeout = None
        self._BackupSecretKey = None
        self._AuthParam = None
        self._TimeParam = None
        self._TimeFormat = None

    @property
    def AuthType(self):
        """Authentication type. valid values:.

<Li>TypeA: authentication method a type, for specific meaning please refer to [authentication method a](https://intl.cloud.tencent.com/document/product/1552/109329?from_cn_redirect=1);</li>.
<Li>TypeB: authentication method b type, for specific meaning please refer to [authentication method b](https://intl.cloud.tencent.com/document/product/1552/109330?from_cn_redirect=1);</li>.
<Li>TypeC: authentication method c type, for specific meaning please refer to [authentication method c](https://intl.cloud.tencent.com/document/product/1552/109331?from_cn_redirect=1);</li>.
<Li>TypeD: authentication method d type, for specific meaning please refer to [authentication method d](https://intl.cloud.tencent.com/document/product/1552/109332?from_cn_redirect=1);</li>.
<Li>TypeVOD: authentication method v type, for specific meaning please refer to [authentication method v](https://intl.cloud.tencent.com/document/product/1552/109333?from_cn_redirect=1).</li>.
        :rtype: str
        """
        return self._AuthType

    @AuthType.setter
    def AuthType(self, AuthType):
        self._AuthType = AuthType

    @property
    def SecretKey(self):
        """The primary authentication key consists of 6–40 uppercase and lowercase english letters or digits, and cannot contain " and $.
        :rtype: str
        """
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def Timeout(self):
        """Validity period of the authentication url, in seconds, value range: 1–630720000. used to determine if the client access request has expired:.
<Li>If the current time exceeds "timestamp + validity period", it is an expired request, and a 403 is returned directly.</li>.
<Li>If the current time does not exceed "timestamp + validity period", the request is not expired, and the md5 string is further validated.</li> note: when authtype is one of typea, typeb, typec, or typed, this field is required.
        :rtype: int
        """
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout

    @property
    def BackupSecretKey(self):
        """The backup authentication key consists of 6–40 uppercase and lowercase english letters or digits, and cannot contain " and $.
        :rtype: str
        """
        return self._BackupSecretKey

    @BackupSecretKey.setter
    def BackupSecretKey(self, BackupSecretKey):
        self._BackupSecretKey = BackupSecretKey

    @property
    def AuthParam(self):
        """Authentication parameters name. the node will validate the value corresponding to this parameter name. consists of 1-100 uppercase and lowercase letters, numbers, or underscores.<br>note: this field is required when authtype is either typea or typed.
        :rtype: str
        """
        return self._AuthParam

    @AuthParam.setter
    def AuthParam(self, AuthParam):
        self._AuthParam = AuthParam

    @property
    def TimeParam(self):
        """Authentication timestamp. it cannot be the same as the value of the authparam field.<br>note: this field is required when authtype is typed.
        :rtype: str
        """
        return self._TimeParam

    @TimeParam.setter
    def TimeParam(self, TimeParam):
        self._TimeParam = TimeParam

    @property
    def TimeFormat(self):
        """Authentication time format. values:.
<Li>Dec: decimal;</li>.
<Li>Hex: hexadecimal.</li>note: this field is required when authtype is typed. the default is hex.
        :rtype: str
        """
        return self._TimeFormat

    @TimeFormat.setter
    def TimeFormat(self, TimeFormat):
        self._TimeFormat = TimeFormat


    def _deserialize(self, params):
        self._AuthType = params.get("AuthType")
        self._SecretKey = params.get("SecretKey")
        self._Timeout = params.get("Timeout")
        self._BackupSecretKey = params.get("BackupSecretKey")
        self._AuthParam = params.get("AuthParam")
        self._TimeParam = params.get("TimeParam")
        self._TimeFormat = params.get("TimeFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BandwidthAbuseDefense(AbstractModel):
    """Bandwidth abuse protection configuration (chinese mainland only).

    """

    def __init__(self):
        r"""
        :param _Enabled: Whether bandwidth abuse protection (applicable to chinese mainland only) is enabled. valid values: <li>on: enabled;</li> <li>off: disabled.</li>.
        :type Enabled: str
        :param _Action: Bandwidth abuse protection (applicable to chinese mainland) handling method. required when Enabled is on. valid values for SecurityAction Name: <li>Monitor: observe;</li> <li>Deny: block;</li> <li>Challenge: Challenge, where ChallengeActionParameters.Name only supports JSChallenge.</li>.
        :type Action: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        self._Enabled = None
        self._Action = None

    @property
    def Enabled(self):
        """Whether bandwidth abuse protection (applicable to chinese mainland only) is enabled. valid values: <li>on: enabled;</li> <li>off: disabled.</li>.
        :rtype: str
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def Action(self):
        """Bandwidth abuse protection (applicable to chinese mainland) handling method. required when Enabled is on. valid values for SecurityAction Name: <li>Monitor: observe;</li> <li>Deny: block;</li> <li>Challenge: Challenge, where ChallengeActionParameters.Name only supports JSChallenge.</li>.
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action


    def _deserialize(self, params):
        self._Enabled = params.get("Enabled")
        if params.get("Action") is not None:
            self._Action = SecurityAction()
            self._Action._deserialize(params.get("Action"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BillingData(AbstractModel):
    """Billing data item

    """

    def __init__(self):
        r"""
        :param _Time: Data timestamp.
        :type Time: str
        :param _Value: Value.
        :type Value: int
        :param _ZoneId: Zone ID (or content identifier if enabled).
        :type ZoneId: str
        :param _Host: Domain name.
        :type Host: str
        :param _ProxyId: Layer-4 proxy instance ID.
        :type ProxyId: str
        :param _RegionId: Billing region (based on EdgeOne node location). Values: 
<li>CH: Mainland China</li> <li>AF: Africa</li> <li>AS1: Asia Pacific Region 1</li> <li>AS2: Asia Pacific Region 2</li> <li>AS3: Asia Pacific Region 3</li> <li>EU: Europe</li> <li>MidEast: Middle East</li> <li>NA: North America</li> <li>SA: South America</li>
        :type RegionId: str
        """
        self._Time = None
        self._Value = None
        self._ZoneId = None
        self._Host = None
        self._ProxyId = None
        self._RegionId = None

    @property
    def Time(self):
        """Data timestamp.
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Value(self):
        """Value.
        :rtype: int
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def ZoneId(self):
        """Zone ID (or content identifier if enabled).
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Host(self):
        """Domain name.
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def ProxyId(self):
        """Layer-4 proxy instance ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId

    @property
    def RegionId(self):
        """Billing region (based on EdgeOne node location). Values: 
<li>CH: Mainland China</li> <li>AF: Africa</li> <li>AS1: Asia Pacific Region 1</li> <li>AS2: Asia Pacific Region 2</li> <li>AS3: Asia Pacific Region 3</li> <li>EU: Europe</li> <li>MidEast: Middle East</li> <li>NA: North America</li> <li>SA: South America</li>
        :rtype: str
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._Value = params.get("Value")
        self._ZoneId = params.get("ZoneId")
        self._Host = params.get("Host")
        self._ProxyId = params.get("ProxyId")
        self._RegionId = params.get("RegionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BillingDataFilter(AbstractModel):
    """Billing data filter criteria.

    """

    def __init__(self):
        r"""
        :param _Type: Parameter name.
        :type Type: str
        :param _Value: Parameter value.
        :type Value: str
        """
        self._Type = None
        self._Value = None

    @property
    def Type(self):
        """Parameter name.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Value(self):
        """Parameter value.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindDomainInfo(AbstractModel):
    """Describes the domain names bound to the policy template.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name.
        :type Domain: str
        :param _ZoneId: Zone ID to which the domain belongs.
        :type ZoneId: str
        :param _Status: Binding status. valid values:. 
<li>`process`: binding in progress</li>
<li>`online`: binding succeeded.</li>
<Li>`fail`: binding failed.</li>
        :type Status: str
        """
        self._Domain = None
        self._ZoneId = None
        self._Status = None

    @property
    def Domain(self):
        """Domain name.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def ZoneId(self):
        """Zone ID to which the domain belongs.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Status(self):
        """Binding status. valid values:. 
<li>`process`: binding in progress</li>
<li>`online`: binding succeeded.</li>
<Li>`fail`: binding failed.</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._ZoneId = params.get("ZoneId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindSecurityTemplateToEntityRequest(AbstractModel):
    """BindSecurityTemplateToEntity request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID of the policy template to be bound to or unbound from.
        :type ZoneId: str
        :param _Entities: List of domain names to bind to/unbind from a policy template
        :type Entities: list of str
        :param _Operate: Action options. Values include:
<li>`bind`: Bind the domain names to the specified policy template </li>
<li>`unbind-keep-policy`: Unbind a domain name from a policy template and keep the current policy when unbinding</li>
<li>`unbind-use-default`: Unbind domain names from policy templates and use default blank policy.</li> Note: Only one domain name can be unbound at one time. When `Operate` is `unbind-keep-policy` or `unbind-use-default`, there can only be one domain name specified in `Entities`.
        :type Operate: str
        :param _TemplateId: Specifies the ID of the policy template or the site's global policy to be bound or unbound.
- To bind to a policy template, or unbind from it, specify the policy template ID.
- To bind to the site's global policy, or unbind from it, use the @ZoneLevel@domain parameter value.

Note: After unbinding, the domain name will use an independent policy and rule quota will be calculated separately. Please make sure there is sufficient rule quota before unbinding.
        :type TemplateId: str
        :param _OverWrite: Whether to replace the existing policy template bound with the domain name. Values: 
<li>`true`: Replace the template bound to the domain. </li>
<li>`false`: Do not replace the template.</li> Note: In this case, the API returns an error if there is already a policy template bound to the specified domain name.
        :type OverWrite: bool
        """
        self._ZoneId = None
        self._Entities = None
        self._Operate = None
        self._TemplateId = None
        self._OverWrite = None

    @property
    def ZoneId(self):
        """Site ID of the policy template to be bound to or unbound from.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Entities(self):
        """List of domain names to bind to/unbind from a policy template
        :rtype: list of str
        """
        return self._Entities

    @Entities.setter
    def Entities(self, Entities):
        self._Entities = Entities

    @property
    def Operate(self):
        """Action options. Values include:
<li>`bind`: Bind the domain names to the specified policy template </li>
<li>`unbind-keep-policy`: Unbind a domain name from a policy template and keep the current policy when unbinding</li>
<li>`unbind-use-default`: Unbind domain names from policy templates and use default blank policy.</li> Note: Only one domain name can be unbound at one time. When `Operate` is `unbind-keep-policy` or `unbind-use-default`, there can only be one domain name specified in `Entities`.
        :rtype: str
        """
        return self._Operate

    @Operate.setter
    def Operate(self, Operate):
        self._Operate = Operate

    @property
    def TemplateId(self):
        """Specifies the ID of the policy template or the site's global policy to be bound or unbound.
- To bind to a policy template, or unbind from it, specify the policy template ID.
- To bind to the site's global policy, or unbind from it, use the @ZoneLevel@domain parameter value.

Note: After unbinding, the domain name will use an independent policy and rule quota will be calculated separately. Please make sure there is sufficient rule quota before unbinding.
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def OverWrite(self):
        """Whether to replace the existing policy template bound with the domain name. Values: 
<li>`true`: Replace the template bound to the domain. </li>
<li>`false`: Do not replace the template.</li> Note: In this case, the API returns an error if there is already a policy template bound to the specified domain name.
        :rtype: bool
        """
        return self._OverWrite

    @OverWrite.setter
    def OverWrite(self, OverWrite):
        self._OverWrite = OverWrite


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Entities = params.get("Entities")
        self._Operate = params.get("Operate")
        self._TemplateId = params.get("TemplateId")
        self._OverWrite = params.get("OverWrite")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindSecurityTemplateToEntityResponse(AbstractModel):
    """BindSecurityTemplateToEntity response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BindSharedCNAMEMap(AbstractModel):
    """Bindings between a shared CNAME and connected domain names

    """

    def __init__(self):
        r"""
        :param _SharedCNAME: The shared CNAME to be bound with or unbound from.
        :type SharedCNAME: str
        :param _DomainNames: Acceleration domains (up to 20).
        :type DomainNames: list of str
        """
        self._SharedCNAME = None
        self._DomainNames = None

    @property
    def SharedCNAME(self):
        """The shared CNAME to be bound with or unbound from.
        :rtype: str
        """
        return self._SharedCNAME

    @SharedCNAME.setter
    def SharedCNAME(self, SharedCNAME):
        self._SharedCNAME = SharedCNAME

    @property
    def DomainNames(self):
        """Acceleration domains (up to 20).
        :rtype: list of str
        """
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames


    def _deserialize(self, params):
        self._SharedCNAME = params.get("SharedCNAME")
        self._DomainNames = params.get("DomainNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindSharedCNAMERequest(AbstractModel):
    """BindSharedCNAME request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site related with the acceleration domain name.	
        :type ZoneId: str
        :param _BindType: Action type. Values:
<li>`bind`: To bind</li>
<li>`unbind`: To unbind</li>
        :type BindType: str
        :param _BindSharedCNAMEMaps: Bindings between domain names and a shared CNAME
        :type BindSharedCNAMEMaps: list of BindSharedCNAMEMap
        """
        self._ZoneId = None
        self._BindType = None
        self._BindSharedCNAMEMaps = None

    @property
    def ZoneId(self):
        """ID of the site related with the acceleration domain name.	
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def BindType(self):
        """Action type. Values:
<li>`bind`: To bind</li>
<li>`unbind`: To unbind</li>
        :rtype: str
        """
        return self._BindType

    @BindType.setter
    def BindType(self, BindType):
        self._BindType = BindType

    @property
    def BindSharedCNAMEMaps(self):
        """Bindings between domain names and a shared CNAME
        :rtype: list of BindSharedCNAMEMap
        """
        return self._BindSharedCNAMEMaps

    @BindSharedCNAMEMaps.setter
    def BindSharedCNAMEMaps(self, BindSharedCNAMEMaps):
        self._BindSharedCNAMEMaps = BindSharedCNAMEMaps


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._BindType = params.get("BindType")
        if params.get("BindSharedCNAMEMaps") is not None:
            self._BindSharedCNAMEMaps = []
            for item in params.get("BindSharedCNAMEMaps"):
                obj = BindSharedCNAMEMap()
                obj._deserialize(item)
                self._BindSharedCNAMEMaps.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindSharedCNAMEResponse(AbstractModel):
    """BindSharedCNAME response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BindZoneToPlanRequest(AbstractModel):
    """BindZoneToPlan request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site to be bound.
        :type ZoneId: str
        :param _PlanId: ID of the target plan.
        :type PlanId: str
        """
        self._ZoneId = None
        self._PlanId = None

    @property
    def ZoneId(self):
        """ID of the site to be bound.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def PlanId(self):
        """ID of the target plan.
        :rtype: str
        """
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._PlanId = params.get("PlanId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindZoneToPlanResponse(AbstractModel):
    """BindZoneToPlan response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BlockIPActionParameters(AbstractModel):
    """Additional parameter for SecurityAction `BlockIP`.

    """

    def __init__(self):
        r"""
        :param _Duration: Penalty duration for `BlockIP`. Units: <li>`s`: second, value range 1-120;</li> <li>`m`: minute, value range 1-120;</li> <li>`h`: hour, value range 1-48.</li>.
        :type Duration: str
        """
        self._Duration = None

    @property
    def Duration(self):
        """Penalty duration for `BlockIP`. Units: <li>`s`: second, value range 1-120;</li> <li>`m`: minute, value range 1-120;</li> <li>`h`: hour, value range 1-48.</li>.
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotConfig(AbstractModel):
    """Bot security configuration

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable bot security. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _BotManagedRule: The settings of the bot managed rule. If it is null, the settings that were last configured will be used.
        :type BotManagedRule: :class:`tencentcloud.teo.v20220901.models.BotManagedRule`
        :param _BotPortraitRule: The settings of the client reputation rule. If it is null, the settings that were last configured will be used.
        :type BotPortraitRule: :class:`tencentcloud.teo.v20220901.models.BotPortraitRule`
        :param _IntelligenceRule: The bot intelligence settings. If it is null, the settings that were last configured will be used.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IntelligenceRule: :class:`tencentcloud.teo.v20220901.models.IntelligenceRule`
        :param _BotUserRules: Settings of the custom bot rule. If it is null, the settings that were last configured will be used.
        :type BotUserRules: list of BotUserRule
        :param _AlgDetectRule: Active bot detection rule.
        :type AlgDetectRule: list of AlgDetectRule
        :param _Customizes: Settings of the bot managed rule. It is only used for output.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Customizes: list of BotUserRule
        """
        self._Switch = None
        self._BotManagedRule = None
        self._BotPortraitRule = None
        self._IntelligenceRule = None
        self._BotUserRules = None
        self._AlgDetectRule = None
        self._Customizes = None

    @property
    def Switch(self):
        """Whether to enable bot security. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BotManagedRule(self):
        """The settings of the bot managed rule. If it is null, the settings that were last configured will be used.
        :rtype: :class:`tencentcloud.teo.v20220901.models.BotManagedRule`
        """
        return self._BotManagedRule

    @BotManagedRule.setter
    def BotManagedRule(self, BotManagedRule):
        self._BotManagedRule = BotManagedRule

    @property
    def BotPortraitRule(self):
        """The settings of the client reputation rule. If it is null, the settings that were last configured will be used.
        :rtype: :class:`tencentcloud.teo.v20220901.models.BotPortraitRule`
        """
        return self._BotPortraitRule

    @BotPortraitRule.setter
    def BotPortraitRule(self, BotPortraitRule):
        self._BotPortraitRule = BotPortraitRule

    @property
    def IntelligenceRule(self):
        """The bot intelligence settings. If it is null, the settings that were last configured will be used.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.IntelligenceRule`
        """
        return self._IntelligenceRule

    @IntelligenceRule.setter
    def IntelligenceRule(self, IntelligenceRule):
        self._IntelligenceRule = IntelligenceRule

    @property
    def BotUserRules(self):
        """Settings of the custom bot rule. If it is null, the settings that were last configured will be used.
        :rtype: list of BotUserRule
        """
        return self._BotUserRules

    @BotUserRules.setter
    def BotUserRules(self, BotUserRules):
        self._BotUserRules = BotUserRules

    @property
    def AlgDetectRule(self):
        """Active bot detection rule.
        :rtype: list of AlgDetectRule
        """
        return self._AlgDetectRule

    @AlgDetectRule.setter
    def AlgDetectRule(self, AlgDetectRule):
        self._AlgDetectRule = AlgDetectRule

    @property
    def Customizes(self):
        """Settings of the bot managed rule. It is only used for output.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of BotUserRule
        """
        return self._Customizes

    @Customizes.setter
    def Customizes(self, Customizes):
        self._Customizes = Customizes


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        if params.get("BotManagedRule") is not None:
            self._BotManagedRule = BotManagedRule()
            self._BotManagedRule._deserialize(params.get("BotManagedRule"))
        if params.get("BotPortraitRule") is not None:
            self._BotPortraitRule = BotPortraitRule()
            self._BotPortraitRule._deserialize(params.get("BotPortraitRule"))
        if params.get("IntelligenceRule") is not None:
            self._IntelligenceRule = IntelligenceRule()
            self._IntelligenceRule._deserialize(params.get("IntelligenceRule"))
        if params.get("BotUserRules") is not None:
            self._BotUserRules = []
            for item in params.get("BotUserRules"):
                obj = BotUserRule()
                obj._deserialize(item)
                self._BotUserRules.append(obj)
        if params.get("AlgDetectRule") is not None:
            self._AlgDetectRule = []
            for item in params.get("AlgDetectRule"):
                obj = AlgDetectRule()
                obj._deserialize(item)
                self._AlgDetectRule.append(obj)
        if params.get("Customizes") is not None:
            self._Customizes = []
            for item in params.get("Customizes"):
                obj = BotUserRule()
                obj._deserialize(item)
                self._Customizes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotExtendAction(AbstractModel):
    """Bot extended actions

    """

    def __init__(self):
        r"""
        :param _Action: Action. Valid values: 
<li>`monitor`: Observe;</li>
<li>`alg`: JavaScript challenge;</li>
<li>`captcha`: Managed challenge;</li>
<li>`random`: Actions are executed based on the percentage specified in `ExtendActions`;</li>
<li>`silence`: Silence;</li>
<li>`shortdelay`: Add short latency;</li>
<li>`longdelay`: Add long latency.</li>
        :type Action: str
        :param _Percent: The probability for triggering the action. Value range: 0-100.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Percent: int
        """
        self._Action = None
        self._Percent = None

    @property
    def Action(self):
        """Action. Valid values: 
<li>`monitor`: Observe;</li>
<li>`alg`: JavaScript challenge;</li>
<li>`captcha`: Managed challenge;</li>
<li>`random`: Actions are executed based on the percentage specified in `ExtendActions`;</li>
<li>`silence`: Silence;</li>
<li>`shortdelay`: Add short latency;</li>
<li>`longdelay`: Add long latency.</li>
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Percent(self):
        """The probability for triggering the action. Value range: 0-100.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Percent

    @Percent.setter
    def Percent(self, Percent):
        self._Percent = Percent


    def _deserialize(self, params):
        self._Action = params.get("Action")
        self._Percent = params.get("Percent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotManagedRule(AbstractModel):
    """Bot managed rules. The rule IDs can be obtained from the output of DescribeBotManagedRules.

    """

    def __init__(self):
        r"""
        :param _Action: The rule action. Values:
<li>`drop`: Block</li>
<li>`trans`: Allow</li>
<li>`alg`: JavaScript challenge</li>
<li>`monitor`: Observe</li>
        :type Action: str
        :param _RuleID: The rule ID, which is only used as an output parameter.
        :type RuleID: int
        :param _TransManagedIds: The ID of the rule that applies the "Allow" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TransManagedIds: list of int
        :param _AlgManagedIds: The ID of the rule that applies the "JavaScript challenge" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AlgManagedIds: list of int
        :param _CapManagedIds: The ID of the rule that applies the "Managed challenge" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CapManagedIds: list of int
        :param _MonManagedIds: The ID of the rule that applies the "Observe" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MonManagedIds: list of int
        :param _DropManagedIds: The ID of the rule that applies the "Block" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DropManagedIds: list of int
        """
        self._Action = None
        self._RuleID = None
        self._TransManagedIds = None
        self._AlgManagedIds = None
        self._CapManagedIds = None
        self._MonManagedIds = None
        self._DropManagedIds = None

    @property
    def Action(self):
        """The rule action. Values:
<li>`drop`: Block</li>
<li>`trans`: Allow</li>
<li>`alg`: JavaScript challenge</li>
<li>`monitor`: Observe</li>
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def RuleID(self):
        """The rule ID, which is only used as an output parameter.
        :rtype: int
        """
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def TransManagedIds(self):
        """The ID of the rule that applies the "Allow" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._TransManagedIds

    @TransManagedIds.setter
    def TransManagedIds(self, TransManagedIds):
        self._TransManagedIds = TransManagedIds

    @property
    def AlgManagedIds(self):
        """The ID of the rule that applies the "JavaScript challenge" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._AlgManagedIds

    @AlgManagedIds.setter
    def AlgManagedIds(self, AlgManagedIds):
        self._AlgManagedIds = AlgManagedIds

    @property
    def CapManagedIds(self):
        """The ID of the rule that applies the "Managed challenge" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._CapManagedIds

    @CapManagedIds.setter
    def CapManagedIds(self, CapManagedIds):
        self._CapManagedIds = CapManagedIds

    @property
    def MonManagedIds(self):
        """The ID of the rule that applies the "Observe" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._MonManagedIds

    @MonManagedIds.setter
    def MonManagedIds(self, MonManagedIds):
        self._MonManagedIds = MonManagedIds

    @property
    def DropManagedIds(self):
        """The ID of the rule that applies the "Block" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._DropManagedIds

    @DropManagedIds.setter
    def DropManagedIds(self, DropManagedIds):
        self._DropManagedIds = DropManagedIds


    def _deserialize(self, params):
        self._Action = params.get("Action")
        self._RuleID = params.get("RuleID")
        self._TransManagedIds = params.get("TransManagedIds")
        self._AlgManagedIds = params.get("AlgManagedIds")
        self._CapManagedIds = params.get("CapManagedIds")
        self._MonManagedIds = params.get("MonManagedIds")
        self._DropManagedIds = params.get("DropManagedIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotManagement(AbstractModel):
    """Web security BOT managed rules architecture.

    """

    def __init__(self):
        r"""
        :param _ClientAttestationRules: Definition list of client authentication rules. feature in beta test. submit a ticket or contact smart customer service if needed.
        :type ClientAttestationRules: :class:`tencentcloud.teo.v20220901.models.ClientAttestationRules`
        """
        self._ClientAttestationRules = None

    @property
    def ClientAttestationRules(self):
        """Definition list of client authentication rules. feature in beta test. submit a ticket or contact smart customer service if needed.
        :rtype: :class:`tencentcloud.teo.v20220901.models.ClientAttestationRules`
        """
        return self._ClientAttestationRules

    @ClientAttestationRules.setter
    def ClientAttestationRules(self, ClientAttestationRules):
        self._ClientAttestationRules = ClientAttestationRules


    def _deserialize(self, params):
        if params.get("ClientAttestationRules") is not None:
            self._ClientAttestationRules = ClientAttestationRules()
            self._ClientAttestationRules._deserialize(params.get("ClientAttestationRules"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotPortraitRule(AbstractModel):
    """Bot user portrait rules

    """

    def __init__(self):
        r"""
        :param _Switch: Switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _RuleID: The rule ID, which is only used as an output parameter.
        :type RuleID: int
        :param _AlgManagedIds: The ID of the rule that applies the "JavaScript challenge" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AlgManagedIds: list of int
        :param _CapManagedIds: The ID of the rule that applies the "Managed challenge" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CapManagedIds: list of int
        :param _MonManagedIds: The ID of the rule that applies the "Observe" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MonManagedIds: list of int
        :param _DropManagedIds: The ID of the rule that applies the "Block" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DropManagedIds: list of int
        """
        self._Switch = None
        self._RuleID = None
        self._AlgManagedIds = None
        self._CapManagedIds = None
        self._MonManagedIds = None
        self._DropManagedIds = None

    @property
    def Switch(self):
        """Switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def RuleID(self):
        """The rule ID, which is only used as an output parameter.
        :rtype: int
        """
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def AlgManagedIds(self):
        """The ID of the rule that applies the "JavaScript challenge" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._AlgManagedIds

    @AlgManagedIds.setter
    def AlgManagedIds(self, AlgManagedIds):
        self._AlgManagedIds = AlgManagedIds

    @property
    def CapManagedIds(self):
        """The ID of the rule that applies the "Managed challenge" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._CapManagedIds

    @CapManagedIds.setter
    def CapManagedIds(self, CapManagedIds):
        self._CapManagedIds = CapManagedIds

    @property
    def MonManagedIds(self):
        """The ID of the rule that applies the "Observe" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._MonManagedIds

    @MonManagedIds.setter
    def MonManagedIds(self, MonManagedIds):
        self._MonManagedIds = MonManagedIds

    @property
    def DropManagedIds(self):
        """The ID of the rule that applies the "Block" action.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._DropManagedIds

    @DropManagedIds.setter
    def DropManagedIds(self, DropManagedIds):
        self._DropManagedIds = DropManagedIds


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._RuleID = params.get("RuleID")
        self._AlgManagedIds = params.get("AlgManagedIds")
        self._CapManagedIds = params.get("CapManagedIds")
        self._MonManagedIds = params.get("MonManagedIds")
        self._DropManagedIds = params.get("DropManagedIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotUserRule(AbstractModel):
    """Custom bot rules

    """

    def __init__(self):
        r"""
        :param _RuleName: 
        :type RuleName: str
        :param _Action: The action. Values:
<li>`drop`: Block the request</li>
<li>`monitor`: Observe</li>
<li>`trans`: Allow</li>
<li>`redirect`: Redirect the request</li>
<li>`page`: Return the specified page</li>
<li>`alg`: JavaScript challenge</li>
<li>`captcha`: Managed challenge</li>
<li>`random`: Handle the request randomly by the weight</li>
<li>`silence`: Keep the connection but do not response to the client</li>
<li>`shortdelay`: Add a short latency period</li>
<li>`longdelay`: Add a long latency period</li>
        :type Action: str
        :param _RuleStatus: The rule status. Values:
<li>`on`: Enabled</li>
<li>`off`: Disabled</li>Default value: `on`
        :type RuleStatus: str
        :param _AclConditions: Details of the rule.
        :type AclConditions: list of AclCondition
        :param _RulePriority: The rule weight. Value range: 0-100.
        :type RulePriority: int
        :param _RuleID: Rule ID, which is only used as an output parameter.
        :type RuleID: int
        :param _ExtendActions: [Currently unavailable] Specify the random action and percentage.
        :type ExtendActions: list of BotExtendAction
        :param _FreqFields: The filter. Values:
<li>`sip`: Client IP</li>
This parameter is left empty by default.
        :type FreqFields: list of str
        :param _UpdateTime: The update time, which is only used as an output parameter.
        :type UpdateTime: str
        :param _FreqScope: Query scope. Values:
<li>`source_to_eo`: (Response) Traffic going from the origin to EdgeOne.</li>
<li>`client_to_eo`: (Request) Traffic going from the client to EdgeOne.</li>
Default: `source_to_eo`.
        :type FreqScope: list of str
        :param _Name: Name of the custom return page. It's required when `Action=page`.
        :type Name: str
        :param _CustomResponseId: ID of custom response. The ID can be obtained via the `DescribeCustomErrorPages` API. It's required when `Action=page`.	
        :type CustomResponseId: str
        :param _ResponseCode: The response code to trigger the return page. It's required when `Action=page`. Value: 100-600. 3xx response codes are not supported. Default value: 567.
        :type ResponseCode: int
        :param _RedirectUrl: The redirection URL. It's required when `Action=redirect`.
        :type RedirectUrl: str
        """
        self._RuleName = None
        self._Action = None
        self._RuleStatus = None
        self._AclConditions = None
        self._RulePriority = None
        self._RuleID = None
        self._ExtendActions = None
        self._FreqFields = None
        self._UpdateTime = None
        self._FreqScope = None
        self._Name = None
        self._CustomResponseId = None
        self._ResponseCode = None
        self._RedirectUrl = None

    @property
    def RuleName(self):
        """
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Action(self):
        """The action. Values:
<li>`drop`: Block the request</li>
<li>`monitor`: Observe</li>
<li>`trans`: Allow</li>
<li>`redirect`: Redirect the request</li>
<li>`page`: Return the specified page</li>
<li>`alg`: JavaScript challenge</li>
<li>`captcha`: Managed challenge</li>
<li>`random`: Handle the request randomly by the weight</li>
<li>`silence`: Keep the connection but do not response to the client</li>
<li>`shortdelay`: Add a short latency period</li>
<li>`longdelay`: Add a long latency period</li>
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def RuleStatus(self):
        """The rule status. Values:
<li>`on`: Enabled</li>
<li>`off`: Disabled</li>Default value: `on`
        :rtype: str
        """
        return self._RuleStatus

    @RuleStatus.setter
    def RuleStatus(self, RuleStatus):
        self._RuleStatus = RuleStatus

    @property
    def AclConditions(self):
        """Details of the rule.
        :rtype: list of AclCondition
        """
        return self._AclConditions

    @AclConditions.setter
    def AclConditions(self, AclConditions):
        self._AclConditions = AclConditions

    @property
    def RulePriority(self):
        """The rule weight. Value range: 0-100.
        :rtype: int
        """
        return self._RulePriority

    @RulePriority.setter
    def RulePriority(self, RulePriority):
        self._RulePriority = RulePriority

    @property
    def RuleID(self):
        """Rule ID, which is only used as an output parameter.
        :rtype: int
        """
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def ExtendActions(self):
        """[Currently unavailable] Specify the random action and percentage.
        :rtype: list of BotExtendAction
        """
        return self._ExtendActions

    @ExtendActions.setter
    def ExtendActions(self, ExtendActions):
        self._ExtendActions = ExtendActions

    @property
    def FreqFields(self):
        """The filter. Values:
<li>`sip`: Client IP</li>
This parameter is left empty by default.
        :rtype: list of str
        """
        return self._FreqFields

    @FreqFields.setter
    def FreqFields(self, FreqFields):
        self._FreqFields = FreqFields

    @property
    def UpdateTime(self):
        """The update time, which is only used as an output parameter.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FreqScope(self):
        """Query scope. Values:
<li>`source_to_eo`: (Response) Traffic going from the origin to EdgeOne.</li>
<li>`client_to_eo`: (Request) Traffic going from the client to EdgeOne.</li>
Default: `source_to_eo`.
        :rtype: list of str
        """
        return self._FreqScope

    @FreqScope.setter
    def FreqScope(self, FreqScope):
        self._FreqScope = FreqScope

    @property
    def Name(self):
        """Name of the custom return page. It's required when `Action=page`.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def CustomResponseId(self):
        """ID of custom response. The ID can be obtained via the `DescribeCustomErrorPages` API. It's required when `Action=page`.	
        :rtype: str
        """
        return self._CustomResponseId

    @CustomResponseId.setter
    def CustomResponseId(self, CustomResponseId):
        self._CustomResponseId = CustomResponseId

    @property
    def ResponseCode(self):
        """The response code to trigger the return page. It's required when `Action=page`. Value: 100-600. 3xx response codes are not supported. Default value: 567.
        :rtype: int
        """
        return self._ResponseCode

    @ResponseCode.setter
    def ResponseCode(self, ResponseCode):
        self._ResponseCode = ResponseCode

    @property
    def RedirectUrl(self):
        """The redirection URL. It's required when `Action=redirect`.
        :rtype: str
        """
        return self._RedirectUrl

    @RedirectUrl.setter
    def RedirectUrl(self, RedirectUrl):
        self._RedirectUrl = RedirectUrl


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        self._Action = params.get("Action")
        self._RuleStatus = params.get("RuleStatus")
        if params.get("AclConditions") is not None:
            self._AclConditions = []
            for item in params.get("AclConditions"):
                obj = AclCondition()
                obj._deserialize(item)
                self._AclConditions.append(obj)
        self._RulePriority = params.get("RulePriority")
        self._RuleID = params.get("RuleID")
        if params.get("ExtendActions") is not None:
            self._ExtendActions = []
            for item in params.get("ExtendActions"):
                obj = BotExtendAction()
                obj._deserialize(item)
                self._ExtendActions.append(obj)
        self._FreqFields = params.get("FreqFields")
        self._UpdateTime = params.get("UpdateTime")
        self._FreqScope = params.get("FreqScope")
        self._Name = params.get("Name")
        self._CustomResponseId = params.get("CustomResponseId")
        self._ResponseCode = params.get("ResponseCode")
        self._RedirectUrl = params.get("RedirectUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CC(AbstractModel):
    """CC configuration item.

    """

    def __init__(self):
        r"""
        :param _Switch: WAF switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _PolicyId: ID of the policy
        :type PolicyId: int
        """
        self._Switch = None
        self._PolicyId = None

    @property
    def Switch(self):
        """WAF switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def PolicyId(self):
        """ID of the policy
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._PolicyId = params.get("PolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CLSTopic(AbstractModel):
    """The configuration information of real-time log delivery to Tencent Cloud CLS

    """

    def __init__(self):
        r"""
        :param _LogSetId: The ID of the Tencent Cloud CLS log set.
        :type LogSetId: str
        :param _TopicId: The ID of the Tencent Cloud CLS log topic.
        :type TopicId: str
        :param _LogSetRegion: The region of the Tencent Cloud CLS log set.
        :type LogSetRegion: str
        """
        self._LogSetId = None
        self._TopicId = None
        self._LogSetRegion = None

    @property
    def LogSetId(self):
        """The ID of the Tencent Cloud CLS log set.
        :rtype: str
        """
        return self._LogSetId

    @LogSetId.setter
    def LogSetId(self, LogSetId):
        self._LogSetId = LogSetId

    @property
    def TopicId(self):
        """The ID of the Tencent Cloud CLS log topic.
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def LogSetRegion(self):
        """The region of the Tencent Cloud CLS log set.
        :rtype: str
        """
        return self._LogSetRegion

    @LogSetRegion.setter
    def LogSetRegion(self, LogSetRegion):
        self._LogSetRegion = LogSetRegion


    def _deserialize(self, params):
        self._LogSetId = params.get("LogSetId")
        self._TopicId = params.get("TopicId")
        self._LogSetRegion = params.get("LogSetRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Cache(AbstractModel):
    """Cache time settings

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable cache configuration. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _CacheTime: Cache expiration time setting.
Unit: second. The maximum value is 365 days.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CacheTime: int
        :param _IgnoreCacheControl: Whether to enable force cache. Values:
<li>`on`: Enable</li>
<li>`off`: Disable </li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type IgnoreCacheControl: str
        """
        self._Switch = None
        self._CacheTime = None
        self._IgnoreCacheControl = None

    @property
    def Switch(self):
        """Whether to enable cache configuration. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def CacheTime(self):
        """Cache expiration time setting.
Unit: second. The maximum value is 365 days.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CacheTime

    @CacheTime.setter
    def CacheTime(self, CacheTime):
        self._CacheTime = CacheTime

    @property
    def IgnoreCacheControl(self):
        warnings.warn("parameter `IgnoreCacheControl` is deprecated", DeprecationWarning) 

        """Whether to enable force cache. Values:
<li>`on`: Enable</li>
<li>`off`: Disable </li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IgnoreCacheControl

    @IgnoreCacheControl.setter
    def IgnoreCacheControl(self, IgnoreCacheControl):
        warnings.warn("parameter `IgnoreCacheControl` is deprecated", DeprecationWarning) 

        self._IgnoreCacheControl = IgnoreCacheControl


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._CacheTime = params.get("CacheTime")
        self._IgnoreCacheControl = params.get("IgnoreCacheControl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheConfig(AbstractModel):
    """Cache rule configuration.

    """

    def __init__(self):
        r"""
        :param _Cache: Cache configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :type Cache: :class:`tencentcloud.teo.v20220901.models.Cache`
        :param _NoCache: No-cache configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :type NoCache: :class:`tencentcloud.teo.v20220901.models.NoCache`
        :param _FollowOrigin: Follows the origin server configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :type FollowOrigin: :class:`tencentcloud.teo.v20220901.models.FollowOrigin`
        """
        self._Cache = None
        self._NoCache = None
        self._FollowOrigin = None

    @property
    def Cache(self):
        """Cache configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.Cache`
        """
        return self._Cache

    @Cache.setter
    def Cache(self, Cache):
        self._Cache = Cache

    @property
    def NoCache(self):
        """No-cache configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.NoCache`
        """
        return self._NoCache

    @NoCache.setter
    def NoCache(self, NoCache):
        self._NoCache = NoCache

    @property
    def FollowOrigin(self):
        """Follows the origin server configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.FollowOrigin`
        """
        return self._FollowOrigin

    @FollowOrigin.setter
    def FollowOrigin(self, FollowOrigin):
        self._FollowOrigin = FollowOrigin


    def _deserialize(self, params):
        if params.get("Cache") is not None:
            self._Cache = Cache()
            self._Cache._deserialize(params.get("Cache"))
        if params.get("NoCache") is not None:
            self._NoCache = NoCache()
            self._NoCache._deserialize(params.get("NoCache"))
        if params.get("FollowOrigin") is not None:
            self._FollowOrigin = FollowOrigin()
            self._FollowOrigin._deserialize(params.get("FollowOrigin"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheConfigCustomTime(AbstractModel):
    """Node cache TTL custom cache time configuration parameters

    """

    def __init__(self):
        r"""
        :param _Switch: Custom cache time switch. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _CacheTime: Custom cache time value, unit: seconds. value range: 0-315360000.<br>note: this field is required when switch is on; when switch is off, this field is not required and will not take effect if filled.
        :type CacheTime: int
        """
        self._Switch = None
        self._CacheTime = None

    @property
    def Switch(self):
        """Custom cache time switch. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def CacheTime(self):
        """Custom cache time value, unit: seconds. value range: 0-315360000.<br>note: this field is required when switch is on; when switch is off, this field is not required and will not take effect if filled.
        :rtype: int
        """
        return self._CacheTime

    @CacheTime.setter
    def CacheTime(self, CacheTime):
        self._CacheTime = CacheTime


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._CacheTime = params.get("CacheTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheConfigParameters(AbstractModel):
    """Node Cache TTL configuration parameters

    """

    def __init__(self):
        r"""
        :param _FollowOrigin: Follow origin server cache configuration. only one of followorigin, nocache, customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type FollowOrigin: :class:`tencentcloud.teo.v20220901.models.FollowOrigin`
        :param _NoCache: No cache configuration. only one of followorigin, nocache, customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type NoCache: :class:`tencentcloud.teo.v20220901.models.NoCache`
        :param _CustomTime: Custom cache time configuration. only one of followorigin, nocache, customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type CustomTime: :class:`tencentcloud.teo.v20220901.models.CacheConfigCustomTime`
        """
        self._FollowOrigin = None
        self._NoCache = None
        self._CustomTime = None

    @property
    def FollowOrigin(self):
        """Follow origin server cache configuration. only one of followorigin, nocache, customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.FollowOrigin`
        """
        return self._FollowOrigin

    @FollowOrigin.setter
    def FollowOrigin(self, FollowOrigin):
        self._FollowOrigin = FollowOrigin

    @property
    def NoCache(self):
        """No cache configuration. only one of followorigin, nocache, customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.NoCache`
        """
        return self._NoCache

    @NoCache.setter
    def NoCache(self, NoCache):
        self._NoCache = NoCache

    @property
    def CustomTime(self):
        """Custom cache time configuration. only one of followorigin, nocache, customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CacheConfigCustomTime`
        """
        return self._CustomTime

    @CustomTime.setter
    def CustomTime(self, CustomTime):
        self._CustomTime = CustomTime


    def _deserialize(self, params):
        if params.get("FollowOrigin") is not None:
            self._FollowOrigin = FollowOrigin()
            self._FollowOrigin._deserialize(params.get("FollowOrigin"))
        if params.get("NoCache") is not None:
            self._NoCache = NoCache()
            self._NoCache._deserialize(params.get("NoCache"))
        if params.get("CustomTime") is not None:
            self._CustomTime = CacheConfigCustomTime()
            self._CustomTime._deserialize(params.get("CustomTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheKey(AbstractModel):
    """The cache key configuration.

    """

    def __init__(self):
        r"""
        :param _FullUrlCache: Whether to enable full-path cache. Values:
<li>`on`: Enable full-path cache (i.e., disable Ignore Query String).</li>
<li>`off`: Disable full-path cache (i.e., enable Ignore Query String).</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type FullUrlCache: str
        :param _IgnoreCase: Whether to ignore case in the cache key. Values:
<li>`on`: Ignore</li>
<li>`off`: Not ignore</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type IgnoreCase: str
        :param _QueryString: Request parameter contained in `CacheKey`. 
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type QueryString: :class:`tencentcloud.teo.v20220901.models.QueryString`
        """
        self._FullUrlCache = None
        self._IgnoreCase = None
        self._QueryString = None

    @property
    def FullUrlCache(self):
        """Whether to enable full-path cache. Values:
<li>`on`: Enable full-path cache (i.e., disable Ignore Query String).</li>
<li>`off`: Disable full-path cache (i.e., enable Ignore Query String).</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._FullUrlCache

    @FullUrlCache.setter
    def FullUrlCache(self, FullUrlCache):
        self._FullUrlCache = FullUrlCache

    @property
    def IgnoreCase(self):
        """Whether to ignore case in the cache key. Values:
<li>`on`: Ignore</li>
<li>`off`: Not ignore</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IgnoreCase

    @IgnoreCase.setter
    def IgnoreCase(self, IgnoreCase):
        self._IgnoreCase = IgnoreCase

    @property
    def QueryString(self):
        """Request parameter contained in `CacheKey`. 
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.QueryString`
        """
        return self._QueryString

    @QueryString.setter
    def QueryString(self, QueryString):
        self._QueryString = QueryString


    def _deserialize(self, params):
        self._FullUrlCache = params.get("FullUrlCache")
        self._IgnoreCase = params.get("IgnoreCase")
        if params.get("QueryString") is not None:
            self._QueryString = QueryString()
            self._QueryString._deserialize(params.get("QueryString"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheKeyConfigParameters(AbstractModel):
    """The cache key configuration.

    """

    def __init__(self):
        r"""
        :param _FullURLCache: Whether to enable full-path cache. values:.
<Li>`On`: enable full-path cache (i.e., disable ignore query string).</li>.
<Li>`Off`: disable full-path cache (i.e., enable ignore query string).</li>.
        :type FullURLCache: str
        :param _IgnoreCase: Whether to ignore case in the cache key. values:.
<Li>`On`: ignore;</li>.
<Li>`Off`: not ignore.</li>.
        :type IgnoreCase: str
        :param _QueryString: Query string retention configuration parameter. this field and fullurlcache must be set simultaneously, but cannot both be `on`.
        :type QueryString: :class:`tencentcloud.teo.v20220901.models.CacheKeyQueryString`
        """
        self._FullURLCache = None
        self._IgnoreCase = None
        self._QueryString = None

    @property
    def FullURLCache(self):
        """Whether to enable full-path cache. values:.
<Li>`On`: enable full-path cache (i.e., disable ignore query string).</li>.
<Li>`Off`: disable full-path cache (i.e., enable ignore query string).</li>.
        :rtype: str
        """
        return self._FullURLCache

    @FullURLCache.setter
    def FullURLCache(self, FullURLCache):
        self._FullURLCache = FullURLCache

    @property
    def IgnoreCase(self):
        """Whether to ignore case in the cache key. values:.
<Li>`On`: ignore;</li>.
<Li>`Off`: not ignore.</li>.
        :rtype: str
        """
        return self._IgnoreCase

    @IgnoreCase.setter
    def IgnoreCase(self, IgnoreCase):
        self._IgnoreCase = IgnoreCase

    @property
    def QueryString(self):
        """Query string retention configuration parameter. this field and fullurlcache must be set simultaneously, but cannot both be `on`.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CacheKeyQueryString`
        """
        return self._QueryString

    @QueryString.setter
    def QueryString(self, QueryString):
        self._QueryString = QueryString


    def _deserialize(self, params):
        self._FullURLCache = params.get("FullURLCache")
        self._IgnoreCase = params.get("IgnoreCase")
        if params.get("QueryString") is not None:
            self._QueryString = CacheKeyQueryString()
            self._QueryString._deserialize(params.get("QueryString"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheKeyCookie(AbstractModel):
    """Custom Cache Key Cookie configuration parameters

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable feature. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _Action: Cache action. values:.
<Li>`Full`: retain all</li>.
<Li> `ignore`: ignore all;</li>.
<Li> `includecustom`: retain specified parameters;</li>.
<Li> `excludecustom`: ignore specified parameters.</li> **note**: when `switch` is on, this field is required. when `switch` is off, this field is not required and will not take effect if filled.
        :type Action: str
        :param _Values: Custom cache key cookie name list.<br>note: this field is required when action is includecustom or excludecustom; when action is full or ignore, this field is not required and will not take effect if filled.
        :type Values: list of str
        """
        self._Switch = None
        self._Action = None
        self._Values = None

    @property
    def Switch(self):
        """Whether to enable feature. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Action(self):
        """Cache action. values:.
<Li>`Full`: retain all</li>.
<Li> `ignore`: ignore all;</li>.
<Li> `includecustom`: retain specified parameters;</li>.
<Li> `excludecustom`: ignore specified parameters.</li> **note**: when `switch` is on, this field is required. when `switch` is off, this field is not required and will not take effect if filled.
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Values(self):
        """Custom cache key cookie name list.<br>note: this field is required when action is includecustom or excludecustom; when action is full or ignore, this field is not required and will not take effect if filled.
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Action = params.get("Action")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheKeyHeader(AbstractModel):
    """Custom Cache Key HTTP request header configuration parameters.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable feature. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _Values: Custom cache key http request header list.<br>note: this field is required when switch is on; when switch is off, this field is not required and will not take effect if filled.
        :type Values: list of str
        """
        self._Switch = None
        self._Values = None

    @property
    def Switch(self):
        """Whether to enable feature. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Values(self):
        """Custom cache key http request header list.<br>note: this field is required when switch is on; when switch is off, this field is not required and will not take effect if filled.
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheKeyParameters(AbstractModel):
    """Custom Cache Key configuration parameters. The FullURLCache and QueryString parameters are combined. For specific examples, refer to:
    - Retain all query strings. Enable ignore case.
    ```
    {
      "CacheKey": {
        "FullURLCache": "on",
        "QueryString": {
          "Switch": "off"
        },
        "IgnoreCase": "on"
      }
    }
    ```
    - Ignore all query strings. Enable ignore case.
    ```
    {
      "CacheKey": {
        "FullURLCache": "off",
        "QueryString": {
          "Switch": "off"
        },
        "IgnoreCase": "on"
      }
    }
    ```
    - Retain specified query string parameters. Disable ignore case.
    ```
    {
      "CacheKey": {
        "FullURLCache": "off",
        "QueryString": {
            "Switch": "on",
            "Action": "includeCustom",
            "Values": ["name1","name2","name3"]
        },
        "IgnoreCase": "off"
      }
    }
    ```
    -Query string ignore specified parameters. Disable ignore case.
    ```
    {
      "CacheKey": {
        "FullURLCache": "off",
        "QueryString": {
            "Switch": "on",
            "Action": "excludeCustom",
            "Values": ["name1","name2","name3"]
        },
        "IgnoreCase": "off"
      }
    }
    ```

    """

    def __init__(self):
        r"""
        :param _FullURLCache: Switch for retaining the complete query string. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li> note: at least one of fullurlcache, ignorecase, header, scheme, or cookie must be configured. this field and querystring.switch must be set simultaneously, but cannot both be on.
        :type FullURLCache: str
        :param _QueryString: Configuration parameter for retaining the query string. this field and fullurlcache must be set simultaneously, but cannot both be on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type QueryString: :class:`tencentcloud.teo.v20220901.models.CacheKeyQueryString`
        :param _IgnoreCase: Switch for ignoring case. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li> note: at least one of fullurlcache, ignorecase, header, scheme, or cookie must be configured.
        :type IgnoreCase: str
        :param _Header: HTTP request header configuration parameters. at least one of the following configurations must be set: fullurlcache, ignorecase, header, scheme, cookie.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type Header: :class:`tencentcloud.teo.v20220901.models.CacheKeyHeader`
        :param _Scheme: Request protocol switch. valid values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li> note: at least one of fullurlcache, ignorecase, header, scheme, or cookie must be configured.
        :type Scheme: str
        :param _Cookie: Cookie configuration parameters. at least one of the following configurations must be set: fullurlcache, ignorecase, header, scheme, cookie.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type Cookie: :class:`tencentcloud.teo.v20220901.models.CacheKeyCookie`
        """
        self._FullURLCache = None
        self._QueryString = None
        self._IgnoreCase = None
        self._Header = None
        self._Scheme = None
        self._Cookie = None

    @property
    def FullURLCache(self):
        """Switch for retaining the complete query string. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li> note: at least one of fullurlcache, ignorecase, header, scheme, or cookie must be configured. this field and querystring.switch must be set simultaneously, but cannot both be on.
        :rtype: str
        """
        return self._FullURLCache

    @FullURLCache.setter
    def FullURLCache(self, FullURLCache):
        self._FullURLCache = FullURLCache

    @property
    def QueryString(self):
        """Configuration parameter for retaining the query string. this field and fullurlcache must be set simultaneously, but cannot both be on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CacheKeyQueryString`
        """
        return self._QueryString

    @QueryString.setter
    def QueryString(self, QueryString):
        self._QueryString = QueryString

    @property
    def IgnoreCase(self):
        """Switch for ignoring case. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li> note: at least one of fullurlcache, ignorecase, header, scheme, or cookie must be configured.
        :rtype: str
        """
        return self._IgnoreCase

    @IgnoreCase.setter
    def IgnoreCase(self, IgnoreCase):
        self._IgnoreCase = IgnoreCase

    @property
    def Header(self):
        """HTTP request header configuration parameters. at least one of the following configurations must be set: fullurlcache, ignorecase, header, scheme, cookie.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CacheKeyHeader`
        """
        return self._Header

    @Header.setter
    def Header(self, Header):
        self._Header = Header

    @property
    def Scheme(self):
        """Request protocol switch. valid values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li> note: at least one of fullurlcache, ignorecase, header, scheme, or cookie must be configured.
        :rtype: str
        """
        return self._Scheme

    @Scheme.setter
    def Scheme(self, Scheme):
        self._Scheme = Scheme

    @property
    def Cookie(self):
        """Cookie configuration parameters. at least one of the following configurations must be set: fullurlcache, ignorecase, header, scheme, cookie.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CacheKeyCookie`
        """
        return self._Cookie

    @Cookie.setter
    def Cookie(self, Cookie):
        self._Cookie = Cookie


    def _deserialize(self, params):
        self._FullURLCache = params.get("FullURLCache")
        if params.get("QueryString") is not None:
            self._QueryString = CacheKeyQueryString()
            self._QueryString._deserialize(params.get("QueryString"))
        self._IgnoreCase = params.get("IgnoreCase")
        if params.get("Header") is not None:
            self._Header = CacheKeyHeader()
            self._Header._deserialize(params.get("Header"))
        self._Scheme = params.get("Scheme")
        if params.get("Cookie") is not None:
            self._Cookie = CacheKeyCookie()
            self._Cookie._deserialize(params.get("Cookie"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheKeyQueryString(AbstractModel):
    """Custom Cache Key query string configuration parameters

    """

    def __init__(self):
        r"""
        :param _Switch: Query string retain/ignore specified parameter switch. valid values are:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _Action: Actions to retain/ignore specified parameters in the query string. values:.
<Li>`IncludeCustom`: retain partial parameters.</li>.
<Li>`ExcludeCustom`: ignore partial parameters.</li> note: this field is required when `switch` is on. when `switch` is off, this field is not required and will not take effect if filled.
        :type Action: str
        :param _Values: List of parameter names to be retained/ignored in the query string. <br>note: this field is required when `switch` is on. when `switch` is off, this field is not required and will not take effect if filled.
        :type Values: list of str
        """
        self._Switch = None
        self._Action = None
        self._Values = None

    @property
    def Switch(self):
        """Query string retain/ignore specified parameter switch. valid values are:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Action(self):
        """Actions to retain/ignore specified parameters in the query string. values:.
<Li>`IncludeCustom`: retain partial parameters.</li>.
<Li>`ExcludeCustom`: ignore partial parameters.</li> note: this field is required when `switch` is on. when `switch` is off, this field is not required and will not take effect if filled.
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Values(self):
        """List of parameter names to be retained/ignored in the query string. <br>note: this field is required when `switch` is on. when `switch` is off, this field is not required and will not take effect if filled.
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Action = params.get("Action")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheParameters(AbstractModel):
    """Node Cache TTL configuration parameters

    """

    def __init__(self):
        r"""
        :param _FollowOrigin: Cache follows origin server. if not specified, this configuration is not set. only one of followorigin, nocache, or customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type FollowOrigin: :class:`tencentcloud.teo.v20220901.models.FollowOrigin`
        :param _NoCache: No cache. if not specified, this configuration is not set. only one of followorigin, nocache, or customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type NoCache: :class:`tencentcloud.teo.v20220901.models.NoCache`
        :param _CustomTime: Custom cache time. if not specified, this configuration is not set. only one of followorigin, nocache, or customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type CustomTime: :class:`tencentcloud.teo.v20220901.models.CustomTime`
        """
        self._FollowOrigin = None
        self._NoCache = None
        self._CustomTime = None

    @property
    def FollowOrigin(self):
        """Cache follows origin server. if not specified, this configuration is not set. only one of followorigin, nocache, or customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.FollowOrigin`
        """
        return self._FollowOrigin

    @FollowOrigin.setter
    def FollowOrigin(self, FollowOrigin):
        self._FollowOrigin = FollowOrigin

    @property
    def NoCache(self):
        """No cache. if not specified, this configuration is not set. only one of followorigin, nocache, or customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.NoCache`
        """
        return self._NoCache

    @NoCache.setter
    def NoCache(self, NoCache):
        self._NoCache = NoCache

    @property
    def CustomTime(self):
        """Custom cache time. if not specified, this configuration is not set. only one of followorigin, nocache, or customtime can have switch set to on.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CustomTime`
        """
        return self._CustomTime

    @CustomTime.setter
    def CustomTime(self, CustomTime):
        self._CustomTime = CustomTime


    def _deserialize(self, params):
        if params.get("FollowOrigin") is not None:
            self._FollowOrigin = FollowOrigin()
            self._FollowOrigin._deserialize(params.get("FollowOrigin"))
        if params.get("NoCache") is not None:
            self._NoCache = NoCache()
            self._NoCache._deserialize(params.get("NoCache"))
        if params.get("CustomTime") is not None:
            self._CustomTime = CustomTime()
            self._CustomTime._deserialize(params.get("CustomTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CachePrefresh(AbstractModel):
    """Cache prefresh

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable cache prefresh. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _Percent: The cache prefresh percentage. Values: 1-99
Note: This field may return null, indicating that no valid values can be obtained.
        :type Percent: int
        """
        self._Switch = None
        self._Percent = None

    @property
    def Switch(self):
        """Whether to enable cache prefresh. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Percent(self):
        """The cache prefresh percentage. Values: 1-99
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Percent

    @Percent.setter
    def Percent(self, Percent):
        self._Percent = Percent


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Percent = params.get("Percent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CachePrefreshParameters(AbstractModel):
    """Cache prefresh configuration parameters

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable cache prefresh. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _CacheTimePercent: Prefresh interval set as a percentage of the node cache time. value range: 1-99.<br>note: this field is required when switch is on; when switch is off, this field is not required and will not take effect if filled.
        :type CacheTimePercent: int
        """
        self._Switch = None
        self._CacheTimePercent = None

    @property
    def Switch(self):
        """Whether to enable cache prefresh. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def CacheTimePercent(self):
        """Prefresh interval set as a percentage of the node cache time. value range: 1-99.<br>note: this field is required when switch is on; when switch is off, this field is not required and will not take effect if filled.
        :rtype: int
        """
        return self._CacheTimePercent

    @CacheTimePercent.setter
    def CacheTimePercent(self, CacheTimePercent):
        self._CacheTimePercent = CacheTimePercent


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._CacheTimePercent = params.get("CacheTimePercent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheTag(AbstractModel):
    """The information attached when the node cache purge type is set to purge_cache_tag.

    """

    def __init__(self):
        r"""
        :param _Domains: List of domain names to purge cache for.
        :type Domains: list of str
        """
        self._Domains = None

    @property
    def Domains(self):
        """List of domain names to purge cache for.
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains


    def _deserialize(self, params):
        self._Domains = params.get("Domains")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CertificateInfo(AbstractModel):
    """HTTPS server certificate configuration

    """

    def __init__(self):
        r"""
        :param _CertId: Certificate ID, which originates from the SSL side. You can check the CertId from the [SSL Certificate List](https://console.cloud.tencent.com/ssl).
        :type CertId: str
        :param _Alias: Alias of the certificate.
        :type Alias: str
        :param _Type: Type of the certificate. Values:
<li>`default`: Default certificate</li>
<li>`upload`: Specified certificate</li>
<li>`managed`: Tencent Cloud-managed certificate</li>
        :type Type: str
        :param _ExpireTime: The certificate expiration time.
        :type ExpireTime: str
        :param _DeployTime: Time when the certificate is deployed.
        :type DeployTime: str
        :param _SignAlgo: Signature algorithm.
        :type SignAlgo: str
        :param _Status: Status of the certificate. Values:
u200c<li>`deployed`: The deployment has completed</li>
u200c<li>`processing`: Deployment in progress</li>
u200c<li>`applying`: Application in progress</li>
u200c<li>`failed`: Application rejected</li>
<li>`issued`: Binding failed.</li>
        :type Status: str
        """
        self._CertId = None
        self._Alias = None
        self._Type = None
        self._ExpireTime = None
        self._DeployTime = None
        self._SignAlgo = None
        self._Status = None

    @property
    def CertId(self):
        """Certificate ID, which originates from the SSL side. You can check the CertId from the [SSL Certificate List](https://console.cloud.tencent.com/ssl).
        :rtype: str
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def Alias(self):
        """Alias of the certificate.
        :rtype: str
        """
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def Type(self):
        """Type of the certificate. Values:
<li>`default`: Default certificate</li>
<li>`upload`: Specified certificate</li>
<li>`managed`: Tencent Cloud-managed certificate</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ExpireTime(self):
        """The certificate expiration time.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def DeployTime(self):
        """Time when the certificate is deployed.
        :rtype: str
        """
        return self._DeployTime

    @DeployTime.setter
    def DeployTime(self, DeployTime):
        self._DeployTime = DeployTime

    @property
    def SignAlgo(self):
        """Signature algorithm.
        :rtype: str
        """
        return self._SignAlgo

    @SignAlgo.setter
    def SignAlgo(self, SignAlgo):
        self._SignAlgo = SignAlgo

    @property
    def Status(self):
        """Status of the certificate. Values:
u200c<li>`deployed`: The deployment has completed</li>
u200c<li>`processing`: Deployment in progress</li>
u200c<li>`applying`: Application in progress</li>
u200c<li>`failed`: Application rejected</li>
<li>`issued`: Binding failed.</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._CertId = params.get("CertId")
        self._Alias = params.get("Alias")
        self._Type = params.get("Type")
        self._ExpireTime = params.get("ExpireTime")
        self._DeployTime = params.get("DeployTime")
        self._SignAlgo = params.get("SignAlgo")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChallengeActionParameters(AbstractModel):
    """Web security Challenge additional parameter.

    """

    def __init__(self):
        r"""
        :param _ChallengeOption: Safe execution challenge actions. valid values: <li> InterstitialChallenge: interstitial challenge;</li> <li> InlineChallenge: embedded challenge;</li> <li> JSChallenge: JavaScript challenge;</li> <li> ManagedChallenge: managed challenge.</li>.
        :type ChallengeOption: str
        :param _Interval: Specifies the time interval for challenge repetition. this field is required when Name is InterstitialChallenge/InlineChallenge. default value is 300s. supported units: <li>s: second, value ranges from 1 to 60;</li><li>m: minute, value ranges from 1 to 60;</li><li>h: hour, value ranges from 1 to 24.</li>.

        :type Interval: str
        :param _AttesterId: Client authentication method ID. this field is required when Name is InterstitialChallenge/InlineChallenge.
        :type AttesterId: str
        """
        self._ChallengeOption = None
        self._Interval = None
        self._AttesterId = None

    @property
    def ChallengeOption(self):
        """Safe execution challenge actions. valid values: <li> InterstitialChallenge: interstitial challenge;</li> <li> InlineChallenge: embedded challenge;</li> <li> JSChallenge: JavaScript challenge;</li> <li> ManagedChallenge: managed challenge.</li>.
        :rtype: str
        """
        return self._ChallengeOption

    @ChallengeOption.setter
    def ChallengeOption(self, ChallengeOption):
        self._ChallengeOption = ChallengeOption

    @property
    def Interval(self):
        """Specifies the time interval for challenge repetition. this field is required when Name is InterstitialChallenge/InlineChallenge. default value is 300s. supported units: <li>s: second, value ranges from 1 to 60;</li><li>m: minute, value ranges from 1 to 60;</li><li>h: hour, value ranges from 1 to 24.</li>.

        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def AttesterId(self):
        """Client authentication method ID. this field is required when Name is InterstitialChallenge/InlineChallenge.
        :rtype: str
        """
        return self._AttesterId

    @AttesterId.setter
    def AttesterId(self, AttesterId):
        self._AttesterId = AttesterId


    def _deserialize(self, params):
        self._ChallengeOption = params.get("ChallengeOption")
        self._Interval = params.get("Interval")
        self._AttesterId = params.get("AttesterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckCnameStatusRequest(AbstractModel):
    """CheckCnameStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID.
        :type ZoneId: str
        :param _RecordNames: List of accelerated domain names.
        :type RecordNames: list of str
        """
        self._ZoneId = None
        self._RecordNames = None

    @property
    def ZoneId(self):
        """Site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RecordNames(self):
        """List of accelerated domain names.
        :rtype: list of str
        """
        return self._RecordNames

    @RecordNames.setter
    def RecordNames(self, RecordNames):
        self._RecordNames = RecordNames


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RecordNames = params.get("RecordNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckCnameStatusResponse(AbstractModel):
    """CheckCnameStatus response structure.

    """

    def __init__(self):
        r"""
        :param _CnameStatus: CNAME status of accelerated domain names.
        :type CnameStatus: list of CnameStatus
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CnameStatus = None
        self._RequestId = None

    @property
    def CnameStatus(self):
        """CNAME status of accelerated domain names.
        :rtype: list of CnameStatus
        """
        return self._CnameStatus

    @CnameStatus.setter
    def CnameStatus(self, CnameStatus):
        self._CnameStatus = CnameStatus

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CnameStatus") is not None:
            self._CnameStatus = []
            for item in params.get("CnameStatus"):
                obj = CnameStatus()
                obj._deserialize(item)
                self._CnameStatus.append(obj)
        self._RequestId = params.get("RequestId")


class CheckRegionHealthStatus(AbstractModel):
    """Health status of origin servers in each health check region.

    """

    def __init__(self):
        r"""
        :param _Region: Health check region, which is a two-letter code according to ISO-3166-1.
        :type Region: str
        :param _Healthy: Health status of origin servers in a single health check region. Valid values:
<li>Healthy: healthy.</li>
<li>Unhealthy: unhealthy.</li>
<li>Undetected: no data detected.</li>Note: If all origin servers in a single health check region are healthy, the status is healthy; otherwise, it is unhealthy.
        :type Healthy: str
        :param _OriginHealthStatus: Origin server health status.
        :type OriginHealthStatus: list of OriginHealthStatus
        """
        self._Region = None
        self._Healthy = None
        self._OriginHealthStatus = None

    @property
    def Region(self):
        """Health check region, which is a two-letter code according to ISO-3166-1.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Healthy(self):
        """Health status of origin servers in a single health check region. Valid values:
<li>Healthy: healthy.</li>
<li>Unhealthy: unhealthy.</li>
<li>Undetected: no data detected.</li>Note: If all origin servers in a single health check region are healthy, the status is healthy; otherwise, it is unhealthy.
        :rtype: str
        """
        return self._Healthy

    @Healthy.setter
    def Healthy(self, Healthy):
        self._Healthy = Healthy

    @property
    def OriginHealthStatus(self):
        """Origin server health status.
        :rtype: list of OriginHealthStatus
        """
        return self._OriginHealthStatus

    @OriginHealthStatus.setter
    def OriginHealthStatus(self, OriginHealthStatus):
        self._OriginHealthStatus = OriginHealthStatus


    def _deserialize(self, params):
        self._Region = params.get("Region")
        self._Healthy = params.get("Healthy")
        if params.get("OriginHealthStatus") is not None:
            self._OriginHealthStatus = []
            for item in params.get("OriginHealthStatus"):
                obj = OriginHealthStatus()
                obj._deserialize(item)
                self._OriginHealthStatus.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClientAttestationRule(AbstractModel):
    """Client authentication rule.

    """

    def __init__(self):
        r"""
        :param _Id: Client authentication rule ID. supported rule configuration operations by rule ID: <li> <b>add</b> a new rule: leave the ID empty or do not specify the ID parameter.</li> <li> <b>modify</b> an existing rule: specify the rule ID that needs to be updated/modified.</li> <li> <b>delete</b> an existing rule: existing rules not included in the ClientAttestationRule list under BotManagement parameters will be deleted.</li>.
        :type Id: str
        :param _Name: Specifies the name of the client authentication rule.
        :type Name: str
        :param _Enabled: Whether the rule is enabled. valid values: <li>`on`: enable</li> <li>`off`: disable</li>.
        :type Enabled: str
        :param _Priority: Priority of rules. a smaller value indicates higher priority execution. value range: 0-100. default value: 0.
        :type Priority: int
        :param _Condition: The rule content must comply with expression grammar. for details, see the product document.
        :type Condition: str
        :param _AttesterId: Specifies the client authentication option ID.
        :type AttesterId: str
        :param _DeviceProfiles: Client device configuration. if the DeviceProfiles parameter value is not specified in the ClientAttestationRules parameter, keep the existing client device configuration and do not modify it.
        :type DeviceProfiles: list of DeviceProfile
        :param _InvalidAttestationAction: Handling method for failed client authentication. valid values for SecurityAction Name: <li>Deny: block;</li> <li>Monitor: observation;</li> <li>Redirect: redirection;</li> <li>Challenge: Challenge.</li> default value: Monitor.
        :type InvalidAttestationAction: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        self._Id = None
        self._Name = None
        self._Enabled = None
        self._Priority = None
        self._Condition = None
        self._AttesterId = None
        self._DeviceProfiles = None
        self._InvalidAttestationAction = None

    @property
    def Id(self):
        """Client authentication rule ID. supported rule configuration operations by rule ID: <li> <b>add</b> a new rule: leave the ID empty or do not specify the ID parameter.</li> <li> <b>modify</b> an existing rule: specify the rule ID that needs to be updated/modified.</li> <li> <b>delete</b> an existing rule: existing rules not included in the ClientAttestationRule list under BotManagement parameters will be deleted.</li>.
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        """Specifies the name of the client authentication rule.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Enabled(self):
        """Whether the rule is enabled. valid values: <li>`on`: enable</li> <li>`off`: disable</li>.
        :rtype: str
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def Priority(self):
        """Priority of rules. a smaller value indicates higher priority execution. value range: 0-100. default value: 0.
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def Condition(self):
        """The rule content must comply with expression grammar. for details, see the product document.
        :rtype: str
        """
        return self._Condition

    @Condition.setter
    def Condition(self, Condition):
        self._Condition = Condition

    @property
    def AttesterId(self):
        """Specifies the client authentication option ID.
        :rtype: str
        """
        return self._AttesterId

    @AttesterId.setter
    def AttesterId(self, AttesterId):
        self._AttesterId = AttesterId

    @property
    def DeviceProfiles(self):
        """Client device configuration. if the DeviceProfiles parameter value is not specified in the ClientAttestationRules parameter, keep the existing client device configuration and do not modify it.
        :rtype: list of DeviceProfile
        """
        return self._DeviceProfiles

    @DeviceProfiles.setter
    def DeviceProfiles(self, DeviceProfiles):
        self._DeviceProfiles = DeviceProfiles

    @property
    def InvalidAttestationAction(self):
        """Handling method for failed client authentication. valid values for SecurityAction Name: <li>Deny: block;</li> <li>Monitor: observation;</li> <li>Redirect: redirection;</li> <li>Challenge: Challenge.</li> default value: Monitor.
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        return self._InvalidAttestationAction

    @InvalidAttestationAction.setter
    def InvalidAttestationAction(self, InvalidAttestationAction):
        self._InvalidAttestationAction = InvalidAttestationAction


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Enabled = params.get("Enabled")
        self._Priority = params.get("Priority")
        self._Condition = params.get("Condition")
        self._AttesterId = params.get("AttesterId")
        if params.get("DeviceProfiles") is not None:
            self._DeviceProfiles = []
            for item in params.get("DeviceProfiles"):
                obj = DeviceProfile()
                obj._deserialize(item)
                self._DeviceProfiles.append(obj)
        if params.get("InvalidAttestationAction") is not None:
            self._InvalidAttestationAction = SecurityAction()
            self._InvalidAttestationAction._deserialize(params.get("InvalidAttestationAction"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClientAttestationRules(AbstractModel):
    """Describes the client authentication configuration.

    """

    def __init__(self):
        r"""
        :param _Rules: List of client authentication. when using ModifySecurityPolicy to modify Web protection configuration: <li> if Rules in SecurityPolicy.BotManagement.ClientAttestationRules is not specified or the parameter length of Rules is zero: clear all client authentication rule configuration. </li> <li> if ClientAttestationRules in SecurityPolicy.BotManagement parameters is unspecified: keep existing client authentication rule configuration and do not modify. </li>.
        :type Rules: list of ClientAttestationRule
        """
        self._Rules = None

    @property
    def Rules(self):
        """List of client authentication. when using ModifySecurityPolicy to modify Web protection configuration: <li> if Rules in SecurityPolicy.BotManagement.ClientAttestationRules is not specified or the parameter length of Rules is zero: clear all client authentication rule configuration. </li> <li> if ClientAttestationRules in SecurityPolicy.BotManagement parameters is unspecified: keep existing client authentication rule configuration and do not modify. </li>.
        :rtype: list of ClientAttestationRule
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = ClientAttestationRule()
                obj._deserialize(item)
                self._Rules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClientFiltering(AbstractModel):
    """Intelligent client filtering.

    """

    def __init__(self):
        r"""
        :param _Enabled: Whether intelligent client filtering is enabled. valid values: <li>on: enable;</li> <li>off: disable.</li>.
        :type Enabled: str
        :param _Action: The handling method of intelligent client filtering. when Enabled is on, this field is required. the Name parameter of SecurityAction supports: <li>Monitor: observation;</li> <li>Deny: block;</li> <li>Challenge: Challenge, where ChallengeActionParameters.Name only supports JSChallenge.</li>.
        :type Action: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        self._Enabled = None
        self._Action = None

    @property
    def Enabled(self):
        """Whether intelligent client filtering is enabled. valid values: <li>on: enable;</li> <li>off: disable.</li>.
        :rtype: str
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def Action(self):
        """The handling method of intelligent client filtering. when Enabled is on, this field is required. the Name parameter of SecurityAction supports: <li>Monitor: observation;</li> <li>Deny: block;</li> <li>Challenge: Challenge, where ChallengeActionParameters.Name only supports JSChallenge.</li>.
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action


    def _deserialize(self, params):
        self._Enabled = params.get("Enabled")
        if params.get("Action") is not None:
            self._Action = SecurityAction()
            self._Action._deserialize(params.get("Action"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClientIPCountryParameters(AbstractModel):
    """Location information of the Client IP carried in origin-pull. It is formatted as a two-letter ISO-3166-1 country/region code.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable configuration. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _HeaderName: Name of the request header that contains the client ip region. it is valid when `switch=on`. the default value `eo-client-ipcountry` is used when it is not specified.
        :type HeaderName: str
        """
        self._Switch = None
        self._HeaderName = None

    @property
    def Switch(self):
        """Whether to enable configuration. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def HeaderName(self):
        """Name of the request header that contains the client ip region. it is valid when `switch=on`. the default value `eo-client-ipcountry` is used when it is not specified.
        :rtype: str
        """
        return self._HeaderName

    @HeaderName.setter
    def HeaderName(self, HeaderName):
        self._HeaderName = HeaderName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._HeaderName = params.get("HeaderName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClientIPHeaderParameters(AbstractModel):
    """The header configuration for storing client request IP.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable configuration. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _HeaderName: Name of the request header containing the client ip address for origin-pull. when switch is on, this parameter is required. x-forwarded-for is not allowed for this parameter.
        :type HeaderName: str
        """
        self._Switch = None
        self._HeaderName = None

    @property
    def Switch(self):
        """Whether to enable configuration. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def HeaderName(self):
        """Name of the request header containing the client ip address for origin-pull. when switch is on, this parameter is required. x-forwarded-for is not allowed for this parameter.
        :rtype: str
        """
        return self._HeaderName

    @HeaderName.setter
    def HeaderName(self, HeaderName):
        self._HeaderName = HeaderName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._HeaderName = params.get("HeaderName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClientIpCountry(AbstractModel):
    """Location information of the client IP carried in origin-pull. It is formatted as a two-letter ISO-3166-1 country/region code.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable configuration. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _HeaderName: Name of the request header that contains the client IP region. It is valid when `Switch=on`. 
The default value `EO-Client-IPCountry` is used when it is not specified.
        :type HeaderName: str
        """
        self._Switch = None
        self._HeaderName = None

    @property
    def Switch(self):
        """Whether to enable configuration. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def HeaderName(self):
        """Name of the request header that contains the client IP region. It is valid when `Switch=on`. 
The default value `EO-Client-IPCountry` is used when it is not specified.
        :rtype: str
        """
        return self._HeaderName

    @HeaderName.setter
    def HeaderName(self, HeaderName):
        self._HeaderName = HeaderName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._HeaderName = params.get("HeaderName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClientIpHeader(AbstractModel):
    """The client IP header configuration

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the configuration. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _HeaderName: Name of the request header containing the client IP address for origin-pull. When Switch is on, this parameter is required. X-Forwarded-For is not allowed for this parameter.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type HeaderName: str
        """
        self._Switch = None
        self._HeaderName = None

    @property
    def Switch(self):
        """Whether to enable the configuration. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def HeaderName(self):
        """Name of the request header containing the client IP address for origin-pull. When Switch is on, this parameter is required. X-Forwarded-For is not allowed for this parameter.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: str
        """
        return self._HeaderName

    @HeaderName.setter
    def HeaderName(self, HeaderName):
        self._HeaderName = HeaderName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._HeaderName = params.get("HeaderName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CnameStatus(AbstractModel):
    """CNAME status

    """

    def __init__(self):
        r"""
        :param _RecordName: The domain name.
        :type RecordName: str
        :param _Cname: The CNAME address.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Cname: str
        :param _Status: The CNAME status. Values:
<li>`active`: Activated</li>
<li>`moved`: Not activated </li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: str
        """
        self._RecordName = None
        self._Cname = None
        self._Status = None

    @property
    def RecordName(self):
        """The domain name.
        :rtype: str
        """
        return self._RecordName

    @RecordName.setter
    def RecordName(self, RecordName):
        self._RecordName = RecordName

    @property
    def Cname(self):
        """The CNAME address.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Cname

    @Cname.setter
    def Cname(self, Cname):
        self._Cname = Cname

    @property
    def Status(self):
        """The CNAME status. Values:
<li>`active`: Activated</li>
<li>`moved`: Not activated </li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._RecordName = params.get("RecordName")
        self._Cname = params.get("Cname")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CodeAction(AbstractModel):
    """Rule engine action with a status code

    """

    def __init__(self):
        r"""
        :param _Action: Feature name. For details, see [DescribeRulesSetting](https://intl.cloud.tencent.com/document/product/1552/80618?from_cn_redirect=1) API
        :type Action: str
        :param _Parameters: Operation parameter.
        :type Parameters: list of RuleCodeActionParams
        """
        self._Action = None
        self._Parameters = None

    @property
    def Action(self):
        """Feature name. For details, see [DescribeRulesSetting](https://intl.cloud.tencent.com/document/product/1552/80618?from_cn_redirect=1) API
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Parameters(self):
        """Operation parameter.
        :rtype: list of RuleCodeActionParams
        """
        return self._Parameters

    @Parameters.setter
    def Parameters(self, Parameters):
        self._Parameters = Parameters


    def _deserialize(self, params):
        self._Action = params.get("Action")
        if params.get("Parameters") is not None:
            self._Parameters = []
            for item in params.get("Parameters"):
                obj = RuleCodeActionParams()
                obj._deserialize(item)
                self._Parameters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Compression(AbstractModel):
    """Smart compression configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable smart compression. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _Algorithms: Compression algorithm. Values:
<li>`brotli`: Brotli algorithm</li>
<li>`gzip`: Gzip algorithm</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type Algorithms: list of str
        """
        self._Switch = None
        self._Algorithms = None

    @property
    def Switch(self):
        """Whether to enable smart compression. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Algorithms(self):
        """Compression algorithm. Values:
<li>`brotli`: Brotli algorithm</li>
<li>`gzip`: Gzip algorithm</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._Algorithms

    @Algorithms.setter
    def Algorithms(self, Algorithms):
        self._Algorithms = Algorithms


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Algorithms = params.get("Algorithms")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompressionParameters(AbstractModel):
    """Smart compression configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable smart compression. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _Algorithms: Supported compression algorithm list. this field is required when switch is on; otherwise, it is not effective. valid values:.
<Li>`Brotli`: brotli algorithm;</li>.
<Li>`Gzip`: gzip algorithm.</li>.
        :type Algorithms: list of str
        """
        self._Switch = None
        self._Algorithms = None

    @property
    def Switch(self):
        """Whether to enable smart compression. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Algorithms(self):
        """Supported compression algorithm list. this field is required when switch is on; otherwise, it is not effective. valid values:.
<Li>`Brotli`: brotli algorithm;</li>.
<Li>`Gzip`: gzip algorithm.</li>.
        :rtype: list of str
        """
        return self._Algorithms

    @Algorithms.setter
    def Algorithms(self, Algorithms):
        self._Algorithms = Algorithms


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Algorithms = params.get("Algorithms")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigGroupVersionInfo(AbstractModel):
    """Version information about the configuration group.

    """

    def __init__(self):
        r"""
        :param _VersionId: Version ID.
        :type VersionId: str
        :param _VersionNumber: Version No.
        :type VersionNumber: str
        :param _GroupId: Configuraration group ID.
        :type GroupId: str
        :param _GroupType: Configuration group type. Valid values: 
<li>l7_acceleration: L7 acceleration configuration group. </li>
<li>edge_functions: Edge function configuration group. </li>
        :type GroupType: str
        :param _Description: Version description.
        :type Description: str
        :param _Status: Version status. Valid values: 
<li>creating: Being created.</li>
<li>inactive: Not effective.</li>
<li>active: Effective. </li>
        :type Status: str
        :param _CreateTime: Version creation time. The time format follows the ISO 8601 standard and is represented in Coordinated Universal Time (UTC).
        :type CreateTime: str
        """
        self._VersionId = None
        self._VersionNumber = None
        self._GroupId = None
        self._GroupType = None
        self._Description = None
        self._Status = None
        self._CreateTime = None

    @property
    def VersionId(self):
        """Version ID.
        :rtype: str
        """
        return self._VersionId

    @VersionId.setter
    def VersionId(self, VersionId):
        self._VersionId = VersionId

    @property
    def VersionNumber(self):
        """Version No.
        :rtype: str
        """
        return self._VersionNumber

    @VersionNumber.setter
    def VersionNumber(self, VersionNumber):
        self._VersionNumber = VersionNumber

    @property
    def GroupId(self):
        """Configuraration group ID.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupType(self):
        """Configuration group type. Valid values: 
<li>l7_acceleration: L7 acceleration configuration group. </li>
<li>edge_functions: Edge function configuration group. </li>
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def Description(self):
        """Version description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Status(self):
        """Version status. Valid values: 
<li>creating: Being created.</li>
<li>inactive: Not effective.</li>
<li>active: Effective. </li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        """Version creation time. The time format follows the ISO 8601 standard and is represented in Coordinated Universal Time (UTC).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._VersionId = params.get("VersionId")
        self._VersionNumber = params.get("VersionNumber")
        self._GroupId = params.get("GroupId")
        self._GroupType = params.get("GroupType")
        self._Description = params.get("Description")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmOriginACLUpdateRequest(AbstractModel):
    """ConfirmOriginACLUpdate request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Specifies the site ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        """Specifies the site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmOriginACLUpdateResponse(AbstractModel):
    """ConfirmOriginACLUpdate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ContentIdentifier(AbstractModel):
    """Content identifier. This feature is only available to the allowlist.

    """

    def __init__(self):
        r"""
        :param _ContentId: Content identifier id.
        :type ContentId: str
        :param _Description: Content identifier description.
        :type Description: str
        :param _ReferenceCount: Count of citations by the rule engine.
        :type ReferenceCount: int
        :param _PlanId: Bound package id.
        :type PlanId: str
        :param _Tags: Bound tags.
        :type Tags: list of Tag
        :param _Status: Content identifier status. valid values:.
<Li>`Active`: activated</li>.
<Li>`Deleted`: deleted</li>.
        :type Status: str
        :param _CreatedOn: Creation time, which adopts coordinated universal time (utc) and follows the date and time format of the iso 8601 standard.
        :type CreatedOn: str
        :param _ModifiedOn: Latest update time, which adopts coordinated universal time (utc) and follows the date and time format of the iso 8601 standard.
        :type ModifiedOn: str
        :param _DeletedOn: Deletion time, which is empty when the status is not `deleted`. the time format follows the iso 8601 standard and is represented in coordinated universal time (utc).
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type DeletedOn: str
        """
        self._ContentId = None
        self._Description = None
        self._ReferenceCount = None
        self._PlanId = None
        self._Tags = None
        self._Status = None
        self._CreatedOn = None
        self._ModifiedOn = None
        self._DeletedOn = None

    @property
    def ContentId(self):
        """Content identifier id.
        :rtype: str
        """
        return self._ContentId

    @ContentId.setter
    def ContentId(self, ContentId):
        self._ContentId = ContentId

    @property
    def Description(self):
        """Content identifier description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ReferenceCount(self):
        """Count of citations by the rule engine.
        :rtype: int
        """
        return self._ReferenceCount

    @ReferenceCount.setter
    def ReferenceCount(self, ReferenceCount):
        self._ReferenceCount = ReferenceCount

    @property
    def PlanId(self):
        """Bound package id.
        :rtype: str
        """
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def Tags(self):
        """Bound tags.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Status(self):
        """Content identifier status. valid values:.
<Li>`Active`: activated</li>.
<Li>`Deleted`: deleted</li>.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreatedOn(self):
        """Creation time, which adopts coordinated universal time (utc) and follows the date and time format of the iso 8601 standard.
        :rtype: str
        """
        return self._CreatedOn

    @CreatedOn.setter
    def CreatedOn(self, CreatedOn):
        self._CreatedOn = CreatedOn

    @property
    def ModifiedOn(self):
        """Latest update time, which adopts coordinated universal time (utc) and follows the date and time format of the iso 8601 standard.
        :rtype: str
        """
        return self._ModifiedOn

    @ModifiedOn.setter
    def ModifiedOn(self, ModifiedOn):
        self._ModifiedOn = ModifiedOn

    @property
    def DeletedOn(self):
        """Deletion time, which is empty when the status is not `deleted`. the time format follows the iso 8601 standard and is represented in coordinated universal time (utc).
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: str
        """
        return self._DeletedOn

    @DeletedOn.setter
    def DeletedOn(self, DeletedOn):
        self._DeletedOn = DeletedOn


    def _deserialize(self, params):
        self._ContentId = params.get("ContentId")
        self._Description = params.get("Description")
        self._ReferenceCount = params.get("ReferenceCount")
        self._PlanId = params.get("PlanId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Status = params.get("Status")
        self._CreatedOn = params.get("CreatedOn")
        self._ModifiedOn = params.get("ModifiedOn")
        self._DeletedOn = params.get("DeletedOn")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAccelerationDomainRequest(AbstractModel):
    """CreateAccelerationDomain request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site related with the acceleration domain name.
        :type ZoneId: str
        :param _DomainName: Acceleration domain name
        :type DomainName: str
        :param _OriginInfo: Details of the origin.
        :type OriginInfo: :class:`tencentcloud.teo.v20220901.models.OriginInfo`
        :param _OriginProtocol: Origin-pull protocol configuration. Values:
<li>`FOLLOW`: Follow the protocol of origin</li>
<li>`HTTP`: Send requests to the origin over HTTP</li>
<li>`HTTPS`: Send requests to the origin over HTTPS</li>
<li>Default: `FOLLOW`</li>
        :type OriginProtocol: str
        :param _HttpOriginPort: Ports for HTTP origin-pull requests. Range: 1-65535. It takes effect when `OriginProtocol=FOLLOW/HTTP`. Port 80 is used if it's not specified. 
        :type HttpOriginPort: int
        :param _HttpsOriginPort: Ports for HTTPS origin-pull requests. Range: 1-65535. It takes effect when `OriginProtocol=FOLLOW/HTTPS`. Port 443 is used if it's not specified. 
        :type HttpsOriginPort: int
        :param _IPv6Status: IPv6 status. Values:
<li>`follow`: Follow the IPv6 configuration of the site</li>
<li>`on`: Enable</li>
<li>`off`: Disable</li>
<li>Default: `follow`</li>
        :type IPv6Status: str
        """
        self._ZoneId = None
        self._DomainName = None
        self._OriginInfo = None
        self._OriginProtocol = None
        self._HttpOriginPort = None
        self._HttpsOriginPort = None
        self._IPv6Status = None

    @property
    def ZoneId(self):
        """ID of the site related with the acceleration domain name.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def DomainName(self):
        """Acceleration domain name
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def OriginInfo(self):
        """Details of the origin.
        :rtype: :class:`tencentcloud.teo.v20220901.models.OriginInfo`
        """
        return self._OriginInfo

    @OriginInfo.setter
    def OriginInfo(self, OriginInfo):
        self._OriginInfo = OriginInfo

    @property
    def OriginProtocol(self):
        """Origin-pull protocol configuration. Values:
<li>`FOLLOW`: Follow the protocol of origin</li>
<li>`HTTP`: Send requests to the origin over HTTP</li>
<li>`HTTPS`: Send requests to the origin over HTTPS</li>
<li>Default: `FOLLOW`</li>
        :rtype: str
        """
        return self._OriginProtocol

    @OriginProtocol.setter
    def OriginProtocol(self, OriginProtocol):
        self._OriginProtocol = OriginProtocol

    @property
    def HttpOriginPort(self):
        """Ports for HTTP origin-pull requests. Range: 1-65535. It takes effect when `OriginProtocol=FOLLOW/HTTP`. Port 80 is used if it's not specified. 
        :rtype: int
        """
        return self._HttpOriginPort

    @HttpOriginPort.setter
    def HttpOriginPort(self, HttpOriginPort):
        self._HttpOriginPort = HttpOriginPort

    @property
    def HttpsOriginPort(self):
        """Ports for HTTPS origin-pull requests. Range: 1-65535. It takes effect when `OriginProtocol=FOLLOW/HTTPS`. Port 443 is used if it's not specified. 
        :rtype: int
        """
        return self._HttpsOriginPort

    @HttpsOriginPort.setter
    def HttpsOriginPort(self, HttpsOriginPort):
        self._HttpsOriginPort = HttpsOriginPort

    @property
    def IPv6Status(self):
        """IPv6 status. Values:
<li>`follow`: Follow the IPv6 configuration of the site</li>
<li>`on`: Enable</li>
<li>`off`: Disable</li>
<li>Default: `follow`</li>
        :rtype: str
        """
        return self._IPv6Status

    @IPv6Status.setter
    def IPv6Status(self, IPv6Status):
        self._IPv6Status = IPv6Status


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._DomainName = params.get("DomainName")
        if params.get("OriginInfo") is not None:
            self._OriginInfo = OriginInfo()
            self._OriginInfo._deserialize(params.get("OriginInfo"))
        self._OriginProtocol = params.get("OriginProtocol")
        self._HttpOriginPort = params.get("HttpOriginPort")
        self._HttpsOriginPort = params.get("HttpsOriginPort")
        self._IPv6Status = params.get("IPv6Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAccelerationDomainResponse(AbstractModel):
    """CreateAccelerationDomain response structure.

    """

    def __init__(self):
        r"""
        :param _OwnershipVerification: Use the information returned by this parameter to verify the ownership of a domain name. For details, see [Ownership Verification](https://intl.cloud.tencent.com/document/product/1552/70789?from_cn_redirect=1).
Note: This field may return·null, indicating that no valid values can be obtained.
        :type OwnershipVerification: :class:`tencentcloud.teo.v20220901.models.OwnershipVerification`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OwnershipVerification = None
        self._RequestId = None

    @property
    def OwnershipVerification(self):
        """Use the information returned by this parameter to verify the ownership of a domain name. For details, see [Ownership Verification](https://intl.cloud.tencent.com/document/product/1552/70789?from_cn_redirect=1).
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.OwnershipVerification`
        """
        return self._OwnershipVerification

    @OwnershipVerification.setter
    def OwnershipVerification(self, OwnershipVerification):
        self._OwnershipVerification = OwnershipVerification

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OwnershipVerification") is not None:
            self._OwnershipVerification = OwnershipVerification()
            self._OwnershipVerification._deserialize(params.get("OwnershipVerification"))
        self._RequestId = params.get("RequestId")


class CreateAliasDomainRequest(AbstractModel):
    """CreateAliasDomain request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        :param _AliasName: The alias domain name.
        :type AliasName: str
        :param _TargetName: The target domain name.
        :type TargetName: str
        :param _CertType: Certificate configuration. Values:
<li>`none`: (Default) Do not configure</li>
<li>`hosting`: Managed SSL certificate</li>
        :type CertType: str
        :param _CertId: The certificate ID. This field is required when `CertType=hosting`.
        :type CertId: list of str
        """
        self._ZoneId = None
        self._AliasName = None
        self._TargetName = None
        self._CertType = None
        self._CertId = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def AliasName(self):
        """The alias domain name.
        :rtype: str
        """
        return self._AliasName

    @AliasName.setter
    def AliasName(self, AliasName):
        self._AliasName = AliasName

    @property
    def TargetName(self):
        """The target domain name.
        :rtype: str
        """
        return self._TargetName

    @TargetName.setter
    def TargetName(self, TargetName):
        self._TargetName = TargetName

    @property
    def CertType(self):
        """Certificate configuration. Values:
<li>`none`: (Default) Do not configure</li>
<li>`hosting`: Managed SSL certificate</li>
        :rtype: str
        """
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def CertId(self):
        """The certificate ID. This field is required when `CertType=hosting`.
        :rtype: list of str
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._AliasName = params.get("AliasName")
        self._TargetName = params.get("TargetName")
        self._CertType = params.get("CertType")
        self._CertId = params.get("CertId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAliasDomainResponse(AbstractModel):
    """CreateAliasDomain response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateApplicationProxyRequest(AbstractModel):
    """CreateApplicationProxy request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID.
        :type ZoneId: str
        :param _ProxyName: Domain name or subdomain name when `ProxyType=hostname`; 
Instance name when `ProxyType=instance`.
        :type ProxyName: str
        :param _PlatType: The scheduling mode. Values:
<li>`ip`: Schedule via Anycast IP.</li>
<li>`domain`: Schedule via CNAME.</li>
        :type PlatType: str
        :param _SecurityType: Whether to enable security protection. Values:
<li>`0`: Disable security protection.</li>
<li>`1`: Enable security protection.</li>
        :type SecurityType: int
        :param _AccelerateType: Whether to enable acceleration. Values:
<li>`0`: Disable acceleration.</li>
<li>`1`: Enable acceleration.</li>
        :type AccelerateType: int
        :param _ProxyType: Layer 4 proxy mode, with value: <li>instance: instance mode.</li>If not specified, the default value instance will be used.
        :type ProxyType: str
        :param _SessionPersistTime: The session persistence duration. Value range: 30-3600 (in seconds).
If not specified, this field uses the default value 600.
        :type SessionPersistTime: int
        :param _Ipv6: Ipv6 access configuration. 
IPv6 access is disabled if it is not specified.
        :type Ipv6: :class:`tencentcloud.teo.v20220901.models.Ipv6`
        :param _ApplicationProxyRules: The rule details.
If this field is not specified, an application proxy rule will not be created.
        :type ApplicationProxyRules: list of ApplicationProxyRule
        :param _AccelerateMainland: Cross-MLC-border acceleration. It is disabled if this parameter is not specified.
        :type AccelerateMainland: :class:`tencentcloud.teo.v20220901.models.AccelerateMainland`
        """
        self._ZoneId = None
        self._ProxyName = None
        self._PlatType = None
        self._SecurityType = None
        self._AccelerateType = None
        self._ProxyType = None
        self._SessionPersistTime = None
        self._Ipv6 = None
        self._ApplicationProxyRules = None
        self._AccelerateMainland = None

    @property
    def ZoneId(self):
        """Site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ProxyName(self):
        """Domain name or subdomain name when `ProxyType=hostname`; 
Instance name when `ProxyType=instance`.
        :rtype: str
        """
        return self._ProxyName

    @ProxyName.setter
    def ProxyName(self, ProxyName):
        self._ProxyName = ProxyName

    @property
    def PlatType(self):
        """The scheduling mode. Values:
<li>`ip`: Schedule via Anycast IP.</li>
<li>`domain`: Schedule via CNAME.</li>
        :rtype: str
        """
        return self._PlatType

    @PlatType.setter
    def PlatType(self, PlatType):
        self._PlatType = PlatType

    @property
    def SecurityType(self):
        """Whether to enable security protection. Values:
<li>`0`: Disable security protection.</li>
<li>`1`: Enable security protection.</li>
        :rtype: int
        """
        return self._SecurityType

    @SecurityType.setter
    def SecurityType(self, SecurityType):
        self._SecurityType = SecurityType

    @property
    def AccelerateType(self):
        """Whether to enable acceleration. Values:
<li>`0`: Disable acceleration.</li>
<li>`1`: Enable acceleration.</li>
        :rtype: int
        """
        return self._AccelerateType

    @AccelerateType.setter
    def AccelerateType(self, AccelerateType):
        self._AccelerateType = AccelerateType

    @property
    def ProxyType(self):
        """Layer 4 proxy mode, with value: <li>instance: instance mode.</li>If not specified, the default value instance will be used.
        :rtype: str
        """
        return self._ProxyType

    @ProxyType.setter
    def ProxyType(self, ProxyType):
        self._ProxyType = ProxyType

    @property
    def SessionPersistTime(self):
        """The session persistence duration. Value range: 30-3600 (in seconds).
If not specified, this field uses the default value 600.
        :rtype: int
        """
        return self._SessionPersistTime

    @SessionPersistTime.setter
    def SessionPersistTime(self, SessionPersistTime):
        self._SessionPersistTime = SessionPersistTime

    @property
    def Ipv6(self):
        """Ipv6 access configuration. 
IPv6 access is disabled if it is not specified.
        :rtype: :class:`tencentcloud.teo.v20220901.models.Ipv6`
        """
        return self._Ipv6

    @Ipv6.setter
    def Ipv6(self, Ipv6):
        self._Ipv6 = Ipv6

    @property
    def ApplicationProxyRules(self):
        """The rule details.
If this field is not specified, an application proxy rule will not be created.
        :rtype: list of ApplicationProxyRule
        """
        return self._ApplicationProxyRules

    @ApplicationProxyRules.setter
    def ApplicationProxyRules(self, ApplicationProxyRules):
        self._ApplicationProxyRules = ApplicationProxyRules

    @property
    def AccelerateMainland(self):
        """Cross-MLC-border acceleration. It is disabled if this parameter is not specified.
        :rtype: :class:`tencentcloud.teo.v20220901.models.AccelerateMainland`
        """
        return self._AccelerateMainland

    @AccelerateMainland.setter
    def AccelerateMainland(self, AccelerateMainland):
        self._AccelerateMainland = AccelerateMainland


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ProxyName = params.get("ProxyName")
        self._PlatType = params.get("PlatType")
        self._SecurityType = params.get("SecurityType")
        self._AccelerateType = params.get("AccelerateType")
        self._ProxyType = params.get("ProxyType")
        self._SessionPersistTime = params.get("SessionPersistTime")
        if params.get("Ipv6") is not None:
            self._Ipv6 = Ipv6()
            self._Ipv6._deserialize(params.get("Ipv6"))
        if params.get("ApplicationProxyRules") is not None:
            self._ApplicationProxyRules = []
            for item in params.get("ApplicationProxyRules"):
                obj = ApplicationProxyRule()
                obj._deserialize(item)
                self._ApplicationProxyRules.append(obj)
        if params.get("AccelerateMainland") is not None:
            self._AccelerateMainland = AccelerateMainland()
            self._AccelerateMainland._deserialize(params.get("AccelerateMainland"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApplicationProxyResponse(AbstractModel):
    """CreateApplicationProxy response structure.

    """

    def __init__(self):
        r"""
        :param _ProxyId: The L4 application proxy ID.
        :type ProxyId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ProxyId = None
        self._RequestId = None

    @property
    def ProxyId(self):
        """The L4 application proxy ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ProxyId = params.get("ProxyId")
        self._RequestId = params.get("RequestId")


class CreateApplicationProxyRuleRequest(AbstractModel):
    """CreateApplicationProxyRule request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        :param _ProxyId: The proxy ID.
        :type ProxyId: str
        :param _Proto: The protocol. Values:
<li>`TCP`: TCP protocol</li>
<li>`UDP`: UDP protocol</li>
        :type Proto: str
        :param _Port: The access port, which can be:
<li>A single port, such as 80</li>
<li>A port range, such as 81-90</li>
        :type Port: list of str
        :param _OriginType: Origin server type. Valid values:<li>custom: Manually added;</li>
<li>loadbalancer: Cloud Load Balancer;</li><li>origins: Origin server group.</li>
        :type OriginType: str
        :param _OriginValue: Details of the origin server:<li>When OriginType is custom, it indicates one or more origin servers, such as ["8.8.8.8","9.9.9.9"] or OriginValue=["test.com"];</li><li>When OriginType is loadbalancer, it indicates a single Cloud Load Balancer, such as ["lb-xdffsfasdfs"];</li><li>When OriginType is origins, it requires one and only one element, which represents an origin server group ID, such as ["origin-537f5b41-162a-11ed-abaa-525400c5da15"].</li>
        :type OriginValue: list of str
        :param _ForwardClientIp: Passes the client IP. Values:
<li>`TOA`: Pass the client IP via TOA (available only when `Proto=TCP`).</li>
<li>`PPV1`: Pass the client IP via Proxy Protocol V1 (available only when `Proto=TCP`).</li>
<li>`PPV2`: Pass the client IP via Proxy Protocol V2.</li>
<li>`OFF`: Not pass the client IP.</li>Default value: OFF.
        :type ForwardClientIp: str
        :param _SessionPersist: Whether to enable session persistence. Values:
<li>`true`: Enable.</li>
<li>`false`: Disable.</li>Default value: false.
        :type SessionPersist: bool
        :param _SessionPersistTime: Duration for the persistent session. The value takes effect only when `SessionPersist = true`.
        :type SessionPersistTime: int
        :param _OriginPort: The origin port, which can be:
<li>A single port, such as 80</li>
<li>A port range, such as 81-82</li>
        :type OriginPort: str
        :param _RuleTag: Rule tag. This parameter is left empty by default.
        :type RuleTag: str
        """
        self._ZoneId = None
        self._ProxyId = None
        self._Proto = None
        self._Port = None
        self._OriginType = None
        self._OriginValue = None
        self._ForwardClientIp = None
        self._SessionPersist = None
        self._SessionPersistTime = None
        self._OriginPort = None
        self._RuleTag = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ProxyId(self):
        """The proxy ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId

    @property
    def Proto(self):
        """The protocol. Values:
<li>`TCP`: TCP protocol</li>
<li>`UDP`: UDP protocol</li>
        :rtype: str
        """
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def Port(self):
        """The access port, which can be:
<li>A single port, such as 80</li>
<li>A port range, such as 81-90</li>
        :rtype: list of str
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def OriginType(self):
        """Origin server type. Valid values:<li>custom: Manually added;</li>
<li>loadbalancer: Cloud Load Balancer;</li><li>origins: Origin server group.</li>
        :rtype: str
        """
        return self._OriginType

    @OriginType.setter
    def OriginType(self, OriginType):
        self._OriginType = OriginType

    @property
    def OriginValue(self):
        """Details of the origin server:<li>When OriginType is custom, it indicates one or more origin servers, such as ["8.8.8.8","9.9.9.9"] or OriginValue=["test.com"];</li><li>When OriginType is loadbalancer, it indicates a single Cloud Load Balancer, such as ["lb-xdffsfasdfs"];</li><li>When OriginType is origins, it requires one and only one element, which represents an origin server group ID, such as ["origin-537f5b41-162a-11ed-abaa-525400c5da15"].</li>
        :rtype: list of str
        """
        return self._OriginValue

    @OriginValue.setter
    def OriginValue(self, OriginValue):
        self._OriginValue = OriginValue

    @property
    def ForwardClientIp(self):
        """Passes the client IP. Values:
<li>`TOA`: Pass the client IP via TOA (available only when `Proto=TCP`).</li>
<li>`PPV1`: Pass the client IP via Proxy Protocol V1 (available only when `Proto=TCP`).</li>
<li>`PPV2`: Pass the client IP via Proxy Protocol V2.</li>
<li>`OFF`: Not pass the client IP.</li>Default value: OFF.
        :rtype: str
        """
        return self._ForwardClientIp

    @ForwardClientIp.setter
    def ForwardClientIp(self, ForwardClientIp):
        self._ForwardClientIp = ForwardClientIp

    @property
    def SessionPersist(self):
        """Whether to enable session persistence. Values:
<li>`true`: Enable.</li>
<li>`false`: Disable.</li>Default value: false.
        :rtype: bool
        """
        return self._SessionPersist

    @SessionPersist.setter
    def SessionPersist(self, SessionPersist):
        self._SessionPersist = SessionPersist

    @property
    def SessionPersistTime(self):
        """Duration for the persistent session. The value takes effect only when `SessionPersist = true`.
        :rtype: int
        """
        return self._SessionPersistTime

    @SessionPersistTime.setter
    def SessionPersistTime(self, SessionPersistTime):
        self._SessionPersistTime = SessionPersistTime

    @property
    def OriginPort(self):
        """The origin port, which can be:
<li>A single port, such as 80</li>
<li>A port range, such as 81-82</li>
        :rtype: str
        """
        return self._OriginPort

    @OriginPort.setter
    def OriginPort(self, OriginPort):
        self._OriginPort = OriginPort

    @property
    def RuleTag(self):
        """Rule tag. This parameter is left empty by default.
        :rtype: str
        """
        return self._RuleTag

    @RuleTag.setter
    def RuleTag(self, RuleTag):
        self._RuleTag = RuleTag


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ProxyId = params.get("ProxyId")
        self._Proto = params.get("Proto")
        self._Port = params.get("Port")
        self._OriginType = params.get("OriginType")
        self._OriginValue = params.get("OriginValue")
        self._ForwardClientIp = params.get("ForwardClientIp")
        self._SessionPersist = params.get("SessionPersist")
        self._SessionPersistTime = params.get("SessionPersistTime")
        self._OriginPort = params.get("OriginPort")
        self._RuleTag = params.get("RuleTag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApplicationProxyRuleResponse(AbstractModel):
    """CreateApplicationProxyRule response structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: The rule ID.
        :type RuleId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleId = None
        self._RequestId = None

    @property
    def RuleId(self):
        """The rule ID.
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class CreateCLSIndexRequest(AbstractModel):
    """CreateCLSIndex request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _TaskId: The ID of the real-time log delivery task.
        :type TaskId: str
        """
        self._ZoneId = None
        self._TaskId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TaskId(self):
        """The ID of the real-time log delivery task.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCLSIndexResponse(AbstractModel):
    """CreateCLSIndex response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateConfigGroupVersionRequest(AbstractModel):
    """CreateConfigGroupVersion request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _GroupId: GroupId of the version to be created.
        :type GroupId: str
        :param _Content: Configuration content to be imported. It is required to be in JSON format and encoded in UTF-8. Please refer to the example below for the configuration file content.
        :type Content: str
        :param _Description: Version description. The maximum length allowed is 50 characters. This field can be used to provide details about the application scenarios of this version.
        :type Description: str
        """
        self._ZoneId = None
        self._GroupId = None
        self._Content = None
        self._Description = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        """GroupId of the version to be created.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Content(self):
        """Configuration content to be imported. It is required to be in JSON format and encoded in UTF-8. Please refer to the example below for the configuration file content.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Description(self):
        """Version description. The maximum length allowed is 50 characters. This field can be used to provide details about the application scenarios of this version.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        self._Content = params.get("Content")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateConfigGroupVersionResponse(AbstractModel):
    """CreateConfigGroupVersion response structure.

    """

    def __init__(self):
        r"""
        :param _VersionId: Version ID.
        :type VersionId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VersionId = None
        self._RequestId = None

    @property
    def VersionId(self):
        """Version ID.
        :rtype: str
        """
        return self._VersionId

    @VersionId.setter
    def VersionId(self, VersionId):
        self._VersionId = VersionId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._VersionId = params.get("VersionId")
        self._RequestId = params.get("RequestId")


class CreateContentIdentifierRequest(AbstractModel):
    """CreateContentIdentifier request structure.

    """

    def __init__(self):
        r"""
        :param _Description: Description of the content identifier, length limit of up to 20 characters.
        :type Description: str
        :param _PlanId: Target plan id to be bound, available only for the enterprise edition. <li>if there is already a plan under your account, go to [plan management](https://console.cloud.tencent.com/edgeone/package) to get the plan id and directly bind the content identifier to the plan;</li><li>if you do not have a plan to bind, please purchase an enterprise edition plan first.</li>.
        :type PlanId: str
        :param _Tags: Tags of the content identifier. this parameter is used for authority control. to create tags, go to the [tag console](https://console.cloud.tencent.com/tag/taglist).
        :type Tags: list of Tag
        """
        self._Description = None
        self._PlanId = None
        self._Tags = None

    @property
    def Description(self):
        """Description of the content identifier, length limit of up to 20 characters.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PlanId(self):
        """Target plan id to be bound, available only for the enterprise edition. <li>if there is already a plan under your account, go to [plan management](https://console.cloud.tencent.com/edgeone/package) to get the plan id and directly bind the content identifier to the plan;</li><li>if you do not have a plan to bind, please purchase an enterprise edition plan first.</li>.
        :rtype: str
        """
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def Tags(self):
        """Tags of the content identifier. this parameter is used for authority control. to create tags, go to the [tag console](https://console.cloud.tencent.com/tag/taglist).
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Description = params.get("Description")
        self._PlanId = params.get("PlanId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateContentIdentifierResponse(AbstractModel):
    """CreateContentIdentifier response structure.

    """

    def __init__(self):
        r"""
        :param _ContentId: Generated content identifier id. after creation, you can go to the rule engine to "set the content identifier" under certain match conditions.
        :type ContentId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ContentId = None
        self._RequestId = None

    @property
    def ContentId(self):
        """Generated content identifier id. after creation, you can go to the rule engine to "set the content identifier" under certain match conditions.
        :rtype: str
        """
        return self._ContentId

    @ContentId.setter
    def ContentId(self, ContentId):
        self._ContentId = ContentId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ContentId = params.get("ContentId")
        self._RequestId = params.get("RequestId")


class CreateCustomizeErrorPageRequest(AbstractModel):
    """CreateCustomizeErrorPage request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Name: Custom error page name. The name must be 2-30 characters long.
        :type Name: str
        :param _ContentType: Custom error page type, with values:<li>text/html; </li><li>application/json;</li><li>text/plain;</li><li>text/xml.</li>
        :type ContentType: str
        :param _Description: Custom error page description, not exceeding 60 characters.
        :type Description: str
        :param _Content: Custom error page content, not exceeding 2 KB.
        :type Content: str
        """
        self._ZoneId = None
        self._Name = None
        self._ContentType = None
        self._Description = None
        self._Content = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Name(self):
        """Custom error page name. The name must be 2-30 characters long.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ContentType(self):
        """Custom error page type, with values:<li>text/html; </li><li>application/json;</li><li>text/plain;</li><li>text/xml.</li>
        :rtype: str
        """
        return self._ContentType

    @ContentType.setter
    def ContentType(self, ContentType):
        self._ContentType = ContentType

    @property
    def Description(self):
        """Custom error page description, not exceeding 60 characters.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Content(self):
        """Custom error page content, not exceeding 2 KB.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Name = params.get("Name")
        self._ContentType = params.get("ContentType")
        self._Description = params.get("Description")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomizeErrorPageResponse(AbstractModel):
    """CreateCustomizeErrorPage response structure.

    """

    def __init__(self):
        r"""
        :param _PageId: Page ID.
        :type PageId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PageId = None
        self._RequestId = None

    @property
    def PageId(self):
        """Page ID.
        :rtype: str
        """
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PageId = params.get("PageId")
        self._RequestId = params.get("RequestId")


class CreateDnsRecordRequest(AbstractModel):
    """CreateDnsRecord request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone id.
        :type ZoneId: str
        :param _Name: DNS record name. if the domain name is in chinese, korean, or japanese, it needs to be converted to punycode before input.
        :type Name: str
        :param _Type: DNS record type. valid values are: <li>a: points the domain name to an external ipv4 address, such as 8.8.8.8;</li><li>aaaa: points the domain name to an external ipv6 address;</li><li>mx: used for email servers. when there are multiple mx records, the lower the priority value, the higher the priority;</li><li>cname: points the domain name to another domain name, which then resolves to the final ip address;</li><li>txt: identifies and describes the domain name, commonly used for domain verification and spf records (anti-spam);</li><li>ns: if you need to delegate the subdomain to another dns service provider for resolution, you need to add an ns record. the root domain cannot add ns records;</li><li>caa: specifies the ca that can issue certificates for this site;</li><li>srv: identifies a server using a service, commonly used in microsoft's directory management.</li>.
Different record types, such as srv and caa records, have different requirements for host record names and record value formats. for detailed descriptions and format examples of each record type, please refer to: [introduction to dns record types](https://intl.cloud.tencent.com/document/product/1552/90453?from_cn_redirect=1#2f681022-91ab-4a9e-ac3d-0a6c454d954e).
        :type Type: str
        :param _Content: DNS record content. fill in the corresponding content according to the type value. if the domain name is in chinese, korean, or japanese, it needs to be converted to punycode before input.
        :type Content: str
        :param _Location: DNS record resolution route. if not specified, the default is default, which means the default resolution route and is effective in all regions.

- resolution route configuration is only applicable when type (dns record type) is a, aaaa, or cname.
- resolution route configuration is only applicable to standard version and enterprise edition packages. for valid values, please refer to: [resolution routes and corresponding code enumeration](https://intl.cloud.tencent.com/document/product/1552/112542?from_cn_redirect=1).
        :type Location: str
        :param _TTL: Cache time. users can specify a value range of 60-86400. the smaller the value, the faster the modification records will take effect in all regions. default value: 300. unit: seconds.
        :type TTL: int
        :param _Weight: DNS record weight. users can specify a value range of -1 to 100. a value of 0 means no resolution. if not specified, the default is -1, which means no weight is set. weight configuration is only applicable when type (dns record type) is a, aaaa, or cname.<br>note: for the same subdomain, different dns records with the same resolution route should either all have weights set or none have weights set.
        :type Weight: int
        :param _Priority: MX record priority, which takes effect only when type (dns record type) is mx. the smaller the value, the higher the priority. users can specify a value range of 0–50. the default value is 0 if not specified.
        :type Priority: int
        """
        self._ZoneId = None
        self._Name = None
        self._Type = None
        self._Content = None
        self._Location = None
        self._TTL = None
        self._Weight = None
        self._Priority = None

    @property
    def ZoneId(self):
        """Zone id.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Name(self):
        """DNS record name. if the domain name is in chinese, korean, or japanese, it needs to be converted to punycode before input.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """DNS record type. valid values are: <li>a: points the domain name to an external ipv4 address, such as 8.8.8.8;</li><li>aaaa: points the domain name to an external ipv6 address;</li><li>mx: used for email servers. when there are multiple mx records, the lower the priority value, the higher the priority;</li><li>cname: points the domain name to another domain name, which then resolves to the final ip address;</li><li>txt: identifies and describes the domain name, commonly used for domain verification and spf records (anti-spam);</li><li>ns: if you need to delegate the subdomain to another dns service provider for resolution, you need to add an ns record. the root domain cannot add ns records;</li><li>caa: specifies the ca that can issue certificates for this site;</li><li>srv: identifies a server using a service, commonly used in microsoft's directory management.</li>.
Different record types, such as srv and caa records, have different requirements for host record names and record value formats. for detailed descriptions and format examples of each record type, please refer to: [introduction to dns record types](https://intl.cloud.tencent.com/document/product/1552/90453?from_cn_redirect=1#2f681022-91ab-4a9e-ac3d-0a6c454d954e).
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Content(self):
        """DNS record content. fill in the corresponding content according to the type value. if the domain name is in chinese, korean, or japanese, it needs to be converted to punycode before input.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Location(self):
        """DNS record resolution route. if not specified, the default is default, which means the default resolution route and is effective in all regions.

- resolution route configuration is only applicable when type (dns record type) is a, aaaa, or cname.
- resolution route configuration is only applicable to standard version and enterprise edition packages. for valid values, please refer to: [resolution routes and corresponding code enumeration](https://intl.cloud.tencent.com/document/product/1552/112542?from_cn_redirect=1).
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def TTL(self):
        """Cache time. users can specify a value range of 60-86400. the smaller the value, the faster the modification records will take effect in all regions. default value: 300. unit: seconds.
        :rtype: int
        """
        return self._TTL

    @TTL.setter
    def TTL(self, TTL):
        self._TTL = TTL

    @property
    def Weight(self):
        """DNS record weight. users can specify a value range of -1 to 100. a value of 0 means no resolution. if not specified, the default is -1, which means no weight is set. weight configuration is only applicable when type (dns record type) is a, aaaa, or cname.<br>note: for the same subdomain, different dns records with the same resolution route should either all have weights set or none have weights set.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def Priority(self):
        """MX record priority, which takes effect only when type (dns record type) is mx. the smaller the value, the higher the priority. users can specify a value range of 0–50. the default value is 0 if not specified.
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Content = params.get("Content")
        self._Location = params.get("Location")
        self._TTL = params.get("TTL")
        self._Weight = params.get("Weight")
        self._Priority = params.get("Priority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDnsRecordResponse(AbstractModel):
    """CreateDnsRecord response structure.

    """

    def __init__(self):
        r"""
        :param _RecordId: DNS record id.
        :type RecordId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RecordId = None
        self._RequestId = None

    @property
    def RecordId(self):
        """DNS record id.
        :rtype: str
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RecordId = params.get("RecordId")
        self._RequestId = params.get("RequestId")


class CreateFunctionRequest(AbstractModel):
    """CreateFunction request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Name: Function name, which can contain up to 30 characters, including lowercase letters, digits, and hyphens. It should start and end with a digit or a letter.
        :type Name: str
        :param _Content: Function content, which currently only supports JavaScript code. Its maximum size is 5 MB.
        :type Content: str
        :param _Remark: Function description, which can contain up to 60 characters.
        :type Remark: str
        """
        self._ZoneId = None
        self._Name = None
        self._Content = None
        self._Remark = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Name(self):
        """Function name, which can contain up to 30 characters, including lowercase letters, digits, and hyphens. It should start and end with a digit or a letter.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Content(self):
        """Function content, which currently only supports JavaScript code. Its maximum size is 5 MB.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Remark(self):
        """Function description, which can contain up to 60 characters.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Name = params.get("Name")
        self._Content = params.get("Content")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFunctionResponse(AbstractModel):
    """CreateFunction response structure.

    """

    def __init__(self):
        r"""
        :param _FunctionId: Function ID.
        :type FunctionId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FunctionId = None
        self._RequestId = None

    @property
    def FunctionId(self):
        """Function ID.
        :rtype: str
        """
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._RequestId = params.get("RequestId")


class CreateFunctionRuleRequest(AbstractModel):
    """CreateFunctionRule request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _FunctionRuleConditions: Rule condition list. There is an OR relationship between different conditions of the same trigger rule.
        :type FunctionRuleConditions: list of FunctionRuleCondition
        :param _FunctionId: Function ID, specifying a function executed when a trigger rule condition is met.
        :type FunctionId: str
        :param _Remark: Rule description, which can contain up to 60 characters.
        :type Remark: str
        """
        self._ZoneId = None
        self._FunctionRuleConditions = None
        self._FunctionId = None
        self._Remark = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def FunctionRuleConditions(self):
        """Rule condition list. There is an OR relationship between different conditions of the same trigger rule.
        :rtype: list of FunctionRuleCondition
        """
        return self._FunctionRuleConditions

    @FunctionRuleConditions.setter
    def FunctionRuleConditions(self, FunctionRuleConditions):
        self._FunctionRuleConditions = FunctionRuleConditions

    @property
    def FunctionId(self):
        """Function ID, specifying a function executed when a trigger rule condition is met.
        :rtype: str
        """
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def Remark(self):
        """Rule description, which can contain up to 60 characters.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("FunctionRuleConditions") is not None:
            self._FunctionRuleConditions = []
            for item in params.get("FunctionRuleConditions"):
                obj = FunctionRuleCondition()
                obj._deserialize(item)
                self._FunctionRuleConditions.append(obj)
        self._FunctionId = params.get("FunctionId")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFunctionRuleResponse(AbstractModel):
    """CreateFunctionRule response structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: Rule ID.
        :type RuleId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleId = None
        self._RequestId = None

    @property
    def RuleId(self):
        """Rule ID.
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class CreateL4ProxyRequest(AbstractModel):
    """CreateL4Proxy request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _ProxyName: Name of the L4 proxy instance, which can contain 1-50 characters, including a-z, 0-9, and hyphens (-). However, hyphens (-) cannot be used individually or consecutively and should not be placed at the beginning or end of the name. Modification is not allowed after creation.

        :type ProxyName: str
        :param _Area: Acceleration zone of the L4 proxy instance.
<li>mainland: Chinese mainland availability zone;</li>
<li>overseas: global availability zone (excluding the Chinese mainland);</li>
<li>global: global availability zone.</li>
        :type Area: str
        :param _Ipv6: Whether to enable IPv6 access. If this parameter is not input, the default value `off` is used. This configuration can be enabled only in certain acceleration zones and security protection configurations. For details, see [Creating an L4 Proxy Instance] (https://intl.cloud.tencent.com/document/product/1552/90025?from_cn_redirect=1). Valid values:
<li>on: Enable;</li>
<li>off: Disable.</li>


        :type Ipv6: str
        :param _StaticIp: Whether to enable static IP. If this parameter is not input, the default value `off` is used. This configuration can be enabled only in certain acceleration zones and security protection configurations. For details, see [Creating an L4 Proxy Instance] (https://intl.cloud.tencent.com/document/product/1552/90025?from_cn_redirect=1). Valid values:
<li>on: Enable;</li>
<li>off: Disable.</li>

        :type StaticIp: str
        :param _AccelerateMainland: Whether to enable network optimization for the Chinese mainland. If this parameter is not input, the default value `off` is used. This configuration can be enabled only in certain acceleration zones and security protection configurations. For details, see [Creating an L4 Proxy Instance] (https://intl.cloud.tencent.com/document/product/1552/90025?from_cn_redirect=1). Valid values:
<li>on: Enable;</li>
<li>off: Disable.</li>

        :type AccelerateMainland: str
        :param _DDosProtectionConfig: Configuration of L3/L4 DDoS protection. If this parameter is not input, the default platform protection option is used. For details, see [Exclusive DDoS Protection Usage] (https://intl.cloud.tencent.com/document/product/1552/95994?from_cn_redirect=1).
        :type DDosProtectionConfig: :class:`tencentcloud.teo.v20220901.models.DDosProtectionConfig`
        """
        self._ZoneId = None
        self._ProxyName = None
        self._Area = None
        self._Ipv6 = None
        self._StaticIp = None
        self._AccelerateMainland = None
        self._DDosProtectionConfig = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ProxyName(self):
        """Name of the L4 proxy instance, which can contain 1-50 characters, including a-z, 0-9, and hyphens (-). However, hyphens (-) cannot be used individually or consecutively and should not be placed at the beginning or end of the name. Modification is not allowed after creation.

        :rtype: str
        """
        return self._ProxyName

    @ProxyName.setter
    def ProxyName(self, ProxyName):
        self._ProxyName = ProxyName

    @property
    def Area(self):
        """Acceleration zone of the L4 proxy instance.
<li>mainland: Chinese mainland availability zone;</li>
<li>overseas: global availability zone (excluding the Chinese mainland);</li>
<li>global: global availability zone.</li>
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Ipv6(self):
        """Whether to enable IPv6 access. If this parameter is not input, the default value `off` is used. This configuration can be enabled only in certain acceleration zones and security protection configurations. For details, see [Creating an L4 Proxy Instance] (https://intl.cloud.tencent.com/document/product/1552/90025?from_cn_redirect=1). Valid values:
<li>on: Enable;</li>
<li>off: Disable.</li>


        :rtype: str
        """
        return self._Ipv6

    @Ipv6.setter
    def Ipv6(self, Ipv6):
        self._Ipv6 = Ipv6

    @property
    def StaticIp(self):
        """Whether to enable static IP. If this parameter is not input, the default value `off` is used. This configuration can be enabled only in certain acceleration zones and security protection configurations. For details, see [Creating an L4 Proxy Instance] (https://intl.cloud.tencent.com/document/product/1552/90025?from_cn_redirect=1). Valid values:
<li>on: Enable;</li>
<li>off: Disable.</li>

        :rtype: str
        """
        return self._StaticIp

    @StaticIp.setter
    def StaticIp(self, StaticIp):
        self._StaticIp = StaticIp

    @property
    def AccelerateMainland(self):
        """Whether to enable network optimization for the Chinese mainland. If this parameter is not input, the default value `off` is used. This configuration can be enabled only in certain acceleration zones and security protection configurations. For details, see [Creating an L4 Proxy Instance] (https://intl.cloud.tencent.com/document/product/1552/90025?from_cn_redirect=1). Valid values:
<li>on: Enable;</li>
<li>off: Disable.</li>

        :rtype: str
        """
        return self._AccelerateMainland

    @AccelerateMainland.setter
    def AccelerateMainland(self, AccelerateMainland):
        self._AccelerateMainland = AccelerateMainland

    @property
    def DDosProtectionConfig(self):
        """Configuration of L3/L4 DDoS protection. If this parameter is not input, the default platform protection option is used. For details, see [Exclusive DDoS Protection Usage] (https://intl.cloud.tencent.com/document/product/1552/95994?from_cn_redirect=1).
        :rtype: :class:`tencentcloud.teo.v20220901.models.DDosProtectionConfig`
        """
        return self._DDosProtectionConfig

    @DDosProtectionConfig.setter
    def DDosProtectionConfig(self, DDosProtectionConfig):
        self._DDosProtectionConfig = DDosProtectionConfig


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ProxyName = params.get("ProxyName")
        self._Area = params.get("Area")
        self._Ipv6 = params.get("Ipv6")
        self._StaticIp = params.get("StaticIp")
        self._AccelerateMainland = params.get("AccelerateMainland")
        if params.get("DDosProtectionConfig") is not None:
            self._DDosProtectionConfig = DDosProtectionConfig()
            self._DDosProtectionConfig._deserialize(params.get("DDosProtectionConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateL4ProxyResponse(AbstractModel):
    """CreateL4Proxy response structure.

    """

    def __init__(self):
        r"""
        :param _ProxyId: L4 instance ID.
        :type ProxyId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ProxyId = None
        self._RequestId = None

    @property
    def ProxyId(self):
        """L4 instance ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ProxyId = params.get("ProxyId")
        self._RequestId = params.get("RequestId")


class CreateL4ProxyRulesRequest(AbstractModel):
    """CreateL4ProxyRules request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _ProxyId: Layer 4 proxy instance ID.
        :type ProxyId: str
        :param _L4ProxyRules: List of forwarding rules. A single request supports up to 200 forwarding rules.
Note: When L4ProxyRule is used here, Protocol, PortRange, OriginType, OriginValue, and OriginPortRange are required fields; ClientIPPassThroughMode, SessionPersist, SessionPersistTime, and RuleTag are optional fields; do not fill in RuleId and Status.
        :type L4ProxyRules: list of L4ProxyRule
        """
        self._ZoneId = None
        self._ProxyId = None
        self._L4ProxyRules = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ProxyId(self):
        """Layer 4 proxy instance ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId

    @property
    def L4ProxyRules(self):
        """List of forwarding rules. A single request supports up to 200 forwarding rules.
Note: When L4ProxyRule is used here, Protocol, PortRange, OriginType, OriginValue, and OriginPortRange are required fields; ClientIPPassThroughMode, SessionPersist, SessionPersistTime, and RuleTag are optional fields; do not fill in RuleId and Status.
        :rtype: list of L4ProxyRule
        """
        return self._L4ProxyRules

    @L4ProxyRules.setter
    def L4ProxyRules(self, L4ProxyRules):
        self._L4ProxyRules = L4ProxyRules


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ProxyId = params.get("ProxyId")
        if params.get("L4ProxyRules") is not None:
            self._L4ProxyRules = []
            for item in params.get("L4ProxyRules"):
                obj = L4ProxyRule()
                obj._deserialize(item)
                self._L4ProxyRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateL4ProxyRulesResponse(AbstractModel):
    """CreateL4ProxyRules response structure.

    """

    def __init__(self):
        r"""
        :param _L4ProxyRuleIds: IDs of newly added forwarding rules, returned as an array.
        :type L4ProxyRuleIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._L4ProxyRuleIds = None
        self._RequestId = None

    @property
    def L4ProxyRuleIds(self):
        """IDs of newly added forwarding rules, returned as an array.
        :rtype: list of str
        """
        return self._L4ProxyRuleIds

    @L4ProxyRuleIds.setter
    def L4ProxyRuleIds(self, L4ProxyRuleIds):
        self._L4ProxyRuleIds = L4ProxyRuleIds

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._L4ProxyRuleIds = params.get("L4ProxyRuleIds")
        self._RequestId = params.get("RequestId")


class CreateL7AccRulesRequest(AbstractModel):
    """CreateL7AccRules request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone id.
        :type ZoneId: str
        :param _Rules: The rule content.
        :type Rules: list of RuleEngineItem
        """
        self._ZoneId = None
        self._Rules = None

    @property
    def ZoneId(self):
        """Zone id.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Rules(self):
        """The rule content.
        :rtype: list of RuleEngineItem
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleEngineItem()
                obj._deserialize(item)
                self._Rules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateL7AccRulesResponse(AbstractModel):
    """CreateL7AccRules response structure.

    """

    def __init__(self):
        r"""
        :param _RuleIds: Rule id list.
        :type RuleIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleIds = None
        self._RequestId = None

    @property
    def RuleIds(self):
        """Rule id list.
        :rtype: list of str
        """
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleIds = params.get("RuleIds")
        self._RequestId = params.get("RequestId")


class CreateLoadBalancerRequest(AbstractModel):
    """CreateLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Name: LoadBalancer name, which can contain 1 to 200 characters, including a-z, A-Z, 0-9, underscores (_), and hyphens (-).
        :type Name: str
        :param _Type: LoadBalancer type. Valid values:
<li>HTTP: HTTP-specific LoadBalancer. It supports adding HTTP-specific and general origin server groups. It can only be referenced by site acceleration services (such as domain name service and rule engine).</li>
<li>GENERAL: general LoadBalancer. It only supports adding general origin server groups. It can be referenced by site acceleration services (such as domain name service and rule engine) and Layer-4 proxy.</li>
        :type Type: str
        :param _OriginGroups: List of origin server groups and their corresponding disaster recovery scheduling priorities. For details, refer to Sample Scenario in [Quickly Create Load Balancers](https://intl.cloud.tencent.com/document/product/1552/104223?from_cn_redirect=1).
        :type OriginGroups: list of OriginGroupInLoadBalancer
        :param _HealthChecker: Health check policy. For details, refer to [Health Check Policies](https://intl.cloud.tencent.com/document/product/1552/104228?from_cn_redirect=1). If left empty, health check is disabled by default.
        :type HealthChecker: :class:`tencentcloud.teo.v20220901.models.HealthChecker`
        :param _SteeringPolicy: Traffic scheduling policy among origin server groups. Valid values:
<li>Priority: Perform failover according to priority.</li>The default value is Priority.
        :type SteeringPolicy: str
        :param _FailoverPolicy: Request retry policy when access to an origin server fails. For details, refer to [Introduction to Request Retry Strategy](https://intl.cloud.tencent.com/document/product/1552/104227?from_cn_redirect=1). Valid values:
<li>OtherOriginGroup: After a single request fails, retry with another origin server within the next lower priority origin server group.</li>
<li>OtherRecordInOriginGroup: After a single request fails, retry with another origin server within the same origin server group.</li> The default value is OtherRecordInOriginGroup.
        :type FailoverPolicy: str
        """
        self._ZoneId = None
        self._Name = None
        self._Type = None
        self._OriginGroups = None
        self._HealthChecker = None
        self._SteeringPolicy = None
        self._FailoverPolicy = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Name(self):
        """LoadBalancer name, which can contain 1 to 200 characters, including a-z, A-Z, 0-9, underscores (_), and hyphens (-).
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """LoadBalancer type. Valid values:
<li>HTTP: HTTP-specific LoadBalancer. It supports adding HTTP-specific and general origin server groups. It can only be referenced by site acceleration services (such as domain name service and rule engine).</li>
<li>GENERAL: general LoadBalancer. It only supports adding general origin server groups. It can be referenced by site acceleration services (such as domain name service and rule engine) and Layer-4 proxy.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def OriginGroups(self):
        """List of origin server groups and their corresponding disaster recovery scheduling priorities. For details, refer to Sample Scenario in [Quickly Create Load Balancers](https://intl.cloud.tencent.com/document/product/1552/104223?from_cn_redirect=1).
        :rtype: list of OriginGroupInLoadBalancer
        """
        return self._OriginGroups

    @OriginGroups.setter
    def OriginGroups(self, OriginGroups):
        self._OriginGroups = OriginGroups

    @property
    def HealthChecker(self):
        """Health check policy. For details, refer to [Health Check Policies](https://intl.cloud.tencent.com/document/product/1552/104228?from_cn_redirect=1). If left empty, health check is disabled by default.
        :rtype: :class:`tencentcloud.teo.v20220901.models.HealthChecker`
        """
        return self._HealthChecker

    @HealthChecker.setter
    def HealthChecker(self, HealthChecker):
        self._HealthChecker = HealthChecker

    @property
    def SteeringPolicy(self):
        """Traffic scheduling policy among origin server groups. Valid values:
<li>Priority: Perform failover according to priority.</li>The default value is Priority.
        :rtype: str
        """
        return self._SteeringPolicy

    @SteeringPolicy.setter
    def SteeringPolicy(self, SteeringPolicy):
        self._SteeringPolicy = SteeringPolicy

    @property
    def FailoverPolicy(self):
        """Request retry policy when access to an origin server fails. For details, refer to [Introduction to Request Retry Strategy](https://intl.cloud.tencent.com/document/product/1552/104227?from_cn_redirect=1). Valid values:
<li>OtherOriginGroup: After a single request fails, retry with another origin server within the next lower priority origin server group.</li>
<li>OtherRecordInOriginGroup: After a single request fails, retry with another origin server within the same origin server group.</li> The default value is OtherRecordInOriginGroup.
        :rtype: str
        """
        return self._FailoverPolicy

    @FailoverPolicy.setter
    def FailoverPolicy(self, FailoverPolicy):
        self._FailoverPolicy = FailoverPolicy


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        if params.get("OriginGroups") is not None:
            self._OriginGroups = []
            for item in params.get("OriginGroups"):
                obj = OriginGroupInLoadBalancer()
                obj._deserialize(item)
                self._OriginGroups.append(obj)
        if params.get("HealthChecker") is not None:
            self._HealthChecker = HealthChecker()
            self._HealthChecker._deserialize(params.get("HealthChecker"))
        self._SteeringPolicy = params.get("SteeringPolicy")
        self._FailoverPolicy = params.get("FailoverPolicy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLoadBalancerResponse(AbstractModel):
    """CreateLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: CLB instance ID.
        :type InstanceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._RequestId = None

    @property
    def InstanceId(self):
        """CLB instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._RequestId = params.get("RequestId")


class CreateOriginGroupRequest(AbstractModel):
    """CreateOriginGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID
        :type ZoneId: str
        :param _Name: Origin group name. It can contain 1 to 200 characters ([a-z], [A-Z], [0-9] and [_-]).
        :type Name: str
        :param _Type: (Required) Origin group type. Values:
<li>`GENERAL`: General origin groups. It supports IPs and domain names. It can be referenced by DNS, Rule Engine, Layer 4 Proxy and General LoadBalancer. </li>
<li>`HTTP`: HTTP-specific origin groups. It supports IPs/domain names and object storage buckets. It can be referenced by acceleration domain names, rule engines and HTTP LoadBalancer. It cannot be referenced by L4 proxies. </li>
        :type Type: str
        :param _Records: (Required) Origins in the origin group.
        :type Records: list of OriginRecord
        :param _HostHeader: Host header used for origin-pull. It only works when `Type=HTTP`. The `HostHeader` specified in `RuleEngine` takes a higher priority over this configuration.
        :type HostHeader: str
        """
        self._ZoneId = None
        self._Name = None
        self._Type = None
        self._Records = None
        self._HostHeader = None

    @property
    def ZoneId(self):
        """Site ID
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Name(self):
        """Origin group name. It can contain 1 to 200 characters ([a-z], [A-Z], [0-9] and [_-]).
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """(Required) Origin group type. Values:
<li>`GENERAL`: General origin groups. It supports IPs and domain names. It can be referenced by DNS, Rule Engine, Layer 4 Proxy and General LoadBalancer. </li>
<li>`HTTP`: HTTP-specific origin groups. It supports IPs/domain names and object storage buckets. It can be referenced by acceleration domain names, rule engines and HTTP LoadBalancer. It cannot be referenced by L4 proxies. </li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Records(self):
        """(Required) Origins in the origin group.
        :rtype: list of OriginRecord
        """
        return self._Records

    @Records.setter
    def Records(self, Records):
        self._Records = Records

    @property
    def HostHeader(self):
        """Host header used for origin-pull. It only works when `Type=HTTP`. The `HostHeader` specified in `RuleEngine` takes a higher priority over this configuration.
        :rtype: str
        """
        return self._HostHeader

    @HostHeader.setter
    def HostHeader(self, HostHeader):
        self._HostHeader = HostHeader


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        if params.get("Records") is not None:
            self._Records = []
            for item in params.get("Records"):
                obj = OriginRecord()
                obj._deserialize(item)
                self._Records.append(obj)
        self._HostHeader = params.get("HostHeader")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOriginGroupResponse(AbstractModel):
    """CreateOriginGroup response structure.

    """

    def __init__(self):
        r"""
        :param _OriginGroupId: The ID of the origin group.
        :type OriginGroupId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OriginGroupId = None
        self._RequestId = None

    @property
    def OriginGroupId(self):
        """The ID of the origin group.
        :rtype: str
        """
        return self._OriginGroupId

    @OriginGroupId.setter
    def OriginGroupId(self, OriginGroupId):
        self._OriginGroupId = OriginGroupId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OriginGroupId = params.get("OriginGroupId")
        self._RequestId = params.get("RequestId")


class CreatePlanForZoneRequest(AbstractModel):
    """CreatePlanForZone request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site.
        :type ZoneId: str
        :param _PlanType: The plan option. Values:
<li>`sta`: Standard plan that supports content delivery network outside the Chinese mainland.</li>
<li>`sta_with_bot`: Standard plan that supports content delivery network outside the Chinese mainland and bot management.</li>
<li>`sta_cm`: Standard plan that supports content delivery network inside the Chinese mainland.</li>
<li>`sta_cm_with_bot`: Standard plan that supports content delivery network inside the Chinese mainland and bot management.</li>
<li>`sta_global`: Standard plan that supports content delivery network over the globe.</li>
<li>`sta_global_with_bot`: Standard plan that supports content delivery network over the globe and bot management.</li>
<li>`ent`: Enterprise plan that supports content delivery network outside the Chinese mainland.</li>
<li>`ent_with_bot`: Enterprise plan that supports content delivery network outside the Chinese mainland and bot management.</li>
<li>`ent_cm`: Enterprise plan that supports content delivery network inside the Chinese mainland.</li>
<li>`ent_cm_with_bot`: Enterprise plan that supports content delivery network inside the Chinese mainland and bot management.</li>
<li>`ent_global`: Enterprise plan that supports content delivery network over the globe.</li>
<li>`ent_global_with_bot`: Enterprise plan that supports content delivery network over the globe and bot management.</li>To get the available plan options for your account, view the output from <a href="https://intl.cloud.tencent.com/document/product/1552/80606?from_cn_redirect=1">DescribeAvailablePlans</a>.
        :type PlanType: str
        """
        self._ZoneId = None
        self._PlanType = None

    @property
    def ZoneId(self):
        """ID of the site.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def PlanType(self):
        """The plan option. Values:
<li>`sta`: Standard plan that supports content delivery network outside the Chinese mainland.</li>
<li>`sta_with_bot`: Standard plan that supports content delivery network outside the Chinese mainland and bot management.</li>
<li>`sta_cm`: Standard plan that supports content delivery network inside the Chinese mainland.</li>
<li>`sta_cm_with_bot`: Standard plan that supports content delivery network inside the Chinese mainland and bot management.</li>
<li>`sta_global`: Standard plan that supports content delivery network over the globe.</li>
<li>`sta_global_with_bot`: Standard plan that supports content delivery network over the globe and bot management.</li>
<li>`ent`: Enterprise plan that supports content delivery network outside the Chinese mainland.</li>
<li>`ent_with_bot`: Enterprise plan that supports content delivery network outside the Chinese mainland and bot management.</li>
<li>`ent_cm`: Enterprise plan that supports content delivery network inside the Chinese mainland.</li>
<li>`ent_cm_with_bot`: Enterprise plan that supports content delivery network inside the Chinese mainland and bot management.</li>
<li>`ent_global`: Enterprise plan that supports content delivery network over the globe.</li>
<li>`ent_global_with_bot`: Enterprise plan that supports content delivery network over the globe and bot management.</li>To get the available plan options for your account, view the output from <a href="https://intl.cloud.tencent.com/document/product/1552/80606?from_cn_redirect=1">DescribeAvailablePlans</a>.
        :rtype: str
        """
        return self._PlanType

    @PlanType.setter
    def PlanType(self, PlanType):
        self._PlanType = PlanType


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._PlanType = params.get("PlanType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePlanForZoneResponse(AbstractModel):
    """CreatePlanForZone response structure.

    """

    def __init__(self):
        r"""
        :param _ResourceNames: List of purchased resources.
        :type ResourceNames: list of str
        :param _DealNames: List or order numbers.
        :type DealNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ResourceNames = None
        self._DealNames = None
        self._RequestId = None

    @property
    def ResourceNames(self):
        """List of purchased resources.
        :rtype: list of str
        """
        return self._ResourceNames

    @ResourceNames.setter
    def ResourceNames(self, ResourceNames):
        self._ResourceNames = ResourceNames

    @property
    def DealNames(self):
        """List or order numbers.
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ResourceNames = params.get("ResourceNames")
        self._DealNames = params.get("DealNames")
        self._RequestId = params.get("RequestId")


class CreatePlanRequest(AbstractModel):
    """CreatePlan request structure.

    """

    def __init__(self):
        r"""
        :param _PlanType: Type of the subscribed plan. Valid values: <li>personal: Personal plan in prepaid mode;</li><li>basic: Basic plan in prepaid mode;</li><li>standard: Standard plan in prepaid mode;</li><li>enterprise: Enterprise plan in pay-as-you-go mode.</li>When subscribing to a prepaid plan, please ensure that your account balance is sufficient. If the balance is insufficient, an order to be paid will be generated.
For an overview of billing, see [EdgeOne Billing Overview](https://intl.cloud.tencent.com/document/product/1552/94156?from_cn_redirect=1).
For differences between plans, refer to [EdgeOne Billing Plan Comparison](https://intl.cloud.tencent.com/document/product/1552/94165?from_cn_redirect=1).
        :type PlanType: str
        :param _AutoUseVoucher: Whether to automatically use a voucher. Valid values: <li>true: Yes;</li><li>false: No.</li>This parameter is valid only when PlanType is personal, basic, or standard.
If this field is not specified, the default value 'false' will be used.
        :type AutoUseVoucher: str
        :param _PrepaidPlanParam: Parameters for subscribing to a prepaid plan. When PlanType is personal, basic, or standard, this parameter is optional and can be used to specify the subscription duration of the plan and enable auto-renewal.
If this field is not specified, the default plan duration is 1 month, with auto-renewal disabled.
        :type PrepaidPlanParam: :class:`tencentcloud.teo.v20220901.models.PrepaidPlanParam`
        """
        self._PlanType = None
        self._AutoUseVoucher = None
        self._PrepaidPlanParam = None

    @property
    def PlanType(self):
        """Type of the subscribed plan. Valid values: <li>personal: Personal plan in prepaid mode;</li><li>basic: Basic plan in prepaid mode;</li><li>standard: Standard plan in prepaid mode;</li><li>enterprise: Enterprise plan in pay-as-you-go mode.</li>When subscribing to a prepaid plan, please ensure that your account balance is sufficient. If the balance is insufficient, an order to be paid will be generated.
For an overview of billing, see [EdgeOne Billing Overview](https://intl.cloud.tencent.com/document/product/1552/94156?from_cn_redirect=1).
For differences between plans, refer to [EdgeOne Billing Plan Comparison](https://intl.cloud.tencent.com/document/product/1552/94165?from_cn_redirect=1).
        :rtype: str
        """
        return self._PlanType

    @PlanType.setter
    def PlanType(self, PlanType):
        self._PlanType = PlanType

    @property
    def AutoUseVoucher(self):
        """Whether to automatically use a voucher. Valid values: <li>true: Yes;</li><li>false: No.</li>This parameter is valid only when PlanType is personal, basic, or standard.
If this field is not specified, the default value 'false' will be used.
        :rtype: str
        """
        return self._AutoUseVoucher

    @AutoUseVoucher.setter
    def AutoUseVoucher(self, AutoUseVoucher):
        self._AutoUseVoucher = AutoUseVoucher

    @property
    def PrepaidPlanParam(self):
        """Parameters for subscribing to a prepaid plan. When PlanType is personal, basic, or standard, this parameter is optional and can be used to specify the subscription duration of the plan and enable auto-renewal.
If this field is not specified, the default plan duration is 1 month, with auto-renewal disabled.
        :rtype: :class:`tencentcloud.teo.v20220901.models.PrepaidPlanParam`
        """
        return self._PrepaidPlanParam

    @PrepaidPlanParam.setter
    def PrepaidPlanParam(self, PrepaidPlanParam):
        self._PrepaidPlanParam = PrepaidPlanParam


    def _deserialize(self, params):
        self._PlanType = params.get("PlanType")
        self._AutoUseVoucher = params.get("AutoUseVoucher")
        if params.get("PrepaidPlanParam") is not None:
            self._PrepaidPlanParam = PrepaidPlanParam()
            self._PrepaidPlanParam._deserialize(params.get("PrepaidPlanParam"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePlanResponse(AbstractModel):
    """CreatePlan response structure.

    """

    def __init__(self):
        r"""
        :param _PlanId: Plan ID, formatted as edgeone-2unuvzjmmn2q.
        :type PlanId: str
        :param _DealName: Order number.
        :type DealName: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PlanId = None
        self._DealName = None
        self._RequestId = None

    @property
    def PlanId(self):
        """Plan ID, formatted as edgeone-2unuvzjmmn2q.
        :rtype: str
        """
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def DealName(self):
        """Order number.
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PlanId = params.get("PlanId")
        self._DealName = params.get("DealName")
        self._RequestId = params.get("RequestId")


class CreatePrefetchTaskRequest(AbstractModel):
    """CreatePrefetchTask request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site.
        :type ZoneId: str
        :param _Targets: List of resources to be preheated. Each element format is similar to the following:
http://www.example.com/example.txt. The parameter value is currently required.
Note: The number of tasks that can be submitted is limited by the quota of a billing package. For details, see [Billing Overview] (https://intl.cloud.tencent.com/document/product/1552/77380?from_cn_redirect=1).
        :type Targets: list of str
        :param _EncodeUrl: Whether to encode a URL according to RFC3986. Enable this field when the URL contains non-ASCII characters.
        :type EncodeUrl: bool
        :param _Headers: HTTP header information
        :type Headers: list of Header
        """
        self._ZoneId = None
        self._Targets = None
        self._EncodeUrl = None
        self._Headers = None

    @property
    def ZoneId(self):
        """ID of the site.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Targets(self):
        """List of resources to be preheated. Each element format is similar to the following:
http://www.example.com/example.txt. The parameter value is currently required.
Note: The number of tasks that can be submitted is limited by the quota of a billing package. For details, see [Billing Overview] (https://intl.cloud.tencent.com/document/product/1552/77380?from_cn_redirect=1).
        :rtype: list of str
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def EncodeUrl(self):
        warnings.warn("parameter `EncodeUrl` is deprecated", DeprecationWarning) 

        """Whether to encode a URL according to RFC3986. Enable this field when the URL contains non-ASCII characters.
        :rtype: bool
        """
        return self._EncodeUrl

    @EncodeUrl.setter
    def EncodeUrl(self, EncodeUrl):
        warnings.warn("parameter `EncodeUrl` is deprecated", DeprecationWarning) 

        self._EncodeUrl = EncodeUrl

    @property
    def Headers(self):
        """HTTP header information
        :rtype: list of Header
        """
        return self._Headers

    @Headers.setter
    def Headers(self, Headers):
        self._Headers = Headers


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Targets = params.get("Targets")
        self._EncodeUrl = params.get("EncodeUrl")
        if params.get("Headers") is not None:
            self._Headers = []
            for item in params.get("Headers"):
                obj = Header()
                obj._deserialize(item)
                self._Headers.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrefetchTaskResponse(AbstractModel):
    """CreatePrefetchTask response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: ID of the task.
        :type JobId: str
        :param _FailedList: List of failed tasks.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailedList: list of FailReason
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._FailedList = None
        self._RequestId = None

    @property
    def JobId(self):
        """ID of the task.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def FailedList(self):
        """List of failed tasks.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of FailReason
        """
        return self._FailedList

    @FailedList.setter
    def FailedList(self, FailedList):
        self._FailedList = FailedList

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        if params.get("FailedList") is not None:
            self._FailedList = []
            for item in params.get("FailedList"):
                obj = FailReason()
                obj._deserialize(item)
                self._FailedList.append(obj)
        self._RequestId = params.get("RequestId")


class CreatePurgeTaskRequest(AbstractModel):
    """CreatePurgeTask request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone id.
.
If you want to quickly submit targets urls under different sites, you can set it to *, but the account calling this api must have permission for all site resources under the main account.
        :type ZoneId: str
        :param _Type: Type of cache purging. Values:
<li>`purge_url`: Purge by the URL</li>
<li>`purge_prefix`: Purge by the directory</li>
<li>`purge_host`: Purge by the hostname</li>
<li>`purge_all`: Purge all caches</li>
<li>`purge_cache_tag`: Purge by the cache-tag </li>For more details, see [Cache Purge](https://intl.cloud.tencent.com/document/product/1552/70759?from_cn_redirect=1).
        :type Type: str
        :param _Method: Node cache purge method, valid for directory, hostname, and all cache refreshes. Valid values: <li>invalidate: Refreshes only resources that were updated under the directory; </li><li>delete: Refreshes all node resources, regardless of whether they were updated. </li>Default value: invalidate.
        :type Method: str
        :param _Targets: List of resources for which cache is to be purged. Each element format depends on the cache purge type and you can refer to the API examples for details. <li>The number of tasks that can be submitted at a time is limited by the quota of a billing package. For details, see [Billing Overview] (https://intl.cloud.tencent.com/document/product/1552/77380?from_cn_redirect=1).</li>
        :type Targets: list of str
        :param _EncodeUrl: Specifies whether to transcode non-ASCII URLs according to RFC3986.
Note that if it’s enabled, the purging is based on the converted URLs.
        :type EncodeUrl: bool
        :param _CacheTag: The information attached when the node cache purge type is set to purge_cache_tag.
        :type CacheTag: :class:`tencentcloud.teo.v20220901.models.CacheTag`
        """
        self._ZoneId = None
        self._Type = None
        self._Method = None
        self._Targets = None
        self._EncodeUrl = None
        self._CacheTag = None

    @property
    def ZoneId(self):
        """Zone id.
.
If you want to quickly submit targets urls under different sites, you can set it to *, but the account calling this api must have permission for all site resources under the main account.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Type(self):
        """Type of cache purging. Values:
<li>`purge_url`: Purge by the URL</li>
<li>`purge_prefix`: Purge by the directory</li>
<li>`purge_host`: Purge by the hostname</li>
<li>`purge_all`: Purge all caches</li>
<li>`purge_cache_tag`: Purge by the cache-tag </li>For more details, see [Cache Purge](https://intl.cloud.tencent.com/document/product/1552/70759?from_cn_redirect=1).
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Method(self):
        """Node cache purge method, valid for directory, hostname, and all cache refreshes. Valid values: <li>invalidate: Refreshes only resources that were updated under the directory; </li><li>delete: Refreshes all node resources, regardless of whether they were updated. </li>Default value: invalidate.
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def Targets(self):
        """List of resources for which cache is to be purged. Each element format depends on the cache purge type and you can refer to the API examples for details. <li>The number of tasks that can be submitted at a time is limited by the quota of a billing package. For details, see [Billing Overview] (https://intl.cloud.tencent.com/document/product/1552/77380?from_cn_redirect=1).</li>
        :rtype: list of str
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def EncodeUrl(self):
        warnings.warn("parameter `EncodeUrl` is deprecated", DeprecationWarning) 

        """Specifies whether to transcode non-ASCII URLs according to RFC3986.
Note that if it’s enabled, the purging is based on the converted URLs.
        :rtype: bool
        """
        return self._EncodeUrl

    @EncodeUrl.setter
    def EncodeUrl(self, EncodeUrl):
        warnings.warn("parameter `EncodeUrl` is deprecated", DeprecationWarning) 

        self._EncodeUrl = EncodeUrl

    @property
    def CacheTag(self):
        """The information attached when the node cache purge type is set to purge_cache_tag.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CacheTag`
        """
        return self._CacheTag

    @CacheTag.setter
    def CacheTag(self, CacheTag):
        self._CacheTag = CacheTag


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Type = params.get("Type")
        self._Method = params.get("Method")
        self._Targets = params.get("Targets")
        self._EncodeUrl = params.get("EncodeUrl")
        if params.get("CacheTag") is not None:
            self._CacheTag = CacheTag()
            self._CacheTag._deserialize(params.get("CacheTag"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePurgeTaskResponse(AbstractModel):
    """CreatePurgeTask response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: ID of the task.
        :type JobId: str
        :param _FailedList: List of failed tasks and reasons.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailedList: list of FailReason
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._FailedList = None
        self._RequestId = None

    @property
    def JobId(self):
        """ID of the task.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def FailedList(self):
        """List of failed tasks and reasons.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of FailReason
        """
        return self._FailedList

    @FailedList.setter
    def FailedList(self, FailedList):
        self._FailedList = FailedList

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        if params.get("FailedList") is not None:
            self._FailedList = []
            for item in params.get("FailedList"):
                obj = FailReason()
                obj._deserialize(item)
                self._FailedList.append(obj)
        self._RequestId = params.get("RequestId")


class CreateRealtimeLogDeliveryTaskRequest(AbstractModel):
    """CreateRealtimeLogDeliveryTask request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _TaskName: Name of a real-time log delivery task, which can contain up to 200 characters, including digits, English letters, hyphens (-) and underscores (_).
        :type TaskName: str
        :param _TaskType: Type of a real-time log delivery task. Valid values:
<li>cls: push to Tencent Cloud CLS;</li>
<li>custom_endpoint: push to a custom HTTP(S) address;</li>
<li>s3: push to an AWS S3-compatible bucket address.</li>
        :type TaskType: str
        :param _EntityList: List of entities (L7 domain names or L4 proxy instances) corresponding to a real-time log delivery task. Valid value examples:
<li>L7 domain name: domain.example.com;</li>
<li>L4 proxy instance: sid-2s69eb5wcms7.</li>
        :type EntityList: list of str
        :param _LogType: Dataset type. Valid values:
<li>domain: site acceleration logs;</li>
<li>application: L4 proxy logs;</li>
<li>web-rateLiming: rate limit and CC attack defense logs;</li>
<li>web-attack: managed rule logs;</li>
<li>web-rule: custom rule logs;</li>
<li>web-bot: Bot management logs.</li>
        :type LogType: str
        :param _Area: Data area. Valid values:
<li>mainland: within the Chinese mainland;</li>
<li>overseas: global (excluding the Chinese mainland).</li>
        :type Area: str
        :param _Fields: List of predefined fields for delivery.
        :type Fields: list of str
        :param _CustomFields: The list of custom fields for log delivery, which supports extracting specified content from HTTP request headers, response headers, cookies, and request bodies. Custom field names must be unique. The number of custom fields cannot exceed a maximum of 200. A single real-time log delivery task can configure up to 5 custom fields of the request body type. Currently, only site acceleration logs (LogType=domain) support custom fields.
        :type CustomFields: list of CustomField
        :param _DeliveryConditions: Filter criteria of log delivery. If this parameter is not specified, all logs will be shipped.
        :type DeliveryConditions: list of DeliveryCondition
        :param _Sample: Sampling ratio in permille. Value range: 1-1000. For example, 605 indicates a sampling ratio of 60.5%. If this parameter is not specified, the sampling ratio is 100%.
        :type Sample: int
        :param _LogFormat: Output format for log delivery. If this field is not specified, the default format is used, which works as follows:
<li>When TaskType is 'custom_endpoint', the default format is an array of JSON objects, with each JSON object representing a log entry;</li>
<li>When TaskType is 's3', the default format is JSON Lines;</li>Specifically, when TaskType is 'cls', the only allowed value for LogFormat.FormatType is 'json', and other parameters in LogFormat will be ignored. It is recommended not to transfer LogFormat.
        :type LogFormat: :class:`tencentcloud.teo.v20220901.models.LogFormat`
        :param _CLS: Configuration information of CLS. This parameter is required when TaskType is cls.
        :type CLS: :class:`tencentcloud.teo.v20220901.models.CLSTopic`
        :param _CustomEndpoint: Configuration information of the custom HTTP service. This parameter is required when TaskType is custom_endpoint.
        :type CustomEndpoint: :class:`tencentcloud.teo.v20220901.models.CustomEndpoint`
        :param _S3: Configuration information of the AWS S3-compatible bucket. This parameter is required when TaskType is s3.
        :type S3: :class:`tencentcloud.teo.v20220901.models.S3`
        """
        self._ZoneId = None
        self._TaskName = None
        self._TaskType = None
        self._EntityList = None
        self._LogType = None
        self._Area = None
        self._Fields = None
        self._CustomFields = None
        self._DeliveryConditions = None
        self._Sample = None
        self._LogFormat = None
        self._CLS = None
        self._CustomEndpoint = None
        self._S3 = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TaskName(self):
        """Name of a real-time log delivery task, which can contain up to 200 characters, including digits, English letters, hyphens (-) and underscores (_).
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskType(self):
        """Type of a real-time log delivery task. Valid values:
<li>cls: push to Tencent Cloud CLS;</li>
<li>custom_endpoint: push to a custom HTTP(S) address;</li>
<li>s3: push to an AWS S3-compatible bucket address.</li>
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def EntityList(self):
        """List of entities (L7 domain names or L4 proxy instances) corresponding to a real-time log delivery task. Valid value examples:
<li>L7 domain name: domain.example.com;</li>
<li>L4 proxy instance: sid-2s69eb5wcms7.</li>
        :rtype: list of str
        """
        return self._EntityList

    @EntityList.setter
    def EntityList(self, EntityList):
        self._EntityList = EntityList

    @property
    def LogType(self):
        """Dataset type. Valid values:
<li>domain: site acceleration logs;</li>
<li>application: L4 proxy logs;</li>
<li>web-rateLiming: rate limit and CC attack defense logs;</li>
<li>web-attack: managed rule logs;</li>
<li>web-rule: custom rule logs;</li>
<li>web-bot: Bot management logs.</li>
        :rtype: str
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType

    @property
    def Area(self):
        """Data area. Valid values:
<li>mainland: within the Chinese mainland;</li>
<li>overseas: global (excluding the Chinese mainland).</li>
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Fields(self):
        """List of predefined fields for delivery.
        :rtype: list of str
        """
        return self._Fields

    @Fields.setter
    def Fields(self, Fields):
        self._Fields = Fields

    @property
    def CustomFields(self):
        """The list of custom fields for log delivery, which supports extracting specified content from HTTP request headers, response headers, cookies, and request bodies. Custom field names must be unique. The number of custom fields cannot exceed a maximum of 200. A single real-time log delivery task can configure up to 5 custom fields of the request body type. Currently, only site acceleration logs (LogType=domain) support custom fields.
        :rtype: list of CustomField
        """
        return self._CustomFields

    @CustomFields.setter
    def CustomFields(self, CustomFields):
        self._CustomFields = CustomFields

    @property
    def DeliveryConditions(self):
        """Filter criteria of log delivery. If this parameter is not specified, all logs will be shipped.
        :rtype: list of DeliveryCondition
        """
        return self._DeliveryConditions

    @DeliveryConditions.setter
    def DeliveryConditions(self, DeliveryConditions):
        self._DeliveryConditions = DeliveryConditions

    @property
    def Sample(self):
        """Sampling ratio in permille. Value range: 1-1000. For example, 605 indicates a sampling ratio of 60.5%. If this parameter is not specified, the sampling ratio is 100%.
        :rtype: int
        """
        return self._Sample

    @Sample.setter
    def Sample(self, Sample):
        self._Sample = Sample

    @property
    def LogFormat(self):
        """Output format for log delivery. If this field is not specified, the default format is used, which works as follows:
<li>When TaskType is 'custom_endpoint', the default format is an array of JSON objects, with each JSON object representing a log entry;</li>
<li>When TaskType is 's3', the default format is JSON Lines;</li>Specifically, when TaskType is 'cls', the only allowed value for LogFormat.FormatType is 'json', and other parameters in LogFormat will be ignored. It is recommended not to transfer LogFormat.
        :rtype: :class:`tencentcloud.teo.v20220901.models.LogFormat`
        """
        return self._LogFormat

    @LogFormat.setter
    def LogFormat(self, LogFormat):
        self._LogFormat = LogFormat

    @property
    def CLS(self):
        """Configuration information of CLS. This parameter is required when TaskType is cls.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CLSTopic`
        """
        return self._CLS

    @CLS.setter
    def CLS(self, CLS):
        self._CLS = CLS

    @property
    def CustomEndpoint(self):
        """Configuration information of the custom HTTP service. This parameter is required when TaskType is custom_endpoint.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CustomEndpoint`
        """
        return self._CustomEndpoint

    @CustomEndpoint.setter
    def CustomEndpoint(self, CustomEndpoint):
        self._CustomEndpoint = CustomEndpoint

    @property
    def S3(self):
        """Configuration information of the AWS S3-compatible bucket. This parameter is required when TaskType is s3.
        :rtype: :class:`tencentcloud.teo.v20220901.models.S3`
        """
        return self._S3

    @S3.setter
    def S3(self, S3):
        self._S3 = S3


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TaskName = params.get("TaskName")
        self._TaskType = params.get("TaskType")
        self._EntityList = params.get("EntityList")
        self._LogType = params.get("LogType")
        self._Area = params.get("Area")
        self._Fields = params.get("Fields")
        if params.get("CustomFields") is not None:
            self._CustomFields = []
            for item in params.get("CustomFields"):
                obj = CustomField()
                obj._deserialize(item)
                self._CustomFields.append(obj)
        if params.get("DeliveryConditions") is not None:
            self._DeliveryConditions = []
            for item in params.get("DeliveryConditions"):
                obj = DeliveryCondition()
                obj._deserialize(item)
                self._DeliveryConditions.append(obj)
        self._Sample = params.get("Sample")
        if params.get("LogFormat") is not None:
            self._LogFormat = LogFormat()
            self._LogFormat._deserialize(params.get("LogFormat"))
        if params.get("CLS") is not None:
            self._CLS = CLSTopic()
            self._CLS._deserialize(params.get("CLS"))
        if params.get("CustomEndpoint") is not None:
            self._CustomEndpoint = CustomEndpoint()
            self._CustomEndpoint._deserialize(params.get("CustomEndpoint"))
        if params.get("S3") is not None:
            self._S3 = S3()
            self._S3._deserialize(params.get("S3"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRealtimeLogDeliveryTaskResponse(AbstractModel):
    """CreateRealtimeLogDeliveryTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the successfully created task.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """ID of the successfully created task.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateRuleRequest(AbstractModel):
    """CreateRule request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site
        :type ZoneId: str
        :param _RuleName: The rule name (1 to 255 characters)
        :type RuleName: str
        :param _Status: Rule status. Values:
<li>`enable`: Enabled</li>
<li>`disable`: Disabled</li>
        :type Status: str
        :param _Rules: The rule content.
        :type Rules: list of Rule
        :param _Tags: Tag of the rule.
        :type Tags: list of str
        """
        self._ZoneId = None
        self._RuleName = None
        self._Status = None
        self._Rules = None
        self._Tags = None

    @property
    def ZoneId(self):
        """ID of the site
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RuleName(self):
        """The rule name (1 to 255 characters)
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Status(self):
        """Rule status. Values:
<li>`enable`: Enabled</li>
<li>`disable`: Disabled</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Rules(self):
        """The rule content.
        :rtype: list of Rule
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def Tags(self):
        """Tag of the rule.
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RuleName = params.get("RuleName")
        self._Status = params.get("Status")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = Rule()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRuleResponse(AbstractModel):
    """CreateRule response structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: Rule ID
        :type RuleId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleId = None
        self._RequestId = None

    @property
    def RuleId(self):
        """Rule ID
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class CreateSecurityIPGroupRequest(AbstractModel):
    """CreateSecurityIPGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID.
        :type ZoneId: str
        :param _IPGroup: IP group information.
        :type IPGroup: :class:`tencentcloud.teo.v20220901.models.IPGroup`
        """
        self._ZoneId = None
        self._IPGroup = None

    @property
    def ZoneId(self):
        """Site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def IPGroup(self):
        """IP group information.
        :rtype: :class:`tencentcloud.teo.v20220901.models.IPGroup`
        """
        return self._IPGroup

    @IPGroup.setter
    def IPGroup(self, IPGroup):
        self._IPGroup = IPGroup


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("IPGroup") is not None:
            self._IPGroup = IPGroup()
            self._IPGroup._deserialize(params.get("IPGroup"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSecurityIPGroupResponse(AbstractModel):
    """CreateSecurityIPGroup response structure.

    """

    def __init__(self):
        r"""
        :param _GroupId: IP group ID.
        :type GroupId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GroupId = None
        self._RequestId = None

    @property
    def GroupId(self):
        """IP group ID.
        :rtype: int
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._RequestId = params.get("RequestId")


class CreateSharedCNAMERequest(AbstractModel):
    """CreateSharedCNAME request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site to which the shared CNAME belongs.	
        :type ZoneId: str
        :param _SharedCNAMEPrefix: Shared CNAME prefix. Enter a valid domain name prefix, such as "test-api" and "test-api.com". A maximum of 50 characters are allowed. 

Complete format of the shared CNAME: '<Custom prefix>+<A 12-character random string in ZoneId>+share.dnse[0-5].com'. 

For example, if the prefix is example.com, EdgeOne will create the shared CNAME: example.com.sai2ig51kaa5.share.dnse2.com.
        :type SharedCNAMEPrefix: str
        :param _Description: Description. It supports 1-50 characters.
        :type Description: str
        """
        self._ZoneId = None
        self._SharedCNAMEPrefix = None
        self._Description = None

    @property
    def ZoneId(self):
        """ID of the site to which the shared CNAME belongs.	
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def SharedCNAMEPrefix(self):
        """Shared CNAME prefix. Enter a valid domain name prefix, such as "test-api" and "test-api.com". A maximum of 50 characters are allowed. 

Complete format of the shared CNAME: '<Custom prefix>+<A 12-character random string in ZoneId>+share.dnse[0-5].com'. 

For example, if the prefix is example.com, EdgeOne will create the shared CNAME: example.com.sai2ig51kaa5.share.dnse2.com.
        :rtype: str
        """
        return self._SharedCNAMEPrefix

    @SharedCNAMEPrefix.setter
    def SharedCNAMEPrefix(self, SharedCNAMEPrefix):
        self._SharedCNAMEPrefix = SharedCNAMEPrefix

    @property
    def Description(self):
        """Description. It supports 1-50 characters.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._SharedCNAMEPrefix = params.get("SharedCNAMEPrefix")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSharedCNAMEResponse(AbstractModel):
    """CreateSharedCNAME response structure.

    """

    def __init__(self):
        r"""
        :param _SharedCNAME: Shared CNAME. Format: '<Custom prefix>+<A 12-character random string in ZoneId>+share.dnse[0-5].com'.
        :type SharedCNAME: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SharedCNAME = None
        self._RequestId = None

    @property
    def SharedCNAME(self):
        """Shared CNAME. Format: '<Custom prefix>+<A 12-character random string in ZoneId>+share.dnse[0-5].com'.
        :rtype: str
        """
        return self._SharedCNAME

    @SharedCNAME.setter
    def SharedCNAME(self, SharedCNAME):
        self._SharedCNAME = SharedCNAME

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SharedCNAME = params.get("SharedCNAME")
        self._RequestId = params.get("RequestId")


class CreateWebSecurityTemplateRequest(AbstractModel):
    """CreateWebSecurityTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID. Explicitly identifies the zone to which the policy template belongs for access control purposes.
        :type ZoneId: str
        :param _TemplateName: Policy template name. Composed of Chinese characters, letters, digits, and underscores. Cannot begin with an underscore and must be less than or equal to 32 characters.
        :type TemplateName: str
        :param _SecurityPolicy: Web security policy template configuration. Generates default config if empty. Supported: Exception rules, custom rules, rate limiting rules, managed rules. Not supported: Bot management rules (under development).
        :type SecurityPolicy: :class:`tencentcloud.teo.v20220901.models.SecurityPolicy`
        """
        self._ZoneId = None
        self._TemplateName = None
        self._SecurityPolicy = None

    @property
    def ZoneId(self):
        """Zone ID. Explicitly identifies the zone to which the policy template belongs for access control purposes.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TemplateName(self):
        """Policy template name. Composed of Chinese characters, letters, digits, and underscores. Cannot begin with an underscore and must be less than or equal to 32 characters.
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def SecurityPolicy(self):
        """Web security policy template configuration. Generates default config if empty. Supported: Exception rules, custom rules, rate limiting rules, managed rules. Not supported: Bot management rules (under development).
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityPolicy`
        """
        return self._SecurityPolicy

    @SecurityPolicy.setter
    def SecurityPolicy(self, SecurityPolicy):
        self._SecurityPolicy = SecurityPolicy


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TemplateName = params.get("TemplateName")
        if params.get("SecurityPolicy") is not None:
            self._SecurityPolicy = SecurityPolicy()
            self._SecurityPolicy._deserialize(params.get("SecurityPolicy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWebSecurityTemplateResponse(AbstractModel):
    """CreateWebSecurityTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _TemplateId: Policy template ID.
        :type TemplateId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TemplateId = None
        self._RequestId = None

    @property
    def TemplateId(self):
        """Policy template ID.
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._RequestId = params.get("RequestId")


class CreateZoneRequest(AbstractModel):
    """CreateZone request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Site access type. If this parameter is not input, the default value `partial` is used. Valid values of this parameter are as follows:
<li>partial: CNAME access;</li>
<li>full: NS access;</li>
<li>noDomainAccess: access with no domain name.</li>
<li>dnsPodAccess: DNSPod hosted access. To use this access mode, your domain name should have been hosted on DNSPod.</li>
        :type Type: str
        :param _ZoneName: Site name. For sites connected via CNAME/NS, pass in the secondary domain name (example.com). Leave it blank if the site is connected without a domain name. 
        :type ZoneName: str
        :param _Area: The acceleration area of the L7 domain name when `Type` is `partial` or `full`. When Type is `noDomainAccess`, please leave it blank.
<li>`global`: Global AZs</li>
<li>`mainland`: AZs in the Chinese mainland</li>
<li>`overseas`: (Default) AZs outside the Chinese mainland </li>
        :type Area: str
        :param _PlanId: ID of the plan to which you want to bind the site. If you don't have an EdgeOne plan, purchase one in the EdgeOne console.
        :type PlanId: str
        :param _AliasZoneName: The site alias. It allows up to 20 characters, including [0-9], [a-z], [A-Z] and [-_]. For details, see [Glossary](https://intl.cloud.tencent.com/document/product/1552/70202?from_cn_redirect=1). If you don't want to use it, just leave it blank.
        :type AliasZoneName: str
        :param _Tags: Tags of the site. To create tags, go to the [Tag Console](https://console.cloud.tencent.com/tag/taglist).
        :type Tags: list of Tag
        :param _AllowDuplicates: Whether to allow duplicate sites. Values:
<li>`true`: Duplicate sites are allowed.</li>
<li>`false`: Duplicate sites are not allowed.</li>If it is left empty, the default value `false` is used.
        :type AllowDuplicates: bool
        :param _JumpStart: Whether to skip scanning the existing DNS records of the site. Default value: false.
        :type JumpStart: bool
        """
        self._Type = None
        self._ZoneName = None
        self._Area = None
        self._PlanId = None
        self._AliasZoneName = None
        self._Tags = None
        self._AllowDuplicates = None
        self._JumpStart = None

    @property
    def Type(self):
        """Site access type. If this parameter is not input, the default value `partial` is used. Valid values of this parameter are as follows:
<li>partial: CNAME access;</li>
<li>full: NS access;</li>
<li>noDomainAccess: access with no domain name.</li>
<li>dnsPodAccess: DNSPod hosted access. To use this access mode, your domain name should have been hosted on DNSPod.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ZoneName(self):
        """Site name. For sites connected via CNAME/NS, pass in the secondary domain name (example.com). Leave it blank if the site is connected without a domain name. 
        :rtype: str
        """
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName

    @property
    def Area(self):
        """The acceleration area of the L7 domain name when `Type` is `partial` or `full`. When Type is `noDomainAccess`, please leave it blank.
<li>`global`: Global AZs</li>
<li>`mainland`: AZs in the Chinese mainland</li>
<li>`overseas`: (Default) AZs outside the Chinese mainland </li>
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def PlanId(self):
        """ID of the plan to which you want to bind the site. If you don't have an EdgeOne plan, purchase one in the EdgeOne console.
        :rtype: str
        """
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def AliasZoneName(self):
        """The site alias. It allows up to 20 characters, including [0-9], [a-z], [A-Z] and [-_]. For details, see [Glossary](https://intl.cloud.tencent.com/document/product/1552/70202?from_cn_redirect=1). If you don't want to use it, just leave it blank.
        :rtype: str
        """
        return self._AliasZoneName

    @AliasZoneName.setter
    def AliasZoneName(self, AliasZoneName):
        self._AliasZoneName = AliasZoneName

    @property
    def Tags(self):
        """Tags of the site. To create tags, go to the [Tag Console](https://console.cloud.tencent.com/tag/taglist).
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def AllowDuplicates(self):
        warnings.warn("parameter `AllowDuplicates` is deprecated", DeprecationWarning) 

        """Whether to allow duplicate sites. Values:
<li>`true`: Duplicate sites are allowed.</li>
<li>`false`: Duplicate sites are not allowed.</li>If it is left empty, the default value `false` is used.
        :rtype: bool
        """
        return self._AllowDuplicates

    @AllowDuplicates.setter
    def AllowDuplicates(self, AllowDuplicates):
        warnings.warn("parameter `AllowDuplicates` is deprecated", DeprecationWarning) 

        self._AllowDuplicates = AllowDuplicates

    @property
    def JumpStart(self):
        warnings.warn("parameter `JumpStart` is deprecated", DeprecationWarning) 

        """Whether to skip scanning the existing DNS records of the site. Default value: false.
        :rtype: bool
        """
        return self._JumpStart

    @JumpStart.setter
    def JumpStart(self, JumpStart):
        warnings.warn("parameter `JumpStart` is deprecated", DeprecationWarning) 

        self._JumpStart = JumpStart


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._ZoneName = params.get("ZoneName")
        self._Area = params.get("Area")
        self._PlanId = params.get("PlanId")
        self._AliasZoneName = params.get("AliasZoneName")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._AllowDuplicates = params.get("AllowDuplicates")
        self._JumpStart = params.get("JumpStart")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateZoneResponse(AbstractModel):
    """CreateZone response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID.
        :type ZoneId: str
        :param _OwnershipVerification: Site ownership verification information. After the site is created, you need to complete the ownership verification before the site can serve normally.

If `Type=partial`, add TXT records to your DNS provider or add files to the root DNS server, and then call [VerifyOwnership]() to complete verification. For more information, see [Ownership Verification](https://intl.cloud.tencent.com/document/product/1552/70789?from_cn_redirect=1).

If `Type = full`, switch the DNS server as instructed by [Modifying DNS Server](https://intl.cloud.tencent.com/document/product/1552/90452?from_cn_redirect=1). Then call [VerifyOwnership]() to check the result.

If `Type = noDomainAccess`, leave it blank. No action is required.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type OwnershipVerification: :class:`tencentcloud.teo.v20220901.models.OwnershipVerification`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneId = None
        self._OwnershipVerification = None
        self._RequestId = None

    @property
    def ZoneId(self):
        """Site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def OwnershipVerification(self):
        """Site ownership verification information. After the site is created, you need to complete the ownership verification before the site can serve normally.

If `Type=partial`, add TXT records to your DNS provider or add files to the root DNS server, and then call [VerifyOwnership]() to complete verification. For more information, see [Ownership Verification](https://intl.cloud.tencent.com/document/product/1552/70789?from_cn_redirect=1).

If `Type = full`, switch the DNS server as instructed by [Modifying DNS Server](https://intl.cloud.tencent.com/document/product/1552/90452?from_cn_redirect=1). Then call [VerifyOwnership]() to check the result.

If `Type = noDomainAccess`, leave it blank. No action is required.
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.OwnershipVerification`
        """
        return self._OwnershipVerification

    @OwnershipVerification.setter
    def OwnershipVerification(self, OwnershipVerification):
        self._OwnershipVerification = OwnershipVerification

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("OwnershipVerification") is not None:
            self._OwnershipVerification = OwnershipVerification()
            self._OwnershipVerification._deserialize(params.get("OwnershipVerification"))
        self._RequestId = params.get("RequestId")


class CurrentOriginACL(AbstractModel):
    """Currently effective origin ACLs.

    """

    def __init__(self):
        r"""
        :param _EntireAddresses: IP range details.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type EntireAddresses: :class:`tencentcloud.teo.v20220901.models.Addresses`
        :param _Version: Version number.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type Version: str
        :param _ActiveTime: Version effective time in UTC+8, following the date and time format of the ISO 8601 standard.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type ActiveTime: str
        :param _IsPlaned: This parameter is used to record whether "I've upgraded to the lastest verison" is completed before the origin ACLs version is effective. valid values:.
- true: specifies that the version is effective and the update to the latest version is confirmed.
- false: when the version takes effect, the confirmation of updating to the latest origin ACLs are not completed. The IP range is forcibly updated to the latest version in the backend. When this parameter returns false, please confirm in time whether your origin server firewall configuration has been updated to the latest version to avoid origin-pull failure.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type IsPlaned: str
        """
        self._EntireAddresses = None
        self._Version = None
        self._ActiveTime = None
        self._IsPlaned = None

    @property
    def EntireAddresses(self):
        """IP range details.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.Addresses`
        """
        return self._EntireAddresses

    @EntireAddresses.setter
    def EntireAddresses(self, EntireAddresses):
        self._EntireAddresses = EntireAddresses

    @property
    def Version(self):
        """Version number.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def ActiveTime(self):
        """Version effective time in UTC+8, following the date and time format of the ISO 8601 standard.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: str
        """
        return self._ActiveTime

    @ActiveTime.setter
    def ActiveTime(self, ActiveTime):
        self._ActiveTime = ActiveTime

    @property
    def IsPlaned(self):
        """This parameter is used to record whether "I've upgraded to the lastest verison" is completed before the origin ACLs version is effective. valid values:.
- true: specifies that the version is effective and the update to the latest version is confirmed.
- false: when the version takes effect, the confirmation of updating to the latest origin ACLs are not completed. The IP range is forcibly updated to the latest version in the backend. When this parameter returns false, please confirm in time whether your origin server firewall configuration has been updated to the latest version to avoid origin-pull failure.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: str
        """
        return self._IsPlaned

    @IsPlaned.setter
    def IsPlaned(self, IsPlaned):
        self._IsPlaned = IsPlaned


    def _deserialize(self, params):
        if params.get("EntireAddresses") is not None:
            self._EntireAddresses = Addresses()
            self._EntireAddresses._deserialize(params.get("EntireAddresses"))
        self._Version = params.get("Version")
        self._ActiveTime = params.get("ActiveTime")
        self._IsPlaned = params.get("IsPlaned")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomEndpoint(AbstractModel):
    """The configuration information of real-time log delivery to a custom HTTP(S) interface

    """

    def __init__(self):
        r"""
        :param _Url: Address of the custom HTTP API for real-time log shipping. Currently, only HTTP and HTTPS protocols are supported.
        :type Url: str
        :param _AccessId: Custom SecretId used for generating an encrypted signature. This parameter is required if the origin server needs authentication.
        :type AccessId: str
        :param _AccessKey: Custom SecretKey used for generating an encrypted signature. This parameter is required if the origin server needs authentication.
        :type AccessKey: str
        :param _CompressType: Type of data compression. Valid values:<li>gzip: gzip compression.</li>If this parameter is not input, compression is disabled.
        :type CompressType: str
        :param _Protocol: Type of the application layer protocol used in POST requests for log shipping. Valid values: 
<li>http: HTTP protocol;</li>
<li>https: HTTPS protocol.</li>If this parameter is not input, the protocol type is parsed from the URL field.	
        :type Protocol: str
        :param _Headers: Custom request header carried in log shipping. For a header carried by default in EdgeOne log pushing, such as Content-Type, the header value you input will overwrite the default value. The header value references a single variable ${batchSize} to obtain the number of log entries included in each POST request.
        :type Headers: list of Header
        """
        self._Url = None
        self._AccessId = None
        self._AccessKey = None
        self._CompressType = None
        self._Protocol = None
        self._Headers = None

    @property
    def Url(self):
        """Address of the custom HTTP API for real-time log shipping. Currently, only HTTP and HTTPS protocols are supported.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def AccessId(self):
        """Custom SecretId used for generating an encrypted signature. This parameter is required if the origin server needs authentication.
        :rtype: str
        """
        return self._AccessId

    @AccessId.setter
    def AccessId(self, AccessId):
        self._AccessId = AccessId

    @property
    def AccessKey(self):
        """Custom SecretKey used for generating an encrypted signature. This parameter is required if the origin server needs authentication.
        :rtype: str
        """
        return self._AccessKey

    @AccessKey.setter
    def AccessKey(self, AccessKey):
        self._AccessKey = AccessKey

    @property
    def CompressType(self):
        """Type of data compression. Valid values:<li>gzip: gzip compression.</li>If this parameter is not input, compression is disabled.
        :rtype: str
        """
        return self._CompressType

    @CompressType.setter
    def CompressType(self, CompressType):
        self._CompressType = CompressType

    @property
    def Protocol(self):
        """Type of the application layer protocol used in POST requests for log shipping. Valid values: 
<li>http: HTTP protocol;</li>
<li>https: HTTPS protocol.</li>If this parameter is not input, the protocol type is parsed from the URL field.	
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Headers(self):
        """Custom request header carried in log shipping. For a header carried by default in EdgeOne log pushing, such as Content-Type, the header value you input will overwrite the default value. The header value references a single variable ${batchSize} to obtain the number of log entries included in each POST request.
        :rtype: list of Header
        """
        return self._Headers

    @Headers.setter
    def Headers(self, Headers):
        self._Headers = Headers


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._AccessId = params.get("AccessId")
        self._AccessKey = params.get("AccessKey")
        self._CompressType = params.get("CompressType")
        self._Protocol = params.get("Protocol")
        if params.get("Headers") is not None:
            self._Headers = []
            for item in params.get("Headers"):
                obj = Header()
                obj._deserialize(item)
                self._Headers.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomErrorPage(AbstractModel):
    """Custom error code page structure.

    """

    def __init__(self):
        r"""
        :param _PageId: Custom error page ID.
        :type PageId: str
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Name: Custom error page name.
        :type Name: str
        :param _ContentType: Custom error page type.
        :type ContentType: str
        :param _Description: Custom error page description.
        :type Description: str
        :param _Content: Custom error page content.
        :type Content: str
        :param _References: Custom error page reference.
        :type References: list of ErrorPageReference
        """
        self._PageId = None
        self._ZoneId = None
        self._Name = None
        self._ContentType = None
        self._Description = None
        self._Content = None
        self._References = None

    @property
    def PageId(self):
        """Custom error page ID.
        :rtype: str
        """
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Name(self):
        """Custom error page name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ContentType(self):
        """Custom error page type.
        :rtype: str
        """
        return self._ContentType

    @ContentType.setter
    def ContentType(self, ContentType):
        self._ContentType = ContentType

    @property
    def Description(self):
        """Custom error page description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Content(self):
        """Custom error page content.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def References(self):
        """Custom error page reference.
        :rtype: list of ErrorPageReference
        """
        return self._References

    @References.setter
    def References(self, References):
        self._References = References


    def _deserialize(self, params):
        self._PageId = params.get("PageId")
        self._ZoneId = params.get("ZoneId")
        self._Name = params.get("Name")
        self._ContentType = params.get("ContentType")
        self._Description = params.get("Description")
        self._Content = params.get("Content")
        if params.get("References") is not None:
            self._References = []
            for item in params.get("References"):
                obj = ErrorPageReference()
                obj._deserialize(item)
                self._References.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomField(AbstractModel):
    """The custom log field in a real-time log delivery task.

    """

    def __init__(self):
        r"""
        :param _Name: Type of the custom log filed, which indicates extracting data from a specified position in HTTP requests and responses. Valid values:
<li>ReqHeader: Extract the value of a specified field from an HTTP request header;</li>
<li>RspHeader: Extract the value of a specified field from an HTTP response header;</li>
<li>Cookie: Extract the value of a specified field from a cookie;</li>
<li>ReqBody: Extract specified content from an HTTP request body using a Google RE2 regular expression.</li>
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type Name: str
        :param _Value: Enter the definition of the field value based on the field type (Name). This parameter is case-sensitive.
<li>When the field type is ReqHeader, RspHeader, or Cookie, enter the name of the parameter for which you need to extract the value, such as Accept-Language. You can enter 1-100 characters. The name should start with a letter, contain letters, digits, and hyphens (-) in the middle, and end with a letter or digit.</li>
<li>When the field type is ReqBody, enter the Google RE2 regular expression. The maximum length of the regular expression is 4 KB.</li>
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type Value: str
        :param _Enabled: Indicates whether to deliver this field. If not filled in, this field will not be delivered.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Enabled: bool
        """
        self._Name = None
        self._Value = None
        self._Enabled = None

    @property
    def Name(self):
        """Type of the custom log filed, which indicates extracting data from a specified position in HTTP requests and responses. Valid values:
<li>ReqHeader: Extract the value of a specified field from an HTTP request header;</li>
<li>RspHeader: Extract the value of a specified field from an HTTP response header;</li>
<li>Cookie: Extract the value of a specified field from a cookie;</li>
<li>ReqBody: Extract specified content from an HTTP request body using a Google RE2 regular expression.</li>
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        """Enter the definition of the field value based on the field type (Name). This parameter is case-sensitive.
<li>When the field type is ReqHeader, RspHeader, or Cookie, enter the name of the parameter for which you need to extract the value, such as Accept-Language. You can enter 1-100 characters. The name should start with a letter, contain letters, digits, and hyphens (-) in the middle, and end with a letter or digit.</li>
<li>When the field type is ReqBody, enter the Google RE2 regular expression. The maximum length of the regular expression is 4 KB.</li>
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Enabled(self):
        """Indicates whether to deliver this field. If not filled in, this field will not be delivered.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        self._Enabled = params.get("Enabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomRule(AbstractModel):
    """Custom rule configuration.

    """

    def __init__(self):
        r"""
        :param _Name: The custom rule name.
        :type Name: str
        :param _Condition: The specifics of the custom rule, must comply with the expression grammar, please refer to product documentation for details.
        :type Condition: str
        :param _Action: Action for custom rules. The Name parameter of SecurityAction supports: <li>`Deny`: block;</li> <li>`Monitor`: observe;</li> <li>`ReturnCustomPage`: block with customized page;</li> <li>`Redirect`: Redirect to URL;</li> <li>`BlockIP`: IP blocking;</li> <li>`JSChallenge`: JavaScript challenge;</li> <li>`ManagedChallenge`: managed challenge;</li> <li>`Allow`: Allow.</li>.
        :type Action: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        :param _Enabled: The custom rule status. Values: <li>`on`: enabled</li> <li>`off`: disabled</li>.
        :type Enabled: str
        :param _Id: Custom rule ID. <br>Different rule configuration operations are supported by rule ID : <br> - Add a new rule: ID is empty or the ID parameter is not specified; <br> - Modify an existing rule: specify the rule ID that needs to be updated/modified; <br> - Delete an existing rule: existing rules not included in the Rules parameter will be deleted.
        :type Id: str
        :param _RuleType: Type of custom rule. Values: <li>`BasicAccessRule`: basic access control;</li> <li>`PreciseMatchRule`: exact custom rule, default;</li> <li>`ManagedAccessRule`: expert customized rule, output parameter only.</li>The default value is PreciseMatchRule.
        :type RuleType: str
        :param _Priority: Customize the priority of custom rule. Range: 0-100, the default value is 0, this parameter only supports PreciseMatchRule.
        :type Priority: int
        """
        self._Name = None
        self._Condition = None
        self._Action = None
        self._Enabled = None
        self._Id = None
        self._RuleType = None
        self._Priority = None

    @property
    def Name(self):
        """The custom rule name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Condition(self):
        """The specifics of the custom rule, must comply with the expression grammar, please refer to product documentation for details.
        :rtype: str
        """
        return self._Condition

    @Condition.setter
    def Condition(self, Condition):
        self._Condition = Condition

    @property
    def Action(self):
        """Action for custom rules. The Name parameter of SecurityAction supports: <li>`Deny`: block;</li> <li>`Monitor`: observe;</li> <li>`ReturnCustomPage`: block with customized page;</li> <li>`Redirect`: Redirect to URL;</li> <li>`BlockIP`: IP blocking;</li> <li>`JSChallenge`: JavaScript challenge;</li> <li>`ManagedChallenge`: managed challenge;</li> <li>`Allow`: Allow.</li>.
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Enabled(self):
        """The custom rule status. Values: <li>`on`: enabled</li> <li>`off`: disabled</li>.
        :rtype: str
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def Id(self):
        """Custom rule ID. <br>Different rule configuration operations are supported by rule ID : <br> - Add a new rule: ID is empty or the ID parameter is not specified; <br> - Modify an existing rule: specify the rule ID that needs to be updated/modified; <br> - Delete an existing rule: existing rules not included in the Rules parameter will be deleted.
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RuleType(self):
        """Type of custom rule. Values: <li>`BasicAccessRule`: basic access control;</li> <li>`PreciseMatchRule`: exact custom rule, default;</li> <li>`ManagedAccessRule`: expert customized rule, output parameter only.</li>The default value is PreciseMatchRule.
        :rtype: str
        """
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType

    @property
    def Priority(self):
        """Customize the priority of custom rule. Range: 0-100, the default value is 0, this parameter only supports PreciseMatchRule.
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Condition = params.get("Condition")
        if params.get("Action") is not None:
            self._Action = SecurityAction()
            self._Action._deserialize(params.get("Action"))
        self._Enabled = params.get("Enabled")
        self._Id = params.get("Id")
        self._RuleType = params.get("RuleType")
        self._Priority = params.get("Priority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomRules(AbstractModel):
    """Custom rules configuration.

    """

    def __init__(self):
        r"""
        :param _Rules: The custom rule. <br>when modifying the Web protection configuration using ModifySecurityPolicy: <br> - if the Rules parameter is not specified or the parameter length of Rules is zero: clear all custom rule configurations. <br> - if the Rules parameter is not specified: keep the existing custom rule configuration without modification.
        :type Rules: list of CustomRule
        """
        self._Rules = None

    @property
    def Rules(self):
        """The custom rule. <br>when modifying the Web protection configuration using ModifySecurityPolicy: <br> - if the Rules parameter is not specified or the parameter length of Rules is zero: clear all custom rule configurations. <br> - if the Rules parameter is not specified: keep the existing custom rule configuration without modification.
        :rtype: list of CustomRule
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = CustomRule()
                obj._deserialize(item)
                self._Rules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomTime(AbstractModel):
    """Node cache TTL custom cache time parameter configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Custom cache time switch. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _IgnoreCacheControl: Ignore origin server cachecontrol switch. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li> note: this field is required when `switch` is on. when `switch` is off, this field is not required and will not take effect if filled.
        :type IgnoreCacheControl: str
        :param _CacheTime: Custom cache time value, unit: seconds. value range: 0-315360000.<br>note: this field is required when switch is on; when switch is off, this field is not required and will not take effect if filled.
        :type CacheTime: int
        """
        self._Switch = None
        self._IgnoreCacheControl = None
        self._CacheTime = None

    @property
    def Switch(self):
        """Custom cache time switch. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def IgnoreCacheControl(self):
        """Ignore origin server cachecontrol switch. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li> note: this field is required when `switch` is on. when `switch` is off, this field is not required and will not take effect if filled.
        :rtype: str
        """
        return self._IgnoreCacheControl

    @IgnoreCacheControl.setter
    def IgnoreCacheControl(self, IgnoreCacheControl):
        self._IgnoreCacheControl = IgnoreCacheControl

    @property
    def CacheTime(self):
        """Custom cache time value, unit: seconds. value range: 0-315360000.<br>note: this field is required when switch is on; when switch is off, this field is not required and will not take effect if filled.
        :rtype: int
        """
        return self._CacheTime

    @CacheTime.setter
    def CacheTime(self, CacheTime):
        self._CacheTime = CacheTime


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._IgnoreCacheControl = params.get("IgnoreCacheControl")
        self._CacheTime = params.get("CacheTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomizedHeader(AbstractModel):
    """Custom header that can be configured for HTTP/HTTPS health check policies under a LoadBalancer.

    """

    def __init__(self):
        r"""
        :param _Key: Custom header key.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type Key: str
        :param _Value: Custom header value.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        """Custom header key.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        """Custom header value.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DDoS(AbstractModel):
    """DDoS mitigation configuration

    """

    def __init__(self):
        r"""
        :param _Switch: Switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """Switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DDoSAttackEvent(AbstractModel):
    """Information of the DDoS attacker

    """

    def __init__(self):
        r"""
        :param _EventId: The event ID.
        :type EventId: str
        :param _AttackType: The attack type.
        :type AttackType: str
        :param _AttackStatus: The attack status.
        :type AttackStatus: int
        :param _AttackMaxBandWidth: The maximum attack bandwidth.
        :type AttackMaxBandWidth: int
        :param _AttackPacketMaxRate: The peak attack packet rate.
        :type AttackPacketMaxRate: int
        :param _AttackStartTime: The attack start time recorded in seconds.
        :type AttackStartTime: int
        :param _AttackEndTime: The attack end time recorded in seconds.
        :type AttackEndTime: int
        :param _PolicyId: The DDoS policy ID. 
Note: This field may return `null`, indicating that no valid value was found.
        :type PolicyId: int
        :param _ZoneId: The site ID. 
Note: This field may return `null`, indicating that no valid value was found.
        :type ZoneId: str
        :param _Area: Geolocation scope. Values: 
<li>`overseas`: Regions outside the Chinese mainland</li>
<li>`mainland`: Chinese mainland</li>
Note: This field may return `null`, indicating that no valid value was found.
        :type Area: str
        :param _DDoSBlockData: The blocking time of a DDoS attack. 
Note: This field may return `null`, indicating that no valid value was found.
        :type DDoSBlockData: list of DDoSBlockData
        """
        self._EventId = None
        self._AttackType = None
        self._AttackStatus = None
        self._AttackMaxBandWidth = None
        self._AttackPacketMaxRate = None
        self._AttackStartTime = None
        self._AttackEndTime = None
        self._PolicyId = None
        self._ZoneId = None
        self._Area = None
        self._DDoSBlockData = None

    @property
    def EventId(self):
        """The event ID.
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def AttackType(self):
        """The attack type.
        :rtype: str
        """
        return self._AttackType

    @AttackType.setter
    def AttackType(self, AttackType):
        self._AttackType = AttackType

    @property
    def AttackStatus(self):
        """The attack status.
        :rtype: int
        """
        return self._AttackStatus

    @AttackStatus.setter
    def AttackStatus(self, AttackStatus):
        self._AttackStatus = AttackStatus

    @property
    def AttackMaxBandWidth(self):
        """The maximum attack bandwidth.
        :rtype: int
        """
        return self._AttackMaxBandWidth

    @AttackMaxBandWidth.setter
    def AttackMaxBandWidth(self, AttackMaxBandWidth):
        self._AttackMaxBandWidth = AttackMaxBandWidth

    @property
    def AttackPacketMaxRate(self):
        """The peak attack packet rate.
        :rtype: int
        """
        return self._AttackPacketMaxRate

    @AttackPacketMaxRate.setter
    def AttackPacketMaxRate(self, AttackPacketMaxRate):
        self._AttackPacketMaxRate = AttackPacketMaxRate

    @property
    def AttackStartTime(self):
        """The attack start time recorded in seconds.
        :rtype: int
        """
        return self._AttackStartTime

    @AttackStartTime.setter
    def AttackStartTime(self, AttackStartTime):
        self._AttackStartTime = AttackStartTime

    @property
    def AttackEndTime(self):
        """The attack end time recorded in seconds.
        :rtype: int
        """
        return self._AttackEndTime

    @AttackEndTime.setter
    def AttackEndTime(self, AttackEndTime):
        self._AttackEndTime = AttackEndTime

    @property
    def PolicyId(self):
        """The DDoS policy ID. 
Note: This field may return `null`, indicating that no valid value was found.
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def ZoneId(self):
        """The site ID. 
Note: This field may return `null`, indicating that no valid value was found.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Area(self):
        """Geolocation scope. Values: 
<li>`overseas`: Regions outside the Chinese mainland</li>
<li>`mainland`: Chinese mainland</li>
Note: This field may return `null`, indicating that no valid value was found.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def DDoSBlockData(self):
        """The blocking time of a DDoS attack. 
Note: This field may return `null`, indicating that no valid value was found.
        :rtype: list of DDoSBlockData
        """
        return self._DDoSBlockData

    @DDoSBlockData.setter
    def DDoSBlockData(self, DDoSBlockData):
        self._DDoSBlockData = DDoSBlockData


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._AttackType = params.get("AttackType")
        self._AttackStatus = params.get("AttackStatus")
        self._AttackMaxBandWidth = params.get("AttackMaxBandWidth")
        self._AttackPacketMaxRate = params.get("AttackPacketMaxRate")
        self._AttackStartTime = params.get("AttackStartTime")
        self._AttackEndTime = params.get("AttackEndTime")
        self._PolicyId = params.get("PolicyId")
        self._ZoneId = params.get("ZoneId")
        self._Area = params.get("Area")
        if params.get("DDoSBlockData") is not None:
            self._DDoSBlockData = []
            for item in params.get("DDoSBlockData"):
                obj = DDoSBlockData()
                obj._deserialize(item)
                self._DDoSBlockData.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DDoSBlockData(AbstractModel):
    """DDoS blocking details

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time recorded in UNIX timestamp.
        :type StartTime: int
        :param _EndTime: The end time recorded in UNIX timestamp. `0` indicates the blocking is ongoing.
        :type EndTime: int
        :param _BlockArea: The regions blocked.
        :type BlockArea: str
        """
        self._StartTime = None
        self._EndTime = None
        self._BlockArea = None

    @property
    def StartTime(self):
        """The start time recorded in UNIX timestamp.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time recorded in UNIX timestamp. `0` indicates the blocking is ongoing.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def BlockArea(self):
        """The regions blocked.
        :rtype: str
        """
        return self._BlockArea

    @BlockArea.setter
    def BlockArea(self, BlockArea):
        self._BlockArea = BlockArea


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._BlockArea = params.get("BlockArea")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DDosProtectionConfig(AbstractModel):
    """Exclusive DDoS protection specifications configuration applicable to Layer 4 proxy or web site service.

    """

    def __init__(self):
        r"""
        :param _LevelMainland: Dedicated anti-DDoS specifications in the Chinese mainland. For details, refer to [Dedicated Anti-DDoS Related Fees](https://intl.cloud.tencent.com/document/product/1552/94162?from_cn_redirect=1).
<li>PLATFORM: uses the default protection. Dedicated anti-DDoS is not enabled;</li>
<li>BASE30_MAX300: uses dedicated anti-DDoS, which provides 30 Gbps guaranteed protection bandwidth and up to 300 Gbps elastic protection bandwidth;</li>
<li>BASE60_MAX600: uses dedicated anti-DDoS, which provides 60 Gbps guaranteed protection bandwidth and up to 600 Gbps elastic protection bandwidth. </li>If this field is not specified, the default value 'PLATFORM' will be used.
        :type LevelMainland: str
        :param _MaxBandwidthMainland: Configuration of elastic protection bandwidth for exclusive DDoS protection in the Chinese mainland.Valid only when exclusive DDoS protection in the Chinese mainland is enabled (refer to the LevelMainland parameter configuration), and the value has the following limitations:<li>When exclusive DDoS protection is enabled in the Chinese mainland and the 30 Gbps baseline protection bandwidth is used (the LevelMainland parameter value is BASE30_MAX300): the value range is 30 to 300 in Gbps;</li><li>When exclusive DDoS protection is enabled in the Chinese mainland and the 60 Gbps baseline protection bandwidth is used (the LevelMainland parameter value is BASE60_MAX600): the value range is 60 to 600 in Gbps;</li><li>When the default protection of the platform is used (the LevelMainland parameter value is PLATFORM): configuration is not supported, and the value of this parameter is invalid.</li>
        :type MaxBandwidthMainland: int
        :param _LevelOverseas: Dedicated anti-DDoS specifications in global regions (excluding the Chinese mainland).
<li>PLATFORM: uses the default protection. Dedicated anti-DDoS is not enabled;</li>
<li>ANYCAST300: uses dedicated anti-DDoS, which provides 300 Gbps protection bandwidth;</li>
<li>ANYCAST_ALLIN: uses dedicated anti-DDoS, which provides all available protection resources. </li>If this field is not specified, the default value 'PLATFORM' will be used.
        :type LevelOverseas: str
        """
        self._LevelMainland = None
        self._MaxBandwidthMainland = None
        self._LevelOverseas = None

    @property
    def LevelMainland(self):
        """Dedicated anti-DDoS specifications in the Chinese mainland. For details, refer to [Dedicated Anti-DDoS Related Fees](https://intl.cloud.tencent.com/document/product/1552/94162?from_cn_redirect=1).
<li>PLATFORM: uses the default protection. Dedicated anti-DDoS is not enabled;</li>
<li>BASE30_MAX300: uses dedicated anti-DDoS, which provides 30 Gbps guaranteed protection bandwidth and up to 300 Gbps elastic protection bandwidth;</li>
<li>BASE60_MAX600: uses dedicated anti-DDoS, which provides 60 Gbps guaranteed protection bandwidth and up to 600 Gbps elastic protection bandwidth. </li>If this field is not specified, the default value 'PLATFORM' will be used.
        :rtype: str
        """
        return self._LevelMainland

    @LevelMainland.setter
    def LevelMainland(self, LevelMainland):
        self._LevelMainland = LevelMainland

    @property
    def MaxBandwidthMainland(self):
        """Configuration of elastic protection bandwidth for exclusive DDoS protection in the Chinese mainland.Valid only when exclusive DDoS protection in the Chinese mainland is enabled (refer to the LevelMainland parameter configuration), and the value has the following limitations:<li>When exclusive DDoS protection is enabled in the Chinese mainland and the 30 Gbps baseline protection bandwidth is used (the LevelMainland parameter value is BASE30_MAX300): the value range is 30 to 300 in Gbps;</li><li>When exclusive DDoS protection is enabled in the Chinese mainland and the 60 Gbps baseline protection bandwidth is used (the LevelMainland parameter value is BASE60_MAX600): the value range is 60 to 600 in Gbps;</li><li>When the default protection of the platform is used (the LevelMainland parameter value is PLATFORM): configuration is not supported, and the value of this parameter is invalid.</li>
        :rtype: int
        """
        return self._MaxBandwidthMainland

    @MaxBandwidthMainland.setter
    def MaxBandwidthMainland(self, MaxBandwidthMainland):
        self._MaxBandwidthMainland = MaxBandwidthMainland

    @property
    def LevelOverseas(self):
        """Dedicated anti-DDoS specifications in global regions (excluding the Chinese mainland).
<li>PLATFORM: uses the default protection. Dedicated anti-DDoS is not enabled;</li>
<li>ANYCAST300: uses dedicated anti-DDoS, which provides 300 Gbps protection bandwidth;</li>
<li>ANYCAST_ALLIN: uses dedicated anti-DDoS, which provides all available protection resources. </li>If this field is not specified, the default value 'PLATFORM' will be used.
        :rtype: str
        """
        return self._LevelOverseas

    @LevelOverseas.setter
    def LevelOverseas(self, LevelOverseas):
        self._LevelOverseas = LevelOverseas


    def _deserialize(self, params):
        self._LevelMainland = params.get("LevelMainland")
        self._MaxBandwidthMainland = params.get("MaxBandwidthMainland")
        self._LevelOverseas = params.get("LevelOverseas")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DefaultServerCertInfo(AbstractModel):
    """HTTPS server certificate configuration

    """

    def __init__(self):
        r"""
        :param _CertId: ID of the server certificate.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CertId: str
        :param _Alias: Alias of the certificate.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Alias: str
        :param _Type: Type of the certificate. Values:
<li>`default`: Default certificate;</li>
<li>`upload`: Custom certificate;</li>
<li>`managed`: Tencent Cloud-managed certificate.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _ExpireTime: Time when the certificate expires.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpireTime: str
        :param _EffectiveTime: Time when the certificate takes effect.
Note: This field may return null, indicating that no valid values can be obtained.
        :type EffectiveTime: str
        :param _CommonName: Common name of the certificate.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CommonName: str
        :param _SubjectAltName: Domain names added to the SAN certificate.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubjectAltName: list of str
        :param _Status: Deployment status. Values:
<li>`processing`: Deployment in progress</li>
<li>`deployed`: Deployed</li>
<li>`failed`: Deployment failed</li>
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type Status: str
        :param _Message: Failure description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _SignAlgo: Certificate algorithm.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type SignAlgo: str
        """
        self._CertId = None
        self._Alias = None
        self._Type = None
        self._ExpireTime = None
        self._EffectiveTime = None
        self._CommonName = None
        self._SubjectAltName = None
        self._Status = None
        self._Message = None
        self._SignAlgo = None

    @property
    def CertId(self):
        """ID of the server certificate.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def Alias(self):
        """Alias of the certificate.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def Type(self):
        """Type of the certificate. Values:
<li>`default`: Default certificate;</li>
<li>`upload`: Custom certificate;</li>
<li>`managed`: Tencent Cloud-managed certificate.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ExpireTime(self):
        """Time when the certificate expires.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def EffectiveTime(self):
        """Time when the certificate takes effect.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._EffectiveTime

    @EffectiveTime.setter
    def EffectiveTime(self, EffectiveTime):
        self._EffectiveTime = EffectiveTime

    @property
    def CommonName(self):
        """Common name of the certificate.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CommonName

    @CommonName.setter
    def CommonName(self, CommonName):
        self._CommonName = CommonName

    @property
    def SubjectAltName(self):
        """Domain names added to the SAN certificate.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SubjectAltName

    @SubjectAltName.setter
    def SubjectAltName(self, SubjectAltName):
        self._SubjectAltName = SubjectAltName

    @property
    def Status(self):
        """Deployment status. Values:
<li>`processing`: Deployment in progress</li>
<li>`deployed`: Deployed</li>
<li>`failed`: Deployment failed</li>
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Message(self):
        """Failure description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def SignAlgo(self):
        """Certificate algorithm.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._SignAlgo

    @SignAlgo.setter
    def SignAlgo(self, SignAlgo):
        self._SignAlgo = SignAlgo


    def _deserialize(self, params):
        self._CertId = params.get("CertId")
        self._Alias = params.get("Alias")
        self._Type = params.get("Type")
        self._ExpireTime = params.get("ExpireTime")
        self._EffectiveTime = params.get("EffectiveTime")
        self._CommonName = params.get("CommonName")
        self._SubjectAltName = params.get("SubjectAltName")
        self._Status = params.get("Status")
        self._Message = params.get("Message")
        self._SignAlgo = params.get("SignAlgo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAccelerationDomainsRequest(AbstractModel):
    """DeleteAccelerationDomains request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site related with the accelerated domain name.
        :type ZoneId: str
        :param _DomainNames: List of accelerated domain names to be deleted.
        :type DomainNames: list of str
        :param _Force: Whether to forcibly delete a domain name if it is associated with resources (such as alias domain names and traffic scheduling policies). 
<li>`true`: Delete the domain name and all associated resources.</li>
<li>`false`: Do not delete the domain name and all associated resources.</li>If it’s not specified, the default value `false` is used.
        :type Force: bool
        """
        self._ZoneId = None
        self._DomainNames = None
        self._Force = None

    @property
    def ZoneId(self):
        """ID of the site related with the accelerated domain name.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def DomainNames(self):
        """List of accelerated domain names to be deleted.
        :rtype: list of str
        """
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames

    @property
    def Force(self):
        """Whether to forcibly delete a domain name if it is associated with resources (such as alias domain names and traffic scheduling policies). 
<li>`true`: Delete the domain name and all associated resources.</li>
<li>`false`: Do not delete the domain name and all associated resources.</li>If it’s not specified, the default value `false` is used.
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._DomainNames = params.get("DomainNames")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAccelerationDomainsResponse(AbstractModel):
    """DeleteAccelerationDomains response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAliasDomainRequest(AbstractModel):
    """DeleteAliasDomain request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        :param _AliasNames: The alias domain name to be deleted. If it is left empty, the delete operation is not performed.
        :type AliasNames: list of str
        """
        self._ZoneId = None
        self._AliasNames = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def AliasNames(self):
        """The alias domain name to be deleted. If it is left empty, the delete operation is not performed.
        :rtype: list of str
        """
        return self._AliasNames

    @AliasNames.setter
    def AliasNames(self, AliasNames):
        self._AliasNames = AliasNames


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._AliasNames = params.get("AliasNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAliasDomainResponse(AbstractModel):
    """DeleteAliasDomain response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteApplicationProxyRequest(AbstractModel):
    """DeleteApplicationProxy request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        :param _ProxyId: The proxy ID.
        :type ProxyId: str
        """
        self._ZoneId = None
        self._ProxyId = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ProxyId(self):
        """The proxy ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ProxyId = params.get("ProxyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteApplicationProxyResponse(AbstractModel):
    """DeleteApplicationProxy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteApplicationProxyRuleRequest(AbstractModel):
    """DeleteApplicationProxyRule request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        :param _ProxyId: The proxy ID.
        :type ProxyId: str
        :param _RuleId: The rule ID.
        :type RuleId: str
        """
        self._ZoneId = None
        self._ProxyId = None
        self._RuleId = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ProxyId(self):
        """The proxy ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId

    @property
    def RuleId(self):
        """The rule ID.
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ProxyId = params.get("ProxyId")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteApplicationProxyRuleResponse(AbstractModel):
    """DeleteApplicationProxyRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteContentIdentifierRequest(AbstractModel):
    """DeleteContentIdentifier request structure.

    """

    def __init__(self):
        r"""
        :param _ContentId: Content identifier id.
        :type ContentId: str
        """
        self._ContentId = None

    @property
    def ContentId(self):
        """Content identifier id.
        :rtype: str
        """
        return self._ContentId

    @ContentId.setter
    def ContentId(self, ContentId):
        self._ContentId = ContentId


    def _deserialize(self, params):
        self._ContentId = params.get("ContentId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteContentIdentifierResponse(AbstractModel):
    """DeleteContentIdentifier response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCustomErrorPageRequest(AbstractModel):
    """DeleteCustomErrorPage request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _PageId: Custom page ID.
        :type PageId: str
        """
        self._ZoneId = None
        self._PageId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def PageId(self):
        """Custom page ID.
        :rtype: str
        """
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._PageId = params.get("PageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomErrorPageResponse(AbstractModel):
    """DeleteCustomErrorPage response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDnsRecordsRequest(AbstractModel):
    """DeleteDnsRecords request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone id.
        :type ZoneId: str
        :param _RecordIds: List of dns record ids to be deleted, upper limit: 1000.
        :type RecordIds: list of str
        """
        self._ZoneId = None
        self._RecordIds = None

    @property
    def ZoneId(self):
        """Zone id.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RecordIds(self):
        """List of dns record ids to be deleted, upper limit: 1000.
        :rtype: list of str
        """
        return self._RecordIds

    @RecordIds.setter
    def RecordIds(self, RecordIds):
        self._RecordIds = RecordIds


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RecordIds = params.get("RecordIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDnsRecordsResponse(AbstractModel):
    """DeleteDnsRecords response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteFunctionRequest(AbstractModel):
    """DeleteFunction request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _FunctionId: Function ID.
        :type FunctionId: str
        """
        self._ZoneId = None
        self._FunctionId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def FunctionId(self):
        """Function ID.
        :rtype: str
        """
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._FunctionId = params.get("FunctionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFunctionResponse(AbstractModel):
    """DeleteFunction response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteFunctionRulesRequest(AbstractModel):
    """DeleteFunctionRules request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _RuleIds: Rule ID list.
        :type RuleIds: list of str
        """
        self._ZoneId = None
        self._RuleIds = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RuleIds(self):
        """Rule ID list.
        :rtype: list of str
        """
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RuleIds = params.get("RuleIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFunctionRulesResponse(AbstractModel):
    """DeleteFunctionRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteL4ProxyRequest(AbstractModel):
    """DeleteL4Proxy request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _ProxyId: Layer 4 proxy instance ID.
        :type ProxyId: str
        """
        self._ZoneId = None
        self._ProxyId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ProxyId(self):
        """Layer 4 proxy instance ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ProxyId = params.get("ProxyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteL4ProxyResponse(AbstractModel):
    """DeleteL4Proxy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteL4ProxyRulesRequest(AbstractModel):
    """DeleteL4ProxyRules request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _ProxyId: Layer 4 proxy instance ID.
        :type ProxyId: str
        :param _RuleIds: List of forwarding rule IDs. It supports up to 200 forwarding rules at a time.
        :type RuleIds: list of str
        """
        self._ZoneId = None
        self._ProxyId = None
        self._RuleIds = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ProxyId(self):
        """Layer 4 proxy instance ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId

    @property
    def RuleIds(self):
        """List of forwarding rule IDs. It supports up to 200 forwarding rules at a time.
        :rtype: list of str
        """
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ProxyId = params.get("ProxyId")
        self._RuleIds = params.get("RuleIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteL4ProxyRulesResponse(AbstractModel):
    """DeleteL4ProxyRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteL7AccRulesRequest(AbstractModel):
    """DeleteL7AccRules request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone id.
        :type ZoneId: str
        :param _RuleIds: List of rule ids to be deleted. you can obtain ruleid through describel7accrules.
        :type RuleIds: list of str
        """
        self._ZoneId = None
        self._RuleIds = None

    @property
    def ZoneId(self):
        """Zone id.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RuleIds(self):
        """List of rule ids to be deleted. you can obtain ruleid through describel7accrules.
        :rtype: list of str
        """
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RuleIds = params.get("RuleIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteL7AccRulesResponse(AbstractModel):
    """DeleteL7AccRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLoadBalancerRequest(AbstractModel):
    """DeleteLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _InstanceId: CLB instance ID.
        :type InstanceId: str
        """
        self._ZoneId = None
        self._InstanceId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def InstanceId(self):
        """CLB instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLoadBalancerResponse(AbstractModel):
    """DeleteLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOriginGroupRequest(AbstractModel):
    """DeleteOriginGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _GroupId: Origin server group ID. This parameter is required.
        :type GroupId: str
        """
        self._ZoneId = None
        self._GroupId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        """Origin server group ID. This parameter is required.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOriginGroupResponse(AbstractModel):
    """DeleteOriginGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRealtimeLogDeliveryTaskRequest(AbstractModel):
    """DeleteRealtimeLogDeliveryTask request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _TaskId: The ID of the real-time log delivery task.
        :type TaskId: str
        """
        self._ZoneId = None
        self._TaskId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TaskId(self):
        """The ID of the real-time log delivery task.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRealtimeLogDeliveryTaskResponse(AbstractModel):
    """DeleteRealtimeLogDeliveryTask response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRulesRequest(AbstractModel):
    """DeleteRules request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site
        :type ZoneId: str
        :param _RuleIds: IDs of the rules to be deleted.
        :type RuleIds: list of str
        """
        self._ZoneId = None
        self._RuleIds = None

    @property
    def ZoneId(self):
        """ID of the site
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RuleIds(self):
        """IDs of the rules to be deleted.
        :rtype: list of str
        """
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RuleIds = params.get("RuleIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRulesResponse(AbstractModel):
    """DeleteRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSecurityIPGroupRequest(AbstractModel):
    """DeleteSecurityIPGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID.
        :type ZoneId: str
        :param _GroupId: IP group ID.
        :type GroupId: int
        """
        self._ZoneId = None
        self._GroupId = None

    @property
    def ZoneId(self):
        """Site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        """IP group ID.
        :rtype: int
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSecurityIPGroupResponse(AbstractModel):
    """DeleteSecurityIPGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSharedCNAMERequest(AbstractModel):
    """DeleteSharedCNAME request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site to which the shared CNAME belongs.
        :type ZoneId: str
        :param _SharedCNAME: The shared CNAME to be deleted
        :type SharedCNAME: str
        """
        self._ZoneId = None
        self._SharedCNAME = None

    @property
    def ZoneId(self):
        """ID of the site to which the shared CNAME belongs.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def SharedCNAME(self):
        """The shared CNAME to be deleted
        :rtype: str
        """
        return self._SharedCNAME

    @SharedCNAME.setter
    def SharedCNAME(self, SharedCNAME):
        self._SharedCNAME = SharedCNAME


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._SharedCNAME = params.get("SharedCNAME")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSharedCNAMEResponse(AbstractModel):
    """DeleteSharedCNAME response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWebSecurityTemplateRequest(AbstractModel):
    """DeleteWebSecurityTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID. The zone to which the target policy template belongs for access control. Use the DescribeWebSecurityTemplates interface to query the zone of the policy template.
        :type ZoneId: str
        :param _TemplateId: Policy template ID.
        :type TemplateId: str
        """
        self._ZoneId = None
        self._TemplateId = None

    @property
    def ZoneId(self):
        """Zone ID. The zone to which the target policy template belongs for access control. Use the DescribeWebSecurityTemplates interface to query the zone of the policy template.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TemplateId(self):
        """Policy template ID.
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWebSecurityTemplateResponse(AbstractModel):
    """DeleteWebSecurityTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteZoneRequest(AbstractModel):
    """DeleteZone request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteZoneResponse(AbstractModel):
    """DeleteZone response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeliveryCondition(AbstractModel):
    """Real-time log delivery conditions used to define the scope of log delivery. The relationship between items in a DeliveryCondition array is "or", whereas the relationship between items in an inner Conditions array is "and".

    """

    def __init__(self):
        r"""
        :param _Conditions: Log filter criteria. The detailed filter criteria are as follows:
<li>EdgeResponseStatusCode: Filter by response status code returned from the EdgeOne node to the client.<br>?? Supported operators: equal, great, less, great_equal, less_equal<br>?? Valid values: any integer greater than or equal to 0</li>
<li>OriginResponseStatusCode: Filter by response status code of the origin server.<br>?? Supported operators: equal, great, less, great_equal, less_equal.<br>?? Valid values: any integer greater than or equal to -1</li>
<li>SecurityAction: Filter by final action after the request matches a security rule.<br>?? Supported operator: equal<br>?? Options:<br>?? -: unknown/not matched<br>?? Monitor: observation<br>?? JSChallenge: JavaScript challenge<br>?? Deny: blocking<br>?? Allow: allowing<br>?? BlockIP: IP blocking<br>?? Redirect: redirection<br>?? ReturnCustomPage: returning to a custom page<br>?? ManagedChallenge: managed challenge<br>?? Silence: silence<br>?? LongDelay: response after a long delay<br>?? ShortDelay: response after a short delay</li>
<li>SecurityModule: Filter by name of the security module finally handling the request.<br>??Supported operator: equal<br>??Options:<br>?? -: unknown/not matched<br>?? CustomRule: Custom Rules in Web Protection<br>?? RateLimitingCustomRule: Rate Limiting Rules in Web Protection<br>?? ManagedRule: Managed Rules in Web Protection<br>?? L7DDoS: CC Attack Defense in Web Protection<br>?? BotManagement: Bot Basic Management in Bot Management<br>?? BotClientReputation: Client Reputation Analysis in Bot Management<br>?? BotBehaviorAnalysis: Bot Intelligent Analysis in Bot Management<br>?? BotCustomRule: Custom Bot Rules in Bot Management<br>?? BotActiveDetection: Active Detection in Bot Management</li>
        :type Conditions: list of QueryCondition
        """
        self._Conditions = None

    @property
    def Conditions(self):
        """Log filter criteria. The detailed filter criteria are as follows:
<li>EdgeResponseStatusCode: Filter by response status code returned from the EdgeOne node to the client.<br>?? Supported operators: equal, great, less, great_equal, less_equal<br>?? Valid values: any integer greater than or equal to 0</li>
<li>OriginResponseStatusCode: Filter by response status code of the origin server.<br>?? Supported operators: equal, great, less, great_equal, less_equal.<br>?? Valid values: any integer greater than or equal to -1</li>
<li>SecurityAction: Filter by final action after the request matches a security rule.<br>?? Supported operator: equal<br>?? Options:<br>?? -: unknown/not matched<br>?? Monitor: observation<br>?? JSChallenge: JavaScript challenge<br>?? Deny: blocking<br>?? Allow: allowing<br>?? BlockIP: IP blocking<br>?? Redirect: redirection<br>?? ReturnCustomPage: returning to a custom page<br>?? ManagedChallenge: managed challenge<br>?? Silence: silence<br>?? LongDelay: response after a long delay<br>?? ShortDelay: response after a short delay</li>
<li>SecurityModule: Filter by name of the security module finally handling the request.<br>??Supported operator: equal<br>??Options:<br>?? -: unknown/not matched<br>?? CustomRule: Custom Rules in Web Protection<br>?? RateLimitingCustomRule: Rate Limiting Rules in Web Protection<br>?? ManagedRule: Managed Rules in Web Protection<br>?? L7DDoS: CC Attack Defense in Web Protection<br>?? BotManagement: Bot Basic Management in Bot Management<br>?? BotClientReputation: Client Reputation Analysis in Bot Management<br>?? BotBehaviorAnalysis: Bot Intelligent Analysis in Bot Management<br>?? BotCustomRule: Custom Bot Rules in Bot Management<br>?? BotActiveDetection: Active Detection in Bot Management</li>
        :rtype: list of QueryCondition
        """
        return self._Conditions

    @Conditions.setter
    def Conditions(self, Conditions):
        self._Conditions = Conditions


    def _deserialize(self, params):
        if params.get("Conditions") is not None:
            self._Conditions = []
            for item in params.get("Conditions"):
                obj = QueryCondition()
                obj._deserialize(item)
                self._Conditions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DenyActionParameters(AbstractModel):
    """Safe execution action specifies additional parameters for the ban.

    """

    def __init__(self):
        r"""
        :param _BlockIp: Specifies whether to extend the ban on the source IP. valid values.
<li>`on`: Enable;</li>

<li>off: Disable.</li>

After enabled, continuously blocks client ips that trigger the rule. when this option is enabled, the BlockIpDuration parameter must be simultaneously designated.
Note: this option cannot intersect with ReturnCustomPage or Stall.
        :type BlockIp: str
        :param _BlockIpDuration: The ban duration when BlockIP is on.
        :type BlockIpDuration: str
        :param _ReturnCustomPage: Specifies whether to use a custom page. valid values:.
<li>`on`: Enable;</li>

<li>off: Disable.</li>

Enabled, use custom page content to intercept requests. when this option is enabled, ResponseCode and ErrorPageId parameters must be specified simultaneously.
Note: this option cannot intersect with the BlockIp or Stall option.

        :type ReturnCustomPage: str
        :param _ResponseCode: Status code of the custom page.
        :type ResponseCode: str
        :param _ErrorPageId: Specifies the page id of the custom page.
        :type ErrorPageId: str
        :param _Stall: Specifies whether to suspend the request source without processing. valid values:.
<li>`on`: Enable;</li>

<li>off: Disable.</li>

Enabled, no longer responds to requests in the current connection session and does not actively disconnect. used for crawler combat to consume client connection resources.
Note: this option cannot intersect with BlockIp or ReturnCustomPage options.
        :type Stall: str
        """
        self._BlockIp = None
        self._BlockIpDuration = None
        self._ReturnCustomPage = None
        self._ResponseCode = None
        self._ErrorPageId = None
        self._Stall = None

    @property
    def BlockIp(self):
        """Specifies whether to extend the ban on the source IP. valid values.
<li>`on`: Enable;</li>

<li>off: Disable.</li>

After enabled, continuously blocks client ips that trigger the rule. when this option is enabled, the BlockIpDuration parameter must be simultaneously designated.
Note: this option cannot intersect with ReturnCustomPage or Stall.
        :rtype: str
        """
        return self._BlockIp

    @BlockIp.setter
    def BlockIp(self, BlockIp):
        self._BlockIp = BlockIp

    @property
    def BlockIpDuration(self):
        """The ban duration when BlockIP is on.
        :rtype: str
        """
        return self._BlockIpDuration

    @BlockIpDuration.setter
    def BlockIpDuration(self, BlockIpDuration):
        self._BlockIpDuration = BlockIpDuration

    @property
    def ReturnCustomPage(self):
        """Specifies whether to use a custom page. valid values:.
<li>`on`: Enable;</li>

<li>off: Disable.</li>

Enabled, use custom page content to intercept requests. when this option is enabled, ResponseCode and ErrorPageId parameters must be specified simultaneously.
Note: this option cannot intersect with the BlockIp or Stall option.

        :rtype: str
        """
        return self._ReturnCustomPage

    @ReturnCustomPage.setter
    def ReturnCustomPage(self, ReturnCustomPage):
        self._ReturnCustomPage = ReturnCustomPage

    @property
    def ResponseCode(self):
        """Status code of the custom page.
        :rtype: str
        """
        return self._ResponseCode

    @ResponseCode.setter
    def ResponseCode(self, ResponseCode):
        self._ResponseCode = ResponseCode

    @property
    def ErrorPageId(self):
        """Specifies the page id of the custom page.
        :rtype: str
        """
        return self._ErrorPageId

    @ErrorPageId.setter
    def ErrorPageId(self, ErrorPageId):
        self._ErrorPageId = ErrorPageId

    @property
    def Stall(self):
        """Specifies whether to suspend the request source without processing. valid values:.
<li>`on`: Enable;</li>

<li>off: Disable.</li>

Enabled, no longer responds to requests in the current connection session and does not actively disconnect. used for crawler combat to consume client connection resources.
Note: this option cannot intersect with BlockIp or ReturnCustomPage options.
        :rtype: str
        """
        return self._Stall

    @Stall.setter
    def Stall(self, Stall):
        self._Stall = Stall


    def _deserialize(self, params):
        self._BlockIp = params.get("BlockIp")
        self._BlockIpDuration = params.get("BlockIpDuration")
        self._ReturnCustomPage = params.get("ReturnCustomPage")
        self._ResponseCode = params.get("ResponseCode")
        self._ErrorPageId = params.get("ErrorPageId")
        self._Stall = params.get("Stall")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeployConfigGroupVersionRequest(AbstractModel):
    """DeployConfigGroupVersion request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _EnvId: Environment ID. Please specify the environment ID to which the version should be released.
        :type EnvId: str
        :param _ConfigGroupVersionInfos: Version information required for release. Multiple versions of different configuration groups can be modified simultaneously, while each group allows modifying only one version at a time.
        :type ConfigGroupVersionInfos: list of ConfigGroupVersionInfo
        :param _Description: Change description. It is used to describe the content and reasons for this change. A maximum of 100 characters are supported.
        :type Description: str
        """
        self._ZoneId = None
        self._EnvId = None
        self._ConfigGroupVersionInfos = None
        self._Description = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def EnvId(self):
        """Environment ID. Please specify the environment ID to which the version should be released.
        :rtype: str
        """
        return self._EnvId

    @EnvId.setter
    def EnvId(self, EnvId):
        self._EnvId = EnvId

    @property
    def ConfigGroupVersionInfos(self):
        """Version information required for release. Multiple versions of different configuration groups can be modified simultaneously, while each group allows modifying only one version at a time.
        :rtype: list of ConfigGroupVersionInfo
        """
        return self._ConfigGroupVersionInfos

    @ConfigGroupVersionInfos.setter
    def ConfigGroupVersionInfos(self, ConfigGroupVersionInfos):
        self._ConfigGroupVersionInfos = ConfigGroupVersionInfos

    @property
    def Description(self):
        """Change description. It is used to describe the content and reasons for this change. A maximum of 100 characters are supported.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._EnvId = params.get("EnvId")
        if params.get("ConfigGroupVersionInfos") is not None:
            self._ConfigGroupVersionInfos = []
            for item in params.get("ConfigGroupVersionInfos"):
                obj = ConfigGroupVersionInfo()
                obj._deserialize(item)
                self._ConfigGroupVersionInfos.append(obj)
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeployConfigGroupVersionResponse(AbstractModel):
    """DeployConfigGroupVersion response structure.

    """

    def __init__(self):
        r"""
        :param _RecordId: Release record ID.
        :type RecordId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RecordId = None
        self._RequestId = None

    @property
    def RecordId(self):
        """Release record ID.
        :rtype: str
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RecordId = params.get("RecordId")
        self._RequestId = params.get("RequestId")


class DeployRecord(AbstractModel):
    """Version release record details for the configuration group.

    """

    def __init__(self):
        r"""
        :param _ConfigGroupVersionInfos: Details about the released version.
        :type ConfigGroupVersionInfos: list of ConfigGroupVersionInfo
        :param _DeployTime: Release time. The time format follows the ISO 8601 standard and is represented in Coordinated Universal Time (UTC).
        :type DeployTime: str
        :param _Status: Release status. Valid values: 
<li>deploying: Being released.</li>
<li>failure: Release failed.</li>
<li>success: Released successfully. </li>
        :type Status: str
        :param _Message: Release result information.
        :type Message: str
        :param _RecordId: Release record ID. 
Note: this field may return null, indicating that no valid values can be obtained.
        :type RecordId: str
        :param _Description: Change description.
        :type Description: str
        """
        self._ConfigGroupVersionInfos = None
        self._DeployTime = None
        self._Status = None
        self._Message = None
        self._RecordId = None
        self._Description = None

    @property
    def ConfigGroupVersionInfos(self):
        """Details about the released version.
        :rtype: list of ConfigGroupVersionInfo
        """
        return self._ConfigGroupVersionInfos

    @ConfigGroupVersionInfos.setter
    def ConfigGroupVersionInfos(self, ConfigGroupVersionInfos):
        self._ConfigGroupVersionInfos = ConfigGroupVersionInfos

    @property
    def DeployTime(self):
        """Release time. The time format follows the ISO 8601 standard and is represented in Coordinated Universal Time (UTC).
        :rtype: str
        """
        return self._DeployTime

    @DeployTime.setter
    def DeployTime(self, DeployTime):
        self._DeployTime = DeployTime

    @property
    def Status(self):
        """Release status. Valid values: 
<li>deploying: Being released.</li>
<li>failure: Release failed.</li>
<li>success: Released successfully. </li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Message(self):
        """Release result information.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def RecordId(self):
        """Release record ID. 
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def Description(self):
        """Change description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        if params.get("ConfigGroupVersionInfos") is not None:
            self._ConfigGroupVersionInfos = []
            for item in params.get("ConfigGroupVersionInfos"):
                obj = ConfigGroupVersionInfo()
                obj._deserialize(item)
                self._ConfigGroupVersionInfos.append(obj)
        self._DeployTime = params.get("DeployTime")
        self._Status = params.get("Status")
        self._Message = params.get("Message")
        self._RecordId = params.get("RecordId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccelerationDomainsRequest(AbstractModel):
    """DescribeAccelerationDomains request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site related with the acceleration domain name.
        :type ZoneId: str
        :param _Offset: Offset for paginated queries. Default value: 0.
        :type Offset: int
        :param _Limit: Limit on paginated queries. Default value: 20. Maximum value: 200.
        :type Limit: int
        :param _Filters: Filter criteria. The maximum number of Filters.Values is 20. If this parameter is not input, all domain name information under the current zone-id will be returned. The detailed filter criteria are as follows:
<li>domain-name: Filter by acceleration domain name;</li>
<li>origin-type: Filter by origin server type;</li>
<li>origin: Filter by primary origin server address;</li>
<li>backup-origin: Filter by replica origin server address;</li>
<li>domain-cname: Filter by CNAME;</li>
<li>share-cname: Filter by shared CNAME.</li>
        :type Filters: list of AdvancedFilter
        :param _Order: Sort the returned results according to this field. Values include:
<li>`created_on`: Creation time of the acceleration domain name</li>
<li>`domain-name`: (Default) Acceleration domain name.</li> 
        :type Order: str
        :param _Direction: Sort direction. If the field value is number, sort by the numeric value. If the field value is text, sort by the ascill code. Values include:
<li>`asc`: Ascending order.</li>
<li>`desc`: Descending order.</li> Default value: `asc`.
        :type Direction: str
        :param _Match: The match mode. Values:
<li>`all`: Return all matches.</li>
<li>`any`: Return any match.</li>Default value: `all`.
        :type Match: str
        """
        self._ZoneId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._Order = None
        self._Direction = None
        self._Match = None

    @property
    def ZoneId(self):
        """ID of the site related with the acceleration domain name.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Offset(self):
        """Offset for paginated queries. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Limit on paginated queries. Default value: 20. Maximum value: 200.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter criteria. The maximum number of Filters.Values is 20. If this parameter is not input, all domain name information under the current zone-id will be returned. The detailed filter criteria are as follows:
<li>domain-name: Filter by acceleration domain name;</li>
<li>origin-type: Filter by origin server type;</li>
<li>origin: Filter by primary origin server address;</li>
<li>backup-origin: Filter by replica origin server address;</li>
<li>domain-cname: Filter by CNAME;</li>
<li>share-cname: Filter by shared CNAME.</li>
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        """Sort the returned results according to this field. Values include:
<li>`created_on`: Creation time of the acceleration domain name</li>
<li>`domain-name`: (Default) Acceleration domain name.</li> 
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Direction(self):
        """Sort direction. If the field value is number, sort by the numeric value. If the field value is text, sort by the ascill code. Values include:
<li>`asc`: Ascending order.</li>
<li>`desc`: Descending order.</li> Default value: `asc`.
        :rtype: str
        """
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Match(self):
        """The match mode. Values:
<li>`all`: Return all matches.</li>
<li>`any`: Return any match.</li>Default value: `all`.
        :rtype: str
        """
        return self._Match

    @Match.setter
    def Match(self, Match):
        self._Match = Match


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._Direction = params.get("Direction")
        self._Match = params.get("Match")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccelerationDomainsResponse(AbstractModel):
    """DescribeAccelerationDomains response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total of matched alias domain names.
        :type TotalCount: int
        :param _AccelerationDomains: Information of all matched acceleration domain names
        :type AccelerationDomains: list of AccelerationDomain
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AccelerationDomains = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total of matched alias domain names.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AccelerationDomains(self):
        """Information of all matched acceleration domain names
        :rtype: list of AccelerationDomain
        """
        return self._AccelerationDomains

    @AccelerationDomains.setter
    def AccelerationDomains(self, AccelerationDomains):
        self._AccelerationDomains = AccelerationDomains

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AccelerationDomains") is not None:
            self._AccelerationDomains = []
            for item in params.get("AccelerationDomains"):
                obj = AccelerationDomain()
                obj._deserialize(item)
                self._AccelerationDomains.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAliasDomainsRequest(AbstractModel):
    """DescribeAliasDomains request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        :param _Offset: The page offset. Default value: 0
        :type Offset: int
        :param _Limit: The paginated query limit. Default value: 20. Maximum value: 1000.
        :type Limit: int
        :param _Filters: Filter conditions. The maximum value for Filters.Values is 20. The detailed conditions are as follows:
<li>target-name: Filter by the target domain name;</li>
<li>alias-name: Filter by the alias of the domain name.</li>Fuzzy queries are only supported for the field name alias-name.
        :type Filters: list of AdvancedFilter
        """
        self._ZoneId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Offset(self):
        """The page offset. Default value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """The paginated query limit. Default value: 20. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter conditions. The maximum value for Filters.Values is 20. The detailed conditions are as follows:
<li>target-name: Filter by the target domain name;</li>
<li>alias-name: Filter by the alias of the domain name.</li>Fuzzy queries are only supported for the field name alias-name.
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAliasDomainsResponse(AbstractModel):
    """DescribeAliasDomains response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total eligible alias domain names.
        :type TotalCount: int
        :param _AliasDomains: Information of the eligible alias domain names.
        :type AliasDomains: list of AliasDomain
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AliasDomains = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total eligible alias domain names.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AliasDomains(self):
        """Information of the eligible alias domain names.
        :rtype: list of AliasDomain
        """
        return self._AliasDomains

    @AliasDomains.setter
    def AliasDomains(self, AliasDomains):
        self._AliasDomains = AliasDomains

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AliasDomains") is not None:
            self._AliasDomains = []
            for item in params.get("AliasDomains"):
                obj = AliasDomain()
                obj._deserialize(item)
                self._AliasDomains.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeApplicationProxiesRequest(AbstractModel):
    """DescribeApplicationProxies request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID. This parameter is required.
        :type ZoneId: str
        :param _Filters: Filters. Each filter can have up to 20 entries. Details: <li>proxy-id<br>   Filter by the <strong>Proxy ID</strong>, such as: `proxy-ev2sawbwfd`. <br>   Type: String<br>   Required: No</li><li>zone-id<br>   Filter by the <strong>Site ID</strong>, such as `zone-vawer2vadg`. <br>   Type: String<br>   Required: No</li><li>rule-tag<br>   Filter by the <strong>Rule tag</strong>, such as `rule-service-1`. <br>   Type: String<br>   Required: No</li>
        :type Filters: list of Filter
        :param _Offset: The paginated query offset. Default value: 0
        :type Offset: int
        :param _Limit: The paginated query limit. Default value: 20. Maximum value: 1000.
        :type Limit: int
        """
        self._ZoneId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def ZoneId(self):
        """Zone ID. This parameter is required.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Filters(self):
        """Filters. Each filter can have up to 20 entries. Details: <li>proxy-id<br>   Filter by the <strong>Proxy ID</strong>, such as: `proxy-ev2sawbwfd`. <br>   Type: String<br>   Required: No</li><li>zone-id<br>   Filter by the <strong>Site ID</strong>, such as `zone-vawer2vadg`. <br>   Type: String<br>   Required: No</li><li>rule-tag<br>   Filter by the <strong>Rule tag</strong>, such as `rule-service-1`. <br>   Type: String<br>   Required: No</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """The paginated query offset. Default value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """The paginated query limit. Default value: 20. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationProxiesResponse(AbstractModel):
    """DescribeApplicationProxies response structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationProxies: List of application proxies.
        :type ApplicationProxies: list of ApplicationProxy
        :param _TotalCount: Total number of records.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ApplicationProxies = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ApplicationProxies(self):
        """List of application proxies.
        :rtype: list of ApplicationProxy
        """
        return self._ApplicationProxies

    @ApplicationProxies.setter
    def ApplicationProxies(self, ApplicationProxies):
        self._ApplicationProxies = ApplicationProxies

    @property
    def TotalCount(self):
        """Total number of records.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ApplicationProxies") is not None:
            self._ApplicationProxies = []
            for item in params.get("ApplicationProxies"):
                obj = ApplicationProxy()
                obj._deserialize(item)
                self._ApplicationProxies.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAvailablePlansRequest(AbstractModel):
    """DescribeAvailablePlans request structure.

    """


class DescribeAvailablePlansResponse(AbstractModel):
    """DescribeAvailablePlans response structure.

    """

    def __init__(self):
        r"""
        :param _PlanInfo: Plans available for the current user
Note: This field may return null, indicating that no valid values can be obtained.
        :type PlanInfo: list of PlanInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PlanInfo = None
        self._RequestId = None

    @property
    def PlanInfo(self):
        """Plans available for the current user
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of PlanInfo
        """
        return self._PlanInfo

    @PlanInfo.setter
    def PlanInfo(self, PlanInfo):
        self._PlanInfo = PlanInfo

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PlanInfo") is not None:
            self._PlanInfo = []
            for item in params.get("PlanInfo"):
                obj = PlanInfo()
                obj._deserialize(item)
                self._PlanInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingDataRequest(AbstractModel):
    """DescribeBillingData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time. The query time range (EndTime - StartTime) must be less than or equal to 31 days.
        :type EndTime: str
        :param _ZoneIds: Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :type ZoneIds: list of str
        :param _MetricName: Metric name. Valid values:
**Layer 4/7 Acceleration Traffic (Unit: Byte):**
<li>acc_flux: content acceleration traffic, in bytes;</li>
<li>smt_flux: smart acceleration traffic, in bytes;</li>
<li>l4_flux: layer 4 acceleration traffic, in bytes;</li>
<li>sec_flux: exclusive protection traffic, in bytes;</li>
<li>zxctg_flux: network optimization traffic in the chinese mainland, in bytes;</li>

**Layer 4/7 Acceleration Bandwidth (Unit: bps):**
<Li>acc_bandwidth: content acceleration bandwidth, in bps.</li>
<li>smt_bandwidth: smart acceleration bandwidth, in bps;</li>
<Li>l4_bandwidth: layer 4 acceleration bandwidth, in bps.</li>
<li>sec_bandwidth: exclusive protection bandwidth, in bps.</li>
<li>zxctg_bandwidth: network optimization bandwidth in the chinese mainland, in bps;</li>

**HTTP/HTTPS Security Requests (Unit: counts):**
<li>sec_request_clean: number of HTTP/HTTPS requests;</li>

**Value-added Service Usage:**
<li>smt_request_clean: number of smart acceleration requests, in counts;</li>
<li>quic_request: number of quic requests;</li>
<Li>bot_request_clean: number of bot requests;</li>
<li>cls_count: number of real-time log entries pushed;</li>
<li>ddos_bandwidth: elastic ddos protection bandwidth, in bps.</li>

**Edge Computing Usage:**
<li>edgefunction_request: number of edge function executions, in counts</li>
<li>edgefunction_cpu_time: edge function CPU processing time, in milliseconds</li>

**Media Processing Usage (Unit: seconds):**
<li>total_transcode: duration of jit transcoding and transmuxing for all specifications of audio and video, in seconds;</li>
<li>remux: transmuxing duration, in seconds;</li>
<li>transcode_audio: audio transcoding duration, in seconds;</li>
<li>transcode_H264_SD: specifies the duration of standard-definition videos encoded in H.264 (short side <= 480 px), in seconds;</li>
<li>transcode_H264_HD: specifies the duration of high-definition video (short side <= 720 px) encoded in H.264, in seconds;</li>
<li>transcode_H264_FHD: specifies the duration of a full hd video (short side <= 1080 px) encoded in H.264, in seconds;</li>
<li>transcode_H264_2K: specifies the duration of a 2K video (short side <= 1440 px) encoded in H.264, expressed in seconds.</li>


        :type MetricName: str
        :param _Interval: Time granularity of the query. Valid values:
<li>5min: 5 minutes;</li>
<li>hour: 1 hour;</li>
<li>day: 1 day.</li>
        :type Interval: str
        :param _Filters: Filter criteria. The detailed values of filter criteria are as follows:
<ul>
  <li>host: Filter by domain name, such as test.example.com.</li>
  <li>proxy-id: Filter by L4 proxy instance ID, such as sid-2rugn89bkla9.</li>
  <li>region-id: Filter by billing region. Options:
    <ul>
      <li>CH: Chinese mainland</li>
      <li>AF: Africa</li>
      <li>AS1: Asia-Pacific Region 1</li>
      <li>AS2: Asia-Pacific Region 2</li>
      <li>AS3: Asia-Pacific Region 3</li>
      <li>EU: Europe</li>
      <li>MidEast: Middle East</li>
      <li>NA: North America</li>
      <li>SA: South America</li>
    </ul>
  </li>
</ul>
<p>Note: Filters of the same `Type` use OR logic, while filters of different `Type` use AND logic.</p>

        :type Filters: list of BillingDataFilter
        :param _GroupBy: <p>Grouping aggregation dimensions. A maximum of two dimensions can be used for grouping simultaneously. The values are as follows:</p>
  <ul>
    <li>zone-id: Group by zone ID. If content identifiers are used, grouping by content identifier takes priority.</li>
    <li>host: Group by domain name.</li>
    <li>proxy-id: Group by layer-4 proxy instance ID.</li>
    <li>region-id: Group by billing region.</li>
  </ul>
        :type GroupBy: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._ZoneIds = None
        self._MetricName = None
        self._Interval = None
        self._Filters = None
        self._GroupBy = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time. The query time range (EndTime - StartTime) must be less than or equal to 31 days.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ZoneIds(self):
        """Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def MetricName(self):
        """Metric name. Valid values:
**Layer 4/7 Acceleration Traffic (Unit: Byte):**
<li>acc_flux: content acceleration traffic, in bytes;</li>
<li>smt_flux: smart acceleration traffic, in bytes;</li>
<li>l4_flux: layer 4 acceleration traffic, in bytes;</li>
<li>sec_flux: exclusive protection traffic, in bytes;</li>
<li>zxctg_flux: network optimization traffic in the chinese mainland, in bytes;</li>

**Layer 4/7 Acceleration Bandwidth (Unit: bps):**
<Li>acc_bandwidth: content acceleration bandwidth, in bps.</li>
<li>smt_bandwidth: smart acceleration bandwidth, in bps;</li>
<Li>l4_bandwidth: layer 4 acceleration bandwidth, in bps.</li>
<li>sec_bandwidth: exclusive protection bandwidth, in bps.</li>
<li>zxctg_bandwidth: network optimization bandwidth in the chinese mainland, in bps;</li>

**HTTP/HTTPS Security Requests (Unit: counts):**
<li>sec_request_clean: number of HTTP/HTTPS requests;</li>

**Value-added Service Usage:**
<li>smt_request_clean: number of smart acceleration requests, in counts;</li>
<li>quic_request: number of quic requests;</li>
<Li>bot_request_clean: number of bot requests;</li>
<li>cls_count: number of real-time log entries pushed;</li>
<li>ddos_bandwidth: elastic ddos protection bandwidth, in bps.</li>

**Edge Computing Usage:**
<li>edgefunction_request: number of edge function executions, in counts</li>
<li>edgefunction_cpu_time: edge function CPU processing time, in milliseconds</li>

**Media Processing Usage (Unit: seconds):**
<li>total_transcode: duration of jit transcoding and transmuxing for all specifications of audio and video, in seconds;</li>
<li>remux: transmuxing duration, in seconds;</li>
<li>transcode_audio: audio transcoding duration, in seconds;</li>
<li>transcode_H264_SD: specifies the duration of standard-definition videos encoded in H.264 (short side <= 480 px), in seconds;</li>
<li>transcode_H264_HD: specifies the duration of high-definition video (short side <= 720 px) encoded in H.264, in seconds;</li>
<li>transcode_H264_FHD: specifies the duration of a full hd video (short side <= 1080 px) encoded in H.264, in seconds;</li>
<li>transcode_H264_2K: specifies the duration of a 2K video (short side <= 1440 px) encoded in H.264, expressed in seconds.</li>


        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName

    @property
    def Interval(self):
        """Time granularity of the query. Valid values:
<li>5min: 5 minutes;</li>
<li>hour: 1 hour;</li>
<li>day: 1 day.</li>
        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Filters(self):
        """Filter criteria. The detailed values of filter criteria are as follows:
<ul>
  <li>host: Filter by domain name, such as test.example.com.</li>
  <li>proxy-id: Filter by L4 proxy instance ID, such as sid-2rugn89bkla9.</li>
  <li>region-id: Filter by billing region. Options:
    <ul>
      <li>CH: Chinese mainland</li>
      <li>AF: Africa</li>
      <li>AS1: Asia-Pacific Region 1</li>
      <li>AS2: Asia-Pacific Region 2</li>
      <li>AS3: Asia-Pacific Region 3</li>
      <li>EU: Europe</li>
      <li>MidEast: Middle East</li>
      <li>NA: North America</li>
      <li>SA: South America</li>
    </ul>
  </li>
</ul>
<p>Note: Filters of the same `Type` use OR logic, while filters of different `Type` use AND logic.</p>

        :rtype: list of BillingDataFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def GroupBy(self):
        """<p>Grouping aggregation dimensions. A maximum of two dimensions can be used for grouping simultaneously. The values are as follows:</p>
  <ul>
    <li>zone-id: Group by zone ID. If content identifiers are used, grouping by content identifier takes priority.</li>
    <li>host: Group by domain name.</li>
    <li>proxy-id: Group by layer-4 proxy instance ID.</li>
    <li>region-id: Group by billing region.</li>
  </ul>
        :rtype: list of str
        """
        return self._GroupBy

    @GroupBy.setter
    def GroupBy(self, GroupBy):
        self._GroupBy = GroupBy


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ZoneIds = params.get("ZoneIds")
        self._MetricName = params.get("MetricName")
        self._Interval = params.get("Interval")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = BillingDataFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._GroupBy = params.get("GroupBy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingDataResponse(AbstractModel):
    """DescribeBillingData response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Data point list.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type Data: list of BillingData
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """Data point list.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: list of BillingData
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = BillingData()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeConfigGroupVersionDetailRequest(AbstractModel):
    """DescribeConfigGroupVersionDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _VersionId: Version ID.
        :type VersionId: str
        """
        self._ZoneId = None
        self._VersionId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def VersionId(self):
        """Version ID.
        :rtype: str
        """
        return self._VersionId

    @VersionId.setter
    def VersionId(self, VersionId):
        self._VersionId = VersionId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._VersionId = params.get("VersionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConfigGroupVersionDetailResponse(AbstractModel):
    """DescribeConfigGroupVersionDetail response structure.

    """

    def __init__(self):
        r"""
        :param _ConfigGroupVersionInfo: Version information.
        :type ConfigGroupVersionInfo: :class:`tencentcloud.teo.v20220901.models.ConfigGroupVersionInfo`
        :param _Content: Version file content. It is returned in JSON format.
        :type Content: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ConfigGroupVersionInfo = None
        self._Content = None
        self._RequestId = None

    @property
    def ConfigGroupVersionInfo(self):
        """Version information.
        :rtype: :class:`tencentcloud.teo.v20220901.models.ConfigGroupVersionInfo`
        """
        return self._ConfigGroupVersionInfo

    @ConfigGroupVersionInfo.setter
    def ConfigGroupVersionInfo(self, ConfigGroupVersionInfo):
        self._ConfigGroupVersionInfo = ConfigGroupVersionInfo

    @property
    def Content(self):
        """Version file content. It is returned in JSON format.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ConfigGroupVersionInfo") is not None:
            self._ConfigGroupVersionInfo = ConfigGroupVersionInfo()
            self._ConfigGroupVersionInfo._deserialize(params.get("ConfigGroupVersionInfo"))
        self._Content = params.get("Content")
        self._RequestId = params.get("RequestId")


class DescribeConfigGroupVersionsRequest(AbstractModel):
    """DescribeConfigGroupVersions request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _GroupId: Configuraration group ID.
        :type GroupId: str
        :param _Filters: Filtering condition. The maximum value of Filters.Values is 20. If this parameter is not specified, all version information for the selected configuration group is returned. Detailed filtering conditions: 
<li>version-id: Filter by version ID.</li>
        :type Filters: list of AdvancedFilter
        :param _Offset: Paging query offset. The default value is 0.
        :type Offset: int
        :param _Limit: Limited entries in paging queries. The default value is 20 and the maximum value is 100. 
        :type Limit: int
        """
        self._ZoneId = None
        self._GroupId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        """Configuraration group ID.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Filters(self):
        """Filtering condition. The maximum value of Filters.Values is 20. If this parameter is not specified, all version information for the selected configuration group is returned. Detailed filtering conditions: 
<li>version-id: Filter by version ID.</li>
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """Paging query offset. The default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Limited entries in paging queries. The default value is 20 and the maximum value is 100. 
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConfigGroupVersionsResponse(AbstractModel):
    """DescribeConfigGroupVersions response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total versions.
        :type TotalCount: int
        :param _ConfigGroupVersionInfos: Version information list.
        :type ConfigGroupVersionInfos: list of ConfigGroupVersionInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ConfigGroupVersionInfos = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total versions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ConfigGroupVersionInfos(self):
        """Version information list.
        :rtype: list of ConfigGroupVersionInfo
        """
        return self._ConfigGroupVersionInfos

    @ConfigGroupVersionInfos.setter
    def ConfigGroupVersionInfos(self, ConfigGroupVersionInfos):
        self._ConfigGroupVersionInfos = ConfigGroupVersionInfos

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ConfigGroupVersionInfos") is not None:
            self._ConfigGroupVersionInfos = []
            for item in params.get("ConfigGroupVersionInfos"):
                obj = ConfigGroupVersionInfo()
                obj._deserialize(item)
                self._ConfigGroupVersionInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeContentIdentifiersRequest(AbstractModel):
    """DescribeContentIdentifiers request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: The offset of paginated query. default value: 0.
        :type Offset: int
        :param _Limit: Limit on paginated queries. default value: `20`. maximum value: `100`.
        :type Limit: int
        :param _Filters: Filter conditions. the upper limit for filters is 20, and the upper limit for filters.values is 20. if this parameter is not filled in, the content identifiers with permissions under the current appid are returned by default. detailed filtering conditions are as follows: <li>description: filter by content identifier description in batches; for example: test;</li><li>content-id: filter by content identifier id in batches; for example: eocontent-2noz78a8ev6k;</li><li>tag-key: filter by Tag key;</li><li>tag-value: filter by Tag value;</li><li>status: filter by content identifier status. valid values: active: active; deleted: deleted.</li>only description supports fuzzy query, other fields require precise query.
        :type Filters: list of AdvancedFilter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        """The offset of paginated query. default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Limit on paginated queries. default value: `20`. maximum value: `100`.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter conditions. the upper limit for filters is 20, and the upper limit for filters.values is 20. if this parameter is not filled in, the content identifiers with permissions under the current appid are returned by default. detailed filtering conditions are as follows: <li>description: filter by content identifier description in batches; for example: test;</li><li>content-id: filter by content identifier id in batches; for example: eocontent-2noz78a8ev6k;</li><li>tag-key: filter by Tag key;</li><li>tag-value: filter by Tag value;</li><li>status: filter by content identifier status. valid values: active: active; deleted: deleted.</li>only description supports fuzzy query, other fields require precise query.
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContentIdentifiersResponse(AbstractModel):
    """DescribeContentIdentifiers response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of content identifiers that meet the filter conditions.	
        :type TotalCount: int
        :param _ContentIdentifiers: Detailed content identifier list.
        :type ContentIdentifiers: list of ContentIdentifier
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ContentIdentifiers = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of content identifiers that meet the filter conditions.	
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ContentIdentifiers(self):
        """Detailed content identifier list.
        :rtype: list of ContentIdentifier
        """
        return self._ContentIdentifiers

    @ContentIdentifiers.setter
    def ContentIdentifiers(self, ContentIdentifiers):
        self._ContentIdentifiers = ContentIdentifiers

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ContentIdentifiers") is not None:
            self._ContentIdentifiers = []
            for item in params.get("ContentIdentifiers"):
                obj = ContentIdentifier()
                obj._deserialize(item)
                self._ContentIdentifiers.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeContentQuotaRequest(AbstractModel):
    """DescribeContentQuota request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        """ID of the site.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContentQuotaResponse(AbstractModel):
    """DescribeContentQuota response structure.

    """

    def __init__(self):
        r"""
        :param _PurgeQuota: Purging quotas.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PurgeQuota: list of Quota
        :param _PrefetchQuota: Pre-warming quotas.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PrefetchQuota: list of Quota
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PurgeQuota = None
        self._PrefetchQuota = None
        self._RequestId = None

    @property
    def PurgeQuota(self):
        """Purging quotas.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Quota
        """
        return self._PurgeQuota

    @PurgeQuota.setter
    def PurgeQuota(self, PurgeQuota):
        self._PurgeQuota = PurgeQuota

    @property
    def PrefetchQuota(self):
        """Pre-warming quotas.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Quota
        """
        return self._PrefetchQuota

    @PrefetchQuota.setter
    def PrefetchQuota(self, PrefetchQuota):
        self._PrefetchQuota = PrefetchQuota

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PurgeQuota") is not None:
            self._PurgeQuota = []
            for item in params.get("PurgeQuota"):
                obj = Quota()
                obj._deserialize(item)
                self._PurgeQuota.append(obj)
        if params.get("PrefetchQuota") is not None:
            self._PrefetchQuota = []
            for item in params.get("PrefetchQuota"):
                obj = Quota()
                obj._deserialize(item)
                self._PrefetchQuota.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCustomErrorPagesRequest(AbstractModel):
    """DescribeCustomErrorPages request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Filters: Filter criteria. The maximum number of Filters.Values is 20. The detailed Name values of filter criteria are as follows:
<li>page-id: Filter by page ID;</li>
<li>name: Filter by page name;</li>
<li>description: Filter by page description;</li>
<li>content-type: Filter by page type.</li>
        :type Filters: list of AdvancedFilter
        :param _Offset: The offset of paginated query. Default value: 0.
        :type Offset: int
        :param _Limit: The limit of paginated query. Default value: 20. Maximum value: 1,000.  
        :type Limit: int
        """
        self._ZoneId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Filters(self):
        """Filter criteria. The maximum number of Filters.Values is 20. The detailed Name values of filter criteria are as follows:
<li>page-id: Filter by page ID;</li>
<li>name: Filter by page name;</li>
<li>description: Filter by page description;</li>
<li>content-type: Filter by page type.</li>
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """The offset of paginated query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """The limit of paginated query. Default value: 20. Maximum value: 1,000.  
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomErrorPagesResponse(AbstractModel):
    """DescribeCustomErrorPages response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of custom error pages.
        :type TotalCount: int
        :param _ErrorPages: Custom error page data list.
        :type ErrorPages: list of CustomErrorPage
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ErrorPages = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of custom error pages.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ErrorPages(self):
        """Custom error page data list.
        :rtype: list of CustomErrorPage
        """
        return self._ErrorPages

    @ErrorPages.setter
    def ErrorPages(self, ErrorPages):
        self._ErrorPages = ErrorPages

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ErrorPages") is not None:
            self._ErrorPages = []
            for item in params.get("ErrorPages"):
                obj = CustomErrorPage()
                obj._deserialize(item)
                self._ErrorPages.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDDoSAttackDataRequest(AbstractModel):
    """DescribeDDoSAttackData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :type EndTime: str
        :param _MetricNames: Statistical metrics.
<li>`ddos_attackMaxBandwidth`: Peak attack bandwidth;</li>
<li>`ddos_attackMaxPackageRate`: Peak attack packet rate;</li>
<li>`ddos_attackBandwidth`: Time-series data of attack bandwidth;</li>
<li>`ddos_attackPackageRate`: Time-series data of attack packet rate.</li>
        :type MetricNames: list of str
        :param _ZoneIds: Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :type ZoneIds: list of str
        :param _PolicyIds: IDs of DDoS policies to be queried. All policies will be selected if this field is not specified.
        :type PolicyIds: list of int
        :param _Interval: Query period granularity. Valid values:
<li>min: 1 minute;</li>
<li>5min: 5 minutes;</li>
<li>hour: 1 hour;</li>
<li>day: 1 day.</li>If this parameter is not filled in, the granularity will be automatically calculated based on the interval between the start time and end time. Specifically, data will be queried with a granularity of min, 5min, hour, and day respectively when the period is no more than 2 hours, no more than 2 days, no more than 7 days, and over 7 days.
        :type Interval: str
        :param _Area: Geolocation scope. Values:
<li>`overseas`: Regions outside the Chinese mainland</li>
<li>`mainland`: Chinese mainland</li>
<li>`global`: Global </li>If this field is not specified, the default value `global` is used.
        :type Area: str
        """
        self._StartTime = None
        self._EndTime = None
        self._MetricNames = None
        self._ZoneIds = None
        self._PolicyIds = None
        self._Interval = None
        self._Area = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MetricNames(self):
        """Statistical metrics.
<li>`ddos_attackMaxBandwidth`: Peak attack bandwidth;</li>
<li>`ddos_attackMaxPackageRate`: Peak attack packet rate;</li>
<li>`ddos_attackBandwidth`: Time-series data of attack bandwidth;</li>
<li>`ddos_attackPackageRate`: Time-series data of attack packet rate.</li>
        :rtype: list of str
        """
        return self._MetricNames

    @MetricNames.setter
    def MetricNames(self, MetricNames):
        self._MetricNames = MetricNames

    @property
    def ZoneIds(self):
        """Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def PolicyIds(self):
        """IDs of DDoS policies to be queried. All policies will be selected if this field is not specified.
        :rtype: list of int
        """
        return self._PolicyIds

    @PolicyIds.setter
    def PolicyIds(self, PolicyIds):
        self._PolicyIds = PolicyIds

    @property
    def Interval(self):
        """Query period granularity. Valid values:
<li>min: 1 minute;</li>
<li>5min: 5 minutes;</li>
<li>hour: 1 hour;</li>
<li>day: 1 day.</li>If this parameter is not filled in, the granularity will be automatically calculated based on the interval between the start time and end time. Specifically, data will be queried with a granularity of min, 5min, hour, and day respectively when the period is no more than 2 hours, no more than 2 days, no more than 7 days, and over 7 days.
        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Area(self):
        """Geolocation scope. Values:
<li>`overseas`: Regions outside the Chinese mainland</li>
<li>`mainland`: Chinese mainland</li>
<li>`global`: Global </li>If this field is not specified, the default value `global` is used.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MetricNames = params.get("MetricNames")
        self._ZoneIds = params.get("ZoneIds")
        self._PolicyIds = params.get("PolicyIds")
        self._Interval = params.get("Interval")
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDDoSAttackDataResponse(AbstractModel):
    """DescribeDDoSAttackData response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _Data: List of DDoS attack data.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of SecEntry
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        """List of DDoS attack data.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of SecEntry
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = SecEntry()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDDoSAttackEventRequest(AbstractModel):
    """DescribeDDoSAttackEvent request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :type EndTime: str
        :param _PolicyIds: List of DDoS policy IDs. All policies are selected if this field is not specified.
        :type PolicyIds: list of int
        :param _ZoneIds: Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :type ZoneIds: list of str
        :param _Limit: Limit on paginated queries. Default value: 20. Maximum value: 1000.
        :type Limit: int
        :param _Offset: The page offset. Default value: 0.
        :type Offset: int
        :param _ShowDetail: Parameter to show attack details. If it is configured as false, only the number of attacks is returned without details. If it is configured as true, attack details are returned.
        :type ShowDetail: bool
        :param _Area: Geolocation scope. Values: 
<li>`overseas`: Regions outside the Chinese mainland</li>
<li>`mainland`: Chinese mainland</li>
<li>`global`: Global</li>If this field is not specified, the default value `global` is used.
        :type Area: str
        :param _OrderBy: The sorting field. Values: 
<li>`MaxBandWidth`: Peak bandwidth</li>
<li>`AttackStartTime` Start time of the attack</li>If this field is not specified, the default value `AttackStartTime` is used.
        :type OrderBy: str
        :param _OrderType: The sorting method. Values: 
<Li>`asc`: Ascending</li>
<li>`desc`: Descending</li>If this field is not specified, the default value `desc` is used.
        :type OrderType: str
        """
        self._StartTime = None
        self._EndTime = None
        self._PolicyIds = None
        self._ZoneIds = None
        self._Limit = None
        self._Offset = None
        self._ShowDetail = None
        self._Area = None
        self._OrderBy = None
        self._OrderType = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PolicyIds(self):
        """List of DDoS policy IDs. All policies are selected if this field is not specified.
        :rtype: list of int
        """
        return self._PolicyIds

    @PolicyIds.setter
    def PolicyIds(self, PolicyIds):
        self._PolicyIds = PolicyIds

    @property
    def ZoneIds(self):
        """Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def Limit(self):
        """Limit on paginated queries. Default value: 20. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """The page offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def ShowDetail(self):
        """Parameter to show attack details. If it is configured as false, only the number of attacks is returned without details. If it is configured as true, attack details are returned.
        :rtype: bool
        """
        return self._ShowDetail

    @ShowDetail.setter
    def ShowDetail(self, ShowDetail):
        self._ShowDetail = ShowDetail

    @property
    def Area(self):
        """Geolocation scope. Values: 
<li>`overseas`: Regions outside the Chinese mainland</li>
<li>`mainland`: Chinese mainland</li>
<li>`global`: Global</li>If this field is not specified, the default value `global` is used.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def OrderBy(self):
        """The sorting field. Values: 
<li>`MaxBandWidth`: Peak bandwidth</li>
<li>`AttackStartTime` Start time of the attack</li>If this field is not specified, the default value `AttackStartTime` is used.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        """The sorting method. Values: 
<Li>`asc`: Ascending</li>
<li>`desc`: Descending</li>If this field is not specified, the default value `desc` is used.
        :rtype: str
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PolicyIds = params.get("PolicyIds")
        self._ZoneIds = params.get("ZoneIds")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._ShowDetail = params.get("ShowDetail")
        self._Area = params.get("Area")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDDoSAttackEventResponse(AbstractModel):
    """DescribeDDoSAttackEvent response structure.

    """

    def __init__(self):
        r"""
        :param _Data: List of DDoS attack data. 
Note: This field may return `null`, indicating that no valid value was found.
        :type Data: list of DDoSAttackEvent
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Data(self):
        """List of DDoS attack data. 
Note: This field may return `null`, indicating that no valid value was found.
        :rtype: list of DDoSAttackEvent
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def TotalCount(self):
        """Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DDoSAttackEvent()
                obj._deserialize(item)
                self._Data.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDDoSAttackTopDataRequest(AbstractModel):
    """DescribeDDoSAttackTopData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :type EndTime: str
        :param _MetricName: The statistical metric. Values:
<li>`ddos_attackFlux_protocol`: Rank protocols by the attack traffic.</li>
<li>`ddos_attackPackageNum_protocol`: Rank protocols by the number of attack packets.</li>
<li>`ddos_attackNum_attackType`: Rank attack types by the number of attacks.</li>
<li>`ddos_attackNum_sregion`: Rank attacker regions by the number of attacks.</li>
<li>`ddos_attackFlux_sip`: Rank attacker IPs by the number of attacks.</li>
<li>`ddos_attackFlux_sregion`: Rank attacker regions by the number of attacks.</li>
        :type MetricName: str
        :param _ZoneIds: Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :type ZoneIds: list of str
        :param _PolicyIds: The list of DDoS policy IDs to be specified. All policies will be selected if this field is not specified.
        :type PolicyIds: list of int
        :param _AttackType: The attack type. Values:
<li>`flood`: Flood;</li>
<li>`icmpFlood`: ICMP flood;</li>
<li>`all`: All attack types.</li>This field will be set to the default value `all` if not specified.
        :type AttackType: str
        :param _ProtocolType: The protocol type. Values:
<li>`tcp`: TCP protocol;</li>
<li>`udp`: UDP protocol;</li>
<li>`all`: All protocol types.</li>This field will be set to the default value `all` if not specified.
        :type ProtocolType: str
        :param _Port: The port number.
        :type Port: int
        :param _Limit: Queries the top n rows of data. Top 10 rows of data will be queried if this field is not specified.
        :type Limit: int
        :param _Area: Data storage region. Values:
<li>`overseas`: Global (outside the Chinese mainland);</li>
<li>`mainland`: Chinese mainland.</li>If this field is not specified, the data storage region will be determined based on the user's location.
        :type Area: str
        """
        self._StartTime = None
        self._EndTime = None
        self._MetricName = None
        self._ZoneIds = None
        self._PolicyIds = None
        self._AttackType = None
        self._ProtocolType = None
        self._Port = None
        self._Limit = None
        self._Area = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MetricName(self):
        """The statistical metric. Values:
<li>`ddos_attackFlux_protocol`: Rank protocols by the attack traffic.</li>
<li>`ddos_attackPackageNum_protocol`: Rank protocols by the number of attack packets.</li>
<li>`ddos_attackNum_attackType`: Rank attack types by the number of attacks.</li>
<li>`ddos_attackNum_sregion`: Rank attacker regions by the number of attacks.</li>
<li>`ddos_attackFlux_sip`: Rank attacker IPs by the number of attacks.</li>
<li>`ddos_attackFlux_sregion`: Rank attacker regions by the number of attacks.</li>
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName

    @property
    def ZoneIds(self):
        """Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def PolicyIds(self):
        """The list of DDoS policy IDs to be specified. All policies will be selected if this field is not specified.
        :rtype: list of int
        """
        return self._PolicyIds

    @PolicyIds.setter
    def PolicyIds(self, PolicyIds):
        self._PolicyIds = PolicyIds

    @property
    def AttackType(self):
        """The attack type. Values:
<li>`flood`: Flood;</li>
<li>`icmpFlood`: ICMP flood;</li>
<li>`all`: All attack types.</li>This field will be set to the default value `all` if not specified.
        :rtype: str
        """
        return self._AttackType

    @AttackType.setter
    def AttackType(self, AttackType):
        self._AttackType = AttackType

    @property
    def ProtocolType(self):
        """The protocol type. Values:
<li>`tcp`: TCP protocol;</li>
<li>`udp`: UDP protocol;</li>
<li>`all`: All protocol types.</li>This field will be set to the default value `all` if not specified.
        :rtype: str
        """
        return self._ProtocolType

    @ProtocolType.setter
    def ProtocolType(self, ProtocolType):
        self._ProtocolType = ProtocolType

    @property
    def Port(self):
        """The port number.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Limit(self):
        """Queries the top n rows of data. Top 10 rows of data will be queried if this field is not specified.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Area(self):
        """Data storage region. Values:
<li>`overseas`: Global (outside the Chinese mainland);</li>
<li>`mainland`: Chinese mainland.</li>If this field is not specified, the data storage region will be determined based on the user's location.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MetricName = params.get("MetricName")
        self._ZoneIds = params.get("ZoneIds")
        self._PolicyIds = params.get("PolicyIds")
        self._AttackType = params.get("AttackType")
        self._ProtocolType = params.get("ProtocolType")
        self._Port = params.get("Port")
        self._Limit = params.get("Limit")
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDDoSAttackTopDataResponse(AbstractModel):
    """DescribeDDoSAttackTopData response structure.

    """

    def __init__(self):
        r"""
        :param _Data: The list of top-ranked DDoS attack data.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of TopEntry
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Data(self):
        """The list of top-ranked DDoS attack data.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TopEntry
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def TotalCount(self):
        """Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TopEntry()
                obj._deserialize(item)
                self._Data.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDefaultCertificatesRequest(AbstractModel):
    """DescribeDefaultCertificates request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Filters: Filter criteria. Each filter criteria can have up to 5 entries.
<li>`zone-id`: <br>Filter by <strong>site ID</strong>, such as zone-xxx<br>   Type: String<br>   Required: No</li>
        :type Filters: list of Filter
        :param _Offset: Offset for paginated queries. Default value: `0`
        :type Offset: int
        :param _Limit: Limit on paginated queries. Default value: `20`. Maximum value: `100`.
        :type Limit: int
        """
        self._ZoneId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Filters(self):
        """Filter criteria. Each filter criteria can have up to 5 entries.
<li>`zone-id`: <br>Filter by <strong>site ID</strong>, such as zone-xxx<br>   Type: String<br>   Required: No</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """Offset for paginated queries. Default value: `0`
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Limit on paginated queries. Default value: `20`. Maximum value: `100`.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDefaultCertificatesResponse(AbstractModel):
    """DescribeDefaultCertificates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of certificates
        :type TotalCount: int
        :param _DefaultServerCertInfo: List of default certificates
        :type DefaultServerCertInfo: list of DefaultServerCertInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._DefaultServerCertInfo = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of certificates
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DefaultServerCertInfo(self):
        """List of default certificates
        :rtype: list of DefaultServerCertInfo
        """
        return self._DefaultServerCertInfo

    @DefaultServerCertInfo.setter
    def DefaultServerCertInfo(self, DefaultServerCertInfo):
        self._DefaultServerCertInfo = DefaultServerCertInfo

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DefaultServerCertInfo") is not None:
            self._DefaultServerCertInfo = []
            for item in params.get("DefaultServerCertInfo"):
                obj = DefaultServerCertInfo()
                obj._deserialize(item)
                self._DefaultServerCertInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDeployHistoryRequest(AbstractModel):
    """DescribeDeployHistory request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _EnvId: Environment ID.
        :type EnvId: str
        :param _Filters: Filtering condition. The maximum value of Filters.Values is 20. Detailed filtering conditions: 
<li>record-id: Filter by release record ID. </li>
        :type Filters: list of AdvancedFilter
        """
        self._ZoneId = None
        self._EnvId = None
        self._Filters = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def EnvId(self):
        """Environment ID.
        :rtype: str
        """
        return self._EnvId

    @EnvId.setter
    def EnvId(self, EnvId):
        self._EnvId = EnvId

    @property
    def Filters(self):
        """Filtering condition. The maximum value of Filters.Values is 20. Detailed filtering conditions: 
<li>record-id: Filter by release record ID. </li>
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._EnvId = params.get("EnvId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDeployHistoryResponse(AbstractModel):
    """DescribeDeployHistory response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total release records.
        :type TotalCount: int
        :param _Records: Release record details.
        :type Records: list of DeployRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Records = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total release records.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Records(self):
        """Release record details.
        :rtype: list of DeployRecord
        """
        return self._Records

    @Records.setter
    def Records(self, Records):
        self._Records = Records

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Records") is not None:
            self._Records = []
            for item in params.get("Records"):
                obj = DeployRecord()
                obj._deserialize(item)
                self._Records.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDnsRecordsRequest(AbstractModel):
    """DescribeDnsRecords request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone id.
        :type ZoneId: str
        :param _Offset: Offset of paginated query. default value: 0.
        :type Offset: int
        :param _Limit: Number limit of paginated query. default value: 20. maximum value: 1000.
        :type Limit: int
        :param _Filters: Filter conditions. up to 20 values for each filter. detailed filter conditions are as follows: <li>id: filter by dns record id, supports fuzzy search;</li><li>name: filter by dns record name, supports fuzzy search;</li><li>content: filter by dns record content, supports fuzzy search;</li><li>type: filter by dns record type, does not support fuzzy search. valid values:<br>   a: points the domain name to an external ipv4 address, such as 8.8.8.8;<br>   aaaa: points the domain name to an external ipv6 address;<br>   cname: points the domain name to another domain name, which then resolves to the final ip address;<br>   txt: identifies and describes the domain name, commonly used for domain verification and spf records (anti-spam);<br>   ns: if you need to delegate the subdomain to another dns service provider, you need to add an ns record. root domain cannot add ns records;<br>   caa: specifies the ca that can issue certificates for this site;<br>   srv: identifies a server using a specific service, commonly used in microsoft's directory management;<br>   mx: specifies the recipient's mail server.</li><li>ttl: filter by resolution effective time, does not support fuzzy search.</li>.
        :type Filters: list of AdvancedFilter
        :param _SortBy: Sorting basis. values include: <li>`content`: dns record content</li><li>`created-on`: dns record creation time</li><li>`name`: dns record name</li><li>`ttl`: cache time</li><li>`type`: dns record type</li> default sorting is by the combination of `type`, `name`.
        :type SortBy: str
        :param _SortOrder: List sort method. values: <li>`asc`: ascending order</li><li>`desc`: sort in descending order</li> default value: `asc`.
        :type SortOrder: str
        :param _Match: Match method. values: <li>`all`: return records that match all query conditions</li><li>`any`: return records that match any query condition</li> default value: `all`.
        :type Match: str
        """
        self._ZoneId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._SortBy = None
        self._SortOrder = None
        self._Match = None

    @property
    def ZoneId(self):
        """Zone id.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Offset(self):
        """Offset of paginated query. default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number limit of paginated query. default value: 20. maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter conditions. up to 20 values for each filter. detailed filter conditions are as follows: <li>id: filter by dns record id, supports fuzzy search;</li><li>name: filter by dns record name, supports fuzzy search;</li><li>content: filter by dns record content, supports fuzzy search;</li><li>type: filter by dns record type, does not support fuzzy search. valid values:<br>   a: points the domain name to an external ipv4 address, such as 8.8.8.8;<br>   aaaa: points the domain name to an external ipv6 address;<br>   cname: points the domain name to another domain name, which then resolves to the final ip address;<br>   txt: identifies and describes the domain name, commonly used for domain verification and spf records (anti-spam);<br>   ns: if you need to delegate the subdomain to another dns service provider, you need to add an ns record. root domain cannot add ns records;<br>   caa: specifies the ca that can issue certificates for this site;<br>   srv: identifies a server using a specific service, commonly used in microsoft's directory management;<br>   mx: specifies the recipient's mail server.</li><li>ttl: filter by resolution effective time, does not support fuzzy search.</li>.
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        """Sorting basis. values include: <li>`content`: dns record content</li><li>`created-on`: dns record creation time</li><li>`name`: dns record name</li><li>`ttl`: cache time</li><li>`type`: dns record type</li> default sorting is by the combination of `type`, `name`.
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def SortOrder(self):
        """List sort method. values: <li>`asc`: ascending order</li><li>`desc`: sort in descending order</li> default value: `asc`.
        :rtype: str
        """
        return self._SortOrder

    @SortOrder.setter
    def SortOrder(self, SortOrder):
        self._SortOrder = SortOrder

    @property
    def Match(self):
        """Match method. values: <li>`all`: return records that match all query conditions</li><li>`any`: return records that match any query condition</li> default value: `all`.
        :rtype: str
        """
        return self._Match

    @Match.setter
    def Match(self, Match):
        self._Match = Match


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortBy = params.get("SortBy")
        self._SortOrder = params.get("SortOrder")
        self._Match = params.get("Match")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDnsRecordsResponse(AbstractModel):
    """DescribeDnsRecords response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of dns records.
        :type TotalCount: int
        :param _DnsRecords: List of dns records.
        :type DnsRecords: list of DnsRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._DnsRecords = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of dns records.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DnsRecords(self):
        """List of dns records.
        :rtype: list of DnsRecord
        """
        return self._DnsRecords

    @DnsRecords.setter
    def DnsRecords(self, DnsRecords):
        self._DnsRecords = DnsRecords

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DnsRecords") is not None:
            self._DnsRecords = []
            for item in params.get("DnsRecords"):
                obj = DnsRecord()
                obj._deserialize(item)
                self._DnsRecords.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEnvironmentsRequest(AbstractModel):
    """DescribeEnvironments request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEnvironmentsResponse(AbstractModel):
    """DescribeEnvironments response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total environments.
        :type TotalCount: int
        :param _EnvInfos: Environment list.
        :type EnvInfos: list of EnvInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._EnvInfos = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total environments.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EnvInfos(self):
        """Environment list.
        :rtype: list of EnvInfo
        """
        return self._EnvInfos

    @EnvInfos.setter
    def EnvInfos(self, EnvInfos):
        self._EnvInfos = EnvInfos

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EnvInfos") is not None:
            self._EnvInfos = []
            for item in params.get("EnvInfos"):
                obj = EnvInfo()
                obj._deserialize(item)
                self._EnvInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFunctionRulesRequest(AbstractModel):
    """DescribeFunctionRules request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Filters: Filter criteria list. There is an AND relationship between different criteria. The maximum number of Filters.Values is 20. The detailed filter criteria are as follows:
<li>rule-id: Exact match by [rule ID].</li>
<li>function-id: Exact match by [function ID].</li>
<li>remark: Fuzzy match by [rule description].</li>
        :type Filters: list of Filter
        """
        self._ZoneId = None
        self._Filters = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Filters(self):
        """Filter criteria list. There is an AND relationship between different criteria. The maximum number of Filters.Values is 20. The detailed filter criteria are as follows:
<li>rule-id: Exact match by [rule ID].</li>
<li>function-id: Exact match by [function ID].</li>
<li>remark: Fuzzy match by [rule description].</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFunctionRulesResponse(AbstractModel):
    """DescribeFunctionRules response structure.

    """

    def __init__(self):
        r"""
        :param _FunctionRules: Rule details list.
        :type FunctionRules: list of FunctionRule
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FunctionRules = None
        self._RequestId = None

    @property
    def FunctionRules(self):
        """Rule details list.
        :rtype: list of FunctionRule
        """
        return self._FunctionRules

    @FunctionRules.setter
    def FunctionRules(self, FunctionRules):
        self._FunctionRules = FunctionRules

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FunctionRules") is not None:
            self._FunctionRules = []
            for item in params.get("FunctionRules"):
                obj = FunctionRule()
                obj._deserialize(item)
                self._FunctionRules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFunctionRuntimeEnvironmentRequest(AbstractModel):
    """DescribeFunctionRuntimeEnvironment request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _FunctionId: Function ID.
        :type FunctionId: str
        """
        self._ZoneId = None
        self._FunctionId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def FunctionId(self):
        """Function ID.
        :rtype: str
        """
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._FunctionId = params.get("FunctionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFunctionRuntimeEnvironmentResponse(AbstractModel):
    """DescribeFunctionRuntimeEnvironment response structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentVariables: Environment variable list.
        :type EnvironmentVariables: list of FunctionEnvironmentVariable
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EnvironmentVariables = None
        self._RequestId = None

    @property
    def EnvironmentVariables(self):
        """Environment variable list.
        :rtype: list of FunctionEnvironmentVariable
        """
        return self._EnvironmentVariables

    @EnvironmentVariables.setter
    def EnvironmentVariables(self, EnvironmentVariables):
        self._EnvironmentVariables = EnvironmentVariables

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EnvironmentVariables") is not None:
            self._EnvironmentVariables = []
            for item in params.get("EnvironmentVariables"):
                obj = FunctionEnvironmentVariable()
                obj._deserialize(item)
                self._EnvironmentVariables.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFunctionsRequest(AbstractModel):
    """DescribeFunctions request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _FunctionIds: Filter by function ID list.
        :type FunctionIds: list of str
        :param _Filters: Filter criteria list. There is an AND relationship between different criteria. The maximum number of Filters.Values is 20. The detailed filter criteria are as follows:
<li>name: Fuzzy match by [function name].</li>
<li>remark: Fuzzy match by [function description].</li>
        :type Filters: list of Filter
        :param _Offset: The offset of paginated query. Default value: 0.
        :type Offset: int
        :param _Limit: Number limit of paginated query. Default value: 20. Maximum value: 200.
        :type Limit: int
        """
        self._ZoneId = None
        self._FunctionIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def FunctionIds(self):
        """Filter by function ID list.
        :rtype: list of str
        """
        return self._FunctionIds

    @FunctionIds.setter
    def FunctionIds(self, FunctionIds):
        self._FunctionIds = FunctionIds

    @property
    def Filters(self):
        """Filter criteria list. There is an AND relationship between different criteria. The maximum number of Filters.Values is 20. The detailed filter criteria are as follows:
<li>name: Fuzzy match by [function name].</li>
<li>remark: Fuzzy match by [function description].</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """The offset of paginated query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number limit of paginated query. Default value: 20. Maximum value: 200.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._FunctionIds = params.get("FunctionIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFunctionsResponse(AbstractModel):
    """DescribeFunctions response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of functions that meet the query condition.
        :type TotalCount: int
        :param _Functions: Information of all functions that meet the query condition.
        :type Functions: list of Function
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Functions = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of functions that meet the query condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Functions(self):
        """Information of all functions that meet the query condition.
        :rtype: list of Function
        """
        return self._Functions

    @Functions.setter
    def Functions(self, Functions):
        self._Functions = Functions

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Functions") is not None:
            self._Functions = []
            for item in params.get("Functions"):
                obj = Function()
                obj._deserialize(item)
                self._Functions.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHostsSettingRequest(AbstractModel):
    """DescribeHostsSetting request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        :param _Offset: Offset for paginated queries. Default value: 0. Minimum value: 0.
        :type Offset: int
        :param _Limit: Limit on paginated queries. Default value: 100. Maximum value: 1000.
        :type Limit: int
        :param _Filters: Filter conditions. The maximum value for Filters.Values is 20. The detailed conditions are as follows:<li>host: Filter by domain name.</li>
        :type Filters: list of Filter
        """
        self._ZoneId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Offset(self):
        """Offset for paginated queries. Default value: 0. Minimum value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Limit on paginated queries. Default value: 100. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter conditions. The maximum value for Filters.Values is 20. The detailed conditions are as follows:<li>host: Filter by domain name.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHostsSettingResponse(AbstractModel):
    """DescribeHostsSetting response structure.

    """

    def __init__(self):
        r"""
        :param _DetailHosts: List of domain names.
        :type DetailHosts: list of DetailHost
        :param _TotalNumber: Number of domain names
        :type TotalNumber: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DetailHosts = None
        self._TotalNumber = None
        self._RequestId = None

    @property
    def DetailHosts(self):
        """List of domain names.
        :rtype: list of DetailHost
        """
        return self._DetailHosts

    @DetailHosts.setter
    def DetailHosts(self, DetailHosts):
        self._DetailHosts = DetailHosts

    @property
    def TotalNumber(self):
        """Number of domain names
        :rtype: int
        """
        return self._TotalNumber

    @TotalNumber.setter
    def TotalNumber(self, TotalNumber):
        self._TotalNumber = TotalNumber

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DetailHosts") is not None:
            self._DetailHosts = []
            for item in params.get("DetailHosts"):
                obj = DetailHost()
                obj._deserialize(item)
                self._DetailHosts.append(obj)
        self._TotalNumber = params.get("TotalNumber")
        self._RequestId = params.get("RequestId")


class DescribeIPRegionRequest(AbstractModel):
    """DescribeIPRegion request structure.

    """

    def __init__(self):
        r"""
        :param _IPs: List of IPs to be queried, supporting IPV4 and IPV6. Up to 100 can be queried.
        :type IPs: list of str
        """
        self._IPs = None

    @property
    def IPs(self):
        """List of IPs to be queried, supporting IPV4 and IPV6. Up to 100 can be queried.
        :rtype: list of str
        """
        return self._IPs

    @IPs.setter
    def IPs(self, IPs):
        self._IPs = IPs


    def _deserialize(self, params):
        self._IPs = params.get("IPs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIPRegionResponse(AbstractModel):
    """DescribeIPRegion response structure.

    """

    def __init__(self):
        r"""
        :param _IPRegionInfo: List of IP attribution information.
        :type IPRegionInfo: list of IPRegionInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IPRegionInfo = None
        self._RequestId = None

    @property
    def IPRegionInfo(self):
        """List of IP attribution information.
        :rtype: list of IPRegionInfo
        """
        return self._IPRegionInfo

    @IPRegionInfo.setter
    def IPRegionInfo(self, IPRegionInfo):
        self._IPRegionInfo = IPRegionInfo

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IPRegionInfo") is not None:
            self._IPRegionInfo = []
            for item in params.get("IPRegionInfo"):
                obj = IPRegionInfo()
                obj._deserialize(item)
                self._IPRegionInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIdentificationsRequest(AbstractModel):
    """DescribeIdentifications request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter conditions. The maximum value for Filters.Values is 20. The detailed conditions are as follows:<li>zone-name: Filter by site name.</li>
        :type Filters: list of Filter
        :param _Offset: The page offset. Default value: 0
        :type Offset: int
        :param _Limit: The paginated query limit. Default value: 20. Maximum value: 1000.
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """Filter conditions. The maximum value for Filters.Values is 20. The detailed conditions are as follows:<li>zone-name: Filter by site name.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """The page offset. Default value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """The paginated query limit. Default value: 20. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIdentificationsResponse(AbstractModel):
    """DescribeIdentifications response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible sites.
        :type TotalCount: int
        :param _Identifications: The site verification information.
        :type Identifications: list of Identification
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Identifications = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Number of eligible sites.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Identifications(self):
        """The site verification information.
        :rtype: list of Identification
        """
        return self._Identifications

    @Identifications.setter
    def Identifications(self, Identifications):
        self._Identifications = Identifications

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Identifications") is not None:
            self._Identifications = []
            for item in params.get("Identifications"):
                obj = Identification()
                obj._deserialize(item)
                self._Identifications.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeL4ProxyRequest(AbstractModel):
    """DescribeL4Proxy request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the zone where the Layer 4 proxy instance belongs.
        :type ZoneId: str
        :param _Offset: Paginated query offset. Defaults to 0 when not specified.
        :type Offset: int
        :param _Limit: Paginated query limit. Default value: 20. Maximum value: 1000.
        :type Limit: int
        :param _Filters: Filter criteria. The upper limit for Filters.Values is 20. If left empty, all Layer 4 proxy instance information under the current zone ID is returned. The detailed filter criteria are as follows: <li>proxy-id: Filters by Layer 4 proxy instance ID;</li>
<li>ddos-protection-type: Filters by security protection type;</li>

        :type Filters: list of Filter
        """
        self._ZoneId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ZoneId(self):
        """ID of the zone where the Layer 4 proxy instance belongs.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Offset(self):
        """Paginated query offset. Defaults to 0 when not specified.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Paginated query limit. Default value: 20. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter criteria. The upper limit for Filters.Values is 20. If left empty, all Layer 4 proxy instance information under the current zone ID is returned. The detailed filter criteria are as follows: <li>proxy-id: Filters by Layer 4 proxy instance ID;</li>
<li>ddos-protection-type: Filters by security protection type;</li>

        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeL4ProxyResponse(AbstractModel):
    """DescribeL4Proxy response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of Layer 4 proxy instances.
        :type TotalCount: int
        :param _L4Proxies: List of Layer 4 proxy instances.
        :type L4Proxies: list of L4Proxy
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._L4Proxies = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """The number of Layer 4 proxy instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def L4Proxies(self):
        """List of Layer 4 proxy instances.
        :rtype: list of L4Proxy
        """
        return self._L4Proxies

    @L4Proxies.setter
    def L4Proxies(self, L4Proxies):
        self._L4Proxies = L4Proxies

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("L4Proxies") is not None:
            self._L4Proxies = []
            for item in params.get("L4Proxies"):
                obj = L4Proxy()
                obj._deserialize(item)
                self._L4Proxies.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeL4ProxyRulesRequest(AbstractModel):
    """DescribeL4ProxyRules request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _ProxyId: Layer 4 proxy instance ID.
        :type ProxyId: str
        :param _Offset: Paginated query offset. Defaults to 0 when not specified.
        :type Offset: int
        :param _Limit: Paginated query limit. Default value: 20. Maximum value: 1000.
        :type Limit: int
        :param _Filters: Filter criteria. The upper limit of Filters.Values is 20. If it is not filled in, all rule information under the current layer-4 instance will be returned. The detailed filter criteria are as follows: <li>rule-id: filter as per the rules under the layer-4 proxy instance by Rule ID. Rule ID is in the form: rule-31vv7qig0vjy;</li> <li>rule-tag: filter as per the rules under the layer-4 proxy instance by Rule Tag.</li>
        :type Filters: list of Filter
        """
        self._ZoneId = None
        self._ProxyId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ProxyId(self):
        """Layer 4 proxy instance ID.
        :rtype: str
        """
        return self._ProxyId

    @ProxyId.setter
    def ProxyId(self, ProxyId):
        self._ProxyId = ProxyId

    @property
    def Offset(self):
        """Paginated query offset. Defaults to 0 when not specified.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Paginated query limit. Default value: 20. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter criteria. The upper limit of Filters.Values is 20. If it is not filled in, all rule information under the current layer-4 instance will be returned. The detailed filter criteria are as follows: <li>rule-id: filter as per the rules under the layer-4 proxy instance by Rule ID. Rule ID is in the form: rule-31vv7qig0vjy;</li> <li>rule-tag: filter as per the rules under the layer-4 proxy instance by Rule Tag.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ProxyId = params.get("ProxyId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeL4ProxyRulesResponse(AbstractModel):
    """DescribeL4ProxyRules response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total count of forwarding rules.
        :type TotalCount: int
        :param _L4ProxyRules: List of forwarding rules.	
        :type L4ProxyRules: list of L4ProxyRule
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._L4ProxyRules = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """The total count of forwarding rules.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def L4ProxyRules(self):
        """List of forwarding rules.	
        :rtype: list of L4ProxyRule
        """
        return self._L4ProxyRules

    @L4ProxyRules.setter
    def L4ProxyRules(self, L4ProxyRules):
        self._L4ProxyRules = L4ProxyRules

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("L4ProxyRules") is not None:
            self._L4ProxyRules = []
            for item in params.get("L4ProxyRules"):
                obj = L4ProxyRule()
                obj._deserialize(item)
                self._L4ProxyRules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeL7AccRulesRequest(AbstractModel):
    """DescribeL7AccRules request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone id.
        :type ZoneId: str
        :param _Filters: Filter conditions. the upper limit for filters.values is 20. if this parameter is not filled in, the rules under the site are returned in order by default. detailed filtering conditions are as follows:.
<Li>Rule-Id: filter by rule id.</li>.
        :type Filters: list of Filter
        :param _Limit: Number limit of paginated query. default value: 20. maximum value: 1000.
        :type Limit: int
        :param _Offset: Offset of paginated query. default value: 0.
        :type Offset: int
        """
        self._ZoneId = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def ZoneId(self):
        """Zone id.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Filters(self):
        """Filter conditions. the upper limit for filters.values is 20. if this parameter is not filled in, the rules under the site are returned in order by default. detailed filtering conditions are as follows:.
<Li>Rule-Id: filter by rule id.</li>.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        """Number limit of paginated query. default value: 20. maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """Offset of paginated query. default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeL7AccRulesResponse(AbstractModel):
    """DescribeL7AccRules response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of rules.
        :type TotalCount: int
        :param _Rules: Rule list. rules are executed in top-down order. for details, refer to [rule priority](https://intl.cloud.tencent.com/document/product/1552/70901?from_cn_redirect=1#.e4.bc.98.e5.85.88.e7.ba.a7).
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type Rules: list of RuleEngineItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Rules = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of rules.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Rules(self):
        """Rule list. rules are executed in top-down order. for details, refer to [rule priority](https://intl.cloud.tencent.com/document/product/1552/70901?from_cn_redirect=1#.e4.bc.98.e5.85.88.e7.ba.a7).
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: list of RuleEngineItem
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleEngineItem()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeL7AccSettingRequest(AbstractModel):
    """DescribeL7AccSetting request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone id.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        """Zone id.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeL7AccSettingResponse(AbstractModel):
    """DescribeL7AccSetting response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneSetting: Global configuration for site acceleration.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type ZoneSetting: :class:`tencentcloud.teo.v20220901.models.ZoneConfigParameters`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneSetting = None
        self._RequestId = None

    @property
    def ZoneSetting(self):
        """Global configuration for site acceleration.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.ZoneConfigParameters`
        """
        return self._ZoneSetting

    @ZoneSetting.setter
    def ZoneSetting(self, ZoneSetting):
        self._ZoneSetting = ZoneSetting

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ZoneSetting") is not None:
            self._ZoneSetting = ZoneConfigParameters()
            self._ZoneSetting._deserialize(params.get("ZoneSetting"))
        self._RequestId = params.get("RequestId")


class DescribeLoadBalancerListRequest(AbstractModel):
    """DescribeLoadBalancerList request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Offset: Offset of paginated query. Default value: 0.		
        :type Offset: int
        :param _Limit: Paginated query limit. Default value: 20, maximum value: 100.	
        :type Limit: int
        :param _Filters: Filter criteria. The maximum value of Filters.Values is 20. If this parameter is left empty, all LoadBalancer information under the current zone ID will be returned. The detailed filter criteria are as follows:
<li>InstanceName: Filter by LoadBalancer name.</li>
<li>InstanceId: Filter by LoadBalancer ID.</li>

        :type Filters: list of Filter
        """
        self._ZoneId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Offset(self):
        """Offset of paginated query. Default value: 0.		
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Paginated query limit. Default value: 20, maximum value: 100.	
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter criteria. The maximum value of Filters.Values is 20. If this parameter is left empty, all LoadBalancer information under the current zone ID will be returned. The detailed filter criteria are as follows:
<li>InstanceName: Filter by LoadBalancer name.</li>
<li>InstanceId: Filter by LoadBalancer ID.</li>

        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLoadBalancerListResponse(AbstractModel):
    """DescribeLoadBalancerList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of LoadBalancers.
        :type TotalCount: int
        :param _LoadBalancerList: LoadBalancer list.
        :type LoadBalancerList: list of LoadBalancer
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._LoadBalancerList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of LoadBalancers.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LoadBalancerList(self):
        """LoadBalancer list.
        :rtype: list of LoadBalancer
        """
        return self._LoadBalancerList

    @LoadBalancerList.setter
    def LoadBalancerList(self, LoadBalancerList):
        self._LoadBalancerList = LoadBalancerList

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LoadBalancerList") is not None:
            self._LoadBalancerList = []
            for item in params.get("LoadBalancerList"):
                obj = LoadBalancer()
                obj._deserialize(item)
                self._LoadBalancerList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOriginACLRequest(AbstractModel):
    """DescribeOriginACL request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Specifies the site ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        """Specifies the site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOriginACLResponse(AbstractModel):
    """DescribeOriginACL response structure.

    """

    def __init__(self):
        r"""
        :param _OriginACLInfo: Describes the binding relationship between the l7 acceleration domain/l4 proxy instance and the origin server IP range.
        :type OriginACLInfo: :class:`tencentcloud.teo.v20220901.models.OriginACLInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OriginACLInfo = None
        self._RequestId = None

    @property
    def OriginACLInfo(self):
        """Describes the binding relationship between the l7 acceleration domain/l4 proxy instance and the origin server IP range.
        :rtype: :class:`tencentcloud.teo.v20220901.models.OriginACLInfo`
        """
        return self._OriginACLInfo

    @OriginACLInfo.setter
    def OriginACLInfo(self, OriginACLInfo):
        self._OriginACLInfo = OriginACLInfo

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OriginACLInfo") is not None:
            self._OriginACLInfo = OriginACLInfo()
            self._OriginACLInfo._deserialize(params.get("OriginACLInfo"))
        self._RequestId = params.get("RequestId")


class DescribeOriginGroupHealthStatusRequest(AbstractModel):
    """DescribeOriginGroupHealthStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _LBInstanceId: CLB instance ID.
        :type LBInstanceId: str
        :param _OriginGroupIds: Origin server group ID. If left empty, the health status of all origin server groups under a LoadBalancer is obtained by default.
        :type OriginGroupIds: list of str
        """
        self._ZoneId = None
        self._LBInstanceId = None
        self._OriginGroupIds = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def LBInstanceId(self):
        """CLB instance ID.
        :rtype: str
        """
        return self._LBInstanceId

    @LBInstanceId.setter
    def LBInstanceId(self, LBInstanceId):
        self._LBInstanceId = LBInstanceId

    @property
    def OriginGroupIds(self):
        """Origin server group ID. If left empty, the health status of all origin server groups under a LoadBalancer is obtained by default.
        :rtype: list of str
        """
        return self._OriginGroupIds

    @OriginGroupIds.setter
    def OriginGroupIds(self, OriginGroupIds):
        self._OriginGroupIds = OriginGroupIds


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._LBInstanceId = params.get("LBInstanceId")
        self._OriginGroupIds = params.get("OriginGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOriginGroupHealthStatusResponse(AbstractModel):
    """DescribeOriginGroupHealthStatus response structure.

    """

    def __init__(self):
        r"""
        :param _OriginGroupHealthStatusList: Health status of origin servers in an origin server group.
        :type OriginGroupHealthStatusList: list of OriginGroupHealthStatusDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OriginGroupHealthStatusList = None
        self._RequestId = None

    @property
    def OriginGroupHealthStatusList(self):
        """Health status of origin servers in an origin server group.
        :rtype: list of OriginGroupHealthStatusDetail
        """
        return self._OriginGroupHealthStatusList

    @OriginGroupHealthStatusList.setter
    def OriginGroupHealthStatusList(self, OriginGroupHealthStatusList):
        self._OriginGroupHealthStatusList = OriginGroupHealthStatusList

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OriginGroupHealthStatusList") is not None:
            self._OriginGroupHealthStatusList = []
            for item in params.get("OriginGroupHealthStatusList"):
                obj = OriginGroupHealthStatusDetail()
                obj._deserialize(item)
                self._OriginGroupHealthStatusList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOriginGroupRequest(AbstractModel):
    """DescribeOriginGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: (Required) Site ID
        :type ZoneId: str
        :param _Offset: The paginated query offset. Default value: 0
        :type Offset: int
        :param _Limit: Limit on paginated queries. Value range: 1-1000. Default value: 20.
        :type Limit: int
        :param _Filters: Filters. Each filter can have up to 20 entries. See below for details:
<li>`origin-group-id`<br>Filter by the <strong>origin group ID</strong>. Format: `origin-2ccgtb24-7dc5-46s2-9r3e-95825d53dwe3a`<br>Fuzzy query is not supported</li><li>`origin-group-name`<br>Filter by the <strong>origin group name</strong><br>Fuzzy query is supported. When fuzzy query is used, only one origin groupsource site group name is supported</li>
        :type Filters: list of AdvancedFilter
        """
        self._ZoneId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ZoneId(self):
        """(Required) Site ID
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Offset(self):
        """The paginated query offset. Default value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Limit on paginated queries. Value range: 1-1000. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filters. Each filter can have up to 20 entries. See below for details:
<li>`origin-group-id`<br>Filter by the <strong>origin group ID</strong>. Format: `origin-2ccgtb24-7dc5-46s2-9r3e-95825d53dwe3a`<br>Fuzzy query is not supported</li><li>`origin-group-name`<br>Filter by the <strong>origin group name</strong><br>Fuzzy query is supported. When fuzzy query is used, only one origin groupsource site group name is supported</li>
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOriginGroupResponse(AbstractModel):
    """DescribeOriginGroup response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records.
        :type TotalCount: int
        :param _OriginGroups: Origin group information.
        :type OriginGroups: list of OriginGroup
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._OriginGroups = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of records.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def OriginGroups(self):
        """Origin group information.
        :rtype: list of OriginGroup
        """
        return self._OriginGroups

    @OriginGroups.setter
    def OriginGroups(self, OriginGroups):
        self._OriginGroups = OriginGroups

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("OriginGroups") is not None:
            self._OriginGroups = []
            for item in params.get("OriginGroups"):
                obj = OriginGroup()
                obj._deserialize(item)
                self._OriginGroups.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOriginProtectionRequest(AbstractModel):
    """DescribeOriginProtection request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneIds: Set of site IDs to be queried. This is a required parameter.
        :type ZoneIds: list of str
        :param _Filters: Filter conditions. Each filter condition can have up to 20 entries. See below for details:
<li>`need-update`:<br>   Whether <strong>the intermediate IP update is needed for the site</strong>.<br>   Type: String<br>   Required: No<br>   Values:<br>   `true`: Update needed.<br>   `false`: Update not needed.<br></li>
<li>`plan-support`:<br>   Whether <strong>origin protection is supported in the plan</strong>.<br>   Type: String<br>   Required: No<br>   Values:<br>   `true`: Origin protection supported.<br>   `false`: Origin protection not supported.<br></li>
        :type Filters: list of Filter
        :param _Offset: Offset for paginated queries. Default value: 0.
        :type Offset: int
        :param _Limit: Limit on paginated queries. Default value: 20. Maximum value: 1000.
        :type Limit: int
        """
        self._ZoneIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def ZoneIds(self):
        """Set of site IDs to be queried. This is a required parameter.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def Filters(self):
        """Filter conditions. Each filter condition can have up to 20 entries. See below for details:
<li>`need-update`:<br>   Whether <strong>the intermediate IP update is needed for the site</strong>.<br>   Type: String<br>   Required: No<br>   Values:<br>   `true`: Update needed.<br>   `false`: Update not needed.<br></li>
<li>`plan-support`:<br>   Whether <strong>origin protection is supported in the plan</strong>.<br>   Type: String<br>   Required: No<br>   Values:<br>   `true`: Origin protection supported.<br>   `false`: Origin protection not supported.<br></li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """Offset for paginated queries. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Limit on paginated queries. Default value: 20. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ZoneIds = params.get("ZoneIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOriginProtectionResponse(AbstractModel):
    """DescribeOriginProtection response structure.

    """

    def __init__(self):
        r"""
        :param _OriginProtectionInfo: Origin protection configuration.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type OriginProtectionInfo: list of OriginProtectionInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OriginProtectionInfo = None
        self._RequestId = None

    @property
    def OriginProtectionInfo(self):
        """Origin protection configuration.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of OriginProtectionInfo
        """
        return self._OriginProtectionInfo

    @OriginProtectionInfo.setter
    def OriginProtectionInfo(self, OriginProtectionInfo):
        self._OriginProtectionInfo = OriginProtectionInfo

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OriginProtectionInfo") is not None:
            self._OriginProtectionInfo = []
            for item in params.get("OriginProtectionInfo"):
                obj = OriginProtectionInfo()
                obj._deserialize(item)
                self._OriginProtectionInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOverviewL7DataRequest(AbstractModel):
    """DescribeOverviewL7Data request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start time.
        :type StartTime: str
        :param _EndTime: End time.
        :type EndTime: str
        :param _MetricNames: Queried metric. Valid values:
<li>l7Flow_outFlux: EdgeOne response traffic;</li>
<li>l7Flow_inFlux: EdgeOne request traffic;</li>
<li>l7Flow_outBandwidth: EdgeOne response bandwidth;</li>
<li>l7Flow_inBandwidth: EdgeOne request traffic;</li>
<li>l7Flow_hit_outFlux: cache hit traffic;</li>
<li>l7Flow_request: number of access requests;</li>
<li>l7Flow_flux: upstream and downstream traffic of access requests;</li>
<li>l7Flow_bandwidth: upstream and downstream bandwidths of access requests.</li>
        :type MetricNames: list of str
        :param _ZoneIds: Site ID set. This parameter is required.
        :type ZoneIds: list of str
        :param _Domains: Queried domain name set. This parameter has been deprecated.
        :type Domains: list of str
        :param _Protocol: Protocol type of the query. Valid values:
<li>http: HTTP protocol;</li>
<li>https: HTTPS protocol;</li>
<li>http2: HTTP/2 protocol;</li>
<li>all: all protocols.</li>If this parameter is not input, the default value `all` is used. This parameter is not yet effective.
        :type Protocol: str
        :param _Interval: Time granularity of the query. Valid values:
<li>min: 1 minute;</li>
<li>5min: 5 minutes;</li>
<li>hour: 1 hour;</li>
<li>day: 1 day.</li>If this parameter is not input, the granularity will be automatically inferred based on the interval between the start time and end time. Specifically, the granularity value is min, 5min, hour, and day respectively for queries of data within 1 hour, within 2 days, within 7 days, and over 7 days.
        :type Interval: str
        :param _Filters: Filter criteria. The detailed Key values of filter criteria are as follows:
<li>socket:<br>   Filter by [<strong>HTTP protocol type</strong>].<br>   Valid values:<br>   HTTP: HTTP protocol; <br>   HTTPS: HTTPS protocol;<br>   QUIC: QUIC protocol.</li>
<li>domain<br>?? Filter by [<strong>domain name</strong>].</li>
<li>tagKey<br>?? Filter by [<strong>tag key</strong>].</li>
<li>tagValue<br>?? Filter by [<strong>tag value</strong>].</li>
        :type Filters: list of QueryCondition
        :param _Area: Data ownership area. Valid values:
<li>overseas: global (excluding the Chinese mainland) data;</li>
<li>mainland: Chinese mainland data;</li>
<li>global: global data.</li>If this parameter is not input, the default value `global` is used.
        :type Area: str
        """
        self._StartTime = None
        self._EndTime = None
        self._MetricNames = None
        self._ZoneIds = None
        self._Domains = None
        self._Protocol = None
        self._Interval = None
        self._Filters = None
        self._Area = None

    @property
    def StartTime(self):
        """Start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """End time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MetricNames(self):
        """Queried metric. Valid values:
<li>l7Flow_outFlux: EdgeOne response traffic;</li>
<li>l7Flow_inFlux: EdgeOne request traffic;</li>
<li>l7Flow_outBandwidth: EdgeOne response bandwidth;</li>
<li>l7Flow_inBandwidth: EdgeOne request traffic;</li>
<li>l7Flow_hit_outFlux: cache hit traffic;</li>
<li>l7Flow_request: number of access requests;</li>
<li>l7Flow_flux: upstream and downstream traffic of access requests;</li>
<li>l7Flow_bandwidth: upstream and downstream bandwidths of access requests.</li>
        :rtype: list of str
        """
        return self._MetricNames

    @MetricNames.setter
    def MetricNames(self, MetricNames):
        self._MetricNames = MetricNames

    @property
    def ZoneIds(self):
        """Site ID set. This parameter is required.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def Domains(self):
        """Queried domain name set. This parameter has been deprecated.
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Protocol(self):
        """Protocol type of the query. Valid values:
<li>http: HTTP protocol;</li>
<li>https: HTTPS protocol;</li>
<li>http2: HTTP/2 protocol;</li>
<li>all: all protocols.</li>If this parameter is not input, the default value `all` is used. This parameter is not yet effective.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Interval(self):
        """Time granularity of the query. Valid values:
<li>min: 1 minute;</li>
<li>5min: 5 minutes;</li>
<li>hour: 1 hour;</li>
<li>day: 1 day.</li>If this parameter is not input, the granularity will be automatically inferred based on the interval between the start time and end time. Specifically, the granularity value is min, 5min, hour, and day respectively for queries of data within 1 hour, within 2 days, within 7 days, and over 7 days.
        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Filters(self):
        """Filter criteria. The detailed Key values of filter criteria are as follows:
<li>socket:<br>   Filter by [<strong>HTTP protocol type</strong>].<br>   Valid values:<br>   HTTP: HTTP protocol; <br>   HTTPS: HTTPS protocol;<br>   QUIC: QUIC protocol.</li>
<li>domain<br>?? Filter by [<strong>domain name</strong>].</li>
<li>tagKey<br>?? Filter by [<strong>tag key</strong>].</li>
<li>tagValue<br>?? Filter by [<strong>tag value</strong>].</li>
        :rtype: list of QueryCondition
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Area(self):
        """Data ownership area. Valid values:
<li>overseas: global (excluding the Chinese mainland) data;</li>
<li>mainland: Chinese mainland data;</li>
<li>global: global data.</li>If this parameter is not input, the default value `global` is used.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MetricNames = params.get("MetricNames")
        self._ZoneIds = params.get("ZoneIds")
        self._Domains = params.get("Domains")
        self._Protocol = params.get("Protocol")
        self._Interval = params.get("Interval")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryCondition()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOverviewL7DataResponse(AbstractModel):
    """DescribeOverviewL7Data response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries in the query result.
        :type TotalCount: int
        :param _Data: List of time series traffic data in L7 monitoring.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type Data: list of TimingDataRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of entries in the query result.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        """List of time series traffic data in L7 monitoring.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: list of TimingDataRecord
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TimingDataRecord()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrefetchTasksRequest(AbstractModel):
    """DescribePrefetchTasks request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID. This parameter is required.
        :type ZoneId: str
        :param _StartTime: Start time of the query. Either time or job-id is required.
        :type StartTime: str
        :param _EndTime: End time of the query. Either time or job-id is required.
        :type EndTime: str
        :param _Offset: Offset of paginated query. Default value: 0.
        :type Offset: int
        :param _Limit: Number limit of paginated query. Default value: 20. Maximum value: 1000.
        :type Limit: int
        :param _Filters: Filter criteria. The maximum number of Filters.Values is 20. The detailed filter criteria are as follows: <li>job-id: Filter by task ID in the format like 1379afjk91u32h. Multiple values and fuzzy queries are not supported.</li><li>target: Filter by target resource information in the format like http://www.qq.com/1.txt. Multiple values and fuzzy queries are not supported.</li><li>domains: Filter by domain name in the format like www.qq.com. Fuzzy queries are not supported.</li><li>statuses: Filter by task status. Fuzzy queries are not supported. Options:<br>??processing: processing<br>??success: successful<br>??failed: failed<br>??timeout: timed out<br>??invalid: invalid, that is, the response status code of the origin server is not 2xx. Please check the origin server service.</li>
        :type Filters: list of AdvancedFilter
        """
        self._ZoneId = None
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ZoneId(self):
        """Site ID. This parameter is required.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def StartTime(self):
        """Start time of the query. Either time or job-id is required.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """End time of the query. Either time or job-id is required.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        """Offset of paginated query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number limit of paginated query. Default value: 20. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter criteria. The maximum number of Filters.Values is 20. The detailed filter criteria are as follows: <li>job-id: Filter by task ID in the format like 1379afjk91u32h. Multiple values and fuzzy queries are not supported.</li><li>target: Filter by target resource information in the format like http://www.qq.com/1.txt. Multiple values and fuzzy queries are not supported.</li><li>domains: Filter by domain name in the format like www.qq.com. Fuzzy queries are not supported.</li><li>statuses: Filter by task status. Fuzzy queries are not supported. Options:<br>??processing: processing<br>??success: successful<br>??failed: failed<br>??timeout: timed out<br>??invalid: invalid, that is, the response status code of the origin server is not 2xx. Please check the origin server service.</li>
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrefetchTasksResponse(AbstractModel):
    """DescribePrefetchTasks response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of items in the query condition.
        :type TotalCount: int
        :param _Tasks: Task result list.
        :type Tasks: list of Task
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Tasks = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of items in the query condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Tasks(self):
        """Task result list.
        :rtype: list of Task
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = Task()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePurgeTasksRequest(AbstractModel):
    """DescribePurgeTasks request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID. This parameter is required.
        :type ZoneId: str
        :param _StartTime: Start time of the query. Either time or job-id is required.
        :type StartTime: str
        :param _EndTime: End time of the query. Either time or job-id is required.
        :type EndTime: str
        :param _Offset: Offset of paginated query. Default value: 0.
        :type Offset: int
        :param _Limit: Number limit of paginated query. Default value: 20. Maximum value: 1000.
        :type Limit: int
        :param _Filters: Filter criteria. The maximum number of Filters.Values is 20. The detailed filter criteria are as follows:
<li>job-id: Filter by task ID in the format like 1379afjk91u32h. Multiple values and fuzzy queries are not supported.</li>
<li>target: Filter by target resource information in the format like http://www.qq.com/1.txt or tag1. Multiple values are not supported yet. Fuzzy queries are supported.</li>
<li>domains: Filter by domain name in the format like www.qq.com. Fuzzy queries are not supported.</li>
<li>statuses: Filter by task status. Fuzzy queries are not supported. Options:<br>?? processing: processing<br>?? success: successful<br>?? failed: failed<br>?? timeout: timed out</li>
<li>type: Filter by cache clearance type. Multiple values and fuzzy queries are not supported yet. Options: <br>?? purge_url: URL<br>?? purge_prefix: prefix<br>?? purge_all: all cached content<br>?? purge_host: Hostname<br>?? purge_cache_tag: CacheTag</li>
        :type Filters: list of AdvancedFilter
        """
        self._ZoneId = None
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ZoneId(self):
        """Site ID. This parameter is required.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def StartTime(self):
        """Start time of the query. Either time or job-id is required.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """End time of the query. Either time or job-id is required.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        """Offset of paginated query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number limit of paginated query. Default value: 20. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter criteria. The maximum number of Filters.Values is 20. The detailed filter criteria are as follows:
<li>job-id: Filter by task ID in the format like 1379afjk91u32h. Multiple values and fuzzy queries are not supported.</li>
<li>target: Filter by target resource information in the format like http://www.qq.com/1.txt or tag1. Multiple values are not supported yet. Fuzzy queries are supported.</li>
<li>domains: Filter by domain name in the format like www.qq.com. Fuzzy queries are not supported.</li>
<li>statuses: Filter by task status. Fuzzy queries are not supported. Options:<br>?? processing: processing<br>?? success: successful<br>?? failed: failed<br>?? timeout: timed out</li>
<li>type: Filter by cache clearance type. Multiple values and fuzzy queries are not supported yet. Options: <br>?? purge_url: URL<br>?? purge_prefix: prefix<br>?? purge_all: all cached content<br>?? purge_host: Hostname<br>?? purge_cache_tag: CacheTag</li>
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePurgeTasksResponse(AbstractModel):
    """DescribePurgeTasks response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of items in the query condition.
        :type TotalCount: int
        :param _Tasks: Task result list.
        :type Tasks: list of Task
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Tasks = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of items in the query condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Tasks(self):
        """Task result list.
        :rtype: list of Task
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = Task()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRealtimeLogDeliveryTasksRequest(AbstractModel):
    """DescribeRealtimeLogDeliveryTasks request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Offset: The offset of paginated query. Default value: 0.
        :type Offset: int
        :param _Limit: The limit of paginated query. Default value: 20. Maximum value: 1000.
        :type Limit: int
        :param _Filters: Filter conditions. The maximum value for Filters.Values is 20. If this field is not filled in, all the real-time log delivery task information under the current zone-id will be returned. Detailed filter conditions are as follows:
<li>task-id: Filter by real-time log delivery task ID. Fuzzy search is not supported.</li>
<li>task-name: Filter by real-time log delivery task name. Fuzzy search is supported, but only one real-time log delivery task name can be filled in for fuzzy search.</li>
<li>entity-list: Filter by entity corresponding to the real-time log delivery task. Fuzzy search is not supported. Example values: domain.example.com or sid-2s69eb5wcms7.</li>
<li>task-type: Filter by real-time log delivery task type. Fuzzy search is not supported. Optional values:<br>cls: Push to Tencent Cloud CLS;<br>custom_endpoint: Push to a user-defined HTTP(S) address;<br>s3: Push to an AWS S3-compatible bucket address.</li>
        :type Filters: list of AdvancedFilter
        """
        self._ZoneId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Offset(self):
        """The offset of paginated query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """The limit of paginated query. Default value: 20. Maximum value: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter conditions. The maximum value for Filters.Values is 20. If this field is not filled in, all the real-time log delivery task information under the current zone-id will be returned. Detailed filter conditions are as follows:
<li>task-id: Filter by real-time log delivery task ID. Fuzzy search is not supported.</li>
<li>task-name: Filter by real-time log delivery task name. Fuzzy search is supported, but only one real-time log delivery task name can be filled in for fuzzy search.</li>
<li>entity-list: Filter by entity corresponding to the real-time log delivery task. Fuzzy search is not supported. Example values: domain.example.com or sid-2s69eb5wcms7.</li>
<li>task-type: Filter by real-time log delivery task type. Fuzzy search is not supported. Optional values:<br>cls: Push to Tencent Cloud CLS;<br>custom_endpoint: Push to a user-defined HTTP(S) address;<br>s3: Push to an AWS S3-compatible bucket address.</li>
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealtimeLogDeliveryTasksResponse(AbstractModel):
    """DescribeRealtimeLogDeliveryTasks response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of real-time log delivery tasks which match the query conditions.
        :type TotalCount: int
        :param _RealtimeLogDeliveryTasks: The list of all real-time log delivery tasks which match the query conditions.
        :type RealtimeLogDeliveryTasks: list of RealtimeLogDeliveryTask
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RealtimeLogDeliveryTasks = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """The number of real-time log delivery tasks which match the query conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RealtimeLogDeliveryTasks(self):
        """The list of all real-time log delivery tasks which match the query conditions.
        :rtype: list of RealtimeLogDeliveryTask
        """
        return self._RealtimeLogDeliveryTasks

    @RealtimeLogDeliveryTasks.setter
    def RealtimeLogDeliveryTasks(self, RealtimeLogDeliveryTasks):
        self._RealtimeLogDeliveryTasks = RealtimeLogDeliveryTasks

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RealtimeLogDeliveryTasks") is not None:
            self._RealtimeLogDeliveryTasks = []
            for item in params.get("RealtimeLogDeliveryTasks"):
                obj = RealtimeLogDeliveryTask()
                obj._deserialize(item)
                self._RealtimeLogDeliveryTasks.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRulesRequest(AbstractModel):
    """DescribeRules request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site
        :type ZoneId: str
        :param _Filters: Filter criteria. the maximum value of filters.values is 20. the detailed filter criteria are as follows:
.
<Li>Rule-Id: filter by rule id.</li>.
        :type Filters: list of Filter
        """
        self._ZoneId = None
        self._Filters = None

    @property
    def ZoneId(self):
        """ID of the site
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Filters(self):
        """Filter criteria. the maximum value of filters.values is 20. the detailed filter criteria are as follows:
.
<Li>Rule-Id: filter by rule id.</li>.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRulesResponse(AbstractModel):
    """DescribeRules response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site
        :type ZoneId: str
        :param _RuleItems: List of rules. Rules are sorted in order of execution.
        :type RuleItems: list of RuleItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneId = None
        self._RuleItems = None
        self._RequestId = None

    @property
    def ZoneId(self):
        """ID of the site
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RuleItems(self):
        """List of rules. Rules are sorted in order of execution.
        :rtype: list of RuleItem
        """
        return self._RuleItems

    @RuleItems.setter
    def RuleItems(self, RuleItems):
        self._RuleItems = RuleItems

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("RuleItems") is not None:
            self._RuleItems = []
            for item in params.get("RuleItems"):
                obj = RuleItem()
                obj._deserialize(item)
                self._RuleItems.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRulesSettingRequest(AbstractModel):
    """DescribeRulesSetting request structure.

    """


class DescribeRulesSettingResponse(AbstractModel):
    """DescribeRulesSetting response structure.

    """

    def __init__(self):
        r"""
        :param _Actions: List of the settings of the rule engine that can be used for request match and their detailed recommended configuration information.
        :type Actions: list of RulesSettingAction
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Actions = None
        self._RequestId = None

    @property
    def Actions(self):
        """List of the settings of the rule engine that can be used for request match and their detailed recommended configuration information.
        :rtype: list of RulesSettingAction
        """
        return self._Actions

    @Actions.setter
    def Actions(self, Actions):
        self._Actions = Actions

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Actions") is not None:
            self._Actions = []
            for item in params.get("Actions"):
                obj = RulesSettingAction()
                obj._deserialize(item)
                self._Actions.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityIPGroupInfoRequest(AbstractModel):
    """DescribeSecurityIPGroupInfo request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID, used to specify the query scope.
        :type ZoneId: str
        :param _Limit: Maximum number of entries returned in a single response. Default value: 20. Maximum query entries: 1000.
        :type Limit: int
        :param _Offset: The starting entry offset for pagination queries. The default value is 0.
        :type Offset: int
        """
        self._ZoneId = None
        self._Limit = None
        self._Offset = None

    @property
    def ZoneId(self):
        """Site ID, used to specify the query scope.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Limit(self):
        """Maximum number of entries returned in a single response. Default value: 20. Maximum query entries: 1000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """The starting entry offset for pagination queries. The default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityIPGroupInfoResponse(AbstractModel):
    """DescribeSecurityIPGroupInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of IP groups that meet the conditions.
        :type TotalCount: int
        :param _IPGroups: Detailed configuration information of the IP group, including the ID, name, and IP/network segment list of each IP group.
        :type IPGroups: list of IPGroup
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._IPGroups = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """The number of IP groups that meet the conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def IPGroups(self):
        """Detailed configuration information of the IP group, including the ID, name, and IP/network segment list of each IP group.
        :rtype: list of IPGroup
        """
        return self._IPGroups

    @IPGroups.setter
    def IPGroups(self, IPGroups):
        self._IPGroups = IPGroups

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("IPGroups") is not None:
            self._IPGroups = []
            for item in params.get("IPGroups"):
                obj = IPGroup()
                obj._deserialize(item)
                self._IPGroups.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityIPGroupRequest(AbstractModel):
    """DescribeSecurityIPGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Site ID, used to specify the scope of the queried site.
        :type ZoneId: str
        :param _GroupIds: Specifies the security ip group id. <li>when this parameter is provided, only the configuration of the specified security ip group id is queried;</li> <li>when this parameter is not provided, information of all security ip groups under the site is returned.</li>.
        :type GroupIds: list of int
        """
        self._ZoneId = None
        self._GroupIds = None

    @property
    def ZoneId(self):
        """Site ID, used to specify the scope of the queried site.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupIds(self):
        """Specifies the security ip group id. <li>when this parameter is provided, only the configuration of the specified security ip group id is queried;</li> <li>when this parameter is not provided, information of all security ip groups under the site is returned.</li>.
        :rtype: list of int
        """
        return self._GroupIds

    @GroupIds.setter
    def GroupIds(self, GroupIds):
        self._GroupIds = GroupIds


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupIds = params.get("GroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityIPGroupResponse(AbstractModel):
    """DescribeSecurityIPGroup response structure.

    """

    def __init__(self):
        r"""
        :param _IPGroups: Detailed configuration information of security IP groups, including the ID, name, and IP/IP range list information of each security IP group.
        :type IPGroups: list of IPGroup
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IPGroups = None
        self._RequestId = None

    @property
    def IPGroups(self):
        """Detailed configuration information of security IP groups, including the ID, name, and IP/IP range list information of each security IP group.
        :rtype: list of IPGroup
        """
        return self._IPGroups

    @IPGroups.setter
    def IPGroups(self, IPGroups):
        self._IPGroups = IPGroups

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IPGroups") is not None:
            self._IPGroups = []
            for item in params.get("IPGroups"):
                obj = IPGroup()
                obj._deserialize(item)
                self._IPGroups.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityPolicyRequest(AbstractModel):
    """DescribeSecurityPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Entity: `SecurityPolicy` type, the following parameter values can be used for query: <li>`ZoneDefaultPolicy`: used to specify a query for site-level policies;</li> <li>`Template`: used to specify a query for policy templates. the `TemplateId` parameter needs to be specified simultaneously;</li> <li>`Host`: used to specify a query for domain-level policies (note: when using `Host` to specify a domain name service policy, only domain name services or policy templates that have been applied domain-level policies are supported).</li>	
        :type Entity: str
        :param _TemplateId: Specify the policy Template ID. Use this parameter to specify the ID of the policy Template to query the Template configuration when the `Entity` parameter value is set to `Template`.
        :type TemplateId: str
        :param _Host: Specify the domain name. When the `Entity` parameter value is set to `Host`, use the domain-level policy specified by this parameter to query the domain configuration. For example, use `www.example.com` to configure the domain-level policy for that domain name.
        :type Host: str
        """
        self._ZoneId = None
        self._Entity = None
        self._TemplateId = None
        self._Host = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Entity(self):
        """`SecurityPolicy` type, the following parameter values can be used for query: <li>`ZoneDefaultPolicy`: used to specify a query for site-level policies;</li> <li>`Template`: used to specify a query for policy templates. the `TemplateId` parameter needs to be specified simultaneously;</li> <li>`Host`: used to specify a query for domain-level policies (note: when using `Host` to specify a domain name service policy, only domain name services or policy templates that have been applied domain-level policies are supported).</li>	
        :rtype: str
        """
        return self._Entity

    @Entity.setter
    def Entity(self, Entity):
        self._Entity = Entity

    @property
    def TemplateId(self):
        """Specify the policy Template ID. Use this parameter to specify the ID of the policy Template to query the Template configuration when the `Entity` parameter value is set to `Template`.
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Host(self):
        """Specify the domain name. When the `Entity` parameter value is set to `Host`, use the domain-level policy specified by this parameter to query the domain configuration. For example, use `www.example.com` to configure the domain-level policy for that domain name.
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Entity = params.get("Entity")
        self._TemplateId = params.get("TemplateId")
        self._Host = params.get("Host")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityPolicyResponse(AbstractModel):
    """DescribeSecurityPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityPolicy: Security policy configuration.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type SecurityPolicy: :class:`tencentcloud.teo.v20220901.models.SecurityPolicy`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityPolicy = None
        self._RequestId = None

    @property
    def SecurityPolicy(self):
        """Security policy configuration.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityPolicy`
        """
        return self._SecurityPolicy

    @SecurityPolicy.setter
    def SecurityPolicy(self, SecurityPolicy):
        self._SecurityPolicy = SecurityPolicy

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityPolicy") is not None:
            self._SecurityPolicy = SecurityPolicy()
            self._SecurityPolicy._deserialize(params.get("SecurityPolicy"))
        self._RequestId = params.get("RequestId")


class DescribeSecurityTemplateBindingsRequest(AbstractModel):
    """DescribeSecurityTemplateBindings request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: ID of the site to query
        :type ZoneId: str
        :param _TemplateId: ID of the policy template to query.
        :type TemplateId: list of str
        """
        self._ZoneId = None
        self._TemplateId = None

    @property
    def ZoneId(self):
        """ID of the site to query
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TemplateId(self):
        """ID of the policy template to query.
        :rtype: list of str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityTemplateBindingsResponse(AbstractModel):
    """DescribeSecurityTemplateBindings response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityTemplate: Bindings of the specified policy template.

When a domain name of a site is bound with the specified policy template, `TemplateScope` includes the `ZoneId` of the related site and the bindings of the domain name. 

Note: If the template is not bound with any domain name, and there is not any existing binding, `TemplateScope=0` is returned.

In the binding list, the same domain name may appear repeatedly in the `EntityStatus` list with different `Status`. For example, when a domain name is being bound to another policy template, it's marked both `online` and `pending`.
        :type SecurityTemplate: list of SecurityTemplateBinding
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityTemplate = None
        self._RequestId = None

    @property
    def SecurityTemplate(self):
        """Bindings of the specified policy template.

When a domain name of a site is bound with the specified policy template, `TemplateScope` includes the `ZoneId` of the related site and the bindings of the domain name. 

Note: If the template is not bound with any domain name, and there is not any existing binding, `TemplateScope=0` is returned.

In the binding list, the same domain name may appear repeatedly in the `EntityStatus` list with different `Status`. For example, when a domain name is being bound to another policy template, it's marked both `online` and `pending`.
        :rtype: list of SecurityTemplateBinding
        """
        return self._SecurityTemplate

    @SecurityTemplate.setter
    def SecurityTemplate(self, SecurityTemplate):
        self._SecurityTemplate = SecurityTemplate

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityTemplate") is not None:
            self._SecurityTemplate = []
            for item in params.get("SecurityTemplate"):
                obj = SecurityTemplateBinding()
                obj._deserialize(item)
                self._SecurityTemplate.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTimingL4DataRequest(AbstractModel):
    """DescribeTimingL4Data request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :type EndTime: str
        :param _MetricNames: Metric list. Valid values:
<Li>l4Flow_connections: number of concurrent connections;</li>
<Li>l4Flow_flux: total traffic;</li>
<Li>l4Flow_inFlux: inbound traffic;</li>
<Li>l4Flow_outFlux: outbound traffic.</li>
<Li>l4Flow_inBandwidth: inbound peak bandwidth.</li>
<Li>l4Flow_outBandwidth: outbound peak bandwidth.</li>
        :type MetricNames: list of str
        :param _ZoneIds: Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :type ZoneIds: list of str
        :param _ProxyIds: List of L4 proxy IDs. All L4 proxies will be selected if this field is not specified.
        :type ProxyIds: list of str
        :param _Interval: The query granularity. Values:
<li>`min`: 1 minute;</li>
<li>`5min`: 5 minutes;</li>
<li>`hour`: 1 hour;</li>
<li>`day`: 1 day.</li>If this field is not specified, the granularity will be determined based on the query period. <br>Period <= 1 hour: `min`; <br>1 hour < period <= 2 days: `5min`; <br>2 days < period <= 7 days: `hour`; <br>Period > 7 days: `day`.

        :type Interval: str
        :param _Filters: Filter criteria. The detailed key values of filter criteria are as follows:
<li>ruleId: filter by forwarding rule ID.</li>
<li>proxyId: filter by L4 proxy instance ID.</li>
        :type Filters: list of QueryCondition
        :param _Area: Data ownership region. This parameter is deprecated. Please filter data by client region in Filters.country.
        :type Area: str
        """
        self._StartTime = None
        self._EndTime = None
        self._MetricNames = None
        self._ZoneIds = None
        self._ProxyIds = None
        self._Interval = None
        self._Filters = None
        self._Area = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MetricNames(self):
        """Metric list. Valid values:
<Li>l4Flow_connections: number of concurrent connections;</li>
<Li>l4Flow_flux: total traffic;</li>
<Li>l4Flow_inFlux: inbound traffic;</li>
<Li>l4Flow_outFlux: outbound traffic.</li>
<Li>l4Flow_inBandwidth: inbound peak bandwidth.</li>
<Li>l4Flow_outBandwidth: outbound peak bandwidth.</li>
        :rtype: list of str
        """
        return self._MetricNames

    @MetricNames.setter
    def MetricNames(self, MetricNames):
        self._MetricNames = MetricNames

    @property
    def ZoneIds(self):
        """Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def ProxyIds(self):
        """List of L4 proxy IDs. All L4 proxies will be selected if this field is not specified.
        :rtype: list of str
        """
        return self._ProxyIds

    @ProxyIds.setter
    def ProxyIds(self, ProxyIds):
        self._ProxyIds = ProxyIds

    @property
    def Interval(self):
        """The query granularity. Values:
<li>`min`: 1 minute;</li>
<li>`5min`: 5 minutes;</li>
<li>`hour`: 1 hour;</li>
<li>`day`: 1 day.</li>If this field is not specified, the granularity will be determined based on the query period. <br>Period <= 1 hour: `min`; <br>1 hour < period <= 2 days: `5min`; <br>2 days < period <= 7 days: `hour`; <br>Period > 7 days: `day`.

        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Filters(self):
        """Filter criteria. The detailed key values of filter criteria are as follows:
<li>ruleId: filter by forwarding rule ID.</li>
<li>proxyId: filter by L4 proxy instance ID.</li>
        :rtype: list of QueryCondition
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Area(self):
        """Data ownership region. This parameter is deprecated. Please filter data by client region in Filters.country.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MetricNames = params.get("MetricNames")
        self._ZoneIds = params.get("ZoneIds")
        self._ProxyIds = params.get("ProxyIds")
        self._Interval = params.get("Interval")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryCondition()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTimingL4DataResponse(AbstractModel):
    """DescribeTimingL4Data response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _Data: The list of L4 traffic data recorded over time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of TimingDataRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        """The list of L4 traffic data recorded over time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TimingDataRecord
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TimingDataRecord()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTimingL7AnalysisDataRequest(AbstractModel):
    """DescribeTimingL7AnalysisData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :type EndTime: str
        :param _MetricNames: Metric list. Valid values:.
<Li>l7Flow_outFlux: L7 EdgeOne response traffic. Unit: byte;</li>
<Li>l7Flow_inFlux: L7 client request traffic. Unit: byte;</li>
<Li>l7Flow_flux: L7 total traffic (including EdgeOne response traffic and client request traffic). Unit: byte;</li>
<Li>l7Flow_outBandwidth: L7 EdgeOne response bandwidth. Unit: bps;</li>
<Li>l7Flow_inBandwidth: L7 client request bandwidth. Unit: bps;</li>
<Li>l7Flow_bandwidth: L7 total bandwidth (including EdgeOne response bandwidth and client request bandwidth). Unit: bps;</li>
<Li>l7Flow_request: L7 request count. Unit: times;</li>
<Li>l7Flow_avgResponseTime: Average L7 edge response time. Unit: ms (milliseconds);</li>
<Li>l7Flow_avgFirstByteResponseTime: Average L7 edge first byte response time. Unit: ms.</li>
        :type MetricNames: list of str
        :param _ZoneIds: Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :type ZoneIds: list of str
        :param _Interval: Query period granularity. Valid values:
<li>min: 1 minute;</li>
<li>5min: 5 minutes;</li>
<li>hour: 1 hour;</li>
<li>day: 1 day.</li>If this parameter is not filled in, the granularity will be automatically calculated based on the interval between the start time and end time. Specifically, data will be queried with a granularity of min, 5min, hour, and day respectively when the period is no more than 1 hour, no more than 2 days, no more than 7 days, and over 7 days.
        :type Interval: str
        :param _Filters: Filter criteria. The detailed key values of filter criteria are as follows:
<li>country: filter by country/region. The country/region follows the <a href="https://baike.baidu.com/item/ISO%203166-1/5269555">ISO 3166-1 alpha-2</a> standard. Example value: CN.</li>
<li>province: filter by province. This parameter is supported only when the service area is the chinese mainland. refer to the <a href="https://intl.cloud.tencent.com/document/product/228/6316?from_cn_redirect=1#.E5.8C.BA.E5.9F.9F-.2F-.E8.BF.90.E8.90.a5.E5.95.86.E6.98.a0.E5.B0.84.E8.a1.a8">mapping table of provinces within the chinese mainland</a> for province codes. Example value: 22.</li>
<li>isp: filter by isp. This parameter only supports the service area of chinese mainland. The corresponding value options are as follows:<br> 2: china telecom;<br> 26: china unicom;<br> 1046: cmcc;<br> 3947: china tietong;<br> 38: china education network;<br> 43: great wall broadband;<br> 0: other isp.</li>
<Li>domain: filter by subdomain. Example value: www.example.com.</li>
<li>url: filter by url Path. Example value: /content or /content/test.jpg. If you fill in url parameters, you can query the data of the last 30 days at most.</li>
<Li>referer: filter by referer request header. Example value: http://www.example.com/. If the referer parameter is provided, up to 30 days of data can be queried.</li>
<li>resourceType: filter by resource type. The resource type is generally a file suffix. Example value: .jpg. If the resourceType parameter is provided, data from the last 30 days can be queried at most;</li>
<li>protocol: filter by HTTP protocol version. The corresponding value options are as follows:<br> HTTP/1.0;<br> HTTP/1.1;<br> HTTP/2.0;<br> HTTP/3;<br> WebSocket.</li>
<li>socket: filter by HTTP protocol type. The corresponding value options are as follows:<br>HTTP: hypertext transfer protocol;<br>HTTPS: HTTPS protocol;<br>QUIC: QUIC protocol.</li>
<li>statusCode: filter by edge status code. If the statusCode parameter is filled in, data from the last 30 days can be queried at most. The corresponding value options are as follows:<br> 1XX: 1XX type status codes;<br> 2XX: 2XX type status codes;<br> 3XX: 3XX type status codes;<br> 4XX: 4XX type status codes;<br> 5XX: 5XX type status codes;<br> integers within the range [0,600).</li>
<li>browserType: filter by browser type. If the browserType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> Firefox: Firefox browser;<br> Chrome: Chrome browser;<br> Safari: Safari browser;<br> Other: Other browser types;<br> Empty: browser type is Empty;<br> Bot: search engine crawler;<br> MicrosoftEdge: microsoft edge browser;<br> IE: IE browser;<br> Opera: Opera browser;<br> QQBrowser: QQ browser;<br> LBBrowser: LB browser;<br> MaxthonBrowser: Maxthon browser;<br> SouGouBrowser: sogou browser;<br> BIDUBrowser: BIDUBrowser;<br> TaoBrowser: TaoBrowser;<br> UBrowser: UC browser.</li>
<li>deviceType: filter by device type. If the deviceType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> TV: TV device;<br> Tablet: Tablet device;<br> Mobile: Mobile device;<br> Desktop: Desktop device;<br> Other: Other device type;<br> Empty: device type Empty.</li>
<li>operatingSystemType: filter by operating system type. If the operatingSystemType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> Linux: Linux operating system;<br> MacOS: MacOS operating system;<br> Android: Android operating system;<br> IOS: IOS operating system;<br> Windows: Windows operating system;<br> NetBSD: NetBSD;<br> ChromiumOS: ChromiumOS;<br> Bot: Bot: search engine crawler;<br> Other: Other types of operating systems;<br> Empty: operating system is Empty.</li>
<li>tlsVersion: filter by TLS version. If the tlsVersion parameter is input, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> TLS1.0;<br> TLS1.1;<br> TLS1.2;<br> TLS1.3.</li>
<li>ipVersion: filter by IP version. The options for the corresponding value are as follows:<br> 4: IPv4;<br> 6: IPv6.</li>
<li>cacheType: filter by cache status. The options for The corresponding value are as follows:<br>hit: request hits EdgeOne node cache, and resources are provided by node cache. partial cache hit for resources is also recorded as hit.<br>miss: request does not hit EdgeOne node cache, and resources are provided by the origin server.<br>dynamic: requested resources cannot be cached/unconfigured to be cached by node cache, and resources are provided by the origin server.<br>other: unrecognizable cache status. requests responded to by edge functions are recorded as other.</li>
<li>clientIp: filter by client IP. If the clientIp parameter is filled in, data from the last 30 days can be queried at most.</li>
<li>userAgent: filter by User-Agent request header. If the userAgent parameter is filled in, data from the last 30 days can be queried at most.</li>

        :type Filters: list of QueryCondition
        :param _Area: Data ownership region. This parameter is deprecated. Please filter data by client region in Filters.country.
        :type Area: str
        """
        self._StartTime = None
        self._EndTime = None
        self._MetricNames = None
        self._ZoneIds = None
        self._Interval = None
        self._Filters = None
        self._Area = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MetricNames(self):
        """Metric list. Valid values:.
<Li>l7Flow_outFlux: L7 EdgeOne response traffic. Unit: byte;</li>
<Li>l7Flow_inFlux: L7 client request traffic. Unit: byte;</li>
<Li>l7Flow_flux: L7 total traffic (including EdgeOne response traffic and client request traffic). Unit: byte;</li>
<Li>l7Flow_outBandwidth: L7 EdgeOne response bandwidth. Unit: bps;</li>
<Li>l7Flow_inBandwidth: L7 client request bandwidth. Unit: bps;</li>
<Li>l7Flow_bandwidth: L7 total bandwidth (including EdgeOne response bandwidth and client request bandwidth). Unit: bps;</li>
<Li>l7Flow_request: L7 request count. Unit: times;</li>
<Li>l7Flow_avgResponseTime: Average L7 edge response time. Unit: ms (milliseconds);</li>
<Li>l7Flow_avgFirstByteResponseTime: Average L7 edge first byte response time. Unit: ms.</li>
        :rtype: list of str
        """
        return self._MetricNames

    @MetricNames.setter
    def MetricNames(self, MetricNames):
        self._MetricNames = MetricNames

    @property
    def ZoneIds(self):
        """Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def Interval(self):
        """Query period granularity. Valid values:
<li>min: 1 minute;</li>
<li>5min: 5 minutes;</li>
<li>hour: 1 hour;</li>
<li>day: 1 day.</li>If this parameter is not filled in, the granularity will be automatically calculated based on the interval between the start time and end time. Specifically, data will be queried with a granularity of min, 5min, hour, and day respectively when the period is no more than 1 hour, no more than 2 days, no more than 7 days, and over 7 days.
        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Filters(self):
        """Filter criteria. The detailed key values of filter criteria are as follows:
<li>country: filter by country/region. The country/region follows the <a href="https://baike.baidu.com/item/ISO%203166-1/5269555">ISO 3166-1 alpha-2</a> standard. Example value: CN.</li>
<li>province: filter by province. This parameter is supported only when the service area is the chinese mainland. refer to the <a href="https://intl.cloud.tencent.com/document/product/228/6316?from_cn_redirect=1#.E5.8C.BA.E5.9F.9F-.2F-.E8.BF.90.E8.90.a5.E5.95.86.E6.98.a0.E5.B0.84.E8.a1.a8">mapping table of provinces within the chinese mainland</a> for province codes. Example value: 22.</li>
<li>isp: filter by isp. This parameter only supports the service area of chinese mainland. The corresponding value options are as follows:<br> 2: china telecom;<br> 26: china unicom;<br> 1046: cmcc;<br> 3947: china tietong;<br> 38: china education network;<br> 43: great wall broadband;<br> 0: other isp.</li>
<Li>domain: filter by subdomain. Example value: www.example.com.</li>
<li>url: filter by url Path. Example value: /content or /content/test.jpg. If you fill in url parameters, you can query the data of the last 30 days at most.</li>
<Li>referer: filter by referer request header. Example value: http://www.example.com/. If the referer parameter is provided, up to 30 days of data can be queried.</li>
<li>resourceType: filter by resource type. The resource type is generally a file suffix. Example value: .jpg. If the resourceType parameter is provided, data from the last 30 days can be queried at most;</li>
<li>protocol: filter by HTTP protocol version. The corresponding value options are as follows:<br> HTTP/1.0;<br> HTTP/1.1;<br> HTTP/2.0;<br> HTTP/3;<br> WebSocket.</li>
<li>socket: filter by HTTP protocol type. The corresponding value options are as follows:<br>HTTP: hypertext transfer protocol;<br>HTTPS: HTTPS protocol;<br>QUIC: QUIC protocol.</li>
<li>statusCode: filter by edge status code. If the statusCode parameter is filled in, data from the last 30 days can be queried at most. The corresponding value options are as follows:<br> 1XX: 1XX type status codes;<br> 2XX: 2XX type status codes;<br> 3XX: 3XX type status codes;<br> 4XX: 4XX type status codes;<br> 5XX: 5XX type status codes;<br> integers within the range [0,600).</li>
<li>browserType: filter by browser type. If the browserType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> Firefox: Firefox browser;<br> Chrome: Chrome browser;<br> Safari: Safari browser;<br> Other: Other browser types;<br> Empty: browser type is Empty;<br> Bot: search engine crawler;<br> MicrosoftEdge: microsoft edge browser;<br> IE: IE browser;<br> Opera: Opera browser;<br> QQBrowser: QQ browser;<br> LBBrowser: LB browser;<br> MaxthonBrowser: Maxthon browser;<br> SouGouBrowser: sogou browser;<br> BIDUBrowser: BIDUBrowser;<br> TaoBrowser: TaoBrowser;<br> UBrowser: UC browser.</li>
<li>deviceType: filter by device type. If the deviceType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> TV: TV device;<br> Tablet: Tablet device;<br> Mobile: Mobile device;<br> Desktop: Desktop device;<br> Other: Other device type;<br> Empty: device type Empty.</li>
<li>operatingSystemType: filter by operating system type. If the operatingSystemType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> Linux: Linux operating system;<br> MacOS: MacOS operating system;<br> Android: Android operating system;<br> IOS: IOS operating system;<br> Windows: Windows operating system;<br> NetBSD: NetBSD;<br> ChromiumOS: ChromiumOS;<br> Bot: Bot: search engine crawler;<br> Other: Other types of operating systems;<br> Empty: operating system is Empty.</li>
<li>tlsVersion: filter by TLS version. If the tlsVersion parameter is input, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> TLS1.0;<br> TLS1.1;<br> TLS1.2;<br> TLS1.3.</li>
<li>ipVersion: filter by IP version. The options for the corresponding value are as follows:<br> 4: IPv4;<br> 6: IPv6.</li>
<li>cacheType: filter by cache status. The options for The corresponding value are as follows:<br>hit: request hits EdgeOne node cache, and resources are provided by node cache. partial cache hit for resources is also recorded as hit.<br>miss: request does not hit EdgeOne node cache, and resources are provided by the origin server.<br>dynamic: requested resources cannot be cached/unconfigured to be cached by node cache, and resources are provided by the origin server.<br>other: unrecognizable cache status. requests responded to by edge functions are recorded as other.</li>
<li>clientIp: filter by client IP. If the clientIp parameter is filled in, data from the last 30 days can be queried at most.</li>
<li>userAgent: filter by User-Agent request header. If the userAgent parameter is filled in, data from the last 30 days can be queried at most.</li>

        :rtype: list of QueryCondition
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Area(self):
        """Data ownership region. This parameter is deprecated. Please filter data by client region in Filters.country.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MetricNames = params.get("MetricNames")
        self._ZoneIds = params.get("ZoneIds")
        self._Interval = params.get("Interval")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryCondition()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTimingL7AnalysisDataResponse(AbstractModel):
    """DescribeTimingL7AnalysisData response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _Data: The list of L7 traffic data recorded over time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of TimingDataRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        """The list of L7 traffic data recorded over time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TimingDataRecord
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TimingDataRecord()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTimingL7CacheDataRequest(AbstractModel):
    """DescribeTimingL7CacheData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time.
        :type EndTime: str
        :param _MetricNames: The query metric. Values:
<li>l7Cache_outFlux: Response traffic.</li>
<li>l7Cache_request: Response requests.</li>
<li>l7Cache_outBandwidth: Response bandwidth.</li>
        :type MetricNames: list of str
        :param _ZoneIds: ZoneId set. This parameter is required.
        :type ZoneIds: list of str
        :param _Filters: Filter conditions. See below for details: 
<li>`domain`<br> Filter by the <strong>sub-domain name</strong>, such as `test.example.com`<br> Type: String<br> Required: No</li>
<li>`url`<br> Filter by the <strong>URL</strong>, such as `/content`. The query period cannot exceed 30 days. <br> Type: String<br> Required: No</li>
<li>`resourceType`<br> Filter by the <strong>resource file type</strong>, such as `jpg`, `png`. The query period cannot exceed 30 days.<br>Type: String<br> Required: No</li>
<li>cacheType<br>Filter by the <strong>cache hit result</strong>.<br>Type: String<br> Required: No<br> Values: <br> `hit`: Cache hit; <br> `dynamic`: Resource non-cacheable; <br> `miss`: Cache miss</li>
<li>`statusCode`<br> Filter by the <strong> status code</strong>. The query period  cannot exceed 30 days. <br> Type: String<br> Required: No<br> Values: <br> `1XX`: All 1xx status codes;<br> `100`: 100 status code;<br> `101`: 101 status code;<br> `102`: 102 status code;<br> `2XX`: All 2xx status codes;<br> `200`: 200 status code;<br> `201`: 201 status code;<br> `202`: 202 status code;<br> `203`: 203 status code;<br> `204`: 204 status code;<br> `205`: 205 status code;<br> `206`: 206 status code;<br> `207`: 207 status code;<br> `3XX`: All 3xx status codes;<br> `300`: 300 status code;<br> `301`: 301 status code;<br> `302`: 302 status code;<br> `303`: 303 status code;<br> `304`: 304 status code;<br> `305`: 305 status code;<br> `307`: 307 status code;<br> `4XX`: All 4xx status codes;<br> `400`: 400 status code;<br> `401`: 401 status code;<br> `402`: 402 status code;<br> `403`: 403 status code;<br> `404`: 404 status code;<br> `405`: 405 status code;<br> `406`: 406 status code;<br> `407`: 407 status code;<br> `408`: 408 status code;<br> `409`: 409 status code;<br> `410`: 410 status code;<br> `411`: 411 status code;<br> `412`: 412 status code;<br> `412`: 413 status code;<br> `414`: 414 status code;<br> `415`: 415 status code;<br> `416`: 416 status code;<br> `417`: 417 status code;<br>`422`: 422 status code;<br> `423`: 423 status code;<br> `424`: 424 status code;<br> `426`: 426 status code;<br> `451`: 451 status code;<br> `5XX`: All 5xx status codes;<br> `500`: 500 status code;<br> `501`: 501 status code;<br> `502`: 502 status code;<br> `503`: 503 status code;<br> `504`: 504 status code;<br> `505`: 505 status code;<br> `506`: 506 status code;<br> `507`: 507 status code;<br> `510`: 510 status code;<br> `514`: 514 status code;<br> `544`: 544 status code.</li>
<li>`tagKey`:<br> Filter by the <strong>tag key</strong><br> Type: String<br> Required: No</li>
<li>`tagValue`<br> Filter by the <strong>tag value</strong><br> Type: String<br> Required: No</li>
        :type Filters: list of QueryCondition
        :param _Interval: The query time granularity. Values:
<li>`min`: 1 minute;</li>
<li>`5min`: 5 minutes;</li>
<li>`hour`: 1 hour;</li>
<li>`day`: 1 day.</li>If this field is not specified, the granularity will be determined based on the interval between the start time and end time as follows: 1-minute granularity applies for a 1-hour interval, 5-minute granularity for a 2-day interval, 1-hour granularity for a 7-day interval, and 1-day granularity for an interval of over 7 days.
        :type Interval: str
        :param _Area: Geolocation scope. Values:
<li>`overseas`: Regions outside the Chinese mainland</li>
<li>`mainland`: Chinese mainland</li>
<li>`global`: Global</li>If this field is not specified, the default value `global` is used.
        :type Area: str
        """
        self._StartTime = None
        self._EndTime = None
        self._MetricNames = None
        self._ZoneIds = None
        self._Filters = None
        self._Interval = None
        self._Area = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MetricNames(self):
        """The query metric. Values:
<li>l7Cache_outFlux: Response traffic.</li>
<li>l7Cache_request: Response requests.</li>
<li>l7Cache_outBandwidth: Response bandwidth.</li>
        :rtype: list of str
        """
        return self._MetricNames

    @MetricNames.setter
    def MetricNames(self, MetricNames):
        self._MetricNames = MetricNames

    @property
    def ZoneIds(self):
        """ZoneId set. This parameter is required.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def Filters(self):
        """Filter conditions. See below for details: 
<li>`domain`<br> Filter by the <strong>sub-domain name</strong>, such as `test.example.com`<br> Type: String<br> Required: No</li>
<li>`url`<br> Filter by the <strong>URL</strong>, such as `/content`. The query period cannot exceed 30 days. <br> Type: String<br> Required: No</li>
<li>`resourceType`<br> Filter by the <strong>resource file type</strong>, such as `jpg`, `png`. The query period cannot exceed 30 days.<br>Type: String<br> Required: No</li>
<li>cacheType<br>Filter by the <strong>cache hit result</strong>.<br>Type: String<br> Required: No<br> Values: <br> `hit`: Cache hit; <br> `dynamic`: Resource non-cacheable; <br> `miss`: Cache miss</li>
<li>`statusCode`<br> Filter by the <strong> status code</strong>. The query period  cannot exceed 30 days. <br> Type: String<br> Required: No<br> Values: <br> `1XX`: All 1xx status codes;<br> `100`: 100 status code;<br> `101`: 101 status code;<br> `102`: 102 status code;<br> `2XX`: All 2xx status codes;<br> `200`: 200 status code;<br> `201`: 201 status code;<br> `202`: 202 status code;<br> `203`: 203 status code;<br> `204`: 204 status code;<br> `205`: 205 status code;<br> `206`: 206 status code;<br> `207`: 207 status code;<br> `3XX`: All 3xx status codes;<br> `300`: 300 status code;<br> `301`: 301 status code;<br> `302`: 302 status code;<br> `303`: 303 status code;<br> `304`: 304 status code;<br> `305`: 305 status code;<br> `307`: 307 status code;<br> `4XX`: All 4xx status codes;<br> `400`: 400 status code;<br> `401`: 401 status code;<br> `402`: 402 status code;<br> `403`: 403 status code;<br> `404`: 404 status code;<br> `405`: 405 status code;<br> `406`: 406 status code;<br> `407`: 407 status code;<br> `408`: 408 status code;<br> `409`: 409 status code;<br> `410`: 410 status code;<br> `411`: 411 status code;<br> `412`: 412 status code;<br> `412`: 413 status code;<br> `414`: 414 status code;<br> `415`: 415 status code;<br> `416`: 416 status code;<br> `417`: 417 status code;<br>`422`: 422 status code;<br> `423`: 423 status code;<br> `424`: 424 status code;<br> `426`: 426 status code;<br> `451`: 451 status code;<br> `5XX`: All 5xx status codes;<br> `500`: 500 status code;<br> `501`: 501 status code;<br> `502`: 502 status code;<br> `503`: 503 status code;<br> `504`: 504 status code;<br> `505`: 505 status code;<br> `506`: 506 status code;<br> `507`: 507 status code;<br> `510`: 510 status code;<br> `514`: 514 status code;<br> `544`: 544 status code.</li>
<li>`tagKey`:<br> Filter by the <strong>tag key</strong><br> Type: String<br> Required: No</li>
<li>`tagValue`<br> Filter by the <strong>tag value</strong><br> Type: String<br> Required: No</li>
        :rtype: list of QueryCondition
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Interval(self):
        """The query time granularity. Values:
<li>`min`: 1 minute;</li>
<li>`5min`: 5 minutes;</li>
<li>`hour`: 1 hour;</li>
<li>`day`: 1 day.</li>If this field is not specified, the granularity will be determined based on the interval between the start time and end time as follows: 1-minute granularity applies for a 1-hour interval, 5-minute granularity for a 2-day interval, 1-hour granularity for a 7-day interval, and 1-day granularity for an interval of over 7 days.
        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Area(self):
        """Geolocation scope. Values:
<li>`overseas`: Regions outside the Chinese mainland</li>
<li>`mainland`: Chinese mainland</li>
<li>`global`: Global</li>If this field is not specified, the default value `global` is used.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MetricNames = params.get("MetricNames")
        self._ZoneIds = params.get("ZoneIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryCondition()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Interval = params.get("Interval")
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTimingL7CacheDataResponse(AbstractModel):
    """DescribeTimingL7CacheData response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _Data: The list of cached L7 time-series data.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of TimingDataRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        """The list of cached L7 time-series data.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TimingDataRecord
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TimingDataRecord()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTopL7AnalysisDataRequest(AbstractModel):
    """DescribeTopL7AnalysisData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :type EndTime: str
        :param _MetricName: Queried metric. Valid values:
<li> l7Flow_outFlux_country: L7 EdgeOne response traffic aggregated by the country/region dimension;</li>
<li> l7Flow_outFlux_province: L7 EdgeOne response traffic aggregated by the dimension of provinces in chinese mainland;</li>
<li> l7Flow_outFlux_statusCode: L7 EdgeOne response traffic aggregated by the status code dimension;</li>
<li> l7Flow_outFlux_domain: L7 EdgeOne response traffic aggregated by the domain name dimension;</li>
<li>l7Flow_outFlux_url: L7 EdgeOne response traffic aggregated by url path dimension.</li>
<li> l7Flow_outFlux_resourceType: L7 EdgeOne response traffic aggregated by the resource type dimension;</li>
<li> l7Flow_outFlux_sip: L7 EdgeOne response traffic aggregated by the client IP dimension;</li>
<li>l7Flow_outFlux_referers: L7 EdgeOne response traffic aggregated by referer dimension.</li>
<li> l7Flow_outFlux_ua_device: L7 EdgeOne response traffic aggregated by the device type dimension;</li>
<li> l7Flow_outFlux_ua_browser: L7 EdgeOne response traffic aggregated by the browser type dimension;</li>
<li> l7Flow_outFlux_ua_os: L7 EdgeOne response traffic aggregated by the operating system type dimension;</li>
<li> l7Flow_outFlux_ua: L7 EdgeOne response traffic aggregated by the User-Agent dimension;</li>
<li> l7Flow_request_country: L7 request count aggregated by the country/region dimension;</li>
<li> l7Flow_request_province: L7 request count aggregated by the dimension of provinces in the chinese mainland;</li>
<li> l7Flow_request_statusCode: L7 request count aggregated by the status code dimension;</li>
<li> l7Flow_request_domain: L7 request count aggregated by the domain name dimension;</li>
<li>l7Flow_request_url: L7 request count aggregated by url Path dimension.</li>
<li> l7Flow_request_resourceType: L7 request count aggregated by resource type dimension;</li>
<li> l7Flow_request_sip: L7 request count aggregated by the client IP dimension;</li>
<li>l7Flow_request_referer: L7 request count aggregated by referer dimension.</li>
<li> l7Flow_request_ua_device: L7 request count aggregated by the device type dimension;</li>
<li> l7Flow_request_ua_browser: L7 request count aggregated by the browser type dimension;</li>
<li> l7Flow_request_ua_os: L7 request count aggregated by the operating system type dimension.</li>
<li> l7Flow_request_ua: L7 request count aggregated by the User-Agent dimension.</li>
        :type MetricName: str
        :param _ZoneIds: Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :type ZoneIds: list of str
        :param _Limit: Indicates the top N data to be queried. The maximum value is 1000. If this parameter is not input, the default value is 10, indicating querying the top 10 data.
        :type Limit: int
        :param _Filters: Filter criteria. The detailed key values of filter criteria are as follows:
<li>country: filter by country/region. The country/region follows the <a href="https://baike.baidu.com/item/ISO%203166-1/5269555">ISO 3166-1 alpha-2</a> standard. Example value: CN.</li>
<li>province: filter by province. This parameter is supported only when the service area is the chinese mainland. refer to the <a href="https://intl.cloud.tencent.com/document/product/228/6316?from_cn_redirect=1#.E5.8C.BA.E5.9F.9F-.2F-.E8.BF.90.E8.90.a5.E5.95.86.E6.98.a0.E5.B0.84.E8.a1.a8">mapping table of provinces within the chinese mainland</a> for province codes. Example value: 22.</li>
<li>isp: filter by isp. This parameter only supports the service area of chinese mainland. The corresponding value options are as follows:<br> 2: china telecom;<br> 26: china unicom;<br> 1046: cmcc;<br> 3947: china tietong;<br> 38: china education network;<br> 43: great wall broadband;<br> 0: other isp.</li>
<Li>domain: filter by subdomain. Example value: www.example.com.</li>
<li>url: filter by url Path. Example value: /content or /content/test.jpg. If you fill in url parameters, you can query the data of the last 30 days at most.</li>
<Li>referer: filter by referer request header. Example value: http://www.example.com/. If the referer parameter is provided, up to 30 days of data can be queried.</li>
<li>resourceType: filter by resource type. The resource type is generally a file suffix. Example value: .jpg. If the resourceType parameter is provided, data from the last 30 days can be queried at most;</li>
<li>protocol: filter by HTTP protocol version. The corresponding value options are as follows:<br> HTTP/1.0;<br> HTTP/1.1;<br> HTTP/2.0;<br> HTTP/3;<br> WebSocket.</li>
<li>socket: filter by HTTP protocol type. The corresponding value options are as follows:<br>HTTP: hypertext transfer protocol;<br>HTTPS: HTTPS protocol;<br>QUIC: QUIC protocol.</li>
<li>statusCode: filter by edge status code. If the statusCode parameter is filled in, data from the last 30 days can be queried at most. The corresponding value options are as follows:<br> 1XX: 1XX type status codes;<br> 2XX: 2XX type status codes;<br> 3XX: 3XX type status codes;<br> 4XX: 4XX type status codes;<br> 5XX: 5XX type status codes;<br> integers within the range [0,600).</li>
<li>browserType: filter by browser type. If the browserType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> Firefox: Firefox browser;<br> Chrome: Chrome browser;<br> Safari: Safari browser;<br> Other: Other browser types;<br> Empty: browser type is Empty;<br> Bot: search engine crawler;<br> MicrosoftEdge: microsoft edge browser;<br> IE: IE browser;<br> Opera: Opera browser;<br> QQBrowser: QQ browser;<br> LBBrowser: LB browser;<br> MaxthonBrowser: Maxthon browser;<br> SouGouBrowser: sogou browser;<br> BIDUBrowser: BIDUBrowser;<br> TaoBrowser: TaoBrowser;<br> UBrowser: UC browser.</li>
<li>deviceType: filter by device type. If the deviceType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> TV: TV device;<br> Tablet: Tablet device;<br> Mobile: Mobile device;<br> Desktop: Desktop device;<br> Other: Other device type;<br> Empty: device type Empty.</li>
<li>operatingSystemType: filter by operating system type. If the operatingSystemType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> Linux: Linux operating system;<br> MacOS: MacOS operating system;<br> Android: Android operating system;<br> IOS: IOS operating system;<br> Windows: Windows operating system;<br> NetBSD: NetBSD;<br> ChromiumOS: ChromiumOS;<br> Bot: Bot: search engine crawler;<br> Other: Other types of operating systems;<br> Empty: operating system is Empty.</li>
<li>tlsVersion: filter by TLS version. If the tlsVersion parameter is input, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> TLS1.0;<br> TLS1.1;<br> TLS1.2;<br> TLS1.3.</li>
<li>ipVersion: filter by IP version. The options for the corresponding value are as follows:<br> 4: IPv4;<br> 6: IPv6.</li>
<li>cacheType: filter by cache status. The options for The corresponding value are as follows:<br>hit: request hits EdgeOne node cache, and resources are provided by node cache. partial cache hit for resources is also recorded as hit.<br>miss: request does not hit EdgeOne node cache, and resources are provided by the origin server.<br>dynamic: requested resources cannot be cached/unconfigured to be cached by node cache, and resources are provided by the origin server.<br>other: unrecognizable cache status. requests responded to by edge functions are recorded as other.</li>
<li>clientIp: filter by client IP. If the clientIp parameter is filled in, data from the last 30 days can be queried at most.</li>
<li>userAgent: filter by User-Agent request header. If the userAgent parameter is filled in, data from the last 30 days can be queried at most.</li>

        :type Filters: list of QueryCondition
        :param _Interval: Query period granularity. Valid values:
<li>min: 1 minute;</li>
<li>5min: 5 minutes;</li>
<li>hour: 1 hour;</li>
<li>day: 1 day.</li>If this parameter is not filled in, the granularity will be automatically calculated based on the interval between the start time and end time. Specifically, data will be queried with a granularity of min, 5min, hour, and day respectively when the period is no more than 2 hours, no more than 2 days, no more than 7 days, and over 7 days.
        :type Interval: str
        :param _Area: Data ownership region. this parameter is deprecated. Please filter data by client region in Filters.country.
        :type Area: str
        """
        self._StartTime = None
        self._EndTime = None
        self._MetricName = None
        self._ZoneIds = None
        self._Limit = None
        self._Filters = None
        self._Interval = None
        self._Area = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time. The query time range (`EndTime` - `StartTime`) must be less than or equal to 31 days.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MetricName(self):
        """Queried metric. Valid values:
<li> l7Flow_outFlux_country: L7 EdgeOne response traffic aggregated by the country/region dimension;</li>
<li> l7Flow_outFlux_province: L7 EdgeOne response traffic aggregated by the dimension of provinces in chinese mainland;</li>
<li> l7Flow_outFlux_statusCode: L7 EdgeOne response traffic aggregated by the status code dimension;</li>
<li> l7Flow_outFlux_domain: L7 EdgeOne response traffic aggregated by the domain name dimension;</li>
<li>l7Flow_outFlux_url: L7 EdgeOne response traffic aggregated by url path dimension.</li>
<li> l7Flow_outFlux_resourceType: L7 EdgeOne response traffic aggregated by the resource type dimension;</li>
<li> l7Flow_outFlux_sip: L7 EdgeOne response traffic aggregated by the client IP dimension;</li>
<li>l7Flow_outFlux_referers: L7 EdgeOne response traffic aggregated by referer dimension.</li>
<li> l7Flow_outFlux_ua_device: L7 EdgeOne response traffic aggregated by the device type dimension;</li>
<li> l7Flow_outFlux_ua_browser: L7 EdgeOne response traffic aggregated by the browser type dimension;</li>
<li> l7Flow_outFlux_ua_os: L7 EdgeOne response traffic aggregated by the operating system type dimension;</li>
<li> l7Flow_outFlux_ua: L7 EdgeOne response traffic aggregated by the User-Agent dimension;</li>
<li> l7Flow_request_country: L7 request count aggregated by the country/region dimension;</li>
<li> l7Flow_request_province: L7 request count aggregated by the dimension of provinces in the chinese mainland;</li>
<li> l7Flow_request_statusCode: L7 request count aggregated by the status code dimension;</li>
<li> l7Flow_request_domain: L7 request count aggregated by the domain name dimension;</li>
<li>l7Flow_request_url: L7 request count aggregated by url Path dimension.</li>
<li> l7Flow_request_resourceType: L7 request count aggregated by resource type dimension;</li>
<li> l7Flow_request_sip: L7 request count aggregated by the client IP dimension;</li>
<li>l7Flow_request_referer: L7 request count aggregated by referer dimension.</li>
<li> l7Flow_request_ua_device: L7 request count aggregated by the device type dimension;</li>
<li> l7Flow_request_ua_browser: L7 request count aggregated by the browser type dimension;</li>
<li> l7Flow_request_ua_os: L7 request count aggregated by the operating system type dimension.</li>
<li> l7Flow_request_ua: L7 request count aggregated by the User-Agent dimension.</li>
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName

    @property
    def ZoneIds(self):
        """Zone ID set. This parameter is required. A maximum of 100 zone IDs can be passed in. If you need to query data for all zones under the Tencent Cloud main account, please use "*" instead. To query account-level data, you need to have full resource permissions for all zones of this interface.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def Limit(self):
        """Indicates the top N data to be queried. The maximum value is 1000. If this parameter is not input, the default value is 10, indicating querying the top 10 data.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter criteria. The detailed key values of filter criteria are as follows:
<li>country: filter by country/region. The country/region follows the <a href="https://baike.baidu.com/item/ISO%203166-1/5269555">ISO 3166-1 alpha-2</a> standard. Example value: CN.</li>
<li>province: filter by province. This parameter is supported only when the service area is the chinese mainland. refer to the <a href="https://intl.cloud.tencent.com/document/product/228/6316?from_cn_redirect=1#.E5.8C.BA.E5.9F.9F-.2F-.E8.BF.90.E8.90.a5.E5.95.86.E6.98.a0.E5.B0.84.E8.a1.a8">mapping table of provinces within the chinese mainland</a> for province codes. Example value: 22.</li>
<li>isp: filter by isp. This parameter only supports the service area of chinese mainland. The corresponding value options are as follows:<br> 2: china telecom;<br> 26: china unicom;<br> 1046: cmcc;<br> 3947: china tietong;<br> 38: china education network;<br> 43: great wall broadband;<br> 0: other isp.</li>
<Li>domain: filter by subdomain. Example value: www.example.com.</li>
<li>url: filter by url Path. Example value: /content or /content/test.jpg. If you fill in url parameters, you can query the data of the last 30 days at most.</li>
<Li>referer: filter by referer request header. Example value: http://www.example.com/. If the referer parameter is provided, up to 30 days of data can be queried.</li>
<li>resourceType: filter by resource type. The resource type is generally a file suffix. Example value: .jpg. If the resourceType parameter is provided, data from the last 30 days can be queried at most;</li>
<li>protocol: filter by HTTP protocol version. The corresponding value options are as follows:<br> HTTP/1.0;<br> HTTP/1.1;<br> HTTP/2.0;<br> HTTP/3;<br> WebSocket.</li>
<li>socket: filter by HTTP protocol type. The corresponding value options are as follows:<br>HTTP: hypertext transfer protocol;<br>HTTPS: HTTPS protocol;<br>QUIC: QUIC protocol.</li>
<li>statusCode: filter by edge status code. If the statusCode parameter is filled in, data from the last 30 days can be queried at most. The corresponding value options are as follows:<br> 1XX: 1XX type status codes;<br> 2XX: 2XX type status codes;<br> 3XX: 3XX type status codes;<br> 4XX: 4XX type status codes;<br> 5XX: 5XX type status codes;<br> integers within the range [0,600).</li>
<li>browserType: filter by browser type. If the browserType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> Firefox: Firefox browser;<br> Chrome: Chrome browser;<br> Safari: Safari browser;<br> Other: Other browser types;<br> Empty: browser type is Empty;<br> Bot: search engine crawler;<br> MicrosoftEdge: microsoft edge browser;<br> IE: IE browser;<br> Opera: Opera browser;<br> QQBrowser: QQ browser;<br> LBBrowser: LB browser;<br> MaxthonBrowser: Maxthon browser;<br> SouGouBrowser: sogou browser;<br> BIDUBrowser: BIDUBrowser;<br> TaoBrowser: TaoBrowser;<br> UBrowser: UC browser.</li>
<li>deviceType: filter by device type. If the deviceType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> TV: TV device;<br> Tablet: Tablet device;<br> Mobile: Mobile device;<br> Desktop: Desktop device;<br> Other: Other device type;<br> Empty: device type Empty.</li>
<li>operatingSystemType: filter by operating system type. If the operatingSystemType parameter is filled in, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> Linux: Linux operating system;<br> MacOS: MacOS operating system;<br> Android: Android operating system;<br> IOS: IOS operating system;<br> Windows: Windows operating system;<br> NetBSD: NetBSD;<br> ChromiumOS: ChromiumOS;<br> Bot: Bot: search engine crawler;<br> Other: Other types of operating systems;<br> Empty: operating system is Empty.</li>
<li>tlsVersion: filter by TLS version. If the tlsVersion parameter is input, data from the last 30 days can be queried at most. The options for The corresponding value are as follows:<br> TLS1.0;<br> TLS1.1;<br> TLS1.2;<br> TLS1.3.</li>
<li>ipVersion: filter by IP version. The options for the corresponding value are as follows:<br> 4: IPv4;<br> 6: IPv6.</li>
<li>cacheType: filter by cache status. The options for The corresponding value are as follows:<br>hit: request hits EdgeOne node cache, and resources are provided by node cache. partial cache hit for resources is also recorded as hit.<br>miss: request does not hit EdgeOne node cache, and resources are provided by the origin server.<br>dynamic: requested resources cannot be cached/unconfigured to be cached by node cache, and resources are provided by the origin server.<br>other: unrecognizable cache status. requests responded to by edge functions are recorded as other.</li>
<li>clientIp: filter by client IP. If the clientIp parameter is filled in, data from the last 30 days can be queried at most.</li>
<li>userAgent: filter by User-Agent request header. If the userAgent parameter is filled in, data from the last 30 days can be queried at most.</li>

        :rtype: list of QueryCondition
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Interval(self):
        """Query period granularity. Valid values:
<li>min: 1 minute;</li>
<li>5min: 5 minutes;</li>
<li>hour: 1 hour;</li>
<li>day: 1 day.</li>If this parameter is not filled in, the granularity will be automatically calculated based on the interval between the start time and end time. Specifically, data will be queried with a granularity of min, 5min, hour, and day respectively when the period is no more than 2 hours, no more than 2 days, no more than 7 days, and over 7 days.
        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Area(self):
        """Data ownership region. this parameter is deprecated. Please filter data by client region in Filters.country.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MetricName = params.get("MetricName")
        self._ZoneIds = params.get("ZoneIds")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryCondition()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Interval = params.get("Interval")
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopL7AnalysisDataResponse(AbstractModel):
    """DescribeTopL7AnalysisData response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _Data: The top N data list obtained from the statistics of L7 access data by a specified dimension MetricName.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :type Data: list of TopDataRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        """The top N data list obtained from the statistics of L7 access data by a specified dimension MetricName.
Note: This field may return null, which indicates a failure to obtain a valid value.
        :rtype: list of TopDataRecord
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TopDataRecord()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTopL7CacheDataRequest(AbstractModel):
    """DescribeTopL7CacheData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time.
        :type EndTime: str
        :param _MetricName: The query metric. Values:
<li>l7Cache_outFlux_domain: Host/Domain name;</li>
<li>l7Cache_outFlux_url: URL address;</li>
<li>l7Cache_outFlux_resourceType: Resource type;</li>
<li>l7Cache_outFlux_statusCode: Status code.</li>
        :type MetricName: str
        :param _ZoneIds: ZoneId set. This parameter is required.
        :type ZoneIds: list of str
        :param _Limit: The number of data entries to be queried. The maximum value is 1000. If it is not specified, the value 10 is used by default, indicating that the top 10 data entries.
        :type Limit: int
        :param _Filters: Filter conditions. See below for details: 
<li>`domain`<br> Filter by the <strong>sub-domain name</strong>, such as `test.example.com`<br> Type: String<br> Required: No</li>
<li>`url`<br> Filter by the <strong>URL</strong>, such as `/content`. The query period cannot exceed 30 days. <br> Type: String<br> Required: No</li>
<li>`resourceType`<br> Filter by the <strong>resource file type</strong>, such as `jpg`, `png`. The query period cannot exceed 30 days.<br>Type: String<br> Required: No</li>
<li>cacheType<br>Filter by the <strong>cache hit result</strong>.<br>Type: String<br> Required: No<br> Values: <br> `hit`: Cache hit; <br> `dynamic`: Resource non-cacheable; <br> `miss`: Cache miss</li>
<li>`statusCode`<br> Filter by the <strong> status code</strong>. The query period  cannot exceed 30 days. <br> Type: String<br> Required: No<br> Values: <br> `1XX`: All 1xx status codes;<br> `100`: 100 status code;<br> `101`: 101 status code;<br> `102`: 102 status code;<br> `2XX`: All 2xx status codes;<br> `200`: 200 status code;<br> `201`: 201 status code;<br> `202`: 202 status code;<br> `203`: 203 status code;<br> `204`: 204 status code;<br> `205`: 205 status code;<br> `206`: 206 status code;<br> `207`: 207 status code;<br> `3XX`: All 3xx status codes;<br> `300`: 300 status code;<br> `301`: 301 status code;<br> `302`: 302 status code;<br> `303`: 303 status code;<br> `304`: 304 status code;<br> `305`: 305 status code;<br> `307`: 307 status code;<br> `4XX`: All 4xx status codes;<br> `400`: 400 status code;<br> `401`: 401 status code;<br> `402`: 402 status code;<br> `403`: 403 status code;<br> `404`: 404 status code;<br> `405`: 405 status code;<br> `406`: 406 status code;<br> `407`: 407 status code;<br> `408`: 408 status code;<br> `409`: 409 status code;<br> `410`: 410 status code;<br> `411`: 411 status code;<br> `412`: 412 status code;<br> `412`: 413 status code;<br> `414`: 414 status code;<br> `415`: 415 status code;<br> `416`: 416 status code;<br> `417`: 417 status code;<br>`422`: 422 status code;<br> `423`: 423 status code;<br> `424`: 424 status code;<br> `426`: 426 status code;<br> `451`: 451 status code;<br> `5XX`: All 5xx status codes;<br> `500`: 500 status code;<br> `501`: 501 status code;<br> `502`: 502 status code;<br> `503`: 503 status code;<br> `504`: 504 status code;<br> `505`: 505 status code;<br> `506`: 506 status code;<br> `507`: 507 status code;<br> `510`: 510 status code;<br> `514`: 514 status code;<br> `544`: 544 status code.</li>
<li>`tagKey`:<br> Filter by the <strong>tag key</strong><br> Type: String<br> Required: No</li>
<li>`tagValue`<br> Filter by the <strong>tag value</strong><br> Type: String<br> Required: No</li>
        :type Filters: list of QueryCondition
        :param _Interval: The query time granularity. Values:
<li>`min`: 1 minute;</li>
<li>`5min`: 5 minutes;</li>
<li>`hour`: 1 hour;</li>
<li>`day`: 1 day.</li>If this field is not specified, the granularity will be determined based on the interval between the start time and end time as follows: 1-minute granularity applies for a 1-hour interval, 5-minute granularity for a 2-day interval, 1-hour granularity for a 7-day interval, and 1-day granularity for an interval of over 7 days.
        :type Interval: str
        :param _Area: Geolocation scope. Values:
<li>`overseas`: Regions outside the Chinese mainland</li>
<li>`mainland`: Chinese mainland</li>
<li>`global`: Global</li>If this field is not specified, the default value `global` is used.
        :type Area: str
        """
        self._StartTime = None
        self._EndTime = None
        self._MetricName = None
        self._ZoneIds = None
        self._Limit = None
        self._Filters = None
        self._Interval = None
        self._Area = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MetricName(self):
        """The query metric. Values:
<li>l7Cache_outFlux_domain: Host/Domain name;</li>
<li>l7Cache_outFlux_url: URL address;</li>
<li>l7Cache_outFlux_resourceType: Resource type;</li>
<li>l7Cache_outFlux_statusCode: Status code.</li>
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName

    @property
    def ZoneIds(self):
        """ZoneId set. This parameter is required.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def Limit(self):
        """The number of data entries to be queried. The maximum value is 1000. If it is not specified, the value 10 is used by default, indicating that the top 10 data entries.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter conditions. See below for details: 
<li>`domain`<br> Filter by the <strong>sub-domain name</strong>, such as `test.example.com`<br> Type: String<br> Required: No</li>
<li>`url`<br> Filter by the <strong>URL</strong>, such as `/content`. The query period cannot exceed 30 days. <br> Type: String<br> Required: No</li>
<li>`resourceType`<br> Filter by the <strong>resource file type</strong>, such as `jpg`, `png`. The query period cannot exceed 30 days.<br>Type: String<br> Required: No</li>
<li>cacheType<br>Filter by the <strong>cache hit result</strong>.<br>Type: String<br> Required: No<br> Values: <br> `hit`: Cache hit; <br> `dynamic`: Resource non-cacheable; <br> `miss`: Cache miss</li>
<li>`statusCode`<br> Filter by the <strong> status code</strong>. The query period  cannot exceed 30 days. <br> Type: String<br> Required: No<br> Values: <br> `1XX`: All 1xx status codes;<br> `100`: 100 status code;<br> `101`: 101 status code;<br> `102`: 102 status code;<br> `2XX`: All 2xx status codes;<br> `200`: 200 status code;<br> `201`: 201 status code;<br> `202`: 202 status code;<br> `203`: 203 status code;<br> `204`: 204 status code;<br> `205`: 205 status code;<br> `206`: 206 status code;<br> `207`: 207 status code;<br> `3XX`: All 3xx status codes;<br> `300`: 300 status code;<br> `301`: 301 status code;<br> `302`: 302 status code;<br> `303`: 303 status code;<br> `304`: 304 status code;<br> `305`: 305 status code;<br> `307`: 307 status code;<br> `4XX`: All 4xx status codes;<br> `400`: 400 status code;<br> `401`: 401 status code;<br> `402`: 402 status code;<br> `403`: 403 status code;<br> `404`: 404 status code;<br> `405`: 405 status code;<br> `406`: 406 status code;<br> `407`: 407 status code;<br> `408`: 408 status code;<br> `409`: 409 status code;<br> `410`: 410 status code;<br> `411`: 411 status code;<br> `412`: 412 status code;<br> `412`: 413 status code;<br> `414`: 414 status code;<br> `415`: 415 status code;<br> `416`: 416 status code;<br> `417`: 417 status code;<br>`422`: 422 status code;<br> `423`: 423 status code;<br> `424`: 424 status code;<br> `426`: 426 status code;<br> `451`: 451 status code;<br> `5XX`: All 5xx status codes;<br> `500`: 500 status code;<br> `501`: 501 status code;<br> `502`: 502 status code;<br> `503`: 503 status code;<br> `504`: 504 status code;<br> `505`: 505 status code;<br> `506`: 506 status code;<br> `507`: 507 status code;<br> `510`: 510 status code;<br> `514`: 514 status code;<br> `544`: 544 status code.</li>
<li>`tagKey`:<br> Filter by the <strong>tag key</strong><br> Type: String<br> Required: No</li>
<li>`tagValue`<br> Filter by the <strong>tag value</strong><br> Type: String<br> Required: No</li>
        :rtype: list of QueryCondition
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Interval(self):
        """The query time granularity. Values:
<li>`min`: 1 minute;</li>
<li>`5min`: 5 minutes;</li>
<li>`hour`: 1 hour;</li>
<li>`day`: 1 day.</li>If this field is not specified, the granularity will be determined based on the interval between the start time and end time as follows: 1-minute granularity applies for a 1-hour interval, 5-minute granularity for a 2-day interval, 1-hour granularity for a 7-day interval, and 1-day granularity for an interval of over 7 days.
        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Area(self):
        """Geolocation scope. Values:
<li>`overseas`: Regions outside the Chinese mainland</li>
<li>`mainland`: Chinese mainland</li>
<li>`global`: Global</li>If this field is not specified, the default value `global` is used.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MetricName = params.get("MetricName")
        self._ZoneIds = params.get("ZoneIds")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryCondition()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Interval = params.get("Interval")
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopL7CacheDataResponse(AbstractModel):
    """DescribeTopL7CacheData response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _Data: The list of cached L7 top-ranked traffic data.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of TopDataRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        """The list of cached L7 top-ranked traffic data.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TopDataRecord
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TopDataRecord()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWebSecurityTemplateRequest(AbstractModel):
    """DescribeWebSecurityTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID. The zone to which the target policy template belongs for access control. Use the DescribeWebSecurityTemplates interface to query the zone of the policy template.
        :type ZoneId: str
        :param _TemplateId: Policy template ID.
        :type TemplateId: str
        """
        self._ZoneId = None
        self._TemplateId = None

    @property
    def ZoneId(self):
        """Zone ID. The zone to which the target policy template belongs for access control. Use the DescribeWebSecurityTemplates interface to query the zone of the policy template.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TemplateId(self):
        """Policy template ID.
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWebSecurityTemplateResponse(AbstractModel):
    """DescribeWebSecurityTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityPolicy: Web Security policy template configuration. Bot management configuration is not currently supported (under development).
        :type SecurityPolicy: :class:`tencentcloud.teo.v20220901.models.SecurityPolicy`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityPolicy = None
        self._RequestId = None

    @property
    def SecurityPolicy(self):
        """Web Security policy template configuration. Bot management configuration is not currently supported (under development).
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityPolicy`
        """
        return self._SecurityPolicy

    @SecurityPolicy.setter
    def SecurityPolicy(self, SecurityPolicy):
        self._SecurityPolicy = SecurityPolicy

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityPolicy") is not None:
            self._SecurityPolicy = SecurityPolicy()
            self._SecurityPolicy._deserialize(params.get("SecurityPolicy"))
        self._RequestId = params.get("RequestId")


class DescribeWebSecurityTemplatesRequest(AbstractModel):
    """DescribeWebSecurityTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneIds: List of zone IDs. A maximum of 100 zones can be queried in a single request.
        :type ZoneIds: list of str
        """
        self._ZoneIds = None

    @property
    def ZoneIds(self):
        """List of zone IDs. A maximum of 100 zones can be queried in a single request.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds


    def _deserialize(self, params):
        self._ZoneIds = params.get("ZoneIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWebSecurityTemplatesResponse(AbstractModel):
    """DescribeWebSecurityTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of policy templates.
        :type TotalCount: int
        :param _SecurityPolicyTemplates: List of policy templates.
        :type SecurityPolicyTemplates: list of SecurityPolicyTemplateInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SecurityPolicyTemplates = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of policy templates.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SecurityPolicyTemplates(self):
        """List of policy templates.
        :rtype: list of SecurityPolicyTemplateInfo
        """
        return self._SecurityPolicyTemplates

    @SecurityPolicyTemplates.setter
    def SecurityPolicyTemplates(self, SecurityPolicyTemplates):
        self._SecurityPolicyTemplates = SecurityPolicyTemplates

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SecurityPolicyTemplates") is not None:
            self._SecurityPolicyTemplates = []
            for item in params.get("SecurityPolicyTemplates"):
                obj = SecurityPolicyTemplateInfo()
                obj._deserialize(item)
                self._SecurityPolicyTemplates.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeZoneConfigImportResultRequest(AbstractModel):
    """DescribeZoneConfigImportResult request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _TaskId: It indicates the configuration import task ID for which the result needs to be queried. The import task ID is only retained for 7 days.
        :type TaskId: str
        """
        self._ZoneId = None
        self._TaskId = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TaskId(self):
        """It indicates the configuration import task ID for which the result needs to be queried. The import task ID is only retained for 7 days.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeZoneConfigImportResultResponse(AbstractModel):
    """DescribeZoneConfigImportResult response structure.

    """

    def __init__(self):
        r"""
        :param _Status: The status of this import task. Valid values: <li>success: It indicates the configuration was successfully imported;</li> <li>failure: It indicates the configuration import failed;</li> <li>doing: It indicates the configuration is being imported.</li>
        :type Status: str
        :param _Message: The status message of this import task. If the configuration item import fails, you can view the failure cause through this field.
        :type Message: str
        :param _Content: The configuration content of this import task.
        :type Content: str
        :param _ImportTime: The start time of this import task.
        :type ImportTime: str
        :param _FinishTime: The end time of this import task.
        :type FinishTime: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._Message = None
        self._Content = None
        self._ImportTime = None
        self._FinishTime = None
        self._RequestId = None

    @property
    def Status(self):
        """The status of this import task. Valid values: <li>success: It indicates the configuration was successfully imported;</li> <li>failure: It indicates the configuration import failed;</li> <li>doing: It indicates the configuration is being imported.</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Message(self):
        """The status message of this import task. If the configuration item import fails, you can view the failure cause through this field.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Content(self):
        """The configuration content of this import task.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def ImportTime(self):
        """The start time of this import task.
        :rtype: str
        """
        return self._ImportTime

    @ImportTime.setter
    def ImportTime(self, ImportTime):
        self._ImportTime = ImportTime

    @property
    def FinishTime(self):
        """The end time of this import task.
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Message = params.get("Message")
        self._Content = params.get("Content")
        self._ImportTime = params.get("ImportTime")
        self._FinishTime = params.get("FinishTime")
        self._RequestId = params.get("RequestId")


class DescribeZoneSettingRequest(AbstractModel):
    """DescribeZoneSetting request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeZoneSettingResponse(AbstractModel):
    """DescribeZoneSetting response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneSetting: The site configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ZoneSetting: :class:`tencentcloud.teo.v20220901.models.ZoneSetting`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneSetting = None
        self._RequestId = None

    @property
    def ZoneSetting(self):
        """The site configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.ZoneSetting`
        """
        return self._ZoneSetting

    @ZoneSetting.setter
    def ZoneSetting(self, ZoneSetting):
        self._ZoneSetting = ZoneSetting

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ZoneSetting") is not None:
            self._ZoneSetting = ZoneSetting()
            self._ZoneSetting._deserialize(params.get("ZoneSetting"))
        self._RequestId = params.get("RequestId")


class DescribeZonesRequest(AbstractModel):
    """DescribeZones request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: The page offset. Default value: 0
        :type Offset: int
        :param _Limit: Limit on paginated queries. Default value: 20. Maximum value: 100.
        :type Limit: int
        :param _Filters: Filter conditions. Up to 20 values for each filter. If this parameter is not filled in, the information of all sites under the current account is returned. Detailed filtering conditions are as follows:
<li>`zone-name`: Site name </li><li>`zone-id`: Site ID, such as zone-2noz78a8ev6k</li><li>`status`: Site status </li><li>`tag-key`: Tag key </li><li>`tag-value`: Tag value </li>Only `zone-name` supports fuzzy query.
        :type Filters: list of AdvancedFilter
        :param _Order: Sort the returned results according to this field. Values include:
<li>`type`: Connection mode</li>
<li>`area`: Acceleration region</li>
<li>`create-time`: Creation time</li>
<li>`zone-name`: Site name</li>
<li>`use-time`: Last used time</li>
<li>`active-status` Effective status</li> Default value: `create-time`
        :type Order: str
        :param _Direction: Sort direction. If the field value is a number, sort by the numeric value. If the field value is text, sort by the ascill code. Values include:
<li>`asc`: From the smallest to largest</li>
<li>`desc`: From the largest to smallest.</li>Default value: `desc`
        :type Direction: str
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._Order = None
        self._Direction = None

    @property
    def Offset(self):
        """The page offset. Default value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Limit on paginated queries. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """Filter conditions. Up to 20 values for each filter. If this parameter is not filled in, the information of all sites under the current account is returned. Detailed filtering conditions are as follows:
<li>`zone-name`: Site name </li><li>`zone-id`: Site ID, such as zone-2noz78a8ev6k</li><li>`status`: Site status </li><li>`tag-key`: Tag key </li><li>`tag-value`: Tag value </li>Only `zone-name` supports fuzzy query.
        :rtype: list of AdvancedFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        """Sort the returned results according to this field. Values include:
<li>`type`: Connection mode</li>
<li>`area`: Acceleration region</li>
<li>`create-time`: Creation time</li>
<li>`zone-name`: Site name</li>
<li>`use-time`: Last used time</li>
<li>`active-status` Effective status</li> Default value: `create-time`
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Direction(self):
        """Sort direction. If the field value is a number, sort by the numeric value. If the field value is text, sort by the ascill code. Values include:
<li>`asc`: From the smallest to largest</li>
<li>`desc`: From the largest to smallest.</li>Default value: `desc`
        :rtype: str
        """
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AdvancedFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._Direction = params.get("Direction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeZonesResponse(AbstractModel):
    """DescribeZones response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible sites.
        :type TotalCount: int
        :param _Zones: Details of sites.
        :type Zones: list of Zone
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Zones = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Number of eligible sites.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Zones(self):
        """Details of sites.
        :rtype: list of Zone
        """
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Zones") is not None:
            self._Zones = []
            for item in params.get("Zones"):
                obj = Zone()
                obj._deserialize(item)
                self._Zones.append(obj)
        self._RequestId = params.get("RequestId")


class DestroyPlanRequest(AbstractModel):
    """DestroyPlan request structure.

    """

    def __init__(self):
        r"""
        :param _PlanId: Plan ID, in the format of edgeone-2wdo315m2y4c.
        :type PlanId: str
        """
        self._PlanId = None

    @property
    def PlanId(self):
        """Plan ID, in the format of edgeone-2wdo315m2y4c.
        :rtype: str
        """
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId


    def _deserialize(self, params):
        self._PlanId = params.get("PlanId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DestroyPlanResponse(AbstractModel):
    """DestroyPlan response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DetailHost(AbstractModel):
    """Domain name configuration information

    """

    def __init__(self):
        r"""
        :param _ZoneId: The site ID.
        :type ZoneId: str
        :param _Status: The acceleration status. Values:
<li>`process`: In progress</li>
<li>`online`: Enabled</li>
<li>`offline`: Disabled</li>
        :type Status: str
        :param _Host: The domain name.
        :type Host: str
        :param _ZoneName: Name of the site
        :type ZoneName: str
        :param _Cname: The assigned CNAME
        :type Cname: str
        :param _Id: The resource ID.
        :type Id: str
        :param _InstanceId: The instance ID.
        :type InstanceId: str
        :param _Lock: The lock status.
        :type Lock: int
        :param _Mode: The domain name status.
        :type Mode: int
        :param _Area: The acceleration area of the domain name. Values:
<li>`global`: Global.</li>
<li>`mainland`: Chinese mainland.</li>
<li>`overseas`: Outside the Chinese mainland.</li>
        :type Area: str
        :param _AccelerateType: The acceleration type configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccelerateType: :class:`tencentcloud.teo.v20220901.models.AccelerateType`
        :param _Https: The HTTPS configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Https: :class:`tencentcloud.teo.v20220901.models.Https`
        :param _CacheConfig: The cache configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CacheConfig: :class:`tencentcloud.teo.v20220901.models.CacheConfig`
        :param _Origin: The origin configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Origin: :class:`tencentcloud.teo.v20220901.models.Origin`
        :param _SecurityType: The security type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SecurityType: :class:`tencentcloud.teo.v20220901.models.SecurityType`
        :param _CacheKey: The cache key configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CacheKey: :class:`tencentcloud.teo.v20220901.models.CacheKey`
        :param _Compression: The smart compression configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Compression: :class:`tencentcloud.teo.v20220901.models.Compression`
        :param _Waf: The WAF protection configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Waf: :class:`tencentcloud.teo.v20220901.models.Waf`
        :param _CC: The CC protection configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CC: :class:`tencentcloud.teo.v20220901.models.CC`
        :param _DDoS: DDoS mitigation configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :type DDoS: :class:`tencentcloud.teo.v20220901.models.DDoS`
        :param _SmartRouting: The smart routing configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SmartRouting: :class:`tencentcloud.teo.v20220901.models.SmartRouting`
        :param _Ipv6: The IPv6 access configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Ipv6: :class:`tencentcloud.teo.v20220901.models.Ipv6`
        :param _ClientIpCountry: Whether to carry the location information of the client IP during origin-pull.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type ClientIpCountry: :class:`tencentcloud.teo.v20220901.models.ClientIpCountry`
        """
        self._ZoneId = None
        self._Status = None
        self._Host = None
        self._ZoneName = None
        self._Cname = None
        self._Id = None
        self._InstanceId = None
        self._Lock = None
        self._Mode = None
        self._Area = None
        self._AccelerateType = None
        self._Https = None
        self._CacheConfig = None
        self._Origin = None
        self._SecurityType = None
        self._CacheKey = None
        self._Compression = None
        self._Waf = None
        self._CC = None
        self._DDoS = None
        self._SmartRouting = None
        self._Ipv6 = None
        self._ClientIpCountry = None

    @property
    def ZoneId(self):
        """The site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Status(self):
        """The acceleration status. Values:
<li>`process`: In progress</li>
<li>`online`: Enabled</li>
<li>`offline`: Disabled</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Host(self):
        """The domain name.
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def ZoneName(self):
        """Name of the site
        :rtype: str
        """
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName

    @property
    def Cname(self):
        """The assigned CNAME
        :rtype: str
        """
        return self._Cname

    @Cname.setter
    def Cname(self, Cname):
        self._Cname = Cname

    @property
    def Id(self):
        """The resource ID.
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def InstanceId(self):
        """The instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Lock(self):
        """The lock status.
        :rtype: int
        """
        return self._Lock

    @Lock.setter
    def Lock(self, Lock):
        self._Lock = Lock

    @property
    def Mode(self):
        """The domain name status.
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Area(self):
        """The acceleration area of the domain name. Values:
<li>`global`: Global.</li>
<li>`mainland`: Chinese mainland.</li>
<li>`overseas`: Outside the Chinese mainland.</li>
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def AccelerateType(self):
        """The acceleration type configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.AccelerateType`
        """
        return self._AccelerateType

    @AccelerateType.setter
    def AccelerateType(self, AccelerateType):
        self._AccelerateType = AccelerateType

    @property
    def Https(self):
        """The HTTPS configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.Https`
        """
        return self._Https

    @Https.setter
    def Https(self, Https):
        self._Https = Https

    @property
    def CacheConfig(self):
        """The cache configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CacheConfig`
        """
        return self._CacheConfig

    @CacheConfig.setter
    def CacheConfig(self, CacheConfig):
        self._CacheConfig = CacheConfig

    @property
    def Origin(self):
        """The origin configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.Origin`
        """
        return self._Origin

    @Origin.setter
    def Origin(self, Origin):
        self._Origin = Origin

    @property
    def SecurityType(self):
        """The security type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityType`
        """
        return self._SecurityType

    @SecurityType.setter
    def SecurityType(self, SecurityType):
        self._SecurityType = SecurityType

    @property
    def CacheKey(self):
        """The cache key configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CacheKey`
        """
        return self._CacheKey

    @CacheKey.setter
    def CacheKey(self, CacheKey):
        self._CacheKey = CacheKey

    @property
    def Compression(self):
        """The smart compression configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.Compression`
        """
        return self._Compression

    @Compression.setter
    def Compression(self, Compression):
        self._Compression = Compression

    @property
    def Waf(self):
        """The WAF protection configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.Waf`
        """
        return self._Waf

    @Waf.setter
    def Waf(self, Waf):
        self._Waf = Waf

    @property
    def CC(self):
        """The CC protection configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.CC`
        """
        return self._CC

    @CC.setter
    def CC(self, CC):
        self._CC = CC

    @property
    def DDoS(self):
        """DDoS mitigation configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.DDoS`
        """
        return self._DDoS

    @DDoS.setter
    def DDoS(self, DDoS):
        self._DDoS = DDoS

    @property
    def SmartRouting(self):
        """The smart routing configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.SmartRouting`
        """
        return self._SmartRouting

    @SmartRouting.setter
    def SmartRouting(self, SmartRouting):
        self._SmartRouting = SmartRouting

    @property
    def Ipv6(self):
        """The IPv6 access configuration item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.Ipv6`
        """
        return self._Ipv6

    @Ipv6.setter
    def Ipv6(self, Ipv6):
        self._Ipv6 = Ipv6

    @property
    def ClientIpCountry(self):
        """Whether to carry the location information of the client IP during origin-pull.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.ClientIpCountry`
        """
        return self._ClientIpCountry

    @ClientIpCountry.setter
    def ClientIpCountry(self, ClientIpCountry):
        self._ClientIpCountry = ClientIpCountry


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Status = params.get("Status")
        self._Host = params.get("Host")
        self._ZoneName = params.get("ZoneName")
        self._Cname = params.get("Cname")
        self._Id = params.get("Id")
        self._InstanceId = params.get("InstanceId")
        self._Lock = params.get("Lock")
        self._Mode = params.get("Mode")
        self._Area = params.get("Area")
        if params.get("AccelerateType") is not None:
            self._AccelerateType = AccelerateType()
            self._AccelerateType._deserialize(params.get("AccelerateType"))
        if params.get("Https") is not None:
            self._Https = Https()
            self._Https._deserialize(params.get("Https"))
        if params.get("CacheConfig") is not None:
            self._CacheConfig = CacheConfig()
            self._CacheConfig._deserialize(params.get("CacheConfig"))
        if params.get("Origin") is not None:
            self._Origin = Origin()
            self._Origin._deserialize(params.get("Origin"))
        if params.get("SecurityType") is not None:
            self._SecurityType = SecurityType()
            self._SecurityType._deserialize(params.get("SecurityType"))
        if params.get("CacheKey") is not None:
            self._CacheKey = CacheKey()
            self._CacheKey._deserialize(params.get("CacheKey"))
        if params.get("Compression") is not None:
            self._Compression = Compression()
            self._Compression._deserialize(params.get("Compression"))
        if params.get("Waf") is not None:
            self._Waf = Waf()
            self._Waf._deserialize(params.get("Waf"))
        if params.get("CC") is not None:
            self._CC = CC()
            self._CC._deserialize(params.get("CC"))
        if params.get("DDoS") is not None:
            self._DDoS = DDoS()
            self._DDoS._deserialize(params.get("DDoS"))
        if params.get("SmartRouting") is not None:
            self._SmartRouting = SmartRouting()
            self._SmartRouting._deserialize(params.get("SmartRouting"))
        if params.get("Ipv6") is not None:
            self._Ipv6 = Ipv6()
            self._Ipv6._deserialize(params.get("Ipv6"))
        if params.get("ClientIpCountry") is not None:
            self._ClientIpCountry = ClientIpCountry()
            self._ClientIpCountry._deserialize(params.get("ClientIpCountry"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetectLengthLimitCondition(AbstractModel):
    """Length limit detection condition configuration.

    """

    def __init__(self):
        r"""
        :param _Name: Parameter name of the matched condition. Values:.
<li>`body_depth`: detection depth of the request body packet part.</li>
        :type Name: str
        :param _Values: Parameter value of the matched condition, used in pairs with the `Name` parameter.
When the `Name` value is body_depth, `Values` only support passing in a single value. Values:
<li>`8KB`;</li>
<li>`64KB`;</li>
<li>`128KB`.</li>
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        """Parameter name of the matched condition. Values:.
<li>`body_depth`: detection depth of the request body packet part.</li>
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        """Parameter value of the matched condition, used in pairs with the `Name` parameter.
When the `Name` value is body_depth, `Values` only support passing in a single value. Values:
<li>`8KB`;</li>
<li>`64KB`;</li>
<li>`128KB`.</li>
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetectLengthLimitConfig(AbstractModel):
    """Length limit detection configuration.

    """

    def __init__(self):
        r"""
        :param _DetectLengthLimitRules: List of rules that detect length limits.
        :type DetectLengthLimitRules: list of DetectLengthLimitRule
        """
        self._DetectLengthLimitRules = None

    @property
    def DetectLengthLimitRules(self):
        """List of rules that detect length limits.
        :rtype: list of DetectLengthLimitRule
        """
        return self._DetectLengthLimitRules

    @DetectLengthLimitRules.setter
    def DetectLengthLimitRules(self, DetectLengthLimitRules):
        self._DetectLengthLimitRules = DetectLengthLimitRules


    def _deserialize(self, params):
        if params.get("DetectLengthLimitRules") is not None:
            self._DetectLengthLimitRules = []
            for item in params.get("DetectLengthLimitRules"):
                obj = DetectLengthLimitRule()
                obj._deserialize(item)
                self._DetectLengthLimitRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetectLengthLimitRule(AbstractModel):
    """Length limit detection rule details configuration.

    """

    def __init__(self):
        r"""
        :param _RuleId: Rule Id, output parameter only.
        :type RuleId: int
        :param _RuleName: Rule name, output parameter only.
        :type RuleName: str
        :param _Description: Rule description, output parameter only.
        :type Description: str
        :param _Conditions: Rule configuration conditions, output parameter only.
        :type Conditions: list of DetectLengthLimitCondition
        :param _Action: Handling method. Values:.
<li>`skip`: when request body data exceeds the detection depth set by `body_depth` in `Conditions` output parameters, skip all request body content detection.</li>.
<li>`scan`: detect at the detection depth set by `body_depth` in the `Conditions` output parameters only. Truncate the excess part of the request body content directly, the excess part of the request body will not go through security detection.</li> Output paramter only.
        :type Action: str
        """
        self._RuleId = None
        self._RuleName = None
        self._Description = None
        self._Conditions = None
        self._Action = None

    @property
    def RuleId(self):
        """Rule Id, output parameter only.
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        """Rule name, output parameter only.
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Description(self):
        """Rule description, output parameter only.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Conditions(self):
        """Rule configuration conditions, output parameter only.
        :rtype: list of DetectLengthLimitCondition
        """
        return self._Conditions

    @Conditions.setter
    def Conditions(self, Conditions):
        self._Conditions = Conditions

    @property
    def Action(self):
        """Handling method. Values:.
<li>`skip`: when request body data exceeds the detection depth set by `body_depth` in `Conditions` output parameters, skip all request body content detection.</li>.
<li>`scan`: detect at the detection depth set by `body_depth` in the `Conditions` output parameters only. Truncate the excess part of the request body content directly, the excess part of the request body will not go through security detection.</li> Output paramter only.
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._Description = params.get("Description")
        if params.get("Conditions") is not None:
            self._Conditions = []
            for item in params.get("Conditions"):
                obj = DetectLengthLimitCondition()
                obj._deserialize(item)
                self._Conditions.append(obj)
        self._Action = params.get("Action")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeviceProfile(AbstractModel):
    """Describes the client device configuration.

    """

    def __init__(self):
        r"""
        :param _ClientType: Client device type. valid values: <li>iOS;</li> <li>Android;</li> <li>WebView.</li>.
        :type ClientType: str
        :param _HighRiskMinScore: The minimum value to determine a request as high-risk ranges from 1–99. the larger the value, the higher the request risk, and the closer it resembles a request initiated by a Bot client. the default value is 50, corresponding to high-risk for values 51–100.
        :type HighRiskMinScore: int
        :param _HighRiskRequestAction: Handling method for high-risk requests. valid values for SecurityAction Name: <li>Deny: block;</li> <li>Monitor: observation;</li> <li>Redirect: redirection;</li> <li>Challenge: Challenge.</li> default value: Monitor.
        :type HighRiskRequestAction: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        :param _MediumRiskMinScore: Specifies the minimum value to determine a request as medium-risk. value range: 1–99. the larger the value, the higher the request risk, resembling requests initiated by a Bot client. default value: 15, corresponding to medium-risk for values 16–50.
        :type MediumRiskMinScore: int
        :param _MediumRiskRequestAction: Handling method for medium-risk requests. SecurityAction Name parameter supports: <li>Deny: block;</li> <li>Monitor: observe;</li> <li>Redirect: Redirect;</li> <li>Challenge: Challenge.</li> default value is Monitor.
        :type MediumRiskRequestAction: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        self._ClientType = None
        self._HighRiskMinScore = None
        self._HighRiskRequestAction = None
        self._MediumRiskMinScore = None
        self._MediumRiskRequestAction = None

    @property
    def ClientType(self):
        """Client device type. valid values: <li>iOS;</li> <li>Android;</li> <li>WebView.</li>.
        :rtype: str
        """
        return self._ClientType

    @ClientType.setter
    def ClientType(self, ClientType):
        self._ClientType = ClientType

    @property
    def HighRiskMinScore(self):
        """The minimum value to determine a request as high-risk ranges from 1–99. the larger the value, the higher the request risk, and the closer it resembles a request initiated by a Bot client. the default value is 50, corresponding to high-risk for values 51–100.
        :rtype: int
        """
        return self._HighRiskMinScore

    @HighRiskMinScore.setter
    def HighRiskMinScore(self, HighRiskMinScore):
        self._HighRiskMinScore = HighRiskMinScore

    @property
    def HighRiskRequestAction(self):
        """Handling method for high-risk requests. valid values for SecurityAction Name: <li>Deny: block;</li> <li>Monitor: observation;</li> <li>Redirect: redirection;</li> <li>Challenge: Challenge.</li> default value: Monitor.
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        return self._HighRiskRequestAction

    @HighRiskRequestAction.setter
    def HighRiskRequestAction(self, HighRiskRequestAction):
        self._HighRiskRequestAction = HighRiskRequestAction

    @property
    def MediumRiskMinScore(self):
        """Specifies the minimum value to determine a request as medium-risk. value range: 1–99. the larger the value, the higher the request risk, resembling requests initiated by a Bot client. default value: 15, corresponding to medium-risk for values 16–50.
        :rtype: int
        """
        return self._MediumRiskMinScore

    @MediumRiskMinScore.setter
    def MediumRiskMinScore(self, MediumRiskMinScore):
        self._MediumRiskMinScore = MediumRiskMinScore

    @property
    def MediumRiskRequestAction(self):
        """Handling method for medium-risk requests. SecurityAction Name parameter supports: <li>Deny: block;</li> <li>Monitor: observe;</li> <li>Redirect: Redirect;</li> <li>Challenge: Challenge.</li> default value is Monitor.
        :rtype: :class:`tencentcloud.teo.v20220901.models.SecurityAction`
        """
        return self._MediumRiskRequestAction

    @MediumRiskRequestAction.setter
    def MediumRiskRequestAction(self, MediumRiskRequestAction):
        self._MediumRiskRequestAction = MediumRiskRequestAction


    def _deserialize(self, params):
        self._ClientType = params.get("ClientType")
        self._HighRiskMinScore = params.get("HighRiskMinScore")
        if params.get("HighRiskRequestAction") is not None:
            self._HighRiskRequestAction = SecurityAction()
            self._HighRiskRequestAction._deserialize(params.get("HighRiskRequestAction"))
        self._MediumRiskMinScore = params.get("MediumRiskMinScore")
        if params.get("MediumRiskRequestAction") is not None:
            self._MediumRiskRequestAction = SecurityAction()
            self._MediumRiskRequestAction._deserialize(params.get("MediumRiskRequestAction"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DiffIPWhitelist(AbstractModel):
    """Differences between the newest and existing intermediate IPs

    """

    def __init__(self):
        r"""
        :param _LatestIPWhitelist: The latest intermediate IPs.
        :type LatestIPWhitelist: :class:`tencentcloud.teo.v20220901.models.IPWhitelist`
        :param _AddedIPWhitelist: The intermediate IPs added to the existing list.
        :type AddedIPWhitelist: :class:`tencentcloud.teo.v20220901.models.IPWhitelist`
        :param _RemovedIPWhitelist: The intermediate IPs removed from the existing list.
        :type RemovedIPWhitelist: :class:`tencentcloud.teo.v20220901.models.IPWhitelist`
        :param _NoChangeIPWhitelist: The intermediate IPs that remain unchanged.
        :type NoChangeIPWhitelist: :class:`tencentcloud.teo.v20220901.models.IPWhitelist`
        """
        self._LatestIPWhitelist = None
        self._AddedIPWhitelist = None
        self._RemovedIPWhitelist = None
        self._NoChangeIPWhitelist = None

    @property
    def LatestIPWhitelist(self):
        """The latest intermediate IPs.
        :rtype: :class:`tencentcloud.teo.v20220901.models.IPWhitelist`
        """
        return self._LatestIPWhitelist

    @LatestIPWhitelist.setter
    def LatestIPWhitelist(self, LatestIPWhitelist):
        self._LatestIPWhitelist = LatestIPWhitelist

    @property
    def AddedIPWhitelist(self):
        """The intermediate IPs added to the existing list.
        :rtype: :class:`tencentcloud.teo.v20220901.models.IPWhitelist`
        """
        return self._AddedIPWhitelist

    @AddedIPWhitelist.setter
    def AddedIPWhitelist(self, AddedIPWhitelist):
        self._AddedIPWhitelist = AddedIPWhitelist

    @property
    def RemovedIPWhitelist(self):
        """The intermediate IPs removed from the existing list.
        :rtype: :class:`tencentcloud.teo.v20220901.models.IPWhitelist`
        """
        return self._RemovedIPWhitelist

    @RemovedIPWhitelist.setter
    def RemovedIPWhitelist(self, RemovedIPWhitelist):
        self._RemovedIPWhitelist = RemovedIPWhitelist

    @property
    def NoChangeIPWhitelist(self):
        """The intermediate IPs that remain unchanged.
        :rtype: :class:`tencentcloud.teo.v20220901.models.IPWhitelist`
        """
        return self._NoChangeIPWhitelist

    @NoChangeIPWhitelist.setter
    def NoChangeIPWhitelist(self, NoChangeIPWhitelist):
        self._NoChangeIPWhitelist = NoChangeIPWhitelist


    def _deserialize(self, params):
        if params.get("LatestIPWhitelist") is not None:
            self._LatestIPWhitelist = IPWhitelist()
            self._LatestIPWhitelist._deserialize(params.get("LatestIPWhitelist"))
        if params.get("AddedIPWhitelist") is not None:
            self._AddedIPWhitelist = IPWhitelist()
            self._AddedIPWhitelist._deserialize(params.get("AddedIPWhitelist"))
        if params.get("RemovedIPWhitelist") is not None:
            self._RemovedIPWhitelist = IPWhitelist()
            self._RemovedIPWhitelist._deserialize(params.get("RemovedIPWhitelist"))
        if params.get("NoChangeIPWhitelist") is not None:
            self._NoChangeIPWhitelist = IPWhitelist()
            self._NoChangeIPWhitelist._deserialize(params.get("NoChangeIPWhitelist"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableOriginACLRequest(AbstractModel):
    """DisableOriginACL request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Specifies the site ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        """Specifies the site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableOriginACLResponse(AbstractModel):
    """DisableOriginACL response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DnsRecord(AbstractModel):
    """DNS record

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone id.<br>note: zoneid is for output parameter use only and cannot be used as an input parameter in modifydnsrecords. if this parameter is passed, it will be ignored.
        :type ZoneId: str
        :param _RecordId: DNS record id.
        :type RecordId: str
        :param _Name: DNS record name.
        :type Name: str
        :param _Type: DNS record type. valid values are:.
<Li>A: point the domain to a public network ipv4 address, such as 8.8.8.8;</li>.
<Li>AAAA: point the domain to a public network ipv6 address;</li>.
<Li>MX: used for email servers. when there are multiple mx records, the lower the priority, the higher the precedence;</li>.
<Li>CNAME: point the domain to another domain name, which will resolve to the final ip address;</li>.
<Li>TXT: identify and describe the domain, commonly used for domain verification and spf records (anti-spam);</li>.
<Li>NS: if you need to delegate the resolution of a subdomain to another dns service provider, you need to add an ns record. ns records cannot be added to the root domain name;</li>.
<Li>CAA: specifies the ca that can issue certificates for this site;</li>.
<Li>SRV: indicates that a server is using a service, commonly seen in microsoft system directory management.</li>.
        :type Type: str
        :param _Location: DNS record resolution route, if not specified, defaults to default, indicating the default resolution route, effective in all regions.<br>resolution route configuration only applies when type (dns record type) is a, aaaa, or cname.<br>for valid values, refer to: [resolution routes and corresponding code enumeration](https://intl.cloud.tencent.com/document/product/1552/112542?from_cn_redirect=1).
        :type Location: str
        :param _Content: DNS record content. fill in the corresponding content based on the type value.
        :type Content: str
        :param _TTL: Cache time. value range: 60–86400. the smaller the value, the faster the record modification will take effect globally. unit: seconds.
        :type TTL: int
        :param _Weight: DNS record weight. value range: -1–100. a value of -1 means no weight is assigned, and 0 means no parsing. weight configuration is only applicable when type (dns record type) is a, aaaa, or cname.
        :type Weight: int
        :param _Priority: MX record priority. value range: 0–50. the smaller the value, the higher the priority.
        :type Priority: int
        :param _Status: DNS record parsing status. valid values are: <li>enable: takes effect;</li><li>disable: disabled.</li> note: status is only used as an output parameter and cannot be used as an input parameter in modifydnsrecords. if this parameter is passed, it will be ignored.
        :type Status: str
        :param _CreatedOn: Creation time.<br>note: createdon is only used as an output parameter and cannot be used as an input parameter in modifydnsrecords. if this parameter is passed, it will be ignored.
        :type CreatedOn: str
        :param _ModifiedOn: Modification time.<br>note: modifiedon is for output parameter only and cannot be used as an input parameter in modifydnsrecords. if this parameter is passed, it will be ignored.
        :type ModifiedOn: str
        """
        self._ZoneId = None
        self._RecordId = None
        self._Name = None
        self._Type = None
        self._Location = None
        self._Content = None
        self._TTL = None
        self._Weight = None
        self._Priority = None
        self._Status = None
        self._CreatedOn = None
        self._ModifiedOn = None

    @property
    def ZoneId(self):
        """Zone id.<br>note: zoneid is for output parameter use only and cannot be used as an input parameter in modifydnsrecords. if this parameter is passed, it will be ignored.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RecordId(self):
        """DNS record id.
        :rtype: str
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def Name(self):
        """DNS record name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """DNS record type. valid values are:.
<Li>A: point the domain to a public network ipv4 address, such as 8.8.8.8;</li>.
<Li>AAAA: point the domain to a public network ipv6 address;</li>.
<Li>MX: used for email servers. when there are multiple mx records, the lower the priority, the higher the precedence;</li>.
<Li>CNAME: point the domain to another domain name, which will resolve to the final ip address;</li>.
<Li>TXT: identify and describe the domain, commonly used for domain verification and spf records (anti-spam);</li>.
<Li>NS: if you need to delegate the resolution of a subdomain to another dns service provider, you need to add an ns record. ns records cannot be added to the root domain name;</li>.
<Li>CAA: specifies the ca that can issue certificates for this site;</li>.
<Li>SRV: indicates that a server is using a service, commonly seen in microsoft system directory management.</li>.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Location(self):
        """DNS record resolution route, if not specified, defaults to default, indicating the default resolution route, effective in all regions.<br>resolution route configuration only applies when type (dns record type) is a, aaaa, or cname.<br>for valid values, refer to: [resolution routes and corresponding code enumeration](https://intl.cloud.tencent.com/document/product/1552/112542?from_cn_redirect=1).
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Content(self):
        """DNS record content. fill in the corresponding content based on the type value.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def TTL(self):
        """Cache time. value range: 60–86400. the smaller the value, the faster the record modification will take effect globally. unit: seconds.
        :rtype: int
        """
        return self._TTL

    @TTL.setter
    def TTL(self, TTL):
        self._TTL = TTL

    @property
    def Weight(self):
        """DNS record weight. value range: -1–100. a value of -1 means no weight is assigned, and 0 means no parsing. weight configuration is only applicable when type (dns record type) is a, aaaa, or cname.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def Priority(self):
        """MX record priority. value range: 0–50. the smaller the value, the higher the priority.
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def Status(self):
        """DNS record parsing status. valid values are: <li>enable: takes effect;</li><li>disable: disabled.</li> note: status is only used as an output parameter and cannot be used as an input parameter in modifydnsrecords. if this parameter is passed, it will be ignored.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreatedOn(self):
        """Creation time.<br>note: createdon is only used as an output parameter and cannot be used as an input parameter in modifydnsrecords. if this parameter is passed, it will be ignored.
        :rtype: str
        """
        return self._CreatedOn

    @CreatedOn.setter
    def CreatedOn(self, CreatedOn):
        self._CreatedOn = CreatedOn

    @property
    def ModifiedOn(self):
        """Modification time.<br>note: modifiedon is for output parameter only and cannot be used as an input parameter in modifydnsrecords. if this parameter is passed, it will be ignored.
        :rtype: str
        """
        return self._ModifiedOn

    @ModifiedOn.setter
    def ModifiedOn(self, ModifiedOn):
        self._ModifiedOn = ModifiedOn


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RecordId = params.get("RecordId")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Location = params.get("Location")
        self._Content = params.get("Content")
        self._TTL = params.get("TTL")
        self._Weight = params.get("Weight")
        self._Priority = params.get("Priority")
        self._Status = params.get("Status")
        self._CreatedOn = params.get("CreatedOn")
        self._ModifiedOn = params.get("ModifiedOn")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DnsVerification(AbstractModel):
    """

    """

    def __init__(self):
        r"""
        :param _Subdomain: The host record.
        :type Subdomain: str
        :param _RecordType: The record type.
        :type RecordType: str
        :param _RecordValue: The record value.
        :type RecordValue: str
        """
        self._Subdomain = None
        self._RecordType = None
        self._RecordValue = None

    @property
    def Subdomain(self):
        """The host record.
        :rtype: str
        """
        return self._Subdomain

    @Subdomain.setter
    def Subdomain(self, Subdomain):
        self._Subdomain = Subdomain

    @property
    def RecordType(self):
        """The record type.
        :rtype: str
        """
        return self._RecordType

    @RecordType.setter
    def RecordType(self, RecordType):
        self._RecordType = RecordType

    @property
    def RecordValue(self):
        """The record value.
        :rtype: str
        """
        return self._RecordValue

    @RecordValue.setter
    def RecordValue(self, RecordValue):
        self._RecordValue = RecordValue


    def _deserialize(self, params):
        self._Subdomain = params.get("Subdomain")
        self._RecordType = params.get("RecordType")
        self._RecordValue = params.get("RecordValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadL4LogsRequest(AbstractModel):
    """DownloadL4Logs request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time.
        :type EndTime: str
        :param _ZoneIds: ZoneId set. This parameter is required.
        :type ZoneIds: list of str
        :param _ProxyIds: List of L4 proxy instance IDs.
        :type ProxyIds: list of str
        :param _Limit: Limit on paginated queries. Default value: 20. Maximum value: 300.
        :type Limit: int
        :param _Offset: The page offset. Default value: 0.
        :type Offset: int
        """
        self._StartTime = None
        self._EndTime = None
        self._ZoneIds = None
        self._ProxyIds = None
        self._Limit = None
        self._Offset = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ZoneIds(self):
        """ZoneId set. This parameter is required.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def ProxyIds(self):
        """List of L4 proxy instance IDs.
        :rtype: list of str
        """
        return self._ProxyIds

    @ProxyIds.setter
    def ProxyIds(self, ProxyIds):
        self._ProxyIds = ProxyIds

    @property
    def Limit(self):
        """Limit on paginated queries. Default value: 20. Maximum value: 300.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """The page offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ZoneIds = params.get("ZoneIds")
        self._ProxyIds = params.get("ProxyIds")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadL4LogsResponse(AbstractModel):
    """DownloadL4Logs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _Data: List of L4 logs.
        :type Data: list of L4OfflineLog
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        """List of L4 logs.
        :rtype: list of L4OfflineLog
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = L4OfflineLog()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DownloadL7LogsRequest(AbstractModel):
    """DownloadL7Logs request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start time.
        :type StartTime: str
        :param _EndTime: The end time.
        :type EndTime: str
        :param _ZoneIds: ZoneId set. This parameter is required.
        :type ZoneIds: list of str
        :param _Domains: List of subdomain names to be queried. All subdomain names will be selected if this field is not specified.
        :type Domains: list of str
        :param _Limit: Limit on paginated queries. Default value: 20. Maximum value: 300.
        :type Limit: int
        :param _Offset: The page offset. Default value: 0.
        :type Offset: int
        """
        self._StartTime = None
        self._EndTime = None
        self._ZoneIds = None
        self._Domains = None
        self._Limit = None
        self._Offset = None

    @property
    def StartTime(self):
        """The start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """The end time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ZoneIds(self):
        """ZoneId set. This parameter is required.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def Domains(self):
        """List of subdomain names to be queried. All subdomain names will be selected if this field is not specified.
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Limit(self):
        """Limit on paginated queries. Default value: 20. Maximum value: 300.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """The page offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ZoneIds = params.get("ZoneIds")
        self._Domains = params.get("Domains")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadL7LogsResponse(AbstractModel):
    """DownloadL7Logs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _Data: List of L7 logs.
        :type Data: list of L7OfflineLog
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        """List of L7 logs.
        :rtype: list of L7OfflineLog
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = L7OfflineLog()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DropPageConfig(AbstractModel):
    """Block page configuration

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable configuration. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _WafDropPageDetail: The settings of the block page that applies managed rules. If it is null, the settings that were last configured will be used.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WafDropPageDetail: :class:`tencentcloud.teo.v20220901.models.DropPageDetail`
        :param _AclDropPageDetail: The settings of the block page that applies custom rules. If it is null, the settings that were last configured will be used.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AclDropPageDetail: :class:`tencentcloud.teo.v20220901.models.DropPageDetail`
        """
        self._Switch = None
        self._WafDropPageDetail = None
        self._AclDropPageDetail = None

    @property
    def Switch(self):
        """Whether to enable configuration. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def WafDropPageDetail(self):
        """The settings of the block page that applies managed rules. If it is null, the settings that were last configured will be used.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.DropPageDetail`
        """
        return self._WafDropPageDetail

    @WafDropPageDetail.setter
    def WafDropPageDetail(self, WafDropPageDetail):
        self._WafDropPageDetail = WafDropPageDetail

    @property
    def AclDropPageDetail(self):
        """The settings of the block page that applies custom rules. If it is null, the settings that were last configured will be used.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.DropPageDetail`
        """
        return self._AclDropPageDetail

    @AclDropPageDetail.setter
    def AclDropPageDetail(self, AclDropPageDetail):
        self._AclDropPageDetail = AclDropPageDetail


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        if params.get("WafDropPageDetail") is not None:
            self._WafDropPageDetail = DropPageDetail()
            self._WafDropPageDetail._deserialize(params.get("WafDropPageDetail"))
        if params.get("AclDropPageDetail") is not None:
            self._AclDropPageDetail = DropPageDetail()
            self._AclDropPageDetail._deserialize(params.get("AclDropPageDetail"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DropPageDetail(AbstractModel):
    """The configuration details of the block page

    """

    def __init__(self):
        r"""
        :param _PageId: The ID of the block page. Specify `0` to use the default block page. 
(Disused) If 0 is passed, the default block page will be used.
        :type PageId: int
        :param _StatusCode: The HTTP status code to trigger the block page. Range: 100-600, excluding 3xx codes. Code 566: Requests blocked by managed rules. Code 567: Requests blocked by web security rules (except managed rules).
        :type StatusCode: int
        :param _Name: The block page file or URL.
        :type Name: str
        :param _Type: Type of the block page. Values:
<li>`page`: Return the specified page.</li>

        :type Type: str
        :param _CustomResponseId: ID of custom response. The ID can be obtained via the `DescribeCustomErrorPages` API. It's required when `Type=page`.
        :type CustomResponseId: str
        """
        self._PageId = None
        self._StatusCode = None
        self._Name = None
        self._Type = None
        self._CustomResponseId = None

    @property
    def PageId(self):
        """The ID of the block page. Specify `0` to use the default block page. 
(Disused) If 0 is passed, the default block page will be used.
        :rtype: int
        """
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId

    @property
    def StatusCode(self):
        """The HTTP status code to trigger the block page. Range: 100-600, excluding 3xx codes. Code 566: Requests blocked by managed rules. Code 567: Requests blocked by web security rules (except managed rules).
        :rtype: int
        """
        return self._StatusCode

    @StatusCode.setter
    def StatusCode(self, StatusCode):
        self._StatusCode = StatusCode

    @property
    def Name(self):
        """The block page file or URL.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """Type of the block page. Values:
<li>`page`: Return the specified page.</li>

        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CustomResponseId(self):
        """ID of custom response. The ID can be obtained via the `DescribeCustomErrorPages` API. It's required when `Type=page`.
        :rtype: str
        """
        return self._CustomResponseId

    @CustomResponseId.setter
    def CustomResponseId(self, CustomResponseId):
        self._CustomResponseId = CustomResponseId


    def _deserialize(self, params):
        self._PageId = params.get("PageId")
        self._StatusCode = params.get("StatusCode")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._CustomResponseId = params.get("CustomResponseId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableOriginACLRequest(AbstractModel):
    """EnableOriginACL request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Specifies the site ID.
        :type ZoneId: str
        :param _L7EnableMode: The mode of configurating origin ACLs for L7 acceleration domains.
- all: configurate origin ACLs for all L7 acceleration domains under the site.
- specific: configurate origin ACLs for designated L7 acceleration domains under the site.
When the parameter is empty, it defaults to specific.

        :type L7EnableMode: str
        :param _L7Hosts: The list of L7 acceleration domains that require enabling the origin ACLs. This list must be empty when the request parameter L7EnableMode is set to 'all'. A maximum of 200 domains are supported at a time.
        :type L7Hosts: list of str
        :param _L4EnableMode: The mode of configurating origin ACLs for L4 proxy Instances.
- all: configurate origin ACLs for all L4 proxy Instances under the site.
- specific: configurate origin ACLs for designated  L4 proxy Instances under the site.
When the parameter is empty, it defaults to specific.
        :type L4EnableMode: str
        :param _L4ProxyIds: The list of L4 proxy Instances that require enabling origin ACLs. This list must be empty when the request parameter L4EnableMode is set to 'all'. A maximum of 100 instances are supported at a time.
        :type L4ProxyIds: list of str
        """
        self._ZoneId = None
        self._L7EnableMode = None
        self._L7Hosts = None
        self._L4EnableMode = None
        self._L4ProxyIds = None

    @property
    def ZoneId(self):
        """Specifies the site ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def L7EnableMode(self):
        """The mode of configurating origin ACLs for L7 acceleration domains.
- all: configurate origin ACLs for all L7 acceleration domains under the site.
- specific: configurate origin ACLs for designated L7 acceleration domains under the site.
When the parameter is empty, it defaults to specific.

        :rtype: str
        """
        return self._L7EnableMode

    @L7EnableMode.setter
    def L7EnableMode(self, L7EnableMode):
        self._L7EnableMode = L7EnableMode

    @property
    def L7Hosts(self):
        """The list of L7 acceleration domains that require enabling the origin ACLs. This list must be empty when the request parameter L7EnableMode is set to 'all'. A maximum of 200 domains are supported at a time.
        :rtype: list of str
        """
        return self._L7Hosts

    @L7Hosts.setter
    def L7Hosts(self, L7Hosts):
        self._L7Hosts = L7Hosts

    @property
    def L4EnableMode(self):
        """The mode of configurating origin ACLs for L4 proxy Instances.
- all: configurate origin ACLs for all L4 proxy Instances under the site.
- specific: configurate origin ACLs for designated  L4 proxy Instances under the site.
When the parameter is empty, it defaults to specific.
        :rtype: str
        """
        return self._L4EnableMode

    @L4EnableMode.setter
    def L4EnableMode(self, L4EnableMode):
        self._L4EnableMode = L4EnableMode

    @property
    def L4ProxyIds(self):
        """The list of L4 proxy Instances that require enabling origin ACLs. This list must be empty when the request parameter L4EnableMode is set to 'all'. A maximum of 100 instances are supported at a time.
        :rtype: list of str
        """
        return self._L4ProxyIds

    @L4ProxyIds.setter
    def L4ProxyIds(self, L4ProxyIds):
        self._L4ProxyIds = L4ProxyIds


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._L7EnableMode = params.get("L7EnableMode")
        self._L7Hosts = params.get("L7Hosts")
        self._L4EnableMode = params.get("L4EnableMode")
        self._L4ProxyIds = params.get("L4ProxyIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableOriginACLResponse(AbstractModel):
    """EnableOriginACL response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EntityStatus(AbstractModel):
    """Status of domain names bound with this template.

    """

    def __init__(self):
        r"""
        :param _Entity: Instance name. Only subdomain names are supported.
        :type Entity: str
        :param _Status: Instance configuration status. Values:
<li>`online`: Configuration has taken effect;</li><li>`fail`: Configuration failed;</li><li>`process`: Configuration is being delivered. </li>
        :type Status: str
        :param _Message: Message returned after the operation completed. 
        :type Message: str
        """
        self._Entity = None
        self._Status = None
        self._Message = None

    @property
    def Entity(self):
        """Instance name. Only subdomain names are supported.
        :rtype: str
        """
        return self._Entity

    @Entity.setter
    def Entity(self, Entity):
        self._Entity = Entity

    @property
    def Status(self):
        """Instance configuration status. Values:
<li>`online`: Configuration has taken effect;</li><li>`fail`: Configuration failed;</li><li>`process`: Configuration is being delivered. </li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Message(self):
        """Message returned after the operation completed. 
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Entity = params.get("Entity")
        self._Status = params.get("Status")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnvInfo(AbstractModel):
    """Environment information.

    """

    def __init__(self):
        r"""
        :param _EnvId: Environment ID.
        :type EnvId: str
        :param _EnvType: Environment type. Valid values: 
<li>production: Production environment.</li><li> staging: Test environment. </li>
        :type EnvType: str
        :param _Status: Environment status. Valid values: 
<li>creating: Being created.</li>
<li>running: The environment is stable, with version changes allowed.</li>
<li>version_deploying: The version is currently being deployed, with no more changes allowed. </li>
        :type Status: str
        :param _Scope: Effective scope of the configuration in the current environment. Valid values: 
<li>ALL: It takes effect on the entire network when EnvType is set to production.</li>
<li>It returns the IP address of the test node for host binding during testing when EnvType is set to staging. </li>
        :type Scope: list of str
        :param _CurrentConfigGroupVersionInfos: For the effective versions of each configuration group in the current environment, there are two possible scenarios based on the value of Status: 
<li>When Status is set to version_deploying, the returned value of this field represents the previously effective version. In other words, during the deployment of the new version, the effective version is the one that was in effect before any changes were made.</li>
<li>When Status is set to running, the value returned by this field is the currently effective version. </li>
        :type CurrentConfigGroupVersionInfos: list of ConfigGroupVersionInfo
        :param _CreateTime: Creation time. The time format follows the ISO 8601 standard and is represented in Coordinated Universal Time (UTC).
        :type CreateTime: str
        :param _UpdateTime: Update time. The time format follows the ISO 8601 standard and is represented in Coordinated Universal Time (UTC).
        :type UpdateTime: str
        """
        self._EnvId = None
        self._EnvType = None
        self._Status = None
        self._Scope = None
        self._CurrentConfigGroupVersionInfos = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def EnvId(self):
        """Environment ID.
        :rtype: str
        """
        return self._EnvId

    @EnvId.setter
    def EnvId(self, EnvId):
        self._EnvId = EnvId

    @property
    def EnvType(self):
        """Environment type. Valid values: 
<li>production: Production environment.</li><li> staging: Test environment. </li>
        :rtype: str
        """
        return self._EnvType

    @EnvType.setter
    def EnvType(self, EnvType):
        self._EnvType = EnvType

    @property
    def Status(self):
        """Environment status. Valid values: 
<li>creating: Being created.</li>
<li>running: The environment is stable, with version changes allowed.</li>
<li>version_deploying: The version is currently being deployed, with no more changes allowed. </li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Scope(self):
        """Effective scope of the configuration in the current environment. Valid values: 
<li>ALL: It takes effect on the entire network when EnvType is set to production.</li>
<li>It returns the IP address of the test node for host binding during testing when EnvType is set to staging. </li>
        :rtype: list of str
        """
        return self._Scope

    @Scope.setter
    def Scope(self, Scope):
        self._Scope = Scope

    @property
    def CurrentConfigGroupVersionInfos(self):
        """For the effective versions of each configuration group in the current environment, there are two possible scenarios based on the value of Status: 
<li>When Status is set to version_deploying, the returned value of this field represents the previously effective version. In other words, during the deployment of the new version, the effective version is the one that was in effect before any changes were made.</li>
<li>When Status is set to running, the value returned by this field is the currently effective version. </li>
        :rtype: list of ConfigGroupVersionInfo
        """
        return self._CurrentConfigGroupVersionInfos

    @CurrentConfigGroupVersionInfos.setter
    def CurrentConfigGroupVersionInfos(self, CurrentConfigGroupVersionInfos):
        self._CurrentConfigGroupVersionInfos = CurrentConfigGroupVersionInfos

    @property
    def CreateTime(self):
        """Creation time. The time format follows the ISO 8601 standard and is represented in Coordinated Universal Time (UTC).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """Update time. The time format follows the ISO 8601 standard and is represented in Coordinated Universal Time (UTC).
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._EnvId = params.get("EnvId")
        self._EnvType = params.get("EnvType")
        self._Status = params.get("Status")
        self._Scope = params.get("Scope")
        if params.get("CurrentConfigGroupVersionInfos") is not None:
            self._CurrentConfigGroupVersionInfos = []
            for item in params.get("CurrentConfigGroupVersionInfos"):
                obj = ConfigGroupVersionInfo()
                obj._deserialize(item)
                self._CurrentConfigGroupVersionInfos.append(obj)
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ErrorPage(AbstractModel):
    """Custom error page.

    """

    def __init__(self):
        r"""
        :param _StatusCode: Status code. supported values are 400, 403, 404, 405, 414, 416, 451, 500, 501, 502, 503, 504.
        :type StatusCode: int
        :param _RedirectURL: Redirect url. requires a full redirect path, such as https://www.test.com/error.html.
        :type RedirectURL: str
        """
        self._StatusCode = None
        self._RedirectURL = None

    @property
    def StatusCode(self):
        """Status code. supported values are 400, 403, 404, 405, 414, 416, 451, 500, 501, 502, 503, 504.
        :rtype: int
        """
        return self._StatusCode

    @StatusCode.setter
    def StatusCode(self, StatusCode):
        self._StatusCode = StatusCode

    @property
    def RedirectURL(self):
        """Redirect url. requires a full redirect path, such as https://www.test.com/error.html.
        :rtype: str
        """
        return self._RedirectURL

    @RedirectURL.setter
    def RedirectURL(self, RedirectURL):
        self._RedirectURL = RedirectURL


    def _deserialize(self, params):
        self._StatusCode = params.get("StatusCode")
        self._RedirectURL = params.get("RedirectURL")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ErrorPageParameters(AbstractModel):
    """Custom error page configuration parameters.

    """

    def __init__(self):
        r"""
        :param _ErrorPageParams: Custom error page configuration list.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :type ErrorPageParams: list of ErrorPage
        """
        self._ErrorPageParams = None

    @property
    def ErrorPageParams(self):
        """Custom error page configuration list.
Note: this field may return null, which indicates a failure to obtain a valid value.
        :rtype: list of ErrorPage
        """
        return self._ErrorPageParams

    @ErrorPageParams.setter
    def ErrorPageParams(self, ErrorPageParams):
        self._ErrorPageParams = ErrorPageParams


    def _deserialize(self, params):
        if params.get("ErrorPageParams") is not None:
            self._ErrorPageParams = []
            for item in params.get("ErrorPageParams"):
                obj = ErrorPage()
                obj._deserialize(item)
                self._ErrorPageParams.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ErrorPageReference(AbstractModel):
    """Custom error page's referenced source

    """

    def __init__(self):
        r"""
        :param _BusinessId: Referenced business ID, such as the custom block rule ID.
        :type BusinessId: str
        """
        self._BusinessId = None

    @property
    def BusinessId(self):
        """Referenced business ID, such as the custom block rule ID.
        :rtype: str
        """
        return self._BusinessId

    @BusinessId.setter
    def BusinessId(self, BusinessId):
        self._BusinessId = BusinessId


    def _deserialize(self, params):
        self._BusinessId = params.get("BusinessId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExceptConfig(AbstractModel):
    """Exception rules, which are used to bypass specific rules

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable configuration. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _ExceptUserRules: The settings of the exception rule. If it is null, the settings that were last configured will be used.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExceptUserRules: list of ExceptUserRule
        """
        self._Switch = None
        self._ExceptUserRules = None

    @property
    def Switch(self):
        """Whether to enable configuration. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def ExceptUserRules(self):
        """The settings of the exception rule. If it is null, the settings that were last configured will be used.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ExceptUserRule
        """
        return self._ExceptUserRules

    @ExceptUserRules.setter
    def ExceptUserRules(self, ExceptUserRules):
        self._ExceptUserRules = ExceptUserRules


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        if params.get("ExceptUserRules") is not None:
            self._ExceptUserRules = []
            for item in params.get("ExceptUserRules"):
                obj = ExceptUserRule()
                obj._deserialize(item)
                self._ExceptUserRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExceptUserRule(AbstractModel):
    """The settings of the exception rule

    """

    def __init__(self):
        r"""
        :param _RuleName: The rule name.
        :type RuleName: str
        :param _Action: The rule action. It only supports the value `skip`, which indicates skipping all managed rules.
        :type Action: str
        :param _RuleStatus: The rule status. Values:
<li>`on`: Enabled</li>
<li>`off`: Disabled</li>
        :type RuleStatus: str
        :param _RuleID: The rule ID, which is automatically created and only used as an output parameter.
        :type RuleID: int
        :param _UpdateTime: The update time. If it is null, the current date and time is recorded.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type UpdateTime: str
        :param _ExceptUserRuleConditions: The matching condition.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExceptUserRuleConditions: list of ExceptUserRuleCondition
        :param _ExceptUserRuleScope: The scope to which the exception rule applies.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExceptUserRuleScope: :class:`tencentcloud.teo.v20220901.models.ExceptUserRuleScope`
        :param _RulePriority: The rule priority. Value range: 0-100. If it is null, it defaults to 0.
        :type RulePriority: int
        """
        self._RuleName = None
        self._Action = None
        self._RuleStatus = None
        self._RuleID = None
        self._UpdateTime = None
        self._ExceptUserRuleConditions = None
        self._ExceptUserRuleScope = None
        self._RulePriority = None

    @property
    def RuleName(self):
        """The rule name.
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Action(self):
        """The rule action. It only supports the value `skip`, which indicates skipping all managed rules.
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def RuleStatus(self):
        """The rule status. Values:
<li>`on`: Enabled</li>
<li>`off`: Disabled</li>
        :rtype: str
        """
        return self._RuleStatus

    @RuleStatus.setter
    def RuleStatus(self, RuleStatus):
        self._RuleStatus = RuleStatus

    @property
    def RuleID(self):
        """The rule ID, which is automatically created and only used as an output parameter.
        :rtype: int
        """
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def UpdateTime(self):
        """The update time. If it is null, the current date and time is recorded.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ExceptUserRuleConditions(self):
        """The matching condition.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ExceptUserRuleCondition
        """
        return self._ExceptUserRuleConditions

    @ExceptUserRuleConditions.setter
    def ExceptUserRuleConditions(self, ExceptUserRuleConditions):
        self._ExceptUserRuleConditions = ExceptUserRuleConditions

    @property
    def ExceptUserRuleScope(self):
        """The scope to which the exception rule applies.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.teo.v20220901.models.ExceptUserRuleScope`
        """
        return self._ExceptUserRuleScope

    @ExceptUserRuleScope.setter
    def ExceptUserRuleScope(self, ExceptUserRuleScope):
        self._ExceptUserRuleScope = ExceptUserRuleScope

    @property
    def RulePriority(self):
        """The rule priority. Value range: 0-100. If it is null, it defaults to 0.
        :rtype: int
        """
        return self._RulePriority

    @RulePriority.setter
    def RulePriority(self, RulePriority):
        self._RulePriority = RulePriority


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        self._Action = params.get("Action")
        self._RuleStatus = params.get("RuleStatus")
        self._RuleID = params.get("RuleID")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("ExceptUserRuleConditions") is not None:
            self._ExceptUserRuleConditions = []
            for item in params.get("ExceptUserRuleConditions"):
                obj = ExceptUserRuleCondition()
                obj._deserialize(item)
                self._ExceptUserRuleConditions.append(obj)
        if params.get("ExceptUserRuleScope") is not None:
            self._ExceptUserRuleScope = ExceptUserRuleScope()
            self._ExceptUserRuleScope._deserialize(params.get("ExceptUserRuleScope"))
        self._RulePriority = params.get("RulePriority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExceptUserRuleCondition(AbstractModel):
    """The condition of the exception rule

    """

    def __init__(self):
        r"""
        :param _MatchFrom: The field to match. Values:
<li>`host`: Request domain name</li>
<li>`sip`: Client IP</li>
<li>`ua`: User-Agent</li>
<li>`cookie`: Cookie</li>
<li>`cgi`: CGI script</li>
<li>`xff`: XFF header</li>
<li>`url`: Request URL</li>
<li>`accept`: Request content type</li>
<li>`method`: Request method</li>
<li>`header`: Request header</li>
<li>`sip_proto`: Network layer protocol</li>
        :type MatchFrom: str
        :param _MatchParam: The parameter of the field. Only when `MatchFrom = header`, the key contained in the header can be passed.
        :type MatchParam: str
        :param _Operator: The logical operator. Values:
<li>`equal`: String equals</li>
<li>`not_equal`: Value not equals</li>
<li>`include`: String contains</li>
<li>`not_include`: String not contains</li>
<li>`match`: IP matches</li>
<li>`not_match`: IP not matches</li>
<li>`include_area`: Regions contain</li>
<li>`is_empty`: Value left empty</li>
<li>`not_exists`: Key fields not exist</li>
<li>`regexp`: Regex matches</li>
<li>`len_gt`: Value greater than</li>
<li>`len_lt`: Value smaller than</li>
<li>`len_eq`: Value equals</li>
<li>`match_prefix`: Prefix matches</li>
<li>`match_suffix`: Suffix matches</li>
<li>`wildcard`: Wildcard</li>
        :type Operator: str
        :param _MatchContent: The value of the parameter.
        :type MatchContent: str
        """
        self._MatchFrom = None
        self._MatchParam = None
        self._Operator = None
        self._MatchContent = None

    @property
    def MatchFrom(self):
        """The field to match. Values:
<li>`host`: Request domain name</li>
<li>`sip`: Client IP</li>
<li>`ua`: User-Agent</li>
<li>`cookie`: Cookie</li>
<li>`cgi`: CGI script</li>
<li>`xff`: XFF header</li>
<li>`url`: Request URL</li>
<li>`accept`: Request content type</li>
<li>`method`: Request method</li>
<li>`header`: Request header</li>
<li>`sip_proto`: Network layer protocol</li>
        :rtype: str
        """
        return self._MatchFrom

    @MatchFrom.setter
    def MatchFrom(self, MatchFrom):
        self._MatchFrom = MatchFrom

    @property
    def MatchParam(self):
        """The parameter of the field. Only when `MatchFrom = header`, the key contained in the header can be passed.
        :rtype: str
        """
        return self._MatchParam

    @MatchParam.setter
    def MatchParam(self, MatchParam):
        self._MatchParam = MatchParam

    @property
    def Operator(self):
        """The logical operator. Values:
<li>`equal`: String equals</li>
<li>`not_equal`: Value not equals</li>
<li>`include`: String contains</li>
<li>`not_include`: String not contains</li>
<li>`match`: IP matches</li>
<li>`not_match`: IP not matches</li>
<li>`include_area`: Regions contain</li>
<li>`is_empty`: Value left empty</li>
<li>`not_exists`: Key fields not exist</li>
<li>`regexp`: Regex matches</li>
<li>`len_gt`: Value greater than</li>
<li>`len_lt`: Value smaller than</li>
<li>`len_eq`: Value equals</li>
<li>`match_prefix`: Prefix matches</li>
<li>`match_suffix`: Suffix matches</li>
<li>`wildcard`: Wildcard</li>
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def MatchContent(self):
        """The value of the parameter.
        :rtype: str
        """
        return self._MatchContent

    @MatchContent.setter
    def MatchContent(self, MatchContent):
        self._MatchContent = MatchContent


    def _deserialize(self, params):
        self._MatchFrom = params.get("MatchFrom")
        self._MatchParam = params.get("MatchParam")
        self._Operator = params.get("Operator")
        self._MatchContent = params.get("MatchContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExceptUserRuleScope(AbstractModel):
    """The scope to which the exception rule applies

    """

    def __init__(self):
        r"""
        :param _Type: Exception mode. Values:
<li>`complete`: Skip the exception rule for full requests.</li>
<li>`partial`: Skip the exception rule for partial requests.</li>
        :type Type: str
        :param _Modules: The module to be activated. Values:
<li>`waf`: Tencent Cloud-managed rules</li>
<li>`rate`: Rate limiting rules</li>
<li>`acl`: Custom rule</li>
<li>`cc`: CC attack defense</li>
<li>`bot`: Bot protection</li>
Note: this field may return `null`, indicating that no valid value is obtained.
        :type Modules: list of str
        :param _PartialModules: Module settings of the exception rule. If it is null, the settings that were last configured will be used.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type PartialModules: list of PartialModule
        :param _SkipConditions: Condition settings of the exception rule. If it is null, the settings that were last configured will be used.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type SkipConditions: list of SkipCondition
        """
        self._Type = None
        self._Modules = None
        self._PartialModules = None
        self._SkipConditions = None

    @property
    def Type(self):
        """Exception mode. Values:
<li>`complete`: Skip the exception rule for full requests.</li>
<li>`partial`: Skip the exception rule for partial requests.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Modules(self):
        """The module to be activated. Values:
<li>`waf`: Tencent Cloud-managed rules</li>
<li>`rate`: Rate limiting rules</li>
<li>`acl`: Custom rule</li>
<li>`cc`: CC attack defense</li>
<li>`bot`: Bot protection</li>
Note: this field may return `null`, indicating that no valid value is obtained.
        :rtype: list of str
        """
        return self._Modules

    @Modules.setter
    def Modules(self, Modules):
        self._Modules = Modules

    @property
    def PartialModules(self):
        """Module settings of the exception rule. If it is null, the settings that were last configured will be used.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: list of PartialModule
        """
        return self._PartialModules

    @PartialModules.setter
    def PartialModules(self, PartialModules):
        self._PartialModules = PartialModules

    @property
    def SkipConditions(self):
        """Condition settings of the exception rule. If it is null, the settings that were last configured will be used.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: list of SkipCondition
        """
        return self._SkipConditions

    @SkipConditions.setter
    def SkipConditions(self, SkipConditions):
        self._SkipConditions = SkipConditions


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Modules = params.get("Modules")
        if params.get("PartialModules") is not None:
            self._PartialModules = []
            for item in params.get("PartialModules"):
                obj = PartialModule()
                obj._deserialize(item)
                self._PartialModules.append(obj)
        if params.get("SkipConditions") is not None:
            self._SkipConditions = []
            for item in params.get("SkipConditions"):
                obj = SkipCondition()
                obj._deserialize(item)
                self._SkipConditions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExceptionRule(AbstractModel):
    """Web security exception rule.

    """

    def __init__(self):
        r"""
        :param _Id: The ID of the exception rule. different rule configuration operations are supported by rule ID: <li> <b>add</b> a new rule: leave the ID empty or do not specify the ID parameter.</li> <li> <b>modify</b> an existing rule: specify the rule ID that needs to be updated/modified.</li> <li> <b>delete</b> an existing rule: existing Rules not included in the Rules list under the ExceptionRules parameter will be deleted.</li>.
        :type Id: str
        :param _Name: The name of the exception rule.
        :type Name: str
        :param _Condition: Describes the specific content of the exception rule, which must comply with the expression grammar. for details, please refer to the product document.
        :type Condition: str
        :param _SkipScope: Exception rule execution options, valid values: <li>WebSecurityModules: designate the security protection module for the exception rule.</li> <li>ManagedRules: designate the managed rule.</li>.
        :type SkipScope: str
        :param _SkipOption: Skip the specific type of request. valid values: <li>SkipOnAllRequestFields: skip all requests;</li> <li>SkipOnSpecifiedRequestFields: skip specified request fields.</li> valid only when SkipScope is ManagedRules.
        :type SkipOption: str
        :param _WebSecurityModulesForException: Specifies the security protection module for exception rules. valid only when SkipScope is WebSecurityModules. valid values: <li>websec-mod-managed-rules: managed rule.</li><li>websec-mod-rate-limiting: rate limit.</li><li>websec-mod-custom-rules: custom rule.</li><li>websec-mod-adaptive-control: adaptive frequency control, intelligent client filtering, slow attack protection, traffic theft protection.</li><li>websec-mod-bot: bot management.</li>.
        :type WebSecurityModulesForException: list of str
        :param _ManagedRulesForException: Specifies the managed rule for the exception rule. valid only when SkipScope is ManagedRules. cannot specify ManagedRuleGroupsForException at this time.
        :type ManagedRulesForException: list of str
        :param _ManagedRuleGroupsForException: A managed rule group with designated exception rules is valid only when SkipScope is ManagedRules, and at this point you cannot specify ManagedRulesForException.
        :type ManagedRuleGroupsForException: list of str
        :param _RequestFieldsForException: Specify exception rules to skip request fields. valid only when SkipScope is ManagedRules and SkipOption is SkipOnSpecifiedRequestFields.
        :type RequestFieldsForException: list of RequestFieldsForException
        :param _Enabled: Whether the exception rule is enabled. valid values: <li>`on`: enable</li> <li>`off`: disable</li>.
        :type Enabled: str
        """
        self._Id = None
        self._Name = None
        self._Condition = None
        self._SkipScope = None
        self._SkipOption = None
        self._WebSecurityModulesForException = None
        self._ManagedRulesForException = None
        self._ManagedRuleGroupsForException = None
        self._RequestFieldsForException = None
        self._Enabled = None

    @property
    def Id(self):
        """The ID of the exception rule. different rule configuration operations are supported by rule ID: <li> <b>add</b> a new rule: leave the ID empty or do not specify the ID parameter.</li> <li> <b>modify</b> an existing rule: specify the rule ID that needs to be updated/modified.</li> <li> <b>delete</b> an existing rule: existing Rules not included in the Rules list under the ExceptionRules parameter will be deleted.</li>.
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        """The name of the exception rule.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Condition(self):
        """Describes the specific content of the exception rule, which must comply with the expression grammar. for details, please refer to the product document.
        :rtype: str
        """
        return self._Condition

    @Condition.setter
    def Condition(self, Condition):
        self._Condition = Condition

    @property
    def SkipScope(self):
        """Exception rule execution options, valid values: <li>WebSecurityModules: designate the security protection module for the exception rule.</li> <li>ManagedRules: designate the managed rule.</li>.
        :rtype: str
        """
        return self._SkipScope

    @SkipScope.setter
    def SkipScope(self, SkipScope):
        self._SkipScope = SkipScope

    @property
    def SkipOption(self):
        """Skip the specific type of request. valid values: <li>SkipOnAllRequestFields: skip all requests;</li> <li>SkipOnSpecifiedRequestFields: skip specified request fields.</li> valid only when SkipScope is ManagedRules.
        :rtype: str
        """
        return self._SkipOption

    @SkipOption.setter
    def SkipOption(self, SkipOption):
        self._SkipOption = SkipOption

    @property
    def WebSecurityModulesForException(self):
        """Specifies the security protection module for exception rules. valid only when SkipScope is WebSecurityModules. valid values: <li>websec-mod-managed-rules: managed rule.</li><li>websec-mod-rate-limiting: rate limit.</li><li>websec-mod-custom-rules: custom rule.</li><li>websec-mod-adaptive-control: adaptive frequency control, intelligent client filtering, slow attack protection, traffic theft protection.</li><li>websec-mod-bot: bot management.</li>.
        :rtype: list of str
        """
        return self._WebSecurityModulesForException

    @WebSecurityModulesForException.setter
    def WebSecurityModulesForException(self, WebSecurityModulesForException):
        self._WebSecurityModulesForException = WebSecurityModulesForException

    @property
    def ManagedRulesForException(self):
        """Specifies the managed rule for the exception rule. valid only when SkipScope is ManagedRules. cannot specify ManagedRuleGroupsForException at this time.
        :rtype: list of str
        """
        return self._ManagedRulesForException

    @ManagedRulesForException.setter
    def ManagedRulesForException(self, ManagedRulesForException):
        self._ManagedRulesForException = ManagedRulesForException

    @property
    def ManagedRuleGroupsForException(self):
        """A managed rule group with designated exception rules is valid only when SkipScope is ManagedRules, and at this point you cannot specify ManagedRulesForException.
        :rtype: list of str
        """
        return self._ManagedRuleGroupsForException

    @ManagedRuleGroupsForException.setter
    def ManagedRuleGroupsForException(self, ManagedRuleGroupsForException):
        self._ManagedRuleGroupsForException = ManagedRuleGroupsForException

    @property
    def RequestFieldsForException(self):
        """Specify exception rules to skip request fields. valid only when SkipScope is ManagedRules and SkipOption is SkipOnSpecifiedRequestFields.
        :rtype: list of RequestFieldsForException
        """
        return self._RequestFieldsForException

    @RequestFieldsForException.setter
    def RequestFieldsForException(self, RequestFieldsForException):
        self._RequestFieldsForException = RequestFieldsForException

    @property
    def Enabled(self):
        """Whether the exception rule is enabled. valid values: <li>`on`: enable</li> <li>`off`: disable</li>.
        :rtype: str
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Condition = params.get("Condition")
        self._SkipScope = params.get("SkipScope")
        self._SkipOption = params.get("SkipOption")
        self._WebSecurityModulesForException = params.get("WebSecurityModulesForException")
        self._ManagedRulesForException = params.get("ManagedRulesForException")
        self._ManagedRuleGroupsForException = params.get("ManagedRuleGroupsForException")
        if params.get("RequestFieldsForException") is not None:
            self._RequestFieldsForException = []
            for item in params.get("RequestFieldsForException"):
                obj = RequestFieldsForException()
                obj._deserialize(item)
                self._RequestFieldsForException.append(obj)
        self._Enabled = params.get("Enabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExceptionRules(AbstractModel):
    """Web security exception rules.

    """

    def __init__(self):
        r"""
        :param _Rules: Definition list of exception Rules. when using ModifySecurityPolicy to modify Web protection configuration: <li>if the Rules parameter is not specified or the parameter length is zero: clear all exception rule configurations.</li><li>if the ExceptionRules parameter value is not specified in SecurityPolicy: keep existing exception rule configurations without modification.</li>.
        :type Rules: list of ExceptionRule
        """
        self._Rules = None

    @property
    def Rules(self):
        """Definition list of exception Rules. when using ModifySecurityPolicy to modify Web protection configuration: <li>if the Rules parameter is not specified or the parameter length is zero: clear all exception rule configurations.</li><li>if the ExceptionRules parameter value is not specified in SecurityPolicy: keep existing exception rule configurations without modification.</li>.
        :rtype: list of ExceptionRule
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = ExceptionRule()
                obj._deserialize(item)
                self._Rules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportZoneConfigRequest(AbstractModel):
    """ExportZoneConfig request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Types: It indicates exporting the type list of configuration . If it is left blank, all types of configurations will be exported. Currently supported valid values:<li>L7AccelerationConfig: It indicates exporting the Layer-7 acceleration configuration, corresponding to the console's "Site Acceleration - Global Acceleration Configuration" and "Site Acceleration - Rule Engine".</li>
Note: The types that will be supported for export in the future will increase with iterations. When exporting all types, pay attention to the export file size. It is recommended to specify the configuration types to be exported to control the request and response packet payload size.
        :type Types: list of str
        """
        self._ZoneId = None
        self._Types = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Types(self):
        """It indicates exporting the type list of configuration . If it is left blank, all types of configurations will be exported. Currently supported valid values:<li>L7AccelerationConfig: It indicates exporting the Layer-7 acceleration configuration, corresponding to the console's "Site Acceleration - Global Acceleration Configuration" and "Site Acceleration - Rule Engine".</li>
Note: The types that will be supported for export in the future will increase with iterations. When exporting all types, pay attention to the export file size. It is recommended to specify the configuration types to be exported to control the request and response packet payload size.
        :rtype: list of str
        """
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Types = params.get("Types")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportZoneConfigResponse(AbstractModel):
    """ExportZoneConfig response structure.

    """

    def __init__(self):
        r"""
        :param _Content: The specific content of the exported configuration, returned in the JSON format and encoded in the UTF-8 mode. Refer to the example below for the configuration content.
        :type Content: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Content = None
        self._RequestId = None

    @property
    def Content(self):
        """The specific content of the exported configuration, returned in the JSON format and encoded in the UTF-8 mode. Refer to the example below for the configuration content.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Content = params.get("Content")
        self._RequestId = params.get("RequestId")


class FailReason(AbstractModel):
    """Failure reason

    """

    def __init__(self):
        r"""
        :param _Reason: Failure reason.
        :type Reason: str
        :param _Targets: List of resources failed to be processed. 
        :type Targets: list of str
        """
        self._Reason = None
        self._Targets = None

    @property
    def Reason(self):
        """Failure reason.
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def Targets(self):
        """List of resources failed to be processed. 
        :rtype: list of str
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets


    def _deserialize(self, params):
        self._Reason = params.get("Reason")
        self._Targets = params.get("Targets")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FileAscriptionInfo(AbstractModel):
    """Verification file, used to verify site ownership

    """

    def __init__(self):
        r"""
        :param _IdentifyPath: Directory of the verification file.
        :type IdentifyPath: str
        :param _IdentifyContent: Content of the verification file.
        :type IdentifyContent: str
        """
        self._IdentifyPath = None
        self._IdentifyContent = None

    @property
    def IdentifyPath(self):
        """Directory of the verification file.
        :rtype: str
        """
        return self._IdentifyPath

    @IdentifyPath.setter
    def IdentifyPath(self, IdentifyPath):
        self._IdentifyPath = IdentifyPath

    @property
    def IdentifyContent(self):
        """Content of the verification file.
        :rtype: str
        """
        return self._IdentifyContent

    @IdentifyContent.setter
    def IdentifyContent(self, IdentifyContent):
        self._IdentifyContent = IdentifyContent


    def _deserialize(self, params):
        self._IdentifyPath = params.get("IdentifyPath")
        self._IdentifyContent = params.get("IdentifyContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FileVerification(AbstractModel):
    """Information required for verifying via a file. It's applicable to sites connected via CNAMEs.

    """

    def __init__(self):
        r"""
        :param _Path: EdgeOne obtains the file verification information in the format of "Scheme + Host + URL Path", (e.g. https://www.example.com/.well-known/teo-verification/z12h416twn.txt). This field is the URL path section of the URL you need to create.
        :type Path: str
        :param _Content: Content of the verification file. The contents of this field need to be filled into the text file returned by `Path`.
        :type Content: str
        """
        self._Path = None
        self._Content = None

    @property
    def Path(self):
        """EdgeOne obtains the file verification information in the format of "Scheme + Host + URL Path", (e.g. https://www.example.com/.well-known/teo-verification/z12h416twn.txt). This field is the URL path section of the URL you need to create.
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Content(self):
        """Content of the verification file. The contents of this field need to be filled into the text file returned by `Path`.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Path = params.get("Path")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    """Key-value pair filters for conditional filtering queries, such as filtering ID, name, and status.
    If more than one filter exists, the logical relationship between these filters is `AND`.
    If multiple values exist in one filter, the logical relationship between these values under the same filter is `OR`.

    """

    def __init__(self):
        r"""
        :param _Name: Fields to be filtered.
        :type Name: str
        :param _Values: Value of the filtered field.
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        """Fields to be filtered.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        """Value of the filtered field.
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FirstPartConfig(AbstractModel):
    """The configuration to detect slow attacks based on the transfer period the first 8 KB of requests

    """

    def __init__(self):
        r"""
        :param _Switch: Switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type Switch: str
        :param _StatTime: The transfer period threshold of the first 8 KB. If the threshold is reached, it’s considered a slow attack. Default: `5`.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type StatTime: int
        """
        self._Switch = None
        self._StatTime = None

    @property
    def Switch(self):
        """Switch. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def StatTime(self):
        """The transfer period threshold of the first 8 KB. If the threshold is reached, it’s considered a slow attack. Default: `5`.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._StatTime

    @StatTime.setter
    def StatTime(self, StatTime):
        self._StatTime = StatTime


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._StatTime = params.get("StatTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FollowOrigin(AbstractModel):
    """Following origin server configuration for caching.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the configuration of following the origin server. Valid values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _DefaultCache: Whether to cache when an origin server does not return the cache-control header. this field is required when switch is on; when switch is off, this field is not required and will be ineffective if filled. valid values:.
<Li>On: cache;</li>.
<Li>Off: do not cache.</li>.
        :type DefaultCache: str
        :param _DefaultCacheStrategy: Whether to use the default caching policy when an origin server does not return the cache-control header. this field is required when defaultcache is set to on; otherwise, it is ineffective. when defaultcachetime is not 0, this field should be off. valid values:.
<Li>On: use the default caching policy.</li>.
<Li>Off: do not use the default caching policy.</li>.
        :type DefaultCacheStrategy: str
        :param _DefaultCacheTime: The default cache time in seconds when an origin server does not return the cache-control header. the value ranges from 0 to 315360000. this field is required when defaultcache is set to on; otherwise, it is ineffective. when defaultcachestrategy is on, this field should be 0.
        :type DefaultCacheTime: int
        """
        self._Switch = None
        self._DefaultCache = None
        self._DefaultCacheStrategy = None
        self._DefaultCacheTime = None

    @property
    def Switch(self):
        """Whether to enable the configuration of following the origin server. Valid values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def DefaultCache(self):
        """Whether to cache when an origin server does not return the cache-control header. this field is required when switch is on; when switch is off, this field is not required and will be ineffective if filled. valid values:.
<Li>On: cache;</li>.
<Li>Off: do not cache.</li>.
        :rtype: str
        """
        return self._DefaultCache

    @DefaultCache.setter
    def DefaultCache(self, DefaultCache):
        self._DefaultCache = DefaultCache

    @property
    def DefaultCacheStrategy(self):
        """Whether to use the default caching policy when an origin server does not return the cache-control header. this field is required when defaultcache is set to on; otherwise, it is ineffective. when defaultcachetime is not 0, this field should be off. valid values:.
<Li>On: use the default caching policy.</li>.
<Li>Off: do not use the default caching policy.</li>.
        :rtype: str
        """
        return self._DefaultCacheStrategy

    @DefaultCacheStrategy.setter
    def DefaultCacheStrategy(self, DefaultCacheStrategy):
        self._DefaultCacheStrategy = DefaultCacheStrategy

    @property
    def DefaultCacheTime(self):
        """The default cache time in seconds when an origin server does not return the cache-control header. the value ranges from 0 to 315360000. this field is required when defaultcache is set to on; otherwise, it is ineffective. when defaultcachestrategy is on, this field should be 0.
        :rtype: int
        """
        return self._DefaultCacheTime

    @DefaultCacheTime.setter
    def DefaultCacheTime(self, DefaultCacheTime):
        self._DefaultCacheTime = DefaultCacheTime


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._DefaultCache = params.get("DefaultCache")
        self._DefaultCacheStrategy = params.get("DefaultCacheStrategy")
        self._DefaultCacheTime = params.get("DefaultCacheTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ForceRedirect(AbstractModel):
    """Forced HTTPS redirect configuration for access protocols.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable force HTTPS redirect. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :type Switch: str
        :param _RedirectStatusCode: Redirect status code. Values:
<li>`301`: 301 redirect</li>
<li>`302`: 302 redirect</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type RedirectStatusCode: int
        """
        self._Switch = None
        self._RedirectStatusCode = None

    @property
    def Switch(self):
        """Whether to enable force HTTPS redirect. Values:
<li>`on`: Enable</li>
<li>`off`: Disable</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def RedirectStatusCode(self):
        """Redirect status code. Values:
<li>`301`: 301 redirect</li>
<li>`302`: 302 redirect</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RedirectStatusCode

    @RedirectStatusCode.setter
    def RedirectStatusCode(self, RedirectStatusCode):
        self._RedirectStatusCode = RedirectStatusCode


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._RedirectStatusCode = params.get("RedirectStatusCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ForceRedirectHTTPSParameters(AbstractModel):
    """Forced HTTPS redirect configuration for access protocols.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable forced redirect configuration switch. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _RedirectStatusCode: Redirection status code. this field is required when switch is on; otherwise, it is not effective. valid values are:.
<Li>`301`: 301 redirect;</li>.
<Li>`302`: 302 redirect.</li>.
        :type RedirectStatusCode: int
        """
        self._Switch = None
        self._RedirectStatusCode = None

    @property
    def Switch(self):
        """Whether to enable forced redirect configuration switch. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def RedirectStatusCode(self):
        """Redirection status code. this field is required when switch is on; otherwise, it is not effective. valid values are:.
<Li>`301`: 301 redirect;</li>.
<Li>`302`: 302 redirect.</li>.
        :rtype: int
        """
        return self._RedirectStatusCode

    @RedirectStatusCode.setter
    def RedirectStatusCode(self, RedirectStatusCode):
        self._RedirectStatusCode = RedirectStatusCode


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._RedirectStatusCode = params.get("RedirectStatusCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Function(AbstractModel):
    """Details of an edge function.

    """

    def __init__(self):
        r"""
        :param _FunctionId: Function ID.
        :type FunctionId: str
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _Name: Function name.
        :type Name: str
        :param _Remark: Function description.
        :type Remark: str
        :param _Content: Function content.
        :type Content: str
        :param _Domain: Default domain name of a function.
        :type Domain: str
        :param _CreateTime: Creation time, which adopts Coordinated Universal Time (UTC) and follows the date and time format of the ISO 8601 standard.
        :type CreateTime: str
        :param _UpdateTime: Modification time, which adopts Coordinated Universal Time (UTC) and follows the date and time format of the ISO 8601 standard.
        :type UpdateTime: str
        """
        self._FunctionId = None
        self._ZoneId = None
        self._Name = None
        self._Remark = None
        self._Content = None
        self._Domain = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def FunctionId(self):
        """Function ID.
        :rtype: str
        """
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Name(self):
        """Function name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        """Function description.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Content(self):
        """Function content.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Domain(self):
        """Default domain name of a function.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def CreateTime(self):
        """Creation time, which adopts Coordinated Universal Time (UTC) and follows the date and time format of the ISO 8601 standard.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """Modification time, which adopts Coordinated Universal Time (UTC) and follows the date and time format of the ISO 8601 standard.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ZoneId = params.get("ZoneId")
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        self._Content = params.get("Content")
        self._Domain = params.get("Domain")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FunctionEnvironmentVariable(AbstractModel):
    """Environment variables of an edge function

    """

    def __init__(self):
        r"""
        :param _Key: Variable name, which should be unique and can only contain uppercase and lowercase letters, digits, and special characters including at signs (@), periods (.), hyphens (-), and underscores (_). Its maximum size is 64 bytes.
        :type Key: str
        :param _Value: Variable value. Its maximum size is 5000 bytes. The default value is empty.
        :type Value: str
        :param _Type: Variable type. Valid values:
<li>string: string type;</li>
<li>json: JSON object type.</li>Default value: string.
        :type Type: str
        """
        self._Key = None
        self._Value = None
        self._Type = None

    @property
    def Key(self):
        """Variable name, which should be unique and can only contain uppercase and lowercase letters, digits, and special characters including at signs (@), periods (.), hyphens (-), and underscores (_). Its maximum size is 64 bytes.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        """Variable value. Its maximum size is 5000 bytes. The default value is empty.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Type(self):
        """Variable type. Valid values:
<li>string: string type;</li>
<li>json: JSON object type.</li>Default value: string.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FunctionRule(AbstractModel):
    """Trigger rules for an edge function

    """

    def __init__(self):
        r"""
        :param _RuleId: Rule ID.
        :type RuleId: str
        :param _FunctionRuleConditions: Rule condition list. There is an OR relationship between items in the list.
        :type FunctionRuleConditions: list of FunctionRuleCondition
        :param _FunctionId: Function ID, specifying a function executed when a trigger rule condition is met.
        :type FunctionId: str
        :param _Remark: Rule description.
        :type Remark: str
        :param _FunctionName: Function name.
        :type FunctionName: str
        :param _Priority: Priority of a trigger rule for a function. The larger the value, the higher the priority.
        :type Priority: int
        :param _CreateTime: Creation time, which adopts Coordinated Universal Time (UTC) and follows the date and time format of the ISO 8601 standard.
        :type CreateTime: str
        :param _UpdateTime: Update time, which adopts Coordinated Universal Time (UTC) and follows the date and time format of the ISO 8601 standard.
        :type UpdateTime: str
        """
        self._RuleId = None
        self._FunctionRuleConditions = None
        self._FunctionId = None
        self._Remark = None
        self._FunctionName = None
        self._Priority = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def RuleId(self):
        """Rule ID.
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def FunctionRuleConditions(self):
        """Rule condition list. There is an OR relationship between items in the list.
        :rtype: list of FunctionRuleCondition
        """
        return self._FunctionRuleConditions

    @FunctionRuleConditions.setter
    def FunctionRuleConditions(self, FunctionRuleConditions):
        self._FunctionRuleConditions = FunctionRuleConditions

    @property
    def FunctionId(self):
        """Function ID, specifying a function executed when a trigger rule condition is met.
        :rtype: str
        """
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def Remark(self):
        """Rule description.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def FunctionName(self):
        """Function name.
        :rtype: str
        """
        return self._FunctionName

    @FunctionName.setter
    def FunctionName(self, FunctionName):
        self._FunctionName = FunctionName

    @property
    def Priority(self):
        """Priority of a trigger rule for a function. The larger the value, the higher the priority.
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def CreateTime(self):
        """Creation time, which adopts Coordinated Universal Time (UTC) and follows the date and time format of the ISO 8601 standard.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """Update time, which adopts Coordinated Universal Time (UTC) and follows the date and time format of the ISO 8601 standard.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        if params.get("FunctionRuleConditions") is not None:
            self._FunctionRuleConditions = []
            for item in params.get("FunctionRuleConditions"):
                obj = FunctionRuleCondition()
                obj._deserialize(item)
                self._FunctionRuleConditions.append(obj)
        self._FunctionId = params.get("FunctionId")
        self._Remark = params.get("Remark")
        self._FunctionName = params.get("FunctionName")
        self._Priority = params.get("Priority")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FunctionRuleCondition(AbstractModel):
    """Condition of a trigger rule for an edge function.

    """

    def __init__(self):
        r"""
        :param _RuleConditions: Condition of a trigger rule for an edge function. This condition is considered met if all items in the list are met.
        :type RuleConditions: list of RuleCondition
        """
        self._RuleConditions = None

    @property
    def RuleConditions(self):
        """Condition of a trigger rule for an edge function. This condition is considered met if all items in the list are met.
        :rtype: list of RuleCondition
        """
        return self._RuleConditions

    @RuleConditions.setter
    def RuleConditions(self, RuleConditions):
        self._RuleConditions = RuleConditions


    def _deserialize(self, params):
        if params.get("RuleConditions") is not None:
            self._RuleConditions = []
            for item in params.get("RuleConditions"):
                obj = RuleCondition()
                obj._deserialize(item)
                self._RuleConditions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Grpc(AbstractModel):
    """Configuration of gRPC support

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable gRPC support. Valid values: 
<li>`on`: Enable;</li>
<li>`off`: Disable.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """Whether to enable gRPC support. Valid values: 
<li>`on`: Enable;</li>
<li>`off`: Disable.</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GrpcParameters(AbstractModel):
    """gRPC configuration item.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable grpc. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """Whether to enable grpc. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HSTSParameters(AbstractModel):
    """HSTS configuration parameters.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable hsts. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        :param _Timeout: Cache hsts header time, unit: seconds. value range: 1-31536000.<br>note: this field is required when switch is on; when switch is off, this field is not required and will not take effect if filled.
        :type Timeout: int
        :param _IncludeSubDomains: Whether to allow other subdomains to inherit the same hsts header. values:.
<Li>On: allows other subdomains to inherit the same hsts header.</li>.
<Li>Off: does not allow other subdomains to inherit the same hsts header.</li> note: when switch is on, this field is required; when switch is off, this field is not required and will not take effect if filled.
        :type IncludeSubDomains: str
        :param _Preload: Whether to allow the browser to preload the hsts header. valid values:.
<Li>On: allows the browser to preload the hsts header.</li>.
<Li>Off: does not allow the browser to preload the hsts header.</li> note: when switch is on, this field is required; when switch is off, this field is not required and will not take effect if filled.
        :type Preload: str
        """
        self._Switch = None
        self._Timeout = None
        self._IncludeSubDomains = None
        self._Preload = None

    @property
    def Switch(self):
        """Whether to enable hsts. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Timeout(self):
        """Cache hsts header time, unit: seconds. value range: 1-31536000.<br>note: this field is required when switch is on; when switch is off, this field is not required and will not take effect if filled.
        :rtype: int
        """
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout

    @property
    def IncludeSubDomains(self):
        """Whether to allow other subdomains to inherit the same hsts header. values:.
<Li>On: allows other subdomains to inherit the same hsts header.</li>.
<Li>Off: does not allow other subdomains to inherit the same hsts header.</li> note: when switch is on, this field is required; when switch is off, this field is not required and will not take effect if filled.
        :rtype: str
        """
        return self._IncludeSubDomains

    @IncludeSubDomains.setter
    def IncludeSubDomains(self, IncludeSubDomains):
        self._IncludeSubDomains = IncludeSubDomains

    @property
    def Preload(self):
        """Whether to allow the browser to preload the hsts header. valid values:.
<Li>On: allows the browser to preload the hsts header.</li>.
<Li>Off: does not allow the browser to preload the hsts header.</li> note: when switch is on, this field is required; when switch is off, this field is not required and will not take effect if filled.
        :rtype: str
        """
        return self._Preload

    @Preload.setter
    def Preload(self, Preload):
        self._Preload = Preload


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Timeout = params.get("Timeout")
        self._IncludeSubDomains = params.get("IncludeSubDomains")
        self._Preload = params.get("Preload")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HTTP2Parameters(AbstractModel):
    """HTTP2 integration configuration parameters.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable http2 access. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """Whether to enable http2 access. values:.
<Li>`On`: enable;</li>
.
<Li>Off: disable.</li>.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HTTPResponseParameters(AbstractModel):
    """HTTP response configuration parameters.

    """

    def __init__(self):
        r"""
        :param _StatusCode: Response status code. supports 2xx, 4xx, 5xx, excluding 499, 514, 101, 301, 302, 303, 509, 520-599.
        :type StatusCode: int
        :param _ResponsePage: Response page id.
        :type ResponsePage: str
        """
        self._StatusCode = None
        self._ResponsePage = None

    @property
    def StatusCode(self):
        """Response status code. supports 2xx, 4xx, 5xx, excluding 499, 514, 101, 301, 302, 303, 509, 520-599.
        :rtype: int
        """
        return self._StatusCode

    @StatusCode.setter
    def StatusCode(self, StatusCode):
        self._StatusCode = StatusCode

    @property
    def ResponsePage(self):
        """Response page id.
        :rtype: str
        """
        return self._ResponsePage

    @ResponsePage.setter
    def ResponsePage(self, ResponsePage):
        self._ResponsePage = ResponsePage


    def _deserialize(self, params):
        self._StatusCode = params.get("StatusCode")
        self._ResponsePage = params.get("ResponsePage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HTTPUpstreamTimeoutParameters(AbstractModel):
    """Layer-7 origin-pull timeout configuration.

    """

    def __init__(self):
        r"""
        :param _ResponseTimeout: HTTP response timeout in seconds. value range: 5–600.
        :type ResponseTimeout: int
        """
        self._ResponseTimeout = None

    @property
    def ResponseTimeout(self):
        """HTTP response timeout in seconds. value range: 5–600.
        :rtype: int
        """
        return self._ResponseTimeout

    @ResponseTimeout.setter
    def ResponseTimeout(self, ResponseTimeout):
        self._ResponseTimeout = ResponseTimeout


    def _deserialize(self, params):
        self._ResponseTimeout = params.get("ResponseTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HandleFunctionRuntimeEnvironmentRequest(AbstractModel):
    """HandleFunctionRuntimeEnvironment request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Zone ID.
        :type ZoneId: str
        :param _FunctionId: Function ID.
        :type FunctionId: str
        :param _Operation: Operation type. Valid values:
<li>setEnvironmentVariable: Set an environment variable. If the environment variable exists, it will be modified; otherwise, it will be added.</li>
<li>deleteEnvironmentVariable: Delete an environment variable.</li>
<li>clearEnvironmentVariable: Clear an environment variable.</li>
<li>resetEnvironmentVariable: Reset an environment variable.</li>
        :type Operation: str
        :param _EnvironmentVariables: Environment variable list. The runtime environment of a function supports up to 64 variables. This parameter is required when the value of Operation is setEnvironmentVariable, deleteEnvironmentVariable, or resetEnvironmentVariable.
        :type EnvironmentVariables: list of FunctionEnvironmentVariable
        """
        self._ZoneId = None
        self._FunctionId = None
        self._Operation = None
        self._EnvironmentVariables = None

    @property
    def ZoneId(self):
        """Zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def FunctionId(self):
        """Function ID.
        :rtype: str
        """
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def Operation(self):
        """Operation type. Valid values:
<li>setEnvironmentVariable: Set an environment variable. If the environment variable exists, it will be modified; otherwise, it will be added.</li>
<li>deleteEnvironmentVariable: Delete an environment variable.</li>
<li>clearEnvironmentVariable: Clear an environment variable.</li>
<li>resetEnvironmentVariable: Reset an environment variable.</li>
        :rtype: str
        """
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def EnvironmentVariables(self):
        """Environment variable list. The runtime environment of a function supports up to 64 variables. This parameter is required when the value of Operation is setEnvironmentVariable, deleteEnvironmentVariable, or resetEnvironmentVariable.
        :rtype: list of FunctionEnvironmentVariable
        """
        return self._EnvironmentVariables

    @EnvironmentVariables.setter
    def EnvironmentVariables(self, EnvironmentVariables):
        self._EnvironmentVariables = EnvironmentVariables


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._FunctionId = params.get("FunctionId")
        self._Operation = params.get("Operation")
        if params.get("EnvironmentVariables") is not None:
            self._EnvironmentVariables = []
            for item in params.get("EnvironmentVariables"):
                obj = FunctionEnvironmentVariable()
                obj._deserialize(item)
                self._EnvironmentVariables.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HandleFunctionRuntimeEnvironmentResponse(AbstractModel):
    """HandleFunctionRuntimeEnvironment response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Header(AbstractModel):
    """HTTP header, used as input for the CreatePrefetchTask API

    """

    def __init__(self):
        r"""
        :param _Name: HTTP header name.
        :type Name: str
        :param _Value: HTTP header value
        :type Value: str
        """
        self._Name = None
        self._Value = None

    @property
    def Name(self):
        """HTTP header name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        """HTTP header value
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HeaderAction(AbstractModel):
    """HTTP header setting rules.

    """

    def __init__(self):
        r"""
        :param _Action: HTTP header setting methods. valid values are:.
<Li>`Set`: sets a value for an existing header parameter;</li>.
<Li>`Del`: deletes a header parameter;</li>.
<Li>`Add`: adds a header parameter.</li>.
        :type Action: str
        :param _Name: HTTP header name.
        :type Name: str
        :param _Value: HTTP header value. this parameter is required when the action is set to `set` or `add`; it is optional when the action is set to `del`.
        :type Value: str
        """
        self._Action = None
        self._Name = None
        self._Value = None

    @property
    def Action(self):
        """HTTP header setting methods. valid values are:.
<Li>`Set`: sets a value for an existing header parameter;</li>.
<Li>`Del`: deletes a header parameter;</li>.
<Li>`Add`: adds a header parameter.</li>.
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Name(self):
        """HTTP header name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        """HTTP header value. this parameter is required when the action is set to `set` or `add`; it is optional when the action is set to `del`.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Action = params.get("Action")
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HealthChecker(AbstractModel):
    """LoadBalancer health check policy.

    """

    def __init__(self):
        r"""
        :param _Type: Health check policy. Valid values:
<li>HTTP.</li>
<li>HTTPS.</li>
<li>TCP.</li>
<li>UDP.</li>
<li>ICMP Ping.</li>
<li>NoCheck.</li>
Note: NoCheck means the health check policy is not enabled.
        :type Type: str
        :param _Port: Check port, which is required when Type = HTTP, Type = HTTPS, Type = TCP, or Type = UDP.
        :type Port: int
        :param _Interval: Check frequency, in seconds. It indicates how often a health check task is initiated. Valid values: 30, 60, 180, 300, 600.
        :type Interval: int
        :param _Timeout: Timeout for each health check, in seconds. If the health check time exceeds this value, the check result is determined as "unhealthy". The default value is 5s, and the value should be less than Interval.
        :type Timeout: int
        :param _HealthThreshold: Healthy state threshold, in the number of times. It indicates that if the consecutive health check results are "healthy" for a certain number of times, an origin server is considered "healthy". The default value is 3 times, with the minimum value of 1 time.
        :type HealthThreshold: int
        :param _CriticalThreshold: Unhealthy state threshold, in the number of times. It indicates that if the consecutive health check results are "unhealthy" for a certain number of times, an origin server is considered "unhealthy". The default value is 2 times.
        :type CriticalThreshold: int
        :param _Path: Probe path. This parameter is valid only when Type = HTTP or Type = HTTPS. It needs to include the complete host/path and should not contain a protocol, for example, www.example.com/test.

        :type Path: str
        :param _Method: Request method. This parameter is valid only when Type = HTTP or Type = HTTPS. Valid values:
<li>GET.</li>
<li>HEAD.</li>
        :type Method: str
        :param _ExpectedCodes: The status codes used to determine that the probe result is healthy when the probe node initiates a health check to an origin server. This parameter is valid only when Type = HTTP or Type = HTTPS.
        :type ExpectedCodes: list of str
        :param _Headers: The custom HTTP request header carried by a probe request, with a maximum value of 10. This parameter is valid only when Type = HTTP or Type = HTTPS.
        :type Headers: list of CustomizedHeader
        :param _FollowRedirect: Whether to follow 301/302 redirect. When enabled, 301/302 is considered a "healthy" status code, redirecting 3 times by default. This parameter is valid only when Type = HTTP or Type = HTTPS.
        :type FollowRedirect: str
        :param _SendContext: The content sent by a health check. Only ASCII visible characters are allowed, with up to 500 characters. This parameter is valid only when Type = UDP.
        :type SendContext: str
        :param _RecvContext: The expected return result from an origin server during health check. Only ASCII visible characters are allowed, with up to 500 characters. This parameter is valid only when Type = UDP.
        :type RecvContext: str
        """
        self._Type = None
        self._Port = None
        self._Interval = None
        self._Timeout = None
        self._HealthThreshold = None
        self._CriticalThreshold = None
        self._Path = None
        self._Method = None
        self._ExpectedCodes = None
        self._Headers = None
        self._FollowRedirect = None
        self._SendContext = None
        self._RecvContext = None

    @property
    def Type(self):
        """Health check policy. Valid values:
<li>HTTP.</li>
<li>HTTPS.</li>
<li>TCP.</li>
<li>UDP.</li>
<li>ICMP Ping.</li>
<li>NoCheck.</li>
Note: NoCheck means the health check policy is not enabled.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Port(self):
        """Check port, which is required when Type = HTTP, Type = HTTPS, Type = TCP, or Type = UDP.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Interval(self):
        """Check frequency, in seconds. It indicates how often a health check task is initiated. Valid values: 30, 60, 180, 300, 600.
        :rtype: int
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Timeout(self):
        """Timeout for each health check, in seconds. If the health check time exceeds this value, the check result is determined as "unhealthy". The default value is 5s, and the value should be less than Interval.
        :rtype: int
        """
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout

    @property
    def HealthThreshold(self):
        """Healthy state threshold, in the number of times. It indicates that if the consecutive health check results are "healthy" for a certain number of times, an origin server is considered "healthy". The default value is 3 times, with the minimum value of 1 time.
        :rtype: int
        """
        return self._HealthThreshold

    @HealthThreshold.setter
    def HealthThreshold(self, HealthThreshold):
        self._HealthThreshold = HealthThreshold

    @property
    def CriticalThreshold(self):
        """Unhealthy state threshold, in the number of times. It indicates that if the consecutive health check results are "unhealthy" for a certain number of times, an origin server is considered "unhealthy". The default value is 2 times.
        :rtype: int
        """
        return self._CriticalThreshold

    @CriticalThreshold.setter
    def CriticalThreshold(self, CriticalThreshold):
        self._CriticalThreshold = CriticalThreshold

    @property
    def Path(self):
        """Probe path. This parameter is valid only when Type = HTTP or Type = HTTPS. It needs to include the complete host/path and should not contain a protocol, for example, www.example.com/test.

        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Method(self):
        """Request method. This parameter is valid only when Type = HTTP or Type = HTTPS. Valid values:
<li>GET.</li>
<li>HEAD.</li>
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def ExpectedCodes(self):
        """The status codes used to determine that the probe result is healthy when the probe node initiates a health check to an origin server. This parameter is valid only when Type = HTTP or Type = HTTPS.
        :rtype: list of str
        """
        return self._ExpectedCodes

    @ExpectedCodes.setter
    def ExpectedCodes(self, ExpectedCodes):
        self._ExpectedCodes = ExpectedCodes

    @property
    def Headers(self):
        """The custom HTTP request header carried by a probe request, with a maximum value of 10. This parameter is valid only when Type = HTTP or Type = HTTPS.
        :rtype: list of CustomizedHeader
        """
        return self._Headers

    @Headers.setter
    def Headers(self, Headers):
        self._Headers = Headers

    @property
    def FollowRedirect(self):
        """Whether to follow 301/302 redirect. When enabled, 301/302 is considered a "healthy" status code, redirecting 3 times by default. This parameter is valid only when Type = HTTP or Type = HTTPS.
        :rtype: str
        """
        return self._FollowRedirect

    @FollowRedirect.setter
    def FollowRedirect(self, FollowRedirect):
        self._FollowRedirect = FollowRedirect

    @property
    def SendContext(self):
        """The content sent by a health check. Only ASCII visible characters are allowed, with up to 500 characters. This parameter is valid only when Type = UDP.
        :rtype: str
        """
        return self._SendContext

    @SendContext.setter
    def SendContext(self, SendContext):
        self._SendContext = SendContext

    @property
    def RecvContext(self):
        """The expected return result from an origin server during health check. Only ASCII visible characters are allowed, with up to 500 characters. This parameter is valid only when Type = UDP.
        :rtype: str
        """
        return self._RecvContext

    @RecvContext.setter
    def RecvContext(self, RecvContext):
        self._RecvContext = RecvContext


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Port = params.get("Port")
        self._Interval = params.get("Interval")
        self._Timeout = params.get("Timeout")
        self._HealthThreshold = params.get("HealthThreshold")
        self._CriticalThreshold = params.get("CriticalThreshold")
        self._Path = params.get("Path")
        self._Method = params.get("Method")
        self._ExpectedCodes = params.get("ExpectedCodes")
        if params.get("Headers") is not None:
            self._Headers = []
            for item in params.get("Headers"):
                obj = CustomizedHeader()
                obj._deserialize(item)
                self._Headers.append(obj)
        self._FollowRedirect = params.get("FollowRedirect")
        self._SendContext = params.get("SendContext")
        self._RecvContext = params.get("RecvContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HostHeaderParameters(AbstractModel):
    """Host Header Rewrite configuration parameters.

    """

    def __init__(self):
        r"""
        :param _Action: Action to be executed. values:.
<Li>FollowOrigin: follow origin server domain name;</li>.
<Li>`Custom`: custom</li>.
        :type Action: str
        :param _ServerName: Host header rewrite requires a complete domain name.<br>note: this field is required when switch is on; when switch is off, this field is not required and any value will be ignored.
        :type ServerName: str
        """
        self._Action = None
        self._ServerName = None

    @property
    def Action(self):
        """Action to be executed. values:.
<Li>FollowOrigin: follow origin server domain name;</li>.
<Li>`Custom`: custom</li>.
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def ServerName(self):
        """Host header rewrite requires a complete domain name.<br>note: this field is required when switch is on; when switch is off, this field is not required and any value will be ignored.
        :rtype: str
        """
        return self._ServerName

    @ServerName.setter
    def ServerName(self, ServerName):
        self._ServerName = ServerName


    def _deserialize(self, params):
        self._Action = params.get("Action")
        self._ServerName = params.get("ServerName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set)