/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl;

import com.datapps.linkoopdb.jdbc.LdbSqlException;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.impl.JDBCResultSet;
import com.datapps.linkoopdb.jdbc.impl.JDBCUtil;
import com.datapps.linkoopdb.jdbc.types.ClobDataID;
import com.datapps.linkoopdb.jdbc.types.ClobInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.sql.Clob;
import java.sql.SQLException;

public class JDBCClobClient
implements Clob {
    ClobDataID originalClob;
    ClobDataID clob;
    SessionInterface session;
    int colIndex;
    JDBCResultSet resultSet;
    private boolean isClosed;
    private boolean isWritable;

    public JDBCClobClient(SessionInterface session, ClobDataID clob) {
        this.session = session;
        this.clob = clob;
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return fullLength >= 0L && pos >= 0L && len >= 0L && pos <= fullLength - len;
    }

    protected static Charset charsetForName(String charsetName) throws SQLException {
        String csn = charsetName;
        if (csn == null) {
            csn = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(csn)) {
                return Charset.forName(csn);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw JDBCUtil.sqlException(new UnsupportedEncodingException(csn));
    }

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        this.checkClosed();
        return new InputStream(){
            private final byte[] oneChar = new byte[1];
            private boolean m_closed;
            private CharBuffer m_charBuffer = (CharBuffer)CharBuffer.allocate(65536).flip();
            private ByteBuffer m_byteBuffer = ByteBuffer.allocate(1024);
            private Charset m_charset = JDBCClobClient.charsetForName("US-ASCII");
            private CharsetEncoder m_encoder = this.m_charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            private Reader m_reader;
            {
                this.m_reader = JDBCClobClient.this.clob.getCharacterStream(JDBCClobClient.this.session);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read() throws IOException {
                if (this.isEOF()) {
                    return -1;
                }
                byte[] byArray = this.oneChar;
                synchronized (this.oneChar) {
                    int charsRead = this.read(this.oneChar, 0, 1);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return charsRead == 1 ? this.oneChar[0] : -1;
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.checkClosed();
                if (this.isEOF()) {
                    return -1;
                }
                CharBuffer cb = this.m_charBuffer;
                if (cb.remaining() == 0) {
                    cb.clear();
                    int charsRead = this.m_reader.read(cb);
                    cb.flip();
                    if (charsRead < 0) {
                        this.setEOF();
                        return -1;
                    }
                    if (charsRead == 0) {
                        return 0;
                    }
                }
                ByteBuffer bb = this.m_byteBuffer.capacity() < len ? ByteBuffer.allocate(len) : this.m_byteBuffer;
                int cbLimit = cb.limit();
                int cbPosition = cb.position();
                cb.limit(cbPosition + len);
                bb.clear();
                int bbPosition = bb.position();
                CoderResult result = this.m_encoder.encode(cb, bb, false);
                if (bbPosition == bb.position() && result.isUnderflow()) {
                    cb.limit(cb.limit() + 1);
                    this.m_encoder.encode(cb, bb, false);
                }
                cb.limit(cbLimit);
                bb.flip();
                int bytesRead = bb.limit();
                if (bytesRead == 0) {
                    this.setEOF();
                    return -1;
                }
                this.m_byteBuffer = bb;
                bb.get(b, off, bytesRead);
                return bytesRead;
            }

            @Override
            public void close() throws IOException {
                boolean isClosed = this.m_closed;
                if (!isClosed) {
                    this.m_closed = true;
                    this.m_charBuffer = null;
                    this.m_charset = null;
                    this.m_encoder = null;
                    try {
                        this.m_reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            private boolean isEOF() {
                Reader reader = this.m_reader;
                return reader == null;
            }

            private void setEOF() {
                Reader reader = this.m_reader;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.m_reader = null;
            }

            private void checkClosed() throws IOException {
                if (JDBCClobClient.this.isClosed()) {
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.m_closed) {
                    throw new IOException("The stream is closed.");
                }
            }
        };
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        return new ClobInputStream(this.session, this.clob, 0L, this.length());
    }

    @Override
    public synchronized String getSubString(long pos, int length) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, pos - 1L, length)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.getSubString(this.session, pos - 1L, length);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkClosed();
        try {
            return this.clob.length(this.session);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized long position(String searchstr, long start) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, start - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.position(this.session, searchstr, start - 1L);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized long position(Clob searchstr, long start) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, start - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (searchstr instanceof JDBCClobClient) {
            ClobDataID searchClob = ((JDBCClobClient)searchstr).clob;
            try {
                return this.clob.position(this.session, searchClob, start - 1L);
            }
            catch (LdbSqlException e) {
                throw JDBCUtil.sqlException(e);
            }
        }
        return this.position(searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    @Override
    public synchronized OutputStream setAsciiStream(final long pos) throws SQLException {
        this.checkClosed();
        if (pos < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        return new OutputStream(){
            private final byte[] oneByte = new byte[1];
            private long m_position = pos - 1L;
            private Charset m_charset = JDBCClobClient.charsetForName("US-ASCII");
            private CharsetDecoder m_decoder = this.m_charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            private CharBuffer m_charBuffer = CharBuffer.allocate(65536);
            private ByteBuffer m_byteBuffer = ByteBuffer.allocate(1024);
            private boolean m_closed;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int b) throws IOException {
                byte[] byArray = this.oneByte;
                synchronized (this.oneByte) {
                    this.oneByte[0] = (byte)b;
                    this.write(this.oneByte, 0, 1);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ByteBuffer bb;
                this.checkClosed();
                ByteBuffer byteBuffer = bb = this.m_byteBuffer.capacity() < len ? ByteBuffer.allocate(len) : this.m_byteBuffer;
                if (this.m_charBuffer.remaining() < len) {
                    this.flush0();
                }
                CharBuffer cb = this.m_charBuffer.capacity() < len ? CharBuffer.allocate(len) : this.m_charBuffer;
                bb.clear();
                bb.put(b, off, len);
                bb.flip();
                this.m_decoder.decode(bb, cb, false);
                if (cb.remaining() == 0) {
                    this.flush();
                }
            }

            @Override
            public void flush() throws IOException {
                this.checkClosed();
                this.flush0();
            }

            @Override
            public void close() throws IOException {
                if (!this.m_closed) {
                    try {
                        this.flush0();
                    }
                    finally {
                        this.m_closed = true;
                        this.m_byteBuffer = null;
                        this.m_charBuffer = null;
                        this.m_charset = null;
                        this.m_decoder = null;
                    }
                }
            }

            private void checkClosed() throws IOException {
                if (JDBCClobClient.this.isClosed()) {
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.m_closed) {
                    throw new IOException("The stream is closed.");
                }
            }

            private void flush0() throws IOException {
                CharBuffer cb = this.m_charBuffer;
                cb.flip();
                char[] chars = new char[cb.length()];
                cb.get(chars);
                cb.clear();
                try {
                    JDBCClobClient.this.clob.setChars(JDBCClobClient.this.session, this.m_position, chars, 0, chars.length);
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
                this.m_position += (long)chars.length;
            }
        };
    }

    @Override
    public synchronized Writer setCharacterStream(final long pos) throws SQLException {
        this.checkClosed();
        if (pos < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        return new Writer(){
            private long m_clobPosition;
            private boolean m_closed;
            {
                this.m_clobPosition = pos - 1L;
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.checkClosed();
                JDBCClobClient.this.clob.setChars(JDBCClobClient.this.session, this.m_clobPosition, cbuf, off, len);
                this.m_clobPosition += (long)len;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                this.m_closed = true;
            }

            private void checkClosed() throws IOException {
                if (this.m_closed || JDBCClobClient.this.isClosed()) {
                    throw new IOException("The stream is closed");
                }
            }
        };
    }

    @Override
    public synchronized int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public synchronized int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(str.length(), offset, len)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (pos < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        this.startUpdate();
        str = str.substring(offset, offset + len);
        try {
            this.clob.setString(this.session, pos - 1L, str);
            return len;
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void truncate(long len) throws SQLException {
        this.checkClosed();
        if (len < 0L) {
            throw JDBCUtil.outOfRangeArgument("len: " + len);
        }
        try {
            this.clob.truncate(this.session, len);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
        this.clob = null;
        this.session = null;
    }

    @Override
    public synchronized Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.length(), pos - 1L, length)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return new ClobInputStream(this.session, this.clob, pos - 1L, length);
    }

    char[] getChars(long position, int length) throws SQLException {
        try {
            return this.clob.getChars(this.session, position - 1L, length);
        }
        catch (LdbSqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    public ClobDataID getClob() {
        return this.clob;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void setWritable(JDBCResultSet result, int index) {
        this.isWritable = true;
        this.resultSet = result;
        this.colIndex = index;
    }

    public synchronized void clearUpdates() {
        if (this.originalClob != null) {
            this.clob = this.originalClob;
            this.originalClob = null;
        }
    }

    private void startUpdate() throws SQLException {
        if (this.originalClob != null) {
            return;
        }
        this.originalClob = this.clob;
        this.clob = (ClobDataID)this.clob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.clob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = Boolean.TRUE;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1852);
        }
    }
}

