/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.lib.ArrayUtil;
import com.datapps.linkoopdb.jdbc.types.BlobData;
import com.datapps.linkoopdb.jdbc.types.BlobInputStream;
import com.datapps.linkoopdb.jdbc.types.LobLocation;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;

public class BinaryData
implements BlobData {
    public static final BinaryData singleBitZero = new BinaryData(new byte[]{0}, 1L);
    public static final BinaryData singleBitOne = new BinaryData(new byte[]{-128}, 1L);
    public static final byte[] zeroLengthBytes = new byte[0];
    public static final BinaryData zeroLengthBinary = new BinaryData(zeroLengthBytes, false);
    protected byte[] data;
    long id;
    private boolean isBits;
    private long bitLength;
    private int hashCode = 0;

    public BinaryData(byte[] data, boolean clone) {
        if (clone) {
            data = (byte[])ArrayUtil.duplicateArray(data);
        }
        this.data = data;
        this.bitLength = (long)data.length * 8L;
    }

    public BinaryData(SessionInterface session, BlobData b1, BlobData b2) {
        long length = b1.length(session) + b2.length(session);
        if (length > Integer.MAX_VALUE || b1.length(session) > Integer.MAX_VALUE || b2.length(session) > Integer.MAX_VALUE) {
            throw Error.error(3401);
        }
        this.data = new byte[(int)length];
        System.arraycopy(b1.getBytes(session, 0L, (int)b1.length(session)), 0, this.data, 0, (int)b1.length(session));
        System.arraycopy(b2.getBytes(session, 0L, (int)b2.length(session)), 0, this.data, (int)b1.length(session), (int)b2.length(session));
        this.bitLength = (long)((int)length) * 8L;
    }

    public BinaryData(byte[] data, long bitLength) {
        this.data = data;
        this.bitLength = bitLength;
        this.isBits = true;
    }

    public BinaryData(long length, DataInput stream) {
        this.data = new byte[(int)length];
        this.bitLength = (long)this.data.length * 8L;
        try {
            stream.readFully(this.data);
        }
        catch (IOException e) {
            throw Error.error(467, e);
        }
    }

    public static BinaryData getBitData(byte[] data, long bitLength) {
        if (bitLength == 1L) {
            return data[0] == 0 ? singleBitZero : singleBitOne;
        }
        return new BinaryData(data, bitLength);
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }

    @Override
    public byte[] getBytes() {
        return this.data;
    }

    @Override
    public long length(SessionInterface session) {
        return this.data.length;
    }

    @Override
    public long bitLength(SessionInterface session) {
        return this.bitLength;
    }

    @Override
    public boolean isBits() {
        return this.isBits;
    }

    @Override
    public byte[] getBytes(SessionInterface session, long pos, int length) {
        if (!BinaryData.isInLimits(this.data.length, pos, length)) {
            throw new IndexOutOfBoundsException();
        }
        byte[] bytes = new byte[length];
        System.arraycopy(this.data, (int)pos, bytes, 0, length);
        return bytes;
    }

    @Override
    public BlobData getBlob(SessionInterface session, long pos, long length) {
        throw Error.runtimeError(201, "BinaryData");
    }

    @Override
    public InputStream getBinaryStream(SessionInterface session) {
        return new BlobInputStream(session, this, 0L, this.length(session));
    }

    @Override
    public InputStream getBinaryStream(SessionInterface session, long pos, long length) {
        if (!BinaryData.isInLimits(this.data.length, pos, length)) {
            throw new IndexOutOfBoundsException();
        }
        return new BlobInputStream(session, this, pos, this.length(session));
    }

    @Override
    public void setBytes(SessionInterface session, long pos, byte[] bytes, int offset, int length) {
        if (!BinaryData.isInLimits(this.data.length, pos, 0L)) {
            throw new IndexOutOfBoundsException();
        }
        if (!BinaryData.isInLimits(this.data.length, pos, length)) {
            this.data = (byte[])ArrayUtil.resizeArray(this.data, (int)pos + length);
        }
        System.arraycopy(bytes, offset, this.data, (int)pos, length);
        this.bitLength = (long)this.data.length * 8L;
    }

    @Override
    public void setBytes(SessionInterface session, long pos, byte[] bytes) {
        this.setBytes(session, pos, bytes, 0, bytes.length);
    }

    @Override
    public void setBytes(SessionInterface session, long pos, BlobData b, long offset, long length) {
        if (length > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        byte[] bytes = b.getBytes(session, offset, (int)length);
        this.setBytes(session, pos, bytes, 0, bytes.length);
    }

    @Override
    public void setBinaryStream(SessionInterface session, long pos, InputStream in) {
    }

    @Override
    public void truncate(SessionInterface session, long len) {
        if ((long)this.data.length > len) {
            this.data = (byte[])ArrayUtil.resizeArray(this.data, (int)len);
            this.bitLength = (long)this.data.length * 8L;
        }
    }

    @Override
    public BlobData duplicate(SessionInterface session) {
        return new BinaryData(this.data, true);
    }

    @Override
    public long position(SessionInterface session, byte[] pattern, long start) {
        if (pattern.length > this.data.length) {
            return -1L;
        }
        if (start >= (long)this.data.length) {
            return -1L;
        }
        return ArrayUtil.find(this.data, (int)start, this.data.length, pattern);
    }

    @Override
    public long position(SessionInterface session, BlobData pattern, long start) {
        if (pattern.length(session) > (long)this.data.length) {
            return -1L;
        }
        byte[] bytes = pattern.getBytes(session, 0L, (int)pattern.length(session));
        return this.position(session, bytes, start);
    }

    @Override
    public long nonZeroLength(SessionInterface session) {
        return this.data.length;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getStreamBlockSize() {
        return 524288;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void free() {
    }

    @Override
    public void setSession(SessionInterface session) {
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public void setLobLocation(LobLocation lobLocation) {
    }

    @Override
    public LobLocation getLobLocation() {
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof BinaryData) {
            return Type.SQL_VARBINARY.compare(null, this, other) == 0;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int code = 0;
            for (int i = 0; i < this.data.length && i < 32; ++i) {
                code = code * 31 + (0xFF & this.data[i]);
            }
            this.hashCode = code;
        }
        return this.hashCode;
    }
}

