/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.ColumnSchema;
import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.SortAndSlice;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.impl.JDBCArray;
import com.datapps.linkoopdb.jdbc.impl.JDBCArrayBasic;
import com.datapps.linkoopdb.jdbc.impl.JDBCStruct;
import com.datapps.linkoopdb.jdbc.lib.HashMappedList;
import com.datapps.linkoopdb.jdbc.lib.OrderedHashSet;
import com.datapps.linkoopdb.jdbc.rights.Grantee;
import com.datapps.linkoopdb.jdbc.types.RowType;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.sql.Array;
import java.sql.Struct;

public class StructureType
extends RowType {
    public static final String ANONYMOUS_NAME = "_";
    public HashMappedList columnList;
    public LdbSqlNameManager.LdbSqlName name;

    protected StructureType(int typeGroup, int type, Type[] colTypes, HashMappedList columnList) {
        super(typeGroup, type, colTypes);
        this.columnList = columnList;
    }

    public StructureType(LdbSqlNameManager.LdbSqlName name, Type[] colTypes, HashMappedList columnList) {
        this(17, 17, colTypes, columnList);
        this.name = name;
        this.name.owner = name.schema != null ? name.schema.owner : null;
    }

    public StructureType(Type[] colTypes, HashMappedList columnList) {
        this(17, 17, colTypes, columnList);
        this.name = LdbSqlNameManager.newAnonymousStructuredTypeName();
        this.name.owner = this.name.schema != null ? this.name.schema.owner : null;
    }

    public static String convertToSQLString(Object[] array, Type[] types, int maxUnitLength) {
        if (array == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            String string = types[i].convertToSQLString(array[i]);
            if (maxUnitLength > 10 && string.length() > maxUnitLength) {
                sb.append(string.substring(0, maxUnitLength - 4));
                sb.append(" ...");
                continue;
            }
            sb.append(string);
        }
        sb.append(')');
        return sb.toString();
    }

    public HashMappedList getColumnList() {
        return this.columnList;
    }

    public void setColumnList(HashMappedList columnList) {
        this.columnList = columnList;
    }

    @Override
    public int displaySize() {
        return 0;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2002;
    }

    @Override
    public Class getJDBCClass() {
        return Struct.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Struct";
    }

    @Override
    public int getJDBCScale() {
        return 0;
    }

    @Override
    public int getJDBCPrecision() {
        return 0;
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    @Override
    public boolean isRowType() {
        return true;
    }

    @Override
    public int getDegree() {
        return this.colTypes.length;
    }

    @Override
    public String getNameString() {
        if (this.colTypes == null || this.colTypes.length == 0) {
            return "STRUCTURE()";
        }
        StringBuilder builder = new StringBuilder("STRUCTURE").append("(");
        builder.append(((ColumnSchema)this.columnList.get(0)).getSQL());
        for (int i = 1; i < this.colTypes.length; ++i) {
            builder.append(",").append(((ColumnSchema)this.columnList.get(i)).getSQL());
        }
        builder.append(")");
        return builder.toString();
    }

    public String[] getColumns() {
        String[] columns = new String[this.colTypes.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = ((ColumnSchema)this.columnList.get(i)).getNameString();
        }
        return columns;
    }

    @Override
    public String getDefinition() {
        return this.getNameString();
    }

    public String getStructDefinition() {
        if (this.colTypes == null || this.colTypes.length == 0) {
            return "STRUCTURE()";
        }
        StringBuilder builder = new StringBuilder("STRUCTURE").append("(");
        boolean isFistNested = true;
        for (int i = 0; i < this.colTypes.length; ++i) {
            ColumnSchema temp = (ColumnSchema)this.columnList.get(i);
            if (i != 0) {
                builder.append(", ");
            }
            if (temp.getDataType().isStructuredType()) {
                if (isFistNested) {
                    builder.append(temp.getStructSQL(false));
                    continue;
                }
                builder.append(temp.getStructSQL(true));
                continue;
            }
            builder.append(temp.getSQL());
        }
        builder.append(")");
        return builder.toString();
    }

    public String getJsonStructDefinition() {
        if (this.colTypes == null || this.colTypes.length == 0) {
            return "STRUCT<>";
        }
        StringBuilder builder = new StringBuilder("STRUCT").append("<");
        for (int i = 0; i < this.colTypes.length; ++i) {
            ColumnSchema temp = (ColumnSchema)this.columnList.get(i);
            if (i != 0) {
                builder.append(" ,");
            }
            if (temp.getDataType().isStructuredType()) {
                builder.append(temp.getStructSQL(true));
                continue;
            }
            builder.append(temp.getSQL().replace(temp.getName().getStatementName() + " ", temp.getName().getStatementName() + ": "));
        }
        builder.append(">");
        return builder.toString();
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] arrb = (Object[])b;
        Object[] arra = (Object[])a;
        int length = arra.length;
        if (arrb.length < length) {
            length = arrb.length;
        }
        for (int i = 0; i < length; ++i) {
            int result = this.colTypes[i].compare(session, arra[i], arrb[i]);
            if (result == 0) continue;
            return result;
        }
        if (arra.length > arrb.length) {
            return 1;
        }
        if (arra.length < arrb.length) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        Object[] arra = (Object[])a;
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.colTypes[i].convertToTypeLimits(session, arra[i]);
        }
        return arrb;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        if (otherType == null) {
            return a;
        }
        if (!otherType.isStructuredType()) {
            throw Error.error(5562);
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.colTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        Object[] arra = (Object[])a;
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.colTypes[i].convertToType(session, arra[i], otherTypes[i]);
        }
        return arrb;
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object o) {
        return o;
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return this.convertToSQLString(a);
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        Object[] array = (Object[])a;
        StringBuilder sb = new StringBuilder();
        sb.append("STRUCTURE");
        sb.append('(');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            String string = this.colTypes[i].convertToSQLString(array[i]);
            sb.append(string);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (otherType.isCharacterType()) {
            return true;
        }
        if (!otherType.isRowType() && !otherType.isStructuredType()) {
            return false;
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.colTypes.length != otherTypes.length) {
            return false;
        }
        for (int i = 0; i < this.colTypes.length; ++i) {
            if (this.colTypes[i].canConvertFrom(otherTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeAssignedFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (!otherType.isRowType()) {
            return false;
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.colTypes.length != otherTypes.length) {
            return false;
        }
        for (int i = 0; i < this.colTypes.length; ++i) {
            if (this.colTypes[i].canBeAssignedFrom(otherTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type getAggregateType(Type other) {
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (other == this) {
            return this;
        }
        if (!other.isRowType()) {
            throw Error.error(5562);
        }
        Type[] newTypes = new Type[this.colTypes.length];
        Type[] otherTypes = ((RowType)other).getTypesArray();
        if (this.colTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        for (int i = 0; i < this.colTypes.length; ++i) {
            newTypes[i] = this.colTypes[i].getAggregateType(otherTypes[i]);
        }
        return new RowType(newTypes);
    }

    @Override
    public Type getCombinedType(SessionInterface session, Type other, int operation) {
        if (operation != 36) {
            return this.getAggregateType(other);
        }
        if (other == null) {
            return this;
        }
        if (!other.isStructuredType()) {
            throw Error.error(5562);
        }
        Type[] newTypes = new Type[this.colTypes.length];
        Type[] otherTypes = ((RowType)other).getTypesArray();
        if (this.colTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        for (int i = 0; i < this.colTypes.length; ++i) {
            newTypes[i] = this.colTypes[i].getAggregateType(otherTypes[i]);
        }
        return new RowType(newTypes);
    }

    @Override
    public Type[] getTypesArray() {
        return this.colTypes;
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b, SortAndSlice sort) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] arra = (Object[])a;
        Object[] arrb = (Object[])b;
        int length = sort.sortOrder.length;
        for (int i = 0; i < length; ++i) {
            int result;
            a = arra[sort.sortOrder[i]];
            b = arrb[sort.sortOrder[i]];
            if (a == b) continue;
            if (sort.sortNullsLast[i]) {
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
            }
            if ((result = this.colTypes[i].compare(session, a, b)) == 0) continue;
            if (sort.sortDescending[i]) {
                return -result;
            }
            return result;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Type) {
            if (((Type)other).typeCode != 19) {
                return false;
            }
            Type[] otherTypes = ((RowType)other).colTypes;
            if (otherTypes.length != this.colTypes.length) {
                return false;
            }
            for (int i = 0; i < this.colTypes.length; ++i) {
                if (this.colTypes[i].equals(otherTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode(Object a) {
        if (a == null) {
            return 0;
        }
        int hash = 0;
        Object[] array = (Object[])a;
        for (int i = 0; i < this.colTypes.length && i < 4; ++i) {
            hash += this.colTypes[i].hashCode(array[i]);
        }
        return hash;
    }

    @Override
    public boolean isStructuredType() {
        return true;
    }

    public int findColumn(String name) {
        int index = this.columnList.getIndex(name);
        return index;
    }

    public ColumnSchema getColumn(int i) {
        return (ColumnSchema)this.columnList.get(i);
    }

    public int getColumnIndex(String name) {
        int i = this.findColumn(name);
        if (i == -1) {
            throw Error.error(5501, name);
        }
        return i;
    }

    public void addColumn(ColumnSchema column) {
        String name = column.getName().name;
        if (this.findColumn(name) >= 0) {
            throw Error.error(5504, name);
        }
        this.addColumnNoCheck(column);
    }

    public void addColumnNoCheck(ColumnSchema column) {
        this.columnList.add(column.getName().name, column);
    }

    public void rebuildColumnTypes() {
        if (this.columnList != null) {
            this.colTypes = new Type[this.columnList.size()];
            for (int i = 0; i < this.colTypes.length; ++i) {
                this.colTypes[i] = ((ColumnSchema)this.columnList.get((int)i)).dataType;
            }
        }
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getName() {
        return this.name;
    }

    @Override
    public Grantee getOwner() {
        return this.name == null ? null : this.name.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        return set;
    }

    public OrderedHashSet getReferencesForDependents() {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < this.colTypes.length; ++i) {
            ColumnSchema column = (ColumnSchema)this.columnList.get(i);
            OrderedHashSet refs = column.getReferences();
            if (refs == null || refs.isEmpty()) continue;
            set.add(column.getName());
        }
        return set;
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        Object[] data;
        boolean convert = false;
        if (a == null) {
            return null;
        }
        if (a instanceof JDBCStruct) {
            data = ((JDBCStruct)a).getData();
        } else if (a instanceof Object[]) {
            data = (Object[])a;
            convert = true;
        } else if (a instanceof JDBCArray) {
            data = ((JDBCArray)a).getArrayInternal();
        } else if (a instanceof JDBCArrayBasic) {
            data = (Object[])((JDBCArrayBasic)a).getArray();
            convert = true;
        } else if (a instanceof Array) {
            try {
                data = (Object[])((Array)a).getArray();
                convert = true;
            }
            catch (Exception e) {
                throw Error.error(5561);
            }
        } else {
            throw Error.error(5561);
        }
        if (convert) {
            Object[] array = new Object[data.length];
            for (int i = 0; i < data.length; ++i) {
                Object o = this.colTypes[i].convertJavaToSQL(session, data[i]);
                array[i] = this.colTypes[i].convertToTypeLimits(session, o);
            }
            return array;
        }
        return data;
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a instanceof Object[]) {
            Object[] data = (Object[])a;
            return new JDBCStruct(this, data);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertDbToWorker(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        return a;
    }

    @Override
    public Object convertWorkerToDb(SessionInterface session, Object a, Type type) {
        if (a == null) {
            return null;
        }
        Object[] row = (Object[])a;
        for (int i = 0; i < row.length; ++i) {
            row[i] = this.colTypes[i].convertWorkerToDb(session, row[i], ((StructureType)type).colTypes[i]);
        }
        return row;
    }
}

