/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.ColumnSchema;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.lib.HashMappedList;
import com.datapps.linkoopdb.jdbc.types.StructureType;
import com.datapps.linkoopdb.jdbc.types.Type;

public class TableType
extends StructureType {
    public TableType(HashMappedList columnList, Type[] colTypes) {
        super(114, 114, colTypes, columnList);
        this.columnList = columnList;
    }

    protected TableType(int typeCode, HashMappedList columnList, Type[] colTypes) {
        super(114, typeCode, colTypes, columnList);
    }

    public TableType() {
        super(114, 114, null, null);
    }

    @Override
    public int displaySize() {
        int size = 0;
        for (int i = 0; i < this.colTypes.length; ++i) {
            size += this.colTypes[i].displaySize();
        }
        return size;
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    @Override
    public String getNameString() {
        return this.getDefinition();
    }

    @Override
    public String getDefinition() {
        if (this.colTypes == null || this.colTypes.length == 0) {
            return "TABLE()";
        }
        StringBuilder builder = new StringBuilder("TABLE").append("(");
        builder.append(((ColumnSchema)this.columnList.get(0)).getSQL());
        for (int i = 1; i < this.colTypes.length; ++i) {
            builder.append(",").append(((ColumnSchema)this.columnList.get(i)).getSQL());
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b) {
        return 0;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return null;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type type) {
        return null;
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object o) {
        return null;
    }

    @Override
    public String convertToString(Object a) {
        return null;
    }

    @Override
    public String convertToSQLString(Object a) {
        return null;
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        return false;
    }

    @Override
    public Type getAggregateType(Type other) {
        return null;
    }

    @Override
    public Type getCombinedType(SessionInterface session, Type other, int operation) {
        return null;
    }

    @Override
    public String[] getColumns() {
        String[] columns = new String[this.colTypes.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = ((ColumnSchema)this.columnList.get(i)).getNameString();
        }
        return columns;
    }

    public Type[] getColTypes() {
        return this.colTypes;
    }

    public void setColTypes(Type[] colTypes) {
        this.colTypes = colTypes;
    }

    @Override
    public boolean isTableType() {
        return true;
    }
}

