/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DERException;
import com.teradata.tdgss.asn1.der.DERLength;
import com.teradata.tdgss.asn1.der.DERTag;
import java.util.Arrays;

abstract class DERASN1Type {
    protected byte[] octets = null;
    static final boolean isImplicitEncoding = true;

    DERASN1Type() {
    }

    final byte[] getOctets() {
        return this.getOctets(true);
    }

    protected byte[] getOctets(boolean bl) {
        if (bl) {
            return this.octets;
        }
        return this.getExplicitOctets();
    }

    private final byte[] getExplicitOctets() {
        byte[] byArray = this.getUniveralTagOctets();
        byte[] byArray2 = new DERLength(this.size(true)).getLengthOctets();
        byte[] byArray3 = this.concat(byArray, byArray2);
        return this.concat(byArray3, this.octets);
    }

    protected void parseExplicitOctets(byte[] byArray, int n) {
        byte[] byArray2 = new DERTag(byArray, n).getTagOctets();
        if (!Arrays.equals(byArray2, this.getUniveralTagOctets())) {
            throw new DERException("Invalid explicit DER encoded octets.");
        }
        DERLength dERLength = new DERLength(byArray, n += byArray2.length);
        this.octets = new byte[dERLength.getLength()];
        System.arraycopy(byArray, n += dERLength.getLengthOctets().length, this.octets, 0, this.octets.length);
    }

    final byte[] concat(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        int n = 0;
        System.arraycopy(byArray, 0, byArray3, n, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, n += byArray.length, byArray2.length);
        return byArray3;
    }

    final int size() {
        return this.size(true);
    }

    final int size(boolean bl) {
        if (bl) {
            return this.octets.length;
        }
        return this.getExplicitOctets().length;
    }

    abstract byte[] getUniveralTagOctets();

    protected abstract void parse(byte[] var1, int var2, int var3, boolean var4);

    protected abstract boolean isConstructed();
}

