/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DERClass;
import com.teradata.tdgss.asn1.der.DERException;

class DERTag {
    private static final int CLASS_SHIFT = 6;
    private static final int CLASS_MASK = 3;
    private static final int CONSTRUCTED_BIT = 32;
    private static final int LOW_TAG_NUMBER_MAX = 30;
    private static final int LOW_TAG_NUMBER_MASK = 31;
    private static final int HIGH_TAG_NUMBER_TAG = 31;
    private static final int HIGH_TAG_BITS_PER_OCTET = 7;
    private static final int HIGH_TAG_NUMBER_MASK = 127;
    private static final int HIGH_TAG_NUMBER_CONTINUES_BIT = 128;
    private DERClass classType;
    private boolean isConstructed;
    private int tag;
    private byte[] octects = null;

    DERTag(DERClass dERClass, boolean bl, int n) {
        this.classType = dERClass;
        this.isConstructed = bl;
        if (0 > n) {
            throw new DERException("Negative tag number is not valid.");
        }
        this.tag = n;
        this.octects = this.getTagOctets();
    }

    DERTag(byte[] byArray) {
        this.parse(byArray);
    }

    DERTag(byte[] byArray, int n) {
        this.parse(byArray, n);
    }

    void setPrimitive() {
        this.isConstructed = false;
    }

    void setConstructed() {
        this.isConstructed = true;
    }

    private void parse(byte[] byArray) {
        this.parse(byArray, 0);
    }

    private void parse(byte[] byArray, int n) {
        int n2 = byArray[n] >> 6 & 3;
        this.classType = DERClass.valueOf(n2);
        this.isConstructed = (byArray[n] & 0x20) == 32;
        this.tag = byArray[n] & 0x1F;
        if (this.tag == 31) {
            this.tag = this.getHighTagNumber(byArray, n);
        }
        this.octects = this.getTagOctets();
    }

    private byte[] calcOctets(boolean bl) {
        byte[] byArray;
        int n = this.classType.ordinal() << 6;
        n = bl ? (n |= this.isConstructed ? 32 : 0) : (n |= 0x20);
        if (this.tag <= 30) {
            byArray = new byte[]{(byte)(n | this.tag & 0x1F)};
        } else {
            int n2 = 0;
            for (int i = this.tag; i > 0; i >>= 1) {
                ++n2;
            }
            int n3 = (n2 + 7 - 1) / 7;
            byArray = new byte[1 + n3];
            byArray[0] = (byte)(n | 0x1F);
            int n4 = this.tag;
            int n5 = 0;
            for (int i = n3; i > 0; --i) {
                byArray[i] = (byte)(n4 & 0x7F | n5);
                n4 >>= 7;
                n5 = 128;
            }
        }
        return byArray;
    }

    private int getHighTagNumber(byte[] byArray, int n) {
        int n2 = 0;
        try {
            int n3 = n + 1;
            do {
                n2 <<= 7;
                n2 |= byArray[n3] & 0x7F;
            } while ((byArray[n3++] & 0x80) != 0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new DERException("Invalid tag octets.");
        }
        return n2;
    }

    DERClass getClassType() {
        return this.classType;
    }

    boolean isConstructed() {
        return this.isConstructed(true);
    }

    boolean isConstructed(boolean bl) {
        if (bl) {
            return this.isConstructed;
        }
        return true;
    }

    int getTag() {
        return this.tag;
    }

    byte[] getTagOctets() {
        return this.getTagOctets(true);
    }

    int size() {
        return this.octects.length;
    }

    byte[] getTagOctets(boolean bl) {
        if (bl && this.octects != null) {
            return this.octects;
        }
        return this.calcOctets(bl);
    }
}

