# easy-exon

**easy-exon** — это лёгкая Python-обёртка к REST API платформы **Exon (СУИД)**.  
Она упрощает аутентификацию через Keycloak и предоставляет «плоский» Python-клиент
с ресурсами (`api.objects`, `api.users`, `api.itd_acts` и т. д.) вместо ручного
формирования HTTP-запросов.

> **Важно:** библиотека пока ориентирована **на чтение данных**.  
> Из методов `PUT/POST/PATCH` реализовано только добавление/редактирование
> **пользователей** — и то при наличии соответствующих прав у вашего аккаунта.  
> Для остальных сущностей доступна только выборка (`GET` и `POST` для передачи фильтра).

## Возможности

* 🔒 Авторизация по OIDC-токену (Keycloak, realm `SpringBoot`).  
* 🚀 Удобный высокоуровневый клиент `MyApiClient` с «живыми» ресурсами  
  (создаются один раз при инициализации).  
* 📝 Встроенные модели / валидация на базе **Pydantic v2**.  
* 🐍 Минимум зависимостей (только `requests` и `pydantic`).

## Установка

```bash
pip install git+https://github.com/fallec/easy-exon.git
# или с  PyPI:
pip install easy-exon
```

## Быстрый старт

```python
from easy_exon import MyApiClient, get_token

# 1. Получаем JWT-токен Keycloak
token = get_token("login@example.com", "S3cret!")

# 2. Создаём клиент (ресурсы становятся атрибутами объекта)
api = MyApiClient(token=token)

# 3. Делаем запросы
objects_page = api.objects.list()   # Список объектов
```

### Где брать названия полей и эндпоинтов?

Exon не публикует открытой спецификации.  
Чтобы понять, какие поля доступны в том или ином методе, откройте
вкладку **DevTools → Network** вашего браузера при работе с веб-версией Exon:  
там видны реальные HTTP-запросы, их URL, query-параметры и JSON-payload.  
Эти сведения легко перенести в вызовы *easy-exon*.

## Архитектура

* **`MyApiClient`** — центральный класс-обёртка.  
  При создании инициализирует все ресурсы:  
  `users`, `organizations`, `objects`, `itd_*`, `isr_*`, `act_*`, `sk_*`,  
  `otitb_*`, `pir_*` и др.
* **`BaseClient`** — низкоуровневый слой (повторно использует `requests.Session`).
* **`resources/*`** — отдельный модуль на каждый «микросервис» Exon.
* **`exceptions.py`** — типы ошибок (например, `TokenError`).

## Обратная связь

По всем вопросам обращаться в отдел аналитики АНО РСИ.

Грехов Андрей 90788

Измалков Кирилл 90938



## Лицензия

Проект распространяется под лицензией **MIT**.  
См. файл [`LICENSE`](LICENSE) для подробностей.

---

*easy-exon — неофициальный инструмент. Авторы не связаны с разработчиками
Exon Project и не могут гарантировать стабильность внутренних API.*
