# `KnownExploitedVulnerability` JSON Schema

This schema governs the data shape for a single [CISA Known Exploited Vulnerability dataset](https://www.cisa.gov/known-exploited-vulnerabilities-catalog) record.


## Updating the schema

Please use the [official schema](https://www.cisa.gov/sites/default/files/feeds/known_exploited_vulnerabilities_schema.json) as a basis for updating this schema. The main difference between the official schema and this one is that this schema represents a single record instead of the entire catalog.

This schema is being versioned based off of the "SchemaVer" guidelines, which slightly diverges from Semantic Versioning to tailor for the purposes of data models.

Given a version number format `MODEL.REVISION.ADDITION`:

- `MODEL`: increment when you make a breaking schema change which will prevent interaction with any historical data
- `REVISION`: increment when you make a schema change which may prevent interaction with some historical data
- `ADDITION`: increment when you make a schema change that is compatible with all historical data
