from __future__ import annotations

import pytest

from vunnel.utils.vulnerability import build_reference_links


@pytest.mark.parametrize(
    "vulnerability_id, expected",
    [
        ("GHSA-4r7g-fj95-jwpc", ["https://github.com/advisories/GHSA-4r7g-fj95-jwpc"]),
        ("CVE-2023-1234", ["https://www.cve.org/CVERecord?id=CVE-2023-1234", "https://nvd.nist.gov/vuln/detail/CVE-2023-1234"]),
        ("unknown-format", None),
    ],
)
def test_build_reference_links(vulnerability_id: str, expected: list[str] | None):
    assert build_reference_links(vulnerability_id) == expected
