# ================================== LICENSE ===================================
# Wulfric - Cell, Atoms, K-path, visualization.
# Copyright (C) 2023-2025 Andrey Rybakov
#
# e-mail: anry@uv.es, web: adrybakov.com
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# ================================ END LICENSE =================================
old_dir = set(dir())
old_dir.add("old_dir")

################################################################################
#                                  Atoms names                                 #
################################################################################
ATOM_SPECIES = (
    "H",
    "He",
    "Li",
    "Be",
    "B",
    "C",
    "N",
    "O",
    "F",
    "Ne",
    "Na",
    "Mg",
    "Al",
    "Si",
    "P",
    "S",
    "Cl",
    "Ar",
    "K",
    "Ca",
    "Sc",
    "Ti",
    "V",
    "Cr",
    "Mn",
    "Fe",
    "Co",
    "Ni",
    "Cu",
    "Zn",
    "Ga",
    "Ge",
    "As",
    "Se",
    "Br",
    "Kr",
    "Rb",
    "Sr",
    "Y",
    "Zr",
    "Nb",
    "Mo",
    "Tc",
    "Ru",
    "Rh",
    "Pd",
    "Ag",
    "Cd",
    "In",
    "Sn",
    "Sb",
    "Te",
    "I",
    "Xe",
    "Cs",
    "Ba",
    "La",
    "Ce",
    "Pr",
    "Nd",
    "Pm",
    "Sm",
    "Eu",
    "Gd",
    "Tb",
    "Dy",
    "Ho",
    "Er",
    "Tm",
    "Yb",
    "Lu",
    "Hf",
    "Ta",
    "W",
    "Re",
    "Os",
    "Ir",
    "Pt",
    "Au",
    "Hg",
    "Tl",
    "Pb",
    "Bi",
    "Po",
    "At",
    "Rn",
    "Fr",
    "Ra",
    "Ac",
    "Th",
    "Pa",
    "U",
    "Np",
    "Pu",
    "Am",
    "Cm",
    "Bk",
    "Cf",
    "Es",
    "Fm",
    "Md",
    "No",
    "Lr",
    "Rf",
    "Db",
    "Sg",
    "Bh",
    "Hs",
    "Mt",
    "Ds",
    "Rg",
    "Cn",
    "Nh",
    "Fl",
    "Mc",
    "Lv",
    "Ts",
    "Og",
)


# Source https://pubchem.ncbi.nlm.nih.gov/ptable/ as of 25 August 2025
ATOMIC_MASS = {
    "H": 1.0080,
    "He": 4.00260,
    "Li": 7.0,
    "Be": 9.012183,
    "B": 10.81,
    "C": 12.011,
    "N": 14.007,
    "O": 15.999,
    "F": 18.99840316,
    "Ne": 20.180,
    "Na": 22.9897693,
    "Mg": 24.305,
    "Al": 26.981538,
    "Si": 28.085,
    "P": 30.97376200,
    "S": 32.07,
    "Cl": 35.45,
    "Ar": 39.9,
    "K": 39.0983,
    "Ca": 40.08,
    "Sc": 44.95591,
    "Ti": 47.867,
    "V": 50.9415,
    "Cr": 51.996,
    "Mn": 54.93804,
    "Fe": 55.84,
    "Co": 58.93319,
    "Ni": 58.693,
    "Cu": 63.55,
    "Zn": 65.4,
    "Ga": 69.723,
    "Ge": 72.63,
    "As": 74.92159,
    "Se": 78.97,
    "Br": 79.90,
    "Kr": 83.80,
    "Rb": 85.468,
    "Sr": 87.62,
    "Y": 88.90584,
    "Zr": 91.22,
    "Nb": 92.90637,
    "Mo": 95.95,
    "Tc": 96.90636,
    "Ru": 101.1,
    "Rh": 102.9055,
    "Pd": 106.42,
    "Ag": 107.868,
    "Cd": 112.41,
    "In": 114.818,
    "Sn": 118.71,
    "Sb": 121.760,
    "Te": 127.6,
    "I": 126.9045,
    "Xe": 131.29,
    "Cs": 132.9054520,
    "Ba": 137.33,
    "La": 138.9055,
    "Ce": 140.116,
    "Pr": 140.90766,
    "Nd": 144.24,
    "Pm": 144.91276,
    "Sm": 150.4,
    "Eu": 151.964,
    "Gd": 157.25,
    "Tb": 158.92535,
    "Dy": 162.500,
    "Ho": 164.93033,
    "Er": 167.26,
    "Tm": 168.93422,
    "Yb": 173.05,
    "Lu": 174.9667,
    "Hf": 178.49,
    "Ta": 180.9479,
    "W": 183.84,
    "Re": 186.207,
    "Os": 190.2,
    "Ir": 192.22,
    "Pt": 195.08,
    "Au": 196.96657,
    "Hg": 200.59,
    "Tl": 204.383,
    "Pb": 207,
    "Bi": 208.98040,
    "Po": 208.98243,
    "At": 209.98715,
    "Rn": 222.01758,
    "Fr": 223.01973,
    "Ra": 226.02541,
    "Ac": 227.02775,
    "Th": 232.038,
    "Pa": 231.03588,
    "U": 238.0289,
    "Np": 237.048172,
    "Pu": 244.06420,
    "Am": 243.061380,
    "Cm": 247.07035,
    "Bk": 247.07031,
    "Cf": 251.07959,
    "Es": 252.0830,
    "Fm": 257.09511,
    "Md": 258.09843,
    "No": 259.10100,
    "Lr": 266.120,
    "Rf": 267.122,
    "Db": 268.126,
    "Sg": 269.128,
    "Bh": 270.133,
    "Hs": 269.1336,
    "Mt": 277.154,
    "Ds": 282.166,
    "Rg": 282.169,
    "Cn": 286.179,
    "Nh": 286.182,
    "Fl": 290.192,
    "Mc": 290.196,
    "Lv": 293.205,
    "Ts": 294.211,
    "Og": 295.216,
}

# Source https://pubchem.ncbi.nlm.nih.gov/ptable/ as of 25 August 2025
ATOM_COLORS = {
    "H": "#FFFFFF",
    "He": "#D9FFFF",
    "Li": "#CC80FF",
    "Be": "#C2FF00",
    "B": "#FFB5B5",
    "C": "#909090",
    "N": "#3050F8",
    "O": "#FF0D0D",
    "F": "#90E050",
    "Ne": "#B3E3F5",
    "Na": "#AB5CF2",
    "Mg": "#8AFF00",
    "Al": "#BFA6A6",
    "Si": "#F0C8A0",
    "P": "#FF8000",
    "S": "#FFFF30",
    "Cl": "#1FF01F",
    "Ar": "#80D1E3",
    "K": "#8F40D4",
    "Ca": "#3DFF00",
    "Sc": "#E6E6E6",
    "Ti": "#BFC2C7",
    "V": "#A6A6AB",
    "Cr": "#8A99C7",
    "Mn": "#9C7AC7",
    "Fe": "#E06633",
    "Co": "#F090A0",
    "Ni": "#50D050",
    "Cu": "#C88033",
    "Zn": "#7D80B0",
    "Ga": "#C28F8F",
    "Ge": "#668F8F",
    "As": "#BD80E3",
    "Se": "#FFA100",
    "Br": "#A62929",
    "Kr": "#5CB8D1",
    "Rb": "#702EB0",
    "Sr": "#00FF00",
    "Y": "#94FFFF",
    "Zr": "#94E0E0",
    "Nb": "#73C2C9",
    "Mo": "#54B5B5",
    "Tc": "#3B9E9E",
    "Ru": "#248F8F",
    "Rh": "#0A7D8C",
    "Pd": "#6985",
    "Ag": "#C0C0C0",
    "Cd": "#FFD98F",
    "In": "#A67573",
    "Sn": "#668080",
    "Sb": "#9E63B5",
    "Te": "#D47A00",
    "I": "#940094",
    "Xe": "#429EB0",
    "Cs": "#57178F",
    "Ba": "#00C900",
    "La": "#70D4FF",
    "Ce": "#FFFFC7",
    "Pr": "#D9FFC7",
    "Nd": "#C7FFC7",
    "Pm": "#A3FFC7",
    "Sm": "#8FFFC7",
    "Eu": "#61FFC7",
    "Gd": "#45FFC7",
    "Tb": "#30FFC7",
    "Dy": "#1FFFC7",
    "Ho": "#00FF9C",
    "Er": "#",
    "Tm": "#00D452",
    "Yb": "#00BF38",
    "Lu": "#00AB24",
    "Hf": "#4DC2FF",
    "Ta": "#4DA6FF",
    "W": "#2194D6",
    "Re": "#267DAB",
    "Os": "#266696",
    "Ir": "#175487",
    "Pt": "#D0D0E0",
    "Au": "#FFD123",
    "Hg": "#B8B8D0",
    "Tl": "#A6544D",
    "Pb": "#575961",
    "Bi": "#9E4FB5",
    "Po": "#AB5C00",
    "At": "#754F45",
    "Rn": "#428296",
    "Fr": "#420066",
    "Ra": "#007D00",
    "Ac": "#70ABFA",
    "Th": "#00BAFF",
    "Pa": "#00A1FF",
    "U": "#008FFF",
    "Np": "#0080FF",
    "Pu": "#006BFF",
    "Am": "#545CF2",
    "Cm": "#785CE3",
    "Bk": "#8A4FE3",
    "Cf": "#A136D4",
    "Es": "#B31FD4",
    "Fm": "#B31FBA",
    "Md": "#B30DA6",
    "No": "#BD0D87",
    "Lr": "#C70066",
    "Rf": "#CC0059",
    "Db": "#D1004F",
    "Sg": "#D90045",
    "Bh": "#E00038",
    "Hs": "#E6002E",
    "Mt": "#EB0026",
    # Other colors are undefined
    "Ds": "#FD00D7",
    "Rg": "#FD00D7",
    "Cn": "#FD00D7",
    "Nh": "#FD00D7",
    "Fl": "#FD00D7",
    "Mc": "#FD00D7",
    "Lv": "#FD00D7",
    "Ts": "#FD00D7",
    "Og": "#FD00D7",
    "X": "#FD00D7",
}


# Populate __all__ with objects defined in this file
__all__ = list(set(dir()) - old_dir)
# Remove all semi-private objects
__all__ = [i for i in __all__ if not i.startswith("_")]
del old_dir
