import unittest
from smlr.utils.functions import simplex_matrix
import numpy as np

class TestSimplexMatrix(unittest.TestCase):
    def test_shape(self):
        """
        simplex matrix should be (k-1) * k matrix
        """

        for k in range(2, 11):
            matrix: np.ndarray = simplex_matrix(k)
            self.assertEqual(matrix.shape[0], k-1)
            self.assertEqual(matrix.shape[1], k)

    def test_value(self):
        """
        simplex matrix should be:
        
        when k = 2: [1, -1]
        """
        
        matrix: np.ndarray = simplex_matrix(2)

        self.assertAlmostEqual(matrix[0][0], 1)
        self.assertAlmostEqual(matrix[0][1], -1)

    
        