# id_Dodd23
A package to identify the group membership of stars, described in (Dodd23)[https://ui.adsabs.harvard.edu/abs/2023A%26A...670L...2D/abstract].

This package has utilities to:
1. Transform from observables to the Galactocentric position-velocity used in Dodd23
2. Calculate IoM used in Dodd23 (Energy, Lz, L perp)
3. Identify the membership of the stars to substructures identified in Dodd23.

See examples notebook.

## Groups IoM
Groups are defined.
Groups | Mean [En,Lz,Lperp] | covariance
--- | --- | ---
Gaia Enceladus | [-1.17706147e+05 -3.38085108e+01  4.06814367e+02] | [[1.00254943e+08 1.17355768e+06 7.57200250e+04] [1.17355768e+06 4.35077348e+04 8.02911543e+03] [7.57200250e+04 8.02911543e+03 8.14407020e+04]]
L-RL3 | [-1.50778932e+05  1.33687176e+02  5.58893786e+02] | [[7679831.59044808 -145858.99745856  377291.42148388] [-145858.99745856   12856.67646575  -11957.78501425] [ 377291.42148388  -11957.78501425   38941.5587742 ]]
Hot Thick Disk | [-118635.91170409    1337.17346818     393.77690032] | [[ 3.73861048e+07  1.11206925e+06 -2.38946736e+05] [ 1.11206925e+06  3.97429270e+04 -9.63413019e+03] [-2.38946736e+05 -9.63413019e+03  4.36832521e+04]]
Thamnos 1+2 | [-146980.67552909    -840.07011806     284.51947309] | [[ 8.51956729e+06 -3.78985605e+05  1.55925840e+04] [-3.78985605e+05  3.18925500e+04 -3.84165842e+03] [ 1.55925840e+04 -3.84165842e+03  1.16255710e+04]]
Helmi Streams | [-106276.74200091    1300.64169873    2031.70955323] | [[ 2.14702450e+07  2.72827187e+04  6.73351386e+05] [ 2.72827187e+04  4.07061487e+04 -1.94021183e+04] [ 6.73351386e+05 -1.94021183e+04  5.37536539e+04]]
Sequoia | [-98691.22180863  -1667.42957456   1282.33628907] | [[29420389.45626034  -548980.90687133 -1569463.77355954] [ -548980.90687133    75817.15063921    49066.08855248] [-1569463.77355954    49066.08855248   257264.44908434]]
ED-1 | [-138297.07882812     682.75151468    1178.11935402] | [[ 4.00626265e+06  1.17095303e+05  2.28847426e+04] [ 1.17095303e+05  1.01436869e+04 -1.88667516e+03] [ 2.28847426e+04 -1.88667516e+03  6.67514547e+03]]
Group 7 | [-138113.79514352     581.22521973     179.19508445] | [[ 1.30816418e+06  3.81696835e+03  6.05667203e+03] [ 3.81696835e+03  2.62848044e+03 -3.88219995e+01] [ 6.05667203e+03 -3.88219995e+01  3.59654473e+02]]
Group 8 | [-1.36153390e+05  8.50693162e+02  7.65603722e+01] | [[2.97512040e+06 7.85460411e+04 4.72189541e+03] [7.85460411e+04 4.63565272e+03 1.32064301e+03] [4.72189541e+03 1.32064301e+03 1.13155571e+03]]
Group 9 | [-140891.66013154     608.32531553     341.07955397] | [[6.56271697e+05 2.53204241e+04 1.49318170e+03] [2.53204241e+04 2.23395188e+03 2.89676336e+01] [1.49318170e+03 2.89676336e+01 6.27499761e+02]]
Group 10 | [-1.30274218e+05 -9.86221163e+01  6.26632484e+02] | [[ 2.60664420e+06 -3.06581376e+04  1.83486568e+03] [-3.06581376e+04  4.61208856e+03 -1.29997106e+03] [ 1.83486568e+03 -1.29997106e+03  1.03147087e+03]]
L-RL64 | [-73883.94956776  -2961.63071547    487.69773871] | [[4944866.71934184  -90610.84654646  -20725.09298218] [ -90610.84654646   35850.57067161  -13088.05021027] [ -20725.09298218  -13088.05021027   20042.14747399]]
Group 12 | [-135378.93992392    -160.80711966     555.48385089] | [[ 3.03175327e+05 -9.53145213e+03 -7.92853226e+03] [-9.53145213e+03  1.69561772e+03 -9.22057864e+00] [-7.92853226e+03 -9.22057864e+00  8.00829677e+02]]
Group 13 | [-107823.35550489    -207.01229686    1092.343679  ] | [[1609802.97127011  107942.18339433   43287.20740788] [ 107942.18339433   22415.9311162     5025.9524723 ] [  43287.20740788    5025.9524723     2904.83937229]]
Group 14 | [-9.63241824e+04  3.51491621e+00  8.93899585e+02] | [[ 3.62290982e+06  7.20008189e+04 -2.98874780e+04] [ 7.20008189e+04  1.09244272e+04 -1.17139466e+03] [-2.98874780e+04 -1.17139466e+03  1.14438246e+03]]
ED-2 | [-101837.20303526   -2249.03982632     912.49613633] | [[ 6.08946249e+06 -1.38327383e+05  2.86674332e+04] [-1.38327383e+05  3.53067742e+03 -2.28415513e+02] [ 2.86674332e+04 -2.28415513e+02  1.96122385e+03]]
Group 16 | [-84487.0637682    2164.26996402   1825.90520559] | [[23627511.06889399   464102.3872849   -722561.19984759] [  464102.3872849     62147.93302771   -41419.75188345] [ -722561.19984759   -41419.75188345    66736.84379981]]
ED-4 | [-71562.75066862   1011.80963274   2507.8415314 ] | [[4597476.44408782   24549.93369109   64555.41450287] [  24549.93369109   30431.95390227  -36643.4582481 ] [  64555.41450287  -36643.4582481    61192.24480486]]
Group 19 | [-1.44202775e+05 -1.19371863e+03  1.32851965e+02] | [[ 8.75852163e+05 -4.28371252e+04  2.01340536e+03] [-4.28371252e+04  3.42657228e+03  1.09594251e+01] [ 2.01340536e+03  1.09594251e+01  2.43033588e+02]]
Group 20 | [-139696.13050422     684.1370522      673.01046593] | [[ 1.60182991e+05 -6.48573377e+02  5.84095335e+03] [-6.48573377e+02  2.40382112e+02 -7.13801170e+01] [ 5.84095335e+03 -7.13801170e+01  5.38581650e+02]]
Group 21 | [-1.35221850e+05 -8.29681477e+01  6.90632673e+02] | [[96984.18135943 -1614.08208165  1113.18058704] [-1614.08208165   485.40517723  -470.54374947] [ 1113.18058704  -470.54374947   657.10420371]]
Group 22 | [-1.64880994e+05  1.53273168e+02  2.22079438e+01] | [[2.14492608e+05 1.08056282e+04 3.21271158e+02] [1.08056282e+04 9.17987287e+02 5.47620158e+01] [3.21271158e+02 5.47620158e+01 4.46311098e+01]]
ED-3 | [-87093.51684654  -2564.73543273   1387.80128936] | [[5203520.18493455 -110249.01431307   15397.06756633] [-110249.01431307    8857.87874759    5485.1125867 ] [  15397.06756633    5485.1125867     7730.71566523]]
Typhon | [-45156.52899756    610.44497946   2908.45803035] | [[ 1.12596616e+07  1.50100525e+04  4.07889817e+04] [ 1.50100525e+04  2.58739058e+03 -3.11008273e+03] [ 4.07889817e+04 -3.11008273e+03  1.77926058e+04]]
ED-5 | [-73131.75666162   -417.41420858   1360.2131682 ] | [[ 9.72579177e+06 -6.76349294e+04 -5.20633341e+04] [-6.76349294e+04  6.15159686e+03 -2.35515097e+03] [-5.20633341e+04 -2.35515097e+03  3.42501276e+03]]
Group 27 | [-1.54229163e+05  2.19425858e+01  4.42123138e+01] | [[ 4.74530803e+04  5.52197029e+02 -4.13613842e+02] [ 5.52197029e+02  1.32709766e+02 -6.37222779e+01] [-4.13613842e+02 -6.37222779e+01  3.82679362e+01]]
ED-6 | [-60528.1962893    -723.97224311   1782.30087621] | [[5474752.34150951   36149.29719424  126840.81949945] [  36149.29719424   41587.13708458   -8938.30664713] [ 126840.81949945   -8938.30664713   30249.31217349]]

## Dependancies
- Astropy
- numpy
