"""
Tools for modeling unit generators (UGens).
"""

# Need to import these before anything else
from .core import (  # isort:skip
    AudioControl,
    BinaryOpUGen,
    Check,
    Control,
    LagControl,
    OutputProxy,
    Parameter,
    PseudoUGen,
    SuperColliderSynthDef,
    SynthDef,
    SynthDefBuilder,
    TrigControl,
    UGen,
    UGenOperable,
    UGenSerializable,
    UGenVector,
    UnaryOpUGen,
    compile_synthdefs,
    decompile_synthdef,
    decompile_synthdefs,
    param,
    synthdef,
    ugen,
)

from .basic import Mix, MulAdd, Sum3, Sum4
from .beq import (
    BAllPass,
    BBandPass,
    BBandStop,
    BHiCut,
    BHiPass,
    BHiShelf,
    BLowCut,
    BLowPass,
    BLowShelf,
    BPeakEQ,
)
from .bufio import (
    BufRd,
    BufWr,
    ClearBuf,
    LocalBuf,
    MaxLocalBufs,
    PlayBuf,
    RecordBuf,
    ScopeOut,
    ScopeOut2,
)
from .chaos import (
    CuspL,
    CuspN,
    FBSineC,
    FBSineL,
    FBSineN,
    GbmanL,
    GbmanN,
    HenonC,
    HenonL,
    HenonN,
    LatoocarfianC,
    LatoocarfianL,
    LatoocarfianN,
    LinCongC,
    LinCongL,
    LinCongN,
    LorenzL,
    QuadC,
    QuadL,
    QuadN,
    StandardL,
    StandardN,
)
from .convolution import Convolution, Convolution2, Convolution2L, Convolution3
from .delay import (
    AllpassC,
    AllpassL,
    AllpassN,
    BufAllpassC,
    BufAllpassL,
    BufAllpassN,
    BufCombC,
    BufCombL,
    BufCombN,
    BufDelayC,
    BufDelayL,
    BufDelayN,
    CombC,
    CombL,
    CombN,
    Delay1,
    Delay2,
    DelayC,
    DelayL,
    DelayN,
    DelTapRd,
    DelTapWr,
)
from .demand import (
    Dbrown,
    Dbufrd,
    Dbufwr,
    Demand,
    DemandEnvGen,
    Dgeom,
    Dibrown,
    Diwhite,
    Drand,
    Dreset,
    Dseq,
    Dser,
    Dseries,
    Dshuf,
    Dstutter,
    Dswitch,
    Dswitch1,
    Dunique,
    Duty,
    Dwhite,
    Dwrand,
    Dxrand,
)
from .diskio import DiskIn, DiskOut, VDiskIn
from .dynamics import Amplitude, Compander, CompanderD, Limiter, Normalizer
from .envelopes import (
    Done,
    Envelope,
    EnvGen,
    Free,
    FreeSelf,
    FreeSelfWhenDone,
    Linen,
    Pause,
    PauseSelf,
    PauseSelfWhenDone,
)
from .ffsinosc import Blip, FSinOsc, Klank, Pulse, Saw
from .filters import (
    APF,
    BPF,
    BPZ2,
    BRF,
    BRZ2,
    FOS,
    HPF,
    HPZ1,
    HPZ2,
    LPF,
    LPZ1,
    LPZ2,
    RHPF,
    RLPF,
    SOS,
    Changed,
    Decay,
    Decay2,
    DetectSilence,
    Formlet,
    Integrator,
    Lag,
    Lag2,
    Lag2UD,
    Lag3,
    Lag3UD,
    LagUD,
    LeakDC,
    Median,
    MidEQ,
    MoogFF,
    OnePole,
    OneZero,
    Ramp,
    Ringz,
    Slew,
    Slope,
    TwoPole,
    TwoZero,
)
from .gendyn import Gendy1, Gendy2, Gendy3
from .granular import GrainBuf, GrainIn, PitchShift, Warp1
from .hilbert import FreqShift, Hilbert, HilbertFIR
from .info import (
    BlockSize,
    BufChannels,
    BufDur,
    BufFrames,
    BufRateScale,
    BufSampleRate,
    BufSamples,
    ControlDur,
    ControlRate,
    NodeID,
    NumAudioBuses,
    NumBuffers,
    NumControlBuses,
    NumInputBuses,
    NumOutputBuses,
    NumRunningSynths,
    RadiansPerSample,
    SampleDur,
    SampleRate,
    SubsampleOffset,
)
from .inout import In, InFeedback, LocalIn, LocalOut, OffsetOut, Out, ReplaceOut, XOut
from .lines import A2K, DC, K2A, AmpComp, AmpCompA, Line, LinExp, LinLin, Silence, XLine
from .mac import KeyState, MouseButton, MouseX, MouseY
from .ml import (
    MFCC,
    BeatTrack,
    BeatTrack2,
    KeyTrack,
    Loudness,
    Onsets,
    Pitch,
    SpecCentroid,
    SpecFlatness,
    SpecPcile,
)
from .noise import (
    BrownNoise,
    ClipNoise,
    CoinGate,
    Crackle,
    Dust,
    Dust2,
    ExpRand,
    GrayNoise,
    Hasher,
    IRand,
    LFClipNoise,
    LFDClipNoise,
    LFDNoise0,
    LFDNoise1,
    LFDNoise3,
    LFNoise0,
    LFNoise1,
    LFNoise2,
    LinRand,
    Logistic,
    MantissaMask,
    NRand,
    PinkNoise,
    Rand,
    RandID,
    RandSeed,
    TExpRand,
    TIRand,
    TRand,
    TWindex,
    WhiteNoise,
)
from .osc import (
    COsc,
    DegreeToKey,
    Impulse,
    Index,
    LFCub,
    LFGauss,
    LFPar,
    LFPulse,
    LFSaw,
    LFTri,
    Select,
    SinOsc,
    SyncSaw,
    VarSaw,
    Vibrato,
    VOsc,
    VOsc3,
    WrapIndex,
)
from .panning import (
    Balance2,
    BiPanB2,
    DecodeB2,
    Pan2,
    Pan4,
    PanAz,
    PanB,
    PanB2,
    Rotate2,
    Splay,
    XFade2,
)
from .physical import Ball, Pluck, Spring, TBall
from .pv import (
    FFT,
    IFFT,
    PV_Add,
    PV_BinScramble,
    PV_BinShift,
    PV_BinWipe,
    PV_BrickWall,
    PV_ChainUGen,
    PV_ConformalMap,
    PV_Conj,
    PV_Copy,
    PV_CopyPhase,
    PV_Diffuser,
    PV_Div,
    PV_HainsworthFoote,
    PV_JensenAndersen,
    PV_LocalMax,
    PV_MagAbove,
    PV_MagBelow,
    PV_MagClip,
    PV_MagDiv,
    PV_MagFreeze,
    PV_MagMul,
    PV_MagNoise,
    PV_MagShift,
    PV_MagSmear,
    PV_MagSquared,
    PV_Max,
    PV_Min,
    PV_Mul,
    PV_PhaseShift,
    PV_PhaseShift90,
    PV_PhaseShift270,
    PV_RandComb,
    PV_RandWipe,
    PV_RectComb,
    PV_RectComb2,
    RunningSum,
)
from .reverb import FreeVerb
from .safety import CheckBadValues, Sanitize
from .system import SYSTEM_SYNTHDEFS, default
from .triggers import (
    Clip,
    Fold,
    Gate,
    InRange,
    Latch,
    LeastChange,
    MostChange,
    Peak,
    PeakFollower,
    Phasor,
    Poll,
    RunningMax,
    RunningMin,
    Schmidt,
    SendPeakRMS,
    SendReply,
    SendTrig,
    Sweep,
    TDelay,
    ToggleFF,
    Trig,
    Trig1,
    Wrap,
    ZeroCrossing,
)

__all__ = [
    "A2K",
    "APF",
    "BPF",
    "BPZ2",
    "BRF",
    "BRZ2",
    "DC",
    "FFT",
    "FOS",
    "HPF",
    "HPZ1",
    "HPZ2",
    "IFFT",
    "K2A",
    "LPF",
    "LPZ1",
    "LPZ2",
    "MFCC",
    "RHPF",
    "RLPF",
    "SOS",
    "SYSTEM_SYNTHDEFS",
    "AllpassC",
    "AllpassL",
    "AllpassN",
    "AmpComp",
    "AmpCompA",
    "Amplitude",
    "AudioControl",
    "BAllPass",
    "BBandPass",
    "BBandStop",
    "BHiCut",
    "BHiPass",
    "BHiShelf",
    "BLowCut",
    "BLowPass",
    "BLowShelf",
    "BPeakEQ",
    "Balance2",
    "Ball",
    "BeatTrack",
    "BeatTrack2",
    "BiPanB2",
    "BinaryOpUGen",
    "Blip",
    "BlockSize",
    "BrownNoise",
    "BufAllpassC",
    "BufAllpassL",
    "BufAllpassN",
    "BufChannels",
    "BufCombC",
    "BufCombL",
    "BufCombN",
    "BufDelayC",
    "BufDelayL",
    "BufDelayN",
    "BufDur",
    "BufFrames",
    "BufRateScale",
    "BufRd",
    "BufSampleRate",
    "BufSamples",
    "BufWr",
    "COsc",
    "Changed",
    "Check",
    "CheckBadValues",
    "ClearBuf",
    "Clip",
    "ClipNoise",
    "CoinGate",
    "CombC",
    "CombL",
    "CombN",
    "Compander",
    "CompanderD",
    "Control",
    "ControlDur",
    "ControlRate",
    "Convolution",
    "Convolution2",
    "Convolution2L",
    "Convolution3",
    "Crackle",
    "CuspL",
    "CuspN",
    "Dbrown",
    "Dbufrd",
    "Dbufwr",
    "Decay",
    "Decay2",
    "DecodeB2",
    "DegreeToKey",
    "DelTapRd",
    "DelTapWr",
    "Delay1",
    "Delay2",
    "DelayC",
    "DelayL",
    "DelayN",
    "Demand",
    "DemandEnvGen",
    "DetectSilence",
    "Dgeom",
    "Dibrown",
    "DiskIn",
    "DiskOut",
    "Diwhite",
    "Done",
    "Drand",
    "Dreset",
    "Dseq",
    "Dser",
    "Dseries",
    "Dshuf",
    "Dstutter",
    "Dswitch",
    "Dswitch1",
    "Dunique",
    "Dust",
    "Dust2",
    "Duty",
    "Dwhite",
    "Dwrand",
    "Dxrand",
    "EnvGen",
    "Envelope",
    "ExpRand",
    "FBSineC",
    "FBSineL",
    "FBSineN",
    "FSinOsc",
    "Fold",
    "Formlet",
    "Free",
    "FreeSelf",
    "FreeSelfWhenDone",
    "FreeVerb",
    "FreqShift",
    "Gate",
    "GbmanL",
    "GbmanN",
    "Gendy1",
    "Gendy2",
    "Gendy3",
    "GrainBuf",
    "GrainIn",
    "GrayNoise",
    "Hasher",
    "HenonC",
    "HenonL",
    "HenonN",
    "Hilbert",
    "HilbertFIR",
    "IRand",
    "Impulse",
    "In",
    "InFeedback",
    "InRange",
    "Index",
    "Integrator",
    "KeyState",
    "KeyTrack",
    "Klank",
    "LFClipNoise",
    "LFCub",
    "LFDClipNoise",
    "LFDNoise0",
    "LFDNoise1",
    "LFDNoise3",
    "LFGauss",
    "LFNoise0",
    "LFNoise1",
    "LFNoise2",
    "LFPar",
    "LFPulse",
    "LFSaw",
    "LFTri",
    "Lag",
    "Lag2",
    "Lag2UD",
    "Lag3",
    "Lag3UD",
    "LagControl",
    "LagUD",
    "Latch",
    "LatoocarfianC",
    "LatoocarfianL",
    "LatoocarfianN",
    "LeakDC",
    "LeastChange",
    "Limiter",
    "LinCongC",
    "LinCongL",
    "LinCongN",
    "LinExp",
    "LinLin",
    "LinRand",
    "Line",
    "Linen",
    "LocalBuf",
    "LocalIn",
    "LocalOut",
    "Logistic",
    "LorenzL",
    "Loudness",
    "MantissaMask",
    "MaxLocalBufs",
    "Median",
    "MidEQ",
    "Mix",
    "MoogFF",
    "MostChange",
    "MouseButton",
    "MouseX",
    "MouseY",
    "MulAdd",
    "NRand",
    "NodeID",
    "Normalizer",
    "NumAudioBuses",
    "NumBuffers",
    "NumControlBuses",
    "NumInputBuses",
    "NumOutputBuses",
    "NumRunningSynths",
    "OffsetOut",
    "OnePole",
    "OneZero",
    "Onsets",
    "Out",
    "OutputProxy",
    "PV_Add",
    "PV_BinScramble",
    "PV_BinShift",
    "PV_BinWipe",
    "PV_BrickWall",
    "PV_ChainUGen",
    "PV_ConformalMap",
    "PV_Conj",
    "PV_Copy",
    "PV_CopyPhase",
    "PV_Diffuser",
    "PV_Div",
    "PV_HainsworthFoote",
    "PV_JensenAndersen",
    "PV_LocalMax",
    "PV_MagAbove",
    "PV_MagBelow",
    "PV_MagClip",
    "PV_MagDiv",
    "PV_MagFreeze",
    "PV_MagMul",
    "PV_MagNoise",
    "PV_MagShift",
    "PV_MagSmear",
    "PV_MagSquared",
    "PV_Max",
    "PV_Min",
    "PV_Mul",
    "PV_PhaseShift",
    "PV_PhaseShift90",
    "PV_PhaseShift270",
    "PV_RandComb",
    "PV_RandWipe",
    "PV_RectComb",
    "PV_RectComb2",
    "Pan2",
    "Pan4",
    "PanAz",
    "PanB",
    "PanB2",
    "Parameter",
    "Pause",
    "PauseSelf",
    "PauseSelfWhenDone",
    "Peak",
    "PeakFollower",
    "Phasor",
    "PinkNoise",
    "Pitch",
    "PitchShift",
    "PlayBuf",
    "Pluck",
    "Poll",
    "PseudoUGen",
    "Pulse",
    "QuadC",
    "QuadL",
    "QuadN",
    "RadiansPerSample",
    "Ramp",
    "Rand",
    "RandID",
    "RandSeed",
    "RecordBuf",
    "ReplaceOut",
    "Ringz",
    "Rotate2",
    "RunningMax",
    "RunningMin",
    "RunningSum",
    "SampleDur",
    "SampleRate",
    "Sanitize",
    "Saw",
    "Schmidt",
    "ScopeOut",
    "ScopeOut2",
    "Select",
    "SendPeakRMS",
    "SendReply",
    "SendTrig",
    "Silence",
    "SinOsc",
    "Slew",
    "Slope",
    "SpecCentroid",
    "SpecFlatness",
    "SpecPcile",
    "Splay",
    "Spring",
    "StandardL",
    "StandardN",
    "SubsampleOffset",
    "Sum3",
    "Sum4",
    "SuperColliderSynthDef",
    "Sweep",
    "SyncSaw",
    "SynthDef",
    "SynthDefBuilder",
    "TBall",
    "TDelay",
    "TExpRand",
    "TIRand",
    "TRand",
    "TWindex",
    "ToggleFF",
    "Trig",
    "Trig1",
    "TrigControl",
    "TwoPole",
    "TwoZero",
    "UGen",
    "UGenOperable",
    "UGenSerializable",
    "UGenVector",
    "UnaryOpUGen",
    "VDiskIn",
    "VOsc",
    "VOsc3",
    "VarSaw",
    "Vibrato",
    "Warp1",
    "WhiteNoise",
    "Wrap",
    "WrapIndex",
    "XFade2",
    "XLine",
    "XOut",
    "ZeroCrossing",
    "compile_synthdefs",
    "decompile_synthdef",
    "decompile_synthdefs",
    "default",
    "param",
    "synthdef",
    "ugen",
]
