from __future__ import annotations

from typing import Any, AsyncContextManager, Protocol


class ORM(Protocol):
    async def create_database(self): ...
    async def drop_database(self): ...
    def session(self) -> AsyncContextManager["Session"]: ...
    async def migrate(self): ...
    def repo(self, model: type["Model"]) -> "Repository": ...


class Model:
    class Meta:
        table_name: str | None = None

    @classmethod
    async def create(cls, **fields): ...

    @classmethod
    async def get(cls, **filters): ...

    @classmethod
    def query(cls) -> "Query": ...

    async def update(self, **fields): ...

    async def delete(self): ...


class fields:
    @staticmethod
    def Int(pk: bool = False, default: int | None = None): ...

    @staticmethod
    def Str(max_length: int | None = None, unique: bool = False): ...

    @staticmethod
    def Text(): ...

    @staticmethod
    def Bool(default: bool = False): ...

    @staticmethod
    def Datetime(auto_now: bool = False, auto_now_add: bool = False): ...

    @staticmethod
    def ForeignKey(to: type[Model], on_delete: str = "cascade"): ...

