# PhonePe Payment Processing

A simple Python Package to integrate Phonepe payments in your application.

## What is Phonepe

It is a UPI powered payment System which provide various api to process payment in this we have used the test api provided the phonepe for payment processing.


## API Reference

#### Initialize Payment

```http
  POST https://api-preprod.phonepe.com/apis/pg-sandbox/pg/v1/pay
```

| Parameter | Type     | Description                |
| :-------- | :------- | :------------------------- |
| `salt Key` | `string` | **Required**. Your salt Key |
| `Salt Index`| `int` | **Required**. Your salt Index|
| `Merchant Id` | `string` | **Required**. Your Merchant Id is Required.|

#### Check Payment Status 

```http
  GET https://api-preprod.phonepe.com/apis/pg-sandbox/pg/v1/status/${merchant_id}/${transaction_id}"
```

| Parameter | Type     | Description                       |
| :-------- | :------- | :-------------------------------- |
| `merchant Id`      | `string` | **Required**. Your Merchant Id is Required. |
| `Transaction Id`      | `string` | **Required**. Id of the Transaction is Required to Check status. |
| `salt Key` | `string` | **Required**. Your salt Key |
| `Salt Index`| `int` | **Required**. Your salt Index|



## Environment Variables

To run this project, you will need to add the following environment variables to your .env file

`Salt_Key`

`API KEY`

`Merchant Id`


## Features

- Payment Integration
- Initialize Payment
- Check Status
- Cross platform


## 🚀 About Me
I'm a full stack developer...


## 🔗 Links

[![linkedin](https://img.shields.io/badge/linkedin-0A66C2?style=for-the-badge&logo=linkedin&logoColor=white)](https://www.linkedin.com/in/dev-pancholi-b4012b230)


## Installtion

install phonepe-payment using pip

```sh
pip install phonepe-payment
```

start project 

```sh
Initialize of Payment class is Required
```

## Function can be used 

- InitalizePayment()

args Required:- 

| Paramater   | Type         | Required/optional | Description               |
| :--------   | :-------     | :-----------------| :------------------------ |
| **user_id** | `string/int` | `Required`        | Required for user verification    |
| **amount**  | `int`          | `Required`      | amount in rupees |
| **Mobile Number** | `Number` | `Required`      | mobile Number of user is Required | 
| **RedirectUrl** | `http` | `Optional` | Redirect Url is optional to redirect user after payment is Done |
| **CallbackUrl** | `http` | `optional` | Callback Url is optional to send the payment status |
| **Salt_key** | `string` | `optional` | this is optional but required for production as default using test key | 
| **Transaction_id** | `string` | `optional` | Automatically generated by the system |
| **merchant_id** | `string` | `optional` | this is optional but required for production as default using test merchant id|
| **payment_page_redirect** | `boolean` | `optional` | this is optional by default is is using False to not to open the payment page|


- CheckPaymentStatus()

args Required:- 

| Paramater   | Type         | Required/optional | Description               |
| :--------   | :-------     | :-----------------| :------------------------ |
| **Transaction_id** | `string` | `optional` | Required same as the transaction id generated in while InitalizePayment() |
| **merchant_id** | `string` | `optional` | this is optional but required for production as default using test merchant id|
| **Salt_key** | `string` | `optional` | this is optional but required for production as default using test key | 


## License

[MIT](https://github.com/Devpancholi04/phonepe_transaction/blob/main/LICENSE)



## Support

For support, email devpancholigt2004@gmail.com



## Authors

- [@DevPancholi](https://github.com/Devpancholi04/)

