from airflow_config import load_config

RENDERED_DAG = """# Generated by airflow-config
from datetime import datetime

from airflow.models import DAG
from airflow.providers.standard.operators.bash import BashOperator

from airflow_common.library.task import InstallLibrarySSHOperator

with DAG(
    description="this is an example dag",
    schedule="0 3 * * *",
    start_date=datetime.fromisoformat("2023-01-01T00:00:00"),
    dag_id="setup-env",
    default_args={},
) as dag:
    first = BashOperator(bash_command="echo '1'", task_id="first", dag=dag)
    run = InstallLibrarySSHOperator(
        pip=[
            {"name": "lib1", "version_constraint": ">=1.0"},
            {"name": "lib2", "version_constraint": "<=1.0"},
            {"name": "lib3", "version_constraint": "!=1.0"},
        ],
        git=[{"name": "git1", "repo": "test"}, {"name": "git2", "repo": "test", "branch": "develop"}, {"name": "git3", "repo": "test"}],
        command_prefix='echo "test"',
        task_id="run",
        dag=dag,
    )
    last = BashOperator(bash_command="echo '2'", task_id="last", dag=dag)
    first >> run
    run >> last
"""


class TestConfig:
    def test_load_config_hydra(self):
        config = load_config(config_name="config")
        assert config
        assert "libraries" in config.extensions
        assert len(config.extensions["libraries"].pip) == 3
        assert len(config.extensions["libraries"].git) == 3

    def test_render_and_instantiate(self):
        config = load_config(config_name="config")
        assert config.dags["setup-env"].render() == RENDERED_DAG
        exec(config.dags["setup-env"].render())
