from airflow_config import load_config

RENDERED_DAG = """# Generated by airflow-config
from datetime import datetime

from airflow.models import DAG

from airflow_common.infra.task import JournalctlClean

with DAG(
    description="this is an example dag",
    schedule="0 3 * * *",
    start_date=datetime.fromisoformat("2023-01-01T00:00:00"),
    dag_id="clean-journalctl",
    default_args={},
) as dag:
    clean = JournalctlClean(sudo=True, days=2, task_id="clean", dag=dag)
"""


class TestConfig:
    def test_load_config_hydra(self):
        config = load_config(config_name="config")
        assert config
        assert "libraries" in config.extensions
        assert len(config.extensions["libraries"].pip) == 3
        assert len(config.extensions["libraries"].git) == 3

    def test_render_and_instantiate(self):
        config = load_config(config_name="config")
        assert config.dags["clean-journalctl"].render() == RENDERED_DAG
        exec(config.dags["clean-journalctl"].render())
