import setuptools
from ptvulns._version import __version__

with open("README.md", "r") as fh:
    long_description = fh.read()


setuptools.setup(
    name="ptvulns",
    version=__version__,
    description="",
    author="Penterep",
    author_email="info@penterep.com",
    url="https://www.penterep.com/",
    license="GPLv3",
    packages=setuptools.find_packages(),
    package_data={
        "ptvulns": ["3rd_party/**/*"],
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: Implementation :: CPython",
        "Environment :: Console",
        "Topic :: Security",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)"
    ],
    python_requires='>=3.12',
    install_requires=["ptlibs>=1.0.47,<2", "ujson", "pyxploitdb", "aiohttp", "aiolimiter"],
    entry_points = {'console_scripts': ['ptvulns = ptvulns.ptvulns:main']},
    include_package_data= True,
    long_description=long_description,
    long_description_content_type="text/markdown",
    project_urls = {
    "homepage":   "https://www.penterep.com/",
    "repository": "https://github.com/penterep/ptvulns",
    "tracker":    "https://github.com/penterep/ptvulns/issues",
}
)