# 🚀 `jaganathanj` – Resume as a Python Package

[![PyPI version](https://badge.fury.io/py/jaganathanj.svg)](https://badge.fury.io/py/jaganathanj)
[![Python 3.6+](https://img.shields.io/badge/python-3.6+-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

> “Why send a PDF when you can `pip install` a person?”

Meet the world’s first Python package that **is** a resume, built by a developer who thinks different. From achievements to contact info, explore everything about me right from your terminal.

---

## 📦 Installation

```bash
pip install jaganathanj
````

> ✅ Requires: Python 3.6+
> ✅ No extra dependencies
> ✅ Works offline (except for external links)

---

## 🧠 What You Get

This isn't a gimmick — it's my full tech journey, built into a Python module:

* 📘 Career story, impact, and resume
* 🧠 Research & patents
* 💡 Projects & open-source
* 📊 Skills & technologies
* 📬 Contact & social links

---

## ⚙️ Python Usage

```python
import jaganathanj

jaganathanj.about()       # My full story and context
jaganathanj.resume()      # A concise resume snapshot
jaganathanj.cv()          # Extended version of my CV

# Contact & connect
jaganathanj.contact()
jaganathanj.linkedin()
jaganathanj.github()
jaganathanj.portfolio()
jaganathanj.youtube()

# List all available commands
jaganathanj.help()
```

---

## 💻 CLI Commands

For terminal lovers, just run:

```bash
jaganathanj                # Welcome Message
jaganathanj resume         # Quick resume in terminal
jaganathanj about          # Complete story
jaganathanj contact        # Email & social links
jaganathanj help           # See all available options
```

No need to open a browser — explore my profile directly in your shell.

---

## 🎬 How to Operate `jaganathanj`

Want to see it in action?  
Here’s a quick walkthrough video showing how to install and use the package:

▶️ [Watch on YouTube](https://youtu.be/LFaU3U8HQqA)

---

## 👨‍💻 About Me

* 🎓 Final Year CSE @ SRM Easwari Engineering College
* 🏆 IIT Madras Shaastra Hackathon 2025 Finalist
* 📜 Patent: SARIMA-based GPS Alternative (202441089112 A)
* 🎥 YouTube Creator: 667% growth in 15 days
* 👨‍🏫 Taught 70+ peers to 100% pass rate in networking labs
* 🥇 NPTEL Gold Medalist (Cloud Computing)

---

## 🛠️ Tech Stack

**Languages:** Python, Java, C++, JS
**Cloud/DB:** AWS, Firebase, MongoDB, SQL
**Focus Areas:** ML, NLP, System Design

---

## 🎯 Why This Package?

Because traditional resumes don’t show:

* 💡 Innovation & initiative
* 📐 Real-world tech skills
* 🎯 Personal branding
* 📱 Developer-first accessibility

This package is my career — executable.

---

## 🌐 Connect With Me

📧 Email: [jaganathanjjds@gmail.com](mailto:jaganathanjjds@gmail.com)
🔗 LinkedIn: [linkedin.com/in/jaganathan-jn](https://linkedin.com/in/jaganathan-jn)
💻 GitHub: [github.com/J-Jaganathan](https://github.com/J-Jaganathan)
🌐 Portfolio: [jaganathan-j-portfolio.vercel.app](https://jaganathan-j-portfolio.vercel.app/)
📺 YouTube: [@Tech\_CrafterX](https://youtube.com/@Tech_CrafterX)

---

## 📈 Package Info

* Version: `1.0.18`
* No external dependencies
* Zero bloat
* Works offline (except web links)

---

## 🚀 What's Next?

I'm open to opportunities in:

* Data Science & AI/ML
* Backend & Full-Stack Roles
* Research Collaborations
* Developer Advocacy & Teaching

---

## 📜 License

This project is licensed under the **MIT License**.  
You are free to use, modify, and distribute this package in accordance with the terms of the license.

---

Thanks for installing me. See you in your terminal! ✨

---

