# Generated by Django 5.2.4 on 2025-09-09 04:00

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Lead",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(max_length=200, verbose_name="Full Name")),
                ("email", models.EmailField(max_length=254, verbose_name="Email")),
                (
                    "company",
                    models.CharField(blank=True, max_length=200, null=True, verbose_name="Company"),
                ),
                (
                    "company_site",
                    models.CharField(
                        blank=True, max_length=200, null=True, verbose_name="Company Site"
                    ),
                ),
                (
                    "contact_type",
                    models.CharField(
                        choices=[
                            ("email", "Email"),
                            ("whatsapp", "WhatsApp"),
                            ("telegram", "Telegram"),
                            ("phone", "Phone"),
                            ("other", "Other"),
                        ],
                        default="email",
                        max_length=20,
                        verbose_name="Contact Type",
                    ),
                ),
                (
                    "contact_value",
                    models.CharField(
                        blank=True, max_length=200, null=True, verbose_name="Contact Value"
                    ),
                ),
                (
                    "subject",
                    models.CharField(blank=True, max_length=200, null=True, verbose_name="Subject"),
                ),
                ("message", models.TextField(verbose_name="Message")),
                ("extra", models.JSONField(blank=True, null=True, verbose_name="Extra Data")),
                (
                    "site_url",
                    models.URLField(
                        help_text="Frontend URL where form was submitted", verbose_name="Site URL"
                    ),
                ),
                ("user_agent", models.TextField(blank=True, null=True, verbose_name="User Agent")),
                (
                    "ip_address",
                    models.GenericIPAddressField(blank=True, null=True, verbose_name="IP Address"),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("new", "New"),
                            ("contacted", "Contacted"),
                            ("qualified", "Qualified"),
                            ("converted", "Converted"),
                            ("rejected", "Rejected"),
                        ],
                        default="new",
                        max_length=20,
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="Created At"
                    ),
                ),
                ("updated_at", models.DateTimeField(auto_now=True, verbose_name="Updated At")),
                (
                    "admin_notes",
                    models.TextField(blank=True, null=True, verbose_name="Admin Notes"),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "Lead",
                "verbose_name_plural": "Leads",
                "ordering": ["-created_at"],
                "indexes": [
                    models.Index(
                        fields=["site_url", "status"], name="django_cfg__site_ur_20f148_idx"
                    ),
                    models.Index(fields=["created_at"], name="django_cfg__created_610f4c_idx"),
                    models.Index(fields=["email"], name="django_cfg__email_da445e_idx"),
                ],
            },
        ),
    ]
