"""Google address model."""

# pylint: disable=too-many-lines,line-too-long,global-statement
import datetime
import json
import logging
import os
from collections import namedtuple
from typing import Any

import geocoder  # type: ignore
import pytest_is_running
from scrapesession.scrapesession import ScrapeSession  # type: ignore
from timezonefinder import TimezoneFinder  # type: ignore

from ...cache import MEMORY
from ..address_model import VERSION, AddressModel
from ..weather.multi_weather_model import create_mutli_weather_model
from .address_exception import AddressException

SportsballGeocodeTuple = namedtuple(
    "SportsballGeocodeTuple",
    ["city", "state", "postal", "lat", "lng", "housenumber", "country"],
)
THE_FORUM = SportsballGeocodeTuple(
    city="Inglewood",
    state="CA",
    postal="",
    lat=33.958333,
    lng=-118.341667,
    housenumber="3900",
    country="USA",
)
ORLANDO_ARENA = SportsballGeocodeTuple(
    city="Orlando",
    state="FL",
    postal="32801",
    lat=28.548889,
    lng=-81.386667,
    housenumber="600",
    country="USA",
)
ATT_CENTER = SportsballGeocodeTuple(
    city="San Antonio",
    state="TX",
    postal="",
    lat=29.426944,
    lng=-98.4375,
    housenumber="1",
    country="USA",
)
FTX_ARENA = SportsballGeocodeTuple(
    city="Miami",
    state="FL",
    postal="",
    lat=25.781389,
    lng=-80.188056,
    housenumber="601",
    country="USA",
)
VIVINT_ARENA = SportsballGeocodeTuple(
    city="Salt Lake City",
    state="UT",
    postal="",
    lat=40.768333,
    lng=-111.901111,
    housenumber="301",
    country="USA",
)
CHESAPEAKE_ENERGY_ARENA = SportsballGeocodeTuple(
    city="Oklahoma City",
    state="OK",
    postal="",
    lat=35.463333,
    lng=-97.515,
    housenumber="100",
    country="USA",
)
ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX = SportsballGeocodeTuple(
    city="Lake Buena Vista",
    state="FL",
    postal="32830",
    lat=28.337083,
    lng=-81.556,
    housenumber="1375",
    country="USA",
)
QUICKEN_LOANS_ARENA = SportsballGeocodeTuple(
    city="Cleveland",
    state="OH",
    postal="",
    lat=41.496389,
    lng=-81.688056,
    housenumber="1",
    country="USA",
)
DUNN_OLIVER_ACADOME = SportsballGeocodeTuple(
    city="Montgomery",
    state="AL",
    postal="",
    lat=32.36185,
    lng=-86.293158,
    housenumber="",
    country="USA",
)
BRADLEY_CENTER = SportsballGeocodeTuple(
    city="Milwaukee",
    state="WI",
    postal="",
    lat=43.043611,
    lng=-87.916944,
    housenumber="1001",
    country="USA",
)
TEXAS_AM_COMMERCE_FIELD_HOUSE = SportsballGeocodeTuple(
    city="Commerce",
    state="TX",
    postal="75428",
    lat=33.245337,
    lng=-95.907619,
    housenumber="2600",
    country="USA",
)
SAVAGE_ARENA = SportsballGeocodeTuple(
    city="Toledo",
    state="OH",
    postal="43606",
    lat=41.660232,
    lng=-83.609795,
    housenumber="2025",
    country="USA",
)
CHASE_ATHLETIC_CENTER = SportsballGeocodeTuple(
    city="Cleveland",
    state="OH",
    postal="",
    lat=41.499167,
    lng=-81.694722,
    housenumber="",
    country="USA",
)
MURPHY_ATHELTIC_CENTER = SportsballGeocodeTuple(
    city="Murfreesboro",
    state="TN",
    postal="37132",
    lat=35.852467,
    lng=-86.369803,
    housenumber="2650",
    country="USA",
)
ROSS_E_TEMPLETON_CENTER = SportsballGeocodeTuple(
    city="Clinton",
    state="SC",
    postal="29325",
    lat=34.465,
    lng=-81.869,
    housenumber="503",
    country="USA",
)
HOLMES_CENTER = SportsballGeocodeTuple(
    city="Boone",
    state="NC",
    postal="28608",
    lat=36.210624,
    lng=-81.675952,
    housenumber="111",
    country="USA",
)
FARRIS_CENTER = SportsballGeocodeTuple(
    city="Conway",
    state="AR",
    postal="",
    lat=35.081667,
    lng=-92.459444,
    housenumber="",
    country="USA",
)
EA_DIDDLE_ARENA = SportsballGeocodeTuple(
    city="Bowling Green",
    state="KY",
    postal="42101",
    lat=36.985833,
    lng=-86.4575,
    housenumber="1526",
    country="USA",
)
AG_SPANOS_CENTER = SportsballGeocodeTuple(
    city="Stockton",
    state="CA",
    postal="95211",
    lat=37.976669,
    lng=-121.315095,
    housenumber="1178",
    country="USA",
)
WAR_MEMORIAL_GYMNASIUM = SportsballGeocodeTuple(
    city="San Francisco",
    state="CA",
    postal="94118",
    lat=37.776944,
    lng=-122.449444,
    housenumber="2335",
    country="USA",
)
HENDERSON_CENTER = SportsballGeocodeTuple(
    city="Huntington",
    state="WV",
    postal="25755",
    lat=38.424517,
    lng=-82.425211,
    housenumber="",
    country="USA",
)
STONY_BROOK_ARENA = SportsballGeocodeTuple(
    city="Stony Brook",
    state="NY",
    postal="11790",
    lat=40.91741,
    lng=-73.125955,
    housenumber="100",
    country="USA",
)
ARCO_ARENA = SportsballGeocodeTuple(
    city="Sacramento",
    state="CA",
    postal="",
    lat=38.649167,
    lng=-121.518056,
    housenumber="1",
    country="USA",
)
THE_PALACE_OF_AUBURN_HILLS = SportsballGeocodeTuple(
    city="Auburn Hills",
    state="MI",
    postal="",
    lat=42.696944,
    lng=-83.245556,
    housenumber="6",
    country="USA",
)
STATE_FARM_FIELDHOUSE = SportsballGeocodeTuple(
    city="Lake Buena Vista",
    state="FL",
    postal="",
    lat=28.337083,
    lng=-81.556,
    housenumber="",
    country="USA",
)
GSU_CONVOCATION_CENTER = SportsballGeocodeTuple(
    city="Atlanta",
    state="GA",
    postal="30312",
    lat=33.7427,
    lng=-84.38869,
    housenumber="455",
    country="USA",
)
O2_ARENA = SportsballGeocodeTuple(
    city="London",
    state="",
    postal="SE10",
    lat=51.5029,
    lng=0.0032,
    housenumber="",
    country="UK",
)
HARRAHS_CHEROKEE_CENTER = SportsballGeocodeTuple(
    city="Asheville",
    state="NC",
    postal="",
    lat=35.597547,
    lng=-82.555384,
    housenumber="87",
    country="USA",
)
FORD_CENTER_AT_THE_STAR = SportsballGeocodeTuple(
    city="Frisco",
    state="TX",
    postal="",
    lat=33.1105,
    lng=-96.8281,
    housenumber="9",
    country="USA",
)
DUNKIN_DONUTS_CENTER = SportsballGeocodeTuple(
    city="Providence",
    state="RI",
    postal="",
    lat=41.823611,
    lng=-71.418333,
    housenumber="1",
    country="USA",
)
RYAN_CENTER = SportsballGeocodeTuple(
    city="Kingston",
    state="RI",
    postal="02881",
    lat=41.4875,
    lng=-71.535556,
    housenumber="1",
    country="USA",
)
GENEROSO_POPE_ATHELTIC_COMPLEX = SportsballGeocodeTuple(
    city="Brooklyn Heights",
    state="NY",
    postal="11201",
    lat=40.693147,
    lng=-73.992164,
    housenumber="180",
    country="USA",
)
ELMORE_GYMNASIUM = SportsballGeocodeTuple(
    city="Normal",
    state="AL",
    postal="35762",
    lat=34.7852,
    lng=-86.5752,
    housenumber="4900",
    country="USA",
)
VIRGIN_ISLANDS_SPORT_AND_FITNESS_CENTER = SportsballGeocodeTuple(
    city="St. Thomas",
    state="USVI",
    postal="",
    lat=18.340096,
    lng=-64.97306,
    housenumber="",
    country="USA",
)
ANAHEIM_CONVENTION_CENTER = SportsballGeocodeTuple(
    city="Anaheim",
    state="CA",
    postal="92802",
    lat=33.802455,
    lng=-117.919843,
    housenumber="800",
    country="USA",
)
BINGHAMPTON_UNIVERSITY_EVENTS_CENTER = SportsballGeocodeTuple(
    city="Binghamton",
    state="NY",
    postal="13902-6000",
    lat=42.093333,
    lng=-75.971944,
    housenumber="4400",
    country="USA",
)
ICCU_ARENA = SportsballGeocodeTuple(
    city="Moscow",
    state="ID",
    postal="",
    lat=46.7275,
    lng=-117.018056,
    housenumber="",
    country="USA",
)
HERTZ_ARENA = SportsballGeocodeTuple(
    city="Estero",
    state="FL",
    postal="",
    lat=26.440668,
    lng=-81.778809,
    housenumber="11000",
    country="USA",
)
CHASE_FAMILY_ARENA = SportsballGeocodeTuple(
    city="Hartford",
    state="CT",
    postal="06117",
    lat=41.8018079,
    lng=-72.7191231,
    housenumber="200",
    country="USA",
)
ROSE_GARDEN = SportsballGeocodeTuple(
    city="Portland",
    state="OR",
    postal="",
    lat=45.531667,
    lng=-122.666667,
    housenumber="1",
    country="USA",
)
TIMES_UNION_CENTER = SportsballGeocodeTuple(
    city="Albany",
    state="NY",
    postal="",
    lat=42.648611,
    lng=-73.754722,
    housenumber="51",
    country="USA",
)
SIU_ARENA = SportsballGeocodeTuple(
    city="Carbondale",
    state="IL",
    postal="",
    lat=37.708333,
    lng=-89.218611,
    housenumber="",
    country="USA",
)
TOYOTA_CENTER = SportsballGeocodeTuple(
    city="Kennewick",
    state="WA",
    postal="",
    lat=46.22,
    lng=-119.217,
    housenumber="7016",
    country="USA",
)
CHARLOTTE_COLISEUM = SportsballGeocodeTuple(
    city="Charlotte",
    state="NC",
    postal="",
    lat=35.186389,
    lng=-80.912778,
    housenumber="",
    country="USA",
)
REUNION_ARENA = SportsballGeocodeTuple(
    city="Dallas",
    state="TX",
    postal="75207",
    lat=32.772778,
    lng=-96.808056,
    housenumber="777",
    country="USA",
)
MERRELL_CENTER = SportsballGeocodeTuple(
    city="Katy",
    state="TX",
    postal="77494",
    lat=29.780278,
    lng=-95.832222,
    housenumber="6301",
    country="USA",
)
MCNICHOLS_SPORTS_ARENA = SportsballGeocodeTuple(
    city="Denver",
    state="CO",
    postal="",
    lat=39.742778,
    lng=-105.0225,
    housenumber="1635",
    country="USA",
)
MARKET_SQUARE_ARENA = SportsballGeocodeTuple(
    city="Indianapolis",
    state="IN",
    postal="46204",
    lat=39.768333,
    lng=-86.151944,
    housenumber="300",
    country="USA",
)
HULMAN_CENTER = SportsballGeocodeTuple(
    city="Terre Haute",
    state="IN",
    postal="47809",
    lat=39.468333,
    lng=-87.405,
    housenumber="200",
    country="USA",
)
SAN_DIEGO_SPORTS_ARENA = SportsballGeocodeTuple(
    city="San Diego",
    state="CA",
    postal="",
    lat=32.755278,
    lng=-117.212222,
    housenumber="3500",
    country="USA",
)
ALLEN_COUNTY_WAR_MEMORIAL_COLISEUM = SportsballGeocodeTuple(
    city="Fort Wayne",
    state="IN",
    postal="23173",
    lat=41.115556,
    lng=-85.124444,
    housenumber="4000",
    country="USA",
)
SMITH_SPECTRUM = SportsballGeocodeTuple(
    city="Logan",
    state="UT",
    postal="",
    lat=41.748,
    lng=-111.812,
    housenumber="900",
    country="USA",
)
MOBY_ARENA = SportsballGeocodeTuple(
    city="Fort Collins",
    state="CO",
    postal="",
    lat=40.575669,
    lng=-105.093403,
    housenumber="951",
    country="USA",
)
DORTON_ARENA = SportsballGeocodeTuple(
    city="Raleigh",
    state="NC",
    postal="",
    lat=35.793611,
    lng=-78.71,
    housenumber="1025",
    country="USA",
)
SAN_JOSE_CIVIC_AUDITORIUM = SportsballGeocodeTuple(
    city="San Jose",
    state="CA",
    postal="95113",
    lat=37.330987,
    lng=-121.890168,
    housenumber="135",
    country="USA",
)
MIAMI_BEACH_CONVENTION_CENTER = SportsballGeocodeTuple(
    city="Miami Beach",
    state="FL",
    postal="33139",
    lat=25.7948,
    lng=-80.1332,
    housenumber="1901",
    country="USA",
)
BOSTON_GARDENS = SportsballGeocodeTuple(
    city="Boston",
    state="MA",
    postal="",
    lat=42.365833,
    lng=-71.061667,
    housenumber="150",
    country="USA",
)
THE_JUNGLE = SportsballGeocodeTuple(
    city="Indianapolis",
    state="IN",
    postal="46202",
    lat=39.770556,
    lng=-86.175,
    housenumber="901",
    country="USA",
)
BAROSSA_PARK = SportsballGeocodeTuple(
    city="Lyndoch",
    state="SA",
    postal="5351",
    lat=-34.5988377,
    lng=138.8028998,
    housenumber="2",
    country="Australia",
)
BUCCANEER_FIELDHOUSE = SportsballGeocodeTuple(
    city="Charleston",
    state="SC",
    postal="29406",
    lat=32.980822,
    lng=-80.067125,
    housenumber="9200",
    country="USA",
)
WELLNESS_AND_EVENTS_CENTER = SportsballGeocodeTuple(
    city="Newark",
    state="NJ",
    postal="07102",
    lat=40.7453,
    lng=-74.183,
    housenumber="100",
    country="USA",
)
SIMMONS_BANK_ARENA = SportsballGeocodeTuple(
    city="North Little Rock",
    state="AR",
    postal="72114",
    lat=34.755111,
    lng=-92.264439,
    housenumber="1",
    country="USA",
)
LEGACY_CENTER = SportsballGeocodeTuple(
    city="Lake Charles",
    state="LA",
    postal="70607",
    lat=30.1755,
    lng=-93.2095,
    housenumber="",
    country="USA",
)
REYNOLDS_COLISEUM = SportsballGeocodeTuple(
    city="Raleigh",
    state="NC",
    postal="",
    lat=35.783,
    lng=-78.67,
    housenumber="103",
    country="USA",
)
VANCOUVER_CONVENTION_CENTER = SportsballGeocodeTuple(
    city="Vancouver",
    state="BC",
    postal="",
    lat=49.289167,
    lng=-123.113797,
    housenumber="1055",
    country="Canada",
)
KENDALL_ISAACS_GYMNASIUM = SportsballGeocodeTuple(
    city="Nassau",
    state="",
    postal="",
    lat=25.0524506,
    lng=-77.3627058,
    housenumber="",
    country="Bahamas",
)
MEMORIAL_COLISEUM = SportsballGeocodeTuple(
    city="Portland",
    state="OR",
    postal="",
    lat=45.532,
    lng=-122.669,
    housenumber="300",
    country="USA",
)
BROOKSHIRE_GROCERY_ARENA = SportsballGeocodeTuple(
    city="Bossier City",
    state="LA",
    postal="",
    lat=32.465167,
    lng=-93.673583,
    housenumber="2000",
    country="USA",
)
NEW_ORLEANS_CITY = SportsballGeocodeTuple(
    city="New Orleans",
    state="LA",
    postal="",
    lat=29.976111,
    lng=-90.078333,
    housenumber="",
    country="USA",
)
HART_RECREATION_CENTER = SportsballGeocodeTuple(
    city="Worcester",
    state="MA",
    postal="01610",
    lat=42.235046,
    lng=-71.806381,
    housenumber="1",
    country="USA",
)
CFSB_CENTER = SportsballGeocodeTuple(
    city="Murray",
    state="KY",
    postal="42071",
    lat=36.62267,
    lng=-88.32031,
    housenumber="1401",
    country="USA",
)
TD_BANK_SPORTS_CENTER = SportsballGeocodeTuple(
    city="Hamden",
    state="CT",
    postal="06518",
    lat=41.413833,
    lng=-72.911157,
    housenumber="305",
    country="USA",
)
CABOT_CENTER = SportsballGeocodeTuple(
    city="Boston",
    state="MA",
    postal="02115",
    lat=42.3396,
    lng=-71.0898,
    housenumber="400",
    country="USA",
)
CENTRUM_ARENA = SportsballGeocodeTuple(
    city="Cedar City",
    state="UT",
    postal="84720",
    lat=37.675556,
    lng=-113.073056,
    housenumber="351",
    country="USA",
)
BANK_OF_KENTUCKY_CENTER = SportsballGeocodeTuple(
    city="Highland Heights",
    state="KY",
    postal="41099",
    lat=39.032273,
    lng=-84.458864,
    housenumber="500",
    country="USA",
)
THE_NEST = SportsballGeocodeTuple(
    city="Sacramento",
    state="CA",
    postal="",
    lat=38.561903,
    lng=-121.426878,
    housenumber="",
    country="USA",
)
UCCU_CENTER = SportsballGeocodeTuple(
    city="Orem",
    state="UT",
    postal="",
    lat=40.278724,
    lng=-111.716956,
    housenumber="800",
    country="USA",
)
HARBOR_YARD = SportsballGeocodeTuple(
    city="Bridgeport",
    state="CT",
    postal="06604",
    lat=41.171944,
    lng=-73.1875,
    housenumber="500",
    country="USA",
)
UCR_STUDENT_REC_CENTER = SportsballGeocodeTuple(
    city="Riverside",
    state="CA",
    postal="",
    lat=33.9789,
    lng=-117.32813,
    housenumber="",
    country="USA",
)
DEGOL_ARENA = SportsballGeocodeTuple(
    city="Loretto",
    state="PA",
    postal="15940",
    lat=40.504612,
    lng=-78.640901,
    housenumber="140",
    country="USA",
)
RETRIEVER_ACTIVITIES_CENTER = SportsballGeocodeTuple(
    city="Baltimore",
    state="MD",
    postal="21250",
    lat=39.2528994,
    lng=-76.712267,
    housenumber="1000",
    country="USA",
)
AL_LAWSON_CENTER = SportsballGeocodeTuple(
    city="Tallahassee",
    state="FL",
    postal="32310",
    lat=30.424318,
    lng=-84.290473,
    housenumber="1800",
    country="USA",
)
BEASLEY_COLISEUM = SportsballGeocodeTuple(
    city="Pullman",
    state="WA",
    postal="",
    lat=46.735,
    lng=-117.1575,
    housenumber="925",
    country="USA",
)
ALUMNI_HALL = SportsballGeocodeTuple(
    city="Providence",
    state="RI",
    postal="02918",
    lat=41.84575,
    lng=-71.437029,
    housenumber="",
    country="USA",
)
COLISEO_JUAN_AUBIN_CRUZ_ABREU = SportsballGeocodeTuple(
    city="Manati",
    state="PR",
    postal="00674",
    lat=18.4244569,
    lng=-66.4696945,
    housenumber="670",
    country="USA",
)
COLISEO_RUBEN_RODRIGUEZ = SportsballGeocodeTuple(
    city="Bayamon",
    state="PR",
    postal="",
    lat=18.394958,
    lng=-66.150833,
    housenumber="",
    country="USA",
)
BEARD_EAVES_MEMORIAL_COLISEUM = SportsballGeocodeTuple(
    city="Auburn",
    state="AL",
    postal="",
    lat=32.600278,
    lng=-85.492222,
    housenumber="101",
    country="USA",
)
JOSE_MIGUEL_AGRELOT_COLISEUM = SportsballGeocodeTuple(
    city="San Juan",
    state="PR",
    postal="",
    lat=18.427717,
    lng=-66.061392,
    housenumber="500",
    country="USA",
)
OMNI_COLISEUM = SportsballGeocodeTuple(
    city="Atlanta",
    state="GA",
    postal="30303",
    lat=33.7575,
    lng=-84.396667,
    housenumber="100",
    country="USA",
)
SPOKANE = SportsballGeocodeTuple(
    city="Spokane",
    state="WA",
    postal="",
    lat=47.658889,
    lng=-117.425,
    housenumber="",
    country="USA",
)
GREENSBORO = SportsballGeocodeTuple(
    city="Greensboro",
    state="NC",
    postal="",
    lat=36.05,
    lng=-79.49,
    housenumber="",
    country="USA",
)
BUFFALO = SportsballGeocodeTuple(
    city="Buffalo",
    state="NY",
    postal="",
    lat=42.886389,
    lng=-78.878056,
    housenumber="",
    country="USA",
)
LOS_ANGELES = SportsballGeocodeTuple(
    city="Los Angeles",
    state="CA",
    postal="",
    lat=34.05,
    lng=-118.25,
    housenumber="700",
    country="USA",
)
LONG_BEACH = SportsballGeocodeTuple(
    city="Long Beach",
    state="CA",
    postal="",
    lat=33.768333,
    lng=-118.195556,
    housenumber="",
    country="USA",
)
PHILADELPHIA = SportsballGeocodeTuple(
    city="Philadelphia",
    state="PA",
    postal="",
    lat=39.952778,
    lng=-75.163611,
    housenumber="",
    country="USA",
)
AKRON = SportsballGeocodeTuple(
    city="Akron",
    state="OH",
    postal="",
    lat=41.080556,
    lng=-81.522222,
    housenumber="",
    country="USA",
)
HEMPSTEAD = SportsballGeocodeTuple(
    city="Hempstead",
    state="NY",
    postal="",
    lat=40.704722,
    lng=-73.617222,
    housenumber="",
    country="USA",
)
RICHMOND = SportsballGeocodeTuple(
    city="Richmond",
    state="VA",
    postal="",
    lat=37.540833,
    lng=-77.436667,
    housenumber="",
    country="USA",
)
INDIANAPOLIS = SportsballGeocodeTuple(
    city="Indianapolis",
    state="IN",
    postal="",
    lat=39.768611,
    lng=-86.158056,
    housenumber="",
    country="USA",
)
DAYTON = SportsballGeocodeTuple(
    city="Dayton",
    state="OH",
    postal="",
    lat=39.759444,
    lng=-84.191667,
    housenumber="",
    country="USA",
)
NATCHITOCHES = SportsballGeocodeTuple(
    city="Natchitoches",
    state="LA",
    postal="",
    lat=31.693056,
    lng=-93.095,
    housenumber="",
    country="USA",
)
TAMPA = SportsballGeocodeTuple(
    city="Tampa",
    state="FL",
    postal="",
    lat=27.9475,
    lng=-82.458611,
    housenumber="",
    country="USA",
)
LITTLE_ROCK = SportsballGeocodeTuple(
    city="Little Rock",
    state="AR",
    postal="",
    lat=34.744444,
    lng=-92.288056,
    housenumber="",
    country="USA",
)
PENSACOLA = SportsballGeocodeTuple(
    city="Pensacola",
    state="FL",
    postal="",
    lat=30.421308,
    lng=-87.216914,
    housenumber="",
    country="USA",
)
JACKSON = SportsballGeocodeTuple(
    city="Jackson",
    state="MS",
    postal="",
    lat=29.762778,
    lng=-95.383056,
    housenumber="",
    country="USA",
)
RALEIGH = SportsballGeocodeTuple(
    city="Raleigh",
    state="NC",
    postal="",
    lat=35.854167,
    lng=-78.761944,
    housenumber="",
    country="USA",
)
JAMAICA = SportsballGeocodeTuple(
    city="Jamaica",
    state="NY",
    postal="",
    lat=40.7,
    lng=-73.8,
    housenumber="",
    country="USA",
)
CORAL_GABLES = SportsballGeocodeTuple(
    city="Coral Gables",
    state="FL",
    postal="",
    lat=25.716667,
    lng=-80.272222,
    housenumber="",
    country="USA",
)
DAYTONA_BEACH = SportsballGeocodeTuple(
    city="Daytona Beach",
    state="FL",
    postal="",
    lat=29.210833,
    lng=-81.022778,
    housenumber="",
    country="USA",
)
ANCHORAGE = SportsballGeocodeTuple(
    city="Anchorage",
    state="AL",
    postal="",
    lat=61.216667,
    lng=-149.893611,
    housenumber="",
    country="USA",
)
BERKELEY = SportsballGeocodeTuple(
    city="Berkeley",
    state="CA",
    postal="",
    lat=37.871667,
    lng=-122.272778,
    housenumber="",
    country="USA",
)
SHREVEPORT = SportsballGeocodeTuple(
    city="Shreveport",
    state="LA",
    postal="",
    lat=32.463889,
    lng=-93.794444,
    housenumber="",
    country="USA",
)
SEATTLE = SportsballGeocodeTuple(
    city="Seattle",
    state="WA",
    postal="",
    lat=47.603889,
    lng=-122.33,
    housenumber="",
    country="USA",
)
MILWAUKEE = SportsballGeocodeTuple(
    city="Milwaukee",
    state="WI",
    postal="",
    lat=43.05,
    lng=-87.95,
    housenumber="",
    country="USA",
)
SAN_FRANCISCO = SportsballGeocodeTuple(
    city="San Francisco",
    state="CA",
    postal="",
    lat=37.783333,
    lng=-122.416667,
    housenumber="",
    country="USA",
)
MEMPHIS = SportsballGeocodeTuple(
    city="Memphis",
    state="TN",
    postal="",
    lat=35.1175,
    lng=-89.971111,
    housenumber="",
    country="USA",
)
DETROIT = SportsballGeocodeTuple(
    city="Detroit",
    state="MI",
    postal="",
    lat=42.333333,
    lng=-83.05,
    housenumber="",
    country="USA",
)
EUGENE = SportsballGeocodeTuple(
    city="Eugene",
    state="OR",
    postal="",
    lat=44.056389,
    lng=-123.1175,
    housenumber="",
    country="USA",
)
SALT_LAKE_CITY = SportsballGeocodeTuple(
    city="Salt Lake City",
    state="UT",
    postal="",
    lat=40.760833,
    lng=-111.891111,
    housenumber="",
    country="USA",
)
COLUMBUS = SportsballGeocodeTuple(
    city="Columbus",
    state="OH",
    postal="",
    lat=39.962222,
    lng=-83.000556,
    housenumber="",
    country="USA",
)
GREENVILLE = SportsballGeocodeTuple(
    city="Greenville",
    state="SC",
    postal="",
    lat=34.844444,
    lng=-82.385556,
    housenumber="",
    country="USA",
)
SAVANNAH = SportsballGeocodeTuple(
    city="Savannah",
    state="GA",
    postal="",
    lat=32.081111,
    lng=-81.091111,
    housenumber="",
    country="USA",
)
ATLANTA = SportsballGeocodeTuple(
    city="Atlanta",
    state="GA",
    postal="",
    lat=33.748889,
    lng=-84.39,
    housenumber="",
    country="USA",
)
BATON_ROUGE = SportsballGeocodeTuple(
    city="Baton Rouge",
    state="LA",
    postal="",
    lat=30.4475,
    lng=-91.178611,
    housenumber="",
    country="USA",
)
RIVERSIDE = SportsballGeocodeTuple(
    city="Riverside",
    state="CA",
    postal="",
    lat=33.948056,
    lng=-117.396111,
    housenumber="",
    country="USA",
)
LOUISVILLE = SportsballGeocodeTuple(
    city="Louisville",
    state="KT",
    postal="",
    lat=38.256111,
    lng=-85.751389,
    housenumber="",
    country="USA",
)
OXFORD = SportsballGeocodeTuple(
    city="Oxford",
    state="OH",
    postal="",
    lat=39.5075,
    lng=-84.746667,
    housenumber="",
    country="USA",
)
PORTLAND = SportsballGeocodeTuple(
    city="Portland",
    state="OR",
    postal="",
    lat=45.52,
    lng=-122.681944,
    housenumber="",
    country="USA",
)
BALTIMORE = SportsballGeocodeTuple(
    city="Baltimore",
    state="MD",
    postal="",
    lat=39.289444,
    lng=-76.615278,
    housenumber="",
    country="USA",
)
SAN_DIEGO = SportsballGeocodeTuple(
    city="San Diego",
    state="CA",
    postal="",
    lat=32.715,
    lng=-117.1625,
    housenumber="",
    country="USA",
)
BRONX = SportsballGeocodeTuple(
    city="Bronx",
    state="NY",
    postal="",
    lat=40.837222,
    lng=-73.886111,
    housenumber="",
    country="USA",
)
YOUNGSTOWN = SportsballGeocodeTuple(
    city="Youngstown",
    state="OH",
    postal="",
    lat=41.1,
    lng=-80.65,
    housenumber="",
    country="USA",
)
ST_PETERSBURG = SportsballGeocodeTuple(
    city="St. Petersburg",
    state="FL",
    postal="",
    lat=27.773056,
    lng=-82.64,
    housenumber="",
    country="USA",
)
AMES = SportsballGeocodeTuple(
    city="Ames",
    state="IO",
    postal="",
    lat=42.034722,
    lng=-93.62,
    housenumber="",
    country="USA",
)
HUNTINGTON = SportsballGeocodeTuple(
    city="Huntington",
    state="WV",
    postal="",
    lat=38.41925,
    lng=-82.445153,
    housenumber="",
    country="USA",
)
MINNEAPOLIS = SportsballGeocodeTuple(
    city="Minneapolis",
    state="MN",
    postal="",
    lat=44.981944,
    lng=-93.269167,
    housenumber="",
    country="USA",
)
PEORIA = SportsballGeocodeTuple(
    city="Peoria",
    state="IL",
    postal="",
    lat=40.692778,
    lng=-89.590556,
    housenumber="",
    country="USA",
)
FORT_WAYNE = SportsballGeocodeTuple(
    city="Fort Wayne",
    state="IN",
    postal="",
    lat=41.088889,
    lng=-85.161389,
    housenumber="",
    country="USA",
)
MONROE = SportsballGeocodeTuple(
    city="Monroe",
    state="LA",
    postal="",
    lat=32.509444,
    lng=-92.118333,
    housenumber="",
    country="USA",
)
YOKOHAMA_ARENA = SportsballGeocodeTuple(
    city="Kanagawa",
    state="",
    postal="",
    lat=35.512389,
    lng=139.620056,
    housenumber="",
    country="Japan",
)
MADISON = SportsballGeocodeTuple(
    city="Madison",
    state="WI",
    postal="",
    lat=43.074722,
    lng=-89.384167,
    housenumber="",
    country="USA",
)
SAN_JOSE = SportsballGeocodeTuple(
    city="San Jose",
    state="CA",
    postal="",
    lat=37.336111,
    lng=-121.890556,
    housenumber="",
    country="USA",
)
MIAMI_ARENA = SportsballGeocodeTuple(
    city="Miami",
    state="FL",
    postal="",
    lat=25.781111,
    lng=-80.194722,
    housenumber="721",
    country="USA",
)
BIRMINGHAM_JEFFERSON_CIVIC_CENTER = SportsballGeocodeTuple(
    city="Birmingham",
    state="AL",
    postal="35203",
    lat=33.524,
    lng=-86.812,
    housenumber="2100",
    country="USA",
)
FRESNO = SportsballGeocodeTuple(
    city="Fresno",
    state="CA",
    postal="",
    lat=36.75,
    lng=-119.766667,
    housenumber="",
    country="USA",
)
RENO = SportsballGeocodeTuple(
    city="Reno",
    state="NV",
    postal="",
    lat=39.527222,
    lng=-119.821944,
    housenumber="",
    country="USA",
)
TACOMA_DOME = SportsballGeocodeTuple(
    city="Tacoma",
    state="WA",
    postal="98421",
    lat=47.236667,
    lng=-122.426667,
    housenumber="2727",
    country="USA",
)
CHATTANOOGA = SportsballGeocodeTuple(
    city="Chattanooga",
    state="TN",
    postal="",
    lat=35.045556,
    lng=-85.267222,
    housenumber="",
    country="USA",
)
CANTON = SportsballGeocodeTuple(
    city="Canton",
    state="OH",
    postal="",
    lat=40.807778,
    lng=-81.395556,
    housenumber="",
    country="USA",
)
KNOXVILLE = SportsballGeocodeTuple(
    city="Knoxville",
    state="TN",
    postal="",
    lat=35.9617,
    lng=-83.9232,
    housenumber="",
    country="USA",
)
ELON = SportsballGeocodeTuple(
    city="Elon",
    state="NC",
    postal="",
    lat=36.126667,
    lng=-79.495556,
    housenumber="",
    country="USA",
)
NACOGDOCHES = SportsballGeocodeTuple(
    city="Nacogdoches",
    state="TX",
    postal="",
    lat=31.63,
    lng=-94.628611,
    housenumber="",
    country="USA",
)
SOUTHAVEN = SportsballGeocodeTuple(
    city="Southaven",
    state="MS",
    postal="",
    lat=34.968889,
    lng=-90.011111,
    housenumber="",
    country="USA",
)
CHARLOTTE = SportsballGeocodeTuple(
    city="Charlotte",
    state="NC",
    postal="",
    lat=35.227222,
    lng=-80.843056,
    housenumber="",
    country="USA",
)
DULUTH = SportsballGeocodeTuple(
    city="Duluth",
    state="GA",
    postal="",
    lat=34.005278,
    lng=-84.149167,
    housenumber="",
    country="USA",
)
PITTSBURGH = SportsballGeocodeTuple(
    city="Pittsburgh",
    state="PA",
    postal="",
    lat=40.439722,
    lng=-79.976389,
    housenumber="",
    country="USA",
)
SPRINGFIELD = SportsballGeocodeTuple(
    city="Springfield",
    state="IL",
    postal="",
    lat=39.7975,
    lng=-89.645,
    housenumber="",
    country="USA",
)
LAS_VEGAS = SportsballGeocodeTuple(
    city="Las Vegas",
    state="NV",
    postal="",
    lat=36.167222,
    lng=-115.148611,
    housenumber="",
    country="USA",
)
PASADENA = SportsballGeocodeTuple(
    city="Pasadena",
    state="CA",
    postal="",
    lat=34.1475,
    lng=-118.143889,
    housenumber="",
    country="USA",
)
ROCK_HILL = SportsballGeocodeTuple(
    city="Rock Hill",
    state="SC",
    postal="",
    lat=34.946667,
    lng=-81.9275,
    housenumber="",
    country="USA",
)
SIOUX_FALLS = SportsballGeocodeTuple(
    city="Sioux Falls",
    state="SD",
    postal="",
    lat=43.536389,
    lng=-96.731667,
    housenumber="",
    country="USA",
)
STOCKTON = SportsballGeocodeTuple(
    city="Stockton",
    state="CA",
    postal="",
    lat=37.975556,
    lng=-121.300833,
    housenumber="",
    country="USA",
)
BOSTON = SportsballGeocodeTuple(
    city="Boston",
    state="MA",
    postal="",
    lat=42.360278,
    lng=-71.057778,
    housenumber="",
    country="USA",
)
ST_GEORGE = SportsballGeocodeTuple(
    city="St. George",
    state="UT",
    postal="",
    lat=37.075,
    lng=-113.576667,
    housenumber="",
    country="USA",
)
FREEDOM_HALL = SportsballGeocodeTuple(
    city="Louisville",
    state="KY",
    postal="",
    lat=38.200294,
    lng=-85.741886,
    housenumber="937",
    country="USA",
)
ROBERTS_STADIUM = SportsballGeocodeTuple(
    city="Evansville",
    state="IN",
    postal="47711",
    lat=37.97903,
    lng=-87.515926,
    housenumber="2600",
    country="USA",
)
LONG_BEACH_ARENA = SportsballGeocodeTuple(
    city="Long Beach",
    state="CA",
    postal="",
    lat=33.763889,
    lng=-118.188333,
    housenumber="",
    country="USA",
)
MID_SOUTH_COLISEUM = SportsballGeocodeTuple(
    city="Memphis",
    state="TN",
    postal="38104",
    lat=35.118395,
    lng=-89.980366,
    housenumber="996",
    country="USA",
)
CHARLESTON_CIVIC_CENTER = SportsballGeocodeTuple(
    city="Charleston",
    state="WV",
    postal="25301",
    lat=38.35519,
    lng=-81.64152,
    housenumber="200",
    country="USA",
)
SELLAND_ARENA = SportsballGeocodeTuple(
    city="Fresno",
    state="CA",
    postal="",
    lat=36.733093,
    lng=-119.78271,
    housenumber="700",
    country="USA",
)
MAPLE_LEAF_GARDENS = SportsballGeocodeTuple(
    city="Toronto",
    state="ON",
    postal="",
    lat=43.662222,
    lng=-79.380278,
    housenumber="60",
    country="CA",
)
AMICA_MUTUAL_PAVILION = SportsballGeocodeTuple(
    city="Providence",
    state="RI",
    postal="",
    lat=41.823611,
    lng=-71.418333,
    housenumber="1",
    country="USA",
)
MISSISSIPPI_COAST_COLISEUM = SportsballGeocodeTuple(
    city="Biloxi",
    state="MS",
    postal="39531",
    lat=30.3935,
    lng=-88.9746,
    housenumber="2350",
    country="USA",
)
UNIVERSITY_OF_ARIZONA = SportsballGeocodeTuple(
    city="Tucson",
    state="AZ",
    postal="",
    lat=32.2319,
    lng=-110.9527,
    housenumber="",
    country="USA",
)
DETROIT_OLYMPIA = SportsballGeocodeTuple(
    city="Detroit",
    state="MI",
    postal="",
    lat=42.354444,
    lng=-83.100556,
    housenumber="5920",
    country="USA",
)
LAKEFRONT_ARENA = SportsballGeocodeTuple(
    city="New Orleans",
    state="LA",
    postal="",
    lat=30.03,
    lng=-90.050556,
    housenumber="6801",
    country="USA",
)
WICHITA = SportsballGeocodeTuple(
    city="Wichita",
    state="KS",
    postal="",
    lat=29.762778,
    lng=-95.383056,
    housenumber="",
    country="USA",
)
HAVRE_DE_GRACE = SportsballGeocodeTuple(
    city="Havre De Grace",
    state="MD",
    postal="",
    lat=39.548333,
    lng=-76.0975,
    housenumber="",
    country="USA",
)
MOSCOW = SportsballGeocodeTuple(
    city="Moscow",
    state="",
    postal="",
    lat=55.755833,
    lng=37.617778,
    housenumber="",
    country="Russia",
)
LUBBOCK = SportsballGeocodeTuple(
    city="Lubbock",
    state="TX",
    postal="",
    lat=33.585,
    lng=-101.845,
    housenumber="",
    country="USA",
)
SCOTTSDALE = SportsballGeocodeTuple(
    city="Scottsdale",
    state="AZ",
    postal="",
    lat=33.493056,
    lng=-111.926111,
    housenumber="",
    country="USA",
)
ARLINGTON = SportsballGeocodeTuple(
    city="Arlington",
    state="TX",
    postal="",
    lat=32.705,
    lng=-97.122778,
    housenumber="",
    country="USA",
)
DUKE_UNIVERSITY = SportsballGeocodeTuple(
    city="Durham",
    state="NC",
    postal="",
    lat=36.001389,
    lng=-78.938333,
    housenumber="",
    country="USA",
)
COMPAQ_CENTER = SportsballGeocodeTuple(
    city="Houston",
    state="TX",
    postal="",
    lat=29.730278,
    lng=-95.435,
    housenumber="3700",
    country="USA",
)
NEWARK = SportsballGeocodeTuple(
    city="Newark",
    state="NJ",
    postal="",
    lat=40.735556,
    lng=-74.172222,
    housenumber="700",
    country="USA",
)
STARKVILLE = SportsballGeocodeTuple(
    city="Starkville",
    state="MS",
    postal="",
    lat=33.4625,
    lng=-88.82,
    housenumber="",
    country="USA",
)
ROCHESTER = SportsballGeocodeTuple(
    city="Rochester",
    state="NY",
    postal="",
    lat=43.165556,
    lng=-77.616111,
    housenumber="",
    country="USA",
)
BOSTON_COLLEGE = SportsballGeocodeTuple(
    city="Chestnut Hill",
    state="MA",
    postal="",
    lat=42.335,
    lng=-71.170278,
    housenumber="",
    country="USA",
)
UNIVERSITY_OF_KENTUCKY = SportsballGeocodeTuple(
    city="Lexington",
    state="KY",
    postal="",
    lat=38.0325,
    lng=-84.5025,
    housenumber="",
    country="USA",
)
CALIFORNIA_STATE_UNIVERSITY_FRESNO = SportsballGeocodeTuple(
    city="Fresno",
    state="CA",
    postal="",
    lat=36.813333,
    lng=-119.75,
    housenumber="",
    country="USA",
)
GREEN_BAY = SportsballGeocodeTuple(
    city="Green Bay",
    state="WI",
    postal="",
    lat=44.513333,
    lng=-88.015833,
    housenumber="",
    country="USA",
)
VILLANOVA_COLLEGE = SportsballGeocodeTuple(
    city="Villanova",
    state="PA",
    postal="",
    lat=40.03771,
    lng=-75.33755,
    housenumber="",
    country="USA",
)
TEMPE = SportsballGeocodeTuple(
    city="Tempe",
    state="AZ",
    postal="",
    lat=33.412778,
    lng=-111.943056,
    housenumber="",
    country="USA",
)
WAKE_FOREST_COLLEGE = SportsballGeocodeTuple(
    city="Winston-Salem",
    state="NC",
    postal="",
    lat=36.134,
    lng=-80.276,
    housenumber="",
    country="USA",
)
DENVER = SportsballGeocodeTuple(
    city="Denver",
    state="CO",
    postal="",
    lat=39.7392,
    lng=-104.9849,
    housenumber="",
    country="USA",
)
WACO = SportsballGeocodeTuple(
    city="Waco",
    state="TX",
    postal="",
    lat=31.551389,
    lng=-97.155833,
    housenumber="",
    country="USA",
)
NORMAN = SportsballGeocodeTuple(
    city="Norman",
    state="OK",
    postal="",
    lat=35.220833,
    lng=-97.443611,
    housenumber="",
    country="USA",
)
NOTRE_DAME_COLLEGE = SportsballGeocodeTuple(
    city="South Euclid",
    state="OH",
    postal="",
    lat=41.5076,
    lng=-81.5155,
    housenumber="4545",
    country="USA",
)
TOLEDO = SportsballGeocodeTuple(
    city="Toledo",
    state="OH",
    postal="",
    lat=41.652778,
    lng=-83.537778,
    housenumber="",
    country="USA",
)
WEBER_STATE_COLLEGE = SportsballGeocodeTuple(
    city="Ogden",
    state="UT",
    postal="",
    lat=41.193,
    lng=-111.944,
    housenumber="",
    country="USA",
)
PRINCETON = SportsballGeocodeTuple(
    city="Princeton",
    state="NJ",
    postal="",
    lat=40.358244,
    lng=-74.666728,
    housenumber="",
    country="USA",
)
MANHATTAN = SportsballGeocodeTuple(
    city="Manhattan",
    state="KS",
    postal="",
    lat=39.188611,
    lng=-96.604722,
    housenumber="",
    country="USA",
)
GAINESVILLE = SportsballGeocodeTuple(
    city="Gainesville",
    state="FL",
    postal="",
    lat=29.651997,
    lng=-82.324992,
    housenumber="",
    country="USA",
)
STATEN_ISLAND = SportsballGeocodeTuple(
    city="Staten Island",
    state="NY",
    postal="",
    lat=40.583333,
    lng=-74.15,
    housenumber="",
    country="USA",
)
MONTGOMERY = SportsballGeocodeTuple(
    city="Montgomery",
    state="AL",
    postal="",
    lat=32.3675,
    lng=-86.3,
    housenumber="",
    country="USA",
)
GONZAGA = SportsballGeocodeTuple(
    city="Spokane",
    state="WA",
    postal="",
    lat=47.6675,
    lng=-117.4025,
    housenumber="",
    country="USA",
)
CEDAR_FALLS = SportsballGeocodeTuple(
    city="Cedar Falls",
    state="IA",
    postal="",
    lat=42.52352,
    lng=-92.446402,
    housenumber="",
    country="USA",
)
VIRGINIA_BEACH = SportsballGeocodeTuple(
    city="Virginia Beach",
    state="VA",
    postal="",
    lat=36.85,
    lng=-75.977778,
    housenumber="",
    country="USA",
)
CORPUS_CHRISTI = SportsballGeocodeTuple(
    city="Corpus Christi",
    state="TX",
    postal="",
    lat=27.742778,
    lng=-97.401944,
    housenumber="",
    country="USA",
)
BIRMINGHAM = SportsballGeocodeTuple(
    city="Birmingham",
    state="AL",
    postal="",
    lat=33.5175,
    lng=-86.809444,
    housenumber="",
    country="USA",
)
TSONGAS_CENTER = SportsballGeocodeTuple(
    city="Lowell",
    state="MA",
    postal="",
    lat=42.650228,
    lng=-71.313248,
    housenumber="300",
    country="USA",
)
LAWRENCE_JOEL_VETERANS_MEMORIAL_COLISEUM = SportsballGeocodeTuple(
    city="Winston-Salem",
    state="NC",
    postal="27105",
    lat=36.127866,
    lng=-80.257628,
    housenumber="2825",
    country="USA",
)
KFC_YUM_CENTER = SportsballGeocodeTuple(
    city="Louisville",
    state="KY",
    postal="",
    lat=38.2575,
    lng=-85.753889,
    housenumber="1",
    country="USA",
)
PETERSEN_EVENTS_CENTER = SportsballGeocodeTuple(
    city="Pittsburgh",
    state="PA",
    postal="",
    lat=40.443777,
    lng=-79.962274,
    housenumber="3719",
    country="USA",
)
MULLINS_CENTER = SportsballGeocodeTuple(
    city="Amherst",
    state="MA",
    postal="01003",
    lat=42.389381,
    lng=-72.533439,
    housenumber="200",
    country="USA",
)
PNC_ARENA = SportsballGeocodeTuple(
    city="Raleigh",
    state="NC",
    postal="",
    lat=35.803333,
    lng=-78.721944,
    housenumber="1400",
    country="USA",
)
AGGANIS_ARENA = SportsballGeocodeTuple(
    city="Boston",
    state="MA",
    postal="02215",
    lat=42.352231,
    lng=-71.117792,
    housenumber="925",
    country="USA",
)
CAJUNDOME = SportsballGeocodeTuple(
    city="Lafayette",
    state="LA",
    postal="70506",
    lat=30.218444,
    lng=-92.039056,
    housenumber="444",
    country="USA",
)
DURHAM = SportsballGeocodeTuple(
    city="Durham",
    state="NC",
    postal="",
    lat=35.978611,
    lng=-78.9,
    housenumber="",
    country="USA",
)
JON_M_HUNTSMAN_CENTER = SportsballGeocodeTuple(
    city="Salt Lake City",
    state="UT",
    postal="",
    lat=40.762,
    lng=-111.839,
    housenumber="1825",
    country="USA",
)
FLA_LIVE_ARENA = SportsballGeocodeTuple(
    city="Sunrise",
    state="FL",
    postal="",
    lat=26.158333,
    lng=-80.325556,
    housenumber="1",
    country="USA",
)
FORD_CENTER = SportsballGeocodeTuple(
    city="Evansville",
    state="IN",
    postal="",
    lat=37.972189,
    lng=-87.567844,
    housenumber="1",
    country="USA",
)
BENDER_ARENA = SportsballGeocodeTuple(
    city="Washington",
    state="DC",
    postal="",
    lat=38.937778,
    lng=-77.09,
    housenumber="4400",
    country="USA",
)
WOLSTEIN_CENTER = SportsballGeocodeTuple(
    city="Cleveland",
    state="OH",
    postal="",
    lat=41.499167,
    lng=-81.676944,
    housenumber="2000",
    country="USA",
)
CHAIFETZ_ARENA = SportsballGeocodeTuple(
    city="St. Louis",
    state="MO",
    postal="63103",
    lat=38.63246,
    lng=-90.22797,
    housenumber="1",
    country="USA",
)
MAGNESS_ARENA = SportsballGeocodeTuple(
    city="Denver",
    state="CO",
    postal="",
    lat=39.682106,
    lng=-104.961592,
    housenumber="2240",
    country="USA",
)
DON_HASKINS_CENTER = SportsballGeocodeTuple(
    city="El Paso",
    state="TX",
    postal="79968",
    lat=31.777608,
    lng=-106.505718,
    housenumber="151",
    country="USA",
)
MATTHEWS_ARENA = SportsballGeocodeTuple(
    city="Boston",
    state="MA",
    postal="",
    lat=42.341111,
    lng=-71.084444,
    housenumber="238",
    country="USA",
)
BAXTER_ARENA = SportsballGeocodeTuple(
    city="Omaha",
    state="NE",
    postal="",
    lat=41.236,
    lng=-96.013,
    housenumber="2425",
    country="USA",
)
_CACHED_GEOCODES: dict[str, Any] = {
    "Dee Glen Smith Spectrum, Logan, Utah": SMITH_SPECTRUM,
    "Holmes Convocation Center, Boone, North Carolina": HOLMES_CENTER,
    "Convocation Center, Ypsilanti, Michigan": SportsballGeocodeTuple(
        city="Ypsilanti",
        state="MI",
        postal="48197",
        lat=42.254444,
        lng=-83.647222,
        housenumber="799",
        country="USA",
    ),
    "Kirby Sports Center, Easton, Pennsylvania": SportsballGeocodeTuple(
        city="Easton",
        state="PA",
        postal="18042",
        lat=40.7019,
        lng=-75.2107,
        housenumber="700",
        country="USA",
    ),
    "Memorial Gymnasium, Orono, Maine": SportsballGeocodeTuple(
        city="Orono",
        state="ME",
        postal="",
        lat=44.9037,
        lng=-68.67,
        housenumber="18",
        country="USA",
    ),
    "Henderson Center, Huntington, West Virginia": HENDERSON_CENTER,
    "Costello Athletic Center, Lowell, Massachusetts": SportsballGeocodeTuple(
        city="Lowell",
        state="MA",
        postal="",
        lat=42.6555,
        lng=-71.3242,
        housenumber="",
        country="USA",
    ),
    "Multipurpose Activity Center, West Long Branch, New Jersey": SportsballGeocodeTuple(
        city="West Long Branch",
        state="NJ",
        postal="07764",
        lat=40.279475,
        lng=-74.007583,
        housenumber="400",
        country="USA",
    ),
    "Lundholm Gymnasium, Durham, New Hampshire": SportsballGeocodeTuple(
        city="Durham",
        state="NH",
        postal="03824",
        lat=43.138611,
        lng=-70.938056,
        housenumber="145",
        country="USA",
    ),
    "Petersen Events Center, Pittsburgh, Pennsylvania": PETERSEN_EVENTS_CENTER,
    "Dunkin' Donuts Center, Providence, Rhode Island": DUNKIN_DONUTS_CENTER,
    "G.B. Hodge Center, Spartanburg, South Carolina": SportsballGeocodeTuple(
        city="Spartanburg",
        state="SC",
        postal="",
        lat=34.996696,
        lng=-81.968774,
        housenumber="",
        country="USA",
    ),
    "Daytona Stadium - Daytona Beach - FL - 32124": SportsballGeocodeTuple(
        city="Daytona Beach",
        state="FL",
        postal="32124",
        lat=29.173056,
        lng=-81.1175,
        housenumber="3777",
        country="USA",
    ),
    "Redbird Arena, Normal, Illinois": SportsballGeocodeTuple(
        city="Normal",
        state="IL",
        postal="61761",
        lat=40.510606,
        lng=-88.999011,
        housenumber="232",
        country="USA",
    ),
    "Carver-Hawkeye Arena, Iowa City, Iowa": SportsballGeocodeTuple(
        city="Iowa City",
        state="IO",
        postal="52242",
        lat=41.663611,
        lng=-91.554444,
        housenumber="1",
        country="USA",
    ),
    "Baxter Arena, Omaha, Nebraska": BAXTER_ARENA,
    "Pete Hanna Center, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.4638,
        lng=-86.7973,
        housenumber="",
        country="USA",
    ),
    "The SIU Arena, Carbondale, Illinois": SIU_ARENA,
    "Reed Green Coliseum, Hattiesburg, Mississippi": SportsballGeocodeTuple(
        city="Hattiesburg",
        state="MS",
        postal="",
        lat=31.330833,
        lng=-89.337778,
        housenumber="112",
        country="USA",
    ),
    "Convocation Center, San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="78249",
        lat=29.582222,
        lng=-98.621389,
        housenumber="1",
        country="USA",
    ),
    "E.A. Diddle Arena, Bowling Green, Kentucky": EA_DIDDLE_ARENA,
    "Don Haskins Center, El Paso, Texas": DON_HASKINS_CENTER,
    "Jon M. Huntsman Center, Salt Lake City, Utah": JON_M_HUNTSMAN_CENTER,
    "The Pavilion, Davis, California": SportsballGeocodeTuple(
        city="Davis",
        state="CA",
        postal="95616",
        lat=38.541667,
        lng=-121.759444,
        housenumber="1",
        country="USA",
    ),
    "A.G. Spanos Center, Stockton, California": AG_SPANOS_CENTER,
    "Leavey Center, Santa Clara, California": SportsballGeocodeTuple(
        city="Santa Clara",
        state="CA",
        postal="95053",
        lat=37.349111,
        lng=-121.935303,
        housenumber="500",
        country="USA",
    ),
    "Mack Sports Complex, Hempstead, New York": SportsballGeocodeTuple(
        city="Hempstead",
        state="NY",
        postal="11549",
        lat=40.719681,
        lng=-73.596865,
        housenumber="245",
        country="USA",
    ),
    "Hulman Center, Terre Haute, Indiana": HULMAN_CENTER,
    "Worthen Arena, Muncie, Indiana": SportsballGeocodeTuple(
        city="Muncie",
        state="IN",
        postal="",
        lat=40.206944,
        lng=-85.406111,
        housenumber="1699",
        country="USA",
    ),
    "Chace Athletic Center , Smithfield, Rhode Island": SportsballGeocodeTuple(
        city="Smithfield",
        state="RI",
        postal="",
        lat=41.921008,
        lng=-71.539639,
        housenumber="",
        country="USA",
    ),
    "Cotterell Court, Hamilton, New York": SportsballGeocodeTuple(
        city="Hamilton",
        state="NY",
        postal="13346",
        lat=42.814957,
        lng=-75.542754,
        housenumber="13",
        country="USA",
    ),
    "Belk Arena, Davidson, North Carolina": SportsballGeocodeTuple(
        city="Davidson",
        state="NC",
        postal="",
        lat=35.499278,
        lng=-80.840521,
        housenumber="200",
        country="USA",
    ),
    "GSU Convocation Center, Atlanta, Georgia": GSU_CONVOCATION_CENTER,
    "Lavietes Pavilion, Boston, Massachusetts": SportsballGeocodeTuple(
        city="Boston",
        state="MA",
        postal="02163",
        lat=42.368218,
        lng=-71.125291,
        housenumber="",
        country="USA",
    ),
    "Stabler Arena, Bethlehem, Pennsylvania": SportsballGeocodeTuple(
        city="Bethlehem",
        state="PA",
        postal="18015",
        lat=40.584444,
        lng=-75.356944,
        housenumber="124",
        country="USA",
    ),
    "Prather Coliseum, Natchitoches, Louisiana": SportsballGeocodeTuple(
        city="Natchitoches",
        state="LA",
        postal="71457",
        lat=31.744028,
        lng=-93.095167,
        housenumber="220",
        country="USA",
    ),
    "Ross E.Templeton Center, Clinton, South Carolina": ROSS_E_TEMPLETON_CENTER,
    "Kaplan Arena at William and Mary Hall, Williamsburg, Virginia": SportsballGeocodeTuple(
        city="Williamsburg",
        state="VA",
        postal="23186",
        lat=37.273472,
        lng=-76.719625,
        housenumber="751",
        country="USA",
    ),
    "John J. Lee Ampitheater, New Haven, Connecticut": SportsballGeocodeTuple(
        city="New Haven",
        state="CT",
        postal="06511",
        lat=41.313611,
        lng=-72.930556,
        housenumber="70",
        country="USA",
    ),
    "Beeghly Center, Youngstown, Ohio": SportsballGeocodeTuple(
        city="Youngstown",
        state="OH",
        postal="44555",
        lat=41.108056,
        lng=-80.648889,
        housenumber="1",
        country="USA",
    ),
    "Clune Arena , Colorado Springs, Colorado": SportsballGeocodeTuple(
        city="Colorado Springs",
        state="CO",
        postal="",
        lat=39.014,
        lng=-104.8833,
        housenumber="2168",
        country="USA",
    ),
    "Millett Hall, Oxford, Ohio": SportsballGeocodeTuple(
        city="Oxford",
        state="OH",
        postal="45056",
        lat=39.517236,
        lng=-84.734544,
        housenumber="500",
        country="USA",
    ),
    "Johnson Coliseum, Huntsville, Texas": SportsballGeocodeTuple(
        city="Huntsville",
        state="TX",
        postal="77340",
        lat=30.712778,
        lng=-95.546111,
        housenumber="1964",
        country="USA",
    ),
    "Bender Arena, Washington, District of Columbia": BENDER_ARENA,
    "Moby Arena, Fort Collins, Colorado": MOBY_ARENA,
    "Freedom Hall Civic Center, Johnson City, Tennessee": SportsballGeocodeTuple(
        city="Johnson City",
        state="TN",
        postal="37604",
        lat=36.324444,
        lng=-82.375,
        housenumber="1320",
        country="USA",
    ),
    "McBrayer Arena, Richmond, Kentucky": SportsballGeocodeTuple(
        city="Richmond",
        state="KY",
        postal="40475",
        lat=37.737222,
        lng=-84.301389,
        housenumber="521",
        country="USA",
    ),
    "Hyland Performance Arena, Saint Charles, Missouri": SportsballGeocodeTuple(
        city="Saint Charles",
        state="MO",
        postal="",
        lat=38.78912,
        lng=-90.50352,
        housenumber="",
        country="USA",
    ),
    "CFSB Center, Murray, Kentucky": CFSB_CENTER,
    "Echols Memorial Hall, Norfolk, Virginia": SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="23504",
        lat=36.847999,
        lng=-76.258157,
        housenumber="700",
        country="USA",
    ),
    "PNC Arena, Raleigh, North Carolina": PNC_ARENA,
    "The Nest, Sacramento, California": THE_NEST,
    "Sam Vadalabene Center , Edwardsville, Illinois": SportsballGeocodeTuple(
        city="Edwardsville",
        state="IL",
        postal="",
        lat=38.795989,
        lng=-89.999883,
        housenumber="35",
        country="USA",
    ),
    "Maples Pavilion, Stanford, California": SportsballGeocodeTuple(
        city="Stanford",
        state="CA",
        postal="",
        lat=37.4296,
        lng=-122.1605,
        housenumber="655",
        country="USA",
    ),
    "Trojan Arena, Troy, Alabama": SportsballGeocodeTuple(
        city="Troy",
        state="AL",
        postal="36082",
        lat=31.802222,
        lng=-85.954722,
        housenumber="5000",
        country="USA",
    ),
    "UCCU Center, Orem, Utah": UCCU_CENTER,
    "Western Hall, Macomb, Illinois": SportsballGeocodeTuple(
        city="Macomb",
        state="IL",
        postal="",
        lat=40.471589,
        lng=-90.685201,
        housenumber="",
        country="USA",
    ),
    "Allen Arena, Nashville, Tennessee": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.103833,
        lng=-86.798836,
        housenumber="1",
        country="USA",
    ),
    "The Legacy Center, Lake Charles, Louisiana": LEGACY_CENTER,
    "Peter W. Stott Center, Portland, Oregon": SportsballGeocodeTuple(
        city="Portland",
        state="OR",
        postal="97201",
        lat=45.510987,
        lng=-122.687471,
        housenumber="930",
        country="USA",
    ),
    "Haas Pavilion, Berkeley, California": SportsballGeocodeTuple(
        city="Berkeley",
        state="CA",
        postal="",
        lat=37.8694,
        lng=-122.262,
        housenumber="14",
        country="USA",
    ),
    "Murphy Athletic Center, Murfreesboro, Tennessee": MURPHY_ATHELTIC_CENTER,
    "Kiefer Lakefront Arena, New Orleans , Louisiana": LAKEFRONT_ARENA,
    "Bank of Kentucky Center, Highland Heights, Kentucky": BANK_OF_KENTUCKY_CENTER,
    "Robins Center, Richmond, Virginia": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="23173",
        lat=37.580701,
        lng=-77.538987,
        housenumber="",
        country="USA",
    ),
    "Allen County War Memorial Coliseum, Fort Wayne, Indiana": ALLEN_COUNTY_WAR_MEMORIAL_COLISEUM,
    "Island Federal Credit Union, Stony Brook, New York": STONY_BROOK_ARENA,
    "Cajundome, Lafayette, Louisiana": CAJUNDOME,
    "Thomas Assembly Center, Ruston, Louisiana": SportsballGeocodeTuple(
        city="Ruston",
        state="LA",
        postal="71272",
        lat=32.5321,
        lng=-92.6584,
        housenumber="1650",
        country="USA",
    ),
    "Worthington Arena, Bozeman, Montana": SportsballGeocodeTuple(
        city="Bozeman",
        state="MT",
        postal="",
        lat=45.6633,
        lng=-111.0506,
        housenumber="1",
        country="USA",
    ),
    "Mabee Center, Tulsa, Oklahoma": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="74171",
        lat=36.04789,
        lng=-95.95573,
        housenumber="7777",
        country="USA",
    ),
    "Centrum, Cedar City, Utah": CENTRUM_ARENA,
    "Schoenecker Arena, St. Paul, Minnesota": SportsballGeocodeTuple(
        city="St. Paul",
        state="MN",
        postal="",
        lat=44.9395,
        lng=-93.1945,
        housenumber="",
        country="USA",
    ),
    "Icardo Center, Bakersfield, California": SportsballGeocodeTuple(
        city="Bakersfield",
        state="CA",
        postal="",
        lat=35.3475,
        lng=-119.102778,
        housenumber="",
        country="USA",
    ),
    "Titan Gym, Fullerton, California": SportsballGeocodeTuple(
        city="Fullerton",
        state="CA",
        postal="92834",
        lat=33.883046,
        lng=-117.88609,
        housenumber="800",
        country="USA",
    ),
    "Burns Arena, St. George, Utah": SportsballGeocodeTuple(
        city="St. George",
        state="UT",
        postal="",
        lat=37.101,
        lng=-113.566,
        housenumber="400",
        country="USA",
    ),
    "Draddy Gymnasium, Riverdale, New York": SportsballGeocodeTuple(
        city="Riverdale",
        state="NY",
        postal="",
        lat=40.89073,
        lng=-73.900158,
        housenumber="",
        country="USA",
    ),
    "William H. Pitt Center, Fairfield, Connecticut": SportsballGeocodeTuple(
        city="Fairfield",
        state="CT",
        postal="06825",
        lat=41.219439,
        lng=-73.244628,
        housenumber="5151",
        country="USA",
    ),
    "Alumni Arena, Buffalo, New York": SportsballGeocodeTuple(
        city="Buffalo",
        state="NY",
        postal="14221",
        lat=43.0,
        lng=-78.781111,
        housenumber="175",
        country="USA",
    ),
    "Merkert Gymnasium, Easton, Massachusetts": SportsballGeocodeTuple(
        city="Easton",
        state="MA",
        postal="",
        lat=42.0576,
        lng=-71.0789,
        housenumber="",
        country="USA",
    ),
    "John F. Savage Hall, Toledo, Ohio": SAVAGE_ARENA,
    "War Memorial at The Sobrato Center, San Francisco, California": WAR_MEMORIAL_GYMNASIUM,
    "The Jungle, Indianapolis, Indiana": THE_JUNGLE,
    "Lantz Arena, Charleston, Illinois": SportsballGeocodeTuple(
        city="Charleston",
        state="IL",
        postal="61920",
        lat=39.480403,
        lng=-88.178844,
        housenumber="250",
        country="USA",
    ),
    "Friel Court at Beasley Coliseum, Pullman, Washington": BEASLEY_COLISEUM,
    "The Matadome, Northridge, California": SportsballGeocodeTuple(
        city="Northridge",
        state="CA",
        postal="91330",
        lat=34.241974,
        lng=-118.526484,
        housenumber="18111",
        country="USA",
    ),
    "UC Riverside Student Recreation Center, Riverside, California": UCR_STUDENT_REC_CENTER,
    "CFE Arena, Orlando, Florida": SportsballGeocodeTuple(
        city="Orlando",
        state="FL",
        postal="",
        lat=28.6068,
        lng=-81.1976,
        housenumber="12777",
        country="USA",
    ),
    "A.J. Palumbo Center, Pittsburgh, Pennsylvania": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="15282",
        lat=40.4374,
        lng=-79.9879,
        housenumber="600",
        country="USA",
    ),
    "Thomas M. Ryan Center, Kingston, Rhode Island": RYAN_CENTER,
    "Ford Center, Evansville, Indiana": FORD_CENTER,
    "Super Pit, Denton, Texas": SportsballGeocodeTuple(
        city="Denton",
        state="TX",
        postal="76201",
        lat=33.208333,
        lng=-97.153889,
        housenumber="801",
        country="USA",
    ),
    "Athletics-Recreation Center, Valparaiso, Indiana": SportsballGeocodeTuple(
        city="Valparaiso",
        state="IN",
        postal="46383",
        lat=41.464198,
        lng=-87.048338,
        housenumber="1009",
        country="USA",
    ),
    "CSU Fieldhouse, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="29406",
        lat=32.980822,
        lng=-80.067125,
        housenumber="9200",
        country="USA",
    ),
    "Hart Recreation Center, Worcester, Massachusetts": HART_RECREATION_CENTER,
    "McAlister Field House, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="29409",
        lat=32.798508,
        lng=-79.962573,
        housenumber="171",
        country="USA",
    ),
    "Paul Porter Arena, Boiling Springs, North Carolina": SportsballGeocodeTuple(
        city="Boiling Springs",
        state="NC",
        postal="",
        lat=35.246538,
        lng=-81.669518,
        housenumber="",
        country="USA",
    ),
    "Mullins Center, Amherst, Massachusetts": MULLINS_CENTER,
    "Richardson Indoor Stadium, Spartanburg, South Carolina": SportsballGeocodeTuple(
        city="Spartanburg",
        state="SC",
        postal="29303",
        lat=34.963427,
        lng=-81.93363,
        housenumber="601",
        country="USA",
    ),
    "Chaifetz Arena, St. Louis, Missouri": CHAIFETZ_ARENA,
    "WVU Coliseum, Morgantown, West Virginia": SportsballGeocodeTuple(
        city="Morgantown",
        state="WV",
        postal="26505",
        lat=39.649167,
        lng=-79.981111,
        housenumber="",
        country="USA",
    ),
    "Bartow Arena, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.502164,
        lng=-86.809244,
        housenumber="617",
        country="USA",
    ),
    "McKeon Pavilion, Moraga, California": SportsballGeocodeTuple(
        city="Moraga",
        state="CA",
        postal="",
        lat=37.841247,
        lng=-122.106409,
        housenumber="1928",
        country="USA",
    ),
    "KFC Yum! Center, Louisville, Kentucky": KFC_YUM_CENTER,
    "DiSanto Field - Cleveland - OH - 44106": SportsballGeocodeTuple(
        city="Cleveland",
        state="OH",
        postal="44106",
        lat=41.513444,
        lng=-81.603639,
        housenumber="1747",
        country="USA",
    ),
    "University Arena, Kalamazoo, Michigan": SportsballGeocodeTuple(
        city="Kalamazoo",
        state="MI",
        postal="",
        lat=42.283372,
        lng=-85.60845,
        housenumber="",
        country="USA",
    ),
    "Gallagher-Iba Arena, Stillwater, Oklahoma": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="74078",
        lat=36.125833,
        lng=-97.065,
        housenumber="1046",
        country="USA",
    ),
    "Arena-Auditorium, Laramie, Wyoming": SportsballGeocodeTuple(
        city="Laramie",
        state="WY",
        postal="82071",
        lat=41.313344,
        lng=-105.569419,
        housenumber="1000",
        country="USA",
    ),
    "DunnâOliver Acadome, Montgomery, Alabama": DUNN_OLIVER_ACADOME,
    "Health & Physical Education Arena, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.43,
        lng=-95.21,
        housenumber="",
        country="USA",
    ),
    "Memorial Hall, Dover, Delaware": SportsballGeocodeTuple(
        city="Dover",
        state="DE",
        postal="",
        lat=39.1876,
        lng=-75.5434,
        housenumber="",
        country="USA",
    ),
    "Franklin Field - Philadelphia - PA - 19104": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="19104",
        lat=39.95,
        lng=-75.19,
        housenumber="",
        country="USA",
    ),
    "Texas A&MâCommerce Field House, Commerce, Texas": TEXAS_AM_COMMERCE_FIELD_HOUSE,
    "William J. Nicks Building, Prairie View, Texas": SportsballGeocodeTuple(
        city="Prairie View",
        state="TX",
        postal="77446",
        lat=30.092278,
        lng=-95.993083,
        housenumber="100",
        country="USA",
    ),
    "Steinberg Wellness Center, Brooklyn, New York": SportsballGeocodeTuple(
        city="Brooklyn",
        state="NY",
        postal="",
        lat=40.69059,
        lng=-73.979176,
        housenumber="",
        country="USA",
    ),
    "The Palestra, Philadelphia, Pennsylvania": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="19104",
        lat=39.951411,
        lng=-75.188606,
        housenumber="235",
        country="USA",
    ),
    "Pizzitola Sports Center, Providence, Rhode Island": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="02906",
        lat=41.831743,
        lng=-71.398043,
        housenumber="",
        country="USA",
    ),
    "Newman Arena, Ithaca, New York": SportsballGeocodeTuple(
        city="Ithaca",
        state="NY",
        postal="14853",
        lat=42.445794,
        lng=-76.476581,
        housenumber="",
        country="USA",
    ),
    "Al Lawson Center, Tallahassee, Florida": AL_LAWSON_CENTER,
    "Hanner Fieldhouse, Statesboro, Georgia": SportsballGeocodeTuple(
        city="Statesboro",
        state="GA",
        postal="30458",
        lat=32.427778,
        lng=-81.779444,
        housenumber="590",
        country="USA",
    ),
    "Carnesecca Arena, Jamaica, New York": SportsballGeocodeTuple(
        city="Jamaica",
        state="NY",
        postal="",
        lat=40.724167,
        lng=-73.794444,
        housenumber="",
        country="USA",
    ),
    "Pan American Center, Las Cruces, New Mexico": SportsballGeocodeTuple(
        city="Las Cruces",
        state="NM",
        postal="88003",
        lat=32.284,
        lng=-106.7422,
        housenumber="1810",
        country="USA",
    ),
    "Jadwin Gymnasium, Princeton, New Jersey": SportsballGeocodeTuple(
        city="Princeton",
        state="NJ",
        postal="08542",
        lat=40.343449,
        lng=-74.648595,
        housenumber="",
        country="USA",
    ),
    "Matthews Arena, Boston, Massachusetts": MATTHEWS_ARENA,
    "Calihan Hall, Detroit, Michigan": SportsballGeocodeTuple(
        city="Detroit",
        state="MI",
        postal="48221",
        lat=42.414167,
        lng=-83.135833,
        housenumber="4001",
        country="USA",
    ),
    "Curry Arena, Charlotte, North Carolina": SportsballGeocodeTuple(
        city="Charlotte",
        state="NC",
        postal="28274",
        lat=35.1884989,
        lng=-80.8351236,
        housenumber="2201",
        country="USA",
    ),
    "Events Center, Binghamton, New York": BINGHAMPTON_UNIVERSITY_EVENTS_CENTER,
    "Jeff Farris Center, Conway, Arkansas": FARRIS_CENTER,
    "TD Arena, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="29401",
        lat=32.785556,
        lng=-79.934444,
        housenumber="301",
        country="USA",
    ),
    "Reese Court, Cheney, Washington": SportsballGeocodeTuple(
        city="Cheney",
        state="WA",
        postal="",
        lat=47.4914,
        lng=-117.5892,
        housenumber="",
        country="USA",
    ),
    "ICCU Arena, Moscow, Idaho": ICCU_ARENA,
    "Flowers Hall, Florence, Alabama": SportsballGeocodeTuple(
        city="Florence",
        state="AL",
        postal="",
        lat=34.808333,
        lng=-87.683889,
        housenumber="615",
        country="USA",
    ),
    "CBU Events Center, Riverside, California": SportsballGeocodeTuple(
        city="Riverside",
        state="CA",
        postal="",
        lat=33.927501,
        lng=-117.423266,
        housenumber="8431",
        country="USA",
    ),
    "Moody Coliseum , Abilene, Texas": SportsballGeocodeTuple(
        city="Abilene",
        state="TX",
        postal="",
        lat=32.470333,
        lng=-99.70925,
        housenumber="",
        country="USA",
    ),
    "Cross Insurance Center, Bangor, Maine": SportsballGeocodeTuple(
        city="Bangor",
        state="ME",
        postal="",
        lat=44.7893,
        lng=-68.7787,
        housenumber="515",
        country="USA",
    ),
    "Klotsche Center, Milwaukee, Wisconsin": SportsballGeocodeTuple(
        city="Milwaukee",
        state="WI",
        postal="53233",
        lat=43.079414,
        lng=-87.879783,
        housenumber="3409",
        country="USA",
    ),
    "Dugan Wellness Center, Corpus Christi, Texas": SportsballGeocodeTuple(
        city="Corpus Christi",
        state="TX",
        postal="78412",
        lat=27.711472,
        lng=-97.324361,
        housenumber="6300",
        country="USA",
    ),
    "Fleming Gymnasium, Greensboro, North Carolina": SportsballGeocodeTuple(
        city="Greensboro",
        state="NC",
        postal="",
        lat=36.069384,
        lng=-79.81268,
        housenumber="",
        country="USA",
    ),
    "MassMutual Center, Springfield, Massachusetts": SportsballGeocodeTuple(
        city="Springfield",
        state="MA",
        postal="",
        lat=42.102222,
        lng=-72.586944,
        housenumber="1277",
        country="USA",
    ),
    "Sanford Pentagon, Sioux Falls, South Dakota": SportsballGeocodeTuple(
        city="Sioux Falls",
        state="SD",
        postal="",
        lat=43.593056,
        lng=-96.758611,
        housenumber="2210",
        country="USA",
    ),
    "Hilliard Gates Sports Center, Fort Wayne, Indiana": SportsballGeocodeTuple(
        city="Fort Wayne",
        state="IN",
        postal="46835",
        lat=41.119,
        lng=-85.1076,
        housenumber="2101",
        country="USA",
    ),
    "XL Center, Hartford, Connecticut": SportsballGeocodeTuple(
        city="Hartford",
        state="CT",
        postal="",
        lat=41.768333,
        lng=-72.676944,
        housenumber="1",
        country="USA",
    ),
    "Mississippi Coliseum, Jackson, Mississippi": SportsballGeocodeTuple(
        city="Jackson",
        state="MS",
        postal="",
        lat=32.300126,
        lng=-90.172121,
        housenumber="1207",
        country="USA",
    ),
    "Hytche Athletic Center, Princess Anne, Maryland": SportsballGeocodeTuple(
        city="Princess Anne",
        state="MD",
        postal="",
        lat=38.211184,
        lng=-75.687227,
        housenumber="",
        country="USA",
    ),
    "Mississippi Coast Coliseum, Biloxi, Mississippi": MISSISSIPPI_COAST_COLISEUM,
    "Simmons Bank Arena, North Little Rock, Arkansas": SIMMONS_BANK_ARENA,
    "FLA Live Arena, Sunrise, Florida": FLA_LIVE_ARENA,
    "Dollar Loan Center, Henderson, Nevada": SportsballGeocodeTuple(
        city="Henderson",
        state="NV",
        postal="",
        lat=36.018977,
        lng=-115.081632,
        housenumber="200",
        country="USA",
    ),
    "Vivint Arena, Salt Lake City, Utah": VIVINT_ARENA,
    "Rock Hill Sports & Event Center, Rock Hill, South Carolina": SportsballGeocodeTuple(
        city="Rock Hill",
        state="SC",
        postal="29730",
        lat=34.9318802,
        lng=-81.0299645,
        housenumber="326",
        country="USA",
    ),
    "David Stopher Gymnasium, Thibodaux, Louisiana": SportsballGeocodeTuple(
        city="Thibodaux",
        state="LA",
        postal="",
        lat=29.79235,
        lng=-90.80135,
        housenumber="",
        country="USA",
    ),
    "Rolle Activity Center, Flagstaff, Arizona": SportsballGeocodeTuple(
        city="Flagstaff",
        state="AZ",
        postal="86001",
        lat=35.1768307,
        lng=-111.6553593,
        housenumber="",
        country="USA",
    ),
    "Wellness Center, Brooklyn, New York": SportsballGeocodeTuple(
        city="Brooklyn",
        state="NY",
        postal="",
        lat=40.69059,
        lng=-73.979176,
        housenumber="",
        country="USA",
    ),
    "Baha Mar Convention Center, Nassau": SportsballGeocodeTuple(
        city="Nassau",
        state="",
        postal="",
        lat=25.0703613,
        lng=-77.4001874,
        housenumber="",
        country="Bahamas",
    ),
    "DeGol Arena, Loretto, Pennsylvania": DEGOL_ARENA,
    "MGM Grand Garden Arena, Paradise, Nevada": SportsballGeocodeTuple(
        city="Paradise",
        state="NV",
        postal="",
        lat=36.104808,
        lng=-115.168614,
        housenumber="3799",
        country="USA",
    ),
    "State Farm Field House, Lake Buena Vista, Florida": STATE_FARM_FIELDHOUSE,
    "Boston Garden": BOSTON_GARDENS,
    "Cow Palace - Daly City, California - United States": SportsballGeocodeTuple(
        city="Daly City",
        state="CA",
        postal="",
        lat=37.706667,
        lng=-122.418611,
        housenumber="2600",
        country="USA",
    ),
    "The Forum": THE_FORUM,
    "Chicago Stadium": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="",
        lat=41.881667,
        lng=-87.672778,
        housenumber="1800",
        country="USA",
    ),
    "Memorial Coliseum - Portland, Oregon - United States": MEMORIAL_COLISEUM,
    "McNichols Sports Arena": MCNICHOLS_SPORTS_ARENA,
    "Kemper Arena": SportsballGeocodeTuple(
        city="Kansas City",
        state="MO",
        postal="",
        lat=39.742778,
        lng=-105.0225,
        housenumber="1800",
        country="USA",
    ),
    "Omni Coliseum": OMNI_COLISEUM,
    "Great Western Forum": THE_FORUM,
    "The Palace of Auburn Hills - Auburn Hills, MI - USA": THE_PALACE_OF_AUBURN_HILLS,
    "Quicken Loans Arena - Cleveland, Ohio - United States": QUICKEN_LOANS_ARENA,
    "Chesapeake Energy Arena - Oklahoma City, Oklahoma - United States": CHESAPEAKE_ENERGY_ARENA,
    "AT&T Center - San Antonio, Texas - United States": ATT_CENTER,
    "ESPN Wide World of Sports Complex": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "International Amphitheatre": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60609",
        lat=41.816111,
        lng=-87.646111,
        housenumber="4220",
        country="USA",
    ),
    "San Jose Civic Auditorium": SAN_JOSE_CIVIC_AUDITORIUM,
    "Suncoast Credit Union Arena, Fort Myers, Florida": SportsballGeocodeTuple(
        city="Fort Myers",
        state="FL",
        postal="33919",
        lat=26.5478,
        lng=-81.8869,
        housenumber="13351",
        country="USA",
    ),
    "The Spectrum - Guildford, Surrey, United Kingdom - United Kingdom": SportsballGeocodeTuple(
        city="Surrey",
        state="",
        postal="",
        lat=51.24844,
        lng=-0.56288,
        housenumber="",
        country="UK",
    ),
    "San Diego Sports Arena": SAN_DIEGO_SPORTS_ARENA,
    "Hertz Arena, Estero, Florida": HERTZ_ARENA,
    "Hard Rock Hotel Riviera Maya, Cancun": SportsballGeocodeTuple(
        city="Cancun",
        state="",
        postal="",
        lat=20.5069801,
        lng=-87.215373,
        housenumber="",
        country="Mexico",
    ),
    "Ocean Center, Daytona Beach, Florida": SportsballGeocodeTuple(
        city="Daytona Beach",
        state="FL",
        postal="",
        lat=29.2287,
        lng=-81.0106,
        housenumber="101",
        country="USA",
    ),
    "John Gray Gymnasium, Grand Cayman": SportsballGeocodeTuple(
        city="Grand Cayman",
        state="",
        postal="",
        lat=19.279316,
        lng=-81.385651,
        housenumber="73",
        country="UK",
    ),
    "Woodling Gym, Cleveland, Ohio": SportsballGeocodeTuple(
        city="Cleveland",
        state="OH",
        postal="",
        lat=41.503355,
        lng=-81.671269,
        housenumber="",
        country="USA",
    ),
    "Municipal Auditorium": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.167581,
        lng=-86.782244,
        housenumber="417",
        country="USA",
    ),
    "Elridge Wilburn Blake Sports and Fitness Center, St. Thomas": SportsballGeocodeTuple(
        city="St. Thomas",
        state="USVI",
        postal="",
        lat=18.340096,
        lng=-64.97306,
        housenumber="",
        country="USA",
    ),
    "Market Square Arena": MARKET_SQUARE_ARENA,
    "Reunion Arena": REUNION_ARENA,
    "Walsh Gymnasium, South Orange, New Jersey": SportsballGeocodeTuple(
        city="South Orange",
        state="NJ",
        postal="07079",
        lat=40.74169,
        lng=-74.244921,
        housenumber="",
        country="USA",
    ),
    "Moore Gymnasium, Daytona Beach, Florida": SportsballGeocodeTuple(
        city="Daytona Beach",
        state="FL",
        postal="",
        lat=29.210895,
        lng=-81.030977,
        housenumber="",
        country="USA",
    ),
    "Tacoma Dome": TACOMA_DOME,
    "Royal Farms Arena, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.288611,
        lng=-76.618889,
        housenumber="201",
        country="USA",
    ),
    "Arco Arena - Sacramento, California - United States": ARCO_ARENA,
    "Bradley Center": BRADLEY_CENTER,
    "Charlotte Coliseum": CHARLOTTE_COLISEUM,
    "Miami Arena": MIAMI_ARENA,
    "Al McGuire Center, Milwaukee, Wisconsin": SportsballGeocodeTuple(
        city="Milwaukee",
        state="WI",
        postal="53233",
        lat=43.039722,
        lng=-87.926389,
        housenumber="770",
        country="USA",
    ),
    "Orlando Arena": ORLANDO_ARENA,
    "Tokyo Metropolitan Gymnasium": SportsballGeocodeTuple(
        city="Tokyo",
        state="",
        postal="",
        lat=35.679694,
        lng=139.7125,
        housenumber="",
        country="Japan",
    ),
    "Yokohama Arena": YOKOHAMA_ARENA,
    "Anaheim Convention Center": ANAHEIM_CONVENTION_CENTER,
    "Amway Arena": ORLANDO_ARENA,
    "FTX Arena": FTX_ARENA,
    "Rose Garden": ROSE_GARDEN,
    "Toyota Center - Kennewick, Washington - United States": TOYOTA_CENTER,
    "Etihad Arena - Yas Bay Waterfront, Yas Island, Abu Dhabi - United Arab Emirates": SportsballGeocodeTuple(
        city="Abu Dhabi",
        state="",
        postal="",
        lat=24.4603,
        lng=54.604,
        housenumber="",
        country="UAE",
    ),
    "AT&T Center, San Antonio, Texas": ATT_CENTER,
    "FTX Arena, Miami, Florida": FTX_ARENA,
    "Vivint Smart Home Arena, Salt Lake City, Utah": VIVINT_ARENA,
    "Chesapeake Energy Arena, Oklahoma City, Oklahoma": CHESAPEAKE_ENERGY_ARENA,
    "The Arena, Bay Lake, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "HP Field House, Bay Lake, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Amway Center, Orlando, Florida": ORLANDO_ARENA,
    "Quicken Loans Arena, Cleveland, Ohio": QUICKEN_LOANS_ARENA,
    "Visa Athletic Center, Bay Lake, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Dunn–Oliver Acadome, Montgomery, Alabama": DUNN_OLIVER_ACADOME,
    "The O2 Arena, London, United Kingdom": O2_ARENA,
    "BMO Harris Bradley Center, Milwaukee, Wisconsin": BRADLEY_CENTER,
    "Texas A&M–Commerce Field House, Commerce, Texas": TEXAS_AM_COMMERCE_FIELD_HOUSE,
    "Detroit, Michigan": DETROIT,
    "Charlotte, North Carolina": CHARLOTTE,
    "Salt Lake City, Utah": SALT_LAKE_CITY,
    "Ferrell Center, Waco, Texas": SportsballGeocodeTuple(
        city="Waco",
        state="TX",
        postal="76706",
        lat=31.547903,
        lng=-97.105969,
        housenumber="1900",
        country="USA",
    ),
    "Princeton, New Jersey": PRINCETON,
    "Nashville, Tennessee": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.162222,
        lng=-86.774444,
        housenumber="",
        country="USA",
    ),
    "Fort Worth, Texas": SportsballGeocodeTuple(
        city="Fort Worth",
        state="TX",
        postal="",
        lat=32.756389,
        lng=-97.3325,
        housenumber="",
        country="USA",
    ),
    "Henderson, Nevada": SportsballGeocodeTuple(
        city="Henderson",
        state="NV",
        postal="",
        lat=36.033333,
        lng=-114.983333,
        housenumber="",
        country="USA",
    ),
    "Lake Charles, Louisiana": SportsballGeocodeTuple(
        city="Lake Charles",
        state="LA",
        postal="",
        lat=30.214722,
        lng=-93.208611,
        housenumber="",
        country="USA",
    ),
    "Pensacola Bay Center, Pensacola, Florida": SportsballGeocodeTuple(
        city="Pensacola",
        state="FL",
        postal="32502",
        lat=30.416485,
        lng=-87.209372,
        housenumber="201",
        country="USA",
    ),
    "Lundholm Gym, Durham, New Hampshire": SportsballGeocodeTuple(
        city="Durham",
        state="NH",
        postal="03824",
        lat=43.138611,
        lng=-70.938056,
        housenumber="145",
        country="USA",
    ),
    "Clune Arena, Colorado Springs, Colorado": SportsballGeocodeTuple(
        city="Colorado Springs",
        state="CO",
        postal="",
        lat=39.014,
        lng=-104.8833,
        housenumber="2168",
        country="USA",
    ),
    "Donald L. Tucker Civic Center, Tallahassee, Florida": SportsballGeocodeTuple(
        city="Tallahassee",
        state="FL",
        postal="32301",
        lat=30.437842,
        lng=-84.28669,
        housenumber="505",
        country="USA",
    ),
    "Denny Sanford Premier Center, Sioux Falls, South Dakota": SportsballGeocodeTuple(
        city="Sioux Falls",
        state="SD",
        postal="",
        lat=43.561667,
        lng=-96.75,
        housenumber="1201",
        country="USA",
    ),
    "Dunn-Oliver Acadome, Montgomery, Alabama": DUNN_OLIVER_ACADOME,
    "Oklahoma City, Oklahoma": SportsballGeocodeTuple(
        city="Oklahoma City",
        state="OK",
        postal="",
        lat=35.468611,
        lng=-97.521389,
        housenumber="",
        country="USA",
    ),
    "Harrah's Cherokee Center, Asheville, North Carolina": HARRAHS_CHEROKEE_CENTER,
    "Savage Arena, Toledo, Ohio": SAVAGE_ARENA,
    "Pullman, Washington": SportsballGeocodeTuple(
        city="Pullman",
        state="WA",
        postal="",
        lat=46.733333,
        lng=-117.168611,
        housenumber="87",
        country="USA",
    ),
    "Fairfield, Connecticut": SportsballGeocodeTuple(
        city="Fairfield",
        state="CT",
        postal="",
        lat=41.15,
        lng=-73.266667,
        housenumber="87",
        country="USA",
    ),
    "Denton, Texas": SportsballGeocodeTuple(
        city="Denton",
        state="TX",
        postal="",
        lat=33.216389,
        lng=-97.129167,
        housenumber="",
        country="USA",
    ),
    "Coral Gables, Florida": CORAL_GABLES,
    "Kingston, Rhode Island": SportsballGeocodeTuple(
        city="Kingston",
        state="KI",
        postal="",
        lat=41.483333,
        lng=-71.533333,
        housenumber="",
        country="USA",
    ),
    "Chase Athletic Center, Smithfield, Rhode Island": CHASE_ATHLETIC_CENTER,
    "Murphy Center, Murfreesboro, Tennessee": MURPHY_ATHELTIC_CENTER,
    "Chesapeake Employers Insurance Arena, Baltimore, Maryland": CHESAPEAKE_ENERGY_ARENA,
    "Bozeman, Montana": SportsballGeocodeTuple(
        city="Bozeman",
        state="MT",
        postal="",
        lat=45.685556,
        lng=-111.025,
        housenumber="",
        country="USA",
    ),
    "Banterra Center, Carbondale, Illinois": SportsballGeocodeTuple(
        city="Carbondale",
        state="IL",
        postal="",
        lat=37.708333,
        lng=-89.218611,
        housenumber="",
        country="USA",
    ),
    "CU Events Center, Boulder, Colorado": SportsballGeocodeTuple(
        city="Boulder",
        state="CO",
        postal="",
        lat=40.0047,
        lng=-105.2606,
        housenumber="950",
        country="USA",
    ),
    "University Credit Union Pavilion, Moraga, California": SportsballGeocodeTuple(
        city="Moraga",
        state="CA",
        postal="",
        lat=37.841247,
        lng=-122.106409,
        housenumber="1928",
        country="USA",
    ),
    "Bernard Johnson Coliseum, Huntsville, Texas": SportsballGeocodeTuple(
        city="Huntsville",
        state="TX",
        postal="77340",
        lat=30.712778,
        lng=-95.546111,
        housenumber="1964",
        country="USA",
    ),
    "Amica Mutual Pavilion, Providence, Rhode Island": AMICA_MUTUAL_PAVILION,
    "George Gervin GameAbove Center, Ypsilanti, Michigan": SportsballGeocodeTuple(
        city="Ypsilanti",
        state="MI",
        postal="48197",
        lat=42.254444,
        lng=-83.647222,
        housenumber="799",
        country="USA",
    ),
    "Binghamton, New York": SportsballGeocodeTuple(
        city="Binghamton",
        state="NY",
        postal="",
        lat=42.098889,
        lng=-75.910833,
        housenumber="",
        country="USA",
    ),
    "Timmons Arena, Greenville, South Carolina": SportsballGeocodeTuple(
        city="Greenville",
        state="SC",
        postal="29613",
        lat=34.9179345,
        lng=-82.437289,
        housenumber="3300",
        country="USA",
    ),
    "Betty Engelstad Sioux Center, Grand Forks, North Dakota": SportsballGeocodeTuple(
        city="Grand Forks",
        state="ND",
        postal="58203",
        lat=47.92767,
        lng=-97.07247,
        housenumber="1",
        country="USA",
    ),
    "Ross E. Templeton Center, Clinton, South Carolina": ROSS_E_TEMPLETON_CENTER,
    "UMPC Cooper Fieldhouse, Pittsburgh, Pennsylvania": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="15282",
        lat=40.4374,
        lng=-79.9879,
        housenumber="600",
        country="USA",
    ),
    "John J. Lee Amphitheater, New Haven, Connecticut": SportsballGeocodeTuple(
        city="New Haven",
        state="CT",
        postal="06511",
        lat=41.313611,
        lng=-72.930556,
        housenumber="70",
        country="USA",
    ),
    "Moscow, Idaho": SportsballGeocodeTuple(
        city="Moscow",
        state="ID",
        postal="",
        lat=46.741667,
        lng=-117.0,
        housenumber="",
        country="USA",
    ),
    "Island Federal Credit Union Arena, Stony Brook, New York": STONY_BROOK_ARENA,
    "America First Event Center, Cedar City, Utah": SportsballGeocodeTuple(
        city="Cedar City",
        state="UT",
        postal="84720",
        lat=37.675556,
        lng=-113.073056,
        housenumber="351",
        country="USA",
    ),
    "Jenny Craig Pavilion, San Diego, California": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.7745,
        lng=-117.1837,
        housenumber="5998",
        country="USA",
    ),
    "George M. Holmes Convocation Center, Boone, North Carolina": HOLMES_CENTER,
    "Farris Center, Conway, Arkansas": FARRIS_CENTER,
    "Atlanta, Georgia": ATLANTA,
    "UNF Arena, Jacksonville, Florida": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="32224",
        lat=30.2734,
        lng=-81.5079,
        housenumber="11852",
        country="USA",
    ),
    "Strahan Arena, San Marcos, Texas": SportsballGeocodeTuple(
        city="San Marcos",
        state="TX",
        postal="78666",
        lat=29.888611,
        lng=-97.932778,
        housenumber="601",
        country="USA",
    ),
    "Wellness and Events Center, Newark, New Jersey": WELLNESS_AND_EVENTS_CENTER,
    "Easton, Massachusetts": SportsballGeocodeTuple(
        city="Easton",
        state="MA",
        postal="",
        lat=42.024444,
        lng=-71.129167,
        housenumber="",
        country="USA",
    ),
    "University Credit Union Center, Davis, California": SportsballGeocodeTuple(
        city="Davis",
        state="CA",
        postal="95616",
        lat=38.541667,
        lng=-121.759444,
        housenumber="1",
        country="USA",
    ),
    "Buccaneer Field House, Charleston, South Carolina": BUCCANEER_FIELDHOUSE,
    "Credit Union 1 Arena, Chicago, Illinois": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60607",
        lat=41.874722,
        lng=-87.656111,
        housenumber="525",
        country="USA",
    ),
    "E. A. Diddle Arena, Bowling Green, Kentucky": EA_DIDDLE_ARENA,
    "Kress Events Center, Green Bay, Wisconsin": SportsballGeocodeTuple(
        city="Green Bay",
        state="WI",
        postal="",
        lat=44.530069,
        lng=-87.915967,
        housenumber="",
        country="USA",
    ),
    "OceanFirst Bank Center, West Long Branch, New Jersey": SportsballGeocodeTuple(
        city="West Long Branch",
        state="NJ",
        postal="07764",
        lat=40.279475,
        lng=-74.007583,
        housenumber="400",
        country="USA",
    ),
    "Alex G. Spanos Center, Stockton, California": AG_SPANOS_CENTER,
    "War Memorial Gymnasium, San Francisco, California": WAR_MEMORIAL_GYMNASIUM,
    "Frost Arena, Brookings, South Dakota": SportsballGeocodeTuple(
        city="Brookings",
        state="SD",
        postal="57007",
        lat=44.317984,
        lng=-96.779058,
        housenumber="1165",
        country="USA",
    ),
    "Louisville, Kentucky": LOUISVILLE,
    "Saint Charles, Missouri": SportsballGeocodeTuple(
        city="Saint Charles",
        state="MO",
        postal="",
        lat=38.789,
        lng=-90.514,
        housenumber="",
        country="USA",
    ),
    "Cam Henderson Center, Huntington, West Virginia": HENDERSON_CENTER,
    "Brooklyn, New York": SportsballGeocodeTuple(
        city="Brooklyn",
        state="NY",
        postal="",
        lat=40.65,
        lng=-73.95,
        housenumber="",
        country="USA",
    ),
    "Alabama A&M Events Center, Huntsville, Alabama": SportsballGeocodeTuple(
        city="Huntsville",
        state="AL",
        postal="35810",
        lat=34.781139,
        lng=-86.580528,
        housenumber="",
        country="USA",
    ),
    "Vadalabene Center, Edwardsville, Illinois": SportsballGeocodeTuple(
        city="Edwardsville",
        state="IL",
        postal="",
        lat=38.795989,
        lng=-89.999883,
        housenumber="35",
        country="USA",
    ),
    "Corpus Christi, Texas": CORPUS_CHRISTI,
    "Island Federal Credit Union Arena, New York, NY, USA": STONY_BROOK_ARENA,
    "Savannah, Georgia": SAVANNAH,
    "Akron, Ohio": AKRON,
    "Sioux Falls, South Dakota": SIOUX_FALLS,
    "Springfield, Massachusetts": SportsballGeocodeTuple(
        city="Springfield",
        state="MA",
        postal="",
        lat=42.101389,
        lng=-72.590278,
        housenumber="",
        country="USA",
    ),
    "Elmont, New York": SportsballGeocodeTuple(
        city="Elmont",
        state="NY",
        postal="",
        lat=40.701667,
        lng=-73.7025,
        housenumber="",
        country="USA",
    ),
    "Tulsa, Oklahoma": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="",
        lat=36.131389,
        lng=-95.937222,
        housenumber="",
        country="USA",
    ),
    "Sunrise, Florida": SportsballGeocodeTuple(
        city="Sunrise",
        state="FL",
        postal="",
        lat=26.157222,
        lng=-80.286111,
        housenumber="",
        country="USA",
    ),
    "Paradise, Nevada": SportsballGeocodeTuple(
        city="Paradise",
        state="NV",
        postal="",
        lat=36.081944,
        lng=-115.124722,
        housenumber="",
        country="USA",
    ),
    "Niceville, Florida": SportsballGeocodeTuple(
        city="Niceville",
        state="FL",
        postal="",
        lat=30.516111,
        lng=-86.471667,
        housenumber="",
        country="USA",
    ),
    "Ondrej Nepela Arena, Bratislava, Slovakia": SportsballGeocodeTuple(
        city="Bratislava",
        state="",
        postal="",
        lat=48.16,
        lng=17.135833,
        housenumber="9",
        country="Slovakia",
    ),
    "San Juan Capistrano, California": SportsballGeocodeTuple(
        city="San Juan Capistrano",
        state="CA",
        postal="",
        lat=33.499444,
        lng=-117.661667,
        housenumber="",
        country="USA",
    ),
    "Fort Myers, Florida": SportsballGeocodeTuple(
        city="Fort Myers",
        state="FL",
        postal="",
        lat=26.616667,
        lng=-81.833333,
        housenumber="",
        country="USA",
    ),
    "Thunderdome Stadium, Nonthaburi, Thailand": SportsballGeocodeTuple(
        city="Nonthaburi",
        state="",
        postal="",
        lat=13.917989,
        lng=100.547411,
        housenumber="",
        country="Thailand",
    ),
    "Spotland Stadium, Rochdale, England": SportsballGeocodeTuple(
        city="Rochdale",
        state="",
        postal="OL11 5DR",
        lat=53.620833,
        lng=-2.18,
        housenumber="",
        country="UK",
    ),
    "ARCO Arena, Sacramento, CA, USA": ARCO_ARENA,
    "AdventHealth Arena, Orlando, FL, USA": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "The Palace of Auburn Hills, Auburn Hills, MI, USA": THE_PALACE_OF_AUBURN_HILLS,
    "BMO Harris Bradley Center, Milwaukee, WI, USA": BRADLEY_CENTER,
    "State Farm Field House, Orlando, FL, USA": STATE_FARM_FIELDHOUSE,
    "Panjin Jinxiu Stadium, Panjin, China": SportsballGeocodeTuple(
        city="Panjin",
        state="",
        postal="",
        lat=41.110278,
        lng=122.071667,
        housenumber="",
        country="China",
    ),
    "ESPN Wide World of Sports Complex, Bay Lake, FL, USA": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Visa Athletic Center, Orlando, FL, USA": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "The Arena (WWOS), Orlando, FL, USA": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "PayPal Park, San Jose, CA, USA": SportsballGeocodeTuple(
        city="San Jose",
        state="CA",
        postal="",
        lat=37.351389,
        lng=-121.925,
        housenumber="1123",
        country="USA",
    ),
    "Robert F. Kennedy Memorial Stadium, Washington, DC, USA": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.89,
        lng=-76.972,
        housenumber="2400",
        country="USA",
    ),
    "West Hartford, Connecticut": SportsballGeocodeTuple(
        city="West Hartford",
        state="CT",
        postal="",
        lat=41.767778,
        lng=-72.753889,
        housenumber="",
        country="USA",
    ),
    "The Palace of Auburn Hills, Auburn Hills, Michigan": THE_PALACE_OF_AUBURN_HILLS,
    "Lake Buena Vista, Florida": SportsballGeocodeTuple(
        city="Lake Buena Vista",
        state="FL",
        postal="",
        lat=28.3775,
        lng=-81.526111,
        housenumber="",
        country="USA",
    ),
    "Place Bell, Laval": SportsballGeocodeTuple(
        city="Laval",
        state="QC",
        postal="",
        lat=45.5558,
        lng=-73.7218,
        housenumber="1950",
        country="CA",
    ),
    "Estero, Florida": SportsballGeocodeTuple(
        city="Estero",
        state="FL",
        postal="",
        lat=26.427778,
        lng=-81.795,
        housenumber="",
        country="USA",
    ),
    "McDonough Field House, Albany, New York": SportsballGeocodeTuple(
        city="Albany",
        state="NY",
        postal="",
        lat=42.6970529,
        lng=-73.6817757,
        housenumber="",
        country="USA",
    ),
    "Uncasville, Connecticut": SportsballGeocodeTuple(
        city="Uncasville",
        state="CT",
        postal="",
        lat=41.434542,
        lng=-72.109799,
        housenumber="",
        country="USA",
    ),
    "Sacramento, California": SportsballGeocodeTuple(
        city="Sacramento",
        state="CA",
        postal="",
        lat=38.581667,
        lng=-121.494444,
        housenumber="",
        country="USA",
    ),
    "Ford Center at the Star, Frisco, Texas": FORD_CENTER_AT_THE_STAR,
    "Willett Hall, Farmville, Virginia": SportsballGeocodeTuple(
        city="Farmville",
        state="VA",
        postal="",
        lat=37.2975,
        lng=-78.3955,
        housenumber="23909",
        country="USA",
    ),
    "Indianapolis, Indiana": INDIANAPOLIS,
    "Milwaukee, Wisconsin": MILWAUKEE,
    "GSU Sports Arena, Atlanta, Georgia": GSU_CONVOCATION_CENTER,
    "High Point, North Carolina": SportsballGeocodeTuple(
        city="High Point",
        state="NC",
        postal="",
        lat=35.991111,
        lng=-79.993611,
        housenumber="",
        country="USA",
    ),
    "Winfield Dunn Center, Clarksville, Tennessee": SportsballGeocodeTuple(
        city="Clarksville",
        state="TN",
        postal="",
        lat=36.536111,
        lng=-87.356944,
        housenumber="",
        country="USA",
    ),
    "Harry A. Campel Pavilion, Storrs, Connecticut": SportsballGeocodeTuple(
        city="Storrs",
        state="CT",
        postal="06269",
        lat=41.805292,
        lng=-72.254194,
        housenumber="2095",
        country="USA",
    ),
    "Santa Cruz, California": SportsballGeocodeTuple(
        city="Santa Cruz",
        state="CA",
        postal="",
        lat=36.971944,
        lng=-122.026389,
        housenumber="",
        country="USA",
    ),
    "South Padre Island, Texas": SportsballGeocodeTuple(
        city="South Padre Island",
        state="TX",
        postal="",
        lat=26.111944,
        lng=-97.169722,
        housenumber="",
        country="USA",
    ),
    "Wichita, Kansas": WICHITA,
    "Jackson, Mississippi": JACKSON,
    "Union, New Jersey": SportsballGeocodeTuple(
        city="Union",
        state="NJ",
        postal="",
        lat=40.695266,
        lng=-74.269078,
        housenumber="",
        country="USA",
    ),
    "The O2 Arena, London": O2_ARENA,
    "People's United Center, Hamden, Connecticut": SportsballGeocodeTuple(
        city="Hamden",
        state="CT",
        postal="06518",
        lat=41.413833,
        lng=-72.911157,
        housenumber="305",
        country="USA",
    ),
    "Taylorsville, Utah": SportsballGeocodeTuple(
        city="Taylorsville",
        state="UT",
        postal="",
        lat=40.655,
        lng=-111.949444,
        housenumber="",
        country="USA",
    ),
    "Flagstaff, Arizona": SportsballGeocodeTuple(
        city="Flagstaff",
        state="AZ",
        postal="",
        lat=35.180556,
        lng=-111.62,
        housenumber="",
        country="USA",
    ),
    "Portland, Oregon": PORTLAND,
    "Laie, Hawaii": SportsballGeocodeTuple(
        city="Laie",
        state="HI",
        postal="",
        lat=21.648611,
        lng=-157.925556,
        housenumber="",
        country="USA",
    ),
    "Copper Box Arena, London": SportsballGeocodeTuple(
        city="London",
        state="",
        postal="",
        lat=51.5444,
        lng=-0.0201,
        housenumber="",
        country="UK",
    ),
    "Anaheim, California": SportsballGeocodeTuple(
        city="Anaheim",
        state="CA",
        postal="",
        lat=33.836111,
        lng=-117.889722,
        housenumber="",
        country="USA",
    ),
    "Lahaina, Hawaii": SportsballGeocodeTuple(
        city="Lahaina",
        state="HI",
        postal="",
        lat=20.873889,
        lng=-156.6775,
        housenumber="",
        country="USA",
    ),
    "Edinburg, Texas": SportsballGeocodeTuple(
        city="Edinburg",
        state="TX",
        postal="",
        lat=26.304167,
        lng=-98.163889,
        housenumber="",
        country="USA",
    ),
    "Spokane, Washington": SPOKANE,
    "Montego Bay Convention Centre, Montego Bay": SportsballGeocodeTuple(
        city="Montego Bay",
        state="",
        postal="",
        lat=18.5198974,
        lng=-77.8204727,
        housenumber="",
        country="Jamaica",
    ),
    "National Basketball Arena, South Dublin": SportsballGeocodeTuple(
        city="South Dublin",
        state="",
        postal="",
        lat=53.292222,
        lng=-6.334444,
        housenumber="",
        country="Ireland",
    ),
    "Generoso Pope Athletic Complex, Brooklyn Heights, New York": GENEROSO_POPE_ATHELTIC_COMPLEX,
    "Youngstown, Ohio": YOUNGSTOWN,
    "Kansas City, Kansas": SportsballGeocodeTuple(
        city="Kansas City",
        state="KS",
        postal="",
        lat=39.106667,
        lng=-94.676389,
        housenumber="",
        country="USA",
    ),
    "San Diego, California": SAN_DIEGO,
    "Sleep Train Arena, Sacramento, California": ARCO_ARENA,
    "UNT Coliseum, Denton, Texas": SportsballGeocodeTuple(
        city="Denton",
        state="TX",
        postal="76201",
        lat=33.208333,
        lng=-97.153889,
        housenumber="801",
        country="USA",
    ),
    "The Center, Philadelphia, Pennsylvania": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.952,
        lng=-75.164,
        housenumber="",
        country="USA",
    ),
    "Wolstein Center, Cleveland, Ohio": WOLSTEIN_CENTER,
    "Elmore Gymnasium, Normal, Alabama": ELMORE_GYMNASIUM,
    "Teague Special Events Center, Abilene, Texas": SportsballGeocodeTuple(
        city="Abilene",
        state="TX",
        postal="79601",
        lat=32.4712266,
        lng=-99.7083714,
        housenumber="1600",
        country="USA",
    ),
    "U.S. Cellular Center, Asheville, North Carolina": HARRAHS_CHEROKEE_CENTER,
    "Ford Center at The Star, Frisco, Texas": FORD_CENTER_AT_THE_STAR,
    "Boardwalk Hall, Atlantic City, New Jersey": SportsballGeocodeTuple(
        city="Atlantic City",
        state="NJ",
        postal="",
        lat=39.355,
        lng=-74.438611,
        housenumber="2301",
        country="USA",
    ),
    "Norfolk Scope, Norfolk, Virginia": SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="23510",
        lat=36.853275,
        lng=-76.286722,
        housenumber="201",
        country="USA",
    ),
    "Beasley Coliseum, Pullman, Washington": BEASLEY_COLISEUM,
    "Times Union Center , Albany, New York": TIMES_UNION_CENTER,
    "Dunkin Donuts Center, Providence, Rhode Island": DUNKIN_DONUTS_CENTER,
    "Ryan Center, Kingston, Rhode Island": RYAN_CENTER,
    "Pope Physical Education Center, Brooklyn Heights, New York": GENEROSO_POPE_ATHELTIC_COMPLEX,
    "Eastwood High School Gym, El Paso, Texas": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="",
        lat=31.7718,
        lng=-106.3547,
        housenumber="2430",
        country="USA",
    ),
    "Millis Center, High Point, North Carolina": SportsballGeocodeTuple(
        city="High Point",
        state="NC",
        postal="27262",
        lat=35.973456,
        lng=-79.995706,
        housenumber="922",
        country="USA",
    ),
    "George Bisacca Court at Alumni Hall, Fairfield, Connecticut": SportsballGeocodeTuple(
        city="Fairfield",
        state="CT",
        postal="",
        lat=41.159854,
        lng=-73.256646,
        housenumber="",
        country="USA",
    ),
    "Life University Gym, Marietta, Georgia": SportsballGeocodeTuple(
        city="Marietta",
        state="GA",
        postal="30062",
        lat=33.9313785,
        lng=-84.5223277,
        housenumber="1269",
        country="USA",
    ),
    "John J. Moore Athletic Center, Jersey City, New Jersey": SportsballGeocodeTuple(
        city="Jersey City",
        state="NJ",
        postal="07305",
        lat=40.7129524,
        lng=-74.0891177,
        housenumber="110",
        country="USA",
    ),
    "Elmore Health Science Building , Normal, Alabama": ELMORE_GYMNASIUM,
    "McDonough Gymnasium, Washington, District of Columbia": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="20057",
        lat=38.9075,
        lng=-77.0775,
        housenumber="",
        country="USA",
    ),
    "M.O. Campbell Center, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="77032",
        lat=29.932222,
        lng=-95.359722,
        housenumber="1865",
        country="USA",
    ),
    "Alumni Recreation Center, Loudonville, New York": SportsballGeocodeTuple(
        city="Loudonville",
        state="NY",
        postal="12211",
        lat=42.7174,
        lng=-73.7487,
        housenumber="515",
        country="USA",
    ),
    "Max Worthington Arena, Bozeman, Montana": SportsballGeocodeTuple(
        city="Bozeman",
        state="MT",
        postal="",
        lat=45.6633,
        lng=-111.0506,
        housenumber="1",
        country="USA",
    ),
    "Alumni Hall (RI), Providence, Rhode Island": ALUMNI_HALL,
    "Leonard E. Merrell Center, Katy, Texas": MERRELL_CENTER,
    "Comerica, Frisco, Texas": SportsballGeocodeTuple(
        city="Frisco",
        state="TX",
        postal="",
        lat=33.101026,
        lng=-96.819624,
        housenumber="2601",
        country="USA",
    ),
    "Chase Family Arena, Hartford, Connecticut": CHASE_FAMILY_ARENA,
    "Virgin Islands Sport & Fitness Center , St. Thomas": VIRGIN_ISLANDS_SPORT_AND_FITNESS_CENTER,
    "Virgin Islands Sport & Fitness Center, St. Thomas": VIRGIN_ISLANDS_SPORT_AND_FITNESS_CENTER,
    "McArthur Gymnasium, St. Petersburg, Florida": SportsballGeocodeTuple(
        city="St. Petersburg",
        state="FL",
        postal="",
        lat=27.717097,
        lng=-82.688406,
        housenumber="",
        country="USA",
    ),
    "St. Petersburg, Florida": ST_PETERSBURG,
    "Anaheim Convention Center, Anaheim, California": ANAHEIM_CONVENTION_CENTER,
    "Hawkins Arena, Macon, Georgia": SportsballGeocodeTuple(
        city="Macon",
        state="GA",
        postal="31207",
        lat=32.829722,
        lng=-83.651944,
        housenumber="1730",
        country="USA",
    ),
    "Frank Erwin Center, Austin, Texas": SportsballGeocodeTuple(
        city="Austin",
        state="TX",
        postal="",
        lat=30.277,
        lng=-97.7322,
        housenumber="1701",
        country="USA",
    ),
    "Binghamton University Events Center, Vestal, New York": BINGHAMPTON_UNIVERSITY_EVENTS_CENTER,
    "Kaiser Permanente Arena, Santa Cruz, California": SportsballGeocodeTuple(
        city="Santa Cruz",
        state="CA",
        postal="",
        lat=36.968611,
        lng=-122.023611,
        housenumber="",
        country="USA",
    ),
    "Rip Griffin Center, Lubbock, Texas": SportsballGeocodeTuple(
        city="Lubbock",
        state="TX",
        postal="",
        lat=33.57186,
        lng=-101.93188,
        housenumber="",
        country="USA",
    ),
    "Ability360 Sports & Fitness Center, Phoenix, Arizona": SportsballGeocodeTuple(
        city="Phoenix",
        state="AZ",
        postal="85034",
        lat=33.4451355,
        lng=-111.9737363,
        housenumber="5031",
        country="USA",
    ),
    "Lawrence Joel Veterans Memorial Coliseum, Winston-Salem, North Carolina": LAWRENCE_JOEL_VETERANS_MEMORIAL_COLISEUM,
    "Indiana Convention Center, Indianapolis, Indiana": SportsballGeocodeTuple(
        city="Indianapolis",
        state="IN",
        postal="",
        lat=39.765278,
        lng=-86.1625,
        housenumber="100",
        country="USA",
    ),
    "Cabot Center Gym, Boston, Massachusetts": CABOT_CENTER,
    "Holt Arena, Pocatello, Idaho": ICCU_ARENA,
    "Covelli Centre, Youngstown, Ohio": SportsballGeocodeTuple(
        city="Youngstown",
        state="OH",
        postal="44503",
        lat=41.096145,
        lng=-80.647943,
        housenumber="229",
        country="USA",
    ),
    "Burton Coliseum, Lake Charles, Louisiana": SportsballGeocodeTuple(
        city="Lake Charles",
        state="LA",
        postal="70607",
        lat=30.136989,
        lng=-93.211476,
        housenumber="7001",
        country="USA",
    ),
    "Bert Ogden Arena, Edinburg, Texas": SportsballGeocodeTuple(
        city="Edinburg",
        state="TX",
        postal="78539",
        lat=26.256568,
        lng=-98.164631,
        housenumber="4900",
        country="USA",
    ),
    "Reynolds Coliseum, Raleigh, North Carolina": REYNOLDS_COLISEUM,
    "Walter E. Washington Convention Center, Washington, District of Columbia": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.9051,
        lng=-77.023,
        housenumber="801",
        country="USA",
    ),
    "Germain Arena, Estero, Florida": HERTZ_ARENA,
    "Mabee Fieldhouse, Kansas City, Kansas": SportsballGeocodeTuple(
        city="Kansas City",
        state="KS",
        postal="64145",
        lat=38.911069,
        lng=-94.5921775,
        housenumber="11901",
        country="USA",
    ),
    "Lynchburg, Virginia": SportsballGeocodeTuple(
        city="Lynchburg",
        state="VA",
        postal="",
        lat=37.403611,
        lng=-79.17,
        housenumber="",
        country="USA",
    ),
    "Lowell, Massachusetts": SportsballGeocodeTuple(
        city="Lowell",
        state="MA",
        postal="",
        lat=42.639444,
        lng=-71.314722,
        housenumber="",
        country="USA",
    ),
    "Swinney Recreation Center, Kansas City, Missouri": SportsballGeocodeTuple(
        city="Kansas City",
        state="MO",
        postal="64110",
        lat=39.03555,
        lng=-94.57876,
        housenumber="5030",
        country="USA",
    ),
    "Chase Family Arena at Reich Family Pavilion, Hartford, Connecticut": CHASE_FAMILY_ARENA,
    "Rose Garden Arena, Portland, Oregon": ROSE_GARDEN,
    "JMU Convocation Center, Harrisonburg, Virginia": SportsballGeocodeTuple(
        city="Harrisonburg",
        state="VA",
        postal="",
        lat=38.431892,
        lng=-78.868854,
        housenumber="",
        country="USA",
    ),
    "Denver, Colorado": DENVER,
    "Times Union Center, Albany, New York": TIMES_UNION_CENTER,
    "Carmichael Arena, Chapel Hill, North Carolina": SportsballGeocodeTuple(
        city="Chapel Hill",
        state="NC",
        postal="27599",
        lat=35.909526,
        lng=-79.045408,
        housenumber="310",
        country="USA",
    ),
    "Harrisonburg, Virginia": SportsballGeocodeTuple(
        city="Harrisonburg",
        state="VA",
        postal="",
        lat=38.449444,
        lng=-78.868889,
        housenumber="",
        country="USA",
    ),
    "76ers Fieldhouse, Wilmington, Delaware": SportsballGeocodeTuple(
        city="Wilmington",
        state="DE",
        postal="",
        lat=39.727582,
        lng=-75.554497,
        housenumber="401",
        country="USA",
    ),
    "Pittsburgh, Pennsylvania": PITTSBURGH,
    "Prescott Valley, Arizona": SportsballGeocodeTuple(
        city="Prescott Valley",
        state="AZ",
        postal="",
        lat=34.61,
        lng=-112.315833,
        housenumber="",
        country="USA",
    ),
    "Vines Center, Lynchburg, Virginia": SportsballGeocodeTuple(
        city="Lynchburg",
        state="VA",
        postal="24502",
        lat=37.349068,
        lng=-79.180998,
        housenumber="1971",
        country="USA",
    ),
    "HP Field House, Orlando, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Tsongas Center, Lowell, Massachusetts": TSONGAS_CENTER,
    "The Arena, Niceville, Florida": SportsballGeocodeTuple(
        city="Niceville",
        state="FL",
        postal="",
        lat=30.5394,
        lng=-86.4756,
        housenumber="300",
        country="USA",
    ),
    "Las Vegas, Nevada": LAS_VEGAS,
    "Fort Wayne, Indiana": FORT_WAYNE,
    "Portland, Maine": SportsballGeocodeTuple(
        city="Portland",
        state="ME",
        postal="",
        lat=43.66,
        lng=-70.255,
        housenumber="",
        country="USA",
    ),
    "Gateway Christian Academy, Bimini": SportsballGeocodeTuple(
        city="",
        state="Bimini",
        postal="",
        lat=25.7433101,
        lng=-79.2883217,
        housenumber="",
        country="Bahamas",
    ),
    "Orlando, Florida": SportsballGeocodeTuple(
        city="Orlando",
        state="FL",
        postal="",
        lat=28.54,
        lng=-81.38,
        housenumber="",
        country="USA",
    ),
    "Kissimmee, Florida": SportsballGeocodeTuple(
        city="Kissimmee",
        state="FL",
        postal="",
        lat=28.304167,
        lng=-81.412778,
        housenumber="",
        country="USA",
    ),
    "Alaska Airlines Center, Anchorage, Alaska": SportsballGeocodeTuple(
        city="Anchorage",
        state="AL",
        postal="",
        lat=61.188056,
        lng=-149.812222,
        housenumber="3550",
        country="USA",
    ),
    "Baoshan Sports Center, Shanghai": SportsballGeocodeTuple(
        city="Shanghai",
        state="",
        postal="",
        lat=31.395225,
        lng=121.491842,
        housenumber="",
        country="China",
    ),
    "New Brunswick, New Jersey": SportsballGeocodeTuple(
        city="New Brunswick",
        state="NJ",
        postal="",
        lat=40.486678,
        lng=-74.444414,
        housenumber="",
        country="USA",
    ),
    "SIU Arena, Carbondale, Illinois": SIU_ARENA,
    "Boise, Idaho": SportsballGeocodeTuple(
        city="Boise",
        state="ID",
        postal="",
        lat=43.615833,
        lng=-116.201667,
        housenumber="",
        country="USA",
    ),
    "Power Balance Pavilion, Sacramento, California": ARCO_ARENA,
    "Von Braun Center, Hunstville, Alabama": SportsballGeocodeTuple(
        city="Huntsville",
        state="AL",
        postal="",
        lat=34.72699,
        lng=-86.590887,
        housenumber="700",
        country="USA",
    ),
    "Bradley Center, Milwaukee, Wisconsin": BRADLEY_CENTER,
    "Toyota Center, Kennewick, Washington": TOYOTA_CENTER,
    "Los Angeles, California": LOS_ANGELES,
    "Newark, New Jersey": NEWARK,
    "SSE Arena, Belfast": SportsballGeocodeTuple(
        city="Belfast",
        state="",
        postal="BT3 9QQ",
        lat=54.604167,
        lng=-5.915,
        housenumber="2",
        country="UK",
    ),
    "Pocatello, Idaho": SportsballGeocodeTuple(
        city="Pocatello",
        state="ID",
        postal="",
        lat=42.862222,
        lng=-112.450556,
        housenumber="",
        country="USA",
    ),
    "Seattle, Washington": SEATTLE,
    "Amway Arena, Orlando, Florida": ORLANDO_ARENA,
    "Izod Center, East Rutherford, New Jersey": SportsballGeocodeTuple(
        city="East Rutherford",
        state="NJ",
        postal="",
        lat=40.811667,
        lng=-74.0675,
        housenumber="50",
        country="USA",
    ),
    "Baltimore, Maryland": BALTIMORE,
    "Coraopolis, Pennsylvania": SportsballGeocodeTuple(
        city="Coraopolis",
        state="PA",
        postal="",
        lat=40.515817,
        lng=-80.162792,
        housenumber="",
        country="USA",
    ),
    "Tiger Arena, Savannah, Georgia": SportsballGeocodeTuple(
        city="Savannah",
        state="GA",
        postal="",
        lat=32.02376,
        lng=-81.0658,
        housenumber="",
        country="USA",
    ),
    "ARCO Arena (II), Sacramento, California": ARCO_ARENA,
    "Nashville Municipal Auditorium, Nashville, Tennessee": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.10,
        lng=-86.46,
        housenumber="417",
        country="USA",
    ),
    "Rosemont, Illinois": SportsballGeocodeTuple(
        city="Rosemont",
        state="IL",
        postal="",
        lat=41.990833,
        lng=-87.873889,
        housenumber="",
        country="USA",
    ),
    "Greensboro, North Carolina": GREENSBORO,
    "Elon, North Carolina": ELON,
    "Mercedes-Benz Arena, Shanghai": SportsballGeocodeTuple(
        city="Shanghai",
        state="",
        postal="",
        lat=31.91,
        lng=121.48,
        housenumber="",
        country="China",
    ),
    "Continental Airlines Arena, East Rutherford, New Jersey": SportsballGeocodeTuple(
        city="East Rutherford",
        state="NJ",
        postal="",
        lat=40.811667,
        lng=-74.0675,
        housenumber="50",
        country="USA",
    ),
    "Brooks Gym, Johnson City, Tennessee": SportsballGeocodeTuple(
        city="Johnson City",
        state="TN",
        postal="37614",
        lat=36.3025963,
        lng=-82.3703615,
        housenumber="1127",
        country="USA",
    ),
    "Qubein Center, High Point, North Carolina": SportsballGeocodeTuple(
        city="High Point",
        state="NC",
        postal="27262",
        lat=35.978333,
        lng=-79.996667,
        housenumber="1050",
        country="USA",
    ),
    "TD Waterhouse Centre, Orlando, Florida": ORLANDO_ARENA,
    "Charlotte Coliseum, Charlotte, North Carolina": CHARLOTTE_COLISEUM,
    "Pyramid Arena, Memphis, Tennessee": SportsballGeocodeTuple(
        city="Memphis",
        state="TN",
        postal="",
        lat=35.155556,
        lng=-90.051944,
        housenumber="1",
        country="USA",
    ),
    "Renaissance Coliseum, Peoria, Illinois": SportsballGeocodeTuple(
        city="Peoria",
        state="IL",
        postal="",
        lat=40.699167,
        lng=-89.617778,
        housenumber="",
        country="USA",
    ),
    "Compaq Center, Houston, Texas": COMPAQ_CENTER,
    "Reunion Arena, Dallas, Texas": REUNION_ARENA,
    "Merrell Center, Katy, Texas": MERRELL_CENTER,
    "McNichols Sports Arena, Denver, Colorado": MCNICHOLS_SPORTS_ARENA,
    "Freedom Hall, Louisville, Kentucky": FREEDOM_HALL,
    "HemisFair Arena, San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="78203",
        lat=29.420134,
        lng=-98.483299,
        housenumber="601",
        country="USA",
    ),
    "Market Square Arena, Indianapolis, Indiana": MARKET_SQUARE_ARENA,
    "Hampton Coliseum, Hampton, Virginia": SportsballGeocodeTuple(
        city="Hampton",
        state="VA",
        postal="23666",
        lat=37.034725,
        lng=-76.381339,
        housenumber="1000",
        country="USA",
    ),
    "Richmond Coliseum, Richmond, Virginia": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="23219",
        lat=37.544705,
        lng=-77.434484,
        housenumber="601",
        country="USA",
    ),
    "Salt Palace, Salt Lake City, Utah": SportsballGeocodeTuple(
        city="Salt Lake City",
        state="UT",
        postal="",
        lat=40.766944,
        lng=-111.895,
        housenumber="100",
        country="USA",
    ),
    "Hulman Civic-University Center, Terre Haute, Indiana": HULMAN_CENTER,
    "San Diego Sports Arena, San Diego, California": SAN_DIEGO_SPORTS_ARENA,
    "Denver Auditorium Arena, Denver, Colorado": SportsballGeocodeTuple(
        city="Denver",
        state="CO",
        postal="80204",
        lat=39.744444,
        lng=-104.9975,
        housenumber="1323",
        country="USA",
    ),
    "Mid-South Coliseum, Memphis, Tennessee": MID_SOUTH_COLISEUM,
    "Memorial Coliseum, Lexington, Kentucky": SportsballGeocodeTuple(
        city="Lexington",
        state="KT",
        postal="40508",
        lat=38.0394636,
        lng=-84.5004952,
        housenumber="",
        country="USA",
    ),
    "Indiana State Fair Coliseum, Indianapolis, Indiana": SportsballGeocodeTuple(
        city="Indianapolis",
        state="IN",
        postal="",
        lat=39.8275,
        lng=-86.135,
        housenumber="1202",
        country="USA",
    ),
    "Golden Hall, San Diego, California": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="92101",
        lat=32.7507735,
        lng=-117.1008248,
        housenumber="9",
        country="USA",
    ),
    "Tuscaloosa, Alabama": SportsballGeocodeTuple(
        city="Tuscaloosa",
        state="AL",
        postal="",
        lat=33.209722,
        lng=-87.569167,
        housenumber="",
        country="USA",
    ),
    "Lubbock, Texas": LUBBOCK,
    "Chestnut Hill, Massachusetts": SportsballGeocodeTuple(
        city="Chestnut Hill",
        state="MA",
        postal="",
        lat=42.330556,
        lng=-71.166111,
        housenumber="",
        country="USA",
    ),
    "Minneapolis, Minnesota": MINNEAPOLIS,
    "Ann Arbor, Michigan": SportsballGeocodeTuple(
        city="Ann Arbor",
        state="MI",
        postal="",
        lat=42.281389,
        lng=-83.748333,
        housenumber="",
        country="USA",
    ),
    "Norman, Oklahoma": NORMAN,
    "Greenville, South Carolina": GREENVILLE,
    "Storrs, Connecticut": SportsballGeocodeTuple(
        city="Storrs",
        state="CT",
        postal="",
        lat=41.808333,
        lng=-72.249444,
        housenumber="",
        country="USA",
    ),
    "Muncie, Indiana": SportsballGeocodeTuple(
        city="Muncie",
        state="IN",
        postal="",
        lat=40.196667,
        lng=-85.375,
        housenumber="",
        country="USA",
    ),
    "Bowling Green, Ohio": SportsballGeocodeTuple(
        city="Bowling Green",
        state="OH",
        postal="",
        lat=41.373889,
        lng=-83.650833,
        housenumber="",
        country="USA",
    ),
    "Annapolis, Maryland": SportsballGeocodeTuple(
        city="Annapolis",
        state="MD",
        postal="",
        lat=38.973056,
        lng=-76.501111,
        housenumber="",
        country="USA",
    ),
    "Providence, Rhode Island": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="",
        lat=41.823611,
        lng=-71.422222,
        housenumber="",
        country="USA",
    ),
    "St. Bonaventure, New York": SportsballGeocodeTuple(
        city="St. Bonaventure",
        state="NY",
        postal="",
        lat=42.080278,
        lng=-78.475,
        housenumber="",
        country="USA",
    ),
    "Pensacola, Florida": PENSACOLA,
    "Johnson City, Tennessee": SportsballGeocodeTuple(
        city="Johnson City",
        state="TN",
        postal="",
        lat=36.333333,
        lng=-82.366667,
        housenumber="",
        country="USA",
    ),
    "Hamilton, New York": SportsballGeocodeTuple(
        city="Hamilton",
        state="NY",
        postal="",
        lat=42.829167,
        lng=-75.552778,
        housenumber="",
        country="USA",
    ),
    "New Britain, Connecticut": SportsballGeocodeTuple(
        city="New Britain",
        state="CT",
        postal="",
        lat=41.675,
        lng=-72.787222,
        housenumber="",
        country="USA",
    ),
    "Teaneck, New Jersey": SportsballGeocodeTuple(
        city="Teaneck",
        state="NJ",
        postal="",
        lat=40.890317,
        lng=-74.011478,
        housenumber="",
        country="USA",
    ),
    "Bronx, New York": BRONX,
    "Fairfax, Virginia": SportsballGeocodeTuple(
        city="Fairfax",
        state="VA",
        postal="",
        lat=38.8525,
        lng=-77.304167,
        housenumber="",
        country="USA",
    ),
    "Oxford, Ohio": OXFORD,
    "Raleigh, North Carolina": RALEIGH,
    "DeKalb, Illinois": SportsballGeocodeTuple(
        city="DeKalb",
        state="IL",
        postal="",
        lat=41.931389,
        lng=-88.750278,
        housenumber="",
        country="USA",
    ),
    "Natchitoches, Louisiana": NATCHITOCHES,
    "Athens, Ohio": SportsballGeocodeTuple(
        city="Athens",
        state="OH",
        postal="",
        lat=39.329167,
        lng=-82.096111,
        housenumber="",
        country="USA",
    ),
    "Philadelphia, Pennsylvania": PHILADELPHIA,
    "South Bend, Indiana": SportsballGeocodeTuple(
        city="South Bend",
        state="IN",
        postal="",
        lat=41.676389,
        lng=-86.269444,
        housenumber="",
        country="USA",
    ),
    "Laramie, Wyoming": SportsballGeocodeTuple(
        city="Laramie",
        state="WY",
        postal="",
        lat=41.311111,
        lng=-105.593611,
        housenumber="",
        country="USA",
    ),
    "College Station, Texas": SportsballGeocodeTuple(
        city="College Station",
        state="TX",
        postal="",
        lat=30.601389,
        lng=-96.314444,
        housenumber="",
        country="USA",
    ),
    "Ames, Iowa": AMES,
    "San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="",
        lat=29.425,
        lng=-98.493889,
        housenumber="",
        country="USA",
    ),
    "West Lafayette, Indiana": SportsballGeocodeTuple(
        city="West Lafayette",
        state="IN",
        postal="",
        lat=40.443333,
        lng=-86.923611,
        housenumber="",
        country="USA",
    ),
    "Lexington, Kentucky": SportsballGeocodeTuple(
        city="Lexington",
        state="KT",
        postal="",
        lat=38.046389,
        lng=-84.496944,
        housenumber="",
        country="USA",
    ),
    "Tucson, Arizona": SportsballGeocodeTuple(
        city="Tucson",
        state="AZ",
        postal="",
        lat=32.221667,
        lng=-110.926389,
        housenumber="",
        country="USA",
    ),
    "Starkville, Mississippi": STARKVILLE,
    "Smithfield, Rhode Island": SportsballGeocodeTuple(
        city="Smithfield",
        state="RI",
        postal="",
        lat=41.9,
        lng=-71.533333,
        housenumber="",
        country="USA",
    ),
    "Dayton, Ohio": DAYTON,
    "Greenville, North Carolina": SportsballGeocodeTuple(
        city="Greenville",
        state="NC",
        postal="",
        lat=35.594444,
        lng=-77.376111,
        housenumber="",
        country="USA",
    ),
    "Orono, Maine": SportsballGeocodeTuple(
        city="Orono",
        state="ME",
        postal="",
        lat=44.883333,
        lng=-68.672222,
        housenumber="",
        country="USA",
    ),
    "Columbus, Ohio": COLUMBUS,
    "Reno, Nevada": RENO,
    "San Jose, California": SAN_JOSE,
    "Columbia, South Carolina": SportsballGeocodeTuple(
        city="Columbia",
        state="SC",
        postal="",
        lat=34.000556,
        lng=-81.034722,
        housenumber="",
        country="USA",
    ),
    "Birmingham, Alabama": BIRMINGHAM,
    "Buffalo, New York": BUFFALO,
    "Easton, Pennsylvania": SportsballGeocodeTuple(
        city="Easton",
        state="PA",
        postal="",
        lat=40.688333,
        lng=-75.216389,
        housenumber="",
        country="USA",
    ),
    "Highland Heights, Kentucky": SportsballGeocodeTuple(
        city="Highland Heights",
        state="KT",
        postal="",
        lat=39.035556,
        lng=-84.456667,
        housenumber="",
        country="USA",
    ),
    "Rochester, Michigan": SportsballGeocodeTuple(
        city="Rochester",
        state="MI",
        postal="",
        lat=42.680556,
        lng=-83.133889,
        housenumber="",
        country="USA",
    ),
    "Toledo, Ohio": TOLEDO,
    "Burlington, Vermont": SportsballGeocodeTuple(
        city="Burlington",
        state="VT",
        postal="",
        lat=44.475833,
        lng=-73.211944,
        housenumber="",
        country="USA",
    ),
    "Blacksburg, Virginia": SportsballGeocodeTuple(
        city="Blacksburg",
        state="VI",
        postal="",
        lat=37.23,
        lng=-80.417778,
        housenumber="",
        country="USA",
    ),
    "Kalamazoo, Michigan": SportsballGeocodeTuple(
        city="Kalamazoo",
        state="MI",
        postal="",
        lat=42.29,
        lng=-85.585833,
        housenumber="",
        country="USA",
    ),
    "Colorado Springs, Colorado": SportsballGeocodeTuple(
        city="Colorado Springs",
        state="CO",
        postal="",
        lat=38.833889,
        lng=-104.825278,
        housenumber="",
        country="USA",
    ),
    "Fort Collins, Colorado": SportsballGeocodeTuple(
        city="Fort Collins",
        state="CO",
        postal="",
        lat=40.559167,
        lng=-105.078056,
        housenumber="",
        country="USA",
    ),
    "Eugene, Oregon": EUGENE,
    "Charlottesville, Virginia": SportsballGeocodeTuple(
        city="Charlottesville",
        state="VI",
        postal="",
        lat=38.0299,
        lng=-78.479,
        housenumber="",
        country="USA",
    ),
    "Fresno, California": FRESNO,
    "War Memorial Coliseum, Fort Wayne, Indiana": ALLEN_COUNTY_WAR_MEMORIAL_COLISEUM,
    "Peterson Gym, San Diego, California": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.7742,
        lng=-117.0768,
        housenumber="5340",
        country="USA",
    ),
    "St. Paul Civic Center, St. Paul, Minnesota": SportsballGeocodeTuple(
        city="St. Paul",
        state="MN",
        postal="55102",
        lat=39.4285806,
        lng=-85.6296931,
        housenumber="143",
        country="USA",
    ),
    "Riverdale, New York": SportsballGeocodeTuple(
        city="Riverdale",
        state="NY",
        postal="",
        lat=40.894,
        lng=-73.913,
        housenumber="",
        country="USA",
    ),
    "North Andover, Massachusetts": SportsballGeocodeTuple(
        city="North Andover",
        state="MA",
        postal="",
        lat=42.698611,
        lng=-71.135556,
        housenumber="",
        country="USA",
    ),
    "Niagara University, New York": SportsballGeocodeTuple(
        city="Niagara University",
        state="NY",
        postal="",
        lat=43.138,
        lng=-79.037,
        housenumber="",
        country="USA",
    ),
    "Wilmington, North Carolina": SportsballGeocodeTuple(
        city="Wilmington",
        state="NC",
        postal="",
        lat=34.21,
        lng=-77.886667,
        housenumber="",
        country="USA",
    ),
    "Jersey City, New Jersey": SportsballGeocodeTuple(
        city="Jersey City",
        state="NJ",
        postal="",
        lat=40.71,
        lng=-74.06,
        housenumber="",
        country="USA",
    ),
    "Orangeburg, South Carolina": SportsballGeocodeTuple(
        city="Orangeburg",
        state="SC",
        postal="",
        lat=33.491944,
        lng=-80.855278,
        housenumber="",
        country="USA",
    ),
    "Pine Bluff, Arkansas": SportsballGeocodeTuple(
        city="Pine Bluff",
        state="AR",
        postal="",
        lat=34.228333,
        lng=-92.0,
        housenumber="",
        country="USA",
    ),
    "Grambling, Louisiana": SportsballGeocodeTuple(
        city="Grambling",
        state="LA",
        postal="",
        lat=32.5275,
        lng=-92.713889,
        housenumber="",
        country="USA",
    ),
    "Murfreesboro, Tennessee": SportsballGeocodeTuple(
        city="Murfreesboro",
        state="TN",
        postal="",
        lat=35.846111,
        lng=-86.391944,
        housenumber="",
        country="USA",
    ),
    "Itta Bena, Mississippi": SportsballGeocodeTuple(
        city="Itta Bena",
        state="MS",
        postal="",
        lat=33.4975,
        lng=-90.324444,
        housenumber="",
        country="USA",
    ),
    "Huntsville, Texas": SportsballGeocodeTuple(
        city="Huntsville",
        state="TX",
        postal="",
        lat=30.722222,
        lng=-95.553333,
        housenumber="",
        country="USA",
    ),
    "Baton Rouge, Louisiana": BATON_ROUGE,
    "Bowling Green, Kentucky": SportsballGeocodeTuple(
        city="Bowling Green",
        state="KT",
        postal="",
        lat=36.981667,
        lng=-86.444444,
        housenumber="",
        country="USA",
    ),
    "Davis, California": SportsballGeocodeTuple(
        city="Davis",
        state="CA",
        postal="",
        lat=38.553889,
        lng=-121.738056,
        housenumber="",
        country="USA",
    ),
    "ExploreAsheville.com Arena, Asheville, North Carolina": HARRAHS_CHEROKEE_CENTER,
    "Dover, Delaware": SportsballGeocodeTuple(
        city="Dover",
        state="DE",
        postal="",
        lat=39.158056,
        lng=-75.524444,
        housenumber="",
        country="USA",
    ),
    "Moon, Pennsylvania": SportsballGeocodeTuple(
        city="Moon",
        state="PA",
        postal="",
        lat=40.516667,
        lng=-80.233333,
        housenumber="",
        country="USA",
    ),
    "Fair Park, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.4968,
        lng=-86.8714,
        housenumber="",
        country="USA",
    ),
    "Newark, Delaware": SportsballGeocodeTuple(
        city="Newark",
        state="DE",
        postal="",
        lat=39.683611,
        lng=-75.749722,
        housenumber="",
        country="USA",
    ),
    "Hempstead, New York": HEMPSTEAD,
    "Boston, Massachusetts": BOSTON,
    "Lewisburg, Pennsylvania": SportsballGeocodeTuple(
        city="Lewisburg",
        state="PA",
        postal="",
        lat=40.963889,
        lng=-76.888056,
        housenumber="",
        country="USA",
    ),
    "Terre Haute, Indiana": SportsballGeocodeTuple(
        city="Terre Haute",
        state="IN",
        postal="",
        lat=39.469722,
        lng=-87.389722,
        housenumber="",
        country="USA",
    ),
    "Ruston, Louisiana": SportsballGeocodeTuple(
        city="Ruston",
        state="LA",
        postal="",
        lat=32.529722,
        lng=-92.640556,
        housenumber="",
        country="USA",
    ),
    "Poughkeepsie, New York": SportsballGeocodeTuple(
        city="Poughkeepsie",
        state="NY",
        postal="",
        lat=41.703889,
        lng=-73.93,
        housenumber="",
        country="USA",
    ),
    "Springfield, Missouri": SportsballGeocodeTuple(
        city="Springfield",
        state="MO",
        postal="",
        lat=37.215278,
        lng=-93.298333,
        housenumber="",
        country="USA",
    ),
    "West Long Branch, New Jersey": SportsballGeocodeTuple(
        city="West Long Branch",
        state="NJ",
        postal="",
        lat=40.287904,
        lng=-74.020019,
        housenumber="",
        country="USA",
    ),
    "Emmitsburg, Maryland": SportsballGeocodeTuple(
        city="Emmitsburg",
        state="MD",
        postal="",
        lat=39.704167,
        lng=-77.321111,
        housenumber="",
        country="USA",
    ),
    "Florence, Alabama": SportsballGeocodeTuple(
        city="Florence",
        state="AL",
        postal="",
        lat=34.83035,
        lng=-87.665419,
        housenumber="",
        country="USA",
    ),
    "Lawrenceville, New Jersey": SportsballGeocodeTuple(
        city="Lawrenceville",
        state="NJ",
        postal="",
        lat=40.302787,
        lng=-74.738004,
        housenumber="",
        country="USA",
    ),
    "Albany, New York": SportsballGeocodeTuple(
        city="Albany",
        state="NY",
        postal="",
        lat=42.6525,
        lng=-73.757222,
        housenumber="",
        country="USA",
    ),
    "Carbondale, Illinois": SportsballGeocodeTuple(
        city="Carbondale",
        state="IL",
        postal="",
        lat=37.722222,
        lng=-89.258333,
        housenumber="",
        country="USA",
    ),
    "Staten Island, New York": STATEN_ISLAND,
    "Abilene, Texas": SportsballGeocodeTuple(
        city="Abilene",
        state="TX",
        postal="",
        lat=32.45,
        lng=-99.75,
        housenumber="",
        country="USA",
    ),
    "Green Bay, Wisconsin": GREEN_BAY,
    "Las Cruces, New Mexico": SportsballGeocodeTuple(
        city="Las Cruces",
        state="NM",
        postal="",
        lat=32.314444,
        lng=-106.778889,
        housenumber="",
        country="USA",
    ),
    "Stephenville, Texas": SportsballGeocodeTuple(
        city="Stephenville",
        state="TX",
        postal="",
        lat=32.209722,
        lng=-98.2375,
        housenumber="",
        country="USA",
    ),
    "Orem, Utah": SportsballGeocodeTuple(
        city="Orem",
        state="UT",
        postal="",
        lat=40.290556,
        lng=-111.729722,
        housenumber="",
        country="USA",
    ),
    "Bakersfield, California": SportsballGeocodeTuple(
        city="Bakersfield",
        state="CA",
        postal="",
        lat=35.373333,
        lng=-119.018889,
        housenumber="",
        country="USA",
    ),
    "Northridge, California": SportsballGeocodeTuple(
        city="Northridge",
        state="CA",
        postal="",
        lat=34.228056,
        lng=-118.535833,
        housenumber="",
        country="USA",
    ),
    "St. George, Utah": ST_GEORGE,
    "Long Beach, California": LONG_BEACH,
    "El Paso, Texas": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="",
        lat=31.759167,
        lng=-106.488611,
        housenumber="",
        country="USA",
    ),
    "San Luis Obispo, California": SportsballGeocodeTuple(
        city="San Luis Obispo",
        state="CA",
        postal="",
        lat=35.274167,
        lng=-120.663056,
        housenumber="",
        country="USA",
    ),
    "Fullerton, California": SportsballGeocodeTuple(
        city="Fullerton",
        state="CA",
        postal="",
        lat=33.88,
        lng=-117.928611,
        housenumber="",
        country="USA",
    ),
    "Riverside, California": RIVERSIDE,
    "La Jolla, California": SportsballGeocodeTuple(
        city="La Jolla",
        state="CA",
        postal="",
        lat=32.84,
        lng=-117.276944,
        housenumber="",
        country="USA",
    ),
    "Anderson High School Wigwam, Anderson, Indiana": SportsballGeocodeTuple(
        city="Anderson",
        state="IN",
        postal="",
        lat=40.103056,
        lng=-85.685833,
        housenumber="1229",
        country="USA",
    ),
    "Miami-Dade Junior College North, Miami, Florida": SportsballGeocodeTuple(
        city="Miami",
        state="FL",
        postal="",
        lat=25.777778,
        lng=-80.190556,
        housenumber="1229",
        country="USA",
    ),
    "Miami Beach Convention Hall, Miami Beach, Florida": MIAMI_BEACH_CONVENTION_CENTER,
    "Curtis Hixon Hall, Tampa, Florida": SportsballGeocodeTuple(
        city="Tampa",
        state="FL",
        postal="",
        lat=27.949167,
        lng=-82.461944,
        housenumber="",
        country="USA",
    ),
    "Winston-Salem Memorial Coliseum, Winston-Salem, North Carolina": SportsballGeocodeTuple(
        city="Winston-Salem",
        state="NC",
        postal="",
        lat=36.1262,
        lng=-80.2581,
        housenumber="",
        country="USA",
    ),
    "Uniontown High School, Uniontown, Pennsylvania": SportsballGeocodeTuple(
        city="Uniontown",
        state="PA",
        postal="",
        lat=39.89632,
        lng=-79.72016,
        housenumber="",
        country="USA",
    ),
    "Island Garden, West Hempstead, New York": SportsballGeocodeTuple(
        city="West Hempstead",
        state="NY",
        postal="",
        lat=40.707222,
        lng=-73.656667,
        housenumber="",
        country="USA",
    ),
    "Roanoke Civic Center, Roanoke, Virginia": SportsballGeocodeTuple(
        city="Roanoke",
        state="VA",
        postal="24016",
        lat=37.280171,
        lng=-79.935669,
        housenumber="710",
        country="USA",
    ),
    "Maple Leaf Gardens, Toronto, Canada": MAPLE_LEAF_GARDENS,
    "Utah State Spectrum, Logan, Utah": SMITH_SPECTRUM,
    "Bayfront Arena, St. Petersburg, Florida": SportsballGeocodeTuple(
        city="St. Petersburg",
        state="FL",
        postal="",
        lat=27.766583,
        lng=-82.631694,
        housenumber="400",
        country="USA",
    ),
    "Richmond Arena, Richmond, Virginia": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="",
        lat=37.569855,
        lng=-77.462411,
        housenumber="400",
        country="USA",
    ),
    "Mt. Pleasant, Michigan": SportsballGeocodeTuple(
        city="Mt. Pleasant",
        state="MI",
        postal="",
        lat=43.597778,
        lng=-84.7675,
        housenumber="",
        country="USA",
    ),
    "Conway, Arkansas": SportsballGeocodeTuple(
        city="Conway",
        state="AR",
        postal="",
        lat=35.087222,
        lng=-92.453333,
        housenumber="",
        country="USA",
    ),
    "Kent, Ohio": SportsballGeocodeTuple(
        city="Kent",
        state="OH",
        postal="",
        lat=41.149167,
        lng=-81.360833,
        housenumber="",
        country="USA",
    ),
    "Hofstra Physical Fitness Center, Hempstead, New York": SportsballGeocodeTuple(
        city="Hempstead",
        state="NY",
        postal="",
        lat=40.7216566,
        lng=-73.5998583,
        housenumber="",
        country="USA",
    ),
    "Jacksonville Coliseum, Jacksonville, Florida": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="32202",
        lat=30.324596,
        lng=-81.640901,
        housenumber="1145",
        country="USA",
    ),
    "Moby Gym, Ft. Collins, Colorado": MOBY_ARENA,
    "Salem Civic Center, Salem, Virginia": SportsballGeocodeTuple(
        city="Salem",
        state="VA",
        postal="",
        lat=37.283889,
        lng=-80.040833,
        housenumber="",
        country="USA",
    ),
    "Tarrant County Convention Center, Ft. Worth, Texas": SportsballGeocodeTuple(
        city="Ft. Worth",
        state="TX",
        postal="76102",
        lat=32.749,
        lng=-97.3277,
        housenumber="12",
        country="USA",
    ),
    "Lubbock Municipal Coliseum, Lubbock, Texas": SportsballGeocodeTuple(
        city="Lubbock",
        state="TX",
        postal="79409",
        lat=33.59,
        lng=-101.8775,
        housenumber="2720",
        country="USA",
    ),
    "Dorton Arena, Raleigh, North Carolina": DORTON_ARENA,
    "J.S. Dorton Arena, Raleigh, North Carolina": DORTON_ARENA,
    "West Palm Beach Auditorium, West Palm Beach, Florida": SportsballGeocodeTuple(
        city="West Palm Beach",
        state="FL",
        postal="33401",
        lat=26.723611,
        lng=-80.082222,
        housenumber="1610",
        country="USA",
    ),
    "Sikeston Field House, Sikeston, Missouri": SportsballGeocodeTuple(
        city="Sikeston",
        state="MO",
        postal="63801",
        lat=36.87943,
        lng=-89.57209,
        housenumber="200",
        country="USA",
    ),
    "Swenson Gym, Ogden, Utah": SportsballGeocodeTuple(
        city="Ogden",
        state="UT",
        postal="",
        lat=41.190833,
        lng=-111.941944,
        housenumber="1356",
        country="USA",
    ),
    "Auburn, Alabama": SportsballGeocodeTuple(
        city="Auburn",
        state="AL",
        postal="",
        lat=32.597778,
        lng=-85.480833,
        housenumber="",
        country="USA",
    ),
    "Chapel Hill, North Carolina": SportsballGeocodeTuple(
        city="Chapel Hill",
        state="NC",
        postal="",
        lat=35.927222,
        lng=-79.039167,
        housenumber="",
        country="USA",
    ),
    "Knoxville, Tennessee": KNOXVILLE,
    "Gainesville, Florida": GAINESVILLE,
    "Tempe, Arizona": TEMPE,
    "Manhattan, Kansas": MANHATTAN,
    "Clemson, South Carolina": SportsballGeocodeTuple(
        city="Clemson",
        state="SC",
        postal="",
        lat=34.685,
        lng=-82.814722,
        housenumber="",
        country="USA",
    ),
    "Madison, Wisconsin": MADISON,
    "College Park, Maryland": SportsballGeocodeTuple(
        city="College Park",
        state="MD",
        postal="",
        lat=38.996667,
        lng=-76.9275,
        housenumber="",
        country="USA",
    ),
    "Columbia, Missouri": SportsballGeocodeTuple(
        city="Columbia",
        state="MO",
        postal="",
        lat=38.9475,
        lng=-92.326667,
        housenumber="",
        country="USA",
    ),
    "Provo, Utah": SportsballGeocodeTuple(
        city="Provo",
        state="UT",
        postal="",
        lat=40.244444,
        lng=-111.660833,
        housenumber="",
        country="USA",
    ),
    "Lawrence, Kansas": SportsballGeocodeTuple(
        city="Lawrence",
        state="KS",
        postal="",
        lat=38.959722,
        lng=-95.264167,
        housenumber="",
        country="USA",
    ),
    "Fayetteville, Arkansas": SportsballGeocodeTuple(
        city="Fayetteville",
        state="AR",
        postal="",
        lat=36.0625,
        lng=-94.1575,
        housenumber="",
        country="USA",
    ),
    "Buies Creek, North Carolina": SportsballGeocodeTuple(
        city="Buies Creek",
        state="NC",
        postal="",
        lat=35.408056,
        lng=-78.741389,
        housenumber="",
        country="USA",
    ),
    "Ithaca, New York": SportsballGeocodeTuple(
        city="Ithaca",
        state="NY",
        postal="",
        lat=42.443333,
        lng=-76.5,
        housenumber="",
        country="USA",
    ),
    "Bloomington, Indiana": SportsballGeocodeTuple(
        city="Bloomington",
        state="IN",
        postal="",
        lat=39.162222,
        lng=-86.522222,
        housenumber="",
        country="USA",
    ),
    "Kennesaw, Georgia": SportsballGeocodeTuple(
        city="Kennesaw",
        state="GA",
        postal="",
        lat=34.023333,
        lng=-84.615278,
        housenumber="",
        country="USA",
    ),
    "Amherst, Massachusetts": SportsballGeocodeTuple(
        city="Amherst",
        state="MA",
        postal="",
        lat=42.383333,
        lng=-72.516667,
        housenumber="",
        country="USA",
    ),
    "Richmond, Virginia": RICHMOND,
    "Syracuse, New York": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="",
        lat=43.046944,
        lng=-76.144444,
        housenumber="",
        country="USA",
    ),
    "Morgantown, West Virginia": SportsballGeocodeTuple(
        city="Morgantown",
        state="WV",
        postal="",
        lat=39.633611,
        lng=-79.950556,
        housenumber="",
        country="USA",
    ),
    "Omaha, Nebraska": SportsballGeocodeTuple(
        city="Omaha",
        state="NE",
        postal="",
        lat=41.258611,
        lng=-95.9375,
        housenumber="",
        country="USA",
    ),
    "Santa Barbara, California": SportsballGeocodeTuple(
        city="Santa Barbara",
        state="CA",
        postal="",
        lat=34.416667,
        lng=-119.7,
        housenumber="",
        country="USA",
    ),
    "Stony Brook, New York": SportsballGeocodeTuple(
        city="Stony Brook",
        state="NY",
        postal="",
        lat=40.906389,
        lng=-73.128333,
        housenumber="",
        country="USA",
    ),
    "Hanover, New Hampshire": SportsballGeocodeTuple(
        city="Hanover",
        state="NH",
        postal="",
        lat=43.702222,
        lng=-72.289444,
        housenumber="",
        country="USA",
    ),
    "Davidson, North Carolina": SportsballGeocodeTuple(
        city="Davidson",
        state="NC",
        postal="",
        lat=35.500556,
        lng=-80.846944,
        housenumber="",
        country="USA",
    ),
    "Ypsilanti, Michigan": SportsballGeocodeTuple(
        city="Ypsilanti",
        state="MI",
        postal="",
        lat=42.242778,
        lng=-83.618333,
        housenumber="",
        country="USA",
    ),
    "Daytona Beach, Florida": DAYTONA_BEACH,
    "Richmond, Kentucky": SportsballGeocodeTuple(
        city="Richmond",
        state="KT",
        postal="",
        lat=37.731111,
        lng=-84.293889,
        housenumber="",
        country="USA",
    ),
    "Jacksonville, Alabama": SportsballGeocodeTuple(
        city="Jacksonville",
        state="AL",
        postal="",
        lat=33.815833,
        lng=-85.760556,
        housenumber="",
        country="USA",
    ),
    "Stillwater, Oklahoma": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="",
        lat=36.116,
        lng=-97.059,
        housenumber="",
        country="USA",
    ),
    "Arlington, Texas": ARLINGTON,
    "Boulder, Colorado": SportsballGeocodeTuple(
        city="Boulder",
        state="CO",
        postal="",
        lat=40.015,
        lng=-105.2705,
        housenumber="",
        country="USA",
    ),
    "New Rochelle, New York": SportsballGeocodeTuple(
        city="New Rochelle",
        state="NY",
        postal="",
        lat=40.908611,
        lng=-73.781944,
        housenumber="",
        country="USA",
    ),
    "Logan, Utah": SportsballGeocodeTuple(
        city="Logan",
        state="UT",
        postal="",
        lat=41.763889,
        lng=-111.8725,
        housenumber="",
        country="USA",
    ),
    "Prairie View, Texas": SportsballGeocodeTuple(
        city="Prairie View",
        state="TX",
        postal="",
        lat=30.082222,
        lng=-95.991667,
        housenumber="",
        country="USA",
    ),
    "Bangor, Maine": SportsballGeocodeTuple(
        city="Bangor",
        state="ME",
        postal="",
        lat=44.803056,
        lng=-68.7675,
        housenumber="",
        country="USA",
    ),
    "Louisville Convention Center, Louisville, Kentucky": SportsballGeocodeTuple(
        city="Louisville",
        state="KT",
        postal="",
        lat=38.254194,
        lng=-85.755111,
        housenumber="",
        country="USA",
    ),
    "Long Beach Arena, Long Beach, California": LONG_BEACH_ARENA,
    "Uline Arena, Washington, District of Columbia": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.905,
        lng=-77.003056,
        housenumber="",
        country="USA",
    ),
    "Selland Arena, Fresno, California": SELLAND_ARENA,
    "Reid Gymnasium, Cullowhee, North Carolina": SportsballGeocodeTuple(
        city="Cullowhee",
        state="NC",
        postal="",
        lat=35.3102321,
        lng=-83.1838092,
        housenumber="",
        country="USA",
    ),
    "Community Arena, Steubenville, Ohio": SportsballGeocodeTuple(
        city="Steubenville",
        state="OH",
        postal="",
        lat=40.369477,
        lng=-80.662254,
        housenumber="",
        country="USA",
    ),
    "Dinner Key Auditorium, Miami, Florida": SportsballGeocodeTuple(
        city="Miami",
        state="FL",
        postal="33133",
        lat=25.728391,
        lng=-80.236465,
        housenumber="2700",
        country="USA",
    ),
    "Loyola Field House, New Orleans, Louisiana": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="",
        lat=29.937556,
        lng=-90.119944,
        housenumber="",
        country="USA",
    ),
    "Metropolitan Sports Center, Bloomington, Minnesota": SportsballGeocodeTuple(
        city="Bloomington",
        state="MN",
        postal="55420",
        lat=44.858333,
        lng=-93.24,
        housenumber="7901",
        country="USA",
    ),
    "Sam Houston Coliseum, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.761453,
        lng=-95.369546,
        housenumber="",
        country="USA",
    ),
    "Long Island Arena, Commack, New York": SportsballGeocodeTuple(
        city="Commack",
        state="NY",
        postal="",
        lat=40.838333,
        lng=-73.283333,
        housenumber="",
        country="USA",
    ),
    "St. Paul Auditorium, St. Paul, Minnesota": SportsballGeocodeTuple(
        city="St. Paul",
        state="MN",
        postal="",
        lat=44.944853,
        lng=-93.099445,
        housenumber="175",
        country="USA",
    ),
    "East Lansing, Michigan": SportsballGeocodeTuple(
        city="East Lansing",
        state="MI",
        postal="",
        lat=42.748056,
        lng=-84.483611,
        housenumber="",
        country="USA",
    ),
    "Honolulu, Hawaii": SportsballGeocodeTuple(
        city="Honolulu",
        state="HI",
        postal="",
        lat=21.306944,
        lng=-157.858333,
        housenumber="",
        country="USA",
    ),
    "Lincoln, Nebraska": SportsballGeocodeTuple(
        city="Lincoln",
        state="NE",
        postal="",
        lat=40.809167,
        lng=-96.678056,
        housenumber="",
        country="USA",
    ),
    "New Orleans, Louisiana": NEW_ORLEANS_CITY,
    "San Jose Civic Auditorium, San Jose, California": SAN_JOSE_CIVIC_AUDITORIUM,
    "Blackham Coliseum, Lafeyette, Louisiana": SportsballGeocodeTuple(
        city="Lafeyette",
        state="LA",
        postal="70506",
        lat=30.210554,
        lng=-92.033122,
        housenumber="444",
        country="USA",
    ),
    "Duluth Arena Auditorium, Duluth, Minnesota": SportsballGeocodeTuple(
        city="Duluth",
        state="MN",
        postal="55802",
        lat=46.781389,
        lng=-92.098056,
        housenumber="350",
        country="USA",
    ),
    "Baltimore Civic Center, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.288611,
        lng=-76.618889,
        housenumber="201",
        country="USA",
    ),
    "Detroit Olympia, Detroit, Michigan": DETROIT_OLYMPIA,
    "Convention Hall, Philadelphia, Pennsylvania": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.947368,
        lng=-75.195043,
        housenumber="3400",
        country="USA",
    ),
    "Miami Beach Auditorium, Miami Beach, Florida": MIAMI_BEACH_CONVENTION_CENTER,
    "Kiel Auditorium, St. Louis, Missouri": SportsballGeocodeTuple(
        city="St. Louis",
        state="MO",
        postal="63103",
        lat=38.627972,
        lng=-90.201782,
        housenumber="1401",
        country="USA",
    ),
    "Onondaga War Memorial, Syracuse, New York": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="",
        lat=43.044722,
        lng=-76.148333,
        housenumber="515",
        country="USA",
    ),
    "69th Regiment Armory, New York, New York": SportsballGeocodeTuple(
        city="New York",
        state="NY",
        postal="",
        lat=40.741389,
        lng=-73.984167,
        housenumber="68",
        country="USA",
    ),
    "Boston Garden, Boston, Massachusetts": BOSTON_GARDENS,
    "West Point, New York": SportsballGeocodeTuple(
        city="West Point",
        state="NY",
        postal="",
        lat=41.395,
        lng=-73.955,
        housenumber="",
        country="USA",
    ),
    "Bethlehem, Pennsylvania": SportsballGeocodeTuple(
        city="Bethlehem",
        state="PA",
        postal="",
        lat=40.626111,
        lng=-75.375556,
        housenumber="",
        country="USA",
    ),
    "Memphis, Tennessee": MEMPHIS,
    "Champaign, Illinois": SportsballGeocodeTuple(
        city="Champaign",
        state="IL",
        postal="",
        lat=40.116389,
        lng=-88.243611,
        housenumber="",
        country="USA",
    ),
    "Iowa City, Iowa": SportsballGeocodeTuple(
        city="Iowa City",
        state="IO",
        postal="",
        lat=41.66,
        lng=-91.53,
        housenumber="",
        country="USA",
    ),
    "Cedar City, Utah": SportsballGeocodeTuple(
        city="Cedar City",
        state="UT",
        postal="",
        lat=37.6775,
        lng=-113.095278,
        housenumber="",
        country="USA",
    ),
    "Oxford, Mississippi": SportsballGeocodeTuple(
        city="Oxford",
        state="MS",
        postal="",
        lat=34.372222,
        lng=-89.508056,
        housenumber="",
        country="USA",
    ),
    "Massimino Court, West Palm Beach, Florida": SportsballGeocodeTuple(
        city="West Palm Beach",
        state="FL",
        postal="33409",
        lat=26.7163158,
        lng=-80.1098274,
        housenumber="2300",
        country="USA",
    ),
    "Brookshire Grocery Arena, Bossier City, Louisiana": BROOKSHIRE_GROCERY_ARENA,
    "Roberto Clemente Coliseum, San Juan": SportsballGeocodeTuple(
        city="San Juan",
        state="PR",
        postal="",
        lat=18.4159,
        lng=-66.0754,
        housenumber="",
        country="USA",
    ),
    "Trojan Fieldhouse, Little Rock, Arkansas": SportsballGeocodeTuple(
        city="Little Rock",
        state="AR",
        postal="37210",
        lat=36.1407945,
        lng=-86.7555075,
        housenumber="410",
        country="USA",
    ),
    "George Q. Cannon Activities Center, Laie, Hawaii": SportsballGeocodeTuple(
        city="Laie",
        state="HI",
        postal="96762",
        lat=21.641036,
        lng=-157.9224658,
        housenumber="55",
        country="USA",
    ),
    "The Arena at Northwest Florida State College, Niceville, Florida": SportsballGeocodeTuple(
        city="Niceville",
        state="FL",
        postal="",
        lat=30.5394,
        lng=-86.4756,
        housenumber="",
        country="USA",
    ),
    "South Point Arena, Enterprise, Nevada": SportsballGeocodeTuple(
        city="Enterprise",
        state="NV",
        postal="89183",
        lat=36.011426,
        lng=-115.1753,
        housenumber="9777",
        country="USA",
    ),
    "McGonigle Hall, Philadelphia, Pennsylvania": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="19121",
        lat=39.981029,
        lng=-75.158033,
        housenumber="1800",
        country="USA",
    ),
    "Municipal Auditorium, Columbus, Georgia": SportsballGeocodeTuple(
        city="Columbus",
        state="GA",
        postal="",
        lat=32.5029979,
        lng=-84.9441475,
        housenumber="",
        country="USA",
    ),
    "IUPUI Gymnasium, Indianapolis, Indiana": THE_JUNGLE,
    "Daniel Lynch '38 Gymnasium, Brooklyn, New York": GENEROSO_POPE_ATHELTIC_COMPLEX,
    "TD Bank Sports Center, Hamden, Connecticut": TD_BANK_SPORTS_CENTER,
    "San Francisco, California": SAN_FRANCISCO,
    "Villanova, Pennsylvania": SportsballGeocodeTuple(
        city="Villanova",
        state="PA",
        postal="",
        lat=40.037222,
        lng=-75.349167,
        housenumber="",
        country="USA",
    ),
    "Normal, Illinois": SportsballGeocodeTuple(
        city="Normal",
        state="IL",
        postal="",
        lat=40.512222,
        lng=-88.988611,
        housenumber="",
        country="USA",
    ),
    "Troy, Alabama": SportsballGeocodeTuple(
        city="Troy",
        state="AL",
        postal="",
        lat=31.808889,
        lng=-85.97,
        housenumber="",
        country="USA",
    ),
    "Fargo, North Dakota": SportsballGeocodeTuple(
        city="Fargo",
        state="ND",
        postal="",
        lat=46.873333,
        lng=-96.827222,
        housenumber="",
        country="USA",
    ),
    "Savannah Civic Center, Savannah, Georgia": SportsballGeocodeTuple(
        city="Savannah",
        state="GA",
        postal="31401",
        lat=32.0769645,
        lng=-81.0995252,
        housenumber="301",
        country="USA",
    ),
    "Barossa Park, Lyndoch, Australia": BAROSSA_PARK,
    "Peoria, Illinois": PEORIA,
    "Durham, North Carolina": DURHAM,
    "South Orange, New Jersey": SportsballGeocodeTuple(
        city="South Orange",
        state="NJ",
        postal="",
        lat=40.748811,
        lng=-74.261512,
        housenumber="",
        country="USA",
    ),
    "Foster Pavilion, Waco, Texas": SportsballGeocodeTuple(
        city="Waco",
        state="TX",
        postal="",
        lat=31.556698,
        lng=-97.121613,
        housenumber="",
        country="USA",
    ),
    "Santa Clara, California": SportsballGeocodeTuple(
        city="Santa Clara",
        state="CA",
        postal="",
        lat=37.354444,
        lng=-121.969167,
        housenumber="",
        country="USA",
    ),
    "Chattanooga, Tennessee": CHATTANOOGA,
    "Des Moines, Iowa": SportsballGeocodeTuple(
        city="Des Moines",
        state="IA",
        postal="",
        lat=41.590833,
        lng=-93.620833,
        housenumber="",
        country="USA",
    ),
    "Conway, South Carolina": SportsballGeocodeTuple(
        city="Conway",
        state="SC",
        postal="",
        lat=33.838056,
        lng=-79.056111,
        housenumber="",
        country="USA",
    ),
    "Macomb, Illinois": SportsballGeocodeTuple(
        city="Macomb",
        state="IL",
        postal="",
        lat=40.470833,
        lng=-90.680833,
        housenumber="",
        country="USA",
    ),
    "Stockton, California": STOCKTON,
    "Jonesboro, Arkansas": SportsballGeocodeTuple(
        city="Jonesboro",
        state="AR",
        postal="",
        lat=35.811111,
        lng=-90.696944,
        housenumber="",
        country="USA",
    ),
    "Alcorn State, Mississippi": SportsballGeocodeTuple(
        city="Alcorn State",
        state="MI",
        postal="",
        lat=31.8769,
        lng=-91.1411,
        housenumber="",
        country="USA",
    ),
    "Evanston, Illinois": SportsballGeocodeTuple(
        city="Evanston",
        state="IL",
        postal="",
        lat=42.046389,
        lng=-87.694722,
        housenumber="",
        country="USA",
    ),
    "Missoula, Montana": SportsballGeocodeTuple(
        city="Missoula",
        state="MT",
        postal="",
        lat=46.892778,
        lng=-114.021667,
        housenumber="",
        country="USA",
    ),
    "Cheney, Washington": SportsballGeocodeTuple(
        city="Cheney",
        state="WA",
        postal="",
        lat=47.488611,
        lng=-117.578611,
        housenumber="",
        country="USA",
    ),
    "Jacksonville, Florida": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="",
        lat=30.336944,
        lng=-81.661389,
        housenumber="",
        country="USA",
    ),
    "Nacogdoches, Texas": NACOGDOCHES,
    "Commerce, Texas": SportsballGeocodeTuple(
        city="Commerce",
        state="TX",
        postal="",
        lat=33.245,
        lng=-95.894444,
        housenumber="",
        country="USA",
    ),
    "Beaumont, Texas": SportsballGeocodeTuple(
        city="Beaumont",
        state="TX",
        postal="",
        lat=30.08,
        lng=-94.126667,
        housenumber="",
        country="USA",
    ),
    "Greeley, Colorado": SportsballGeocodeTuple(
        city="Greeley",
        state="CO",
        postal="",
        lat=40.423333,
        lng=-104.709167,
        housenumber="",
        country="USA",
    ),
    "Ogden, Utah": SportsballGeocodeTuple(
        city="Ogden",
        state="UT",
        postal="",
        lat=41.227778,
        lng=-111.968333,
        housenumber="",
        country="USA",
    ),
    "University Park, Pennsylvania": SportsballGeocodeTuple(
        city="University Park",
        state="PA",
        postal="",
        lat=40.806667,
        lng=-77.880278,
        housenumber="",
        country="USA",
    ),
    "Barossa Park": BAROSSA_PARK,
    "Moraga, California": SportsballGeocodeTuple(
        city="Moraga",
        state="CA",
        postal="",
        lat=37.835,
        lng=-122.129722,
        housenumber="",
        country="USA",
    ),
    "Hammond, Louisiana": SportsballGeocodeTuple(
        city="Hammond",
        state="LA",
        postal="",
        lat=30.5025,
        lng=-90.475,
        housenumber="",
        country="USA",
    ),
    "Macon, Georgia": SportsballGeocodeTuple(
        city="Macon",
        state="GA",
        postal="",
        lat=32.834722,
        lng=-83.651667,
        housenumber="",
        country="USA",
    ),
    "Radford, Virginia": SportsballGeocodeTuple(
        city="Radford",
        state="VA",
        postal="",
        lat=37.1275,
        lng=-80.569444,
        housenumber="",
        country="USA",
    ),
    "Spartanburg, South Carolina": SportsballGeocodeTuple(
        city="Spartanburg",
        state="SC",
        postal="",
        lat=34.946667,
        lng=-81.9275,
        housenumber="",
        country="USA",
    ),
    "Rock Hill, South Carolina": ROCK_HILL,
    "Montgomery, Alabama": MONTGOMERY,
    "Elma Roane Fieldhouse, Memphis, Tennessee": SportsballGeocodeTuple(
        city="Memphis",
        state="TN",
        postal="38152",
        lat=35.118369,
        lng=-89.935675,
        housenumber="495",
        country="USA",
    ),
    "Murray, Kentucky": SportsballGeocodeTuple(
        city="Murray",
        state="KY",
        postal="",
        lat=36.609444,
        lng=-88.315556,
        housenumber="",
        country="USA",
    ),
    "Grand Forks, North Dakota": SportsballGeocodeTuple(
        city="Grand Forks",
        state="ND",
        postal="",
        lat=47.921264,
        lng=-97.088339,
        housenumber="",
        country="USA",
    ),
    "Cookeville, Tennessee": SportsballGeocodeTuple(
        city="Cookeville",
        state="TN",
        postal="",
        lat=36.164167,
        lng=-85.504167,
        housenumber="",
        country="USA",
    ),
    "Malibu, California": SportsballGeocodeTuple(
        city="Malibu",
        state="CA",
        postal="",
        lat=34.035,
        lng=-118.695,
        housenumber="",
        country="USA",
    ),
    "Boiling Springs, North Carolina": SportsballGeocodeTuple(
        city="Boiling Springs",
        state="NC",
        postal="",
        lat=35.251944,
        lng=-81.663611,
        housenumber="",
        country="USA",
    ),
    "Lexington, Virginia": SportsballGeocodeTuple(
        city="Lexington",
        state="VA",
        postal="",
        lat=37.783889,
        lng=-79.442778,
        housenumber="",
        country="USA",
    ),
    "Buccaneer Fieldhouse, Charleston, South Carolina": BUCCANEER_FIELDHOUSE,
    "Charleston, Illinois": SportsballGeocodeTuple(
        city="Charleston",
        state="IL",
        postal="",
        lat=39.484167,
        lng=-88.178056,
        housenumber="",
        country="USA",
    ),
    "Worcester, Massachusetts": SportsballGeocodeTuple(
        city="Worcester",
        state="MA",
        postal="",
        lat=42.271389,
        lng=-71.798889,
        housenumber="",
        country="USA",
    ),
    "Joan Perry Brock Center, Farmville, Virginia": SportsballGeocodeTuple(
        city="Farmville",
        state="VA",
        postal="",
        lat=37.298333,
        lng=-78.395556,
        housenumber="405",
        country="USA",
    ),
    "Princess Anne, Maryland": SportsballGeocodeTuple(
        city="Princess Anne",
        state="MD",
        postal="",
        lat=38.209722,
        lng=-75.695,
        housenumber="",
        country="USA",
    ),
    "Joel and Diane Bloom Wellness and Events Center, Newark, New Jersey": WELLNESS_AND_EVENTS_CENTER,
    "Asheville, North Carolina": SportsballGeocodeTuple(
        city="Asheville",
        state="NC",
        postal="",
        lat=35.595556,
        lng=-82.551944,
        housenumber="",
        country="USA",
    ),
    "Clinton, South Carolina": SportsballGeocodeTuple(
        city="Clinton",
        state="SC",
        postal="",
        lat=34.471389,
        lng=-81.875,
        housenumber="",
        country="USA",
    ),
    "Edwardsville, Illinois": SportsballGeocodeTuple(
        city="Edwardsville",
        state="IL",
        postal="",
        lat=38.803889,
        lng=-89.958333,
        housenumber="",
        country="USA",
    ),
    "DeLand, Florida": SportsballGeocodeTuple(
        city="DeLand",
        state="FL",
        postal="",
        lat=29.0225,
        lng=-81.286389,
        housenumber="",
        country="USA",
    ),
    "Martin, Tennessee": SportsballGeocodeTuple(
        city="Martin",
        state="TN",
        postal="",
        lat=36.341944,
        lng=-88.851667,
        housenumber="",
        country="USA",
    ),
    "The Coliseum, Carrollton, Georgia": SportsballGeocodeTuple(
        city="Carrollton",
        state="GA",
        postal="",
        lat=33.5761,
        lng=-85.1039,
        housenumber="",
        country="USA",
    ),
    "Williamsburg, Virginia": SportsballGeocodeTuple(
        city="Williamsburg",
        state="VA",
        postal="",
        lat=37.270833,
        lng=-76.706944,
        housenumber="",
        country="USA",
    ),
    "Cedar Falls, Iowa": CEDAR_FALLS,
    "Towson, Maryland": SportsballGeocodeTuple(
        city="Towson",
        state="MD",
        postal="",
        lat=39.393056,
        lng=-76.609444,
        housenumber="",
        country="USA",
    ),
    "Vermillon, South Dakota": SportsballGeocodeTuple(
        city="Vermillon",
        state="SD",
        postal="",
        lat=42.781389,
        lng=-96.925278,
        housenumber="",
        country="USA",
    ),
    "Tampa, Florida": TAMPA,
    "Berkeley, California": BERKELEY,
    "Barossa Oval - Australia": BAROSSA_PARK,
    "Verizon Arena, North Little Rock, Arkansas": SIMMONS_BANK_ARENA,
    "Naples, Florida": SportsballGeocodeTuple(
        city="Naples",
        state="FL",
        postal="",
        lat=26.136111,
        lng=-81.794444,
        housenumber="",
        country="USA",
    ),
    "Henrico Sports & Events Center, Henrico, Virginia": SportsballGeocodeTuple(
        city="Henrico",
        state="VA",
        postal="23059",
        lat=37.6771948,
        lng=-77.4528141,
        housenumber="1",
        country="USA",
    ),
    "College Park, Georgia": SportsballGeocodeTuple(
        city="College Park",
        state="GA",
        postal="",
        lat=33.6175,
        lng=-84.4675,
        housenumber="",
        country="USA",
    ),
    "Ralston, Nebraska": SportsballGeocodeTuple(
        city="Ralston",
        state="NE",
        postal="",
        lat=41.200556,
        lng=-96.035556,
        housenumber="",
        country="USA",
    ),
    "Bill Greehey Arena, San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="78228",
        lat=29.451858,
        lng=-98.5643022,
        housenumber="1",
        country="USA",
    ),
    "Hartsell Arena, Pensacola, Florida": SportsballGeocodeTuple(
        city="Pensacola",
        state="FL",
        postal="32504",
        lat=30.4793276,
        lng=-87.1995723,
        housenumber="",
        country="USA",
    ),
    "Kerr Fitness Center, Pittsburgh, Pennsylvania": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="15237",
        lat=40.5691309,
        lng=-80.01166,
        housenumber="9000",
        country="USA",
    ),
    "Titan Field House, Melbourne, Florida": SportsballGeocodeTuple(
        city="Melbourne",
        state="FL",
        postal="3865",
        lat=28.16992,
        lng=-80.66588,
        housenumber="32935",
        country="USA",
    ),
    "H&HP Complex, Lake Charles, Louisiana": LEGACY_CENTER,
    "Bill Harris Arena, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="35208",
        lat=33.495,
        lng=-86.874,
        housenumber="2331",
        country="USA",
    ),
    "Rochester, New York": ROCHESTER,
    "North Little Rock, Arkansas": SportsballGeocodeTuple(
        city="North Little Rock",
        state="AR",
        postal="",
        lat=34.780833,
        lng=-92.256944,
        housenumber="",
        country="USA",
    ),
    "Kent, Washington": SportsballGeocodeTuple(
        city="Kent",
        state="WA",
        postal="",
        lat=47.382778,
        lng=-122.226944,
        housenumber="",
        country="USA",
    ),
    "Magness Arena, Denver, Colorado": MAGNESS_ARENA,
    "ESPN Wide World of Sports, Orlando, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Chaparral Center, Midland, Texas": SportsballGeocodeTuple(
        city="Midland",
        state="TX",
        postal="",
        lat=32.028,
        lng=-102.103,
        housenumber="2240",
        country="USA",
    ),
    "NJIT Wellness and Events Center, Newark, New Jersey": WELLNESS_AND_EVENTS_CENTER,
    "McGrath-Phillips Arena, Chicago, Illinois": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60604",
        lat=41.923901,
        lng=-87.653167,
        housenumber="2323",
        country="USA",
    ),
    "Jacksonville Veteran's Memorial Arena, Jacksonville, Florida": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="32202",
        lat=30.325769,
        lng=-81.645069,
        housenumber="300",
        country="USA",
    ),
    "James T. Valvano Arena, Raleigh, North Carolina": REYNOLDS_COLISEUM,
    "North Charleston Coliseum, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="29418",
        lat=32.8656,
        lng=-80.0224,
        housenumber="5001",
        country="USA",
    ),
    "North Athletic Complex, Pittsburgh, Pennsylvania": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.519083,
        lng=-80.212405,
        housenumber="",
        country="USA",
    ),
    "Georgetown, Kentucky": SportsballGeocodeTuple(
        city="Georgetown",
        state="KY",
        postal="",
        lat=38.209722,
        lng=-84.56,
        housenumber="",
        country="USA",
    ),
    "Gold Dome, Shreveport, Louisiana": SportsballGeocodeTuple(
        city="Shreveport",
        state="LA",
        postal="71134",
        lat=32.480921,
        lng=-93.729818,
        housenumber="2911",
        country="USA",
    ),
    "Vancouver Convention Centre,": VANCOUVER_CONVENTION_CENTER,
    "Vancouver Convention Centre, Vancouver": VANCOUVER_CONVENTION_CENTER,
    "Kendal Isaacs Gymnasium, Nassau": KENDALL_ISAACS_GYMNASIUM,
    "Kendal Isaacs Gymnasium, Nassau, The Bahamas": KENDALL_ISAACS_GYMNASIUM,
    "Otter Sports Center, Marina, California": SportsballGeocodeTuple(
        city="Marina",
        state="CA",
        postal="93933",
        lat=36.6544526,
        lng=-121.8081741,
        housenumber="2050",
        country="USA",
    ),
    "ShoWare Center, Kent, Washington": SportsballGeocodeTuple(
        city="Kent",
        state="WA",
        postal="",
        lat=47.388333,
        lng=-122.24,
        housenumber="625",
        country="USA",
    ),
    "Fort Bliss, El Paso, Texas": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="",
        lat=31.801847,
        lng=-106.424608,
        housenumber="",
        country="USA",
    ),
    "Huntington, West Virginia": HUNTINGTON,
    "St. John Arena, Columbus, Ohio": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="43210",
        lat=40.005278,
        lng=-83.018889,
        housenumber="410",
        country="USA",
    ),
    "Delmar-Tusa Fieldhouse, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="77092",
        lat=29.802778,
        lng=-95.456944,
        housenumber="2020",
        country="USA",
    ),
    "Reno Events Center, Reno, Nevada": SportsballGeocodeTuple(
        city="Reno",
        state="NV",
        postal="",
        lat=39.5309,
        lng=-119.8125,
        housenumber="400",
        country="USA",
    ),
    "Municipal Auditorium, Kansas City, Missouri": SportsballGeocodeTuple(
        city="Kansas City",
        state="MO",
        postal="",
        lat=39.098353,
        lng=-94.586416,
        housenumber="301",
        country="USA",
    ),
    "Hattiesburg, Mississippi": SportsballGeocodeTuple(
        city="Hattiesburg",
        state="MS",
        postal="",
        lat=31.315833,
        lng=-89.308611,
        housenumber="",
        country="USA",
    ),
    "Alumni Gym, Elon, North Carolina": SportsballGeocodeTuple(
        city="Elon",
        state="NC",
        postal="",
        lat=36.109018,
        lng=-79.506705,
        housenumber="",
        country="USA",
    ),
    "Jack and Ruth Ann Hill Convocation Center, Statesboro, Georgia": SportsballGeocodeTuple(
        city="Statesboro",
        state="GA",
        postal="30458",
        lat=32.40625,
        lng=-81.783056,
        housenumber="284",
        country="USA",
    ),
    "San Marcos, Texas": SportsballGeocodeTuple(
        city="San Marcos",
        state="TX",
        postal="",
        lat=29.879444,
        lng=-97.938889,
        housenumber="",
        country="USA",
    ),
    "Retriever Activities Center, Baltimore, Maryland": RETRIEVER_ACTIVITIES_CENTER,
    "Memorial Coliseum, Portland, Oregon": MEMORIAL_COLISEUM,
    "Benjamin Johnson Arena, Spartanburg, South Carolina": SportsballGeocodeTuple(
        city="Spartanburg",
        state="SC",
        postal="",
        lat=34.960278,
        lng=-81.932778,
        housenumber="",
        country="USA",
    ),
    "Hartford, Connecticut": SportsballGeocodeTuple(
        city="Hartford",
        state="CT",
        postal="",
        lat=41.7625,
        lng=-72.674167,
        housenumber="",
        country="USA",
    ),
    "Quest MultiSport, Chicago, Illinois": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="60612",
        lat=41.8733479,
        lng=-87.6923655,
        housenumber="2641",
        country="USA",
    ),
    "ICI Center (Embry-Riddle), Daytona Beach, Florida": SportsballGeocodeTuple(
        city="Daytona Beach",
        state="FL",
        postal="32114",
        lat=29.1886,
        lng=-81.0487,
        housenumber="1",
        country="USA",
    ),
    "South Point Arena, Las Vegas, Nevada": SportsballGeocodeTuple(
        city="Las Vegas",
        state="NV",
        postal="89183",
        lat=36.0112358,
        lng=-115.1752286,
        housenumber="9777",
        country="USA",
    ),
    "Abrams Physical Fitness Center, Fort Hood, Texas": SportsballGeocodeTuple(
        city="Fort Hood",
        state="TX",
        postal="76544",
        lat=31.1382238,
        lng=-97.7772131,
        housenumber="",
        country="USA",
    ),
    "CenturyLink Center (LA), Bossier City, Louisiana": BROOKSHIRE_GROCERY_ARENA,
    "Dothan Civic Center, Dothan, Alabama": SportsballGeocodeTuple(
        city="Dothan",
        state="AL",
        postal="",
        lat=31.224722,
        lng=-85.39,
        housenumber="",
        country="USA",
    ),
    "Stockton Arena, Stockton, California": SportsballGeocodeTuple(
        city="Stockton",
        state="CA",
        postal="95203",
        lat=37.9561651,
        lng=-121.2960735,
        housenumber="248",
        country="USA",
    ),
    "Le Moyne Events Center, Syracuse, New York": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="13214",
        lat=43.0502,
        lng=-76.0848,
        housenumber="500",
        country="USA",
    ),
    "Bloch Arena, Honolulu, Hawaii": SportsballGeocodeTuple(
        city="Honolulu",
        state="HI",
        postal="96818",
        lat=21.3477415,
        lng=-157.9412764,
        housenumber="224",
        country="USA",
    ),
    "Charleston Civic Center, Charleston, West Virginia": CHARLESTON_CIVIC_CENTER,
    "Tom Golisano Field House, Ave Maria, Florida": SportsballGeocodeTuple(
        city="Ave Maria",
        state="FL",
        postal="34142",
        lat=26.3396049,
        lng=-81.4410362,
        housenumber="4810",
        country="USA",
    ),
    "Tuba City HS Gym, Tuba City, Arizona": SportsballGeocodeTuple(
        city="Tuba City",
        state="AZ",
        postal="86045",
        lat=36.126661,
        lng=-111.223479,
        housenumber="",
        country="USA",
    ),
    "Lakeland Center, Lakeland, Florida": SportsballGeocodeTuple(
        city="Lakeland",
        state="FL",
        postal="33815",
        lat=28.041053,
        lng=-81.963619,
        housenumber="701",
        country="USA",
    ),
    "'Iolani School Gym, Honolulu, Hawaii": SportsballGeocodeTuple(
        city="Honolulu",
        state="HI",
        postal="96826",
        lat=21.2865,
        lng=-157.824567,
        housenumber="563",
        country="USA",
    ),
    "Mercyhurst Athletic Center, Erie, Pennsylvania": SportsballGeocodeTuple(
        city="Erie",
        state="PA",
        postal="",
        lat=42.1046,
        lng=-80.0556,
        housenumber="",
        country="USA",
    ),
    "Monroe, Louisiana": MONROE,
    "F&M Bank Arena, Clarksville, Tennessee": SportsballGeocodeTuple(
        city="Clarksville",
        state="TN",
        postal="",
        lat=36.529444,
        lng=-87.359722,
        housenumber="101",
        country="USA",
    ),
    "C.M. Tad Smith Coliseum, University, Mississippi": SportsballGeocodeTuple(
        city="University",
        state="MS",
        postal="38677",
        lat=34.362197,
        lng=-89.539303,
        housenumber="",
        country="USA",
    ),
    "Verties Sails Gymnasium, Memphis, Tennessee": SportsballGeocodeTuple(
        city="Memphis",
        state="TN",
        postal="38107",
        lat=35.1565496,
        lng=-89.9896643,
        housenumber="",
        country="USA",
    ),
    "Thibodaux, Louisiana": SportsballGeocodeTuple(
        city="Thibodaux",
        state="LA",
        postal="",
        lat=29.792222,
        lng=-90.82,
        housenumber="",
        country="USA",
    ),
    "New Orleans , Louisiana": NEW_ORLEANS_CITY,
    "First Bank & Trust Arena, Brookings, South Dakota": SportsballGeocodeTuple(
        city="Brookings",
        state="SD",
        postal="57007",
        lat=44.317984,
        lng=-96.779058,
        housenumber="1165",
        country="USA",
    ),
    "Cambria County War Memorial Arena, Johnstown, Pennsylvania": SportsballGeocodeTuple(
        city="Johnstown",
        state="PA",
        postal="15901",
        lat=40.32296,
        lng=-78.922654,
        housenumber="326",
        country="USA",
    ),
    "Esby Gym, Glassboro, New Jersey": SportsballGeocodeTuple(
        city="Glassboro",
        state="NJ",
        postal="08028",
        lat=39.7106001,
        lng=-75.1186627,
        housenumber="300",
        country="USA",
    ),
    "Boone, North Carolina": SportsballGeocodeTuple(
        city="Boone",
        state="NC",
        postal="",
        lat=36.211111,
        lng=-81.666944,
        housenumber="",
        country="USA",
    ),
    "Davis Field House, Greenville, South Carolina": SportsballGeocodeTuple(
        city="Greenville",
        state="SC",
        postal="",
        lat=34.8725,
        lng=-82.361944,
        housenumber="",
        country="USA",
    ),
    "Rimrock Auto Arena at MetraPark, Billings, Montana": SportsballGeocodeTuple(
        city="Billings",
        state="MT",
        postal="59101",
        lat=45.800103,
        lng=-108.477201,
        housenumber="308",
        country="USA",
    ),
    "Corvallis, Oregon": SportsballGeocodeTuple(
        city="Corvallis",
        state="OR",
        postal="",
        lat=44.569722,
        lng=-123.278333,
        housenumber="",
        country="USA",
    ),
    "Mabee Center, Liberty, Missouri": SportsballGeocodeTuple(
        city="Liberty",
        state="MO",
        postal="64068",
        lat=39.24962892,
        lng=-94.4087267,
        housenumber="924",
        country="USA",
    ),
    "Durham, New Hampshire": SportsballGeocodeTuple(
        city="Durham",
        state="NH",
        postal="",
        lat=43.133889,
        lng=-70.926389,
        housenumber="",
        country="USA",
    ),
    "Morehead, Kentucky": SportsballGeocodeTuple(
        city="Morehead",
        state="KY",
        postal="",
        lat=38.190833,
        lng=-83.4475,
        housenumber="",
        country="USA",
    ),
    "Hart Center Arena, Worcester, Massachusetts": HART_RECREATION_CENTER,
    "Regional Special Events Center, Murray, Kentucky": CFSB_CENTER,
    "M&T Bank Arena, Hamden, Connecticut": TD_BANK_SPORTS_CENTER,
    "Cape Girardeau, Missouri": SportsballGeocodeTuple(
        city="Cape Girardeau",
        state="MO",
        postal="",
        lat=37.310833,
        lng=-89.559722,
        housenumber="",
        country="USA",
    ),
    "Memorial Center, Johnson City, Tennessee": SportsballGeocodeTuple(
        city="Johnson City",
        state="TN",
        postal="37601",
        lat=36.3037181,
        lng=-82.3707852,
        housenumber="",
        country="USA",
    ),
    "New Haven, Connecticut": SportsballGeocodeTuple(
        city="New Haven",
        state="CT",
        postal="",
        lat=41.308333,
        lng=-72.925,
        housenumber="",
        country="USA",
    ),
    "Ralston Arena, Ralston, Nebraska": SportsballGeocodeTuple(
        city="Ralston",
        state="NE",
        postal="",
        lat=41.206944,
        lng=-96.026944,
        housenumber="7300",
        country="USA",
    ),
    "Avron B. Fogelman Arena, New Orleans, Louisiana": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="70118",
        lat=29.938611,
        lng=-90.120556,
        housenumber="",
        country="USA",
    ),
    "Pritchard Gymnasium, Stony Brook, New York": SportsballGeocodeTuple(
        city="Stony Brook",
        state="NY",
        postal="11790",
        lat=40.917238,
        lng=-73.124638,
        housenumber="",
        country="USA",
    ),
    "Agganis Arena, Boston, Massachusetts": AGGANIS_ARENA,
    "Valparaiso, Indiana": SportsballGeocodeTuple(
        city="Valparaisos",
        state="IN",
        postal="",
        lat=41.476111,
        lng=-87.040278,
        housenumber="",
        country="USA",
    ),
    "Asheville Civic Center, Asheville, North Carolina": HARRAHS_CHEROKEE_CENTER,
    "1st Mariner Arena, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.288611,
        lng=-76.618889,
        housenumber="201",
        country="USA",
    ),
    "ASU Acadome, Montgomery, Alabama": DUNN_OLIVER_ACADOME,
    "Solomon Court at Cabot Center, Boston, Massachusetts": CABOT_CENTER,
    "University, Mississippi": SportsballGeocodeTuple(
        city="University",
        state="MS",
        postal="",
        lat=34.365556,
        lng=-89.537778,
        housenumber="",
        country="USA",
    ),
    "Centrum Arena, Cedar City, Utah": CENTRUM_ARENA,
    "Mount Pleasant, Michigan": SportsballGeocodeTuple(
        city="Mount Pleasant",
        state="MI",
        postal="",
        lat=43.597778,
        lng=-84.7675,
        housenumber="",
        country="USA",
    ),
    "Hampton, Virginia": SportsballGeocodeTuple(
        city="Hampton",
        state="VI",
        postal="",
        lat=37.026389,
        lng=-76.344444,
        housenumber="",
        country="USA",
    ),
    "Albuquerque, New Mexico": SportsballGeocodeTuple(
        city="Albuquerque",
        state="NM",
        postal="",
        lat=35.084444,
        lng=-106.650278,
        housenumber="",
        country="USA",
    ),
    "The Bank of Kentucky Center, Highland Heights, Kentucky": BANK_OF_KENTUCKY_CENTER,
    "Little Rock, Arkansas": LITTLE_ROCK,
    "Bridgeport, Connecticut": SportsballGeocodeTuple(
        city="Bridgeport",
        state="CT",
        postal="",
        lat=41.186389,
        lng=-73.195556,
        housenumber="",
        country="USA",
    ),
    "Loretto, Pennsylvania": SportsballGeocodeTuple(
        city="Loretto",
        state="PA",
        postal="",
        lat=40.506389,
        lng=-78.636111,
        housenumber="",
        country="USA",
    ),
    "Vermillion, South Dakota": SportsballGeocodeTuple(
        city="Vermillion",
        state="SD",
        postal="",
        lat=42.781389,
        lng=-96.925278,
        housenumber="",
        country="USA",
    ),
    "Hornets Nest, Sacramento, California": THE_NEST,
    "Carolina First Arena, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="",
        lat=32.789444,
        lng=-79.929444,
        housenumber="",
        country="USA",
    ),
    "Road Town": SportsballGeocodeTuple(
        city="Road Town",
        state="",
        postal="",
        lat=18.431389,
        lng=-64.623056,
        housenumber="",
        country="British Virgin Islands",
    ),
    "D.J. Sokol Arena, Omaha, Nebraska": SportsballGeocodeTuple(
        city="Omaha",
        state="NE",
        postal="",
        lat=41.266146,
        lng=-95.940471,
        housenumber="",
        country="USA",
    ),
    "Enterprise, Nevada": SportsballGeocodeTuple(
        city="Enterprise",
        state="NV",
        postal="",
        lat=36.031389,
        lng=-115.198056,
        housenumber="",
        country="USA",
    ),
    "Templeton Center, Clinton, South Carolina": ROSS_E_TEMPLETON_CENTER,
    "Tupelo, Mississippi": SportsballGeocodeTuple(
        city="Tupelo",
        state="MS",
        postal="",
        lat=34.259722,
        lng=-88.725833,
        housenumber="",
        country="USA",
    ),
    "McKay Events Center, Orem, Utah": UCCU_CENTER,
    "Mobile, Alabama": SportsballGeocodeTuple(
        city="Mobile",
        state="AL",
        postal="",
        lat=30.6675,
        lng=-88.101111,
        housenumber="",
        country="USA",
    ),
    "Harbor Yard, Bridgeport, Connecticut": HARBOR_YARD,
    "Arena at Harbor Yard, Bridgeport, Connecticut": HARBOR_YARD,
    "Chase Arena at Reich Family Pavilion, West Hartford, Connecticut": CHASE_FAMILY_ARENA,
    "University Center, Macon, Georgia": SportsballGeocodeTuple(
        city="Macon",
        state="GA",
        postal="",
        lat=32.829167,
        lng=-83.648611,
        housenumber="",
        country="USA",
    ),
    "Rabobank Arena, Bakersfield, California": SportsballGeocodeTuple(
        city="Bakersfield",
        state="CA",
        postal="",
        lat=35.37208,
        lng=-119.013723,
        housenumber="1001",
        country="USA",
    ),
    "UCR Student Rec Center, Riverside, California": UCR_STUDENT_REC_CENTER,
    "Maurice Stokes Athletic Center, Loretto, Pennsylvania": DEGOL_ARENA,
    "RAC Arena, Baltimore, Maryland": RETRIEVER_ACTIVITIES_CENTER,
    "The Milk House, Lake Buena Vista, Florida": ESPN_WIDE_WORLD_OF_SPORTS_COMPLEX,
    "Sullivan Arena, Anchorage, Alaska": SportsballGeocodeTuple(
        city="Anchorage",
        state="AL",
        postal="04473",
        lat=61.205556,
        lng=-149.8725,
        housenumber="1600",
        country="USA",
    ),
    "Rose Arena, Mount Pleasant, Michigan": SportsballGeocodeTuple(
        city="Mount Pleasant",
        state="MI",
        postal="",
        lat=43.580888,
        lng=-84.773941,
        housenumber="",
        country="USA",
    ),
    "Towson Center, Towson, Maryland": SportsballGeocodeTuple(
        city="Towson",
        state="MD",
        postal="21252",
        lat=39.386375,
        lng=-76.616238,
        housenumber="7500",
        country="USA",
    ),
    "Multipurpose Center and Teaching Gym, Tallahassee, Florida": AL_LAWSON_CENTER,
    "Puerto Vallarta International Convention Center, Puerto Vallarta": SportsballGeocodeTuple(
        city="Puerto Vallarta",
        state="",
        postal="",
        lat=20.6799474,
        lng=-105.2334998,
        housenumber="",
        country="Mexico",
    ),
    "Aventura Spa Palace Resort, Riviera Maya": SportsballGeocodeTuple(
        city="Playa del Carmen",
        state="QR",
        postal="77710",
        lat=20.5069801,
        lng=-87.215373,
        housenumber="72",
        country="Mexico",
    ),
    "Friel Court, Pullman, Washington": BEASLEY_COLISEUM,
    "Lafayette, Louisiana": SportsballGeocodeTuple(
        city="Lafayette",
        state="LA",
        postal="",
        lat=30.208056,
        lng=-92.0325,
        housenumber="",
        country="USA",
    ),
    "Corbin J. Robertson Center, Georgetown, Texas": SportsballGeocodeTuple(
        city="Georgetown",
        state="TX",
        postal="78626",
        lat=30.6361364,
        lng=-97.6633265,
        housenumber="930",
        country="USA",
    ),
    "Statesboro, Georgia": SportsballGeocodeTuple(
        city="Statesboro",
        state="GA",
        postal="",
        lat=32.445278,
        lng=-81.779167,
        housenumber="",
        country="USA",
    ),
    "UHY Center, Loudonville, New York": SportsballGeocodeTuple(
        city="Loudonville",
        state="NY",
        postal="12211",
        lat=42.7174,
        lng=-73.7487,
        housenumber="515",
        country="USA",
    ),
    "Frank L. Forbes Arena, Atlanta, Georgia": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="",
        lat=33.748471,
        lng=-84.417106,
        housenumber="",
        country="USA",
    ),
    "Earl C. Sams Gymnasium, San Antonio, Texas": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="78212",
        lat=29.4618769,
        lng=-98.4859131,
        housenumber="1",
        country="USA",
    ),
    "Mullaney Gymnasium, Providence, Rhode Island": ALUMNI_HALL,
    "Camp Humphreys, Anjeong-ri": SportsballGeocodeTuple(
        city="Anjeong-ri",
        state="",
        postal="",
        lat=36.9684272,
        lng=126.9811043,
        housenumber="",
        country="South Korea",
    ),
    "Curtis Culwell Center, Garland, Texas": SportsballGeocodeTuple(
        city="Garland",
        state="TX",
        postal="",
        lat=32.95956,
        lng=-96.64191,
        housenumber="4999",
        country="USA",
    ),
    "Summit Arena, Hot Springs, Arkansas": SportsballGeocodeTuple(
        city="Hot Springs",
        state="AR",
        postal="",
        lat=34.509722,
        lng=-93.049167,
        housenumber="398",
        country="USA",
    ),
    "Sioux Falls Arena, Sioux Falls, South Dakota": SportsballGeocodeTuple(
        city="Sioux Falls",
        state="SD",
        postal="57104",
        lat=43.562081,
        lng=-96.749333,
        housenumber="1201",
        country="USA",
    ),
    "Bob Devaney Sports Center, Lincoln, Nebraska": SportsballGeocodeTuple(
        city="Lincoln",
        state="NE",
        postal="",
        lat=40.830207,
        lng=-96.697644,
        housenumber="1600",
        country="USA",
    ),
    "Jamaica, New York": JAMAICA,
    "Waco, Texas": WACO,
    "Rebecca D. Lockhart Arena, Orem, Utah": SportsballGeocodeTuple(
        city="Orem",
        state="UT",
        postal="84058",
        lat=40.2787192,
        lng=-111.7155783,
        housenumber="785",
        country="USA",
    ),
    "South Padre Island Convention Centre, South Padre Island, Texas": SportsballGeocodeTuple(
        city="South Padre Island",
        state="TX",
        postal="78597",
        lat=26.140556,
        lng=-97.175,
        housenumber="7355",
        country="USA",
    ),
    "Moon Palace Resort, Cancun": SportsballGeocodeTuple(
        city="Cancun",
        state="QR",
        postal="77500",
        lat=20.9886511,
        lng=-86.826701,
        housenumber="340",
        country="Mexico",
    ),
    "Meeks Family Fieldhouse at Carson Center, Evansville, Indiana": SportsballGeocodeTuple(
        city="Evansville",
        state="IN",
        postal="",
        lat=37.9963496,
        lng=-87.6993641,
        housenumber="",
        country="USA",
    ),
    "José Miguel Agrelot Coliseum, San Juan": JOSE_MIGUEL_AGRELOT_COLISEUM,
    "USB Sports Complex, Stony Brook, New York": SportsballGeocodeTuple(
        city="Stony Brook",
        state="NY",
        postal="11790",
        lat=40.917417,
        lng=-73.124722,
        housenumber="100",
        country="USA",
    ),
    "Kimbel Arena, Conway, South Carolina": SportsballGeocodeTuple(
        city="Conway",
        state="SC",
        postal="",
        lat=33.79382,
        lng=-79.013243,
        housenumber="",
        country="USA",
    ),
    "Sapp Fieldhouse, Ralston, Nebraska": SportsballGeocodeTuple(
        city="Ralston",
        state="NE",
        postal="68132",
        lat=41.2574,
        lng=-96.00922,
        housenumber="6311",
        country="USA",
    ),
    "Texas Hall, Arlington, Texas": SportsballGeocodeTuple(
        city="Arlington",
        state="TX",
        postal="76010",
        lat=32.7297,
        lng=-97.1154,
        housenumber="701",
        country="USA",
    ),
    "Grand Exhibition Hall at Harrah's Cherokee Casino, Cherokee, North Carolina": HARRAHS_CHEROKEE_CENTER,
    "The Arena at Gwinnett Center, Duluth, Georgia": SportsballGeocodeTuple(
        city="Duluth",
        state="GA",
        postal="",
        lat=33.991389,
        lng=-84.094167,
        housenumber="6400",
        country="USA",
    ),
    "Birmingham-Jefferson Civic Center, Birmingham, Alabama": BIRMINGHAM_JEFFERSON_CIVIC_CENTER,
    "War Memorial Gymnasium, Maui, Hawaii": SportsballGeocodeTuple(
        city="Maui",
        state="HI",
        postal="96793",
        lat=20.8919129,
        lng=-156.4902234,
        housenumber="700",
        country="USA",
    ),
    "University of Tampa Sports Arena, Tampa, Florida": SportsballGeocodeTuple(
        city="Tampa",
        state="FL",
        postal="",
        lat=27.946944,
        lng=-82.468889,
        housenumber="",
        country="USA",
    ),
    "Sears Centre , Hoffman Estates, Illinois": SportsballGeocodeTuple(
        city="Hoffman Estates",
        state="IL",
        postal="",
        lat=42.071694,
        lng=-88.209456,
        housenumber="5333",
        country="USA",
    ),
    "Nassau": SportsballGeocodeTuple(
        city="Nassau",
        state="",
        postal="",
        lat=25.044167,
        lng=-77.350278,
        housenumber="",
        country="Bahamas",
    ),
    "Coliseo Juan AubÃ­n Cruz Abreu, ManatÃ­": COLISEO_JUAN_AUBIN_CRUZ_ABREU,
    "Alltel Arena, North Little Rock, Arkansas": SIMMONS_BANK_ARENA,
    "Mohegan Arena at Casey Plaza, Wilkes-Barre, Pennsylvania": SportsballGeocodeTuple(
        city="Wilkes-Barre",
        state="PA",
        postal="",
        lat=41.240471,
        lng=-75.848504,
        housenumber="255",
        country="USA",
    ),
    "St. Thomas": SportsballGeocodeTuple(
        city="St. Thomas",
        state="VI",
        postal="",
        lat=18.333333,
        lng=-64.916667,
        housenumber="255",
        country="USA",
    ),
    "Cancun": SportsballGeocodeTuple(
        city="Cancun",
        state="QR",
        postal="",
        lat=21.160556,
        lng=-86.8475,
        housenumber="",
        country="Mexico",
    ),
    "Roberts Stadium, Evansville, Indiana": ROBERTS_STADIUM,
    "Anderson Arena, Bowling Green, Ohio": SportsballGeocodeTuple(
        city="Bowling Green",
        state="OH",
        postal="",
        lat=41.376944,
        lng=-83.636389,
        housenumber="",
        country="USA",
    ),
    "Coliseo Juan Aubín Cruz Abreu, Manatí": COLISEO_JUAN_AUBIN_CRUZ_ABREU,
    "Coppin Center, Baltimore, Maryland": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.311111,
        lng=-76.657778,
        housenumber="",
        country="USA",
    ),
    "San Juan": SportsballGeocodeTuple(
        city="San Juan",
        state="PR",
        postal="",
        lat=18.406389,
        lng=-66.063889,
        housenumber="",
        country="USA",
    ),
    "Charlie Justice Center, Asheville, North Carolina": SportsballGeocodeTuple(
        city="Asheville",
        state="NC",
        postal="",
        lat=35.617507,
        lng=-82.567711,
        housenumber="",
        country="USA",
    ),
    "McArthur Court, Eugene, Oregon": SportsballGeocodeTuple(
        city="Eugene",
        state="OR",
        postal="",
        lat=44.0416,
        lng=-123.074,
        housenumber="1601",
        country="USA",
    ),
    "Poliforum Benito Juarez, Cancun": SportsballGeocodeTuple(
        city="Cancun",
        state="QR",
        postal="",
        lat=21.101111,
        lng=-86.835,
        housenumber="1601",
        country="Mexico",
    ),
    "Alario Center, Westwego, Louisiana": SportsballGeocodeTuple(
        city="Westwego",
        state="LA",
        postal="",
        lat=29.90516,
        lng=-90.16283,
        housenumber="2000",
        country="USA",
    ),
    "Blue Cross Arena, Rochester, New York": SportsballGeocodeTuple(
        city="Rochester",
        state="NY",
        postal="",
        lat=43.153694,
        lng=-77.610778,
        housenumber="1",
        country="USA",
    ),
    "Walter Athletic Complex, Tampa, Florida": SportsballGeocodeTuple(
        city="Tampa",
        state="FL",
        postal="33606",
        lat=27.9471998,
        lng=-82.4713179,
        housenumber="400",
        country="USA",
    ),
    "CenturyTel Center, Bossier City, Louisiana": BROOKSHIRE_GROCERY_ARENA,
    "Glens Falls Civic Center, Glens Falls, New York": SportsballGeocodeTuple(
        city="Glens Falls",
        state="NY",
        postal="12801",
        lat=43.308169,
        lng=-73.641782,
        housenumber="1",
        country="USA",
    ),
    "VisitLethbridge.com Arena, Lethbridge": SportsballGeocodeTuple(
        city="Lethbridge",
        state="AB",
        postal="",
        lat=49.666947,
        lng=-112.805428,
        housenumber="2510",
        country="Canada",
    ),
    "Memorial Gym, Moscow, Idaho": SportsballGeocodeTuple(
        city="Moscow",
        state="ID",
        postal="",
        lat=46.7265,
        lng=-117.014,
        housenumber="1001",
        country="USA",
    ),
    "Grand Cayman": SportsballGeocodeTuple(
        city="Grand Cayman",
        state="",
        postal="",
        lat=19.33,
        lng=-81.24,
        housenumber="",
        country="UK",
    ),
    "Coliseo Rubén Rodríguez, Bayamon": COLISEO_RUBEN_RODRIGUEZ,
    "BankCorp South Arena, Tupelo, Mississippi": SportsballGeocodeTuple(
        city="Tupelo",
        state="MS",
        postal="38804",
        lat=34.26,
        lng=-88.7,
        housenumber="375",
        country="USA",
    ),
    "Coliseo RubÃ©n RodrÃ­guez, Bayamon": COLISEO_RUBEN_RODRIGUEZ,
    "Tim's Toyota Center, Prescott, Arizona": SportsballGeocodeTuple(
        city="Prescott",
        state="AZ",
        postal="",
        lat=34.589242,
        lng=-112.336361,
        housenumber="3201",
        country="USA",
    ),
    "Bossier City, Louisiana": SportsballGeocodeTuple(
        city="Bossier City",
        state="LA",
        postal="",
        lat=32.517778,
        lng=-93.691389,
        housenumber="",
        country="USA",
    ),
    "Seabury Center, Berea, Ohio": SportsballGeocodeTuple(
        city="Berea",
        state="OH",
        postal="40404",
        lat=37.5742278,
        lng=-84.2930863,
        housenumber="313",
        country="USA",
    ),
    "Anchorage, Alaska": ANCHORAGE,
    "Mott Gymn, San Luis Obispo, California": SportsballGeocodeTuple(
        city="San Luis Obispo",
        state="CA",
        postal="",
        lat=35.29886,
        lng=-120.65855,
        housenumber="1",
        country="USA",
    ),
    "Beard–Eaves–Memorial Coliseum, Auburn, Alabama": BEARD_EAVES_MEMORIAL_COLISEUM,
    "Colonial Hall at The Greenbrier, White Sulphur Springs, West Virginia": SportsballGeocodeTuple(
        city="White Sulphur Springs",
        state="WV",
        postal="36832",
        lat=37.7854,
        lng=-80.3083,
        housenumber="",
        country="USA",
    ),
    "BeardâEavesâMemorial Coliseum, Auburn, Alabama": BEARD_EAVES_MEMORIAL_COLISEUM,
    "Vibrant Arena at The MARK, Moline, Illinois": SportsballGeocodeTuple(
        city="Moline",
        state="IL",
        postal="61265",
        lat=41.507837,
        lng=-90.520437,
        housenumber="1201",
        country="USA",
    ),
    "Summit Arena, Rapid City, South Dakota": SportsballGeocodeTuple(
        city="Rapid City",
        state="SD",
        postal="",
        lat=44.08854,
        lng=-103.225816,
        housenumber="444",
        country="USA",
    ),
    "Charleston, West Virginia": SportsballGeocodeTuple(
        city="Charleston",
        state="WV",
        postal="",
        lat=38.349819,
        lng=-81.632622,
        housenumber="",
        country="USA",
    ),
    "Shreveport, Louisiana": SHREVEPORT,
    "Tahoe Blue Event Center, Stateline, Nevada": SportsballGeocodeTuple(
        city="Stateline",
        state="NV",
        postal="89449",
        lat=38.96275,
        lng=-119.938472,
        housenumber="75",
        country="USA",
    ),
    "Greenville, Mississippi": SportsballGeocodeTuple(
        city="Greenville",
        state="MS",
        postal="",
        lat=33.384722,
        lng=-91.048333,
        housenumber="",
        country="USA",
    ),
    "Adidas Arena, Paris": SportsballGeocodeTuple(
        city="Paris",
        state="",
        postal="75018",
        lat=48.89959,
        lng=2.36075,
        housenumber="58",
        country="France",
    ),
    "Gulfport, Mississippi": SportsballGeocodeTuple(
        city="Gulfport",
        state="MS",
        postal="",
        lat=30.401667,
        lng=-89.076111,
        housenumber="",
        country="USA",
    ),
    "East Rutherford, New Jersey": SportsballGeocodeTuple(
        city="East Rutherford",
        state="NJ",
        postal="",
        lat=40.817097,
        lng=-74.085024,
        housenumber="",
        country="USA",
    ),
    "Duluth, Georgia": DULUTH,
    "Kennewick, Washington": SportsballGeocodeTuple(
        city="Kennewick",
        state="WA",
        postal="",
        lat=46.195278,
        lng=-119.173056,
        housenumber="",
        country="USA",
    ),
    "Southaven, Mississippi": SOUTHAVEN,
    "Casper, Wyoming": SportsballGeocodeTuple(
        city="Casper",
        state="WY",
        postal="",
        lat=42.85,
        lng=-106.325,
        housenumber="",
        country="USA",
    ),
    "Beard-Eaves-Memorial, Auburn, Alabama": BEARD_EAVES_MEMORIAL_COLISEUM,
    "DCU Center, Worcester, Massachusetts": SportsballGeocodeTuple(
        city="Worcester",
        state="MA",
        postal="",
        lat=42.266111,
        lng=-71.798333,
        housenumber="50",
        country="USA",
    ),
    "Wooden Family Fieldhouse, Xenia, Ohio": SportsballGeocodeTuple(
        city="Xenia",
        state="OH",
        postal="45385",
        lat=39.665597,
        lng=-83.9246487,
        housenumber="1310",
        country="USA",
    ),
    "JosÃ© Miguel Agrelot Coliseum, San Juan": JOSE_MIGUEL_AGRELOT_COLISEUM,
    "Sun National Bank Center, Trenton, New Jersey": SportsballGeocodeTuple(
        city="Trenton",
        state="NJ",
        postal="08611",
        lat=40.212778,
        lng=-74.757561,
        housenumber="81",
        country="USA",
    ),
    "The Omni, Atlanta, Georgia": OMNI_COLISEUM,
    "TD Banknorth Sports Center, Hamden, Connecticut": TD_BANK_SPORTS_CENTER,
    "Alltell Arena, North Little Rock, Arkansas": SIMMONS_BANK_ARENA,
    "Auburn Hills, Michigan": SportsballGeocodeTuple(
        city="Auburn Hills",
        state="MI",
        postal="",
        lat=42.6875,
        lng=-83.234167,
        housenumber="",
        country="USA",
    ),
    "Guaynabo": SportsballGeocodeTuple(
        city="Guaynabo",
        state="PR",
        postal="",
        lat=18.366667,
        lng=-66.1,
        housenumber="",
        country="USA",
    ),
    "Biloxi, Mississippi": SportsballGeocodeTuple(
        city="Biloxi",
        state="MS",
        postal="",
        lat=30.411944,
        lng=-88.927778,
        housenumber="",
        country="USA",
    ),
    "Glendale, Arizona": SportsballGeocodeTuple(
        city="Glendale",
        state="AZ",
        postal="",
        lat=33.538611,
        lng=-112.186389,
        housenumber="",
        country="USA",
    ),
    "Kentucky International Convention Center, Louisville, Kentucky": SportsballGeocodeTuple(
        city="Louisville",
        state="KY",
        postal="",
        lat=38.254194,
        lng=-85.755111,
        housenumber="",
        country="USA",
    ),
    "Hoffman Estates, Illinois": SportsballGeocodeTuple(
        city="Hoffman Estates",
        state="IL",
        postal="",
        lat=42.063889,
        lng=-88.146944,
        housenumber="",
        country="USA",
    ),
    "Bojangles Coliseum, Charlotte, North Carolina": SportsballGeocodeTuple(
        city="Charlotte",
        state="NC",
        postal="",
        lat=35.205164,
        lng=-80.795103,
        housenumber="2700",
        country="USA",
    ),
    "F. Mitchell Johnson Center, Charleston, South Carolina": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="",
        lat=32.785278,
        lng=-79.934167,
        housenumber="",
        country="USA",
    ),
    "Hammons Student Center, Springfield, Missouri": SportsballGeocodeTuple(
        city="Springfield",
        state="MO",
        postal="",
        lat=37.202222,
        lng=-93.284444,
        housenumber="",
        country="USA",
    ),
    "Curragh Racecourse, Ireland": SportsballGeocodeTuple(
        city="",
        state="County Kildare",
        postal="",
        lat=53.165278,
        lng=-6.845278,
        housenumber="",
        country="Ireland",
    ),
    "Doomben Racecourse, Australia": SportsballGeocodeTuple(
        city="Ascot",
        state="QLD",
        postal="",
        lat=-27.426319,
        lng=153.076033,
        housenumber="",
        country="Australia",
    ),
    "Tokyo Racecourse, Japan": SportsballGeocodeTuple(
        city="Tokyo",
        state="",
        postal="",
        lat=35.663,
        lng=139.485,
        housenumber="",
        country="Japan",
    ),
    "Newbury Racecourse, United Kingdom": SportsballGeocodeTuple(
        city="Newbury",
        state="Berkshire",
        postal="",
        lat=51.394444,
        lng=-1.300556,
        housenumber="",
        country="UK",
    ),
    "ParisLongchamp Racecourse, France": SportsballGeocodeTuple(
        city="Paris",
        state="",
        postal="",
        lat=48.85875,
        lng=2.232778,
        housenumber="",
        country="France",
    ),
    "Morphettville Racecourse, Australia": SportsballGeocodeTuple(
        city="Adelaide",
        state="SA",
        postal="",
        lat=-34.978076,
        lng=138.542747,
        housenumber="",
        country="Australia",
    ),
    "Newmarket Racecourse, United Kingdom": SportsballGeocodeTuple(
        city="Suffolk",
        state="",
        postal="",
        lat=52.230861,
        lng=0.38225,
        housenumber="",
        country="UK",
    ),
    "Nakayama Racecourse, Japan": SportsballGeocodeTuple(
        city="Funabashi",
        state="Chiba",
        postal="",
        lat=35.725556,
        lng=139.9625,
        housenumber="",
        country="Japan",
    ),
    "Randwick Racecourse, Australia": SportsballGeocodeTuple(
        city="Sydney",
        state="NSW",
        postal="",
        lat=-33.910833,
        lng=151.230278,
        housenumber="",
        country="Australia",
    ),
    "Hanshin Racecourse, Japan": SportsballGeocodeTuple(
        city="Takarazuka",
        state="Hyogo",
        postal="",
        lat=34.780222,
        lng=135.3625,
        housenumber="",
        country="Japan",
    ),
    "Meydan Racecourse, United Arab Emirates": SportsballGeocodeTuple(
        city="Dubai",
        state="",
        postal="",
        lat=25.156102,
        lng=55.306549,
        housenumber="",
        country="UAE",
    ),
    "Chukyo Racecourse, Japan": SportsballGeocodeTuple(
        city="Toyoake",
        state="Aichi",
        postal="",
        lat=35.066736,
        lng=136.989444,
        housenumber="1225",
        country="Japan",
    ),
    "Flemington Racecourse, Australia": SportsballGeocodeTuple(
        city="Melbourne",
        state="VIC",
        postal="",
        lat=-37.790278,
        lng=144.9125,
        housenumber="",
        country="Australia",
    ),
    "Turffontein Racecourse, South Africa": SportsballGeocodeTuple(
        city="Johannesburg",
        state="",
        postal="",
        lat=-26.238056,
        lng=28.046944,
        housenumber="",
        country="South Africa",
    ),
    "Ellerslie Racecourse, New Zealand": SportsballGeocodeTuple(
        city="Auckland",
        state="",
        postal="",
        lat=-36.889292,
        lng=174.805769,
        housenumber="",
        country="New Zealand",
    ),
    "Caulfield Racecourse, Australia": SportsballGeocodeTuple(
        city="Melbourne",
        state="VIC",
        postal="",
        lat=-37.881,
        lng=145.04,
        housenumber="",
        country="Australia",
    ),
    "King Abdulaziz Racecourse, Saudi Arabia": SportsballGeocodeTuple(
        city="Riyadh",
        state="",
        postal="",
        lat=24.985861,
        lng=46.785194,
        housenumber="",
        country="Saudi Arabia",
    ),
    "Kenilworth Racecourse, South Africa": SportsballGeocodeTuple(
        city="Cape Town",
        state="",
        postal="",
        lat=-33.998611,
        lng=18.479722,
        housenumber="",
        country="South Africa",
    ),
    "San Isidro Racecourse, Argentina": SportsballGeocodeTuple(
        city="San Isidro",
        state="",
        postal="",
        lat=-34.483058,
        lng=-58.519072,
        housenumber="",
        country="Argentina",
    ),
    "Kyoto Racecourse, Japan": SportsballGeocodeTuple(
        city="Fushimi-ku",
        state="Kyoto",
        postal="",
        lat=34.906667,
        lng=135.725,
        housenumber="",
        country="Japan",
    ),
    "Munich Racecourse, Germany": SportsballGeocodeTuple(
        city="Munich",
        state="",
        postal="81929",
        lat=48.1438687,
        lng=11.6556131,
        housenumber="36",
        country="Germany",
    ),
    "Del Mar Racecourse, United States of America": SportsballGeocodeTuple(
        city="Del Mar",
        state="CA",
        postal="",
        lat=32.976111,
        lng=-117.261944,
        housenumber="",
        country="USA",
    ),
    "Sha Tin, China": SportsballGeocodeTuple(
        city="Hong Kong",
        state="",
        postal="",
        lat=22.399444,
        lng=114.206667,
        housenumber="",
        country="China",
    ),
    "IRE": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=53.3543083,
        lng=-10.8559015,
        housenumber="",
        country="Ireland",
    ),
    "West Palm Beach, Florida, United States": SportsballGeocodeTuple(
        city="West Palm Beach",
        state="FL",
        postal="",
        lat=26.709722,
        lng=-80.064167,
        housenumber="",
        country="USA",
    ),
    "East Liverpool, Ohio, United States": SportsballGeocodeTuple(
        city="East Liverpool",
        state="OH",
        postal="",
        lat=40.628611,
        lng=-80.571944,
        housenumber="",
        country="USA",
    ),
    "Spokane, Washington, United States": SPOKANE,
    "Greensboro, North Carolina, United States": GREENSBORO,
    "Clinton, Maryland, United States": SportsballGeocodeTuple(
        city="Clinton",
        state="MD",
        postal="",
        lat=38.763611,
        lng=-76.895556,
        housenumber="",
        country="USA",
    ),
    "Lynwood, California, United States": SportsballGeocodeTuple(
        city="Lynwood",
        state="CA",
        postal="",
        lat=33.924722,
        lng=-118.201944,
        housenumber="",
        country="USA",
    ),
    "Buffalo, New York, United States": BUFFALO,
    "Battle Ground, Washington, United States": SportsballGeocodeTuple(
        city="Battle Ground",
        state="WA",
        postal="",
        lat=45.762778,
        lng=-122.530556,
        housenumber="",
        country="USA",
    ),
    "Los Angeles, California, United States": LOS_ANGELES,
    "Long Beach, California, United States": LONG_BEACH,
    "Philadelphia, Pennsylvania, United States": PHILADELPHIA,
    "Rockaway, New York, United States": SportsballGeocodeTuple(
        city="Rockaway",
        state="NY",
        postal="",
        lat=40.585833,
        lng=-73.816944,
        housenumber="",
        country="USA",
    ),
    "Pineville, Louisiana, United States": SportsballGeocodeTuple(
        city="Pineville",
        state="LA",
        postal="",
        lat=31.338889,
        lng=-92.4125,
        housenumber="",
        country="USA",
    ),
    "Sao Carlos, Brazil": SportsballGeocodeTuple(
        city="Sao Carlos",
        state="Sao Paulo",
        postal="",
        lat=-22.0,
        lng=-47.890833,
        housenumber="",
        country="Brazil",
    ),
    "Akron, Ohio, United States": AKRON,
    "Canton, Mississippi, United States": SportsballGeocodeTuple(
        city="Canton",
        state="MS",
        postal="",
        lat=32.611944,
        lng=-90.023333,
        housenumber="",
        country="USA",
    ),
    "East Chicago, Indiana, United States": SportsballGeocodeTuple(
        city="East Chicago",
        state="IN",
        postal="",
        lat=41.638889,
        lng=-87.459444,
        housenumber="",
        country="USA",
    ),
    "Hempstead, New York, United States": HEMPSTEAD,
    "Canton, Ohio, United States": CANTON,
    "Harlem, New York, United States": SportsballGeocodeTuple(
        city="Harlem",
        state="NY",
        postal="",
        lat=40.808889,
        lng=-73.948333,
        housenumber="",
        country="USA",
    ),
    "Bethlehem, Mississippi, United States": SportsballGeocodeTuple(
        city="Bethlehem",
        state="MS",
        postal="",
        lat=34.577222,
        lng=-89.328889,
        housenumber="",
        country="USA",
    ),
    "Richmond, Virginia, United States": RICHMOND,
    "Coeur d'Alene, Idaho, United States": SportsballGeocodeTuple(
        city="Coeur d'Alene",
        state="ID",
        postal="",
        lat=47.692778,
        lng=-116.78,
        housenumber="",
        country="USA",
    ),
    "Sant'Angelo Lodigiano, Italy": SportsballGeocodeTuple(
        city="Sant'Angelo Lodigiano",
        state="LO",
        postal="",
        lat=45.233333,
        lng=9.4,
        housenumber="",
        country="Italy",
    ),
    "Orange City, Iowa, United States": SportsballGeocodeTuple(
        city="Orange City",
        state="IO",
        postal="",
        lat=42.995833,
        lng=-96.054722,
        housenumber="",
        country="USA",
    ),
    "Indianapolis, Indiana, United States": INDIANAPOLIS,
    "Rocky Mount, North Carolina, United States": SportsballGeocodeTuple(
        city="Rocky Mount",
        state="NC",
        postal="",
        lat=35.968333,
        lng=-77.804444,
        housenumber="",
        country="USA",
    ),
    "Reynoldsburg, Ohio, United States": SportsballGeocodeTuple(
        city="Reynoldsburg",
        state="OH",
        postal="",
        lat=39.96,
        lng=-82.784722,
        housenumber="",
        country="USA",
    ),
    "St. Petersburg, Russia": SportsballGeocodeTuple(
        city="St. Petersburg",
        state="",
        postal="",
        lat=59.9375,
        lng=30.308611,
        housenumber="",
        country="Russia",
    ),
    "Dayton, Ohio, United States": DAYTON,
    "Valhalla, New York, United States": SportsballGeocodeTuple(
        city="Valhalla",
        state="NY",
        postal="",
        lat=41.075,
        lng=-73.775278,
        housenumber="",
        country="USA",
    ),
    "Trebinje, Bosnia and Herzegovina": SportsballGeocodeTuple(
        city="Trebinje",
        state="",
        postal="",
        lat=42.711944,
        lng=18.346111,
        housenumber="",
        country="Bosnia and Herzegovina",
    ),
    "Orange, New Jersey, United States": SportsballGeocodeTuple(
        city="Orange",
        state="NJ",
        postal="",
        lat=40.76804,
        lng=-74.235692,
        housenumber="",
        country="USA",
    ),
    "Vevey, Switzerland": SportsballGeocodeTuple(
        city="Vevey",
        state="Vaud",
        postal="",
        lat=46.466667,
        lng=6.85,
        housenumber="",
        country="Switzerland",
    ),
    "Bastrop, Louisiana, United States": SportsballGeocodeTuple(
        city="Bastrop",
        state="LA",
        postal="",
        lat=32.756944,
        lng=-91.890278,
        housenumber="",
        country="USA",
    ),
    "Natchitoches, Louisiana, United States": NATCHITOCHES,
    "Tampa, Florida, United States": TAMPA,
    "Palma de Mallorca, Spain": SportsballGeocodeTuple(
        city="Palma de Mallorca",
        state="",
        postal="",
        lat=39.566667,
        lng=2.65,
        housenumber="",
        country="Spain",
    ),
    "Burnsville, Minnesota, United States": SportsballGeocodeTuple(
        city="Burnsville",
        state="MN",
        postal="",
        lat=44.767778,
        lng=-93.2775,
        housenumber="",
        country="USA",
    ),
    "McLeansboro, Illinois, United States": SportsballGeocodeTuple(
        city="McLeansboro",
        state="IL",
        postal="",
        lat=38.090278,
        lng=-88.538611,
        housenumber="",
        country="USA",
    ),
    "Little Rock, Arkansas, United States": LITTLE_ROCK,
    "Pensacola, Florida, United States": PENSACOLA,
    "Portland, Tennessee, United States": SportsballGeocodeTuple(
        city="Portland",
        state="TN",
        postal="",
        lat=36.581709,
        lng=-86.516383,
        housenumber="",
        country="USA",
    ),
    "Nederland, Texas, United States": SportsballGeocodeTuple(
        city="Nederland",
        state="TX",
        postal="",
        lat=29.968889,
        lng=-94.000833,
        housenumber="",
        country="USA",
    ),
    "Indianola, Mississippi, United States": SportsballGeocodeTuple(
        city="Indianola",
        state="MS",
        postal="",
        lat=33.451111,
        lng=-90.6375,
        housenumber="",
        country="USA",
    ),
    "Belgrade, Serbia": SportsballGeocodeTuple(
        city="Belgrade",
        state="",
        postal="",
        lat=44.817778,
        lng=20.456944,
        housenumber="",
        country="Serbia",
    ),
    "Hoke, North Carolina, United States": SportsballGeocodeTuple(
        city="Hoke",
        state="NC",
        postal="",
        lat=35.017,
        lng=-79.24,
        housenumber="",
        country="USA",
    ),
    "Jackson, Mississippi, United States": JACKSON,
    "Raleigh, North Carolina, United States": RALEIGH,
    "Jamaica, New York, United States": JAMAICA,
    "Brazzaville, Republic of the Congo": SportsballGeocodeTuple(
        city="Brazzaville",
        state="",
        postal="",
        lat=-1.44,
        lng=15.556,
        housenumber="",
        country="Republic of the Congo",
    ),
    "Mullens, West Virginia, United States": SportsballGeocodeTuple(
        city="Mullens",
        state="WV",
        postal="",
        lat=37.584722,
        lng=-81.384722,
        housenumber="",
        country="USA",
    ),
    "Kinston, North Carolina, United States": SportsballGeocodeTuple(
        city="Kinston",
        state="NC",
        postal="",
        lat=35.274722,
        lng=-77.593611,
        housenumber="",
        country="USA",
    ),
    "Harvey, Illinois, United States": SportsballGeocodeTuple(
        city="Harvey",
        state="IL",
        postal="",
        lat=41.610833,
        lng=-87.651944,
        housenumber="",
        country="USA",
    ),
    "Pointe-a-Pitre, Guadeloupe": SportsballGeocodeTuple(
        city="Pointe-a-Pitre",
        state="",
        postal="",
        lat=16.2411,
        lng=-61.5331,
        housenumber="",
        country="Guadeloupe",
    ),
    "Amherst, Virginia, United States": SportsballGeocodeTuple(
        city="Amherst",
        state="VA",
        postal="",
        lat=37.576944,
        lng=-79.050556,
        housenumber="",
        country="USA",
    ),
    "Coral Gables, Florida, United States": CORAL_GABLES,
    "Bijelo Polje, Montenegro": SportsballGeocodeTuple(
        city="Bijelo Polje",
        state="",
        postal="",
        lat=43.04,
        lng=19.75,
        housenumber="",
        country="Montenegro",
    ),
    "Daytona Beach, Florida, United States": DAYTONA_BEACH,
    "Birmingham, Michigan, United States": SportsballGeocodeTuple(
        city="Birmingham",
        state="MI",
        postal="",
        lat=42.546667,
        lng=-83.211389,
        housenumber="",
        country="USA",
    ),
    "Anchorage, Alaska, United States": ANCHORAGE,
    "Berkeley, California, United States": BERKELEY,
    "Harper, Kansas, United States": SportsballGeocodeTuple(
        city="Harper",
        state="KS",
        postal="",
        lat=37.285,
        lng=-98.0275,
        housenumber="",
        country="USA",
    ),
    "Shreveport, Louisiana, United States": SHREVEPORT,
    "Seattle, Washington, United States": SEATTLE,
    "Milwaukee, Wisconsin, United States": MILWAUKEE,
    "Wallace, North Carolina, United States": SportsballGeocodeTuple(
        city="Wallace",
        state="NC",
        postal="",
        lat=34.737778,
        lng=-77.990556,
        housenumber="",
        country="USA",
    ),
    "Ft. Lauderdale, Florida, United States": SportsballGeocodeTuple(
        city="Ft. Lauderdale",
        state="FL",
        postal="",
        lat=26.133333,
        lng=-80.15,
        housenumber="",
        country="USA",
    ),
    "San Francisco, California, United States": SAN_FRANCISCO,
    "Le Robert, Martinique": SportsballGeocodeTuple(
        city="Le Robert",
        state="",
        postal="",
        lat=14.6792,
        lng=-60.9403,
        housenumber="",
        country="Martinique",
    ),
    "Memphis, Tennessee, United States": MEMPHIS,
    "Lake Wales, Florida, United States": SportsballGeocodeTuple(
        city="Lake Wales",
        state="FL",
        postal="",
        lat=27.919444,
        lng=-81.596111,
        housenumber="",
        country="USA",
    ),
    "Hibbing, Minnesota, United States": SportsballGeocodeTuple(
        city="Hibbing",
        state="MN",
        postal="",
        lat=47.417222,
        lng=-92.938333,
        housenumber="",
        country="USA",
    ),
    "Beijing, China": SportsballGeocodeTuple(
        city="Beijing",
        state="",
        postal="",
        lat=39.906667,
        lng=116.3975,
        housenumber="",
        country="China",
    ),
    "Mitchell, South Dakota, United States": SportsballGeocodeTuple(
        city="Mitchell",
        state="SD",
        postal="",
        lat=43.729444,
        lng=-98.033611,
        housenumber="",
        country="USA",
    ),
    "Bedford, Texas, United States": SportsballGeocodeTuple(
        city="Bedford",
        state="TX",
        postal="",
        lat=32.847778,
        lng=-97.122222,
        housenumber="",
        country="USA",
    ),
    "Tacoma, Washington, United States": SportsballGeocodeTuple(
        city="Tacoma",
        state="WA",
        postal="",
        lat=47.245833,
        lng=-122.459444,
        housenumber="",
        country="USA",
    ),
    "Sao Paulo, Brazil": SportsballGeocodeTuple(
        city="Sao Paulo",
        state="Sao Paulo",
        postal="",
        lat=-23.55,
        lng=-46.633333,
        housenumber="",
        country="Brazil",
    ),
    "West Baden, Indiana, United States": SportsballGeocodeTuple(
        city="West Baden",
        state="IN",
        postal="",
        lat=38.5675,
        lng=-86.611944,
        housenumber="",
        country="USA",
    ),
    "Melrose Park, Illinois, United States": SportsballGeocodeTuple(
        city="Melrose Park",
        state="IL",
        postal="",
        lat=41.907778,
        lng=-87.864444,
        housenumber="",
        country="USA",
    ),
    "Rouen, France": SportsballGeocodeTuple(
        city="Rouen",
        state="Normandy",
        postal="",
        lat=49.442778,
        lng=1.088611,
        housenumber="",
        country="France",
    ),
    "Detroit, Michigan, United States": DETROIT,
    "Palmdale, California, United States": SportsballGeocodeTuple(
        city="Palmdale",
        state="CA",
        postal="",
        lat=34.581111,
        lng=-118.100556,
        housenumber="",
        country="USA",
    ),
    "Lincolnton, North Carolina, United States": SportsballGeocodeTuple(
        city="Lincolnton",
        state="NC",
        postal="",
        lat=35.475,
        lng=-81.238611,
        housenumber="",
        country="USA",
    ),
    "Ostrava, Czechia": SportsballGeocodeTuple(
        city="Ostrava",
        state="Moravian-Silesian",
        postal="",
        lat=49.835556,
        lng=18.2925,
        housenumber="",
        country="Czechia",
    ),
    "Waukegan, Illinois, United States": SportsballGeocodeTuple(
        city="Waukegan",
        state="IL",
        postal="",
        lat=42.370278,
        lng=-87.871111,
        housenumber="",
        country="USA",
    ),
    "Eugene, Oregon, United States": EUGENE,
    "Wyoming, Michigan, United States": SportsballGeocodeTuple(
        city="Wyoming",
        state="MI",
        postal="",
        lat=42.876389,
        lng=-85.7575,
        housenumber="",
        country="USA",
    ),
    "Morrisville, Pennsylvania, United States": SportsballGeocodeTuple(
        city="Morrisville",
        state="PA",
        postal="",
        lat=40.2075,
        lng=-74.78,
        housenumber="",
        country="USA",
    ),
    "Salt Lake City, Utah, United States": SALT_LAKE_CITY,
    "Jasper, Florida, United States": SportsballGeocodeTuple(
        city="Jasper",
        state="FL",
        postal="",
        lat=30.518889,
        lng=-82.951111,
        housenumber="",
        country="USA",
    ),
    "North Canton, Ohio, United States": SportsballGeocodeTuple(
        city="North Canton",
        state="OH",
        postal="",
        lat=40.875,
        lng=-81.397222,
        housenumber="",
        country="USA",
    ),
    "Edmonds, Washington, United States": SportsballGeocodeTuple(
        city="Edmonds",
        state="WA",
        postal="",
        lat=47.806944,
        lng=-122.346667,
        housenumber="",
        country="USA",
    ),
    "Wurzburg, Germany": SportsballGeocodeTuple(
        city="Wurzburg",
        state="Bavaria",
        postal="",
        lat=49.783333,
        lng=9.933333,
        housenumber="",
        country="Germany",
    ),
    "Havre De Grace, Maryland, United States": HAVRE_DE_GRACE,
    "Paw Paw, Michigan, United States": SportsballGeocodeTuple(
        city="Paw Paw",
        state="MI",
        postal="",
        lat=42.217222,
        lng=-85.89,
        housenumber="",
        country="USA",
    ),
    "Columbus, Ohio, United States": COLUMBUS,
    "East Spencer, North Carolina, United States": SportsballGeocodeTuple(
        city="East Spencer",
        state="NC",
        postal="",
        lat=35.681667,
        lng=-80.422778,
        housenumber="",
        country="USA",
    ),
    "Greenville, South Carolina, United States": GREENVILLE,
    "Savannah, Georgia, United States": SAVANNAH,
    "Maywood, Illinois, United States": SportsballGeocodeTuple(
        city="Maywood",
        state="IL",
        postal="",
        lat=41.881111,
        lng=-87.843333,
        housenumber="",
        country="USA",
    ),
    "Clarksdale, Mississippi, United States": SportsballGeocodeTuple(
        city="Clarksdale",
        state="MS",
        postal="",
        lat=34.2,
        lng=-90.566667,
        housenumber="",
        country="USA",
    ),
    "Tolono, Illinois, United States": SportsballGeocodeTuple(
        city="Tolono",
        state="IL",
        postal="",
        lat=39.986111,
        lng=-88.259722,
        housenumber="",
        country="USA",
    ),
    "Phoenix, Illinois, United States": SportsballGeocodeTuple(
        city="Phoenix",
        state="IL",
        postal="",
        lat=41.612222,
        lng=-87.630556,
        housenumber="",
        country="USA",
    ),
    "Atlanta, Georgia, United States": ATLANTA,
    "Villa Rica, Georgia, United States": SportsballGeocodeTuple(
        city="Villa Rica",
        state="GA",
        postal="",
        lat=33.731944,
        lng=-84.92,
        housenumber="",
        country="USA",
    ),
    "Peekskill, New York, United States": SportsballGeocodeTuple(
        city="Peekskill",
        state="NY",
        postal="",
        lat=41.283333,
        lng=-73.916667,
        housenumber="",
        country="USA",
    ),
    "Baton Rouge, Louisiana, United States": BATON_ROUGE,
    "Freehold, New Jersey, United States": SportsballGeocodeTuple(
        city="Freehold",
        state="NJ",
        postal="",
        lat=40.224382,
        lng=-74.299051,
        housenumber="",
        country="USA",
    ),
    "Riverside, California, United States": RIVERSIDE,
    "Gary, Indiana, United States": SportsballGeocodeTuple(
        city="Gary",
        state="IN",
        postal="",
        lat=41.590556,
        lng=-87.346944,
        housenumber="",
        country="USA",
    ),
    "Canton, Georgia, United States": SportsballGeocodeTuple(
        city="Canton",
        state="GA",
        postal="",
        lat=34.227222,
        lng=-84.494722,
        housenumber="",
        country="USA",
    ),
    "Visalia, California, United States": SportsballGeocodeTuple(
        city="Visalia",
        state="CA",
        postal="",
        lat=36.330278,
        lng=-119.2925,
        housenumber="",
        country="USA",
    ),
    "Teaneck, New Jersey, United States": SportsballGeocodeTuple(
        city="Teaneck",
        state="NJ",
        postal="",
        lat=40.890317,
        lng=-74.011478,
        housenumber="",
        country="USA",
    ),
    "Louisville, Kentucky, United States": LOUISVILLE,
    "Santa Teresa, Brazil": SportsballGeocodeTuple(
        city="Santa Teresa",
        state="Rio de Janeiro",
        postal="",
        lat=-22.9175,
        lng=-43.188056,
        housenumber="",
        country="Brazil",
    ),
    "Tomsk, Russia": SportsballGeocodeTuple(
        city="Tomsk",
        state="",
        postal="",
        lat=56.5,
        lng=84.966667,
        housenumber="",
        country="Russia",
    ),
    "Oxford, Ohio, United States": OXFORD,
    "Newberry, South Carolina, United States": SportsballGeocodeTuple(
        city="Newberry",
        state="SC",
        postal="",
        lat=34.277778,
        lng=-81.616667,
        housenumber="",
        country="USA",
    ),
    "Irvington, New Jersey, United States": SportsballGeocodeTuple(
        city="Irvington",
        state="NJ",
        postal="",
        lat=40.723859,
        lng=-74.232522,
        housenumber="",
        country="USA",
    ),
    "Portland, Oregon, United States": PORTLAND,
    "Randolph, Wisconsin, United States": SportsballGeocodeTuple(
        city="Randolph",
        state="WI",
        postal="",
        lat=43.577778,
        lng=-89.054167,
        housenumber="",
        country="USA",
    ),
    "Racine, Wisconsin, United States": SportsballGeocodeTuple(
        city="Racine",
        state="WI",
        postal="",
        lat=42.726111,
        lng=-87.805833,
        housenumber="",
        country="USA",
    ),
    "Santa Monica, California, United States": SportsballGeocodeTuple(
        city="Santa Monica",
        state="CA",
        postal="",
        lat=34.021944,
        lng=-118.481389,
        housenumber="",
        country="USA",
    ),
    "Baltimore, Maryland, United States": BALTIMORE,
    "San Diego, California, United States": SAN_DIEGO,
    "Athens, Greece": SportsballGeocodeTuple(
        city="Athens",
        state="Attica",
        postal="",
        lat=37.984167,
        lng=23.728056,
        housenumber="",
        country="Greece",
    ),
    "Bronx, New York, United States": BRONX,
    "Merced, California, United States": SportsballGeocodeTuple(
        city="Merced",
        state="CA",
        postal="",
        lat=37.3,
        lng=-120.483333,
        housenumber="",
        country="USA",
    ),
    "Milwaukee, WI, USA": MILWAUKEE,
    "Oak Park, Illinois, United States": SportsballGeocodeTuple(
        city="Oak Park",
        state="IL",
        postal="",
        lat=41.888333,
        lng=-87.789444,
        housenumber="",
        country="USA",
    ),
    "Milton, Florida, United States": SportsballGeocodeTuple(
        city="Milton",
        state="FL",
        postal="",
        lat=30.632414,
        lng=-87.039689,
        housenumber="",
        country="USA",
    ),
    "Melbourne, Australia": SportsballGeocodeTuple(
        city="Melbourne",
        state="VIC",
        postal="",
        lat=-37.814167,
        lng=144.963056,
        housenumber="",
        country="Australia",
    ),
    "Bar, Montenegro": SportsballGeocodeTuple(
        city="Bar",
        state="",
        postal="",
        lat=42.1,
        lng=19.1,
        housenumber="",
        country="Montenegro",
    ),
    "Benin City, Nigeria": SportsballGeocodeTuple(
        city="Benin City",
        state="Edo",
        postal="",
        lat=6.333333,
        lng=5.622222,
        housenumber="",
        country="Nigeria",
    ),
    "Cortlandt Manor, New York, United States": SportsballGeocodeTuple(
        city="Cortlandt Manor",
        state="NY",
        postal="",
        lat=41.28,
        lng=-73.87,
        housenumber="",
        country="USA",
    ),
    "New Orleans, Louisiana, United States": NEW_ORLEANS_CITY,
    "Riviera Beach, Florida, United States": SportsballGeocodeTuple(
        city="Riviera Beach",
        state="FL",
        postal="",
        lat=26.78,
        lng=-80.067222,
        housenumber="",
        country="USA",
    ),
    "Youngstown, Ohio, United States": YOUNGSTOWN,
    "Pasadena, California, United States": PASADENA,
    "St. Petersburg, Florida, United States": ST_PETERSBURG,
    "Paterson, New Jersey, United States": SportsballGeocodeTuple(
        city="Paterson",
        state="NJ",
        postal="",
        lat=40.914746,
        lng=-74.162826,
        housenumber="",
        country="USA",
    ),
    "Kinna, Sweden": SportsballGeocodeTuple(
        city="Kinna",
        state="Västergötland",
        postal="",
        lat=57.516667,
        lng=12.683333,
        housenumber="",
        country="Sweden",
    ),
    "Les Abymes, Guadeloupe": SportsballGeocodeTuple(
        city="Les Abymes",
        state="",
        postal="",
        lat=16.27,
        lng=-61.52,
        housenumber="",
        country="Guadeloupe",
    ),
    "Oakland, California, United States": SportsballGeocodeTuple(
        city="Oakland",
        state="CA",
        postal="",
        lat=37.804444,
        lng=-122.270833,
        housenumber="",
        country="USA",
    ),
    "Flower Mound, Texas, United States": SportsballGeocodeTuple(
        city="Flower Mound",
        state="TX",
        postal="",
        lat=33.034167,
        lng=-97.113889,
        housenumber="",
        country="USA",
    ),
    "Cleveland, Mississippi, United States": SportsballGeocodeTuple(
        city="Cleveland",
        state="MS",
        postal="",
        lat=33.742222,
        lng=-90.741667,
        housenumber="",
        country="USA",
    ),
    "Ames, Iowa, United States": AMES,
    "Springfield, Illinois, United States": SPRINGFIELD,
    "Chesapeake, Virginia, United States": SportsballGeocodeTuple(
        city="Chesapeake",
        state="VA",
        postal="",
        lat=36.767398,
        lng=-76.287405,
        housenumber="",
        country="USA",
    ),
    "Huntington, West Virginia, United States": HUNTINGTON,
    "Saginaw, Michigan, United States": SportsballGeocodeTuple(
        city="Saginaw",
        state="MI",
        postal="",
        lat=43.42,
        lng=-83.95,
        housenumber="",
        country="USA",
    ),
    "Joinville, Brazil": SportsballGeocodeTuple(
        city="Joinville",
        state="Santa Catarina",
        postal="",
        lat=-26.3204,
        lng=-48.8437,
        housenumber="",
        country="Brazil",
    ),
    "Minneapolis, Minnesota, United States": MINNEAPOLIS,
    "Peoria, Illinois, United States": PEORIA,
    "Braunschweig, Germany": SportsballGeocodeTuple(
        city="Braunschweig",
        state="Lower Saxony",
        postal="",
        lat=52.266667,
        lng=10.516667,
        housenumber="",
        country="Germany",
    ),
    "Hamilton, Massachusetts, United States": SportsballGeocodeTuple(
        city="Hamilton",
        state="MA",
        postal="",
        lat=42.619708,
        lng=-70.854789,
        housenumber="",
        country="USA",
    ),
    "Lancaster, Pennsylvania, United States": SportsballGeocodeTuple(
        city="Lancaster",
        state="PA",
        postal="",
        lat=40.039722,
        lng=-76.304444,
        housenumber="",
        country="USA",
    ),
    "Brampton, Ontario, Canada": SportsballGeocodeTuple(
        city="Brampton",
        state="ON",
        postal="",
        lat=43.688333,
        lng=-79.760833,
        housenumber="",
        country="Canada",
    ),
    "Maio, Cabo Verde": SportsballGeocodeTuple(
        city="Maio",
        state="",
        postal="",
        lat=15.216667,
        lng=-23.166667,
        housenumber="",
        country="Cabo Verde",
    ),
    "Cayenne, French Guiana": SportsballGeocodeTuple(
        city="Cayenne",
        state="",
        postal="",
        lat=4.9372,
        lng=-52.326,
        housenumber="",
        country="French Guiana",
    ),
    "Orinda, California, United States": SportsballGeocodeTuple(
        city="Orinda",
        state="CA",
        postal="",
        lat=37.882778,
        lng=-122.179722,
        housenumber="",
        country="USA",
    ),
    "Fort Wayne, Indiana, United States": FORT_WAYNE,
    "Kelford, North Carolina, United States": SportsballGeocodeTuple(
        city="Kelford",
        state="NC",
        postal="",
        lat=36.181111,
        lng=-77.224167,
        housenumber="",
        country="USA",
    ),
    "Libertyville, Illinois, United States": SportsballGeocodeTuple(
        city="Libertyville",
        state="IL",
        postal="",
        lat=42.284222,
        lng=-87.960673,
        housenumber="",
        country="USA",
    ),
    "Sioux City, Iowa, United States": SportsballGeocodeTuple(
        city="Sioux City",
        state="IA",
        postal="",
        lat=42.498056,
        lng=-96.395556,
        housenumber="",
        country="USA",
    ),
    "Lakewood, California, United States": SportsballGeocodeTuple(
        city="Lakewood",
        state="CA",
        postal="",
        lat=33.8475,
        lng=-118.12,
        housenumber="",
        country="USA",
    ),
    "Monroe, Louisiana, United States": MONROE,
    "St. Louis Park, Minnesota, United States": SportsballGeocodeTuple(
        city="St. Louis Park",
        state="MN",
        postal="",
        lat=44.948333,
        lng=-93.348056,
        housenumber="",
        country="USA",
    ),
    "Puerto Plata, Dominican Republic": SportsballGeocodeTuple(
        city="Puerto Plata",
        state="",
        postal="",
        lat=19.8,
        lng=-70.683333,
        housenumber="",
        country="Dominican Republic",
    ),
    "GB": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=55.0,
        lng=-3.0,
        housenumber="",
        country="UK",
    ),
    "AUS": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-25.0,
        lng=133.0,
        housenumber="",
        country="Australia",
    ),
    "USA": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=40.0,
        lng=-100.0,
        housenumber="",
        country="USA",
    ),
    "NZ": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-42.0,
        lng=173.0,
        housenumber="",
        country="New Zealand",
    ),
    "SAF": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-30.0,
        lng=25.0,
        housenumber="",
        country="South Africa",
    ),
    "BRZ": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-10.0,
        lng=-52.0,
        housenumber="",
        country="Brazil",
    ),
    "FR": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=47.0,
        lng=2.0,
        housenumber="",
        country="France",
    ),
    "CHI": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=35.0,
        lng=103.0,
        housenumber="",
        country="China",
    ),
    "ARG": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-34.0,
        lng=-64.0,
        housenumber="",
        country="Argentina",
    ),
    "GER": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=51.0,
        lng=9.0,
        housenumber="",
        country="Germany",
    ),
    "Hally Valley, China": SportsballGeocodeTuple(
        city="Hong Kong",
        state="",
        postal="",
        lat=22.272778,
        lng=114.182222,
        housenumber="",
        country="China",
    ),
    "JPN": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=36.0,
        lng=138.0,
        housenumber="",
        country="Japan",
    ),
    "ITY": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=43.0,
        lng=12.0,
        housenumber="",
        country="Italy",
    ),
    "Yokohama Arena - Yokohama, Kanagawa - Japan": YOKOHAMA_ARENA,
    "Brandon, MS, USA": SportsballGeocodeTuple(
        city="Brandon",
        state="MS",
        postal="",
        lat=32.280278,
        lng=-89.998333,
        housenumber="",
        country="USA",
    ),
    "Pittsburg, CA, USA": SportsballGeocodeTuple(
        city="Pittsburg",
        state="CA",
        postal="",
        lat=38.028056,
        lng=-121.884722,
        housenumber="",
        country="USA",
    ),
    "Kahuku, HI, USA": SportsballGeocodeTuple(
        city="Kahuku",
        state="HI",
        postal="",
        lat=21.680278,
        lng=-157.950278,
        housenumber="",
        country="USA",
    ),
    "Sunnyside, New York, United States": SportsballGeocodeTuple(
        city="Sunnyside",
        state="NY",
        postal="",
        lat=40.743,
        lng=-73.92,
        housenumber="",
        country="USA",
    ),
    "Santiago Bernabéu - Madrid": SportsballGeocodeTuple(
        city="Madrid",
        state="",
        postal="",
        lat=40.453056,
        lng=-3.688333,
        housenumber="",
        country="Spain",
    ),
    "CAN": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=60.0,
        lng=-110.0,
        housenumber="",
        country="Canada",
    ),
    "Camarillo, CA, USA": SportsballGeocodeTuple(
        city="Camarillo",
        state="CA",
        postal="",
        lat=34.233333,
        lng=-119.033333,
        housenumber="",
        country="USA",
    ),
    "GR": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=39.0,
        lng=22.0,
        housenumber="",
        country="Greece",
    ),
    "Camden, New Jersey, United States": SportsballGeocodeTuple(
        city="Camden",
        state="NJ",
        postal="",
        lat=39.94,
        lng=-75.105,
        housenumber="",
        country="USA",
    ),
    "Madison, Wisconsin, United States": MADISON,
    "Schenectady, New York, United States": SportsballGeocodeTuple(
        city="Schenectady",
        state="NY",
        postal="",
        lat=42.814167,
        lng=-73.937222,
        housenumber="",
        country="USA",
    ),
    "Bellevue, WA, USA": SportsballGeocodeTuple(
        city="Bellevue",
        state="WA",
        postal="",
        lat=47.614444,
        lng=-122.153611,
        housenumber="",
        country="USA",
    ),
    "ZIM": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=-19.0,
        lng=30.0,
        housenumber="",
        country="Zimbabwe",
    ),
    "Inkster, Michigan, United States": SportsballGeocodeTuple(
        city="Inkster",
        state="MI",
        postal="",
        lat=42.2925,
        lng=-83.314167,
        housenumber="",
        country="USA",
    ),
    "Danville, Virginia, United States": SportsballGeocodeTuple(
        city="Danville",
        state="VA",
        postal="",
        lat=36.587222,
        lng=-79.404444,
        housenumber="",
        country="USA",
    ),
    "Antioch, CA, USA": SportsballGeocodeTuple(
        city="Antioch",
        state="CA",
        postal="",
        lat=38.005,
        lng=-121.805833,
        housenumber="",
        country="USA",
    ),
    "San Jose, CA, USA": SAN_JOSE,
    "Miami Arena, Miami, Florida": MIAMI_ARENA,
    "IND": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=21.0,
        lng=78.0,
        housenumber="",
        country="India",
    ),
    "NH": SportsballGeocodeTuple(
        city="",
        state="",
        postal="",
        lat=52.0,
        lng=6.0,
        housenumber="",
        country="Netherlands",
    ),
    "Federal Way, WA, USA": SportsballGeocodeTuple(
        city="Federal Way",
        state="WA",
        postal="",
        lat=47.313333,
        lng=-122.372222,
        housenumber="",
        country="USA",
    ),
    "BJCC Arena, Birmingham, Alabama": BIRMINGHAM_JEFFERSON_CIVIC_CENTER,
    "Long Beach, CA, USA": LONG_BEACH,
    "Kirkland, WA, USA": SportsballGeocodeTuple(
        city="Kirkland",
        state="WA",
        postal="",
        lat=47.7,
        lng=-122.225,
        housenumber="",
        country="USA",
    ),
    "Seffner, FL, USA": SportsballGeocodeTuple(
        city="Seffner",
        state="FL",
        postal="",
        lat=27.992222,
        lng=-82.276667,
        housenumber="",
        country="USA",
    ),
    "Woodinville, WA, USA": SportsballGeocodeTuple(
        city="Woodinville",
        state="WA",
        postal="",
        lat=47.7525,
        lng=-122.143056,
        housenumber="",
        country="USA",
    ),
    "Hawthorne, CA, USA": SportsballGeocodeTuple(
        city="Hawthorne",
        state="CA",
        postal="",
        lat=33.917222,
        lng=-118.348611,
        housenumber="",
        country="USA",
    ),
    "Fresno, CA, USA": FRESNO,
    "Jamestown, NY, USA": SportsballGeocodeTuple(
        city="Jamestown",
        state="NY",
        postal="",
        lat=42.095556,
        lng=-79.238611,
        housenumber="",
        country="USA",
    ),
    "The Summit, Houston, Texas": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.730278,
        lng=-95.435,
        housenumber="3700",
        country="USA",
    ),
    "Folsom, CA, USA": SportsballGeocodeTuple(
        city="Folsom",
        state="CA",
        postal="",
        lat=38.672222,
        lng=-121.157778,
        housenumber="",
        country="USA",
    ),
    "Carlson Center, Fairbanks, Alaska": SportsballGeocodeTuple(
        city="Fairbanks",
        state="AL",
        postal="99701",
        lat=64.842244,
        lng=-147.764081,
        housenumber="2010",
        country="USA",
    ),
    "Orlando Arena, Orlando, Florida": ORLANDO_ARENA,
    "Reno, NV, USA": RENO,
    "Larkspur, CA, USA": SportsballGeocodeTuple(
        city="Larkspur",
        state="CA",
        postal="",
        lat=37.934167,
        lng=-122.535278,
        housenumber="",
        country="USA",
    ),
    "Crawford Hall, Irvine, California": SportsballGeocodeTuple(
        city="Irvine",
        state="CA",
        postal="",
        lat=33.647778,
        lng=-117.848056,
        housenumber="",
        country="USA",
    ),
    "Tacoma Dome, Tacoma, Washington": TACOMA_DOME,
    "Union Multipurpose Activity Center, Tulsa, Oklahoma": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="",
        lat=36.064005,
        lng=-95.869403,
        housenumber="",
        country="USA",
    ),
    "Great Western Forum, Inglewood, California": SportsballGeocodeTuple(
        city="Inglewood",
        state="CA",
        postal="",
        lat=33.958333,
        lng=-118.341667,
        housenumber="3900",
        country="USA",
    ),
    "Hamden, Connecticut": SportsballGeocodeTuple(
        city="Hamden",
        state="CT",
        postal="",
        lat=41.397778,
        lng=-72.921667,
        housenumber="",
        country="USA",
    ),
    "Chattanooga, Tennessee, United States": CHATTANOOGA,
    "Coliseum at Richfield, Richfield, Ohio": SportsballGeocodeTuple(
        city="Richfield",
        state="OH",
        postal="",
        lat=41.245278,
        lng=-81.593889,
        housenumber="2923",
        country="USA",
    ),
    "Joe L. Reed Acadome, Montgomery, Alabama": DUNN_OLIVER_ACADOME,
    "Omni Coliseum, Atlanta, Georgia": OMNI_COLISEUM,
    "Caldwell, ID, USA": SportsballGeocodeTuple(
        city="Caldwell",
        state="ID",
        postal="",
        lat=43.644444,
        lng=-116.646944,
        housenumber="",
        country="USA",
    ),
    "Calgary, AB, Canada": SportsballGeocodeTuple(
        city="Calgary",
        state="AB",
        postal="",
        lat=51.05,
        lng=-114.066667,
        housenumber="",
        country="Canada",
    ),
    "Auburn, WA, USA": SportsballGeocodeTuple(
        city="Auburn",
        state="WA",
        postal="",
        lat=47.303889,
        lng=-122.227222,
        housenumber="",
        country="USA",
    ),
    "Quitman, MS, USA": SportsballGeocodeTuple(
        city="Quitman",
        state="MS",
        postal="",
        lat=32.043056,
        lng=-88.720833,
        housenumber="",
        country="USA",
    ),
    "Rancho Cucamonga, CA, USA": SportsballGeocodeTuple(
        city="Rancho Cucamonga",
        state="CA",
        postal="",
        lat=34.123333,
        lng=-117.579444,
        housenumber="",
        country="USA",
    ),
    "Carson, CA, USA": SportsballGeocodeTuple(
        city="Carson",
        state="CA",
        postal="",
        lat=33.839722,
        lng=-118.259722,
        housenumber="",
        country="USA",
    ),
    "Allen, TX, USA": SportsballGeocodeTuple(
        city="Allen",
        state="TX",
        postal="",
        lat=33.126944,
        lng=-96.663056,
        housenumber="",
        country="USA",
    ),
    "Detroit, MI, USA": DETROIT,
    "Claremont, CA, USA": SportsballGeocodeTuple(
        city="Claremont",
        state="CA",
        postal="",
        lat=34.11,
        lng=-117.719722,
        housenumber="",
        country="USA",
    ),
    "Canton, OH, USA": CANTON,
    "South Jordan, UT, USA": SportsballGeocodeTuple(
        city="South Jordan",
        state="UT",
        postal="",
        lat=40.561667,
        lng=-111.960833,
        housenumber="",
        country="USA",
    ),
    "Snellville, GA, USA": SportsballGeocodeTuple(
        city="Snellville",
        state="GA",
        postal="",
        lat=40.561667,
        lng=-111.960833,
        housenumber="",
        country="USA",
    ),
    "Spring Valley, CA, USA": SportsballGeocodeTuple(
        city="Spring Valley",
        state="CA",
        postal="",
        lat=32.734444,
        lng=-116.981389,
        housenumber="",
        country="USA",
    ),
    "Shreveport, LA, USA": SHREVEPORT,
    "Brendan Byrne Arena, East Rutherford, New Jersey": SportsballGeocodeTuple(
        city="East Rutherford",
        state="NJ",
        postal="",
        lat=40.811667,
        lng=-74.0675,
        housenumber="50",
        country="USA",
    ),
    "Beaverton, OR, USA": SportsballGeocodeTuple(
        city="Beaverton",
        state="OR",
        postal="",
        lat=45.477778,
        lng=-122.816667,
        housenumber="",
        country="USA",
    ),
    "Memphis, TN, USA": MEMPHIS,
    "Sumner, WA, USA": SportsballGeocodeTuple(
        city="Sumner",
        state="WA",
        postal="",
        lat=47.225,
        lng=-122.246667,
        housenumber="",
        country="USA",
    ),
    "White Castle, LA, USA": SportsballGeocodeTuple(
        city="White Castle",
        state="LA",
        postal="",
        lat=30.161111,
        lng=-91.149444,
        housenumber="",
        country="USA",
    ),
    "Mission Hills, CA, USA": SportsballGeocodeTuple(
        city="Mission Hills",
        state="CA",
        postal="",
        lat=34.257222,
        lng=-118.467222,
        housenumber="",
        country="USA",
    ),
    "Mishawaka, IN, USA": SportsballGeocodeTuple(
        city="Mishawaka",
        state="IN",
        postal="",
        lat=41.654167,
        lng=-86.163333,
        housenumber="",
        country="USA",
    ),
    "Tumwater, WA, USA": SportsballGeocodeTuple(
        city="Tumwater",
        state="WA",
        postal="",
        lat=47.007778,
        lng=-122.911111,
        housenumber="",
        country="USA",
    ),
    "Anderson, SC, USA": SportsballGeocodeTuple(
        city="Anderson",
        state="SC",
        postal="",
        lat=34.503333,
        lng=-82.650278,
        housenumber="",
        country="USA",
    ),
    "Canyon Country, CA, USA": SportsballGeocodeTuple(
        city="Canyon Country",
        state="CA",
        postal="",
        lat=34.42,
        lng=-118.45,
        housenumber="",
        country="USA",
    ),
    "Port Neches, TX, USA": SportsballGeocodeTuple(
        city="Port Neches",
        state="TX",
        postal="",
        lat=29.988889,
        lng=-93.961667,
        housenumber="",
        country="USA",
    ),
    "Seibert Hall, Birmingham, Alabama": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.4643,
        lng=-86.7959,
        housenumber="",
        country="USA",
    ),
    "Martinsburg, WV, USA": SportsballGeocodeTuple(
        city="Martinsburg",
        state="WV",
        postal="",
        lat=39.453611,
        lng=-77.995556,
        housenumber="",
        country="USA",
    ),
    "Lehi, UT, USA": SportsballGeocodeTuple(
        city="Lehi",
        state="UT",
        postal="",
        lat=40.387778,
        lng=-111.871667,
        housenumber="",
        country="USA",
    ),
    "Ontario, CA, USA": SportsballGeocodeTuple(
        city="Ontario",
        state="CA",
        postal="",
        lat=34.052778,
        lng=-117.627778,
        housenumber="",
        country="USA",
    ),
    "Brentwood, CA, USA": SportsballGeocodeTuple(
        city="Brentwood",
        state="CA",
        postal="",
        lat=37.931944,
        lng=-121.695833,
        housenumber="",
        country="USA",
    ),
    "Scottsdale, AZ, USA": SCOTTSDALE,
    "Moorhead, MN, USA": SportsballGeocodeTuple(
        city="Moorhead",
        state="MN",
        postal="",
        lat=46.873889,
        lng=-96.767222,
        housenumber="",
        country="USA",
    ),
    "Orange, CA, USA": SportsballGeocodeTuple(
        city="Orange",
        state="CA",
        postal="",
        lat=33.803056,
        lng=-117.8325,
        housenumber="",
        country="USA",
    ),
    "Puyallup, WA, USA": SportsballGeocodeTuple(
        city="Puyallup",
        state="WA",
        postal="",
        lat=47.175556,
        lng=-122.272222,
        housenumber="",
        country="USA",
    ),
    "Valdosta, GA, USA": SportsballGeocodeTuple(
        city="Valdosta",
        state="GA",
        postal="",
        lat=30.846667,
        lng=-83.283056,
        housenumber="",
        country="USA",
    ),
    "Columbia, MO, USA": SportsballGeocodeTuple(
        city="Columbia",
        state="MO",
        postal="",
        lat=38.9475,
        lng=-92.326667,
        housenumber="",
        country="USA",
    ),
    "Homestead, FL, USA": SportsballGeocodeTuple(
        city="Homestead",
        state="FL",
        postal="",
        lat=25.468722,
        lng=-80.477557,
        housenumber="",
        country="USA",
    ),
    "Virginia Beach, VA, USA": VIRGINIA_BEACH,
    "Greer, SC, USA": SportsballGeocodeTuple(
        city="Greer",
        state="SC",
        postal="",
        lat=34.930278,
        lng=-82.225,
        housenumber="",
        country="USA",
    ),
    "Eminence, KY, USA": SportsballGeocodeTuple(
        city="Eminence",
        state="KY",
        postal="",
        lat=38.363611,
        lng=-85.177778,
        housenumber="",
        country="USA",
    ),
    "St. Petersburg, FL, USA": ST_PETERSBURG,
    "Nicholls, GA, USA": SportsballGeocodeTuple(
        city="Nicholls",
        state="GA",
        postal="",
        lat=31.516944,
        lng=-82.637778,
        housenumber="",
        country="USA",
    ),
    "Columbus, GA, USA": SportsballGeocodeTuple(
        city="Columbus",
        state="GA",
        postal="",
        lat=32.492222,
        lng=-84.940278,
        housenumber="",
        country="USA",
    ),
    "Ascot, England": SportsballGeocodeTuple(
        city="Ascot",
        state="",
        postal="",
        lat=51.4084,
        lng=-0.6707,
        housenumber="",
        country="UK",
    ),
    "Douglasville, GA, USA": SportsballGeocodeTuple(
        city="Douglasville",
        state="GA",
        postal="",
        lat=33.751389,
        lng=-84.747778,
        housenumber="",
        country="USA",
    ),
    "Knoxville, TN, USA": KNOXVILLE,
    "Bradenton, FL, USA": SportsballGeocodeTuple(
        city="Bradenton",
        state="FL",
        postal="",
        lat=27.483333,
        lng=-82.583333,
        housenumber="",
        country="USA",
    ),
    "Henderson, KY, USA": SportsballGeocodeTuple(
        city="Henderson",
        state="KY",
        postal="",
        lat=37.835556,
        lng=-87.580833,
        housenumber="",
        country="USA",
    ),
    "Inglewood, CA, USA": SportsballGeocodeTuple(
        city="Inglewood",
        state="CA",
        postal="",
        lat=33.9575,
        lng=-118.346111,
        housenumber="",
        country="USA",
    ),
    "Saline, MI, USA": SportsballGeocodeTuple(
        city="Saline",
        state="MI",
        postal="",
        lat=42.170833,
        lng=-83.779722,
        housenumber="",
        country="USA",
    ),
    "Tampa, FL, USA": TAMPA,
    "Hebron, KY, USA": SportsballGeocodeTuple(
        city="Hebron",
        state="KY",
        postal="",
        lat=39.0625,
        lng=-84.709722,
        housenumber="",
        country="USA",
    ),
    "Lagrange, KY, USA": SportsballGeocodeTuple(
        city="Lagrange",
        state="KY",
        postal="",
        lat=38.398611,
        lng=-85.375,
        housenumber="",
        country="USA",
    ),
    "Lilburn, GA, USA": SportsballGeocodeTuple(
        city="Lilburn",
        state="GA",
        postal="",
        lat=33.888889,
        lng=-84.140833,
        housenumber="",
        country="USA",
    ),
    "Noblesville, IN, USA": SportsballGeocodeTuple(
        city="Noblesville",
        state="IN",
        postal="",
        lat=40.025,
        lng=-85.952778,
        housenumber="",
        country="USA",
    ),
    "Forsyth, GA, USA": SportsballGeocodeTuple(
        city="Forsyth",
        state="GA",
        postal="",
        lat=33.035,
        lng=-83.938056,
        housenumber="",
        country="USA",
    ),
    "Sunnyvale, TX, USA": SportsballGeocodeTuple(
        city="Sunnyvale",
        state="TX",
        postal="",
        lat=32.803611,
        lng=-96.569722,
        housenumber="",
        country="USA",
    ),
    "Farrell, PA, USA": SportsballGeocodeTuple(
        city="Farrell",
        state="PA",
        postal="",
        lat=41.211667,
        lng=-80.494167,
        housenumber="",
        country="USA",
    ),
    "Shelby, NC, USA": SportsballGeocodeTuple(
        city="Shelby",
        state="NC",
        postal="",
        lat=35.290278,
        lng=-81.545278,
        housenumber="",
        country="USA",
    ),
    "Jacksonville, AR, USA": SportsballGeocodeTuple(
        city="Jacksonville",
        state="AR",
        postal="",
        lat=34.873056,
        lng=-92.115278,
        housenumber="",
        country="USA",
    ),
    "Louisville, KY, USA": LOUISVILLE,
    "Irondale, AL, USA": SportsballGeocodeTuple(
        city="Irondale",
        state="AL",
        postal="",
        lat=33.531944,
        lng=-86.686944,
        housenumber="",
        country="USA",
    ),
    "Overland Park, KS, USA": SportsballGeocodeTuple(
        city="Overland Park",
        state="KS",
        postal="",
        lat=38.886944,
        lng=-94.686944,
        housenumber="",
        country="USA",
    ),
    "Elon, NC, USA": ELON,
    "Alabaster, AL, USA": SportsballGeocodeTuple(
        city="Alabaster",
        state="AL",
        postal="",
        lat=33.231162,
        lng=-86.823829,
        housenumber="",
        country="USA",
    ),
    "Germantown, TN, USA": SportsballGeocodeTuple(
        city="Germantown",
        state="TN",
        postal="",
        lat=35.088889,
        lng=-89.793889,
        housenumber="",
        country="USA",
    ),
    "UFCU Stadium - San Marcos - TX - 78666": SportsballGeocodeTuple(
        city="San Marcos",
        state="TX",
        postal="78666",
        lat=29.891111,
        lng=-97.925556,
        housenumber="1100",
        country="USA",
    ),
    "Lithia, FL, USA": SportsballGeocodeTuple(
        city="Lithia",
        state="FL",
        postal="",
        lat=27.850278,
        lng=-82.174722,
        housenumber="",
        country="USA",
    ),
    "Midlothian, TX, USA": SportsballGeocodeTuple(
        city="Midlothian",
        state="TX",
        postal="",
        lat=32.506944,
        lng=-97.006944,
        housenumber="",
        country="USA",
    ),
    "Crosby, TX, USA": SportsballGeocodeTuple(
        city="Crosby",
        state="TX",
        postal="",
        lat=29.910577,
        lng=-95.060882,
        housenumber="",
        country="USA",
    ),
    "Edna, TX, USA": SportsballGeocodeTuple(
        city="Edna",
        state="TX",
        postal="",
        lat=28.978611,
        lng=-96.646111,
        housenumber="",
        country="USA",
    ),
    "Nacogdoches, TX, USA": NACOGDOCHES,
    "Madisonville, TX, USA": SportsballGeocodeTuple(
        city="Madisonville",
        state="TX",
        postal="",
        lat=30.950833,
        lng=-95.9125,
        housenumber="",
        country="USA",
    ),
    "Ennis, TX, USA": SportsballGeocodeTuple(
        city="Ennis",
        state="TX",
        postal="",
        lat=32.329444,
        lng=-96.625278,
        housenumber="",
        country="USA",
    ),
    "Phenix City, AL, USA": SportsballGeocodeTuple(
        city="Phenix City",
        state="AL",
        postal="",
        lat=32.470833,
        lng=-85.002778,
        housenumber="",
        country="USA",
    ),
    "Liberty Hill, TX, USA": SportsballGeocodeTuple(
        city="Liberty Hill",
        state="TX",
        postal="",
        lat=30.655556,
        lng=-97.913889,
        housenumber="",
        country="USA",
    ),
    "Southaven, MS, USA": SOUTHAVEN,
    "Chagrin Falls, OH, USA": SportsballGeocodeTuple(
        city="Chagrin Falls",
        state="OH",
        postal="",
        lat=41.431111,
        lng=-81.388611,
        housenumber="",
        country="USA",
    ),
    "Lynwood, CA, USA": SportsballGeocodeTuple(
        city="Lynwood",
        state="CA",
        postal="",
        lat=33.924722,
        lng=-118.201944,
        housenumber="",
        country="USA",
    ),
    "Hebron, TX, USA": SportsballGeocodeTuple(
        city="Hebron",
        state="TX",
        postal="",
        lat=33.026389,
        lng=-96.863611,
        housenumber="",
        country="USA",
    ),
    "Pensacola, FL, USA": PENSACOLA,
    "Frisco, TX, USA": SportsballGeocodeTuple(
        city="Frisco",
        state="TX",
        postal="",
        lat=33.141667,
        lng=-96.821667,
        housenumber="",
        country="USA",
    ),
    "Rowlett, TX, USA": SportsballGeocodeTuple(
        city="Rowlett",
        state="TX",
        postal="",
        lat=32.902778,
        lng=-96.544444,
        housenumber="",
        country="USA",
    ),
    "Charlotte, NC, USA": CHARLOTTE,
    "Sugar Land, TX, USA": SportsballGeocodeTuple(
        city="Sugar Land",
        state="TX",
        postal="",
        lat=29.599444,
        lng=-95.614167,
        housenumber="",
        country="USA",
    ),
    "Elgin, TX, USA": SportsballGeocodeTuple(
        city="Elgin",
        state="TX",
        postal="",
        lat=30.348611,
        lng=-97.3725,
        housenumber="",
        country="USA",
    ),
    "Duluth, GA, USA": DULUTH,
    "Pittsburgh, PA, USA": PITTSBURGH,
    "Ashtabula, OH, USA": SportsballGeocodeTuple(
        city="Ashtabula",
        state="OH",
        postal="",
        lat=41.874444,
        lng=-80.795833,
        housenumber="",
        country="USA",
    ),
    "Salem, OR, USA": SportsballGeocodeTuple(
        city="Salem",
        state="OR",
        postal="",
        lat=44.923056,
        lng=-123.024444,
        housenumber="",
        country="USA",
    ),
    "Mansfield, OH, USA": SportsballGeocodeTuple(
        city="Mansfield",
        state="OH",
        postal="",
        lat=40.753333,
        lng=-82.504444,
        housenumber="",
        country="USA",
    ),
    "Springfield, IL, USA": SPRINGFIELD,
    "Carrollton, TX, USA": SportsballGeocodeTuple(
        city="Carrollton",
        state="TX",
        postal="",
        lat=32.953611,
        lng=-96.890278,
        housenumber="",
        country="USA",
    ),
    "Little Rock, AR, USA": LITTLE_ROCK,
    "Plaquemine, LA, USA": SportsballGeocodeTuple(
        city="Plaquemine",
        state="LA",
        postal="",
        lat=30.281389,
        lng=-91.248889,
        housenumber="",
        country="USA",
    ),
    "Ahoskie, NC, USA": SportsballGeocodeTuple(
        city="Ahoskie",
        state="NC",
        postal="",
        lat=36.284167,
        lng=-76.99,
        housenumber="",
        country="USA",
    ),
    "Nashville, AR, USA": SportsballGeocodeTuple(
        city="Nashville",
        state="AR",
        postal="",
        lat=33.94826,
        lng=-93.84704,
        housenumber="",
        country="USA",
    ),
    "New Braunfels, TX, USA": SportsballGeocodeTuple(
        city="New Braunfels",
        state="TX",
        postal="",
        lat=29.725,
        lng=-98.125556,
        housenumber="",
        country="USA",
    ),
    "Lee, FL, USA": SportsballGeocodeTuple(
        city="Lee",
        state="FL",
        postal="",
        lat=30.419444,
        lng=-83.299722,
        housenumber="",
        country="USA",
    ),
    "Dana Point, CA, USA": SportsballGeocodeTuple(
        city="Dana Point",
        state="CA",
        postal="",
        lat=33.467222,
        lng=-117.698056,
        housenumber="",
        country="USA",
    ),
    "Atlanta, GA, USA": ATLANTA,
    "Waynesville, MO, USA": SportsballGeocodeTuple(
        city="Waynesville",
        state="MO",
        postal="",
        lat=37.82,
        lng=-92.220278,
        housenumber="",
        country="USA",
    ),
    "Waterford, MI, USA": SportsballGeocodeTuple(
        city="Waterford",
        state="MI",
        postal="",
        lat=42.658333,
        lng=-83.386111,
        housenumber="",
        country="USA",
    ),
    "Leander, TX, USA": SportsballGeocodeTuple(
        city="Leander",
        state="TX",
        postal="",
        lat=30.578889,
        lng=-97.853056,
        housenumber="",
        country="USA",
    ),
    "Waxahachie, TX, USA": SportsballGeocodeTuple(
        city="Waxahachie",
        state="TX",
        postal="",
        lat=32.391667,
        lng=-96.844444,
        housenumber="",
        country="USA",
    ),
    "Sumter, SC, USA": SportsballGeocodeTuple(
        city="Sumter",
        state="SC",
        postal="",
        lat=33.920556,
        lng=-80.341667,
        housenumber="",
        country="USA",
    ),
    "Newport, KY, USA": SportsballGeocodeTuple(
        city="Newport",
        state="KY",
        postal="",
        lat=39.088611,
        lng=-84.490278,
        housenumber="",
        country="USA",
    ),
    "Midland, TX, USA": SportsballGeocodeTuple(
        city="Midland",
        state="TX",
        postal="",
        lat=32.0,
        lng=-102.1,
        housenumber="",
        country="USA",
    ),
    "Cleveland, TX, USA": SportsballGeocodeTuple(
        city="Cleveland",
        state="TX",
        postal="",
        lat=30.345,
        lng=-95.083611,
        housenumber="",
        country="USA",
    ),
    "La Mirada, CA, USA": SportsballGeocodeTuple(
        city="La Mirada",
        state="CA",
        postal="",
        lat=33.902222,
        lng=-118.009722,
        housenumber="",
        country="USA",
    ),
    "New Orleans, LA, USA": NEW_ORLEANS_CITY,
    "Slidell, LA, USA": SportsballGeocodeTuple(
        city="Slidell",
        state="LA",
        postal="",
        lat=30.279167,
        lng=-89.777778,
        housenumber="",
        country="USA",
    ),
    "Bryan, TX, USA": SportsballGeocodeTuple(
        city="Bryan",
        state="TX",
        postal="",
        lat=30.674444,
        lng=-96.37,
        housenumber="",
        country="USA",
    ),
    "Marseille, France": SportsballGeocodeTuple(
        city="Marseille",
        state="",
        postal="",
        lat=43.2964,
        lng=5.37,
        housenumber="",
        country="France",
    ),
    "Rusk, TX, USA": SportsballGeocodeTuple(
        city="Rusk",
        state="TX",
        postal="",
        lat=31.795556,
        lng=-95.15,
        housenumber="",
        country="USA",
    ),
    "Stafford, TX, USA": SportsballGeocodeTuple(
        city="Stafford",
        state="TX",
        postal="",
        lat=29.624167,
        lng=-95.563333,
        housenumber="",
        country="USA",
    ),
    "Cypress, TX, USA": SportsballGeocodeTuple(
        city="Cypress",
        state="TX",
        postal="",
        lat=29.970833,
        lng=-95.697222,
        housenumber="",
        country="USA",
    ),
    "Plano, TX, USA": SportsballGeocodeTuple(
        city="Plano",
        state="TX",
        postal="",
        lat=33.050278,
        lng=-96.698889,
        housenumber="",
        country="USA",
    ),
    "Lumberton, TX, USA": SportsballGeocodeTuple(
        city="Lumberton",
        state="TX",
        postal="",
        lat=30.236111,
        lng=-94.229722,
        housenumber="",
        country="USA",
    ),
    "Anna, TX, USA": SportsballGeocodeTuple(
        city="Anna",
        state="TX",
        postal="",
        lat=33.355556,
        lng=-96.561944,
        housenumber="",
        country="USA",
    ),
    "Kilgore, TX, USA": SportsballGeocodeTuple(
        city="Kilgore",
        state="TX",
        postal="",
        lat=32.385556,
        lng=-94.868611,
        housenumber="",
        country="USA",
    ),
    "Aubrey, TX, USA": SportsballGeocodeTuple(
        city="Aubrey",
        state="TX",
        postal="",
        lat=33.307222,
        lng=-96.983889,
        housenumber="",
        country="USA",
    ),
    "Nolensville, TN, USA": SportsballGeocodeTuple(
        city="Nolensville",
        state="TN",
        postal="",
        lat=35.956667,
        lng=-86.666944,
        housenumber="",
        country="USA",
    ),
    "Humble, TX, USA": SportsballGeocodeTuple(
        city="Aubrey",
        state="TX",
        postal="",
        lat=29.995,
        lng=-95.265,
        housenumber="",
        country="USA",
    ),
    "Deer Park, TX, USA": SportsballGeocodeTuple(
        city="Aubrey",
        state="TX",
        postal="",
        lat=29.692003,
        lng=-95.118108,
        housenumber="",
        country="USA",
    ),
    "Ventura, CA, USA": SportsballGeocodeTuple(
        city="Ventura",
        state="CA",
        postal="",
        lat=34.275,
        lng=-119.227778,
        housenumber="",
        country="USA",
    ),
    "Bendigo, VIC, Australia": SportsballGeocodeTuple(
        city="Bendigo",
        state="VIC",
        postal="",
        lat=-36.75,
        lng=144.266667,
        housenumber="",
        country="Australia",
    ),
    "Providence, UT, USA": SportsballGeocodeTuple(
        city="Providence",
        state="UT",
        postal="",
        lat=41.703333,
        lng=-111.813333,
        housenumber="",
        country="USA",
    ),
    "West Jordan, UT, USA": SportsballGeocodeTuple(
        city="West Jordan",
        state="UT",
        postal="",
        lat=40.606389,
        lng=-111.976111,
        housenumber="",
        country="USA",
    ),
    "Las Vegas, NV, USA": LAS_VEGAS,
    "Aledo, TX, USA": SportsballGeocodeTuple(
        city="Aledo",
        state="TX",
        postal="",
        lat=32.705,
        lng=-97.615556,
        housenumber="",
        country="USA",
    ),
    "Minneola, FL, USA": SportsballGeocodeTuple(
        city="Minneola",
        state="FL",
        postal="",
        lat=28.606667,
        lng=-81.732222,
        housenumber="",
        country="USA",
    ),
    "Rigby, ID, USA": SportsballGeocodeTuple(
        city="Rigby",
        state="ID",
        postal="",
        lat=43.673333,
        lng=-111.913333,
        housenumber="",
        country="USA",
    ),
    "Woods Cross, UT, USA": SportsballGeocodeTuple(
        city="Woods Cross",
        state="UT",
        postal="",
        lat=40.876667,
        lng=-111.916111,
        housenumber="",
        country="USA",
    ),
    "Winter Haven, FL, USA": SportsballGeocodeTuple(
        city="Winter Haven",
        state="FL",
        postal="",
        lat=28.023056,
        lng=-81.734444,
        housenumber="",
        country="USA",
    ),
    "San Mateo, CA, USA": SportsballGeocodeTuple(
        city="San Mateo",
        state="CA",
        postal="",
        lat=37.554167,
        lng=-122.313056,
        housenumber="",
        country="USA",
    ),
    "Idaho Falls, ID, USA": SportsballGeocodeTuple(
        city="Idaho Falls",
        state="ID",
        postal="",
        lat=43.500556,
        lng=-112.027778,
        housenumber="",
        country="USA",
    ),
    "Mission Viejo, CA, USA": SportsballGeocodeTuple(
        city="Mission Viejo",
        state="CA",
        postal="",
        lat=33.596944,
        lng=-117.658333,
        housenumber="",
        country="USA",
    ),
    "Magna, UT, USA": SportsballGeocodeTuple(
        city="Magna",
        state="UT",
        postal="",
        lat=40.722222,
        lng=-112.076667,
        housenumber="",
        country="USA",
    ),
    "Pasadena, CA, USA": PASADENA,
    "Rock Hill, SC, USA": ROCK_HILL,
    "Rocklin, CA, USA": SportsballGeocodeTuple(
        city="Rocklin",
        state="CA",
        postal="",
        lat=38.8,
        lng=-121.246667,
        housenumber="",
        country="USA",
    ),
    "Rancho Santa Margarita, CA, USA": SportsballGeocodeTuple(
        city="Rancho Santa Margarita",
        state="CA",
        postal="",
        lat=33.641389,
        lng=-117.594444,
        housenumber="",
        country="USA",
    ),
    "Los Angeles, CA, USA": LOS_ANGELES,
    "Auckland, New Zealand": SportsballGeocodeTuple(
        city="Auckland",
        state="",
        postal="",
        lat=-36.849167,
        lng=174.765278,
        housenumber="",
        country="New Zealand",
    ),
    "Rosenberg, TX, USA": SportsballGeocodeTuple(
        city="Rosenberg",
        state="TX",
        postal="",
        lat=29.5525,
        lng=-95.805,
        housenumber="",
        country="USA",
    ),
    "Gold Coast, QLD, Australia": SportsballGeocodeTuple(
        city="Gold Coast",
        state="QLD",
        postal="",
        lat=-28.016667,
        lng=153.4,
        housenumber="",
        country="Australia",
    ),
    "Pleasant Grove, UT, USA": SportsballGeocodeTuple(
        city="Pleasant Grove",
        state="UT",
        postal="",
        lat=40.370278,
        lng=-111.748056,
        housenumber="",
        country="USA",
    ),
    "Hauula, HI, USA": SportsballGeocodeTuple(
        city="Hauula",
        state="HI",
        postal="",
        lat=21.613889,
        lng=-157.913611,
        housenumber="",
        country="USA",
    ),
    "Midvale, UT, USA": SportsballGeocodeTuple(
        city="Midvale",
        state="UT",
        postal="",
        lat=40.613889,
        lng=-111.888333,
        housenumber="",
        country="USA",
    ),
    "Bluffdale, UT, USA": SportsballGeocodeTuple(
        city="Bluffdale",
        state="UT",
        postal="",
        lat=40.473333,
        lng=-111.944444,
        housenumber="",
        country="USA",
    ),
    "Rahway, NJ, USA": SportsballGeocodeTuple(
        city="Rahway",
        state="NJ",
        postal="",
        lat=40.607152,
        lng=-74.280531,
        housenumber="",
        country="USA",
    ),
    "American Fork, UT, USA": SportsballGeocodeTuple(
        city="American Fork",
        state="UT",
        postal="",
        lat=40.361111,
        lng=-111.790556,
        housenumber="",
        country="USA",
    ),
    "Queen Creek, AZ, USA": SportsballGeocodeTuple(
        city="Queen Creek",
        state="AZ",
        postal="",
        lat=33.248611,
        lng=-111.634167,
        housenumber="",
        country="USA",
    ),
    "Monument, CO, USA": SportsballGeocodeTuple(
        city="Monument",
        state="CO",
        postal="",
        lat=39.081111,
        lng=-104.8625,
        housenumber="",
        country="USA",
    ),
    "Prosper, TX, USA": SportsballGeocodeTuple(
        city="Prosper",
        state="TX",
        postal="",
        lat=33.245833,
        lng=-96.840833,
        housenumber="",
        country="USA",
    ),
    "Peoria, AZ, USA": SportsballGeocodeTuple(
        city="Peoria",
        state="AZ",
        postal="",
        lat=33.5825,
        lng=-112.238611,
        housenumber="",
        country="USA",
    ),
    "Vienna, VA, USA": SportsballGeocodeTuple(
        city="Vienna",
        state="VA",
        postal="",
        lat=38.9,
        lng=-77.266667,
        housenumber="",
        country="USA",
    ),
    "Sioux Falls, SD, USA": SIOUX_FALLS,
    "Richmond, TX, USA": SportsballGeocodeTuple(
        city="Richmond",
        state="TX",
        postal="",
        lat=29.582222,
        lng=-95.760833,
        housenumber="",
        country="USA",
    ),
    "Stockton, CA, USA": STOCKTON,
    "Anahuac, TX, USA": SportsballGeocodeTuple(
        city="Anahuac",
        state="TX",
        postal="",
        lat=29.756944,
        lng=-94.681389,
        housenumber="",
        country="USA",
    ),
    "Pomona, CA, USA": SportsballGeocodeTuple(
        city="Pomona",
        state="CA",
        postal="",
        lat=34.060833,
        lng=-117.755833,
        housenumber="",
        country="USA",
    ),
    "North Salt Lake, UT, USA": SportsballGeocodeTuple(
        city="North Salt Lake",
        state="UT",
        postal="",
        lat=40.840278,
        lng=-111.904167,
        housenumber="",
        country="USA",
    ),
    "Boston, MA, USA": BOSTON,
    "Spanish Fork, UT, USA": SportsballGeocodeTuple(
        city="Spanish Fork",
        state="UT",
        postal="",
        lat=40.115,
        lng=-111.638333,
        housenumber="",
        country="USA",
    ),
    "Fairfield, CA, USA": SportsballGeocodeTuple(
        city="Fairfield",
        state="CA",
        postal="",
        lat=38.257778,
        lng=-122.054167,
        housenumber="",
        country="USA",
    ),
    "Winchester, VA, USA": SportsballGeocodeTuple(
        city="Winchester",
        state="VA",
        postal="",
        lat=39.183333,
        lng=-78.166667,
        housenumber="",
        country="USA",
    ),
    "Bellflower, CA, USA": SportsballGeocodeTuple(
        city="Bellflower",
        state="CA",
        postal="",
        lat=33.888056,
        lng=-118.1275,
        housenumber="",
        country="USA",
    ),
    "Randolph, MA, USA": SportsballGeocodeTuple(
        city="Randolph",
        state="MA",
        postal="",
        lat=42.1625,
        lng=-71.041667,
        housenumber="",
        country="USA",
    ),
    "St. George, UT, USA": ST_GEORGE,
    "Garland, UT, USA": SportsballGeocodeTuple(
        city="Garland",
        state="UT",
        postal="",
        lat=41.736111,
        lng=-112.162778,
        housenumber="",
        country="USA",
    ),
    "ARCO Arena (I), Sacramento, California": ARCO_ARENA,
    "Arizona Veterans Memorial Coliseum, Phoenix, Arizona": SportsballGeocodeTuple(
        city="Phoenix",
        state="AZ",
        postal="",
        lat=33.469444,
        lng=-112.096667,
        housenumber="1826",
        country="USA",
    ),
    "Tylertown, Mississippi, United States": SportsballGeocodeTuple(
        city="Tylertown",
        state="MS",
        postal="",
        lat=31.116111,
        lng=-90.142778,
        housenumber="",
        country="USA",
    ),
    "Freedom Hall - Louisville, Kentucky - United States": FREEDOM_HALL,
    "Roberts Stadium": ROBERTS_STADIUM,
    "Sports Arena": ARCO_ARENA,
    "Veterans Memorial Auditorium": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="",
        lat=41.829847,
        lng=-71.417425,
        housenumber="",
        country="USA",
    ),
    "Long Beach Arena": LONG_BEACH_ARENA,
    "Las Vegas Convention Center": SportsballGeocodeTuple(
        city="Las Vegas",
        state="NV",
        postal="",
        lat=36.131516,
        lng=-115.151507,
        housenumber="3150",
        country="USA",
    ),
    "Mid-South Coliseum": MID_SOUTH_COLISEUM,
    "Charleston Civic Center": CHARLESTON_CIVIC_CENTER,
    "Montreal Forum": SportsballGeocodeTuple(
        city="Montreal",
        state="QC",
        postal="",
        lat=45.490278,
        lng=-73.584722,
        housenumber="2313",
        country="Canada",
    ),
    "Roberts Municipal Stadium": SportsballGeocodeTuple(
        city="Evansville",
        state="IN",
        postal="47711",
        lat=37.97903,
        lng=-87.515926,
        housenumber="2600",
        country="USA",
    ),
    "Selland Arena": SELLAND_ARENA,
    "Carolina Coliseum": SportsballGeocodeTuple(
        city="Columbia",
        state="SC",
        postal="29201",
        lat=37.97903,
        lng=-87.515926,
        housenumber="701",
        country="USA",
    ),
    "Washington College": SportsballGeocodeTuple(
        city="Chestertown",
        state="MD",
        postal="",
        lat=39.218056,
        lng=-76.069444,
        housenumber="",
        country="USA",
    ),
    "Maple Leaf Gardens - Toronto, Ontario - United States": MAPLE_LEAF_GARDENS,
    "El Paso County Coliseum": SportsballGeocodeTuple(
        city="El Paso",
        state="TX",
        postal="79905",
        lat=31.766389,
        lng=-106.443056,
        housenumber="4100",
        country="USA",
    ),
    "Providence Civic Center": AMICA_MUTUAL_PAVILION,
    "Sacramento State College": SportsballGeocodeTuple(
        city="Sacramento",
        state="CA",
        postal="",
        lat=38.560222,
        lng=-121.424111,
        housenumber="",
        country="USA",
    ),
    "Weber State College": WEBER_STATE_COLLEGE,
    "Mississippi Coast Coliseum": MISSISSIPPI_COAST_COLISEUM,
    "University of Arizona": UNIVERSITY_OF_ARIZONA,
    "Riverside Centroplex": SportsballGeocodeTuple(
        city="Baton Rouge",
        state="LA",
        postal="",
        lat=30.4448,
        lng=-91.1894,
        housenumber="",
        country="USA",
    ),
    "Duke University": DUKE_UNIVERSITY,
    "Bowling Green College": SportsballGeocodeTuple(
        city="Bowling Green",
        state="OH",
        postal="",
        lat=41.38,
        lng=-83.63,
        housenumber="",
        country="USA",
    ),
    "New Mexico State College": SportsballGeocodeTuple(
        city="Las Cruces",
        state="NM",
        postal="",
        lat=32.283,
        lng=-106.748,
        housenumber="",
        country="USA",
    ),
    "Eastern Michigan College": SportsballGeocodeTuple(
        city="Ypsilanti",
        state="MI",
        postal="",
        lat=42.250154,
        lng=-83.624454,
        housenumber="",
        country="USA",
    ),
    "Kentucky College": UNIVERSITY_OF_KENTUCKY,
    "Iowa College": SportsballGeocodeTuple(
        city="Iowa City",
        state="IA",
        postal="",
        lat=41.661667,
        lng=-91.536389,
        housenumber="",
        country="USA",
    ),
    "Marshall College": SportsballGeocodeTuple(
        city="Huntington",
        state="WV",
        postal="",
        lat=38.42508,
        lng=-82.42046,
        housenumber="",
        country="USA",
    ),
    "Miami (FL) College": SportsballGeocodeTuple(
        city="Miami",
        state="FL",
        postal="",
        lat=25.7216,
        lng=-80.2793,
        housenumber="",
        country="USA",
    ),
    "Maryland College": SportsballGeocodeTuple(
        city="College Park",
        state="MD",
        postal="",
        lat=38.988,
        lng=-76.943,
        housenumber="",
        country="USA",
    ),
    "Bowling Green State University": SportsballGeocodeTuple(
        city="Bowling Green",
        state="OH",
        postal="",
        lat=41.38,
        lng=-83.63,
        housenumber="",
        country="USA",
    ),
    "University of Florida": SportsballGeocodeTuple(
        city="Gainesville",
        state="FL",
        postal="",
        lat=29.6475,
        lng=-82.345,
        housenumber="",
        country="USA",
    ),
    "University of Cincinnati": SportsballGeocodeTuple(
        city="Cincinnati",
        state="OH",
        postal="",
        lat=39.132778,
        lng=-84.515278,
        housenumber="",
        country="USA",
    ),
    "Arizona College": UNIVERSITY_OF_ARIZONA,
    "LSU College": SportsballGeocodeTuple(
        city="Baton Rouge",
        state="LA",
        postal="",
        lat=30.4145,
        lng=-91.17826,
        housenumber="",
        country="USA",
    ),
    "University of Rhode Island": SportsballGeocodeTuple(
        city="Kingston",
        state="RI",
        postal="",
        lat=41.48071,
        lng=-71.5258,
        housenumber="",
        country="USA",
    ),
    "Army College": SportsballGeocodeTuple(
        city="West Point",
        state="NY",
        postal="",
        lat=41.393,
        lng=-73.958,
        housenumber="",
        country="USA",
    ),
    "San Jose State College": SportsballGeocodeTuple(
        city="San Jose",
        state="CA",
        postal="",
        lat=37.3353,
        lng=-121.8813,
        housenumber="",
        country="USA",
    ),
    "Toledo College": SportsballGeocodeTuple(
        city="Toledo",
        state="OH",
        postal="",
        lat=41.657716,
        lng=-83.61366,
        housenumber="",
        country="USA",
    ),
    "Eastern Illinois College": SportsballGeocodeTuple(
        city="Charleston",
        state="IL",
        postal="",
        lat=39.484444,
        lng=-88.175278,
        housenumber="",
        country="USA",
    ),
    "University of Alabama": SportsballGeocodeTuple(
        city="Tuscaloosa",
        state="AL",
        postal="",
        lat=33.210833,
        lng=-87.546111,
        housenumber="",
        country="USA",
    ),
    "Boston College College": BOSTON_COLLEGE,
    "UNLV College": SportsballGeocodeTuple(
        city="Las Vegas",
        state="NV",
        postal="",
        lat=36.10779,
        lng=-115.14376,
        housenumber="",
        country="USA",
    ),
    "Olympia Stadium": DETROIT_OLYMPIA,
    "Lakefront Arena - New Orleans, Louisiana - United States": LAKEFRONT_ARENA,
    "Michigan College": SportsballGeocodeTuple(
        city="Ann Arbor",
        state="MI",
        postal="",
        lat=42.276944,
        lng=-83.738056,
        housenumber="",
        country="USA",
    ),
    "Mary Hardin-Baylor College": SportsballGeocodeTuple(
        city="Belton",
        state="TX",
        postal="",
        lat=31.0665,
        lng=-97.464,
        housenumber="",
        country="USA",
    ),
    "Holy Cross College": SportsballGeocodeTuple(
        city="Worcester",
        state="MA",
        postal="",
        lat=42.239167,
        lng=-71.808333,
        housenumber="",
        country="USA",
    ),
    "West Texas A&M College": SportsballGeocodeTuple(
        city="Canyon",
        state="TX",
        postal="",
        lat=34.9844,
        lng=-101.9134,
        housenumber="",
        country="USA",
    ),
    "Oklahoma College": SportsballGeocodeTuple(
        city="Norman",
        state="OK",
        postal="",
        lat=35.2088,
        lng=-97.4457,
        housenumber="",
        country="USA",
    ),
    "Bethune-Cookman College": SportsballGeocodeTuple(
        city="Daytona Beach",
        state="FL",
        postal="",
        lat=29.2103,
        lng=-81.0306,
        housenumber="",
        country="USA",
    ),
    "Nevada College": SportsballGeocodeTuple(
        city="Reno",
        state="NV",
        postal="",
        lat=39.537778,
        lng=-119.813889,
        housenumber="",
        country="USA",
    ),
    "Wisconsin College": SportsballGeocodeTuple(
        city="Madison",
        state="WI",
        postal="",
        lat=43.075278,
        lng=-89.404167,
        housenumber="",
        country="USA",
    ),
    "BYU College": SportsballGeocodeTuple(
        city="Provo",
        state="UT",
        postal="",
        lat=40.25,
        lng=-111.649,
        housenumber="",
        country="USA",
    ),
    "Manitoba, Canada": SportsballGeocodeTuple(
        city="",
        state="MB",
        postal="",
        lat=55.0,
        lng=-97.0,
        housenumber="",
        country="Canada",
    ),
    "Robbinsdale, Minnesota, United States": SportsballGeocodeTuple(
        city="Robbinsdale",
        state="MN",
        postal="",
        lat=45.032222,
        lng=-93.338611,
        housenumber="",
        country="USA",
    ),
    "Cole Harbour, Nova Scotia, Canada": SportsballGeocodeTuple(
        city="Cole Harbour",
        state="NS",
        postal="",
        lat=44.671667,
        lng=-63.489722,
        housenumber="",
        country="Canada",
    ),
    "Borlange, Sweden": SportsballGeocodeTuple(
        city="Borlange",
        state="",
        postal="",
        lat=60.485556,
        lng=15.436389,
        housenumber="",
        country="Sweden",
    ),
    "Vasteras, Sweden": SportsballGeocodeTuple(
        city="Vasteras",
        state="",
        postal="",
        lat=59.616111,
        lng=16.552778,
        housenumber="",
        country="Sweden",
    ),
    "Regina, Saskatchewan, Canada": SportsballGeocodeTuple(
        city="Regina",
        state="SK",
        postal="",
        lat=50.454722,
        lng=-104.606667,
        housenumber="",
        country="Canada",
    ),
    "Burnaby, British Columbia, Canada": SportsballGeocodeTuple(
        city="Burnaby",
        state="BC",
        postal="",
        lat=49.266667,
        lng=-122.966667,
        housenumber="",
        country="Canada",
    ),
    "Lagos, Nigeria": SportsballGeocodeTuple(
        city="Lagos",
        state="",
        postal="",
        lat=6.455027,
        lng=3.384082,
        housenumber="",
        country="Nigeria",
    ),
    "Oakville, Ontario, Canada": SportsballGeocodeTuple(
        city="Oakville",
        state="ON",
        postal="",
        lat=43.456389,
        lng=-79.713889,
        housenumber="",
        country="Canada",
    ),
    "Moscow, USSR": MOSCOW,
    "Ljubljana, Slovenia": SportsballGeocodeTuple(
        city="Ljubljana",
        state="",
        postal="",
        lat=46.051389,
        lng=14.506111,
        housenumber="",
        country="Slovenia",
    ),
    "Wichita, Kansas, United States": WICHITA,
    "Stockholm, Sweden": SportsballGeocodeTuple(
        city="Stockholm",
        state="",
        postal="",
        lat=59.329444,
        lng=18.068611,
        housenumber="",
        country="Sweden",
    ),
    "Hinesville, Georgia, United States": SportsballGeocodeTuple(
        city="Robbinsdale",
        state="MN",
        postal="",
        lat=45.032222,
        lng=-93.338611,
        housenumber="",
        country="USA",
    ),
    "Floral, Saskatchewan, Canada": SportsballGeocodeTuple(
        city="Floral",
        state="SK",
        postal="",
        lat=52.056944,
        lng=-106.511111,
        housenumber="",
        country="Canada",
    ),
    "Yaounde, Cameroon": SportsballGeocodeTuple(
        city="Yaounde",
        state="",
        postal="",
        lat=3.866667,
        lng=11.516667,
        housenumber="",
        country="Cameroon",
    ),
    "Vancouver, British Columbia, Canada": SportsballGeocodeTuple(
        city="Vancouver",
        state="BC",
        postal="",
        lat=49.260833,
        lng=-123.113889,
        housenumber="",
        country="Canada",
    ),
    "Boston, Massachusetts, United States": BOSTON,
    "Richmond Hill, Ontario, Canada": SportsballGeocodeTuple(
        city="Richmond Hill",
        state="ON",
        postal="",
        lat=43.871389,
        lng=-79.437222,
        housenumber="",
        country="Canada",
    ),
    "Kuopio, Finland": SportsballGeocodeTuple(
        city="Kuopio",
        state="",
        postal="",
        lat=62.8925,
        lng=27.678333,
        housenumber="",
        country="Finland",
    ),
    "Vienna, Austria": SportsballGeocodeTuple(
        city="Vienna",
        state="",
        postal="",
        lat=48.208333,
        lng=16.3725,
        housenumber="",
        country="Austria",
    ),
    "Edmonton, Alberta, Canada": SportsballGeocodeTuple(
        city="Edmonton",
        state="AB",
        postal="",
        lat=53.534444,
        lng=-113.490278,
        housenumber="",
        country="Canada",
    ),
    "Havre de Grace, Maryland, United States": HAVRE_DE_GRACE,
    "Anahim Lake, British Columbia, Canada": SportsballGeocodeTuple(
        city="Anahim Lake",
        state="BC",
        postal="",
        lat=52.466667,
        lng=-125.316667,
        housenumber="",
        country="Canada",
    ),
    "Las Vegas, Nevada, United States": LAS_VEGAS,
    "Brantford, Ontario, Canada": SportsballGeocodeTuple(
        city="Brantford",
        state="ON",
        postal="",
        lat=43.156944,
        lng=-80.2575,
        housenumber="",
        country="Canada",
    ),
    "Gothenburg, Sweden": SportsballGeocodeTuple(
        city="Gothenburg",
        state="",
        postal="",
        lat=57.7075,
        lng=11.9675,
        housenumber="",
        country="Sweden",
    ),
    "Castries, Saint Lucia": SportsballGeocodeTuple(
        city="Castries",
        state="",
        postal="",
        lat=14.010833,
        lng=-60.989444,
        housenumber="",
        country="Saint Lucia",
    ),
    "Rayville, Louisiana, United States": SportsballGeocodeTuple(
        city="Rayville",
        state="LA",
        postal="",
        lat=32.47,
        lng=-91.7575,
        housenumber="",
        country="USA",
    ),
    "Maykop, Russia": SportsballGeocodeTuple(
        city="Maykop",
        state="",
        postal="",
        lat=44.6,
        lng=40.083333,
        housenumber="",
        country="Russia",
    ),
    "Le Chesnay, France": SportsballGeocodeTuple(
        city="Le Chesnay",
        state="",
        postal="",
        lat=48.8211,
        lng=2.1311,
        housenumber="",
        country="France",
    ),
    "Cologne, Germany": SportsballGeocodeTuple(
        city="Cologne",
        state="",
        postal="",
        lat=50.936389,
        lng=6.952778,
        housenumber="",
        country="Germany",
    ),
    "Baham, Cameroon": SportsballGeocodeTuple(
        city="Baham",
        state="",
        postal="",
        lat=5.333333,
        lng=10.4,
        housenumber="",
        country="Cameroon",
    ),
    "Peterborough, Ontario, Canada": SportsballGeocodeTuple(
        city="Peterborough",
        state="ON",
        postal="",
        lat=44.301111,
        lng=-78.333333,
        housenumber="",
        country="Canada",
    ),
    "Martins Ferry, Ohio, United States": SportsballGeocodeTuple(
        city="Martins Ferry",
        state="OH",
        postal="",
        lat=40.119444,
        lng=-80.718056,
        housenumber="",
        country="USA",
    ),
    "Victoria, British Columbia, Canada": SportsballGeocodeTuple(
        city="Victoria",
        state="BC",
        postal="",
        lat=48.428333,
        lng=-123.364722,
        housenumber="",
        country="Canada",
    ),
    "Winnipeg, Manitoba, Canada": SportsballGeocodeTuple(
        city="Winnipeg",
        state="MB",
        postal="",
        lat=49.895556,
        lng=-97.138611,
        housenumber="",
        country="Canada",
    ),
    "London, Ontario, Canada": SportsballGeocodeTuple(
        city="London",
        state="ON",
        postal="",
        lat=42.9675,
        lng=-81.2325,
        housenumber="",
        country="Canada",
    ),
    "Kladno, Czechoslovakia": SportsballGeocodeTuple(
        city="Kladno",
        state="",
        postal="",
        lat=50.143056,
        lng=14.105278,
        housenumber="",
        country="Czech Republic",
    ),
    "Franklin, Tennessee, United States": SportsballGeocodeTuple(
        city="Franklin",
        state="TN",
        postal="",
        lat=35.929167,
        lng=-86.8575,
        housenumber="",
        country="USA",
    ),
    "Bendigo, Australia": SportsballGeocodeTuple(
        city="Bendigo",
        state="VIC",
        postal="",
        lat=-36.75,
        lng=144.266667,
        housenumber="",
        country="Czech Republic",
    ),
    "Moscow, Russia": MOSCOW,
    "Lubbock, Texas, United States": LUBBOCK,
    "Hamilton, Ontario, Canada": SportsballGeocodeTuple(
        city="Hamilton",
        state="ON",
        postal="",
        lat=43.242778,
        lng=-79.989444,
        housenumber="",
        country="Canada",
    ),
    "Halifax, Nova Scotia, Canada": SportsballGeocodeTuple(
        city="Halifax",
        state="NS",
        postal="",
        lat=44.6475,
        lng=-63.590556,
        housenumber="",
        country="Canada",
    ),
    "Wausau, Wisconsin, United States": SportsballGeocodeTuple(
        city="Wausau",
        state="WI",
        postal="",
        lat=44.95,
        lng=-89.633333,
        housenumber="",
        country="USA",
    ),
    "Grand Rapids, Michigan, United States": SportsballGeocodeTuple(
        city="Grand Rapids",
        state="MI",
        postal="",
        lat=42.963333,
        lng=-85.667778,
        housenumber="",
        country="USA",
    ),
    "Geneva, Switzerland": SportsballGeocodeTuple(
        city="Geneva",
        state="",
        postal="",
        lat=46.201667,
        lng=6.146944,
        housenumber="",
        country="Switzerland",
    ),
    "Richardson, Texas, United States": SportsballGeocodeTuple(
        city="Richardson",
        state="TX",
        postal="",
        lat=32.991667,
        lng=-96.703889,
        housenumber="",
        country="USA",
    ),
    "Strakonice, Czechia": SportsballGeocodeTuple(
        city="Strakonice",
        state="",
        postal="",
        lat=40.889398,
        lng=-74.045698,
        housenumber="",
        country="Czech Republic",
    ),
    "Hackensack, New Jersey, United States": SportsballGeocodeTuple(
        city="Hackensack",
        state="NJ",
        postal="",
        lat=40.889398,
        lng=-74.045698,
        housenumber="",
        country="USA",
    ),
    "Dakar, Senegal": SportsballGeocodeTuple(
        city="Dakar",
        state="",
        postal="",
        lat=14.692778,
        lng=-17.446667,
        housenumber="",
        country="Senegal",
    ),
    "Malaga, Spain": SportsballGeocodeTuple(
        city="Malaga",
        state="",
        postal="",
        lat=36.719444,
        lng=-4.42,
        housenumber="",
        country="Spain",
    ),
    "West Vancouver, British Columbia, Canada": SportsballGeocodeTuple(
        city="West Vancouver",
        state="BC",
        postal="",
        lat=49.366667,
        lng=-123.166667,
        housenumber="",
        country="Canada",
    ),
    "Joliette, Quebec, Canada": SportsballGeocodeTuple(
        city="Joliette",
        state="QC",
        postal="",
        lat=46.016667,
        lng=-73.45,
        housenumber="",
        country="Canada",
    ),
    "Espoo, Finland": SportsballGeocodeTuple(
        city="Espoo",
        state="",
        postal="",
        lat=60.205556,
        lng=24.655556,
        housenumber="",
        country="Finland",
    ),
    "Windsor, Ontario, Canada": SportsballGeocodeTuple(
        city="Windsor",
        state="ON",
        postal="",
        lat=42.302222,
        lng=-82.993611,
        housenumber="",
        country="Canada",
    ),
    "Kiiminki, Finland": SportsballGeocodeTuple(
        city="Kiiminki",
        state="",
        postal="",
        lat=65.133333,
        lng=25.775,
        housenumber="",
        country="Finland",
    ),
    "Pardubice, Czechoslovakia": SportsballGeocodeTuple(
        city="Pardubice",
        state="",
        postal="",
        lat=50.038611,
        lng=15.779167,
        housenumber="",
        country="Czech Republic",
    ),
    "Novokuznetsk, USSR": SportsballGeocodeTuple(
        city="Novokuznetsk",
        state="",
        postal="",
        lat=53.766667,
        lng=87.133333,
        housenumber="",
        country="Russia",
    ),
    "Whitby, Ontario, Canada": SportsballGeocodeTuple(
        city="Whitby",
        state="ON",
        postal="",
        lat=43.9325,
        lng=-78.954444,
        housenumber="",
        country="Canada",
    ),
    "Lipetsk, USSR": SportsballGeocodeTuple(
        city="Lipetsk",
        state="",
        postal="",
        lat=52.616667,
        lng=39.6,
        housenumber="",
        country="Russia",
    ),
    "Holland Landing, Ontario, Canada": SportsballGeocodeTuple(
        city="Holland Landing",
        state="ON",
        postal="",
        lat=44.089444,
        lng=-79.495,
        housenumber="",
        country="Canada",
    ),
    "St. Cloud, Minnesota, United States": SportsballGeocodeTuple(
        city="St. Cloud",
        state="MN",
        postal="",
        lat=45.534167,
        lng=-94.171667,
        housenumber="",
        country="USA",
    ),
    "Scottsdale, Arizona, United States": SCOTTSDALE,
    "Linkoping, Sweden": SportsballGeocodeTuple(
        city="Linkoping",
        state="",
        postal="",
        lat=58.415833,
        lng=15.625278,
        housenumber="",
        country="Sweden",
    ),
    "Siilinjarvi, Finland": SportsballGeocodeTuple(
        city="Siilinjarvi",
        state="",
        postal="",
        lat=63.075,
        lng=27.66,
        housenumber="",
        country="Finland",
    ),
    "Tampere, Finland": SportsballGeocodeTuple(
        city="Tampere",
        state="",
        postal="",
        lat=61.498056,
        lng=23.76,
        housenumber="",
        country="Finland",
    ),
    "Arlington, Texas, United States": ARLINGTON,
    "Colorado College": SportsballGeocodeTuple(
        city="Colorado Springs",
        state="CO",
        postal="",
        lat=38.8479,
        lng=-104.8228,
        housenumber="",
        country="USA",
    ),
    "University of Houston": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.7189,
        lng=-95.3392,
        housenumber="",
        country="USA",
    ),
    "Duke College": DUKE_UNIVERSITY,
    "University of Connecticut": SportsballGeocodeTuple(
        city="Storrs",
        state="CT",
        postal="",
        lat=41.807222,
        lng=-72.2525,
        housenumber="",
        country="USA",
    ),
    "Idaho State College": SportsballGeocodeTuple(
        city="Pocatello",
        state="ID",
        postal="",
        lat=42.861,
        lng=-112.434,
        housenumber="",
        country="USA",
    ),
    "Southern Miss College": SportsballGeocodeTuple(
        city="Hattiesburg",
        state="MS",
        postal="",
        lat=31.329638,
        lng=-89.333847,
        housenumber="",
        country="USA",
    ),
    "Rice College": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.716944,
        lng=-95.402778,
        housenumber="",
        country="USA",
    ),
    "Olten, Switzerland": SportsballGeocodeTuple(
        city="Olten",
        state="",
        postal="",
        lat=47.35,
        lng=7.9,
        housenumber="",
        country="Switzerland",
    ),
    "California College": SportsballGeocodeTuple(
        city="Berkeley",
        state="CA",
        postal="",
        lat=37.871944,
        lng=-122.258333,
        housenumber="",
        country="USA",
    ),
    "University of Pittsburgh": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.4446,
        lng=-79.9533,
        housenumber="",
        country="USA",
    ),
    "Gardner-Webb College": SportsballGeocodeTuple(
        city="Boiling Springs",
        state="NC",
        postal="",
        lat=35.247456,
        lng=-81.670622,
        housenumber="",
        country="USA",
    ),
    "Purdue College": SportsballGeocodeTuple(
        city="West Lafayette",
        state="IN",
        postal="",
        lat=40.425,
        lng=-86.923056,
        housenumber="",
        country="USA",
    ),
    "Oulu, Finland": SportsballGeocodeTuple(
        city="Oulu",
        state="",
        postal="",
        lat=65.014167,
        lng=25.471944,
        housenumber="",
        country="Finland",
    ),
    "Fayetteville, Georgia, United States": SportsballGeocodeTuple(
        city="Fayetteville",
        state="GA",
        postal="",
        lat=33.447778,
        lng=-84.461667,
        housenumber="",
        country="USA",
    ),
    "New York University": SportsballGeocodeTuple(
        city="New York",
        state="NY",
        postal="",
        lat=40.73,
        lng=-73.995,
        housenumber="",
        country="USA",
    ),
    "Stanford College": SportsballGeocodeTuple(
        city="Stanford",
        state="CA",
        postal="",
        lat=37.4275,
        lng=-122.17,
        housenumber="",
        country="USA",
    ),
    "Pittsburgh College": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.4446,
        lng=-79.9533,
        housenumber="",
        country="USA",
    ),
    "Villanova College": VILLANOVA_COLLEGE,
    "Namur, Belgium": SportsballGeocodeTuple(
        city="Namur",
        state="",
        postal="",
        lat=50.466667,
        lng=4.866667,
        housenumber="",
        country="Belgium",
    ),
    "Gaylord Family Oklahoma Memorial Stadium": SportsballGeocodeTuple(
        city="Norman",
        state="OK",
        postal="",
        lat=35.205833,
        lng=-97.4425,
        housenumber="",
        country="USA",
    ),
    "Compaq Center": COMPAQ_CENTER,
    "University of Virginia": SportsballGeocodeTuple(
        city="Charlottesville",
        state="VA",
        postal="",
        lat=38.035556,
        lng=-78.503333,
        housenumber="",
        country="USA",
    ),
    "Fredricksburg, VA, USA": SportsballGeocodeTuple(
        city="Fredricksburg",
        state="VA",
        postal="",
        lat=38.301829,
        lng=-77.470778,
        housenumber="",
        country="USA",
    ),
    "Newark, New Jersey, United States": NEWARK,
    "Tyler, TX, USA": SportsballGeocodeTuple(
        city="Tyler",
        state="TX",
        postal="",
        lat=32.351389,
        lng=-95.301111,
        housenumber="",
        country="USA",
    ),
    "Central, SC, USA": SportsballGeocodeTuple(
        city="Central",
        state="SC",
        postal="",
        lat=34.723889,
        lng=-82.779722,
        housenumber="",
        country="USA",
    ),
    "Leominster, MA, USA": SportsballGeocodeTuple(
        city="Leominster",
        state="MA",
        postal="",
        lat=42.525,
        lng=-71.760278,
        housenumber="",
        country="USA",
    ),
    "Smyrna, TN, USA": SportsballGeocodeTuple(
        city="Smyrna",
        state="TN",
        postal="",
        lat=35.979444,
        lng=-86.521111,
        housenumber="",
        country="USA",
    ),
    "Pewaukee, WI, USA": SportsballGeocodeTuple(
        city="Pewaukee",
        state="WI",
        postal="",
        lat=43.066667,
        lng=-88.25,
        housenumber="",
        country="USA",
    ),
    "Willoughby, OH, USA": SportsballGeocodeTuple(
        city="Willoughby",
        state="OH",
        postal="",
        lat=41.634722,
        lng=-81.408333,
        housenumber="",
        country="USA",
    ),
    "Foley, AL, USA": SportsballGeocodeTuple(
        city="Foley",
        state="AL",
        postal="",
        lat=30.4055942,
        lng=-87.681509,
        housenumber="",
        country="USA",
    ),
    "Lima, OH, USA": SportsballGeocodeTuple(
        city="Lima",
        state="OH",
        postal="",
        lat=40.746389,
        lng=-84.123333,
        housenumber="",
        country="USA",
    ),
    "Westlake, OH, USA": SportsballGeocodeTuple(
        city="Westlake",
        state="OH",
        postal="",
        lat=41.454444,
        lng=-81.928611,
        housenumber="",
        country="USA",
    ),
    "Hollywood, FL, USA": SportsballGeocodeTuple(
        city="Hollywood",
        state="FL",
        postal="",
        lat=26.021389,
        lng=-80.175,
        housenumber="",
        country="USA",
    ),
    "Jackson, AL, USA": SportsballGeocodeTuple(
        city="Jackson",
        state="AL",
        postal="",
        lat=31.521685,
        lng=-87.891113,
        housenumber="",
        country="USA",
    ),
    "Chico, CA, USA": SportsballGeocodeTuple(
        city="Chico",
        state="CA",
        postal="",
        lat=39.74,
        lng=-121.835556,
        housenumber="",
        country="USA",
    ),
    "Baltimore, MD, USA": BALTIMORE,
    "Bridgeville, PA, USA": SportsballGeocodeTuple(
        city="Bridgeville",
        state="PA",
        postal="",
        lat=40.356944,
        lng=-80.108611,
        housenumber="",
        country="USA",
    ),
    "Vineland, NJ, USA": SportsballGeocodeTuple(
        city="Vineland",
        state="NJ",
        postal="",
        lat=39.465,
        lng=-75.006389,
        housenumber="",
        country="USA",
    ),
    "College Park, GA, USA": SportsballGeocodeTuple(
        city="College Park",
        state="GA",
        postal="",
        lat=33.6175,
        lng=-84.4675,
        housenumber="",
        country="USA",
    ),
    "Madison, WI, USA": MADISON,
    "Starkville, MS, USA": STARKVILLE,
    "Britton, SD, USA": SportsballGeocodeTuple(
        city="Britton",
        state="SD",
        postal="",
        lat=45.792222,
        lng=-97.752778,
        housenumber="",
        country="USA",
    ),
    "Oakhurst, NJ, USA": SportsballGeocodeTuple(
        city="Oakhurst",
        state="NJ",
        postal="",
        lat=40.261486,
        lng=-74.02655,
        housenumber="",
        country="USA",
    ),
    "Bronx, NY, USA": BRONX,
    "Newark, NJ, USA": NEWARK,
    "Dover, OH, USA": SportsballGeocodeTuple(
        city="Dover",
        state="OH",
        postal="",
        lat=40.526667,
        lng=-81.477778,
        housenumber="",
        country="USA",
    ),
    "Yazoo City, MS, USA": SportsballGeocodeTuple(
        city="Yazoo City",
        state="MS",
        postal="",
        lat=32.866667,
        lng=-90.403333,
        housenumber="",
        country="USA",
    ),
    "Amite City, LA, USA": SportsballGeocodeTuple(
        city="Amite City",
        state="LA",
        postal="",
        lat=30.728611,
        lng=-90.508611,
        housenumber="",
        country="USA",
    ),
    "Huntingdon Valley, Pennsylvania, United States": SportsballGeocodeTuple(
        city="Huntingdon Valley",
        state="PA",
        postal="",
        lat=40.116667,
        lng=-75.049722,
        housenumber="",
        country="USA",
    ),
    "Burlington, Kansas, United States": SportsballGeocodeTuple(
        city="Burlington",
        state="KS",
        postal="",
        lat=38.193611,
        lng=-95.745278,
        housenumber="",
        country="USA",
    ),
    "Rochester, New York, United States": ROCHESTER,
    "Boston College": BOSTON_COLLEGE,
    "Paulsboro, New Jersey, United States": SportsballGeocodeTuple(
        city="Paulsboro",
        state="NJ",
        postal="",
        lat=39.839975,
        lng=-75.23996,
        housenumber="",
        country="USA",
    ),
    "Saint Mary's College of California": SportsballGeocodeTuple(
        city="Moraga",
        state="CA",
        postal="",
        lat=37.841389,
        lng=-122.109167,
        housenumber="",
        country="USA",
    ),
    "Ohio State University": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="",
        lat=40.0,
        lng=-83.0125,
        housenumber="",
        country="USA",
    ),
    "Michigan State University": SportsballGeocodeTuple(
        city="East Lansing",
        state="MI",
        postal="",
        lat=42.725,
        lng=-84.48,
        housenumber="",
        country="USA",
    ),
    "Mississauga, Ontario, Canada": SportsballGeocodeTuple(
        city="Mississauga",
        state="ON",
        postal="",
        lat=43.6,
        lng=-79.65,
        housenumber="",
        country="Canada",
    ),
    "Duncanville, Texas, United States": SportsballGeocodeTuple(
        city="Duncanville",
        state="TX",
        postal="",
        lat=32.634722,
        lng=-96.906667,
        housenumber="",
        country="USA",
    ),
    "Tulsa College": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="",
        lat=36.152222,
        lng=-95.946389,
        housenumber="",
        country="USA",
    ),
    "Louisiana Tech College": SportsballGeocodeTuple(
        city="Ruston",
        state="LA",
        postal="",
        lat=32.5275,
        lng=-92.6475,
        housenumber="",
        country="USA",
    ),
    "Monmouth College": SportsballGeocodeTuple(
        city="Monmouth",
        state="IL",
        postal="",
        lat=40.914444,
        lng=-90.637222,
        housenumber="",
        country="USA",
    ),
    "South Alabama College": SportsballGeocodeTuple(
        city="Mobile",
        state="AL",
        postal="",
        lat=30.69671,
        lng=-88.17873,
        housenumber="",
        country="USA",
    ),
    "App State College": SportsballGeocodeTuple(
        city="Boone",
        state="NC",
        postal="",
        lat=36.213843,
        lng=-81.678621,
        housenumber="",
        country="USA",
    ),
    "Washington State College": SportsballGeocodeTuple(
        city="Pullman",
        state="WA",
        postal="",
        lat=46.73,
        lng=-117.16,
        housenumber="",
        country="USA",
    ),
    "UL Monroe College": SportsballGeocodeTuple(
        city="Monroe",
        state="LA",
        postal="",
        lat=32.527,
        lng=-92.074,
        housenumber="",
        country="USA",
    ),
    "Southeast Missouri State College": SportsballGeocodeTuple(
        city="Cape Girardeau",
        state="MO",
        postal="",
        lat=37.315125,
        lng=-89.529392,
        housenumber="",
        country="USA",
    ),
    "Liberty College": SportsballGeocodeTuple(
        city="Lynchburg",
        state="VA",
        postal="",
        lat=37.352,
        lng=-79.18,
        housenumber="",
        country="USA",
    ),
    "Mississippi State College": SportsballGeocodeTuple(
        city="Mississippi State",
        state="MS",
        postal="",
        lat=33.454,
        lng=-88.789,
        housenumber="",
        country="USA",
    ),
    "Illinois College": SportsballGeocodeTuple(
        city="Jacksonville",
        state="IL",
        postal="",
        lat=39.730278,
        lng=-90.246667,
        housenumber="",
        country="USA",
    ),
    "UCF College": SportsballGeocodeTuple(
        city="Orlando",
        state="FL",
        postal="",
        lat=28.6016,
        lng=-81.2005,
        housenumber="",
        country="USA",
    ),
    "Kansas State College": SportsballGeocodeTuple(
        city="Manhattan",
        state="KS",
        postal="",
        lat=39.1914,
        lng=-96.5809,
        housenumber="",
        country="USA",
    ),
    "Louisiana College": SportsballGeocodeTuple(
        city="Pineville",
        state="LA",
        postal="",
        lat=31.325278,
        lng=-92.426667,
        housenumber="",
        country="USA",
    ),
    "Missouri College": SportsballGeocodeTuple(
        city="Brentwood",
        state="MO",
        postal="",
        lat=38.62724,
        lng=-90.33558,
        housenumber="",
        country="USA",
    ),
    "Notre Dame College": NOTRE_DAME_COLLEGE,
    "Texas A&M College": SportsballGeocodeTuple(
        city="College Station",
        state="TX",
        postal="",
        lat=30.610278,
        lng=-96.343611,
        housenumber="",
        country="USA",
    ),
    "Fresno State College": CALIFORNIA_STATE_UNIVERSITY_FRESNO,
    "Clemson College": SportsballGeocodeTuple(
        city="Clemson",
        state="SC",
        postal="",
        lat=34.678333,
        lng=-82.839167,
        housenumber="",
        country="USA",
    ),
    "North Dakota State College": SportsballGeocodeTuple(
        city="Fargo",
        state="ND",
        postal="",
        lat=46.8917,
        lng=-96.8,
        housenumber="",
        country="USA",
    ),
    "South Dakota College": SportsballGeocodeTuple(
        city="Vermillion",
        state="SD",
        postal="",
        lat=42.786111,
        lng=-96.925278,
        housenumber="",
        country="USA",
    ),
    "West Florida College": SportsballGeocodeTuple(
        city="Pensacola",
        state="FL",
        postal="",
        lat=30.5495,
        lng=-87.2181,
        housenumber="",
        country="USA",
    ),
    "Northwestern College": SportsballGeocodeTuple(
        city="Orange City",
        state="IO",
        postal="",
        lat=42.999,
        lng=-96.057,
        housenumber="",
        country="USA",
    ),
    "British Columbia College": SportsballGeocodeTuple(
        city="Vancouver",
        state="BC",
        postal="",
        lat=49.271667,
        lng=-123.095278,
        housenumber="",
        country="Canada",
    ),
    "Indiana College": SportsballGeocodeTuple(
        city="Bloomington",
        state="IN",
        postal="",
        lat=39.166667,
        lng=-86.5,
        housenumber="",
        country="USA",
    ),
    "Tennessee College": SportsballGeocodeTuple(
        city="Knoxville",
        state="TN",
        postal="",
        lat=35.951667,
        lng=-83.93,
        housenumber="",
        country="USA",
    ),
    "Florida College": SportsballGeocodeTuple(
        city="Temple Terrace",
        state="FL",
        postal="",
        lat=28.034559,
        lng=-82.383495,
        housenumber="",
        country="USA",
    ),
    "Alabama College": SportsballGeocodeTuple(
        city="Tuscaloosa",
        state="AL",
        postal="",
        lat=33.210833,
        lng=-87.546111,
        housenumber="",
        country="USA",
    ),
    "North Carolina State College": SportsballGeocodeTuple(
        city="Raleigh",
        state="NC",
        postal="",
        lat=35.787222,
        lng=-78.670556,
        housenumber="",
        country="USA",
    ),
    "UCLA College": SportsballGeocodeTuple(
        city="Los Angeles",
        state="CA",
        postal="",
        lat=34.0722,
        lng=-118.4427,
        housenumber="",
        country="USA",
    ),
    "USC College": SportsballGeocodeTuple(
        city="Los Angeles",
        state="CA",
        postal="",
        lat=34.0206,
        lng=-118.2848,
        housenumber="",
        country="USA",
    ),
    "Michigan State College": SportsballGeocodeTuple(
        city="East Lansing",
        state="MI",
        postal="",
        lat=42.725,
        lng=-84.48,
        housenumber="",
        country="USA",
    ),
    "Texas Tech College": SportsballGeocodeTuple(
        city="Lubbock",
        state="TX",
        postal="",
        lat=33.584,
        lng=-101.878,
        housenumber="",
        country="USA",
    ),
    "Iowa State College": SportsballGeocodeTuple(
        city="Ames",
        state="IO",
        postal="",
        lat=42.0262,
        lng=-93.648,
        housenumber="",
        country="USA",
    ),
    "Middle Tennessee College": SportsballGeocodeTuple(
        city="Murfreesboro",
        state="TN",
        postal="",
        lat=35.849,
        lng=-86.365,
        housenumber="",
        country="USA",
    ),
    "Oregon College": SportsballGeocodeTuple(
        city="Eugene",
        state="OR",
        postal="",
        lat=44.0443,
        lng=-123.0758,
        housenumber="",
        country="USA",
    ),
    "Ohio State College": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="",
        lat=40.0,
        lng=-83.0125,
        housenumber="",
        country="USA",
    ),
    "Colorado State College": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="",
        lat=40.5762,
        lng=-105.0808,
        housenumber="",
        country="USA",
    ),
    "California (PA) College": SportsballGeocodeTuple(
        city="California",
        state="PA",
        postal="",
        lat=40.06678,
        lng=-79.88482,
        housenumber="",
        country="USA",
    ),
    "Oregon State College": SportsballGeocodeTuple(
        city="Corvallis",
        state="OR",
        postal="",
        lat=44.5639,
        lng=-123.2747,
        housenumber="",
        country="USA",
    ),
    "Wake Forest College": WAKE_FOREST_COLLEGE,
    "North Carolina College": SportsballGeocodeTuple(
        city="Chapel Hill",
        state="NC",
        postal="",
        lat=35.908611,
        lng=-79.049167,
        housenumber="",
        country="USA",
    ),
    "Western Michigan College": SportsballGeocodeTuple(
        city="Kalamazoo",
        state="MI",
        postal="",
        lat=42.283333,
        lng=-85.613889,
        housenumber="",
        country="USA",
    ),
    "Texas College": SportsballGeocodeTuple(
        city="Tyler",
        state="TX",
        postal="",
        lat=32.3756,
        lng=-95.3124,
        housenumber="",
        country="USA",
    ),
    "Georgia Tech College": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="",
        lat=33.776,
        lng=-84.396,
        housenumber="",
        country="USA",
    ),
    "North Texas College": SportsballGeocodeTuple(
        city="Denton",
        state="TX",
        postal="",
        lat=33.209722,
        lng=-97.15,
        housenumber="",
        country="USA",
    ),
    "Florida A&M College": SportsballGeocodeTuple(
        city="Tallahassee",
        state="FL",
        postal="",
        lat=30.4178,
        lng=-84.2845,
        housenumber="",
        country="USA",
    ),
    "Virginia Tech College": SportsballGeocodeTuple(
        city="Blacksburg",
        state="VA",
        postal="",
        lat=37.225,
        lng=-80.425,
        housenumber="",
        country="USA",
    ),
    "Oklahoma State College": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="",
        lat=36.1224,
        lng=-97.0698,
        housenumber="",
        country="USA",
    ),
    "Central Michigan College": SportsballGeocodeTuple(
        city="Mount Pleasant",
        state="MI",
        postal="",
        lat=43.5898,
        lng=-84.7775,
        housenumber="",
        country="USA",
    ),
    "Central Missouri State College": SportsballGeocodeTuple(
        city="Warrensburg",
        state="MO",
        postal="",
        lat=38.757,
        lng=-93.741,
        housenumber="",
        country="USA",
    ),
    "Cortland College": SportsballGeocodeTuple(
        city="Cortland",
        state="NY",
        postal="",
        lat=42.597,
        lng=-76.189333,
        housenumber="",
        country="USA",
    ),
    "Augustana University (SD) College": SportsballGeocodeTuple(
        city="Sioux Falls",
        state="SD",
        postal="",
        lat=43.526861,
        lng=-96.737028,
        housenumber="",
        country="USA",
    ),
    "Wingate College": SportsballGeocodeTuple(
        city="Wingate",
        state="NC",
        postal="",
        lat=34.986111,
        lng=-80.444167,
        housenumber="",
        country="USA",
    ),
    "Miami (OH) College": SportsballGeocodeTuple(
        city="Oxford",
        state="OH",
        postal="",
        lat=39.511905,
        lng=-84.734674,
        housenumber="",
        country="USA",
    ),
    "Sam Houston College": SportsballGeocodeTuple(
        city="Huntsville",
        state="TX",
        postal="",
        lat=30.713889,
        lng=-95.547222,
        housenumber="",
        country="USA",
    ),
    "Navy College": SportsballGeocodeTuple(
        city="Annapolis",
        state="MD",
        postal="",
        lat=38.9828,
        lng=-76.4851,
        housenumber="",
        country="USA",
    ),
    "Air Force College": SportsballGeocodeTuple(
        city="Air Force Academy",
        state="CO",
        postal="",
        lat=38.9985,
        lng=-104.8541,
        housenumber="",
        country="USA",
    ),
    "Arkansas State College": SportsballGeocodeTuple(
        city="Jonesboro",
        state="AK",
        postal="",
        lat=35.841082,
        lng=-90.679586,
        housenumber="",
        country="USA",
    ),
    "James Madison College": SportsballGeocodeTuple(
        city="Harrisonburg",
        state="VA",
        postal="",
        lat=38.438444,
        lng=-78.87375,
        housenumber="",
        country="USA",
    ),
    "Humacao, PR": SportsballGeocodeTuple(
        city="Humacao",
        state="PR",
        postal="",
        lat=18.149722,
        lng=-65.8275,
        housenumber="",
        country="USA",
    ),
    "Greensboro, NC, United States": GREENSBORO,
    "New Mexico College": SportsballGeocodeTuple(
        city="Albuquerque",
        state="NM",
        postal="",
        lat=35.08389,
        lng=-106.61861,
        housenumber="",
        country="USA",
    ),
    "Ball State College": SportsballGeocodeTuple(
        city="Muncie",
        state="IN",
        postal="",
        lat=40.198322,
        lng=-85.408943,
        housenumber="",
        country="USA",
    ),
    "Kent State College": SportsballGeocodeTuple(
        city="Kent",
        state="OH",
        postal="",
        lat=41.1469442,
        lng=-81.343333,
        housenumber="",
        country="USA",
    ),
    "San Diego State College": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.775278,
        lng=-117.072222,
        housenumber="",
        country="USA",
    ),
    "Wyoming College": SportsballGeocodeTuple(
        city="Laramie",
        state="WY",
        postal="",
        lat=41.313056,
        lng=-105.581389,
        housenumber="",
        country="USA",
    ),
    "Western Kentucky College": SportsballGeocodeTuple(
        city="Bowling Green",
        state="KY",
        postal="",
        lat=36.986111,
        lng=-86.455556,
        housenumber="",
        country="USA",
    ),
    "UTSA College": SportsballGeocodeTuple(
        city="San Antonio",
        state="TX",
        postal="",
        lat=29.583333,
        lng=-98.620833,
        housenumber="",
        country="USA",
    ),
    "South Carolina State College": SportsballGeocodeTuple(
        city="Orangeburg",
        state="SC",
        postal="",
        lat=33.497222,
        lng=-80.85,
        housenumber="",
        country="USA",
    ),
    "Yale College": SportsballGeocodeTuple(
        city="New Haven",
        state="CT",
        postal="",
        lat=41.311667,
        lng=-72.925278,
        housenumber="",
        country="USA",
    ),
    "Vanderbilt College": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.1475,
        lng=-86.8025,
        housenumber="",
        country="USA",
    ),
    "Eastern Kentucky College": SportsballGeocodeTuple(
        city="Richmond",
        state="KY",
        postal="",
        lat=37.734155,
        lng=-84.301434,
        housenumber="",
        country="USA",
    ),
    "Texas State College": SportsballGeocodeTuple(
        city="San Marcos",
        state="TX",
        postal="",
        lat=29.888889,
        lng=-97.938889,
        housenumber="",
        country="USA",
    ),
    "Tulane College": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="",
        lat=29.94,
        lng=-90.12,
        housenumber="",
        country="USA",
    ),
    "Kansas College": SportsballGeocodeTuple(
        city="Lawrence",
        state="KS",
        postal="",
        lat=38.9584,
        lng=-95.2478,
        housenumber="",
        country="USA",
    ),
    "Northern Iowa College": SportsballGeocodeTuple(
        city="Cedar Falls",
        state="IO",
        postal="",
        lat=42.515,
        lng=-92.460556,
        housenumber="",
        country="USA",
    ),
    "Arkansas-Pine Bluff College": SportsballGeocodeTuple(
        city="Pine Bluff",
        state="AK",
        postal="",
        lat=34.2423,
        lng=-92.0203,
        housenumber="",
        country="USA",
    ),
    "North Carolina A&T College": SportsballGeocodeTuple(
        city="Greensboro",
        state="NC",
        postal="",
        lat=36.075352,
        lng=-79.773628,
        housenumber="",
        country="USA",
    ),
    "Pittsburg State College": SportsballGeocodeTuple(
        city="Pittsburg",
        state="KS",
        postal="",
        lat=37.3913,
        lng=-94.7024,
        housenumber="",
        country="USA",
    ),
    "Sherman Oaks, CA, United States": SportsballGeocodeTuple(
        city="Sherman Oaks",
        state="CA",
        postal="",
        lat=34.151111,
        lng=-118.448333,
        housenumber="",
        country="USA",
    ),
    "University of Kentucky": UNIVERSITY_OF_KENTUCKY,
    "California State University, Fresno": CALIFORNIA_STATE_UNIVERSITY_FRESNO,
    "Paris, France": SportsballGeocodeTuple(
        city="Paris",
        state="",
        postal="",
        lat=48.856667,
        lng=2.352222,
        housenumber="",
        country="France",
    ),
    "University of California, Los Angeles": SportsballGeocodeTuple(
        city="Los Angeles",
        state="CA",
        postal="",
        lat=34.0722,
        lng=-118.4427,
        housenumber="",
        country="USA",
    ),
    "University of Colorado": SportsballGeocodeTuple(
        city="Boulder",
        state="CO",
        postal="",
        lat=40.0073,
        lng=-105.2678,
        housenumber="",
        country="USA",
    ),
    "New Castle, Delaware, United States": SportsballGeocodeTuple(
        city="New Castle",
        state="DE",
        postal="",
        lat=39.661944,
        lng=-75.566389,
        housenumber="",
        country="USA",
    ),
    "South Bend, Indiana, United States": SportsballGeocodeTuple(
        city="South Bend",
        state="IN",
        postal="",
        lat=41.676389,
        lng=-86.269444,
        housenumber="",
        country="USA",
    ),
    "University of Texas at Austin": SportsballGeocodeTuple(
        city="Austin",
        state="TX",
        postal="",
        lat=30.285,
        lng=-97.735,
        housenumber="",
        country="USA",
    ),
    "Fayetteville, New York, United States": SportsballGeocodeTuple(
        city="Fayetteville",
        state="NY",
        postal="",
        lat=43.028611,
        lng=-76.004167,
        housenumber="",
        country="USA",
    ),
    "Gonzaga University": GONZAGA,
    "University of Kansas": SportsballGeocodeTuple(
        city="Lawrence",
        state="KS",
        postal="",
        lat=38.9584,
        lng=-95.2478,
        housenumber="",
        country="USA",
    ),
    "University of Nevada, Las Vegas": SportsballGeocodeTuple(
        city="Paradise",
        state="NV",
        postal="",
        lat=36.10779,
        lng=-115.14376,
        housenumber="",
        country="USA",
    ),
    "University of North Carolina": SportsballGeocodeTuple(
        city="Chapel Hill",
        state="NC",
        postal="",
        lat=35.908611,
        lng=-79.049167,
        housenumber="",
        country="USA",
    ),
    "University of Michigan": SportsballGeocodeTuple(
        city="Ann Arbor",
        state="MI",
        postal="",
        lat=42.276944,
        lng=-83.738056,
        housenumber="",
        country="USA",
    ),
    "Stanford University": SportsballGeocodeTuple(
        city="Stanford",
        state="CA",
        postal="",
        lat=37.4275,
        lng=-122.17,
        housenumber="",
        country="USA",
    ),
    "Goma, Democratic Republic of the Congo": SportsballGeocodeTuple(
        city="Goma",
        state="",
        postal="",
        lat=-1.679444,
        lng=29.233611,
        housenumber="",
        country="Democratic Republic of the Congo",
    ),
    "Green Bay, Wisconsin, United States": GREEN_BAY,
    "Washington State University": SportsballGeocodeTuple(
        city="Pullman",
        state="WA",
        postal="",
        lat=46.73,
        lng=-117.16,
        housenumber="",
        country="USA",
    ),
    "Pescara, Italy": SportsballGeocodeTuple(
        city="Pescara",
        state="",
        postal="",
        lat=42.463889,
        lng=14.214167,
        housenumber="",
        country="Italy",
    ),
    "University of Missouri": SportsballGeocodeTuple(
        city="Columbia",
        state="MO",
        postal="",
        lat=38.9453,
        lng=-92.3288,
        housenumber="",
        country="USA",
    ),
    "University of Tulsa": SportsballGeocodeTuple(
        city="Tulsa",
        state="OK",
        postal="",
        lat=36.152222,
        lng=-95.946389,
        housenumber="",
        country="USA",
    ),
    "San Diego State University": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.775278,
        lng=-117.072222,
        housenumber="",
        country="USA",
    ),
    "Eustis, Florida, United States": SportsballGeocodeTuple(
        city="Eustis",
        state="FL",
        postal="",
        lat=28.856389,
        lng=-81.677222,
        housenumber="",
        country="USA",
    ),
    "Canberra, Australia": SportsballGeocodeTuple(
        city="Canberra",
        state="",
        postal="",
        lat=-35.293056,
        lng=149.126944,
        housenumber="",
        country="Australia",
    ),
    "Cedar Rapids, Iowa, United States": SportsballGeocodeTuple(
        city="Cedar Rapids",
        state="IO",
        postal="",
        lat=41.983056,
        lng=-91.668611,
        housenumber="",
        country="USA",
    ),
    "University of Maryland": SportsballGeocodeTuple(
        city="College Park",
        state="MD",
        postal="",
        lat=38.988,
        lng=-76.943,
        housenumber="",
        country="USA",
    ),
    "Salzgitter, Germany": SportsballGeocodeTuple(
        city="Salzgitter",
        state="",
        postal="",
        lat=52.15,
        lng=10.333333,
        housenumber="",
        country="Germany",
    ),
    "Florida": SportsballGeocodeTuple(
        city="",
        state="FL",
        postal="",
        lat=28.0,
        lng=-82.0,
        housenumber="",
        country="USA",
    ),
    "Aurora, Ontario, Canada": SportsballGeocodeTuple(
        city="Aurora",
        state="ON",
        postal="",
        lat=43.9975,
        lng=-79.47,
        housenumber="",
        country="Canada",
    ),
    "Duquesne University": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.436111,
        lng=-79.993056,
        housenumber="",
        country="USA",
    ),
    "Arizona": SportsballGeocodeTuple(
        city="",
        state="AZ",
        postal="",
        lat=35.0,
        lng=-112.0,
        housenumber="",
        country="USA",
    ),
    "Nassau, Bahamas": SportsballGeocodeTuple(
        city="Nassau",
        state="",
        postal="",
        lat=25.044167,
        lng=-77.350278,
        housenumber="",
        country="Bahamas",
    ),
    "Villanova": VILLANOVA_COLLEGE,
    "Tempe, Arizona, United States": TEMPE,
    "University of Southern California": SportsballGeocodeTuple(
        city="Los Angeles",
        state="CA",
        postal="",
        lat=34.0206,
        lng=-118.2848,
        housenumber="",
        country="USA",
    ),
    "Wake Forest": WAKE_FOREST_COLLEGE,
    "Layton, Utah, United States": SportsballGeocodeTuple(
        city="Layton",
        state="UT",
        postal="",
        lat=41.071667,
        lng=-111.996944,
        housenumber="",
        country="USA",
    ),
    "Fort Smith, Arkansas, United States": SportsballGeocodeTuple(
        city="Fort Smith",
        state="AK",
        postal="",
        lat=35.379722,
        lng=-94.381944,
        housenumber="",
        country="USA",
    ),
    "Denver, Colorado, United States": DENVER,
    "Waco, Texas, United States": WACO,
    "Oklahoma State": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="",
        lat=36.1224,
        lng=-97.0698,
        housenumber="",
        country="USA",
    ),
    "Norman, Oklahoma, United States": NORMAN,
    "Villeneuve-sur-Lot, France": SportsballGeocodeTuple(
        city="Villeneuve-sur-Lot",
        state="",
        postal="",
        lat=44.4081,
        lng=0.705,
        housenumber="",
        country="France",
    ),
    "Guymon, Oklahoma, United States": SportsballGeocodeTuple(
        city="Guymon",
        state="OK",
        postal="",
        lat=36.682804,
        lng=-101.481549,
        housenumber="",
        country="USA",
    ),
    "University of Tennessee": SportsballGeocodeTuple(
        city="Knoxville",
        state="TN",
        postal="",
        lat=35.951667,
        lng=-83.93,
        housenumber="",
        country="USA",
    ),
    "University of Louisville": SportsballGeocodeTuple(
        city="Louisville",
        state="KY",
        postal="",
        lat=38.215,
        lng=-85.760278,
        housenumber="",
        country="USA",
    ),
    "Creighton University": SportsballGeocodeTuple(
        city="Omaha",
        state="NB",
        postal="",
        lat=41.264722,
        lng=-95.946111,
        housenumber="",
        country="USA",
    ),
    "University of Notre Dame": NOTRE_DAME_COLLEGE,
    "Belleville, Illinois, United States": SportsballGeocodeTuple(
        city="Belleville",
        state="IL",
        postal="",
        lat=38.521667,
        lng=-89.995278,
        housenumber="",
        country="USA",
    ),
    "Lehigh University": SportsballGeocodeTuple(
        city="Bethlehem",
        state="PA",
        postal="",
        lat=40.606111,
        lng=-75.377222,
        housenumber="",
        country="USA",
    ),
    "Florida State": SportsballGeocodeTuple(
        city="Tallahassee",
        state="FL",
        postal="",
        lat=30.442,
        lng=-84.298,
        housenumber="",
        country="USA",
    ),
    "Oregon": SportsballGeocodeTuple(
        city="",
        state="OR",
        postal="",
        lat=44.0,
        lng=-121.0,
        housenumber="",
        country="USA",
    ),
    "Douala, Cameroon": SportsballGeocodeTuple(
        city="Douala",
        state="",
        postal="",
        lat=4.05,
        lng=9.7,
        housenumber="",
        country="Cameroon",
    ),
    "Georgetown University": SportsballGeocodeTuple(
        city="Washington",
        state="DC",
        postal="",
        lat=38.907222,
        lng=-77.072778,
        housenumber="",
        country="USA",
    ),
    "Toledo, Ohio, United States": TOLEDO,
    "Port Arthur, Texas, United States": SportsballGeocodeTuple(
        city="Port Arthur",
        state="TX",
        postal="",
        lat=29.868333,
        lng=-93.89,
        housenumber="",
        country="USA",
    ),
    "Cordova, Tennessee, United States": SportsballGeocodeTuple(
        city="Cordova",
        state="TN",
        postal="",
        lat=35.155556,
        lng=-89.776111,
        housenumber="",
        country="USA",
    ),
    "Arlington Heights, Illinois, United States": SportsballGeocodeTuple(
        city="Arlington Heights",
        state="IL",
        postal="",
        lat=42.095,
        lng=-87.980833,
        housenumber="",
        country="USA",
    ),
    "Portsmouth, Rhode Island, United States": SportsballGeocodeTuple(
        city="Portsmouth",
        state="RI",
        postal="",
        lat=41.6,
        lng=-71.25,
        housenumber="",
        country="USA",
    ),
    "Weber State University": WEBER_STATE_COLLEGE,
    "Longwood, Florida, United States": SportsballGeocodeTuple(
        city="Longwood",
        state="FL",
        postal="",
        lat=28.701389,
        lng=-81.348611,
        housenumber="",
        country="USA",
    ),
    "Syracuse University": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="",
        lat=43.0376,
        lng=-76.134,
        housenumber="",
        country="USA",
    ),
    "Princeton, New Jersey, United States": PRINCETON,
    "University of Georgia": SportsballGeocodeTuple(
        city="Athens",
        state="GA",
        postal="",
        lat=33.9558,
        lng=-83.3745,
        housenumber="",
        country="USA",
    ),
    "Beverly Hills, California, United States": SportsballGeocodeTuple(
        city="Beverly Hills",
        state="CA",
        postal="",
        lat=34.073056,
        lng=-118.399444,
        housenumber="",
        country="USA",
    ),
    "Wake Forest University": WAKE_FOREST_COLLEGE,
    "Traralgon, Australia": SportsballGeocodeTuple(
        city="Traralgon",
        state="VIC",
        postal="",
        lat=-38.195833,
        lng=146.540278,
        housenumber="",
        country="Australia",
    ),
    "Portsmouth, Virginia, United States": SportsballGeocodeTuple(
        city="Portsmouth",
        state="VA",
        postal="",
        lat=36.834444,
        lng=-76.341667,
        housenumber="",
        country="USA",
    ),
    "Manhattan, Kansas, United States": MANHATTAN,
    "Gainesville, Florida, United States": GAINESVILLE,
    "Texas": SportsballGeocodeTuple(
        city="",
        state="TX",
        postal="",
        lat=31.0,
        lng=-99.0,
        housenumber="",
        country="USA",
    ),
    "Staten Island, New York, United States": STATEN_ISLAND,
    "North Carolina State University": SportsballGeocodeTuple(
        city="Raleigh",
        state="NC",
        postal="",
        lat=35.787222,
        lng=-78.670556,
        housenumber="",
        country="USA",
    ),
    "Milwaukee , Wisconsin, United States": MILWAUKEE,
    "Utah": SportsballGeocodeTuple(
        city="",
        state="UT",
        postal="",
        lat=39.0,
        lng=-111.0,
        housenumber="",
        country="USA",
    ),
    "La Crosse, Wisconsin, United States": SportsballGeocodeTuple(
        city="La Crosse",
        state="WI",
        postal="",
        lat=43.813333,
        lng=-91.233056,
        housenumber="",
        country="USA",
    ),
    "Montgomery, Alabama, United States": MONTGOMERY,
    "Indiana University": SportsballGeocodeTuple(
        city="Bloomington",
        state="IN",
        postal="",
        lat=39.166667,
        lng=-86.5,
        housenumber="",
        country="USA",
    ),
    "University of Oklahoma": SportsballGeocodeTuple(
        city="Norman",
        state="OK",
        postal="",
        lat=35.2088,
        lng=-97.4457,
        housenumber="",
        country="USA",
    ),
    "Leicester, United Kingdom": SportsballGeocodeTuple(
        city="Leicester",
        state="",
        postal="",
        lat=52.636111,
        lng=-1.133056,
        housenumber="",
        country="UK",
    ),
    "Marquette University": SportsballGeocodeTuple(
        city="Milwaukee",
        state="WI",
        postal="",
        lat=43.039167,
        lng=-87.9325,
        housenumber="",
        country="USA",
    ),
    "Pontiac, Michigan, United States": SportsballGeocodeTuple(
        city="Pontiac",
        state="MI",
        postal="",
        lat=42.646111,
        lng=-83.2925,
        housenumber="",
        country="USA",
    ),
    "Butler University": SportsballGeocodeTuple(
        city="Indianapolis",
        state="IN",
        postal="",
        lat=39.839444,
        lng=-86.171389,
        housenumber="",
        country="USA",
    ),
    "Pendleton, South Carolina, United States": SportsballGeocodeTuple(
        city="Pendleton",
        state="SC",
        postal="",
        lat=34.650556,
        lng=-82.780833,
        housenumber="",
        country="USA",
    ),
    "Northern Illinois College": SportsballGeocodeTuple(
        city="DeKalb",
        state="IL",
        postal="",
        lat=41.933889,
        lng=-88.777778,
        housenumber="",
        country="USA",
    ),
    "SMU College": SportsballGeocodeTuple(
        city="University Park",
        state="TX",
        postal="",
        lat=32.83855,
        lng=-96.78294,
        housenumber="",
        country="USA",
    ),
    "Troy College": SportsballGeocodeTuple(
        city="Troy",
        state="AL",
        postal="",
        lat=31.798056,
        lng=-85.953889,
        housenumber="",
        country="USA",
    ),
    "Charlotte College": SportsballGeocodeTuple(
        city="Charlotte",
        state="NC",
        postal="",
        lat=35.306389,
        lng=-80.733333,
        housenumber="",
        country="USA",
    ),
    "Hawai'i' College": SportsballGeocodeTuple(
        city="Honolulu",
        state="HI",
        postal="",
        lat=21.297,
        lng=-157.817,
        housenumber="",
        country="USA",
    ),
    "Florida Atlantic College": SportsballGeocodeTuple(
        city="Boca Raton",
        state="FL",
        postal="",
        lat=26.371,
        lng=-80.102,
        housenumber="",
        country="USA",
    ),
    "Florida State College": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="",
        lat=30.334722,
        lng=-81.659722,
        housenumber="",
        country="USA",
    ),
    "Virginia College": SportsballGeocodeTuple(
        city="Charlottesville",
        state="VA",
        postal="",
        lat=38.035556,
        lng=-78.503333,
        housenumber="",
        country="USA",
    ),
    "Indianapolis, IN, United States": INDIANAPOLIS,
    "Arlington, WA, United States": SportsballGeocodeTuple(
        city="Arlington",
        state="WA",
        postal="",
        lat=48.181111,
        lng=-122.138889,
        housenumber="",
        country="USA",
    ),
    "Allentown, Pennsylvania, United States": SportsballGeocodeTuple(
        city="Allentown",
        state="PA",
        postal="",
        lat=40.601667,
        lng=-75.477222,
        housenumber="",
        country="USA",
    ),
    "Kentucky": SportsballGeocodeTuple(
        city="",
        state="KY",
        postal="",
        lat=37.0,
        lng=-86.0,
        housenumber="",
        country="USA",
    ),
    "Gonzaga": GONZAGA,
    "University of Washington": SportsballGeocodeTuple(
        city="Seattle",
        state="WA",
        postal="",
        lat=47.654167,
        lng=-122.308056,
        housenumber="",
        country="USA",
    ),
    "Oklahoma State University": SportsballGeocodeTuple(
        city="Stillwater",
        state="OK",
        postal="",
        lat=36.1224,
        lng=-97.0698,
        housenumber="",
        country="USA",
    ),
    "Utah College": SportsballGeocodeTuple(
        city="Salt Lake City",
        state="UT",
        postal="",
        lat=40.7642,
        lng=-111.8465,
        housenumber="",
        country="USA",
    ),
    "Houston College": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.7189,
        lng=-95.3392,
        housenumber="",
        country="USA",
    ),
    "Buffalo College": SportsballGeocodeTuple(
        city="Buffalo",
        state="NY",
        postal="",
        lat=43.0,
        lng=-78.789167,
        housenumber="",
        country="USA",
    ),
    "Ohio College": SportsballGeocodeTuple(
        city="Athens",
        state="OH",
        postal="",
        lat=39.324,
        lng=-82.102,
        housenumber="",
        country="USA",
    ),
    "Memphis College": SportsballGeocodeTuple(
        city="Memphis",
        state="TN",
        postal="",
        lat=35.118889,
        lng=-89.937222,
        housenumber="",
        country="USA",
    ),
    "Jacksonville State College": SportsballGeocodeTuple(
        city="Jacksonville",
        state="AL",
        postal="",
        lat=33.822,
        lng=-85.766,
        housenumber="",
        country="USA",
    ),
    "Georgia State College": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="",
        lat=33.753694,
        lng=-84.385972,
        housenumber="",
        country="USA",
    ),
    "Grand Valley State College": SportsballGeocodeTuple(
        city="Allendale",
        state="MI",
        postal="",
        lat=42.963611,
        lng=-85.888611,
        housenumber="",
        country="USA",
    ),
    "Randolph-Macon College": SportsballGeocodeTuple(
        city="Ashland",
        state="VA",
        postal="",
        lat=37.763,
        lng=-77.477,
        housenumber="",
        country="USA",
    ),
    "Alabama State College": SportsballGeocodeTuple(
        city="Montgomery",
        state="AL",
        postal="",
        lat=32.364,
        lng=-86.295,
        housenumber="",
        country="USA",
    ),
    "Jackson State College": SportsballGeocodeTuple(
        city="Jackson",
        state="MS",
        postal="",
        lat=32.296111,
        lng=-90.207778,
        housenumber="",
        country="USA",
    ),
    "Lenoir-Rhyne College": SportsballGeocodeTuple(
        city="Hickory",
        state="NC",
        postal="",
        lat=35.740235,
        lng=-81.325501,
        housenumber="",
        country="USA",
    ),
    "Northwest Missouri State College": SportsballGeocodeTuple(
        city="Maryville",
        state="MO",
        postal="",
        lat=40.353306,
        lng=-94.8834,
        housenumber="",
        country="USA",
    ),
    "Chattanooga College": SportsballGeocodeTuple(
        city="Chattanooga",
        state="TN",
        postal="",
        lat=35.0458,
        lng=-85.2999,
        housenumber="",
        country="USA",
    ),
    "Arizona State College": SportsballGeocodeTuple(
        city="Tempe",
        state="AZ",
        postal="",
        lat=33.4209,
        lng=-111.934,
        housenumber="",
        country="USA",
    ),
    "Morgan State College": SportsballGeocodeTuple(
        city="Baltimore",
        state="MD",
        postal="",
        lat=39.343889,
        lng=-76.584722,
        housenumber="",
        country="USA",
    ),
    "Arkansas College": SportsballGeocodeTuple(
        city="Fayetteville",
        state="AK",
        postal="",
        lat=36.068611,
        lng=-94.176111,
        housenumber="",
        country="USA",
    ),
    "Eastern Washington College": SportsballGeocodeTuple(
        city="Cheney",
        state="WA",
        postal="",
        lat=47.491389,
        lng=-117.583056,
        housenumber="",
        country="USA",
    ),
    "Georgia College": SportsballGeocodeTuple(
        city="Milledgeville",
        state="GA",
        postal="",
        lat=33.081389,
        lng=-83.230556,
        housenumber="",
        country="USA",
    ),
    "Friends University College": SportsballGeocodeTuple(
        city="Wichita",
        state="KS",
        postal="",
        lat=37.678333,
        lng=-97.366667,
        housenumber="",
        country="USA",
    ),
    "Idaho College": SportsballGeocodeTuple(
        city="Caldwell",
        state="ID",
        postal="",
        lat=43.653,
        lng=-116.676,
        housenumber="",
        country="USA",
    ),
    "Saginaw Valley State College": SportsballGeocodeTuple(
        city="University Center",
        state="MI",
        postal="",
        lat=43.5141,
        lng=-83.96156,
        housenumber="",
        country="USA",
    ),
    "Temple College": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.981389,
        lng=-75.154444,
        housenumber="",
        country="USA",
    ),
    "Southern Illinois College": SportsballGeocodeTuple(
        city="Carbondale",
        state="IL",
        postal="",
        lat=37.710426,
        lng=-89.219306,
        housenumber="",
        country="USA",
    ),
    "Grambling College": SportsballGeocodeTuple(
        city="Grambling",
        state="LA",
        postal="",
        lat=32.5252,
        lng=-92.7153,
        housenumber="",
        country="USA",
    ),
    "Western Colorado College": SportsballGeocodeTuple(
        city="Gunnison",
        state="CO",
        postal="",
        lat=38.549,
        lng=-106.92,
        housenumber="",
        country="USA",
    ),
    "Harvard College": SportsballGeocodeTuple(
        city="Cambridge",
        state="MA",
        postal="",
        lat=42.374,
        lng=-71.117,
        housenumber="",
        country="USA",
    ),
    "Wayne State (MI) College": SportsballGeocodeTuple(
        city="Detroit",
        state="MI",
        postal="",
        lat=42.357344,
        lng=-83.070106,
        housenumber="",
        country="USA",
    ),
    "Cincinnati College": SportsballGeocodeTuple(
        city="Cincinnati",
        state="OH",
        postal="",
        lat=39.132778,
        lng=-84.515278,
        housenumber="",
        country="USA",
    ),
    "UAB College": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.502,
        lng=-86.8079,
        housenumber="",
        country="USA",
    ),
    "Concordia-St. Paul College": SportsballGeocodeTuple(
        city="Saint Paul",
        state="MN",
        postal="",
        lat=44.949722,
        lng=-93.155,
        housenumber="",
        country="USA",
    ),
    "Peru State College College": SportsballGeocodeTuple(
        city="Peru",
        state="NB",
        postal="",
        lat=40.475,
        lng=-95.7325,
        housenumber="",
        country="USA",
    ),
    "Alberta College": SportsballGeocodeTuple(
        city="Edmonton",
        state="AL",
        postal="",
        lat=53.524444,
        lng=-113.524444,
        housenumber="",
        country="USA",
    ),
    "Syracuse College": SportsballGeocodeTuple(
        city="Syracuse",
        state="NY",
        postal="",
        lat=43.0376,
        lng=-76.134,
        housenumber="",
        country="USA",
    ),
    "Louisville College": SportsballGeocodeTuple(
        city="Louisville",
        state="KY",
        postal="",
        lat=38.215,
        lng=-85.760278,
        housenumber="",
        country="USA",
    ),
    "West Virginia College": SportsballGeocodeTuple(
        city="Morgantown",
        state="WV",
        postal="",
        lat=39.6458,
        lng=-79.9697,
        housenumber="",
        country="USA",
    ),
    "Sioux Falls College": SportsballGeocodeTuple(
        city="Sioux Falls",
        state="SD",
        postal="",
        lat=43.530778,
        lng=-96.738694,
        housenumber="",
        country="USA",
    ),
    "Norfolk State College": SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="",
        lat=36.8487,
        lng=-76.2625,
        housenumber="",
        country="USA",
    ),
    "Delaware College": SportsballGeocodeTuple(
        city="Newark",
        state="DE",
        postal="",
        lat=39.678333,
        lng=-75.751111,
        housenumber="",
        country="USA",
    ),
    "Massachusetts College": SportsballGeocodeTuple(
        city="North Adams",
        state="MA",
        postal="",
        lat=42.6917,
        lng=-73.1039,
        housenumber="",
        country="USA",
    ),
    "Indiana-Pennsylvania College": SportsballGeocodeTuple(
        city="Indiana",
        state="PA",
        postal="",
        lat=40.617,
        lng=-79.16,
        housenumber="",
        country="USA",
    ),
    "Youngstown State College": SportsballGeocodeTuple(
        city="Youngstown",
        state="OH",
        postal="",
        lat=41.1067,
        lng=-80.6503,
        housenumber="",
        country="USA",
    ),
    "Wisconsin-Whitewater College": SportsballGeocodeTuple(
        city="Whitewater",
        state="WI",
        postal="",
        lat=42.838339,
        lng=-88.743246,
        housenumber="",
        country="USA",
    ),
    "Dayton College": SportsballGeocodeTuple(
        city="Dayton",
        state="OH",
        postal="",
        lat=39.740415,
        lng=-84.179213,
        housenumber="",
        country="USA",
    ),
    "Indiana State College": SportsballGeocodeTuple(
        city="Terre Haute",
        state="IN",
        postal="",
        lat=39.47,
        lng=-87.41,
        housenumber="",
        country="USA",
    ),
    "Central Arkansas College": SportsballGeocodeTuple(
        city="Conway",
        state="AK",
        postal="",
        lat=35.077,
        lng=-92.457,
        housenumber="",
        country="USA",
    ),
    "Stephen F. Austin College": SportsballGeocodeTuple(
        city="Nacogdoches",
        state="TX",
        postal="",
        lat=31.619167,
        lng=-94.648333,
        housenumber="",
        country="USA",
    ),
    "Montana State College": SportsballGeocodeTuple(
        city="Bozeman",
        state="MT",
        postal="",
        lat=45.668333,
        lng=-111.05,
        housenumber="",
        country="USA",
    ),
    "Baldwin-Wallace College": SportsballGeocodeTuple(
        city="Berea",
        state="OH",
        postal="",
        lat=41.371111,
        lng=-81.847778,
        housenumber="",
        country="USA",
    ),
    "Culver-Stockton College College": SportsballGeocodeTuple(
        city="Canton",
        state="MO",
        postal="",
        lat=40.1295,
        lng=-91.5309,
        housenumber="",
        country="USA",
    ),
    "Ferris State College": SportsballGeocodeTuple(
        city="Big Rapids",
        state="MI",
        postal="",
        lat=43.69739,
        lng=-85.4839,
        housenumber="",
        country="USA",
    ),
    "Sacred Heart College": SportsballGeocodeTuple(
        city="Fairfield",
        state="CT",
        postal="",
        lat=41.2214,
        lng=-73.2419,
        housenumber="",
        country="USA",
    ),
    "Towson College": SportsballGeocodeTuple(
        city="Towson",
        state="MD",
        postal="",
        lat=39.394444,
        lng=-76.608333,
        housenumber="",
        country="USA",
    ),
    "Fort Hays State College": SportsballGeocodeTuple(
        city="Hays",
        state="KS",
        postal="",
        lat=38.873333,
        lng=-99.343333,
        housenumber="",
        country="USA",
    ),
    "Dartmouth College": SportsballGeocodeTuple(
        city="Hanover",
        state="NH",
        postal="",
        lat=43.703333,
        lng=-72.288333,
        housenumber="",
        country="USA",
    ),
    "Elon College": SportsballGeocodeTuple(
        city="Elon",
        state="NC",
        postal="",
        lat=36.106389,
        lng=-79.500833,
        housenumber="",
        country="USA",
    ),
    "Mars Hill College": SportsballGeocodeTuple(
        city="Mars Hill",
        state="NC",
        postal="",
        lat=35.82603,
        lng=-82.5507,
        housenumber="",
        country="USA",
    ),
    "East Tennessee State College": SportsballGeocodeTuple(
        city="Mars Hill",
        state="NC",
        postal="",
        lat=36.30333,
        lng=-82.36917,
        housenumber="",
        country="USA",
    ),
    "Rhode Island College": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="",
        lat=41.842199,
        lng=-71.461161,
        housenumber="",
        country="USA",
    ),
    "Stony Brook College": SportsballGeocodeTuple(
        city="Stony Brook",
        state="NY",
        postal="",
        lat=40.917,
        lng=-73.124,
        housenumber="",
        country="USA",
    ),
    "Findlay College": SportsballGeocodeTuple(
        city="Findlay",
        state="OH",
        postal="",
        lat=41.055,
        lng=-83.655,
        housenumber="",
        country="USA",
    ),
    "Framingham State College": SportsballGeocodeTuple(
        city="Framingham",
        state="MA",
        postal="",
        lat=42.2977,
        lng=-71.4366,
        housenumber="",
        country="USA",
    ),
    "Marist College": SportsballGeocodeTuple(
        city="Poughkeepsie Town",
        state="NY",
        postal="",
        lat=41.725974,
        lng=-73.93354,
        housenumber="",
        country="USA",
    ),
    "Bemidji State College": SportsballGeocodeTuple(
        city="Bemidji",
        state="MN",
        postal="",
        lat=47.48175,
        lng=-94.87557,
        housenumber="",
        country="USA",
    ),
    "Akron College": SportsballGeocodeTuple(
        city="Akron",
        state="OH",
        postal="",
        lat=41.0752,
        lng=-81.5115,
        housenumber="",
        country="USA",
    ),
    "Canisius College": SportsballGeocodeTuple(
        city="Buffalo",
        state="NY",
        postal="",
        lat=42.925278,
        lng=-78.852778,
        housenumber="",
        country="USA",
    ),
    "Pennsylvania College": SportsballGeocodeTuple(
        city="Williamsport",
        state="PA",
        postal="",
        lat=41.235,
        lng=-77.021,
        housenumber="",
        country="USA",
    ),
    "North Carolina Central College": SportsballGeocodeTuple(
        city="Durham",
        state="NC",
        postal="",
        lat=35.974167,
        lng=-78.898611,
        housenumber="",
        country="USA",
    ),
    "Missouri Western College": SportsballGeocodeTuple(
        city="St. Joseph",
        state="MO",
        postal="",
        lat=39.7581,
        lng=-94.7856,
        housenumber="",
        country="USA",
    ),
    "Minnesota-Duluth College": SportsballGeocodeTuple(
        city="Duluth",
        state="MN",
        postal="",
        lat=46.8187754,
        lng=-92.0843306,
        housenumber="",
        country="USA",
    ),
    "Lane College College": SportsballGeocodeTuple(
        city="Jackson",
        state="TN",
        postal="",
        lat=35.62805,
        lng=-88.8063527,
        housenumber="",
        country="USA",
    ),
    "East Texas A&M College": SportsballGeocodeTuple(
        city="Commerce",
        state="TX",
        postal="",
        lat=33.2423,
        lng=-95.9077,
        housenumber="",
        country="USA",
    ),
    "Northern Colorado College": SportsballGeocodeTuple(
        city="Greeley",
        state="CO",
        postal="",
        lat=40.404853,
        lng=-104.696741,
        housenumber="",
        country="USA",
    ),
    "Colorado State-Pueblo College": SportsballGeocodeTuple(
        city="Pueblo",
        state="CO",
        postal="",
        lat=38.3075,
        lng=-104.578333,
        housenumber="",
        country="USA",
    ),
    "Stetson College": SportsballGeocodeTuple(
        city="DeLand",
        state="FL",
        postal="",
        lat=29.035,
        lng=-81.3026,
        housenumber="",
        country="USA",
    ),
    "North Dakota College": SportsballGeocodeTuple(
        city="Grand Forks",
        state="ND",
        postal="",
        lat=47.9222,
        lng=-97.0734,
        housenumber="",
        country="USA",
    ),
    "Western Carolina College": SportsballGeocodeTuple(
        city="Cullowhee",
        state="NC",
        postal="",
        lat=35.309722,
        lng=-83.183333,
        housenumber="",
        country="USA",
    ),
    "Brown College": SportsballGeocodeTuple(
        city="Providence",
        state="RI",
        postal="",
        lat=41.826111,
        lng=-71.403056,
        housenumber="",
        country="USA",
    ),
    "Minnesota State College": SportsballGeocodeTuple(
        city="Mankato",
        state="MN",
        postal="",
        lat=44.147,
        lng=-93.998,
        housenumber="",
        country="USA",
    ),
    "Loyola New Orleans College": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="",
        lat=29.935,
        lng=-90.120833,
        housenumber="",
        country="USA",
    ),
    "Princeton College": SportsballGeocodeTuple(
        city="Princeton",
        state="NJ",
        postal="",
        lat=40.345278,
        lng=-74.656111,
        housenumber="",
        country="USA",
    ),
    "Mercer College": SportsballGeocodeTuple(
        city="Macon",
        state="GA",
        postal="",
        lat=32.829167,
        lng=-83.648611,
        housenumber="",
        country="USA",
    ),
    "Howard College": SportsballGeocodeTuple(
        city="Big Spring",
        state="TX",
        postal="",
        lat=32.2506,
        lng=-101.4511,
        housenumber="",
        country="USA",
    ),
    "Houston Christian College": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.694,
        lng=-95.515,
        housenumber="",
        country="USA",
    ),
    "Samford College": SportsballGeocodeTuple(
        city="Homewood",
        state="AL",
        postal="",
        lat=33.4649,
        lng=-86.7937,
        housenumber="",
        country="USA",
    ),
    "New Haven College": SportsballGeocodeTuple(
        city="West Haven",
        state="CT",
        postal="",
        lat=41.2919,
        lng=-72.9622,
        housenumber="",
        country="USA",
    ),
    "Valdosta State College": SportsballGeocodeTuple(
        city="Valdosta",
        state="GA",
        postal="",
        lat=30.847,
        lng=-83.2896,
        housenumber="",
        country="USA",
    ),
    "Lock Haven University College": SportsballGeocodeTuple(
        city="Lock Haven",
        state="PA",
        postal="",
        lat=41.141111,
        lng=-77.461111,
        housenumber="",
        country="USA",
    ),
    "Assumption College": SportsballGeocodeTuple(
        city="Worcester",
        state="MA",
        postal="",
        lat=42.2905,
        lng=-71.8295,
        housenumber="",
        country="USA",
    ),
    "Lafayette College": SportsballGeocodeTuple(
        city="Easton",
        state="PA",
        postal="",
        lat=40.698611,
        lng=-75.208056,
        housenumber="",
        country="USA",
    ),
    "San Diego College": SportsballGeocodeTuple(
        city="San Diego",
        state="CA",
        postal="",
        lat=32.71745,
        lng=-117.15255,
        housenumber="",
        country="USA",
    ),
    "Azusa Pacific College": SportsballGeocodeTuple(
        city="Azusa",
        state="CA",
        postal="",
        lat=34.12971,
        lng=-117.88888,
        housenumber="",
        country="USA",
    ),
    "Campbell College": SportsballGeocodeTuple(
        city="Buies Creek",
        state="NC",
        postal="",
        lat=35.408333,
        lng=-78.739444,
        housenumber="",
        country="USA",
    ),
    "Alcorn State College": SportsballGeocodeTuple(
        city="Alcorn State",
        state="MS",
        postal="",
        lat=31.8769,
        lng=-91.1411,
        housenumber="",
        country="USA",
    ),
    "Northern Arizona College": SportsballGeocodeTuple(
        city="Flagstaff",
        state="AZ",
        postal="",
        lat=35.1875,
        lng=-111.655,
        housenumber="",
        country="USA",
    ),
    "UC Davis College": SportsballGeocodeTuple(
        city="Davis",
        state="CA",
        postal="",
        lat=38.54,
        lng=-121.75,
        housenumber="",
        country="USA",
    ),
    "UAlbany College": SportsballGeocodeTuple(
        city="Albany",
        state="NY",
        postal="",
        lat=42.686,
        lng=-73.824,
        housenumber="",
        country="USA",
    ),
    "Fort Valley State College": SportsballGeocodeTuple(
        city="Fort Valley",
        state="GA",
        postal="",
        lat=32.534417,
        lng=-83.896056,
        housenumber="",
        country="USA",
    ),
    "Washburn College": SportsballGeocodeTuple(
        city="Topeka",
        state="KS",
        postal="",
        lat=39.033786,
        lng=-95.698975,
        housenumber="",
        country="USA",
    ),
    "Shepherd College": SportsballGeocodeTuple(
        city="Shepherdstown",
        state="WV",
        postal="",
        lat=39.436389,
        lng=-77.808333,
        housenumber="",
        country="USA",
    ),
    "William & Mary College": SportsballGeocodeTuple(
        city="Williamsburg",
        state="VA",
        postal="",
        lat=37.270833,
        lng=-76.708333,
        housenumber="",
        country="USA",
    ),
    "Kutztown College": SportsballGeocodeTuple(
        city="Kutztown",
        state="PA",
        postal="",
        lat=40.511,
        lng=-75.783,
        housenumber="",
        country="USA",
    ),
    "Charleston (WV) College": SportsballGeocodeTuple(
        city="Charleston",
        state="WV",
        postal="",
        lat=38.332917,
        lng=-81.616524,
        housenumber="",
        country="USA",
    ),
    "University of Laval College": SportsballGeocodeTuple(
        city="Quebec City",
        state="QC",
        postal="",
        lat=46.78,
        lng=-71.274722,
        housenumber="",
        country="Canada",
    ),
    "Bryant College": SportsballGeocodeTuple(
        city="Smithfield",
        state="RI",
        postal="",
        lat=41.92545,
        lng=-71.53241,
        housenumber="",
        country="USA",
    ),
    "Virginia State College": SportsballGeocodeTuple(
        city="Petersburg",
        state="VA",
        postal="",
        lat=37.238379,
        lng=-77.419818,
        housenumber="",
        country="USA",
    ),
    "East Central (OK) College": SportsballGeocodeTuple(
        city="Ada",
        state="OK",
        postal="",
        lat=34.774444,
        lng=-96.664722,
        housenumber="",
        country="USA",
    ),
    "Wagner College": SportsballGeocodeTuple(
        city="Staten Island",
        state="NY",
        postal="",
        lat=40.615,
        lng=-74.094,
        housenumber="",
        country="USA",
    ),
    "Minot State Universi College": SportsballGeocodeTuple(
        city="Minot",
        state="ND",
        postal="",
        lat=48.246,
        lng=-101.301,
        housenumber="",
        country="USA",
    ),
    "Furman College": SportsballGeocodeTuple(
        city="Greenville",
        state="SC",
        postal="",
        lat=34.925833,
        lng=-82.435556,
        housenumber="",
        country="USA",
    ),
    "Saint John's (MN) College": SportsballGeocodeTuple(
        city="St. Joseph",
        state="MN",
        postal="",
        lat=45.5812104,
        lng=-94.3942241,
        housenumber="",
        country="USA",
    ),
    "Drake College": SportsballGeocodeTuple(
        city="Des Moines",
        state="IO",
        postal="",
        lat=41.602222,
        lng=-93.654167,
        housenumber="",
        country="USA",
    ),
    "Fordham College": SportsballGeocodeTuple(
        city="New York",
        state="NY",
        postal="",
        lat=40.861944,
        lng=-73.886111,
        housenumber="",
        country="USA",
    ),
    "New Hampshire College": SportsballGeocodeTuple(
        city="Durham",
        state="NH",
        postal="",
        lat=43.136389,
        lng=-70.932222,
        housenumber="",
        country="USA",
    ),
    "Lindenwood College": SportsballGeocodeTuple(
        city="St. Charles",
        state="MO",
        postal="",
        lat=38.787,
        lng=-90.503,
        housenumber="",
        country="USA",
    ),
    "Prairie View A&M College": SportsballGeocodeTuple(
        city="Prairie View",
        state="TX",
        postal="",
        lat=30.09194,
        lng=-95.98944,
        housenumber="",
        country="USA",
    ),
    "Barton College College": SportsballGeocodeTuple(
        city="Wilson",
        state="NC",
        postal="",
        lat=35.73536,
        lng=-77.913175,
        housenumber="",
        country="USA",
    ),
    "SE Louisiana College": SportsballGeocodeTuple(
        city="Hammond",
        state="LA",
        postal="",
        lat=30.513889,
        lng=-90.468333,
        housenumber="",
        country="USA",
    ),
    "The Citadel College": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="",
        lat=32.797222,
        lng=-79.961111,
        housenumber="",
        country="USA",
    ),
    "Regina (Canada) College": SportsballGeocodeTuple(
        city="Regina",
        state="SK",
        postal="",
        lat=50.415553,
        lng=-104.587953,
        housenumber="",
        country="Canada",
    ),
    "Tusculum College": SportsballGeocodeTuple(
        city="Tusculum",
        state="TN",
        postal="",
        lat=36.173,
        lng=-82.7616,
        housenumber="",
        country="USA",
    ),
    "Northwestern State College": SportsballGeocodeTuple(
        city="Natchitoches",
        state="LA",
        postal="",
        lat=31.75,
        lng=-93.0972,
        housenumber="",
        country="USA",
    ),
    "Manitoba College": SportsballGeocodeTuple(
        city="Winnipeg",
        state="MB",
        postal="",
        lat=49.809444,
        lng=-97.132778,
        housenumber="",
        country="Canada",
    ),
    "Bucknell College": SportsballGeocodeTuple(
        city="Lewisburg",
        state="PA",
        postal="",
        lat=40.954722,
        lng=-76.883611,
        housenumber="",
        country="USA",
    ),
    "Slippery Rock College": SportsballGeocodeTuple(
        city="Slippery Rock",
        state="PA",
        postal="",
        lat=41.062,
        lng=-80.043,
        housenumber="",
        country="USA",
    ),
    "Ithaca College": SportsballGeocodeTuple(
        city="Ithaca",
        state="NY",
        postal="",
        lat=42.4218,
        lng=-76.4947,
        housenumber="",
        country="USA",
    ),
    "Northern Michigan College": SportsballGeocodeTuple(
        city="Marquette",
        state="MI",
        postal="",
        lat=46.55901,
        lng=-87.40525,
        housenumber="",
        country="USA",
    ),
    "Richmond College": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="",
        lat=37.5775,
        lng=-77.537778,
        housenumber="",
        country="USA",
    ),
    "Maine College": SportsballGeocodeTuple(
        city="Orono",
        state="ME",
        postal="",
        lat=44.902,
        lng=-68.668,
        housenumber="",
        country="USA",
    ),
    "Austin Peay College": SportsballGeocodeTuple(
        city="Clarksville",
        state="TN",
        postal="",
        lat=36.5323,
        lng=-87.35457,
        housenumber="",
        country="USA",
    ),
    "Malone University College": SportsballGeocodeTuple(
        city="Canton",
        state="OH",
        postal="",
        lat=40.826,
        lng=-81.3765,
        housenumber="",
        country="USA",
    ),
    "Albany State College": SportsballGeocodeTuple(
        city="Albany",
        state="GA",
        postal="",
        lat=31.569,
        lng=-84.142,
        housenumber="",
        country="USA",
    ),
    "Tarleton State College": SportsballGeocodeTuple(
        city="Stephenville",
        state="TX",
        postal="",
        lat=32.2139,
        lng=-98.2154,
        housenumber="",
        country="USA",
    ),
    "Virginia Commonwealth College": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="",
        lat=37.5466,
        lng=-77.4533,
        housenumber="",
        country="USA",
    ),
    "UNC Pembroke College": SportsballGeocodeTuple(
        city="Pembroke",
        state="NC",
        postal="",
        lat=34.6876,
        lng=-79.202,
        housenumber="",
        country="USA",
    ),
    "Bowie State College": SportsballGeocodeTuple(
        city="Bowie",
        state="MD",
        postal="",
        lat=39.02158,
        lng=-76.75684,
        housenumber="",
        country="USA",
    ),
    "Louisiana Tech University": SportsballGeocodeTuple(
        city="Ruston",
        state="LA",
        postal="",
        lat=32.5275,
        lng=-92.6475,
        housenumber="",
        country="USA",
    ),
    "Newport, Maine, United States": SportsballGeocodeTuple(
        city="Newport",
        state="ME",
        postal="",
        lat=44.836667,
        lng=-69.2725,
        housenumber="",
        country="USA",
    ),
    "Murray State College": SportsballGeocodeTuple(
        city="Tishomingo",
        state="OK",
        postal="",
        lat=34.222222,
        lng=-96.675833,
        housenumber="",
        country="USA",
    ),
    "Fayetteville State College": SportsballGeocodeTuple(
        city="Fayetteville",
        state="NC",
        postal="",
        lat=35.072,
        lng=-78.8945,
        housenumber="",
        country="USA",
    ),
    "West Alabama College": SportsballGeocodeTuple(
        city="Livingston",
        state="AL",
        postal="",
        lat=32.59,
        lng=-88.186,
        housenumber="",
        country="USA",
    ),
    "Chur, Switzerland": SportsballGeocodeTuple(
        city="Chur",
        state="",
        postal="",
        lat=46.85,
        lng=9.533333,
        housenumber="",
        country="Switzerland",
    ),
    "Wurzburg, Bavaria, DE": SportsballGeocodeTuple(
        city="Wurzburg",
        state="Bavaria",
        postal="",
        lat=49.783333,
        lng=9.933333,
        housenumber="",
        country="Germany",
    ),
    "Atlanta, GA, United States": ATLANTA,
    "McDonald Township, OH, United States": SportsballGeocodeTuple(
        city="McDonald Township",
        state="OH",
        postal="",
        lat=41.163611,
        lng=-80.723333,
        housenumber="",
        country="Germany",
    ),
    "Cedar Falls, Iowa, United States": CEDAR_FALLS,
    "Maryland Stadium": SportsballGeocodeTuple(
        city="College Park",
        state="MD",
        postal="20742",
        lat=38.990278,
        lng=-76.947222,
        housenumber="90",
        country="USA",
    ),
    "Comiskey Park - Chicago, IL - United States": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="",
        lat=41.831667,
        lng=-87.634167,
        housenumber="324",
        country="USA",
    ),
    "Southern Utah College": SportsballGeocodeTuple(
        city="Cedar City",
        state="UT",
        postal="",
        lat=37.675448,
        lng=-113.071632,
        housenumber="",
        country="USA",
    ),
    "Southern Arkansas College": SportsballGeocodeTuple(
        city="Magnolia",
        state="AK",
        postal="",
        lat=33.291667,
        lng=-93.236111,
        housenumber="",
        country="USA",
    ),
    "Humboldt State College": SportsballGeocodeTuple(
        city="Arcata",
        state="CA",
        postal="",
        lat=40.876,
        lng=-124.079,
        housenumber="",
        country="USA",
    ),
    "Missouri S&T College": SportsballGeocodeTuple(
        city="Rolla",
        state="MO",
        postal="",
        lat=37.955544,
        lng=-91.773513,
        housenumber="",
        country="USA",
    ),
    "Duquesne College": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.436111,
        lng=-79.993056,
        housenumber="",
        country="USA",
    ),
    "Missouri State College": SportsballGeocodeTuple(
        city="Springfield",
        state="MO",
        postal="",
        lat=37.19971,
        lng=-93.28079,
        housenumber="",
        country="USA",
    ),
    "UT Martin College": SportsballGeocodeTuple(
        city="Martin",
        state="TN",
        postal="",
        lat=36.341754,
        lng=-88.867097,
        housenumber="",
        country="USA",
    ),
    "Western Illinois College": SportsballGeocodeTuple(
        city="Macomb",
        state="IL",
        postal="",
        lat=40.470392,
        lng=-90.68774,
        housenumber="",
        country="USA",
    ),
    "Greenville College": SportsballGeocodeTuple(
        city="Greenville",
        state="IL",
        postal="",
        lat=38.893611,
        lng=-89.408611,
        housenumber="",
        country="USA",
    ),
    "St. John's University": SportsballGeocodeTuple(
        city="New York",
        state="NY",
        postal="",
        lat=40.721944,
        lng=-73.795556,
        housenumber="",
        country="USA",
    ),
    "Nevada": SportsballGeocodeTuple(
        city="",
        state="NV",
        postal="",
        lat=39.0,
        lng=-117.0,
        housenumber="",
        country="USA",
    ),
    "Legacy Center": LEGACY_CENTER,
    "Wainwright, Alberta, Canada": SportsballGeocodeTuple(
        city="Wainwright",
        state="AL",
        postal="",
        lat=52.833333,
        lng=-110.866667,
        housenumber="",
        country="Canada",
    ),
    "Katy, TX, United States": SportsballGeocodeTuple(
        city="Katy",
        state="TX",
        postal="",
        lat=29.785786,
        lng=-95.824394,
        housenumber="",
        country="USA",
    ),
    "Panama, Panama, Panama": SportsballGeocodeTuple(
        city="Panama",
        state="",
        postal="",
        lat=8.971111,
        lng=-79.534722,
        housenumber="",
        country="Panama",
    ),
    "Mississippi State University": SportsballGeocodeTuple(
        city="Mississippi State",
        state="MS",
        postal="",
        lat=33.454,
        lng=-88.789,
        housenumber="",
        country="USA",
    ),
    "San Carlos, Cojedes, VE": SportsballGeocodeTuple(
        city="San Carlos",
        state="Cojedes",
        postal="",
        lat=9.65,
        lng=-68.583333,
        housenumber="",
        country="Venezuela",
    ),
    "Cape Coral, FL, United States": SportsballGeocodeTuple(
        city="Cape Coral",
        state="FL",
        postal="",
        lat=26.639722,
        lng=-81.9825,
        housenumber="",
        country="USA",
    ),
    "Seattle, WA, United States": SEATTLE,
    "Kansas State": SportsballGeocodeTuple(
        city="Manhattan",
        state="KS",
        postal="",
        lat=39.1914,
        lng=-96.5809,
        housenumber="",
        country="USA",
    ),
    "University of California, Santa Barbara": SportsballGeocodeTuple(
        city="Santa Barbara",
        state="CA",
        postal="",
        lat=34.416389,
        lng=-119.846389,
        housenumber="",
        country="USA",
    ),
    "Georgia Institute of Technology": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="",
        lat=33.776,
        lng=-84.396,
        housenumber="",
        country="USA",
    ),
    "University of New Mexico": SportsballGeocodeTuple(
        city="Albuquerque",
        state="NM",
        postal="",
        lat=35.08389,
        lng=-106.61861,
        housenumber="",
        country="USA",
    ),
    "Lakeland, Florida, United States": SportsballGeocodeTuple(
        city="Lakeland",
        state="FL",
        postal="",
        lat=28.055556,
        lng=-81.954444,
        housenumber="",
        country="USA",
    ),
    "Green Bay": GREEN_BAY,
    "Eastern Illinois University": SportsballGeocodeTuple(
        city="Charleston",
        state="IL",
        postal="",
        lat=39.484444,
        lng=-88.175278,
        housenumber="",
        country="USA",
    ),
    "University of Louisiana at Lafayette": SportsballGeocodeTuple(
        city="Lafayette",
        state="LA",
        postal="",
        lat=30.213,
        lng=-92.019,
        housenumber="",
        country="USA",
    ),
    "Duke": SportsballGeocodeTuple(
        city="Durham",
        state="NC",
        postal="",
        lat=36.001389,
        lng=-78.938333,
        housenumber="",
        country="USA",
    ),
    "Lamar": SportsballGeocodeTuple(
        city="Beaumont",
        state="TX",
        postal="",
        lat=30.041944,
        lng=-94.075,
        housenumber="",
        country="USA",
    ),
    "SMU": SportsballGeocodeTuple(
        city="University Park",
        state="TX",
        postal="",
        lat=32.83855,
        lng=-96.78294,
        housenumber="",
        country="USA",
    ),
    "Michigan": SportsballGeocodeTuple(
        city="",
        state="MI",
        postal="",
        lat=44.0,
        lng=-85.0,
        housenumber="",
        country="USA",
    ),
    "Mount Shasta, California, United States": SportsballGeocodeTuple(
        city="Mount Shasta",
        state="CA",
        postal="",
        lat=41.314444,
        lng=-122.311389,
        housenumber="",
        country="USA",
    ),
    "Overland Park, Kansas, United States": SportsballGeocodeTuple(
        city="Overland Park",
        state="KS",
        postal="",
        lat=38.886944,
        lng=-94.686944,
        housenumber="",
        country="USA",
    ),
    "Western Washington College": SportsballGeocodeTuple(
        city="Bellingham",
        state="WA",
        postal="",
        lat=48.734,
        lng=-122.486,
        housenumber="",
        country="USA",
    ),
    "Swisher Gymansium": SportsballGeocodeTuple(
        city="Jacksonville",
        state="FL",
        postal="32211",
        lat=30.350278,
        lng=-81.605,
        housenumber="",
        country="USA",
    ),
    "Berry College College": SportsballGeocodeTuple(
        city="Rome",
        state="GA",
        postal="",
        lat=34.29,
        lng=-85.189,
        housenumber="",
        country="USA",
    ),
    "Virginia Beach, VA, United States": VIRGINIA_BEACH,
    "Johnstown, NY, United States": SportsballGeocodeTuple(
        city="Johnstown",
        state="NY",
        postal="",
        lat=43.007222,
        lng=-74.372222,
        housenumber="",
        country="USA",
    ),
    "Mattoon, IL, United States": SportsballGeocodeTuple(
        city="Mattoon",
        state="IL",
        postal="",
        lat=39.4775,
        lng=-88.362222,
        housenumber="",
        country="USA",
    ),
    "San Diego, CA, United States": SAN_DIEGO,
    "University of Illinois at Urbana-Champaign": SportsballGeocodeTuple(
        city="Urbana-Champaign",
        state="IL",
        postal="",
        lat=40.110556,
        lng=-88.228333,
        housenumber="",
        country="USA",
    ),
    "College of the Holy Cross": SportsballGeocodeTuple(
        city="Worcester",
        state="MA",
        postal="",
        lat=42.239167,
        lng=-71.808333,
        housenumber="",
        country="USA",
    ),
    "Seoul, South Korea": SportsballGeocodeTuple(
        city="Seoul",
        state="",
        postal="",
        lat=37.56,
        lng=126.99,
        housenumber="",
        country="South Korea",
    ),
    "Louisiana State University": SportsballGeocodeTuple(
        city="Baton Rouge",
        state="LA",
        postal="",
        lat=30.4145,
        lng=-91.17826,
        housenumber="",
        country="USA",
    ),
    "Villanova University": VILLANOVA_COLLEGE,
    "Kansas": SportsballGeocodeTuple(
        city="",
        state="KS",
        postal="",
        lat=38.0,
        lng=-98.0,
        housenumber="",
        country="USA",
    ),
    "Petersburg, Virginia, United States": SportsballGeocodeTuple(
        city="Petersburg",
        state="VA",
        postal="",
        lat=37.23,
        lng=-77.405,
        housenumber="",
        country="USA",
    ),
    "Riga, Latvia": SportsballGeocodeTuple(
        city="Riga",
        state="",
        postal="",
        lat=56.948889,
        lng=24.106389,
        housenumber="",
        country="Latvia",
    ),
    "Bloomsburg College": SportsballGeocodeTuple(
        city="Bloomsburg",
        state="PA",
        postal="",
        lat=41.008,
        lng=-76.448,
        housenumber="",
        country="USA",
    ),
    "SE Missouri State": SportsballGeocodeTuple(
        city="Cape Girardeau",
        state="MO",
        postal="",
        lat=37.315125,
        lng=-89.529392,
        housenumber="",
        country="USA",
    ),
    "West Virginia University": SportsballGeocodeTuple(
        city="Morgantown",
        state="WV",
        postal="",
        lat=39.6458,
        lng=-79.9697,
        housenumber="",
        country="USA",
    ),
    "Virginia Commonwealth University": SportsballGeocodeTuple(
        city="Richmond",
        state="VA",
        postal="",
        lat=37.5466,
        lng=-77.4533,
        housenumber="",
        country="USA",
    ),
    "Arkansas": SportsballGeocodeTuple(
        city="",
        state="AK",
        postal="",
        lat=35.0,
        lng=-92.0,
        housenumber="",
        country="USA",
    ),
    "Norfolk State University": SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="",
        lat=36.8487,
        lng=-76.2625,
        housenumber="",
        country="USA",
    ),
    "LSU": SportsballGeocodeTuple(
        city="Baton Rouge",
        state="LA",
        postal="",
        lat=30.4145,
        lng=-91.17826,
        housenumber="",
        country="USA",
    ),
    "Texas Tech": SportsballGeocodeTuple(
        city="Lubbock",
        state="TX",
        postal="",
        lat=33.584,
        lng=-101.878,
        housenumber="",
        country="USA",
    ),
    "Lake Charles, Louisiana, United States": SportsballGeocodeTuple(
        city="Lake Charles",
        state="LA",
        postal="",
        lat=30.197222,
        lng=-93.236667,
        housenumber="",
        country="USA",
    ),
    "Indiana State University": SportsballGeocodeTuple(
        city="Terre Haute",
        state="IN",
        postal="",
        lat=39.47,
        lng=-87.41,
        housenumber="",
        country="USA",
    ),
    "Washington": SportsballGeocodeTuple(
        city="",
        state="WA",
        postal="",
        lat=47.0,
        lng=-120.0,
        housenumber="",
        country="USA",
    ),
    "United States Naval Academy": SportsballGeocodeTuple(
        city="Annapolis",
        state="MD",
        postal="",
        lat=38.9828,
        lng=-76.4851,
        housenumber="",
        country="USA",
    ),
    "Happy Valley, Oregon, United States": SportsballGeocodeTuple(
        city="Happy Valley",
        state="OR",
        postal="",
        lat=45.435911,
        lng=-122.508117,
        housenumber="",
        country="USA",
    ),
    "University of San Francisco": SportsballGeocodeTuple(
        city="San Francisco",
        state="CA",
        postal="",
        lat=37.779444,
        lng=-122.451944,
        housenumber="",
        country="USA",
    ),
    "Tennessee State College": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.166667,
        lng=-86.830556,
        housenumber="",
        country="USA",
    ),
    "Kanagawa, Japan": SportsballGeocodeTuple(
        city="Kanagawa",
        state="",
        postal="",
        lat=35.447508,
        lng=139.642344,
        housenumber="",
        country="Japan",
    ),
    "Arakawa, JP": SportsballGeocodeTuple(
        city="Arakawa",
        state="",
        postal="",
        lat=35.733333,
        lng=139.783333,
        housenumber="",
        country="Japan",
    ),
    "Inver Grove Heights, MN, United States": SportsballGeocodeTuple(
        city="Inver Grove Heights",
        state="MN",
        postal="",
        lat=44.848056,
        lng=-93.042778,
        housenumber="",
        country="USA",
    ),
    "Springfield, MA, United States": SportsballGeocodeTuple(
        city="Springfield",
        state="MA",
        postal="",
        lat=42.101389,
        lng=-72.590278,
        housenumber="",
        country="USA",
    ),
    "East Setauket, NY, United States": SportsballGeocodeTuple(
        city="East Setauket",
        state="NY",
        postal="",
        lat=40.939722,
        lng=-73.098889,
        housenumber="",
        country="USA",
    ),
    "Canton, IL, United States": SportsballGeocodeTuple(
        city="Canton",
        state="IL",
        postal="",
        lat=40.557778,
        lng=-90.034167,
        housenumber="",
        country="USA",
    ),
    "Corpus Christi, TX, United States": CORPUS_CHRISTI,
    "Tampa, FL, United States": TAMPA,
    "La Sabana, La Guaira, Venezuela": SportsballGeocodeTuple(
        city="La Sabana",
        state="La Guaira",
        postal="",
        lat=10.618,
        lng=-66.382,
        housenumber="",
        country="Venezuela",
    ),
    "Guatire, Miranda, Venezuela": SportsballGeocodeTuple(
        city="Guatire",
        state="Miranda",
        postal="",
        lat=10.471667,
        lng=-66.540556,
        housenumber="",
        country="Venezuela",
    ),
    "Pembroke Pines, FL, United States": SportsballGeocodeTuple(
        city="Pembroke Pines",
        state="FL",
        postal="",
        lat=26.0125,
        lng=-80.313611,
        housenumber="",
        country="USA",
    ),
    "Birmingham, AL, United States": BIRMINGHAM,
    "St. Joseph, MO, United States": SportsballGeocodeTuple(
        city="St. Joseph",
        state="MO",
        postal="",
        lat=39.758056,
        lng=-94.836667,
        housenumber="",
        country="USA",
    ),
    "Joliet, IL, United States": SportsballGeocodeTuple(
        city="Joliet",
        state="IL",
        postal="",
        lat=41.529722,
        lng=-88.072778,
        housenumber="",
        country="USA",
    ),
    "Richmond, VA, United States": RICHMOND,
    "Colleyville, TX, US": SportsballGeocodeTuple(
        city="Colleyville",
        state="TX",
        postal="",
        lat=32.880556,
        lng=-97.147222,
        housenumber="",
        country="USA",
    ),
    "Baylor University": SportsballGeocodeTuple(
        city="Waco",
        state="TX",
        postal="",
        lat=31.548,
        lng=-97.116,
        housenumber="",
        country="USA",
    ),
    "Iowa State University": SportsballGeocodeTuple(
        city="Ames",
        state="IO",
        postal="",
        lat=42.0262,
        lng=-93.648,
        housenumber="",
        country="USA",
    ),
    "University of Dayton": SportsballGeocodeTuple(
        city="Dayton",
        state="OH",
        postal="",
        lat=39.740415,
        lng=-84.179213,
        housenumber="",
        country="USA",
    ),
    "St. Bonaventure University": SportsballGeocodeTuple(
        city="St. Bonaventure",
        state="NY",
        postal="",
        lat=42.078094,
        lng=-78.481307,
        housenumber="",
        country="USA",
    ),
    "University of Miami": SportsballGeocodeTuple(
        city="Coral Gabes",
        state="FL",
        postal="",
        lat=25.7216,
        lng=-80.2793,
        housenumber="",
        country="USA",
    ),
    "University of Nevada, Reno": SportsballGeocodeTuple(
        city="Reno",
        state="NV",
        postal="",
        lat=39.537778,
        lng=-119.813889,
        housenumber="",
        country="USA",
    ),
    "Brigham Young University": SportsballGeocodeTuple(
        city="Provo",
        state="UT",
        postal="",
        lat=40.25,
        lng=-111.649,
        housenumber="",
        country="USA",
    ),
    "Vanderbilt University": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.1475,
        lng=-86.8025,
        housenumber="",
        country="USA",
    ),
    "Midwestern State College": SportsballGeocodeTuple(
        city="Witchita Falls",
        state="TX",
        postal="",
        lat=33.873889,
        lng=-98.521111,
        housenumber="",
        country="USA",
    ),
    "Beloit College College": SportsballGeocodeTuple(
        city="Beloit",
        state="WI",
        postal="",
        lat=42.503,
        lng=-89.031,
        housenumber="",
        country="USA",
    ),
    "Columbia College": SportsballGeocodeTuple(
        city="New York",
        state="NY",
        postal="",
        lat=40.8079,
        lng=-73.9628,
        housenumber="",
        country="USA",
    ),
    "Jacksonville College": SportsballGeocodeTuple(
        city="Jacksonville",
        state="TX",
        postal="",
        lat=31.9658307,
        lng=-95.2810038,
        housenumber="",
        country="USA",
    ),
    "Ashland College": SportsballGeocodeTuple(
        city="Ashland",
        state="OH",
        postal="",
        lat=40.861667,
        lng=-82.323056,
        housenumber="",
        country="USA",
    ),
    "Abilene Christian College": SportsballGeocodeTuple(
        city="Abilene",
        state="TX",
        postal="",
        lat=32.469444,
        lng=-99.708056,
        housenumber="",
        country="USA",
    ),
    "Nebraska-Omaha College": SportsballGeocodeTuple(
        city="Omaha",
        state="NB",
        postal="",
        lat=41.259,
        lng=-96.006,
        housenumber="",
        country="USA",
    ),
    "Northeast Mississippi CC College": SportsballGeocodeTuple(
        city="Booneville",
        state="MS",
        postal="",
        lat=34.6675,
        lng=-88.5625,
        housenumber="",
        country="USA",
    ),
    "Carson-Newman College": SportsballGeocodeTuple(
        city="Jefferson City",
        state="TN",
        postal="",
        lat=36.121944,
        lng=-83.492222,
        housenumber="",
        country="USA",
    ),
    "West Georgia College": SportsballGeocodeTuple(
        city="Carrollton",
        state="GA",
        postal="",
        lat=33.571667,
        lng=-85.114722,
        housenumber="",
        country="USA",
    ),
    "Woburn, Massachusetts, United States": SportsballGeocodeTuple(
        city="Woburn",
        state="MA",
        postal="",
        lat=42.479167,
        lng=-71.152778,
        housenumber="",
        country="USA",
    ),
    "Basking Ridge, New Jersey, United States": SportsballGeocodeTuple(
        city="Basking Ridge",
        state="NJ",
        postal="",
        lat=40.7062,
        lng=-74.5493,
        housenumber="",
        country="USA",
    ),
    "University of Arkansas": SportsballGeocodeTuple(
        city="Fayetteville",
        state="AK",
        postal="",
        lat=36.068611,
        lng=-94.176111,
        housenumber="",
        country="USA",
    ),
    "University of California": SportsballGeocodeTuple(
        city="Oakland",
        state="CA",
        postal="",
        lat=37.802222,
        lng=-122.271389,
        housenumber="",
        country="USA",
    ),
    "Olympic Stadium Zawiya - Zawiya - Libya": SportsballGeocodeTuple(
        city="Zawiya",
        state="",
        postal="",
        lat=32.753889,
        lng=12.739167,
        housenumber="",
        country="Libya",
    ),
    "Clemson University": SportsballGeocodeTuple(
        city="Clemson",
        state="SC",
        postal="",
        lat=34.678333,
        lng=-82.839167,
        housenumber="",
        country="USA",
    ),
    "ohio-state": SportsballGeocodeTuple(
        city="Columbus",
        state="OH",
        postal="",
        lat=40.0,
        lng=-83.0125,
        housenumber="",
        country="USA",
    ),
    "University of Oregon": SportsballGeocodeTuple(
        city="Eugene",
        state="OR",
        postal="",
        lat=44.0443,
        lng=-123.0758,
        housenumber="",
        country="USA",
    ),
    "Temple University": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.981389,
        lng=-75.154444,
        housenumber="",
        country="USA",
    ),
    "DePaul University": SportsballGeocodeTuple(
        city="Chicago",
        state="IL",
        postal="",
        lat=39.981389,
        lng=-75.154444,
        housenumber="",
        country="USA",
    ),
    "Davidson College": SportsballGeocodeTuple(
        city="Davidson",
        state="NC",
        postal="",
        lat=35.49999,
        lng=-80.845296,
        housenumber="",
        country="USA",
    ),
    "University of Southern Mississippi": SportsballGeocodeTuple(
        city="Hattiesburg",
        state="MS",
        postal="",
        lat=31.329638,
        lng=-89.333847,
        housenumber="",
        country="USA",
    ),
    "Valjevo, Serbia": SportsballGeocodeTuple(
        city="Valjevo",
        state="",
        postal="",
        lat=44.266667,
        lng=19.883333,
        housenumber="",
        country="Serbia",
    ),
    "Kansas State University": SportsballGeocodeTuple(
        city="Manhattan",
        state="KS",
        postal="",
        lat=39.1914,
        lng=-96.5809,
        housenumber="",
        country="USA",
    ),
    "University of Mississippi": SportsballGeocodeTuple(
        city="Lafayette County",
        state="MS",
        postal="38677",
        lat=34.3662492,
        lng=-89.5379687,
        housenumber="",
        country="USA",
    ),
    "Western Kentucky University": SportsballGeocodeTuple(
        city="Bowling Green",
        state="KY",
        postal="",
        lat=36.986111,
        lng=-86.455556,
        housenumber="",
        country="USA",
    ),
    "Ball State University": SportsballGeocodeTuple(
        city="Muncie",
        state="IN",
        postal="",
        lat=40.198322,
        lng=-85.408943,
        housenumber="",
        country="USA",
    ),
    "Indiana University-Purdue University Indianapolis": SportsballGeocodeTuple(
        city="Indianapolis",
        state="IN",
        postal="",
        lat=39.773996,
        lng=-86.176361,
        housenumber="",
        country="USA",
    ),
    "Miami University": SportsballGeocodeTuple(
        city="Oxford",
        state="OH",
        postal="",
        lat=39.511905,
        lng=-84.734674,
        housenumber="",
        country="USA",
    ),
    "Seton Hall University": SportsballGeocodeTuple(
        city="South Orange",
        state="NJ",
        postal="",
        lat=40.7417,
        lng=-74.2449,
        housenumber="",
        country="USA",
    ),
    "Saint Joseph's University": SportsballGeocodeTuple(
        city="Philadelphia-Lower Merion",
        state="PA",
        postal="",
        lat=39.995278,
        lng=-75.238889,
        housenumber="",
        country="USA",
    ),
    "Northeastern University": SportsballGeocodeTuple(
        city="Boston",
        state="MA",
        postal="",
        lat=42.34,
        lng=-71.088333,
        housenumber="",
        country="USA",
    ),
    "Tsongas Center - Lowell, Massachusetts - United States": TSONGAS_CENTER,
    "University of Detroit Mercy": SportsballGeocodeTuple(
        city="Detroit",
        state="MI",
        postal="",
        lat=42.41411,
        lng=-83.137922,
        housenumber="",
        country="USA",
    ),
    "Manchester, New Hampshire, United States": SportsballGeocodeTuple(
        city="Manchester",
        state="NH",
        postal="",
        lat=42.990833,
        lng=-71.463611,
        housenumber="",
        country="USA",
    ),
    "Fayetteville State University": SportsballGeocodeTuple(
        city="Fayetteville",
        state="NC",
        postal="",
        lat=35.072,
        lng=-78.8945,
        housenumber="",
        country="USA",
    ),
    "College of Charleston": SportsballGeocodeTuple(
        city="Charleston",
        state="SC",
        postal="",
        lat=32.784167,
        lng=-79.938056,
        housenumber="",
        country="USA",
    ),
    "Xavier University": SportsballGeocodeTuple(
        city="Cincinnati",
        state="OH",
        postal="",
        lat=39.14868,
        lng=-84.47799,
        housenumber="",
        country="USA",
    ),
    "Pittsburgh, Pennsylvania, United States": SportsballGeocodeTuple(
        city="Pittsburgh",
        state="PA",
        postal="",
        lat=40.439722,
        lng=-79.976389,
        housenumber="",
        country="USA",
    ),
    "Ohio University": SportsballGeocodeTuple(
        city="Athens",
        state="OH",
        postal="",
        lat=39.324,
        lng=-82.102,
        housenumber="",
        country="USA",
    ),
    "California State University, Long Beach": SportsballGeocodeTuple(
        city="Long Beach",
        state="CA",
        postal="",
        lat=33.783022,
        lng=-118.112858,
        housenumber="",
        country="USA",
    ),
    "Lawrence Joel Veterans Memorial Coliseum - Winston-Salem, North Carolina - United States": LAWRENCE_JOEL_VETERANS_MEMORIAL_COLISEUM,
    "KFC YUM! Center - Louisville, Kentucky - United States": KFC_YUM_CENTER,
    "University of Memphis": SportsballGeocodeTuple(
        city="Memphis",
        state="TN",
        postal="",
        lat=35.118889,
        lng=-89.937222,
        housenumber="",
        country="USA",
    ),
    "Eastern Washington University": SportsballGeocodeTuple(
        city="Cheney",
        state="WA",
        postal="",
        lat=47.491389,
        lng=-117.583056,
        housenumber="",
        country="USA",
    ),
    "University of Iowa": SportsballGeocodeTuple(
        city="Iowa City",
        state="IO",
        postal="",
        lat=41.661667,
        lng=-91.536389,
        housenumber="",
        country="USA",
    ),
    "Georgia State University": SportsballGeocodeTuple(
        city="Atlanta",
        state="GA",
        postal="",
        lat=33.753694,
        lng=-84.385972,
        housenumber="",
        country="USA",
    ),
    "Faurot Field": SportsballGeocodeTuple(
        city="Columbia",
        state="MO",
        postal="65201",
        lat=38.935833,
        lng=-92.333056,
        housenumber="600",
        country="USA",
    ),
    "Oregon State University": SportsballGeocodeTuple(
        city="Corvallis",
        state="OR",
        postal="",
        lat=44.5639,
        lng=-123.2747,
        housenumber="",
        country="USA",
    ),
    "Texas A&M University": SportsballGeocodeTuple(
        city="College Station",
        state="TX",
        postal="",
        lat=30.610278,
        lng=-96.343611,
        housenumber="",
        country="USA",
    ),
    "Mercer University": SportsballGeocodeTuple(
        city="Macon",
        state="GA",
        postal="",
        lat=32.829167,
        lng=-83.648611,
        housenumber="",
        country="USA",
    ),
    "Saint Louis University": SportsballGeocodeTuple(
        city="St. Louis",
        state="MO",
        postal="",
        lat=38.636389,
        lng=-90.234167,
        housenumber="",
        country="USA",
    ),
    "Times Union Center - Albany, New York - United States": TIMES_UNION_CENTER,
    "O2 Arena": O2_ARENA,
    "Purdue University": SportsballGeocodeTuple(
        city="West Lafayette",
        state="IN",
        postal="",
        lat=40.425,
        lng=-86.923056,
        housenumber="",
        country="USA",
    ),
    "University Stadium - Waterloo, Canada - Canada": SportsballGeocodeTuple(
        city="Waterloo",
        state="ON",
        postal="",
        lat=43.470278,
        lng=-80.53,
        housenumber="",
        country="Canada",
    ),
    "University of New Orleans": SportsballGeocodeTuple(
        city="New Orleans",
        state="LA",
        postal="",
        lat=30.0275,
        lng=-90.0671,
        housenumber="",
        country="USA",
    ),
    "Petersen Events Center - Pittsburgh,Pennsylvania - United States": PETERSEN_EVENTS_CENTER,
    "Virginia Polytechnic Institute and State University": SportsballGeocodeTuple(
        city="Blacksburg",
        state="VA",
        postal="",
        lat=37.225,
        lng=-80.425,
        housenumber="",
        country="USA",
    ),
    "University of West Florida": SportsballGeocodeTuple(
        city="Pensacola",
        state="FL",
        postal="",
        lat=30.5495,
        lng=-87.2181,
        housenumber="",
        country="USA",
    ),
    "Mullins Center - Amherst, MA - United States": MULLINS_CENTER,
    "Wichita State University": SportsballGeocodeTuple(
        city="Wichita",
        state="KS",
        postal="",
        lat=37.719167,
        lng=-97.293056,
        housenumber="24",
        country="USA",
    ),
    "Avesta, Sweden": SportsballGeocodeTuple(
        city="Avesta",
        state="",
        postal="",
        lat=60.145556,
        lng=16.168333,
        housenumber="",
        country="Sweden",
    ),
    "Bamako, Mali": SportsballGeocodeTuple(
        city="Bamako",
        state="",
        postal="",
        lat=12.639167,
        lng=-8.002778,
        housenumber="",
        country="Mali",
    ),
    "Monroe, North Carolina, United States": SportsballGeocodeTuple(
        city="Monroe",
        state="NC",
        postal="",
        lat=34.988889,
        lng=-80.549722,
        housenumber="",
        country="USA",
    ),
    "PNC Arena": PNC_ARENA,
    "Chartway Arena - Norfolk, Virginia - United States": SportsballGeocodeTuple(
        city="Norfolk",
        state="VA",
        postal="",
        lat=36.884169,
        lng=-76.301231,
        housenumber="4320",
        country="USA",
    ),
    "Agganis Arena - Boston, Massachusetts - United States": AGGANIS_ARENA,
    "Cajundome - Lafayette, Louisiana - United States": CAJUNDOME,
    "Ryan Center - Kingston, Rhode Island - United States": RYAN_CENTER,
    "Brentwood, New York, United States": SportsballGeocodeTuple(
        city="Brentwood",
        state="NY",
        postal="",
        lat=40.781667,
        lng=-73.244167,
        housenumber="",
        country="USA",
    ),
    "Durham, North Carolina, United States": DURHAM,
    "Santo Domingo, Distrito Nacional, Dominican Republic": SportsballGeocodeTuple(
        city="Santo Domingo",
        state="Distrito Nacional",
        postal="",
        lat=18.4625,
        lng=-69.936111,
        housenumber="",
        country="Dominican Republic",
    ),
    "Lubumbashi, Democratic Republic of the Congo": SportsballGeocodeTuple(
        city="Lubumbashi",
        state="",
        postal="",
        lat=-11.664167,
        lng=27.482778,
        housenumber="",
        country="Democratic Republic of the Congo",
    ),
    "Baldwin, New York, United States": SportsballGeocodeTuple(
        city="Baldwin",
        state="NY",
        postal="",
        lat=40.670222,
        lng=-73.6125,
        housenumber="",
        country="USA",
    ),
    "North Vancouver, British Columbia, Canada": SportsballGeocodeTuple(
        city="North Vancouver",
        state="BC",
        postal="",
        lat=49.316667,
        lng=-123.066667,
        housenumber="",
        country="Canada",
    ),
    "Lumberton, NJ, United States": SportsballGeocodeTuple(
        city="Lumberton",
        state="NJ",
        postal="",
        lat=39.958855,
        lng=-74.802478,
        housenumber="",
        country="USA",
    ),
    "Jon M. Huntsman Center - Salt Lake City, UT - United States": JON_M_HUNTSMAN_CENTER,
    "Estadio Santiago Bernabéu - Madrid - Spain": SportsballGeocodeTuple(
        city="Madrid",
        state="",
        postal="",
        lat=40.453056,
        lng=-3.688333,
        housenumber="",
        country="Spain",
    ),
    "Wildwood, New Jersey, United States": SportsballGeocodeTuple(
        city="Wildwood",
        state="NJ",
        postal="",
        lat=38.988914,
        lng=-74.819824,
        housenumber="",
        country="USA",
    ),
    "Arizona State University": SportsballGeocodeTuple(
        city="Tempe",
        state="AZ",
        postal="",
        lat=33.4209,
        lng=-111.934,
        housenumber="",
        country="USA",
    ),
    "Murray State University": SportsballGeocodeTuple(
        city="Murray",
        state="KY",
        postal="",
        lat=36.615556,
        lng=-88.321389,
        housenumber="",
        country="USA",
    ),
    "Wisconsin": SportsballGeocodeTuple(
        city="",
        state="WI",
        postal="",
        lat=44.0,
        lng=-90.0,
        housenumber="",
        country="USA",
    ),
    "FLA Live Arena": FLA_LIVE_ARENA,
    "Liberty University": SportsballGeocodeTuple(
        city="Lynchburg",
        state="VA",
        postal="",
        lat=37.352,
        lng=-79.18,
        housenumber="",
        country="USA",
    ),
    "Seattle University": SportsballGeocodeTuple(
        city="Seattle",
        state="WA",
        postal="",
        lat=47.61,
        lng=-122.32,
        housenumber="",
        country="USA",
    ),
    "Ford Center - Evansville, Indiana - United States": FORD_CENTER,
    "University of Utah": SportsballGeocodeTuple(
        city="Salt Lake City",
        state="UT",
        postal="",
        lat=40.7642,
        lng=-111.8465,
        housenumber="",
        country="USA",
    ),
    "Ericsson Globe Arena": SportsballGeocodeTuple(
        city="Stockholm",
        state="",
        postal="121 77",
        lat=59.293556,
        lng=18.083236,
        housenumber="",
        country="Sweden",
    ),
    "Bender Arena - Washington, D.C. - United States": BENDER_ARENA,
    "Hulman Center - Terre Haute, Indiana - United States": HULMAN_CENTER,
    "University of Wisconsin-Green Bay": SportsballGeocodeTuple(
        city="Green Bay",
        state="WI",
        postal="",
        lat=44.53,
        lng=-87.92083,
        housenumber="",
        country="USA",
    ),
    "Wolstein Center - Cleveland, Ohio - United States": WOLSTEIN_CENTER,
    "George Washington": SportsballGeocodeTuple(
        city="Foggy Bottom",
        state="DC",
        postal="",
        lat=38.8997145,
        lng=-77.0485992,
        housenumber="",
        country="USA",
    ),
    "Chaifetz Arena - St. Louis, Missouri - United States": CHAIFETZ_ARENA,
    "Magness Arena - Denver, Colorado - United States": MAGNESS_ARENA,
    "University of Wyoming": SportsballGeocodeTuple(
        city="Laramie",
        state="WY",
        postal="",
        lat=41.313056,
        lng=-105.581389,
        housenumber="",
        country="USA",
    ),
    "Louisville": LOUISVILLE,
    "Tennessee State University": SportsballGeocodeTuple(
        city="Nashville",
        state="TN",
        postal="",
        lat=36.166667,
        lng=-86.830556,
        housenumber="",
        country="USA",
    ),
    "Cleveland State University": SportsballGeocodeTuple(
        city="Cleveland",
        state="OH",
        postal="",
        lat=41.5017,
        lng=-81.6751,
        housenumber="",
        country="USA",
    ),
    "Portland State University": SportsballGeocodeTuple(
        city="Portland",
        state="OR",
        postal="",
        lat=45.512778,
        lng=-122.685278,
        housenumber="",
        country="USA",
    ),
    "Don Haskins Center - El Paso, Texas - United States": DON_HASKINS_CENTER,
    "Portland State College": SportsballGeocodeTuple(
        city="Portland",
        state="OR",
        postal="",
        lat=45.512778,
        lng=-122.685278,
        housenumber="",
        country="USA",
    ),
    "Milwaukee College": SportsballGeocodeTuple(
        city="Milwaukee",
        state="WI",
        postal="",
        lat=43.075,
        lng=-87.8829,
        housenumber="",
        country="USA",
    ),
    "Nobleton, Ontario, Canada": SportsballGeocodeTuple(
        city="Nobleton",
        state="ON",
        postal="",
        lat=43.902222,
        lng=-79.652778,
        housenumber="",
        country="Canada",
    ),
    "Springfield, VA, United States": SportsballGeocodeTuple(
        city="Springfield",
        state="VA",
        postal="",
        lat=38.788611,
        lng=-77.179444,
        housenumber="",
        country="Canada",
    ),
    "Memorial Hall - Kansas City, Kansas - United States": SportsballGeocodeTuple(
        city="Kansas City",
        state="KS",
        postal="66101",
        lat=39.112352,
        lng=-94.62761,
        housenumber="600",
        country="Canada",
    ),
    "Marshall University": SportsballGeocodeTuple(
        city="Huntington",
        state="WV",
        postal="",
        lat=38.42508,
        lng=-82.42046,
        housenumber="",
        country="USA",
    ),
    "Winnipeg Arena": SportsballGeocodeTuple(
        city="Winnipeg",
        state="MB",
        postal="",
        lat=49.886944,
        lng=-97.197778,
        housenumber="1430",
        country="USA",
    ),
    "Bucknell University": SportsballGeocodeTuple(
        city="Lewisburg",
        state="PA",
        postal="",
        lat=40.954722,
        lng=-76.883611,
        housenumber="",
        country="USA",
    ),
    "Rice University": SportsballGeocodeTuple(
        city="Houston",
        state="TX",
        postal="",
        lat=29.716944,
        lng=-95.402778,
        housenumber="",
        country="USA",
    ),
    "Hampton College": SportsballGeocodeTuple(
        city="Hampton",
        state="VA",
        postal="",
        lat=37.0225,
        lng=-76.334722,
        housenumber="",
        country="USA",
    ),
    "University of Wisconsin": SportsballGeocodeTuple(
        city="Madison",
        state="WI",
        postal="",
        lat=43.075278,
        lng=-89.404167,
        housenumber="",
        country="USA",
    ),
    "Southeastern Illinois College": SportsballGeocodeTuple(
        city="Harrisburg",
        state="IL",
        postal="",
        lat=37.7525,
        lng=-88.435556,
        housenumber="",
        country="USA",
    ),
    "Colorado State University": SportsballGeocodeTuple(
        city="Fort Collins",
        state="CO",
        postal="",
        lat=40.5762,
        lng=-105.0808,
        housenumber="",
        country="USA",
    ),
    "Nicholls College": SportsballGeocodeTuple(
        city="Dudley",
        state="MA",
        postal="",
        lat=42.04,
        lng=-71.93,
        housenumber="",
        country="USA",
    ),
    "Montreal Olympic Stadium - Montreal, QC - Canada": SportsballGeocodeTuple(
        city="Montreal",
        state="QC",
        postal="",
        lat=45.558,
        lng=-73.552,
        housenumber="4545",
        country="Canada",
    ),
    "Butler County Community College": SportsballGeocodeTuple(
        city="Butler",
        state="PA",
        postal="",
        lat=40.8297,
        lng=-79.912,
        housenumber="",
        country="USA",
    ),
    "South Plains College": SportsballGeocodeTuple(
        city="Levelland",
        state="TX",
        postal="",
        lat=33.576243,
        lng=-102.367642,
        housenumber="",
        country="USA",
    ),
    "Connecticut College College": SportsballGeocodeTuple(
        city="New London",
        state="CT",
        postal="",
        lat=41.378433,
        lng=-72.104669,
        housenumber="",
        country="USA",
    ),
    "Rickwood Field": SportsballGeocodeTuple(
        city="Birmingham",
        state="AL",
        postal="",
        lat=33.502222,
        lng=-86.855833,
        housenumber="",
        country="USA",
    ),
    "Central Michigan University": SportsballGeocodeTuple(
        city="Mount Pleasant",
        state="MI",
        postal="",
        lat=43.5898,
        lng=-84.7775,
        housenumber="",
        country="USA",
    ),
    "Drexel University": SportsballGeocodeTuple(
        city="Philadelphia",
        state="PA",
        postal="",
        lat=39.954,
        lng=-75.188,
        housenumber="",
        country="USA",
    ),
    "Matthews Arena - United States": MATTHEWS_ARENA,
    "London Stadium": SportsballGeocodeTuple(
        city="London",
        state="",
        postal="E20 2ST",
        lat=51.538611,
        lng=-0.016389,
        housenumber="",
        country="UK",
    ),
    "Baxter Arena - Omaha, NE - United States": BAXTER_ARENA,
    "Western Michigan University": SportsballGeocodeTuple(
        city="Kalamazoo",
        state="MI",
        postal="",
        lat=42.283333,
        lng=-85.613889,
        housenumber="",
        country="USA",
    ),
    "Florida State University": SportsballGeocodeTuple(
        city="Tallahassee",
        state="FL",
        postal="",
        lat=30.442,
        lng=-84.298,
        housenumber="",
        country="USA",
    ),
    "California State Uni College": SportsballGeocodeTuple(
        city="Long Beach",
        state="CA",
        postal="",
        lat=33.763889,
        lng=-118.201111,
        housenumber="",
        country="USA",
    ),
    "Harvard University": SportsballGeocodeTuple(
        city="Cambridge",
        state="MA",
        postal="",
        lat=42.374444,
        lng=-71.116944,
        housenumber="",
        country="USA",
    ),
    "Eastern Michigan University": SportsballGeocodeTuple(
        city="Ypsilanti",
        state="MI",
        postal="",
        lat=42.250154,
        lng=-83.624454,
        housenumber="",
        country="USA",
    ),
}
_GEOCODES_LOADED = False


def _load_cached_geocodes():
    global _GEOCODES_LOADED
    if not _GEOCODES_LOADED:
        with open(
            os.path.join(os.path.dirname(__file__), "venues.json"), encoding="utf8"
        ) as handle:
            venue_db = json.load(handle)
            venues = venue_db["venues"]
            searches = venue_db["searches"]
            searches = {
                k: SportsballGeocodeTuple(
                    city=venues[v]["city"],
                    state=venues[v]["state"],
                    postal=venues[v]["postal"],
                    lat=venues[v]["lat"],
                    lng=venues[v]["lng"],
                    housenumber=venues[v]["housenumber"],
                    country=venues[v]["country"],
                )
                for k, v in searches.items()
            }
            _CACHED_GEOCODES.update(searches)
        _GEOCODES_LOADED = True


def _create_google_address_model(
    query: str, session: ScrapeSession, dt: datetime.datetime | None
) -> AddressModel:
    with session.wayback_disabled():
        _load_cached_geocodes()
        query = query.replace("\n", "").replace("&nbsp;", " ")
        g = _CACHED_GEOCODES.get(query)
        if g is None:
            logging.warning("Failed to find query: %s", query)
            g = geocoder.google(query, session=session)
            _CACHED_GEOCODES[query] = g
        latitude = g.lat
        longitude = g.lng
        weather_model = None
        tz = "UTC"
        altitude = None
        if latitude is not None and longitude is not None:
            tf = TimezoneFinder()
            timezone = tf.timezone_at(lng=longitude, lat=latitude)
            if timezone is not None:
                tz = timezone
            if dt is not None:
                weather_model = create_mutli_weather_model(
                    session,
                    latitude,
                    longitude,
                    dt,  # pyright: ignore
                    tz,
                )
            if not pytest_is_running.is_running():
                url = f"https://api.opentopodata.org/v1/aster30m?locations={latitude},{longitude}"
                r = session.get(url)
                r.raise_for_status()
                data = r.json()
                altitude = data["results"][0]["elevation"]
        try:
            return AddressModel(
                city=g.city,
                state=g.state,
                zipcode=g.postal,
                latitude=latitude,
                longitude=longitude,
                housenumber=g.housenumber,
                weather=weather_model,  # pyright: ignore
                timezone=tz,
                country=g.country,
                altitude=altitude,
                version=VERSION,
            )
        except Exception as exc:
            logging.warning('Failed to retrieve address model for query "%s"', query)
            raise AddressException(
                f'AddressModel failed to validate: "{query}"'
            ) from exc


@MEMORY.cache(ignore=["session"])
def _cached_create_google_address_model(
    query: str, session: ScrapeSession, dt: datetime.datetime | None
) -> AddressModel:
    return _create_google_address_model(query=query, session=session, dt=dt)


def create_google_address_model(
    query: str, session: ScrapeSession, dt: datetime.datetime | None
) -> AddressModel:
    """Create address model from google."""
    if not pytest_is_running.is_running():
        return _cached_create_google_address_model(query=query, session=session, dt=dt)
    with session.cache_disabled():
        return _create_google_address_model(query=query, session=session, dt=dt)
