# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.compile_prompt_deployment_expand_meta_request import CompilePromptDeploymentExpandMetaRequest
from ...types.deployment_history_item import DeploymentHistoryItem
from ...types.deployment_provider_payload_response import DeploymentProviderPayloadResponse
from ...types.deployment_read import DeploymentRead
from ...types.deployment_release_tag_read import DeploymentReleaseTagRead
from ...types.paginated_deployment_release_tag_read_list import PaginatedDeploymentReleaseTagReadList
from ...types.paginated_slim_deployment_read_list import PaginatedSlimDeploymentReadList
from ...types.prompt_deployment_input_request import PromptDeploymentInputRequest
from ...types.prompt_deployment_release import PromptDeploymentRelease
from .raw_client import AsyncRawDeploymentsClient, RawDeploymentsClient
from .types.deployments_list_request_status import DeploymentsListRequestStatus
from .types.list_deployment_release_tags_request_source import ListDeploymentReleaseTagsRequestSource

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DeploymentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDeploymentsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawDeploymentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDeploymentsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        status: typing.Optional[DeploymentsListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedSlimDeploymentReadList:
        """
        Used to list all Prompt Deployments.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        status : typing.Optional[DeploymentsListRequestStatus]
            status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedSlimDeploymentReadList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.deployments.list()
        """
        _response = self._raw_client.list(
            limit=limit, offset=offset, ordering=ordering, status=status, request_options=request_options
        )
        return _response.data

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DeploymentRead:
        """
        Used to retrieve a Prompt Deployment given its ID or name.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeploymentRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.deployments.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(id, request_options=request_options)
        return _response.data

    def deployment_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeploymentHistoryItem:
        """
        DEPRECATED: This endpoint is deprecated and will be removed in a future release. Please use the
        `retrieve_prompt_deployment_release` xendpoint instead.

        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Deployment History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Deployment History Item you'd like to retrieve.

        id : str
            Either the Prompt Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeploymentHistoryItem


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.deployments.deployment_history_item_retrieve(
            history_id_or_release_tag="history_id_or_release_tag",
            id="id",
        )
        """
        _response = self._raw_client.deployment_history_item_retrieve(
            history_id_or_release_tag, id, request_options=request_options
        )
        return _response.data

    def list_deployment_release_tags(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        source: typing.Optional[ListDeploymentReleaseTagsRequestSource] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedDeploymentReleaseTagReadList:
        """
        List Release Tags associated with the specified Prompt Deployment

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        source : typing.Optional[ListDeploymentReleaseTagsRequestSource]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedDeploymentReleaseTagReadList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.deployments.list_deployment_release_tags(
            id="id",
        )
        """
        _response = self._raw_client.list_deployment_release_tags(
            id, limit=limit, offset=offset, ordering=ordering, source=source, request_options=request_options
        )
        return _response.data

    def retrieve_deployment_release_tag(
        self, id: str, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeploymentReleaseTagRead:
        """
        Retrieve a Deployment Release Tag by tag name, associated with a specified Deployment.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Deployment that you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeploymentReleaseTagRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.deployments.retrieve_deployment_release_tag(
            id="id",
            name="name",
        )
        """
        _response = self._raw_client.retrieve_deployment_release_tag(id, name, request_options=request_options)
        return _response.data

    def update_deployment_release_tag(
        self,
        id: str,
        name: str,
        *,
        history_item_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeploymentReleaseTagRead:
        """
        Updates an existing Release Tag associated with the specified Prompt Deployment.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Deployment that you'd like to update.

        history_item_id : typing.Optional[str]
            The ID of the Release to tag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeploymentReleaseTagRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.deployments.update_deployment_release_tag(
            id="id",
            name="name",
        )
        """
        _response = self._raw_client.update_deployment_release_tag(
            id, name, history_item_id=history_item_id, request_options=request_options
        )
        return _response.data

    def retrieve_prompt_deployment_release(
        self, id: str, release_id_or_release_tag: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PromptDeploymentRelease:
        """
        Retrieve a specific Prompt Deployment Release by either its UUID or the name of a Release Tag that points to it.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        release_id_or_release_tag : str
            Either the UUID of Prompt Deployment Release you'd like to retrieve, or the name of a Release Tag that's pointing to the Prompt Deployment Release you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptDeploymentRelease


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.deployments.retrieve_prompt_deployment_release(
            id="id",
            release_id_or_release_tag="release_id_or_release_tag",
        )
        """
        _response = self._raw_client.retrieve_prompt_deployment_release(
            id, release_id_or_release_tag, request_options=request_options
        )
        return _response.data

    def retrieve_provider_payload(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[CompilePromptDeploymentExpandMetaRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeploymentProviderPayloadResponse:
        """
        Given a set of input variable values, compile the exact payload that Vellum would send to the configured model provider
        for execution if the execute-prompt endpoint had been invoked. Note that this endpoint does not actually execute the
        prompt or make an API call to the model provider.

        This endpoint is useful if you don't want to proxy LLM provider requests through Vellum and prefer to send them directly
        to the provider yourself. Note that no guarantees are made on the format of this API's response schema, other than
        that it will be a valid payload for the configured model provider. It's not recommended that you try to parse or
        derive meaning from the response body and instead, should simply pass it directly to the model provider as is.

        We encourage you to seek advise from Vellum Support before integrating with this API for production use.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            The list of inputs defined in the Prompt's deployment with their corresponding values.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        expand_meta : typing.Optional[CompilePromptDeploymentExpandMetaRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeploymentProviderPayloadResponse


        Examples
        --------
        from vellum import StringInputRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.deployments.retrieve_provider_payload(
            inputs=[
                StringInputRequest(
                    name="x",
                    value="value",
                ),
                StringInputRequest(
                    name="x",
                    value="value",
                ),
            ],
        )
        """
        _response = self._raw_client.retrieve_provider_payload(
            inputs=inputs,
            deployment_id=deployment_id,
            deployment_name=deployment_name,
            release_tag=release_tag,
            expand_meta=expand_meta,
            request_options=request_options,
        )
        return _response.data


class AsyncDeploymentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDeploymentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDeploymentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDeploymentsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        status: typing.Optional[DeploymentsListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedSlimDeploymentReadList:
        """
        Used to list all Prompt Deployments.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        status : typing.Optional[DeploymentsListRequestStatus]
            status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedSlimDeploymentReadList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.deployments.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            limit=limit, offset=offset, ordering=ordering, status=status, request_options=request_options
        )
        return _response.data

    async def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DeploymentRead:
        """
        Used to retrieve a Prompt Deployment given its ID or name.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeploymentRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.deployments.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(id, request_options=request_options)
        return _response.data

    async def deployment_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeploymentHistoryItem:
        """
        DEPRECATED: This endpoint is deprecated and will be removed in a future release. Please use the
        `retrieve_prompt_deployment_release` xendpoint instead.

        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Deployment History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Deployment History Item you'd like to retrieve.

        id : str
            Either the Prompt Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeploymentHistoryItem


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.deployments.deployment_history_item_retrieve(
                history_id_or_release_tag="history_id_or_release_tag",
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deployment_history_item_retrieve(
            history_id_or_release_tag, id, request_options=request_options
        )
        return _response.data

    async def list_deployment_release_tags(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        source: typing.Optional[ListDeploymentReleaseTagsRequestSource] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedDeploymentReleaseTagReadList:
        """
        List Release Tags associated with the specified Prompt Deployment

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        source : typing.Optional[ListDeploymentReleaseTagsRequestSource]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedDeploymentReleaseTagReadList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.deployments.list_deployment_release_tags(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_deployment_release_tags(
            id, limit=limit, offset=offset, ordering=ordering, source=source, request_options=request_options
        )
        return _response.data

    async def retrieve_deployment_release_tag(
        self, id: str, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeploymentReleaseTagRead:
        """
        Retrieve a Deployment Release Tag by tag name, associated with a specified Deployment.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Deployment that you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeploymentReleaseTagRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.deployments.retrieve_deployment_release_tag(
                id="id",
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_deployment_release_tag(id, name, request_options=request_options)
        return _response.data

    async def update_deployment_release_tag(
        self,
        id: str,
        name: str,
        *,
        history_item_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeploymentReleaseTagRead:
        """
        Updates an existing Release Tag associated with the specified Prompt Deployment.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Deployment that you'd like to update.

        history_item_id : typing.Optional[str]
            The ID of the Release to tag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeploymentReleaseTagRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.deployments.update_deployment_release_tag(
                id="id",
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_deployment_release_tag(
            id, name, history_item_id=history_item_id, request_options=request_options
        )
        return _response.data

    async def retrieve_prompt_deployment_release(
        self, id: str, release_id_or_release_tag: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PromptDeploymentRelease:
        """
        Retrieve a specific Prompt Deployment Release by either its UUID or the name of a Release Tag that points to it.

        Parameters
        ----------
        id : str
            Either the Prompt Deployment's ID or its unique name

        release_id_or_release_tag : str
            Either the UUID of Prompt Deployment Release you'd like to retrieve, or the name of a Release Tag that's pointing to the Prompt Deployment Release you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptDeploymentRelease


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.deployments.retrieve_prompt_deployment_release(
                id="id",
                release_id_or_release_tag="release_id_or_release_tag",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_prompt_deployment_release(
            id, release_id_or_release_tag, request_options=request_options
        )
        return _response.data

    async def retrieve_provider_payload(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[CompilePromptDeploymentExpandMetaRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeploymentProviderPayloadResponse:
        """
        Given a set of input variable values, compile the exact payload that Vellum would send to the configured model provider
        for execution if the execute-prompt endpoint had been invoked. Note that this endpoint does not actually execute the
        prompt or make an API call to the model provider.

        This endpoint is useful if you don't want to proxy LLM provider requests through Vellum and prefer to send them directly
        to the provider yourself. Note that no guarantees are made on the format of this API's response schema, other than
        that it will be a valid payload for the configured model provider. It's not recommended that you try to parse or
        derive meaning from the response body and instead, should simply pass it directly to the model provider as is.

        We encourage you to seek advise from Vellum Support before integrating with this API for production use.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            The list of inputs defined in the Prompt's deployment with their corresponding values.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        expand_meta : typing.Optional[CompilePromptDeploymentExpandMetaRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeploymentProviderPayloadResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, StringInputRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.deployments.retrieve_provider_payload(
                inputs=[
                    StringInputRequest(
                        name="x",
                        value="value",
                    ),
                    StringInputRequest(
                        name="x",
                        value="value",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_provider_payload(
            inputs=inputs,
            deployment_id=deployment_id,
            deployment_name=deployment_name,
            release_tag=release_tag,
            expand_meta=expand_meta,
            request_options=request_options,
        )
        return _response.data
